
    document.getElementById('productEditModal').addEventListener('shown.bs.modal', function(event) {
       

        var id_brand = document.getElementById('id_brand') ? document.getElementById('id_brand').value : 0;
        
        var elem = event.relatedTarget;
        var productID = elem.getAttribute('data-product-id');

        document.getElementById('saveProductButton').disabled = true;
        document.getElementById('saveProductSpinner').classList.remove('d-none');

        //fetch product data via Fetch API
        fetch(baseURL + `/products/${productID}/details`)
            .then(response => response.json())
            .then(data => {
                document.getElementById('saveProductButton').disabled = false;
                document.getElementById('saveProductSpinner').classList.add('d-none');
                //fill modal fields with data
                $('#productID').val(data.id_business_products);
                $('#productName').val(data.product);
                $('#productPrice').val(data.price);
                $('#productPurchase').val(data.purchase_price);
                $('#productTax').val(data.product_sales_tax);
                $('#productBrand').val(data.brand_id ?? id_brand).trigger('change');
                $('#productCategory').val(data.category);
                $('#productTrackInventory').val(data.track_inventory ?? 'Yes');
                $('#productUnitType').val(data.unit_type);
                $('#productQtyPerUnit').val(data.qty_per_unit);
                $('#productMeasureUnit').val(data.measure_unit);
                $('#productSKU').val(data.sku);
                $('#productBarCode').val(data.barcode_products);
                $('#productCommissionType').val(data.commission_type ?? 'Percentage');
                $('#productCommission').val(data.commission ?? 0);
                $('#productProfessional').val(data.professional ?? 'n');
                $('#productActive').val(data.business_product_active ?? 'Yes');
                $('#productThreshold').val(data.product_threshold ?? 0);
                $('#productType').val(data.product_type ?? 'Physical');

            })
            .catch(error => {
                document.getElementById('saveProductButton').disabled = false;
                document.getElementById('saveProductSpinner').classList.add('d-none');

                toastr.error('Error fetching product details:', error);
            });
    });
    
    document.getElementById('productEditForm').addEventListener('submit', function(event) {
        event.preventDefault();
        // Handle form submission logic here
        //Get form data
        var formData = new FormData(this);
        console.log(Object.fromEntries(formData.entries()));

        document.getElementById('saveProductButton').disabled = true;
        document.getElementById('saveProductSpinner').classList.remove('d-none');

        //Send data via Fetch API
        fetch(baseURL + '/products/save_product', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById('saveProductButton').disabled = false;
            document.getElementById('saveProductSpinner').classList.add('d-none');

            if (data.success) {
                toastr.success('Product updated successfully');
                // Optionally, refresh the product list or perform other actions
                location.reload();
            } else {
                toastr.error('Error updating product:', data.message);
            }
        })
        .catch(error => {
            document.getElementById('saveProductButton').disabled = false;
            document.getElementById('saveProductSpinner').classList.add('d-none');
            toastr.error('Error updating product:', error);
        });

    });

    document.getElementById('productEditModal').addEventListener('hide.bs.modal', function(event) {
        // Reset form fields when modal is closed
        $("#productEditForm")[0].reset();
        // getElementById('productID').value = '';
        // getElementById('productName').value = '';
        // getElementById('productPrice').value = '';
        // getElementById('productPurchase').value = '';
        // getElementById('productTax').value = '';
        // getElementById('productBrand').value = '';
        // getElementById('productCategory').value = '';
        // getElementById('productTrackInventory').value = '';
        // getElementById('productUnitType').value = '';
        // getElementById('productQtyPerUnit').value = '';
        // getElementById('productMeasureUnit').value = '';
        // getElementById('productSKU').value = '';
        // getElementById('productBarCode').value = '';
        // getElementById('productCommissionType').value = '';
        // getElementById('productCommission').value = '';
        // getElementById('productProfessional').value = '';
        // getElementById('productActive').value = '';
        // getElementById('productThreshold').value = '';

    });