    document.getElementById('transferStockModal').addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
       
        var productID = button.getAttribute('data-dt-productID');
        var productName = button.getAttribute('data-dt-productname');
        var batchID = button.getAttribute('data-dt-batchID');
        var storeFrom = button.getAttribute('data-dt-storeFrom');
        var remainingQty = button.getAttribute('data-dt-remaining');
       //console.log(productID);
        if(storeFrom !=''){
            $('#transfer_store_from').val(storeFrom);
            $('#transfer_store_from').prop('disabled', true);
            $("#transferStockButton").prop('disabled', false);
            document.getElementById('transferStockSpinner').classList.add('d-none');
            $("#transferproductID").val(productID);
        } else {
            $('#transfer_store_from').prop('disabled', false);
            $("#transferproductID").val(productID);
        }
        $("#transferProductName").text(productName);

        $('#available_quantity').val(remainingQty);
        $('#transfer_quantity').val(0);

        // Set modal fields
        // Use productID and batchID as needed

        // Handle transfer button click
        $('#transferStockButton').off('click').on('click', function () {
            var transferToStore = $('#transfer_store').val();
            var transferQuantity = parseInt($('#transfer_quantity').val());
            console.log(remainingQty);
            // transferStockButton disabled to prevent multiple clicks
            $('#transferStockButton').prop('disabled', true);
            document.getElementById('transferStockSpinner').classList.remove('d-none');
            if(transferQuantity > 0 && transferQuantity <= parseInt(remainingQty)){
                // Perform the transfer via AJAX
                $.ajax({
                    url: baseURL + "/products/transfer_product_stock",
                    method: 'POST',
                    data: {
                        product_id: productID,
                        batch_id: batchID ?? '',
                        from_store_id: storeFrom,
                        to_store_id: transferToStore,
                        transfer_qty: transferQuantity,
                        _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content') 
                    },
                    success: function(response) {
                        $('#transferStockButton').prop('disabled', false);
                        document.getElementById('transferStockSpinner').classList.add('d-none');
                        if(response.success){
                            toastr.success(response.message);
                            location.reload();
                        } else {
                            toastr.error(response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        $('#transferStockButton').prop('disabled', false);
                        document.getElementById('transferStockSpinner').classList.add('d-none');
                        toastr.error('An error occurred while transferring stock.');
                    }
                });
            } else {
                $('#transferStockButton').prop('disabled', false);
                document.getElementById('transferStockSpinner').classList.add('d-none');
                toastr.error('Please enter a valid transfer quantity.');
            }
        });

        //bind change event to update max transfer quantity
        $('#transfer_store_from').off('change').on('change', function() {
            
            $('#transferStockButton').prop('disabled', true);
            document.getElementById('transferStockSpinner').classList.remove('d-none');

            var selectedStore = $(this).val();
            //Fetch available quantity for selected store via Fetch
            fetch(baseURL + '/products/fetch_store_stock?product_id=' + productID + '&store_id=' + selectedStore, {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            .then(response => response.json())
            .then(data => {
                //enable transfer button if fetch is successful
                $('#transferStockButton').prop('disabled', false);
                document.getElementById('transferStockSpinner').classList.add('d-none');
                if(data.message_type === 'success'){
                    $('#available_quantity').val(data.available_quantity);
                    $('#transfer_quantity').val(0);
                    remainingQty = data.available_quantity;
                    storeFrom = selectedStore;
                    $('#transferStockButton').prop('disabled', false);
                    document.getElementById('transferStockSpinner').classList.add('d-none');
                } else {
                    toastr.error('Failed to fetch available quantity.');
                }
            })
            .catch(error => {
                $('#transferStockButton').prop('disabled', false);
                document.getElementById('transferStockSpinner').classList.add('d-none');
                toastr.error('An error occurred while fetching available quantity.');
            });
        });

    });

    document.getElementById('transferStockModal').addEventListener('hidden.bs.modal', function (event) {
        // Reset modal fields
        $('#transfer_store_from').prop('selectedIndex',0);
        $('#transfer_store_from').prop('disabled', true);
        $('#transfer_store').prop('selectedIndex',0);
        $('#transfer_quantity').val(0);
        $('#available_quantity').val(0);
        $("#transferProductName").text("");
        $('#transferProductID').val("");

    });