@extends('layouts.horizontal', ['title' => 'Account Voucher', 'topbarTitle' => 'Account Voucher', 'nonav' => true])
@section('styles')
<style>
@media print {
  html[data-layout=topnav] .topnav {
    position: static !important;
    box-shadow: none !important;
    border: none !important;
    background: transparent !important;
  }
}
</style>
@endsection
@section('content')

@can('view-Account_Vouchers')

<div class="container-fluid">
    <div class="row fs-13">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-1">
                        <div class="col-1 text-start">                           
                        </div>
                        <div class="col-4">
                            <img src="{{ asset('images/business/' . $account_voucher->business_logo) }}" alt="Business Logo" style="max-height: 72px;">
                        </div>
                        <div class="col-3 text-end">
                            
                        </div>
                        <div class="col-4 text-end">
                            <h3 class="text-decoration-underline">{{ $account_voucher->account_voucher_type }}</h3>
                            <table class="table table-sm no-wrap">
                                <tbody>
                                <tr>
                                    <td class="text-start">Branch</td>
                                    <td>{{ $account_voucher->business->business_name }}</td>
                                </tr>
                                <tr>
                                    <td class="text-start">Voucher Date</td>
                                    <td>{{ $account_voucher->voucher_date }}</td>
                                </tr>
                                <tr>
                                    <td class="text-start">Voucher No</td>
                                    <td>{{ $account_voucher->id_account_vouchers }}</td>
                                </tr>
                                </tbody>
                            </table>
                           
                        </div>
                    </div>
                    <div class="row mb-1">
                        <div class="col-1"></div>
                        <div class="col-11">
                            <table class="table table-borderless table-sm">
                                <tbody>
                                    <tr>
                                        <td style="width: 20%;" class="text-start">
                                            @if($account_voucher->account_voucher_type == 'Payment Voucher')
                                            <strong>PAYMENT MADE TO:</strong>
                                             @elseif($account_voucher->account_voucher_type == 'Receive Voucher')
                                            <strong>PAYMENT RECEIVED FROM:</strong>
                                            @else
                                            <strong>TRANSACTION WITH:</strong>
                                            @endif
                                        </td>
                                        <td class="text-start"><span class="text-decoration-underline">{{ $account_voucher->business_partner_name }}</span></td>
                                    </tr>
                                    <tr>
                                        <td style="width:20%" class="text-start"><strong>ON ACCOUNT OF:</strong></td>
                                        <td class="text-start"><span class="text-decoration-underline">{{ $account_voucher->description }}</span></td>
                                    </tr>
                                </tbody>
                            </table>                            
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-1"></div>
                        <div class="col-11">
                            <table class="table table-bordered table-sm fs-13">
                                <thead>
                                    <tr>
                                        <th class="text-center" style="width: 5%;">Tran.#</th>
                                        <th class="text-start" style="width: 10%;">Folio/Code</th>
                                        <th class="text-start" style="width: 25%;">Head Name</th>
                                        <th class="text-start" style="width: 30%;">Remarks</th>
                                        <th class="text-center" style="width: 10%;">Inst.#</th>
                                        <th class="text-end" style="width: 10%;">Debit ({{ config('constants.CURRENCY') }})</th>
                                        <th class="text-end" style="width: 10%;">Credit ({{ config('constants.CURRENCY') }})</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $debit_total = 0; $credit_total = 0; @endphp
                                    @foreach($details as $detail)
                                    <tr>
                                        <td class="text-center">{{ $detail->id_account_voucher_detail }}</td>
                                        <td class="text-start">{{ $detail->account_hierarchy }}</td>
                                        <td class="text-start">{{ $detail->account_head }}</td>
                                        <td class="text-start">{{ $detail->detail_remarks }}</td>
                                        <td class="text-center">{{ $detail->instrument_number }}</td>
                                        <td class="text-end">{{ number_format($detail->debit, 2) }}</td>
                                        <td class="text-end">{{ number_format($detail->credit, 2) }}</td>
                                        @php 
                                            $debit_total += $detail->debit; 
                                            $credit_total += $detail->credit;
                                        @endphp
                                    </tr>
                                    @endforeach
                                    <tfoot>
                                        <tr>
                                            <th colspan="5" class="text-end">Total</th>
                                            <th class="text-end">{{ number_format($debit_total, 2) }}</th>
                                            <th class="text-end">{{ number_format($credit_total, 2) }}</th>
                                        </tr>
                                    </tfoot>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="row mt-5">
                        <div class="col-3 text-center">
                            <p class="mb-3">-----------------------------</p>
                            <p>Prepared By</p>
                        </div>
                        <div class="col-3 text-center">
                            <p class="mb-3">-----------------------------</p>
                            <p>Checked By</p>
                        </div>
                        <div class="col-3 text-center">    
                            <p class="mb-3">-----------------------------</p>                            
                            <p>Authorized By</p>
                                                    
                        </div>
                        <div class="col-3 text-center">
                            <p class="mb-3">-----------------------------</p>
                            <p>Received/Paid By</p>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-end d-print-none">
                    <button class="btn btn-primary" onclick="cleanPrint();">
                        <iconify-icon icon="ri:printer-fill" class="fs-20"></iconify-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
@else
    <h1>{{config('permission.not_allowed')}}</h1>
@endcan
@endsection
@section('scripts')
<script>

        function cleanPrint() {
            // Create a temporary <style> for print mode
            const style = document.createElement('style');
            style.textContent = `
                @media print {
                html[data-layout=topnav] .topnav {
                    position: static !important;
                    box-shadow: none !important;
                    border: none !important;
                    background: transparent !important;
                }
                }
            `;
            document.head.appendChild(style);

            // Give the browser one frame to apply styles before printing
            setTimeout(() => {
                window.print();
                // Remove after print
                style.remove();
            }, 100);
        }
</script>
@endsection