@extends('layouts.horizontal', ['title' => 'Account Vouchers', 'topbarTitle' => 'Account Vouchers'])

@section('css')

@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     tr.border-top > td {border-top: 2px solid #000 !important;}
</style>

<div class="trail-balance-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Account Vouchers</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
     <div class="card">
        <div class="card-body">
            <div class="row mb-1">                
                <div class="row">
                    <div class="col-12">


                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="card-title mb-2">Filters :</h4>
                            <div class="d-flex align-items-center gap-2">
                                <button onclick="showadvancefilter();" class="btn btn-outline-warning btn-sm" >Switch Filter <i class="ri-arrow-down-fill"></i></button>
                                @can('create-Account_Vouchers')
                                    <a href="{{ route('accounts.open_create_voucher') }}" target="_voucher" class="btn btn-outline-success btn-sm">
                                        <iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon>
                                        Create Voucher
                                    </a>
                                @endcan
                            </div>
                        </div>

                        <div class="row g-3 mb-2 d-none" id="AdvanceFilter">
                            <div class="col-md-4">
                                <label class="form-label">Select Reference Type:</label>
                                <select id="reftype" name="reftype" class="form-control">
                                    <option value="id_account_vouchers">Account Voucher ID</option>
                                    <option value="account_voucher_number">Account Voucher Number</option>
                                    <option value="invoice_id">Invoice ID</option>
                                    <option value="visit_id">Customer Visit ID</option>
                                    <option value="visit_advance_id">Visit Advance ID</option>
                                    <option value="business_partner_id">Customer ID</option>
                                    <option value="cashregister_id">Cash Register ID</option>
                                    <option value="staffpayment_id">Staff Payment Note ID</option>
                                    <option value="purchase_order_id">Purchase Order ID</option>
                                    <option value="grn_id">GRN ID</option>
                                    <option value="dispatch_id">Dispatch Note ID</option>
                                    <option value="return_note_id">Return Note ID</option>
                                    <option value="adjustment_id">Adjustment Note ID</option>
                                    <option value="gtn_id">Goods Transfer Note ID</option>
                                    <option value="order_voucher_id">Gift Voucher ID</option>
                                    <option value="franchise_order_id">Franchise Order ID</option>
                                    <option value="program_invoice_id">Program Invoice ID</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Enter Reference ID</label>
                                <input class="form-control numeric" id="refid" name="refid" required="required">
                            </div>

                            <div class="col-sm-1 align-self-end">
                                <button type="button" class="btn btn-ghost-success btn-icon rounded-circle p-3" id="advance_filter_btn_refresh_table">
                                    <iconify-icon icon="mdi:magnify" width="30px"></iconify-icon>
                                </button>
                                <div id="advanceloaderRun"></div>
                            </div>
                        </div>
            
                        <div class="row g-3 mb-2" id="normalFilter">
                            <div class="col-sm-2">
                                <label for="business" class="form-label">Business</label>
                                <select class="form-select" id="business" name="business"> 
                                    @foreach($businesses as $business)
                                    <option value="{{ $business->id_business }}" {{ $business->id_business == session('business_id') ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                    @endforeach
                                    @if(session('ho') =='Yes')
                                        <option value="0">All Branches</option>
                                    @endif
                                </select>
                            </div> 
                            <div class="col-sm-2">
                                <label for="from_date" class="form-label">From Date</label>
                                <input type="date" class="form-control" id="from_date" name="from_date" value="{{ date('Y-m-d') }}">
                            </div>
                            <div class="col-sm-2">
                                <label for="to_date" class="form-label">To Date</label>
                                <input type="date" class="form-control" id="to_date" name="to_date" value="{{ date('Y-m-t') }}">
                            </div>
                            <div class="col-sm-2">
                                <label for="voucher_type" class="form-label">Voucher Type</label>
                                <select class="form-select" id="voucher_type" name="voucher_type">
                                    <option value="0">All Types</option>
                                    <option value="1">Payment Voucher</option>
                                    <option value="2">Receive Voucher</option>
                                    <option value="3">Journal Voucher</option>
                                    <option value="4">Transfer Voucher</option>
                                </select>
                            </div>
                            <div class="col-sm-2">
                                <label for="auto_voucher" class="form-label">Auto Voucher</label>
                                <select class="form-select" id="auto_voucher" name="auto_voucher">  
                                    <option value="" selected>All</option>                                          
                                    <option value="Yes">Yes</option>
                                    <option value="No">No</option>
                                </select>
                            </div>

                            <div class="col-sm-1 align-self-end">
                                
                                <button type="button" class="btn btn-ghost-success btn-icon rounded-circle p-3" id="btn_refresh_table">
                                    <iconify-icon icon="mdi:magnify" width="30px"></iconify-icon>
                                </button>
                                <div id="loaderRun"></div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card"> 
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-centered mb-0 fs-12" id="voucher_table">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 5%;">#</th>
                            <th style="width: 5%;">Type</th>
                            <th style="width: 10%;">Date</th>
                            <th style="width: 10%;">Created Date</th>
                            <th style="width: 30%;">Description</th>
                            <th style="width: 10%;">Branch</th>
                            <th style="width: 10%;">Business Partner</th>
                            <th style="width: 10%;">Created By</th>
                            <th style="width: 20%;">Account Head</th>
                            <th style="width: 10%;">Total Debit</th>
                            <th style="width: 10%;">Total Credit</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="voucher_table_body">
                        
                    </tbody>
                    <tfoot class="table-light">
                        <tr>
                            <th colspan="9" style="text-align: right;">Total :</th>
                            <th style="text-align: right;" id="total_debit"></th>
                            <th style="text-align: right;" id="total_credit"></th>
                            <th></th>
                        </tr>
                </table>
            </div> <!-- end table-responsive-->
        </div> <!-- end card-body-->
    </div> <!-- end card-->
</div>
@endsection

@section('scripts')
<script> 
    let baseURL = "{{ url('/') }}";
    let can_delete_Account_Vouchers = "{{ auth()->user()->can('delete-Account_Vouchers') }}";
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize DataTable with server-side processing
        let lastVoucherId = null; // track last ID per page draw

        var table = $('#voucher_table').DataTable({
                processing: true,
                serverSide: true,
                searching: true,
                ordering: false,
                stateSave: true,
                pageLength: 10,
                layout: {
                    topStart: "buttons",
                    topEnd: "search",
                    bottomStart: {                 // page length selector
                        pageLength: {
                            menu: [[10, 25, 50, 100, 500], [10, 25, 50, 100, 500]]
                        },
                        info: {}
                    },                
                    bottomEnd: "paging"       // pagination
                },
                ajax: {
                    url: "{{ route('accounts.account_vouchers') }}",
                    type: "GET",
                    data: function (d) {
                        d.business_id = document.getElementById('business').value;
                        d.start_date = document.getElementById('from_date').value;
                        d.end_date = document.getElementById('to_date').value;
                        d.voucher_type = document.getElementById('voucher_type').value;
                        d.auto_voucher = document.getElementById('auto_voucher').value;
                        d.reftype = document.getElementById('reftype').value;
                        d.refid = document.getElementById('refid').value;
                    },
                    dataSrc: function(json) {
                        // ✅ Check if the API returned an error or message instead of data
                        if (json.message) {    
                            // Return an empty array so DataTables won’t break
                            return [];
                           
                        }

                        // ✅ Return actual data for DataTables
                        return json.data || json; 
                    },
                    error: function(xhr, status, error) {
                        // ✅ Network or server error
                        $('#voucher-error').html(`<div class="alert alert-danger">Error loading data: ${error}</div>`).show();
                    }
                },
                buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
                columns: [
                    { data: 'id_account_vouchers', name: 'id_account_vouchers' },
                    { data: 'voucher_type', name: 'voucher_type' },
                    { data: 'voucher_date', name: 'voucher_date' },
                    { data: 'created_on', name: 'created_on' },
                    { data: 'description', name: 'description' },
                    { data: 'business_name', name: 'business_name' },
                    { data: 'business_partner_name', name: 'business_partner_name' },
                    { data: 'created_by', name: 'created_by' },
                    { data: 'account_head', name: 'account_head' },
                    {
                        data: 'total_debit',
                        name: 'total_debit',
                        className: 'text-end',
                        render: function (data) {
                            return parseFloat(data || 0)
                                .toFixed(2)
                                .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        }
                    },
                    {
                        data: 'total_credit',
                        name: 'total_credit',
                        className: 'text-end',
                        render: function (data) {
                            return parseFloat(data || 0)
                                .toFixed(2)
                                .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        }
                    },
                    {
                        data: null,
                        orderable: false,
                        searchable: false,
                        className: 'text-center',
                        render: function (data, type, row) {
                            let viewUrl = baseURL + "/accounts/account_voucher_print?id=" + row.id_account_vouchers;
                            let editUrl = baseURL + "/accounts/open_edit_voucher/" + row.id_account_vouchers;
                            let hideClass = row.auto_voucher == 'Yes' ? 'd-none' : '';
                            var actionButtons = '';

                            if(row.user_role=="Super User"){

                                actionButtons = `<a href="${viewUrl}" target="voucherprint" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success open-btn"><iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon></a>
                                <a href="${editUrl}" target="_blank" class=" btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn"><iconify-icon icon="line-md:edit" class="fs-20"></iconify-icon></a>`;

                                if(can_delete_Account_Vouchers){
                                    actionButtons += `<button onclick="cancelVoucher(${row.id_account_vouchers})" class="  btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button>`;
                                }

                                return actionButtons;

                            } else if(row.user_role=="Super Admin"){ 

                                actionButtons = `<a href="${viewUrl}" target="voucherprint" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success open-btn"><iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon></a>
                                <a href="${editUrl}" target="_blank"  class=" ${hideClass} btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn"><iconify-icon icon="line-md:edit" class="fs-20"></iconify-icon></a>`;

                                if(can_delete_Account_Vouchers){
                                    actionButtons += `<button onclick="cancelVoucher(${row.id_account_vouchers})" class="${hideClass}  btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button>`;
                                }

                                return actionButtons;

                            }  else if((row.user_role=="Admin" || row.user_role=="Accountant") && row.auto_voucher=="No"){

                                actionButtons = `<a href="${viewUrl}" target="voucherprint" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success open-btn"><iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon></a>
                                <a href="${editUrl}" target="_blank" target="voucherprint"  class=" ${hideClass} btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn ${hideClass}"><iconify-icon icon="line-md:edit" class="fs-20"></iconify-icon></a>`;

                                if(can_delete_Account_Vouchers){
                                    actionButtons += `<button onclick="cancelVoucher(${row.id_account_vouchers})" class=" ${hideClass} btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button>`;
                                }

                                return actionButtons;
                            } else {
                                return `<a href="${viewUrl}" target="voucherprint" class="link-success me-2"><iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon></a>`;
                            }
                        }
                    }
                ],
                rowCallback: function (row, data, displayIndex, displayIndexFull) {
                    // If same voucher ID as last row, blank out redundant columns
                    if (lastVoucherId === data.id_account_vouchers) {
                        $('td:eq(0)', row).html(''); // id_account_vouchers
                        $('td:eq(1)', row).html(''); // voucher_type
                        $('td:eq(2)', row).html(''); // voucher_date
                        $('td:eq(3)', row).html(''); // created_on
                        $('td:eq(4)', row).html(''); // description
                        $('td:eq(5)', row).html(''); // business
                        $('td:eq(6)', row).html(''); // partner
                         $('td:eq(7)', row).html(''); // created by - 
                        //$('td:eq(8)', row).html(''); //  - account_head 
                        //  $('td:eq(9)', row).html(''); // total_debit - keep
                        //  $('td:eq(10)', row).html(''); // total_credit - keep
                         $('td:eq(11)', row).html(''); // action - keep

                        
                    } else {
                         $(row).addClass('border-top');
                        lastVoucherId = data.id_account_vouchers;
                    }

                    // Strike-through cancelled vouchers
                    if (data.voucher_status !== 'Active') {
                        $(row).addClass('strike-through');
                    }
                },
                preDrawCallback: function(settings) {
                    // Reset the lastVoucherId before rendering a new page
                     lastVoucherId = null;
                },
                drawCallback: function(settings) {
                    const json = this.api().ajax.json();
                    if (json && json.totals) {
                        document.getElementById('total_debit').innerText = parseFloat(json.totals.debit)
                            .toFixed(2)
                            .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        document.getElementById('total_credit').innerText = parseFloat(json.totals.credit)
                            .toFixed(2)
                            .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    }
                }
            });


        $('#btn_refresh_table, #advance_filter_btn_refresh_table').click(function () {
            let btn = $(this);  // <-- store button

            $("#advanceloaderRun").html(`<span class="spinner-border text-success mt-3 fs-12" role="status" aria-hidden="true"></span>`)
            $("#loaderRun").html(`<span class="spinner-border text-success mt-3 fs-12" role="status" aria-hidden="true"></span>`)
            // btn.html(`Loading...`);
            btn.addClass("d-none");
            btn.prop("disabled", true);

            table.ajax.reload(function () {
                btn.removeClass("d-none");
                // btn.html(`<iconify-icon icon="mdi:magnify" width="30px"></iconify-icon>`);
                btn.prop("disabled", false);
                $("#advanceloaderRun").html(``);
                $("#loaderRun").html(``);
            });
        });

    });

    // Fetch and display account vouchers based on filters
    function account_vouchers() {
        // Validate date inputs
        var fromDate = document.getElementById('from_date').value;
        var toDate = document.getElementById('to_date').value;

        if (fromDate && toDate && fromDate > toDate) {
            alert('From Date cannot be later than To Date.');
            return;
        }
        // Fetch data from server
        // Clear existing table data
        document.getElementById('voucher_table_body').innerHTML = '';
        document.getElementById('total_debit').innerText = '';
        document.getElementById('total_credit').innerText = '';
        
        //Refresh datatable voucher_table
        if ($.fn.DataTable.isDataTable('#voucher_table')) {
            $('#voucher_table').DataTable().destroy();
        }
        document.getElementById('voucher_table_body').innerHTML = '<tr><td colspan="10" style="text-align: center;">Loading...</td></tr>';
        // Call the function to fetch and display data
        setTimeout(fetchAccountVouchers, 500); // Slight delay for better UX        

    }

    function cancelVoucher(id) {
        Swal.fire({
            title: 'Enter the reason for cancellation:',
            input: 'text',
            inputPlaceholder: 'Enter reason here...',
            icon: 'warning',
            showCancelButton: true,
            
            confirmButtonText: 'Cancel Voucher',
           
            cancelButtonText: 'Close',
            customClass: {
                confirmButton: "btn btn-danger me-2", // Apply your custom classes
                cancelButton: "btn btn-warning" // Apply your custom classes
            },
            buttonsStyling: false,
            inputValidator: (value) => {
                if (!value) {
                    return 'You need to write something!'
                }
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // Proceed with cancellation
                sendCancelRequest(id, result.value);
            }
        });
    }

    function sendCancelRequest(id, reason) {
        var url = "{{ route('accounts.cancel_voucher') }}"; // Adjust URL as needed
        $.ajax({
            url: url,
            type: 'POST',
                data: {
                    id_account_vouchers: id,
                    business_id: document.getElementById('business').value,
                    reason: reason,
                    _token: '{{ csrf_token() }}' // Include CSRF token 
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success('Voucher cancelled successfully.');
                        
                        // Refresh the table or remove the cancelled voucher row
                        $('#voucher_table').DataTable().ajax.reload();
                    } else {
                        toastr.error('Error cancelling voucher: ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error('An error occurred while cancelling the voucher.');
                }
            });        
    }
    function showadvancefilter() {
        if ($("#AdvanceFilter").hasClass("d-none")) {
            $("#refid").val('');
            $("#AdvanceFilter").removeClass("d-none");
            $("#normalFilter").addClass("d-none");
        } else {
            $("#AdvanceFilter").addClass("d-none");
            $("#normalFilter").removeClass("d-none");
            $("#refid").val('');
        }
    }
</script>
@endsection