@extends('layouts.horizontal', ['title' => 'Fiscal Year Closing', 'topbarTitle' => 'Fiscal Year Closing']) 
@section('css')
@endsection
@section('content')
<div class="profit-loss-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Fiscal Year Closing</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">Fiscal Year Closing</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>


    {{-------------------->  ALERTS START <--------------------------}}
    @if (session('success'))
    <div class="alert alert-success alert-dismissible d-flex align-items-center border-2 border border-success"
    role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert"
                aria-label="Close"></button>
            <iconify-icon icon="solar:check-read-line-duotone" class="fs-20 me-1"></iconify-icon>
            <div class="lh-1"><strong>Success - </strong> {!! session('success') !!}</div>
        </div>
    @endif
    @if (session('warning'))
        <div class="alert alert-warning alert-dismissible d-flex align-items-center border border-warning"
            role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert"
                aria-label="Close"></button>
            <iconify-icon icon="solar:shield-warning-line-duotone" class="fs-20 me-1"></iconify-icon>
            <div class="lh-1"><strong>Warning - </strong> {!! session('warning') !!}</div>
        </div>
    @endif

    @if (session(key: 'error'))
    <div class="alert alert-danger alert-dismissible d-flex align-items-center border-2 border border-danger"
        role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert"
        aria-label="Close"></button>
        <iconify-icon icon="solar:danger-triangle-bold-duotone" class="fs-20 me-1"></iconify-icon>
        <div class="lh-1"><strong>Error - </strong> {!! session('error') !!} </div>
    </div>
    @endif
    {{-------------------->  ALERTS END <--------------------------}}
    <!-- FILTERS -->
    <form id="accounts_closing_form" method="POST" action="{{route('accounts.accounts_closing')}}">
        @csrf
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Filters </h4>
                        <div>
                            @if(isset($fiscalYearStartFrom['last_closed']))
                            <h4 class="text-primary">Fiscal Year Start From: {{$fiscalYearStartFrom['last_closed']}}</h4>
                            @endif
                        </div>
                    </div>

                    <div class="row g-3">
                        <div class="col-sm-3">
                            <label class="form-label">Business</label>
                            <select class="form-select" id="business" name="selected_business_id">
                               
                                @foreach($businesses as $business)
                                    <option value="{{ $business->id_business }}"
                                        {{ $business->id_business == $business_id_for_voucher ? 'selected' : '' }}>
                                        {{ $business->business_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                         <div class="col-sm-3">
                                <label  class="form-label">Select Closing Month</label>
                                <select class="form-select" id="closing_month" name="closing_month">
                                <option value="">Select Closing Month</option>
                                <?php foreach ($closing_months as $month) { ?>
                                        <option <?php if($closing_month == $month->month){ echo 'selected="selected"';}?> value="<?php echo $month->month; ?>"><?php echo $month->month_name; ?></option>
                                <?php } ?>
                                </select>    
                        </div>   
                         <div class="col-sm-3">
                                <label  class="form-label">Select Closing Year</label>
                                 <?php 
                                        $year = date('Y'); 
                                        $closing_years = [];
                                        for ($x = 0; $x <= 10; $x++) {                                            
                                            $closing_years[] = $year - $x;                           
                                        }
                                        //print_r($closing_years);
                                    ?>

                                <select class="form-select" id="closing_year" name="closing_year">
                                <option value="">Select Closing Year</option>
                                <?php foreach ($closing_years as $year) { ?>
                                            <option <?php if($closing_year == $year){ echo 'selected="selected"';}?> value="<?php echo $year; ?>"><?php echo $year; ?></option>
                                <?php } ?>
                                </select>    
                        </div> 
                        
                        <div class="col-sm-3 align-self-end">
                            <button type="submit" class="btn btn-primary " id="fiscal_year_closing_btn"> Get Closing Accounts</button>
                        </div>
                    </div>
                </div> 
                <div class="card-box-footer ">    
                        <hr>
                        <div class="row ">
                            <div class="col-2">
                            </div>
                            <div class="col-10">
                                <div class="row">

                                <div class="col-6">   
                                        <p class="fs-16 text-danger">When you have viewed the Accounts listed and are sure, click this button to create closing voucher:</p>                                
                                </div>                            
                                <div class="col-2">                                                     
                                    <svg width="80" height="100">
                                        <defs>
                                        <marker id="arrowhead" markerWidth="10" markerHeight="7" 
                                            refX="0" refY="3.5" orient="auto">
                                            <polygon points="0 0, 10 3.5, 0 7" fill="#252631" />
                                        </marker>
                                        </defs>

                                        <line x1="10" y1="20" x2="60" y2="20" stroke="#252631" 
                                        stroke-width="2" marker-end="url(#arrowhead)" />
                                    </svg>
                                </div>
                                <div class="col-4 ">                                
                                    <div class="form-group">
                                        <input class="btn btn-danger"  value="Close Accounts"  type="button" name="close_accounts_btn" id="close_accounts">
                                        <input type="hidden" name="close_accounts" id="close_accounts_hidden">

                                    </div>
                                </div>
                            </div>
                            </div>
                        </div>
                </div>
                
            </div>
        </div>
    </div>
    </form>
    <!-- EXPENSE TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Expense Accounts Closing</h4>
                    </div>
                <?php $sum_credit=0; $sum_debit = 0; ?>
                  <?php if (isset($expense_accounts) && !empty($expense_accounts) && isset($expense_accounts_summary) && !empty($expense_accounts_summary)) { ?>
                    <div class="table-responsive">
                        <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12" id="expenseCLosingTable">
                            <thead class="table-light">
                                <tr class="bg-light">
                                    <th style="width: 15%">ID Account Head</th>
                                    <th style="width: 15%">Account Head #</th>
                                    <th style="width: 15%">Account Head</th>   
                                    <th style="width: 25%">Narration</th>            
                                    <th style="width: 15%">Debit Amount</th>
                                    <th style="width: 15%">Credit Amount</th>
                                </tr>
                            </thead>
                            <tbody id="expenseCLosingTableBody">
                                   <?php foreach ($expense_accounts_summary as $expense_summary) { ?>
                                    <tr>
                                        <td style="width: 15%"><?php echo $retained_account->id_account_heads; ?></td>
                                        <td style="width: 15%"><?php echo $retained_account->account_head_number; ?></td>
                                        <td style="width: 15%"><?php echo $retained_account->account_head; ?></td>
                                        <td style="width: 25%">Retained Earning debited against all EXPENSE accounts durning closing</td>  
                                        <td style="text-align: right;width:15%"><?php echo number_format($expense_summary->balance, 2); $sum_debit = $sum_debit + $expense_summary->balance; ?></td>
                                        <td style="text-align: right;width:15%">0</td>
                                        
                                    </tr>
                                <?php } ?>

                                <?php $expense_balance = 0; foreach ($expense_accounts as $account) { ?>
                                    <tr>
                                        <td style="width: 15%"><?php echo $account->id_account_heads; ?></td>
                                        <td style="width: 15%"><?php echo $account->account_head_number; ?></td>
                                        <td style="width: 15%"><?php echo $account->account_head; ?></td>
                                        <td style="width: 25%">Closing</td>  
                                        <td style="text-align: right;width:15%">0</td>
                                        <td style="text-align: right;width:15%"><?php echo number_format($account->balance, 2); $sum_credit = $sum_credit + $account->balance;?></td>
                                        
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                    <?php } else { ?>
                        <p>No accounts found for the selected month and year.</p>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div> 


    <!-- Revenue TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Revenue Accounts Closing</h4>
                    </div>
                  <?php if (isset($income_accounts) && !empty($income_accounts) && isset($income_accounts_summary) && !empty($income_accounts_summary)) { ?>
                    <div class="table-responsive">
                        <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12" id="revenueCLosingTable">
                            <thead class="table-light">
                                <tr class="bg-light">
                                    <th style="width: 15%">ID Account Head</th>
                                    <th style="width: 15%">Account Head #</th>
                                    <th style="width: 15%">Account Head</th>   
                                    <th style="width: 25%">Narration</th>            
                                    <th style="width: 15%">Debit Amount</th>
                                    <th style="width: 15%">Credit Amount</th>
                                </tr>
                            </thead>
                            <tbody id="revenueCLosingTableBody">
                                 <?php foreach ($income_accounts_summary as $income_summary) { ?>
                                    <tr>
                                        <td style="width: 15%"><?php echo $retained_account->id_account_heads; ?></td>
                                        <td style="width: 15%"><?php echo $retained_account->account_head_number; ?></td>
                                        <td style="width: 15%"><?php echo $retained_account->account_head; ?></td>
                                        <td style="width: 25%">Retained Earning debited against all INCOME accounts durning closing</td>                                          
                                        <td style="text-align: right; width:15%">0</td>
                                        <td style="text-align: right; width:15%"><?php echo number_format($income_summary->balance, 2); $sum_credit = $sum_credit + $income_summary->balance;?></td>
                                        
                                    </tr>
                                <?php } ?>

                                <?php $expense_balance = 0; foreach ($income_accounts as $account) { ?>
                                    <tr>
                                        <td style="width: 15%"><?php echo $account->id_account_heads; ?></td>
                                        <td style="width: 15%"><?php echo $account->account_head_number; ?></td>
                                        <td style="width: 15%"><?php echo $account->account_head; ?></td>
                                        <td style="width: 25%">Closing</td>                                          
                                        <td style="text-align: right; width:15%;"><?php echo number_format($account->balance, 2); $sum_debit = $sum_debit + $account->balance; ?></td>
                                        <td style="text-align: right; width:15%;">0</td>
                                        
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                    <?php } else { ?>
                        <p>No accounts found for the selected month and year.</p>
                    <?php } ?>
                </div>
            </div>
        </div> 
    </div> 


    <!-- GRAND TOTAL TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12" id="revenueCLosingTable">
                            <thead class="table-light">
                                 <tr>
                                    <th style="width: 15%"></th>
                                    <th style="width: 15%"></th>
                                    <th style="width: 15%"></th>   
                                    <th style="width: 25%"></th>            
                                    <th style="text-align: right; width:15%;"><h5>Debit Amount</h5></th>
                                    <th style="text-align: right; width:15%;"><h5>Credit Amount</h5></th>
                               </tr>
                            </thead>
                            <tbody id="revenueCLosingTableBody">
                                <th style="width: 15%"></th>
                                <th style="width: 15%"></th>
                                <th style="width: 15%"></th>
                                <th style="width: 25%"></th>
                                <th style="text-align: right; width:15%"><h5><?php echo $sum_debit;?></h5></th>
                                <th style="text-align: right; width:15%"><h5><?php echo $sum_credit;?></h5></th>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script>
document.addEventListener("DOMContentLoaded", function() {

    document.getElementById("close_accounts").addEventListener("click", function () {

        Swal.fire({
            title: "Are you sure?",
            text: "Are you sure you want to close the accounts till this month?", 
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Yes, Close It",
            cancelButtonText: "Cancel"
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById("close_accounts_hidden").value = "Close Accounts";

                document.getElementById("accounts_closing_form").submit();
            }
        });

    });

});



</script>
@endsection