@extends('layouts.horizontal', ['title' => 'Fiscal Year Closing History', 'topbarTitle' => 'Fiscal Year Closing History']) 
@section('css')
 <style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
 </style>
@endsection
@section('content')
<div class="profit-loss-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Fiscal Year Closing History</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">Fiscal Year Closing History</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    {{-------------------->  ALERTS START <--------------------------}}
    
    @if (session('success'))
    <div class="alert alert-success alert-dismissible d-flex align-items-center border-2 border border-success"
    role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert"
                aria-label="Close"></button>
            <iconify-icon icon="solar:check-read-line-duotone" class="fs-20 me-1"></iconify-icon>
            <div class="lh-1"><strong>Success - </strong> {{ session('success') }}</div>
        </div>
    @endif
    @if (session('warning'))
        <div class="alert alert-warning alert-dismissible d-flex align-items-center border border-warning"
            role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert"
                aria-label="Close"></button>
            <iconify-icon icon="solar:shield-warning-line-duotone" class="fs-20 me-1"></iconify-icon>
            <div class="lh-1"><strong>Warning - </strong> {{ session('warning') }}</div>
        </div>
    @endif

    @if (session(key: 'error'))
    <div class="alert alert-danger alert-dismissible d-flex align-items-center border-2 border border-danger"
        role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert"
        aria-label="Close"></button>
        <iconify-icon icon="solar:danger-triangle-bold-duotone" class="fs-20 me-1"></iconify-icon>
        <div class="lh-1"><strong>Error - </strong> {{ session(key: 'error') }} </div>
    </div>
    @endif
    {{-------------------->  ALERTS END <--------------------------}}
    
    <!-- FILTERS -->
    <form id="accounts_closing_form" method="POST" action="javascript:void(0)">
        @csrf
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Filters </h4>
                        <div>
                            <h4 class="text-primary" id="fiscalYearStartFrom">Fiscal Year Start From </h4>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-sm-3">
                            <label class="form-label">Business</label>
                            <select class="form-select" id="business" name="selected_business_id">
                               
                                @foreach($businesses as $business)
                                    <option value="{{ $business->id_business }}"
                                        {{ $business->id_business == $selected_business_id ? 'selected' : '' }}>
                                        {{ $business->business_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                     
                        
                        <div class="col-sm-3 align-self-end">
                            <button type="button" class="btn btn-primary " id="refreshBtn" onclick="fiscalYearClosingHistory();">Refresh</button>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    </form>
    <!-- EXPENSE TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Fiscal Year Closing History</h4>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12" id="accountCLosingTable">
                            <thead class="table-light">
                                <tr class="bg-light">
                                    <th>ID</th>
                                    <th>Branch</th>
                                    <th>Closed upto</th>
                                    <th>Status</th>
                                    <th>Created By</th>
                                    <th>Cancelled By</th>
                                    <th>Cancellation Reason</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="accountCLosingTableBody">
                               
                            </tbody>
                        </table>
                    </div>
                   
                </div>
            </div>
        </div>
    </div> 

</div>
@endsection

@section('scripts')
<script>
let baseURL = "{{ url('/') }}";
let user_role = @json(session('user_role'));
document.addEventListener("DOMContentLoaded", function() {
    fiscalYearClosingHistory();
});
function fiscalYearClosingHistory() {
    const business_id = document.getElementById("business").value;
    let url = "{{ route('accounts.accounts_closing_history') }}" 
        + `?business_id=${business_id}`;
    $("#refreshBtn").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span> Loading...`);
    fetch(url,{
        method: 'GET',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-Token': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(response => {
        var last_closed =   response.fiscalYearStartFrom.last_closed;
        if(last_closed == null ){
            $("#fiscalYearStartFrom").hide();
        }else{
            $("#fiscalYearStartFrom").show();
            $("#fiscalYearStartFrom").text("Fiscal Year Start From: "+last_closed);
        }


        $("#refreshBtn").html(`Refresh`);
           let tbody = $("#accountCLosingTable tbody");
            tbody.empty(); // clear table first
            if(response.ClosingData.length > 0){
                response.ClosingData.forEach(function(item){
                let viewUrl = baseURL + "/accounts/account_voucher_print?id=" + item.id_account_vouchers;
                var actionButtons ='';
                if(user_role =="Super User" || user_role('user_role') == "Super Admin" ){
                      actionButtons = `<a href="${viewUrl}" target="voucherprint" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success open-btn"><iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon></a>`;
                }  
                if(item.status =="Active"){
                    actionButtons+=`<button onclick="cancelFiscalYearHistory(${item.id},this)" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button>`;
                }
                var strikethrough =''
                if(item.status =="Cancelled"){
                  strikethrough ="strike-through";
                }

                tbody.append(`
                    <tr class="table_tr  ${strikethrough}">
                        <td>${item.id}</td>
                        <td>${item.business_name}</td>
                        <td>${item.closing_date}</td>
                        <td>${item.status}</td>
                        <td>${item.created_by}</td>
                        <td class="cancelledBy">${item.cancelled_by == null ? '' : item.cancelled_by}</td>
                        <td class="cancelled_reason">${item.cancellation_reason == null ? '' : item.cancellation_reason}</td>
                        <td>${actionButtons}</td>
                    </tr>
                `);
                });
            } else {
                tbody.append(`<tr><td colspan="8" class="text-center">No data found</td></tr>`);
            }
    })
    .catch(error => {
        $("#refreshBtn").html(`Refresh`);
        console.error("Error fetching trial balance data:", error);
    });

    table = $('#accountCLosingTable').DataTable({
        destroy: true,
        paging: false,
        searching: true,
        info: false,
        ordering: false,
            "layout": {
            topStart: "buttons",
            topEnd: "search",
            bottomStart: {                 // page length selector
                pageLength: {
                    menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                },
                info: {}
            },                
            
        },
        buttons: [
            { extend: "copy",  className: "btn btn-sm btn-light",
                exportOptions: {
                rows: function (idx, data, node) {
                    return !$(node).hasClass('d-none');
                }
                }
                },
            { extend: "csv",   className: "btn btn-sm btn-light",
                exportOptions: {
                rows: function (idx, data, node) {
                    return !$(node).hasClass('d-none');
                }
                }
                },
            { extend: "print", className: "btn btn-sm btn-light",
                exportOptions: {
                rows: function (idx, data, node) {
                    return !$(node).hasClass('d-none');
                }
                }
                },
            { extend: "pdf", className: "btn btn-sm btn-light",
                exportOptions: {
                rows: function (idx, data, node) {
                    return !$(node).hasClass('d-none');
                }
                }
            }
        ],
    });
} 

    function cancelFiscalYearHistory(id,this_btn) {

        Swal.fire({
            title: 'Enter the reason for cancellation:',
            input: 'text',
            inputPlaceholder: 'Enter reason here...',
            icon: 'warning',
            showCancelButton: true,
            
            confirmButtonText: 'Cancel Closing',
           
            cancelButtonText: 'Close',
            customClass: {
                confirmButton: "btn btn-danger me-2", // Apply your custom classes
                cancelButton: "btn btn-warning" // Apply your custom classes
            },
            buttonsStyling: false,
            inputValidator: (value) => {
                if (!value) {
                    return 'You need to write something!'
                }
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // Proceed with cancellation
                sendCancelRequest(id, result.value,this_btn);
            }
        });
    }

    
    function sendCancelRequest(id, reason,this_btn) {
        var url = "{{ route('accounts.cancel_fiscal_year_closing') }}"; // Adjust URL as needed
        $.ajax({
            url: url,
            type: 'POST',
                data: {
                    id:id,
                    reason: reason,
                    _token: '{{ csrf_token() }}' // Include CSRF token 
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success('Cancelled successfully.');
                        fiscalYearClosingHistory();    

                    } else {
                        toastr.error('Error cancelling : ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error('An error occurred while cancelling');
                }
            });        
    }
</script>
@endsection