@extends('layouts.horizontal', ['title' => 'Balance Sheet', 'topbarTitle' => 'Balance Sheet'])

@section('css')

<style>

</style>

@endsection

@section('content')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h2 class="mb-sm-0">Balance Sheet</h2>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">Balance Sheet</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <!--end page title-->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Filters :</h4>
                        <div class="row g-3">
                            <div class="col-sm-3">
                                <label for="business" class="form-label">Business</label>
                                <select class="form-select" id="business" name="business">
                                  
                                    @foreach($businesses as $business)
                                        <option value="{{ $business->id_business }}" {{ $business->id_business == session('business_id') ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                    @endforeach

                                    @if (session('ho') =="Yes")
                                    <option value="0">All Branches</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-3">
                                <label for="as_on_date_select" class="form-label">As On Date</label>
                                <input type="date" class="form-control" id="as_on_date_select" name="as_on_date" value="{{ date('Y-m-01') }}">
                            </div>                            
                            <div class="col-sm-2 align-self-end">
                                <button type="button" class="btn btn-outline-success" onclick="fetchBalanceSheet()" id="balanceSheetBtn">Refresh</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <!-- end Filters row -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h4 class="card-title mb-0">Balance Sheet</h4>
                                <div>
                                    <button class="btn btn-outline-primary btn-sm" onclick="exportBalanceSheet()">Export to Excel</button>
                                </div>
                            </div>
                            <div id="balance-sheet-view">
                                <table class="table table-bordered w-100 table-sm fs-13" id="balance-sheet-table">
                                    <thead>
                                        <tr>
                                            <th  class="text-start"><span id="business-name">{{ $business_name }}</span></th>
                                            <th  class="text-end">Balance Sheet AS on <span id="as-on-date">{{ $as_on_date }}</span></th>
                                        </tr>
                                      
                                      
                                    </thead>
                                    <tbody>
                                        <tr >
                                            <th class="text-center bg-light" style="width: 50%;">ASSESTS</th>
                                            <th class="text-center bg-light" style="width: 50%;">LIABILITIES</th>
                                        </tr>
                                        <tr>
                                            <td style="vertical-align: top;">
                                                <table class="table table-bordered table-sm w-100" id="assets-table">
                                                    <thead>
                                                        <tr class="bg-light">
                                                            <th>Account Head</th>
                                                            <th class="text-end">Amount ({{ config('constants.CURRENCY') }})</th>
                                                        </tr>
                                                    </thead>
                                                        <tbody>
                                                        @foreach ($account_heads_assest as $main)
                                                            {{-- MAIN LEVEL --}}
                                                            <tr >
                                                                <td class="fw-bold">{{ $main['name'] }}</td>
                                                                <td class="text-end"></td>
                                                            </tr>

                                                            @foreach ($main['children'] as $control)
                                                                {{-- CONTROL LEVEL --}}
                                                                {{-- <tr class="bg-light">
                                                                    <td>&nbsp;&nbsp; <strong>{{ $control['name'] }}</strong></td>
                                                                    <td class="text-end"></td>
                                                                </tr> --}}

                                                                @foreach ($control['children'] as $sub)
                                                                    {{-- SUB CONTROL LEVEL --}}
                                                                    <tr >
                                                                        <td class="fw-bold">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $sub['name'] }}</td>
                                                                        <td class="text-end"></td>
                                                                    </tr>

                                                                    @foreach ($sub['children'] as $head)
                                                                        {{-- HEAD LEVEL --}}
                                                                        <tr>
                                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;—{{ $head['name'] }}</td>
                                                                            <td class="text-end total_{{ $main['id'] }}_{{ $control['id'] }}_{{ $sub['id'] }}_{{ $head['id']  }} amount accountHeadValue">{{ number_format($head['closing_balance'], 2) }}</td>
                                                                        </tr>
                                                                    @endforeach

                                                                    <tr >
                                                                        <td class="fw-bold">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Total for {{ $sub['name'] }}</td>
                                                                        <td class="fw-bold text-end total_{{ $main['id'] }}_{{ $control['id'] }}_{{ $sub['id'] }} amount">0.00</td>
                                                                    </tr>
                                                                @endforeach

                                                                {{-- <tr class="bg-light">
                                                                    <td>&nbsp;&nbsp; <strong>{{ $control['name'] }}</strong></td>
                                                                    <td class="text-end total_{{ $main['id'] }}_{{ $control['id'] }}"></td>
                                                                </tr> --}}
                                                            @endforeach


                                                           <tr  class="bg-light">
                                                                <td class="fw-bold">Total for {{ $main['name'] }}</td>
                                                                <td class=" fw-bold text-end total_{{ $main['id'] }} amount">0.00</td>
                                                            </tr>
                                                        @endforeach

                                                        </tbody>
                                                </table>
                                            </td>
                                            <td style="vertical-align: top;">
                                                
                                                <table class="table table-bordered table-sm w-100" id="liabilities-table">
                                                    <thead>
                                                        <tr class="bg-light">
                                                            <th>Account Head</th>
                                                            <th class="text-end">Amount ({{ config('constants.CURRENCY') }})</th>
                                                        </tr>
                                                    </thead>
                                                   <tbody>
                                                        @foreach ($account_heads_liabilities as $main)
                                                            {{-- MAIN LEVEL --}}
                                                            <tr >
                                                                <td class="fw-bold">  {{ $main['name'] }}</td>
                                                                <td class="text-end"></td>
                                                            </tr>

                                                            @foreach ($main['children'] as $control)
                                                                {{-- CONTROL LEVEL --}}
                                                                {{-- <tr class="bg-light">
                                                                    <td>&nbsp;&nbsp; <strong>{{ $control['name'] }}</strong></td>
                                                                    <td class="text-end"></td>
                                                                </tr> --}}

                                                                @foreach ($control['children'] as $sub)
                                                                    {{-- SUB CONTROL LEVEL --}}
                                                                    <tr >
                                                                        <td class="fw-bold">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $sub['name'] }}</td>
                                                                        <td class="text-end"></td>
                                                                    </tr>

                                                                    @foreach ($sub['children'] as $head)
                                                                        {{-- HEAD LEVEL --}}
                                                                        <tr>
                                                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;—{{ $head['name'] }}</td>
                                                                            <td class="text-end total_{{ $main['id'] }}_{{ $control['id'] }}_{{ $sub['id'] }}_{{ $head['id']  }} amount accountHeadValue">{{ number_format($head['closing_balance'], 2) }}</td>
                                                                        </tr>
                                                                    @endforeach

                                                                    <tr >
                                                                        <td class="fw-bold">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Total for {{ $sub['name'] }}</td>
                                                                        <td class="fw-bold text-end total_{{ $main['id'] }}_{{ $control['id'] }}_{{ $sub['id'] }} amount">0.00</td>
                                                                    </tr>
                                                                @endforeach

                                                                {{-- <tr class="bg-light">
                                                                    <td>&nbsp;&nbsp; <strong>{{ $control['name'] }}</strong></td>
                                                                    <td class="text-end total_{{ $main['id'] }}_{{ $control['id'] }}"></td>
                                                                </tr> --}}
                                                            @endforeach


                                                           <tr class="bg-light">
                                                                <td class="fw-bold">Total for {{ $main['name'] }}</td>
                                                                <td class=" fw-bold text-end total_{{ $main['id'] }} amount">0.00</td>
                                                            </tr>
                                                        @endforeach

                                                         <tr >
                                                                <td class="fw-bold">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Profit and Loss for the period (Net Income)</td>
                                                                <td class=" fw-bold text-end profit_and_loss amount">0.00</td>
                                                         </tr>

                                                          <tr class="bg-light">
                                                                <td class="fw-bold">Liabilities & Equity</td>
                                                                <td class=" fw-bold  totalAmountOfliabilitiesAndAssests text-end">0.00</td>
                                                            </tr>

                                                        </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            fetchBalanceSheet();
        });

         function fetchBalanceSheet() {
            
            $("#liabilities-table tbody tr").each(function () { 
                $(this).find('.amount').text( parseFloat(0.00).toFixed(2));
             });
            $("#assets-table tbody tr").each(function () { 
                $(this).find('.amount').text(parseFloat(0.00).toFixed(2));
             });

         $("#balanceSheetBtn").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span> Loading...`);    
        $.ajax({
            url: "{{ route('accounts.balance_sheet') }}",
            type: "GET",
            data: {
                business_id: $("#business option:selected").val(),
                as_on_date: $("#as_on_date_select").val()
            },
            success: function(response) {
                $("#balanceSheetBtn").html(`Refresh`);
                let liabilities = response.balance_sheet_liabilities;
                let assets = response.balance_sheet_assets;

                let liabilitiesHtml = buildTreeHtml(liabilities);
                let assetsHtml = buildTreeHtml(assets);

                // Calculate totals
                let totalLiabilities = calculateTotal(liabilities);
                let totalAssets = calculateTotal(assets);
                
                var totalValue =0
                      $("#liabilities-table tbody tr").each(function () { 
                      totalValue+=  parseFloat($(this).find('.accountHeadValue').text() || 0);
                });

                // Add totals
                const profitAndLoss = response.profitAndLossAmount || 0;
                $(".profit_and_loss ").text(parseFloat(profitAndLoss || 0).toFixed(2));

                const  totalLiabilitiesAndprofitAndLoss = parseFloat(totalLiabilities+profitAndLoss || 0).toFixed(2);
                $(".totalAmountOfliabilitiesAndAssests").text(parseFloat(totalLiabilitiesAndprofitAndLoss || 0).toFixed(2));
                if(response.as_on_date) {
                    $('#as-on-date').text(response.as_on_date);
                }
                if(response.business_name) {
                    $('#business-name').text(response.business_name);
                } else {
                    $('#business-name').text('All Branches');
                }
            },
            error: function(xhr, status, error) {
                $("#balanceSheetBtn").html(`Refresh`);
                console.error("Error fetching balance sheet:", error);
            }
        });
    } 

      function buildTreeHtml(data) {
        let html = '';
        var mainAccountTotal =0;
        data.forEach(main => {
            // Control categories
            main.children.forEach(control => {
                // Sub-control categories
                control.children.forEach(subControl => {
                    var total_heads_amount =0;
                    subControl.children.forEach(head => {
                        var ids_for_setting_head_value = `.total_${main.id}_${control.id}_${subControl.id}_${head.id}`;
                        $(ids_for_setting_head_value).text(head.closing_balance.toFixed(2));
                        total_heads_amount+=parseFloat(head.closing_balance);
                        mainAccountTotal+= parseFloat(head.closing_balance);
                    });
                    var ids_for_setting_sub_control_value = `.total_${main.id}_${control.id}_${subControl.id}`;
                    $(ids_for_setting_sub_control_value).text(subControl.closing_balance.toFixed(2));
                });
            });
            var ids_for_setting_main_value = `.total_${main.id}`;
            $(ids_for_setting_main_value).text(main.closing_balance.toFixed(2));
        }); 

        return html;
    } 

    function calculateTotal(data) {
        let total = 0;
        data.forEach(main => {
            total += parseFloat(main.closing_balance);
        });
        return total;
    }
    
    </script>

    <script>
function exportBalanceSheet() {

    var tableID = "balance-sheet-table";
    var template = `
@verbatim
<html xmlns:o="urn:schemas-microsoft-com:office:office" 
      xmlns:x="urn:schemas-microsoft-com:office:excel" 
      xmlns="http://www.w3.org/TR/REC-html40">

<head>
<!--[if gte mso 9]>
<xml>
    <x:ExcelWorkbook>
        <x:ExcelWorksheets>
            <x:ExcelWorksheet>
                <x:Name>Balance Sheet</x:Name>
                <x:WorksheetOptions>
                    <x:DisplayGridlines/>
                </x:WorksheetOptions>
            </x:ExcelWorksheet>
        </x:ExcelWorksheets>
    </x:ExcelWorkbook>
</xml>
<![endif]-->
</head>

<body>
<table>{table}</table>
</body>
</html>
@endverbatim`;

    var table = document.getElementById(tableID);

    var ctx = {
        table: table.innerHTML
    };

    var excelFile = "data:application/vnd.ms-excel;base64," +
        btoa(unescape(encodeURIComponent(
            template.replace("{table}", ctx.table)
        )));

    var link = document.createElement("a");

    // Create filename with date
    var d = new Date();
    var datestamp =
        ("0" + d.getDate()).slice(-2) + "-" +
        ("0" + (d.getMonth() + 1)).slice(-2) + "-" +
        d.getFullYear();

    link.download = "Balance-Sheet-" + datestamp + ".xls";
    link.href = excelFile;
    link.click();
}
</script>

@endsection