@extends('layouts.horizontal', ['title' => $account_business_partner->account_business_partner.' Ledger ', 'topbarTitle' => $account_business_partner->account_business_partner.' Ledger ']) 
@section('css')
@vite(['node_modules/choices.js/public/assets/styles/choices.min.css', 'node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection
@section('content')
<div class="profit-loss-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">{{$account_business_partner->account_business_partner.' Ledger '}}</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">{{$account_business_partner->account_business_partner.' Ledger '}}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- FILTERS -->
    <form id="accounts_closing_form" method="POST" action="javascript:void(0)">
        @csrf
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h4 class="card-title mb-0">Filters </h4>
                    </div>
                    <div class="row g-3">
                        <div class="col-sm-2">
                            <label class="form-label">Business</label>
                            <select class="form-select" id="business" name="selected_business_id" onchange="get_business_partner_default_filters();">
                                @foreach($businesses as $business)
                                    <option value="{{ $business->id_business }}"
                                        {{ $business->id_business == $selected_business_id ? 'selected' : '' }}>
                                        {{ $business->business_name }}
                                    </option>
                                @endforeach
                                @if (session('ho') =="Yes")
                                    <option value="0">All Branches</option>
                                @endif
                            </select>
                        </div>
                        <div class="col-md-2">
                             <label class="form-label">Account type</label>
                            <select class='form-control' name='account_type' id='account_type'>
                             <option value="Payable">Payable</option>
                             <option value="Receivable">Receivable</option>
                            </select>                                            
                        </div>
                        <div class="col-2 d-none">
                            <label for="business_partner_type" class="form-label">Business Partner Type</label>
                            <select onchange="onchange_business_partner_type()" class="form-select" id="business_partner_type" name="business_partner_type" required>
                             <option value="{{ $account_business_partner->id_account_business_partner }}">{{ $account_business_partner->account_business_partner }}</option>
                            </select>
                        </div>

                        <div class="col-2 ">
                            <label for="business_partner" class="form-label">{{$account_business_partner->account_business_partner}}</label>
                             <select class="form-select select2" id="business_partner" name="business_partner" placeholder="Enter Business Partner" >                   
                             </select>
                        </div> 

                        <div class="col-md-2">
                            <label for="from_date" class="form-label">From Date</label>
                            <input type="date" class="form-control" id="from_date" name="from_date" value="{{ date('Y-m-d') }}">
                        </div>
                        <div class="col-md-2">
                            <label for="to_date" class="form-label">To Date</label>
                            <input type="date" class="form-control" id="to_date" name="to_date" value="{{ date('Y-m-t') }}">
                        </div>
                     
                        <div class="col-sm-2 align-self-end">
                            <button type="button" class="btn btn-primary " id="btn_refresh_table">Refresh</button>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    </form>
    <!-- EXPENSE TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">{{$account_business_partner->account_business_partner.' Ledger '}}</h4>
                        <div>
                            <h5 class="text-primary" id="account_head_display">Account Head:</h5>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered  dt-responsive w-100 fs-12 table-sm" id="accountBusinessPartnerTable">
                            <thead >
                                <tr>
                                    <th colspan=5 class="text-start" id="businessPartner"></th>                             
                                    <th colspan=5 class="text-end" id="opening_balance_display">Opening Balance: 0.00</th>
                                </tr>
                                <tr>
                                    <th style="width:5%;">Sr.No.</th>
                                    <th style="width:10%;">Branch</th>
                                    <th style="width:8%;">ID Voucher</th>
                                    <th style="width:10%;">Name</th>
                                    <th style="width:8%;">Voucher Date</th>
                                    <th style="width:8%;">Create Date</th>
                                    <th style="width:21%;">Description</th>
                                    <th style="width:10%;">Debit</th>
                                    <th style="width:10%;">Credit</th>
                                    <th style="width:10%;">Balance</th>
                                </tr>
                            </thead>
                            <tbody id="accountBusinessPartnerTableBody">
                            </tbody>
                               <tfoot>
                                <tr>
                                    <th colspan="7" class="text-end" style="width:70%">Totals</th>
                                    <th class="text-end" id="totalDebit" style="width: 10%;">0.00</th>
                                    <th class="text-end" id="totalCredit" style="width: 10%;">0.00</th>
                                    <th class="text-end" id="totalBalance" style="width: 10%;">0.00</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                   
                </div>
            </div>
        </div>
    </div> 

</div>
@endsection

@section('scripts')
<script>
let baseURL = "{{ url('/') }}";
let user_role = @json(session('user_role'));
let accountBusinessPartnerTable = null;
let businessPartnerType =@json($account_business_partner->account_business_partner) || '';
document.addEventListener("DOMContentLoaded", function() {
    $('.select-2').select2({
        width: '100%'
    });
    onchange_business_partner_type();
    getBusinessPartnerTable(); 
    get_business_partner_default_filters();   
    document.getElementById('btn_refresh_table').addEventListener('click', function(btn) { 
        var from_date = document.getElementById('from_date')?.value || 0;
        var to_date = document.getElementById('to_date')?.value || 0;
        var business_partner = document.getElementById('business_partner')?.value || 0;
            if (from_date && to_date) {
            var from = new Date(from_date);
            var to = new Date(to_date);
            var diffTime = Math.abs(to - from); // difference in milliseconds
            var diffYears = diffTime / (1000 * 60 * 60 * 24 * 365); // convert to years

            if (diffYears > 2) {
                Swal.fire({
                    title: 'Warning',
                    text: "You cannot select a date range longer than 2 years.",
                    icon: 'warning'
                });
                return false;
            }
        }


        if (business_partner == 0 || business_partner == "") {
            Swal.fire({
                        title: 'Warning',
                        text: "Please select at least a "+businessPartnerType,
                        icon: 'warning'
                    });
            return false        
        } 


        $("#btn_refresh_table").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>`);
        $("#btn_refresh_table").prop("disabled", true);
        if(accountBusinessPartnerTable){
            accountBusinessPartnerTable.ajax.reload(function() {
                $("#btn_refresh_table").html(`Refresh`);
                $("#btn_refresh_table").prop("disabled", false);
            });
        }
    });
}); 

   function getBusinessPartnerTable() {
        $("#totalDebit").text(parseFloat(0).toFixed(2));
        $("#totalCredit").text(parseFloat(0).toFixed(2));
        $("#totalBalance").text(parseFloat(0).toFixed(2));
        
        var business_partnerText = $("#business_partner option:selected").text();
        $("#businessPartner").text(businessPartnerType + ': ' + business_partnerText);
        accountBusinessPartnerTable = $('#accountBusinessPartnerTable').DataTable({
            processing: true,
            serverSide: false,
            destroy: true,
            autoWidth: false,
            responsive: false,
            scrollY: "500px",  
            scrollX: "auto",  
            scrollCollapse: true,
            ajax: {
                url: "{{ route('accounts.get_business_partner_ledger') }}",
                type: 'GET',
                data: function(d) {
                    return {
                        business_id: document.getElementById('business').value,
                        start_date: document.getElementById('from_date').value,
                        end_date: document.getElementById('to_date').value,
                        account_type: document.getElementById('account_type').value,
                        business_partner_type: document.getElementById('business_partner_type').value,
                        business_partner: document.getElementById('business_partner').value
                    };
                },
                dataSrc: function(json) {
                    if (json.error) {
                        alert(json.error);
                        return [];
                    } else if (json.message) {
                        alert(json.message);
                        return [];
                    }
                    var accountType = document.getElementById('account_type').value;
                    var openingBalance = json.opening_balance || 0;
                    var account_head_name = json.account_head_name || '';
                    var currentBalance = 0;
                    var totalDebit = 0;
                    var totalCredit = 0;

                    $("#opening_balance_display").text("Opening Balance: "+parseFloat(openingBalance).toFixed(2));
                    $("#account_head_display").text("Account Head: "+account_head_name);

                    var processedData = json.business_partner_ledger.map(function(item, index) {
                        totalDebit += parseFloat(item.debit || 0);
                        totalCredit += parseFloat(item.credit || 0);
                        currentBalance +=(parseFloat(item.closing_balance || 0));

                        return {
                            sr_no: index + 1,
                            branch: item.Branch,
                            id_voucher: item.id_account_vouchers,
                            business_partner_name: item.business_partner_name,
                            voucher_date: item.voucher_date,
                            create_date: item.create_date,
                            description: item.description,
                            debit: item.debit,
                            credit: item.credit,
                            balance: currentBalance.toFixed(2)
                        };
                    });



                    $("#totalDebit").text(parseFloat(totalDebit).toFixed(2));
                    $("#totalCredit").text(parseFloat(totalCredit).toFixed(2));
                    $("#totalBalance").text(parseFloat(currentBalance).toFixed(2));
                    
                    // Store totals for footer callback
                    processedData.totals = {
                        totalDebit: totalDebit,
                        totalCredit: totalCredit,
                        closingBalance: currentBalance,
                        openingBalance: openingBalance,
                        accountType: accountType
                    };
                    
                    return processedData;
                }
            },
            "info": false,
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
            },
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-light active" },
                { extend: "csv",   className: "btn btn-sm btn-light" },
                { extend: "print", className: "btn btn-sm btn-light" },
                { extend: "pdf", className: "btn btn-sm btn-light" }
            ],
            columns: [
                { 
                    data: 'sr_no', 
                    width: '5%',
                    title: 'Sr.No.'
                },
                { 
                    data: 'branch', 
                    width: '10%',
                    title: 'Branch'
                },
                { 
                    data: 'id_voucher', 
                    width: '8%',
                    title: 'ID Voucher'
                },
                { 
                    data: 'business_partner_name', 
                    width: '10%',
                    title: 'Name'
                },
                { 
                    data: 'voucher_date', 
                    width: '8%',
                    title: 'Voucher Date'
                },
                { 
                    data: 'create_date', 
                    width: '8%',
                    title: 'Create Date'
                },
                { 
                    data: 'description', 
                    width: '21%',
                    title: 'Description'
                },
                { 
                    data: 'debit', 
                    className: 'text-end', 
                    width: '10%',
                    title: 'Debit',
                    render: function(data, type, row) {
                        return data ? parseFloat(data).toFixed(2) : '0.00';
                    }
                },
                { 
                    data: 'credit', 
                    className: 'text-end', 
                    width: '10%',
                    title: 'Credit',
                    render: function(data, type, row) {
                        return data ? parseFloat(data).toFixed(2) : '0.00';
                    }
                },
                { 
                    data: 'balance', 
                    className: 'text-end', 
                    width: '10%',
                    title: 'Balance',
                    render: function(data, type, row) {
                        return data ? parseFloat(data).toFixed(2) : '0.00';
                    }
                }
            ],
            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {
                // You can add row styling here if needed
            },
            "drawCallback": function(settings) {
                // You can add additional styling or information here
            },
            order: [[0, 'asc']],
            ordering: false,
            sorting: false,
            paging: false        
        });
    }
    
    function onchange_business_partner_type() {
            let mURL = '';
              const type = $('#business_partner_type option:selected').text();
            if (type === "Customers") {
                 mURL = "{{ route('customer_search') }}";
            } else if (type === "Staff") {
                mURL = "{{ route('staff.staff_search') }}";
            } else if (type === "Suppliers") {
                mURL = "{{ route('supplier.supplier_search') }}";
            } else if (type === "Franchise") {
                mURL = "{{ route('franchise.franchise_search') }}";
            } else {
                mURL = "{{ route('business.business_search') }}";
            }
            // Re-initialize Select2 with new URL 
            if(type == "Customers"){
                $('#business_partner').empty(); // Clear previous selections
                initializeBusinessPartnerSelect2(mURL, $('#business_partner_type option:selected').text());
            }
    }   
    function initializeBusinessPartnerSelect2(url, type) {
            $('#business_partner').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.text };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select ' + type ,
                width: '100%'
            });
    } 

   function get_business_partner_default_filters() {
        var business_partner_type = $("#business_partner_type").val() || 0;
        var business_id = $("#business").val() || 0;
        var  business_partner_type_text = $('#business_partner_type option:selected').text();

        $.ajax({
            url: "{{ route('accounts.get-business-partner-default-filters') }}",
            type: 'GET',
            dataType: 'json',
            data:{
                business_partner_type : business_partner_type,
                business_id : business_id
            },
            success: function(response) {

                var staffs     = response.staff;
                var franchises = response.franchises;
                var suppliers  = response.suppliers;
                var businesses = response.businesses;

                // Reset once
                var options = "";

                // Append in priority order
                if (businesses.length > 0) {
                    $(businesses).each(function(i, v){
                        options += `<option value="${v.id}">${v.text}</option>`;
                    });
                }

                if (suppliers.length > 0) {
                    $(suppliers).each(function(i, v){
                        options += `<option value="${v.id}">${v.text}</option>`;
                    });
                }

                if (franchises.length > 0) {
                    $(franchises).each(function(i, v){
                        options += `<option value="${v.id}">${v.text}</option>`;
                    });
                }

                if (staffs.length > 0) {
                    $(staffs).each(function(i, v){
                        options += `<option value="${v.id}">${v.text}</option>`;
                    });
                }

                if(business_partner_type_text !="Customers"){
                    if ($("#business_partner").hasClass("select2-hidden-accessible")) {
                        $("#business_partner").select2("destroy");  
                    }
                    $("#business_partner").html(options);
                    $("#business_partner").select2({   
                        placeholder: "Select Business Partner",
                        allowClear: true,
                        width: "100%"
                    });
                }
                // Example: set to select box

            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
            }
        });
    } 

</script>
@endsection