@extends('layouts.horizontal', ['title' => 'COA', 'topbarTitle' => 'Chart of Accounts'])

@section('css')
@vite([
'node_modules/select2/dist/css/select2.min.css'
])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

<div class="chart_of_accounts">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Chart of Accounts</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Branch : {{ $accounts ? $accounts[0]->business_name : '' }}</h4>
                    
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap mb-0" id="AccountsTable">
                            <thead class="table-light">
                                <tr>
                                    <th>Account Main</th>
                                    <th>Account Control</th>
                                    <th>Account Sub Control</th>
                                    <th>Account Head</th>
                                    <th>Account Number</th>
                                </tr>
                                @can('create-Chart_Of_Accounts')
                                <tr class="d-print-none">
                                    <td ><button class="btn btn-sm btn-primary" id="btnAddMainAccount" onclick="openAddMain();">Add Main +</button></td>
                                    <td ><button class="btn btn-sm btn-primary" id="btnAddControl" onclick="openAddControl();">Add Control +</button></td>
                                    <td ><button class="btn btn-sm btn-primary" id="btnAddSubControl" onclick="openAddSubControl();">Add Sub Control +</button></td>
                                    <td ><button class="btn btn-sm btn-primary" id="btnAddHead" onclick="openAddHead();">Add Head +</button></td>
                                    <td ></td>
                                </tr>
                                @endcan
                            </thead>
                            <tbody>
                                @php $last_id_main = 0; $last_id_control=0; $last_sub_control_id=0; @endphp
                                @foreach($accounts as $account)
                                    <tr>
                                    @if($account->id_account_main != $last_id_main)
                                        @php $last_id_main = $account->id_account_main; @endphp
                                        @php $last_id_control = $account->id_account_control; $last_sub_control_id=0; @endphp
                                        @php $last_sub_control_id = $account->id_account_sub_control; @endphp
                                        <td ds-account-main data-bs-toggle="tooltip" title='ID: {{ $account->id_account_main }}'>{{ $account->account_main_number }} - {{ $account->account_main }} @if(session("user_role")=="Super User") @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditMain({{ $account->id_account_main }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan @endif</td>
                                        <td ds-account-control data-bs-toggle="tooltip" title='ID: {{ $account->id_account_control }}'>{{ $account->account_control_number }} - {{ $account->account_control }} @if(session("user_role")=="Super User" || session("user_role") == "Super Admin") @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditControl({{ $account->id_account_control }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan @endif</td>
                                        <td ds-account-sub-control data-bs-toggle="tooltip" title='ID: {{ $account->id_account_sub_control }}'>{{ $account->account_sub_control_number }} - {{ $account->account_sub_control }} @if(session("user_role")=="Super User" || session("user_role") == "Super Admin") @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditSubControl({{ $account->id_account_sub_control }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan @endif</td>
                                        <td ds-account-head data-bs-toggle="tooltip" title='ID: {{ $account->id_account_heads }}'>{{ $account->account_head_number }} - {{ $account->account_head }} @if(session("user_role")=="Super User" || session("user_role") == "Super Admin") @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditHead({{ $account->id_account_heads }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan @endif</td>
                                        <td ds-account-foot >{{ $account->account_number }}</td>
                                    @else
                                        @if($account->id_account_control != $last_id_control)
                                            @php $last_id_control = $account->id_account_control; $last_sub_control_id=0; @endphp
                                            @php $last_sub_control_id = $account->id_account_sub_control; @endphp
                                            <td ds-account-main ></td>
                                            <td ds-account-control data-bs-toggle="tooltip" title='ID: {{ $account->id_account_control }}'>{{ $account->account_control_number }} - {{ $account->account_control }} @if(session("user_role")=="Super User" || session("user_role") == "Super Admin") @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditControl({{ $account->id_account_control }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan @endif</td>
                                            <td ds-account-sub-control data-bs-toggle="tooltip" title='ID: {{ $account->id_account_sub_control }}'>{{ $account->account_sub_control_number }} - {{ $account->account_sub_control }} @if(session("user_role")=="Super User" || session("user_role") == "Super Admin")@can('edit-Chart_Of_Accounts')<iconify-icon  style='cursor:pointer;' onclick="openEditSubControl({{ $account->id_account_sub_control }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon>@endcan @endif</td>
                                            <td ds-account-head data-bs-toggle="tooltip" title='ID: {{ $account->id_account_heads }}'>{{ $account->account_head_number }} - {{ $account->account_head }} @if(session("user_role")=="Super User" || session("user_role") == "Super Admin") @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditHead({{ $account->id_account_heads }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan @endif</td>
                                            <td ds-account-foot >{{ $account->account_number }}</td>
                                        @else
                                            @if($account->id_account_sub_control != $last_sub_control_id)
                                                @php $last_sub_control_id = $account->id_account_sub_control; @endphp                                
                                                <td ds-account-main></td>
                                                <td ds-account-control></td>    
                                                <td ds-account-sub-control data-bs-toggle="tooltip" title='ID: {{ $account->id_account_sub_control }}'>{{ $account->account_sub_control_number }} - {{ $account->account_sub_control }} @can('edit-Chart_Of_Accounts')<iconify-icon  style='cursor:pointer;' onclick="openEditSubControl({{ $account->id_account_sub_control }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon>@endcan</td>    
                                                <td ds-account-head data-bs-toggle="tooltip" title='ID: {{ $account->id_account_heads }}'>{{ $account->account_head_number }} - {{ $account->account_head }} @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditHead({{ $account->id_account_heads }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon>@endcan</td>
                                                <td ds-account-foot>{{ $account->account_number }}</td>
                                                @else
                                                <td ds-account-main></td>
                                                <td ds-account-control></td>    
                                                <td ds-account-sub-control></td>    
                                                <td ds-account-head data-bs-toggle="tooltip" title='ID: {{ $account->id_account_heads }}'>{{ $account->account_head_number }} - {{ $account->account_head }} @can('edit-Chart_Of_Accounts') <iconify-icon  style='cursor:pointer;' onclick="openEditHead({{ $account->id_account_heads }})" class="fs-20 text-end" icon="line-md:edit-twotone"></iconify-icon> @endcan </td>
                                                <td ds-account-foot >{{ $account->account_number }}</td>
                                                @endif
                                        @endif
                                    @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Edit Main Account Modals --}}
<div class="modal fade" id="editMainAccountModal" tabindex="-1" aria-labelledby="editMainAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editMainAccountModalLabel">Main Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editMainAccountForm" action="javascript:void(0)">
                    @csrf
                    <input type="hidden" id="edit_main_account_id" name="id_account_main">
                    <div class="mb-3">
                        <label for="edit_main_account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" id="edit_main_account_number" name="account_main_number" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_main_account_name" class="form-label">Account Name</label>
                        <input type="text" class="form-control" id="edit_main_account_name" name="account_main" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_main_account_status" class="form-label">Status</label>
                        <select class="form-select" id="edit_main_account_status" name="account_main_status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>                            
                        </select>
                    </div>
                    <button id="btnUpdateMainAccount" onclick="updateMainAccount();" class="btn btn-primary">Save changes</button>
                </form>
            </div>
        </div>
    </div>
</div>

{{-- Edit Main Account Modal End --}}

{{-- Edit Control Account Modals --}}
<div class="modal fade" id="editControlAccountModal" tabindex="-1" aria-labelledby="editControlAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editControlAccountModalLabel">Control Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editControlAccountForm">
                    @csrf
                    <input type="hidden" id="edit_control_account_id" name="id_account_control">
                    <div class="mb-3">
                        <label for="edit_control_account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" id="edit_control_account_number" name="account_control_number" >
                    </div>
                    <div class="mb-3">
                        <label for="edit_control_account_name" class="form-label">Account Name</label>
                        <input type="text" class="form-control" id="edit_control_account_name" name="account_control" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_control_account_main" class="form-label">Main Account</label>
                        <select class="form-select" id="edit_control_account_main" name="account_main_id" required>
                            @foreach($account_main as $main)
                                <option value="{{ $main->id_account_main }}">{{ $main->account_main_number }} - {{ $main->account_main }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="edit_control_account_status" class="form-label">Status</label>
                        <select class="form-select" id="edit_control_account_status" name="account_control_status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>                            
                        </select>
                    </div>
                    <button id="btnUpdateControlAccount" onclick="updateControlAccount();" class="btn btn-primary">Save changes</button>
                </form>
            </div>
        </div>
    </div>
</div>
{{-- Edit Control Account Modal End --}}

{{-- Edit Sub Control Account Modals --}}
<div class="modal fade" id="editSubControlAccountModal" tabindex="-1" aria-labelledby="editSubControlAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editSubControlAccountModalLabel">Sub Control Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editSubControlAccountForm" action="javascript:void(0)">
                    @csrf
                    <input type="hidden" id="edit_sub_control_account_id" name="id_account_sub_control">
                    <div class="mb-3">
                        <label for="edit_sub_control_account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" id="edit_sub_control_account_number" name="account_sub_control_number">
                    </div>
                    <div class="mb-3">
                        <label for="edit_sub_control_account_name" class="form-label">Account Name</label>
                        <input type="text" class="form-control" id="edit_sub_control_account_name" name="account_sub_control_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_sub_control_account_control" class="form-label">Control Account</label>
                        <select class="form-select" id="edit_sub_control_account_control" name="account_control_id" required>
                            @foreach($account_control as $control)
                                <option value="{{ $control->id_account_control }}">{{ $control->account_control_number }} - {{ $control->account_control }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="edit_sub_control_account_status" class="form-label">Status</label>
                        <select class="form-select" id="edit_sub_control_account_status" name="account_sub_control_status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>                            
                        </select>
                    </div>

                    <button id="btnUpdateSubControlAccount" onclick="updateEditSubControl();" class="btn btn-primary">Save changes</button>
                </form>
            </div>
        </div>
    </div>
</div>
{{-- Edit Sub Control Account Modal End --}}

{{-- Edit Head Account Modals --}}
<div class="modal fade" id="editHeadAccountModal" tabindex="-1" aria-labelledby="editHeadAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editHeadAccountModalLabel">Head Account</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editHeadAccountForm">
                    @csrf
                    <input type="hidden" id="edit_head_account_id" name="id_account_heads">
                    <div class="mb-3">
                        <label for="edit_head_account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" id="edit_head_account_number" name="account_head_number">
                    </div>
                    <div class="mb-3">
                        <label for="edit_head_account_name" class="form-label">Account Head Name</label>
                        <input type="text" class="form-control" id="edit_head_account_name" name="account_head" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_head_account_main" class="form-label">Sub Control Account</label>
                        <select class="form-select" id="edit_head_account_main" name="account_sub_control_id" required>
                            @foreach($account_sub_control as $sub_control)
                                <option value="{{ $sub_control->id_account_sub_control }}">{{ $sub_control->account_sub_control_number }} - {{ $sub_control->account_sub_control }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="edit_head_account_name" class="form-label">Account Head Status</label>
                        <select class="form-select" id="edit_head_account_status" name="account_head_status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>

                    <button id="btnUpdateHeadAccount" onclick="updateEditHead();" class="btn btn-primary">Save changes</button>
                </form>
            </div>
        </div>
    </div>
</div>
{{-- Edit Head Account Modal End --}}

@endsection

@section('scripts')

<script>

    document.addEventListener("DOMContentLoaded", function(){
        console.log("Document loaded");

        $("#edit_control_account_main").select2({
            dropdownParent: $('#editControlAccountModal')
        });

        $("#edit_sub_control_account_control").select2({
            dropdownParent: $('#editSubControlAccountModal')
        });

        $("#edit_head_account_main").select2({
            dropdownParent: $('#editHeadAccountModal')
        });


        //**DataTables */
        var table = $('#AccountsTable').DataTable({
            "lengthChange": false,
            "paging": false,
            "ordering": false,
            "info": false,            
            "language": {
                search: "",
                searchPlaceholder: "Search..."
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search"
               
            },
             "buttons": [
                    { extend: "copy",  className: "btn btn-sm btn-light active" },
                    { extend: "csv",   className: "btn btn-sm btn-light" },
                    { extend: "print", className: "btn btn-sm btn-light" },
                    { extend: "pdf", className: "btn btn-sm btn-light" }
                ]
        });
            
    });

    function openAddMain(){
        document.getElementById('edit_main_account_id').value = '';
        document.getElementById('edit_main_account_number').value = '';
        document.getElementById('edit_main_account_name').value = '';

        document.getElementById('editMainAccountModalLabel').innerText  ='Add New Main Account';

        El = document.getElementById('editMainAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
    }

    function openEditMain(id){
        // Fetch account details using AJAX
        $.ajax({
            url: "{{ route('accounts.main.edit') }}",
            method: 'GET',
            data: { id_account_main: id },
            success: function(data) {
                data = data.account_main;
                $('#edit_main_account_id').val(data.id_account_main);
                $('#edit_main_account_number').val(data.account_main_number);
                $('#edit_main_account_name').val(data.account_main);
                document.getElementById('editMainAccountModalLabel').innerText  ='Edit Main Account';
                El = document.getElementById('editMainAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
            },
            error: function() {
                alert('Failed to fetch account details.');
            }
        });
    }

function updateMainAccount(){
    // Use jQuery to select button for addClass
    let btn = $('#btnUpdateMainAccount');
    btn.addClass('disabled'); // now works

    // Get value of input
    let id_account_main = $('#edit_main_account_id').val(); // jQuery val() method

    if(!id_account_main){
        // Add new Main Account
        $('#editMainAccountForm').off('submit').on('submit', function(e){ // off() to prevent multiple bindings
            e.preventDefault();
            const formData = $(this).serialize();
            $.ajax({
                url: "{{ route('accounts.main.add') }}",
                method: 'POST',
                data: formData,
                success: function(response) {
                    btn.removeClass('disabled');
                    if(response.success){
                        toastr.success('Main Account added successfully');
                        location.reload();
                    } else {
                        toastr.error('Add failed: ' + response.message);
                    }
                },
                error: function() {
                    btn.removeClass('disabled');
                    toastr.error('Error Adding Main Account');
                }
            });
        });
    } else {
        // Edit Main Account
        $('#editMainAccountForm').off('submit').on('submit', function(e){
            e.preventDefault();
            const formData = $(this).serialize();
            $.ajax({
                url: "{{ route('accounts.main.update') }}",
                method: 'POST',
                data: formData,
                success: function(response) {
                    btn.removeClass('disabled');
                    if(response.success){
                        toastr.success('Main Account updated successfully');
                        location.reload();
                    } else {
                        toastr.error('Update failed: ' + response.message);
                    }
                },
                error: function() {
                    btn.removeClass('disabled');
                    toastr.error('Error updating Main Account');
                }
            });
        });
    }
}


    function openAddControl(){
        document.getElementById('edit_control_account_id').value = '';
        document.getElementById('edit_control_account_number').value = '';
        document.getElementById('edit_control_account_name').value = '';
        document.getElementById('edit_control_account_main').value = '';
        $('#edit_control_account_main').val('').trigger('change');
        document.getElementById('editControlAccountModalLabel').innerText  ='Add New Control Account';
        El = document.getElementById('editControlAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
    }

    function openEditControl(id){
        // Fetch account details using AJAX
        $.ajax({
            url: "{{ route('accounts.control.edit') }}",
            method: 'GET',
            data: { id_account_control: id },
            success: function(data) {
                data = data.account_control;
                $('#edit_control_account_id').val(data.id_account_control);
                $('#edit_control_account_number').val(data.account_control_number);
                $('#edit_control_account_name').val(data.account_control);
                console.log(data.account_main_id);
                $('#edit_control_account_main').val(data.account_main_id).trigger('change');
                document.getElementById('editControlAccountModalLabel').innerText  ='Edit Control Account';
                El = document.getElementById('editControlAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
            },
            error: function() {
                alert('Failed to fetch account details.');
            }
        });
    }

    function updateControlAccount(){
        let btn = $('#btnUpdateControlAccount');
        btn.addClass('disabled'); // now works

        if($('#edit_control_account_id').val() == ''){
            //Add new Control Account
             $('#editControlAccountForm').on('submit', function(e){
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('accounts.control.add') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {

                        if(response.success){
                            El = document.getElementById('editControlAccountModal');
                            modal = new bootstrap.Modal(El);
                            modal.hide();

                            toastr.success('Control Account added successfully');
                            location.reload();
                        } else {
                            btn.removeClass('disabled');
                            toastr.error('Add failed: ' + response.message);
                        }
                    },
                    error: function() {
                        btn.removeClass('disabled');
                        toastr.error('Error Adding Control Account');
                    }
                });
            });
            return;
        } else {

            console.log("Update Control Account Called");
            $('#editControlAccountForm').on('submit', function(e){
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('accounts.control.update') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if(response.success){
                            El = document.getElementById('editControlAccountModal');
                            modal = new bootstrap.Modal(El);
                            modal.hide();

                            toastr.success('Control Account updated successfully');
                            location.reload();
                        } else {
                            btn.removeClass('disabled');
                            toastr.error('Update failed: ' + response.message);
                        }
                    },
                    error: function() {
                        btn.removeClass('disabled');
                        toastr.error('Error updating Control Account');
                    }
                });
            });
        }
    }

    function openAddSubControl(){
        document.getElementById('edit_sub_control_account_id').value = '';
        document.getElementById('edit_sub_control_account_number').value = '';
        document.getElementById('edit_sub_control_account_name').value = '';
        // document.getElementById('edit_sub_control_account_control').value = '';
        $('#edit_sub_control_account_control').val('').trigger('change');

        document.getElementById('editSubControlAccountModalLabel').innerText  ='Add New Sub Control';

        El = document.getElementById('editSubControlAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
    }

    function openEditSubControl(id){
        // Fetch account details using AJAX
        $.ajax({
            url: "{{ route('accounts.sub_control.edit') }}",
            method: 'GET',
            data: { id_account_sub_control: id },
            success: function(data) {
                data = data.account_sub_control;
                $('#edit_sub_control_account_id').val(data.id_account_sub_control);
                $('#edit_sub_control_account_number').val(data.account_sub_control_number);
                $('#edit_sub_control_account_name').val(data.account_sub_control);
                $('#edit_sub_control_account_status').val(data.account_sub_control_status);
                //console.log(data.account_control_id);
                $('#edit_sub_control_account_control').val(data.account_control_id).trigger('change');
                document.getElementById('editSubControlAccountModalLabel').innerText  ='Edit Sub Control';
                El = document.getElementById('editSubControlAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
            },
            error: function() {
                alert('Failed to fetch account details.');
            }
        });
    } 

    function updateEditSubControl(){

        let btn = $('#btnUpdateSubControlAccount');
        btn.addClass('disabled'); // now works

        if($('#edit_sub_control_account_id').val() == ''){
            //Add new Sub Control Account
             $('#editSubControlAccountForm').on('submit', function(e){
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('accounts.sub_control.add') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                       
                        if(response.success){
                            El = document.getElementById('editSubControlAccountModal');
                            modal = new bootstrap.Modal(El);
                            modal.hide();

                            toastr.success('Sub Control Account added successfully');
                            location.reload();
                        } else {
                            btn.removeClass('disabled');
                            toastr.error('Add failed: ' + response.message);
                        }
                    },
                    error: function() {
                        btn.removeClass('disabled');
                        toastr.error('Error Adding Sub Control Account');
                    }
                });
            });
            return;
        } else {
            //Edit Sub Control Account
            $('#editSubControlAccountForm').on('submit', function(e){
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('accounts.sub_control.update') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if(response.success){
                            El = document.getElementById('editSubControlAccountModal');
                            modal = new bootstrap.Modal(El);
                            modal.hide();
                            toastr.success('Sub Control Account updated successfully');
                            location.reload();
                        } else {
                            btn.removeClass('disabled');
                            toastr.error('Update failed: ' + response.message);
                        }
                    },
                    error: function() {
                        btn.removeClass('disabled');
                        toastr.error('Error updating Sub Control Account');
                    }
                });
            });
        }
    }

    function openAddHead(){
        document.getElementById('edit_head_account_id').value = '';
        document.getElementById('edit_head_account_number').value = '';
        document.getElementById('edit_head_account_name').value = '';
        document.getElementById('edit_head_account_main').value = '';
        $('#edit_head_account_main').val('').trigger("change");
        document.getElementById('editHeadAccountModalLabel').innerText  ='Add New Account Head';
        El = document.getElementById('editHeadAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
    }

    function openEditHead(id){
        console.log("Edit Head ID:", id);
        // Fetch account details using AJAX
        $.ajax({
            url: "{{ route('accounts.head.edit') }}",
            method: 'GET',
            data: { id_account_heads: id },
            success: function(data) {
                data = data.account_heads;
                $('#edit_head_account_id').val(data.id_account_heads);
                $('#edit_head_account_number').val(data.account_head_number);
                $('#edit_head_account_name').val(data.account_head);
                $('#edit_head_account_status').val(data.account_head_status);
                $('#edit_head_account_main').val(data.account_sub_control_id).trigger("change");
                
                document.getElementById('editHeadAccountModalLabel').innerText  ='Edit Account Head';
                El = document.getElementById('editHeadAccountModal');
                modal = new bootstrap.Modal(El);
                modal.show();
            },
            error: function() {
                alert('Failed to fetch account details.');
            }
        });
    }

    function updateEditHead(){
        let btn = $('#btnUpdateHeadAccount');
         btn.addClass('disabled'); 
        if($('#edit_head_account_id').val() == ''){
            //Add new Head Account
             $('#editHeadAccountForm').on('submit', function(e){
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('accounts.head.add') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        // btn.removeClass('disabled');
                        if(response.success){
                            //Close the edit add modal
                            El = document.getElementById('editHeadAccountModal');
                            modal = new bootstrap.Modal(El);
                            modal.hide();

                            toastr.success('Head Account added successfully');
                            location.reload();
                        } else {
                            btn.removeClass('disabled');
                            toastr.error('Add failed: ' + response.message);
                        }
                    },
                    error: function() {
                        btn.removeClass('disabled');
                        toastr.error('Error Adding Head Account');
                    }
                });
            });
            return;
        } else {
            //Edit Head Account       
            $('#editHeadAccountForm').on('submit', function(e){
                e.preventDefault();
                const formData = $(this).serialize();
                $.ajax({
                    url: "{{ route('accounts.head.update') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        
                        if(response.success){
                            El = document.getElementById('editHeadAccountModal');
                            modal = new bootstrap.Modal(El);
                            modal.hide();

                            toastr.success('Head Account updated successfully');
                            location.reload();
                        } else {
                            btn.removeClass('disabled');
                            toastr.error('Update failed: ' + response.message);
                        }
                    },
                    error: function() {
                        btn.removeClass('disabled');
                        toastr.error('Error updating Head Account');
                    }
                });
            });
        }
    }

</script>
@endsection