@extends('layouts.horizontal', ['title' => 'Create Account Vouchers', 'topbarTitle' => 'Create Account Vouchers'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@section('css')
@endsection
@section('content')

<div class="create-voucher-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">{{ isset($voucher) ? 'Edit' : 'Create' }} Account Voucher</h2>
                <div class="page-title-right">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
@if(empty($permission) || auth()->user()->can($permission))
    <div class="row fs-12">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form id="create_voucher_form">
                        @csrf
                        <h4 class="mb-3">Voucher Details</h4>
                        @if(isset($voucher))
                        <input type="hidden" id="id_account_voucher" name="id_account_voucher" value="{{ $voucher->id_account_vouchers }}">
                        @endif
                        <hr>
                        <div class="row mb-3 g-3">
                            <div class="col-2">
                                <label for="voucher_type" class="form-label">Voucher Type</label>
                                <select class="form-select" id="voucher_type" name="voucher_type" required>
                                    <option value="" disabled selected>Select Voucher Type</option>
                                    @foreach($account_voucher_type as $type)
                                        <option @if(isset($voucher) && $voucher->voucher_type == $type->id_account_voucher_type) selected @endif value="{{ $type->id_account_voucher_type }}">{{ explode(' ', $type->account_voucher_type)[0] }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-2">
                                <label for="voucher_date" class="form-label">Voucher Date</label>
                                <input type="date" class="form-control flatpickr" id="voucher_date" name="voucher_date" value="{{ isset($voucher) ? date('Y-m-d', strtotime( $voucher->voucher_date )) : '' }}" required>
                            </div>
                            @php
                                $colspan = (isset($businesses) && count($businesses) > 1) ? 6 : 8;
                                $hiddenClass = (isset($businesses) && count($businesses) > 1) ? '' : 'd-none';
                            @endphp
                            <div class="col-2 {{$hiddenClass}}">
                                <label for="business_id" class="form-label">Branches</label>
                                <select class="form-select" id="business_id" name="business_id" required>
                                    @if (isset($businesses) && count($businesses) > 0)
                                     @foreach ($businesses as $business )
                                        @php
                                            $selected = '';
                                            if (isset($voucherBusinessId) && $voucherBusinessId == $business->id_business) {
                                                $selected = 'selected';
                                            } elseif (session('business_id') == $business->id_business) {
                                                $selected = 'selected';
                                            }
                                        @endphp
                                     <option value="{{$business->id_business}}" {{ $selected }}>{{$business->business_name}}</option>   
                                     @endforeach 
                                    @endif
                                </select>   
                            </div>
                           
                            <div class="col-{{$colspan}}">
                                <label for="voucher_description" class="form-label">Narration</label>
                                <textarea class="form-control" id="voucher_description" name="voucher_description" rows="1" placeholder="Enter Voucher Description" required>{{ isset($voucher) ? $voucher->description : '' }}</textarea>
                            </div>                            
                        </div>                        
                        <div class="row mb-1 g-3">
                            <div class="col-2">
                                <label for="business_partner_type" class="form-label">Business Partner Type</label>
                                <select onchange="onchange_business_partner_type()" class="form-select" id="business_partner_type" name="business_partner_type" required>
                                    <option value="" disabled selected>Select Business Partner Type</option>
                                    @foreach($business_partners as $partner)
                                        <option @if(isset($voucher) && $voucher->business_partner == $partner->id_account_business_partner) selected @endif value="{{ $partner->id_account_business_partner }}">{{ $partner->account_business_partner }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-2">
                                <label for="business_partner" class="form-label">Business Partner</label>
                                <select class="form-select select2" id="business_partner" name="business_partner" placeholder="Enter Business Partner" >
                                    @if(isset($voucher))
                                        <option value="{{ $voucher->business_partner_id }}" selected>{{ $voucher->business_partner_name }}</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-2">
                                <label for="payment_mode" class="form-label">Payment Mode</label>
                                <select class="form-select" id="payment_mode" name="payment_mode" placeholder="Enter Payment Mode" >
                                    <option @if(isset($voucher) && $voucher->payment_mode == "Cash") selected @endif value="Cash"> Cash</option>
                                    <option @if(isset($voucher) && $voucher->payment_mode == "Bank Transfer") selected @endif value="Bank Transfer">Bank Transfer</option>
                                    <option @if(isset($voucher) && $voucher->payment_mode == "Check") selected @endif value="Check">Cheque</option>
                                    <option @if(isset($voucher) && $voucher->payment_mode == "Card") selected @endif value="Card">Credit Card</option>
                                    <option @if(isset($voucher) && $voucher->payment_mode == "Online") selected @endif value="Online">Mobile Payment</option>
                                    <option @if(isset($voucher) && $voucher->payment_mode == "Other") selected @endif value="Other">Other</option>
                                </select>
                            </div>
                            <div class="col-2 border-start border-info">
                                <label for="voucher_status" class="form-label">Voucher Status</label>
                                <select class="form-select" id="voucher_status" name="voucher_status" {{ session('user_role') != 'Super Admin' && session('user_role') != 'Super User' ? 'disabled' : '' }} >
                                    <option value="Active" @if(isset($voucher) && $voucher->voucher_status == "Active") selected @endif>Active</option>
                                    <option value="Inactive" @if(isset($voucher) && $voucher->voucher_status == "Cancelled") selected @endif>Cancelled</option>
                                </select>
                            </div>
                            <div class="col-2">
                                <label for="reference_document" class="form-label">Reference Document</label>
                                <select class="form-select" id="reference_document" name="reference_document" placeholder="Enter Reference Document" >
                                    <option value="" disabled selected>Select Reference Document</option>
                                    <option value="invoice_id" >Service/Sale Invoice ID</option>
                                    <option value="purchase_order_id" >Purchase Order ID</option>
                                    <option value="grn_id" >Goods Received Note ID</option>
                                    <option value="return_note_id"id >Return Note ID</option>
                                    <option value="adjustment_note_id"id >Adjustment Note ID</option>
                                    <option value="gtn_id"id >Goods Transfer Note ID</option>
                                    <option value="order_voucher_id" >Gift Order ID</option>
                                    <option value="visit_id" >Customer Visit ID</option>
                                    <option value="visit_advance_id" >Visit Advance ID</option>
                                    <option value="dispatch_id" >Dispatch Note ID</option>
                                    <option value="franchise_order_id" >Franchise Order ID</option>
                                    <option value="program_invoice_id" >Program Invoice ID</option>
                                    <option value="cash_register_id" >Cash Register ID</option>
                                    <option value="staffpayment_id" >Staff Payment Note ID</option>
                                </select>
                            </div>                        
                            <div class="col-2">
                                <label for="reference_id" class="form-label">Reference ID <span class="text-muted">(Optional)</span> </label>
                                <input type="number" class="form-control" id="reference_id" name="reference_id" placeholder="Enter Reference ID" >
                                
                            </div>
                        </div>
                    </form>
                </div>   
            </div> 
            <div class="card mt-3">
                <div class="card-body">
                        <h4 class="mb-3 mt-1">Transaction Details</h4>
                        <hr>
                        <div class="row mb-3 g-3">
                            <div class="col-2">
                                <label for="account_head" class="form-label">Account Head</label>
                                <select class="form-select select2" id="account_head" name="account_head" placeholder="Enter Account Head" >
                                    <option value="" disabled selected>Select Account Head</option>
                                    @foreach($account_heads as $head)
                                        <option value="{{ $head->id_account_heads }}">{{ $head->account_head_number .' '. $head->account_head }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-2">
                                <label for="detail_remarks" class="form-label">Narration</label>
                                <textarea class="form-control" id="detail_remarks" name="detail_remarks" rows="1" placeholder="Narration" ></textarea>
                            </div>
                            <div class="col-1">
                            <label for="cost_center_type" class="form-label">Cost Type</label>
                            <select onchange="costcentertypechange();" class="form-control" name="cost_center_type" id="cost_center_type" placeholder="Enter Business Partner" >     
                                {{-- <option value="0">All</option>                                --}}
                                @foreach($cost_centers as $center)
                                    <option value="{{ $center->id_account_cost_center }}">{{ $center->account_cost_center }}</option>
                                @endforeach
                            </select>
                            </div>

                            <div class="col-1" id="costCenterDiv">    
                                <!--Cost Center-->
                                <label for="cost_center" class="form-label">Cost Center</label>                                   
                                <input class="form-control" name="cost_center" id="cost_center" value=""/> 
                            </div>

                            {{-- <div class="col-1">
                                <label for="cost_center" class="form-label">Cost Center</label>
                                <select class="form-select select2" id="cost_center" name="cost_center" placeholder="Enter Business Partner" >                                    
                                    @foreach($cost_centers as $center)
                                        <option value="{{ $center->id_account_cost_center }}">{{ $center->account_cost_center }}</option>
                                    @endforeach
                                </select>
                            </div> --}}
                            <div class="col-1">
                                <label for="instrument_number" class="form-label">Instrument#</label>
                                <input type="number" class="form-control" id="instrument_number" name="instrument_number" placeholder="Enter Instrument#" >
                            </div>
                            <div class="col-2 text-end">
                                <label for="debit_amount" class="form-label text-end">Debit</label>
                                <input type="number" min="0" onchange="$('#credit_amount').val(0); if(this.value=='') this.value=0;" class="form-control text-end" id="debit_amount" name="debit_amount" value="0" placeholder="Enter Debit Amount" >
                            </div>                        
                            <div class="col-2 text-end">
                                <label for="credit_amount" class="form-label text-end">Credit</label>
                                <input type="number" min="0" onchange="$('#debit_amount').val(0); if(this.value=='') this.value=0;" class="form-control text-end" id="credit_amount" name="credit_amount" value="0" placeholder="Enter Credit Amount" >
                            </div>
                            <div class="col-1 d-flex align-items-end">
                                <button type="button" onclick="add_voucher_detail()" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn">
                                    <iconify-icon icon="line-md:arrow-open-down" class="fs-20"></iconify-icon>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="row mt-2">
                        <div class="col-12 d-flex justify-content-end">
                            <table id="voucher_detail_table" class="table table-bordered border-dark w-auto fs-12">
                                <thead>
                                    <tr>
                                        <th>Acc. ID</th>
                                        <th>Account Head</th>
                                        <th>Narration</th>
                                        <th>Cost Center</th>
                                        <th>Instrument#</th>
                                        <th class="text-end">Debit</th>
                                        <th class="text-end">Credit</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(isset($details))
                                        @foreach($details as $detail)
                                            <tr>
                                                <td id_account_voucher_detail="{{ $detail->id_account_voucher_detail }}" class="text-end fw-bolder">{{ $detail->account_head_id }}</td>
                                                <td>{{ $detail->account_head }}</td>
                                                <td>{{ $detail->detail_remarks }}</td>
                                                <td cost_center_typeText="{{ $detail->account_cost_center_type_name ?? 'Main Outlet' }}"  cost_center_type="{{ $detail->cost_center_type }}">{{ $detail->cost_center }}</td>
                                                <td>{{ $detail->instrument_number }}</td>
                                                <td class="text-end fw-bolder">{{ $detail->debit }}</td>
                                                <td class="text-end fw-bolder">{{ $detail->credit }}</td>
                                                <td>
                                                    <iconify-icon icon="line-md:pencil" onclick="open_edit_detail($(this).closest('tr'))" class="fs-20 text-danger cursor-pointer"></iconify-icon>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Total</th>
                                        <th class="text-end">0.00</th>
                                        <th class="text-end">0.00</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                            
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-end gap-2">
                    <button type="reset" class="btn btn-light btn-ghost-secondary">Reset</button>
                    <button type="button" onclick="create_voucher()" class="btn btn-info">{{ isset($voucher) ? 'Update' : 'Create' }} Voucher</button>
                </div>
            </div>
        </div>
    </div>
</div>
{{-- Edit Detail Modal --}}

<div class="modal fade" id="editDetailModal"  aria-labelledby="editDetailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editDetailModalLabel">Edit Voucher Detail</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Modal body content goes here -->
                <form id="edit_detail_form">
                    @csrf
                    <div class="row mb-3 g-3">
                        <div class="col-2">
                            <input type="hidden" id="edit_detail_row_index" name="edit_detail_row_index" >
                            <label for="edit_account_head" class="form-label">Account Head</label>
                            <select class="form-select select2" id="edit_account_head" name="edit_account_head" placeholder="Enter Account Head" >
                                <option value="" disabled selected>Select Account Head</option>
                                @foreach($account_heads as $head)
                                    <option value="{{ $head->id_account_heads }}">{{ $head->account_head_number .' '. $head->account_head }}</option>
                                @endforeach
                            </select>
                        </div>
                    
                        <div class="col-2">
                            <label for="edit_cost_center_type" class="form-label">Cost Center<smal>(T)</smal></label>
                            <select onchange="edit_costcentertypechange();" class="form-control" name="edit_cost_center_type" id="edit_cost_center_type" placeholder="Enter Business Partner" >     
                                {{-- <option value="0">select</option>                                --}}
                                @foreach($cost_centers as $center)
                                    <option value="{{ $center->id_account_cost_center }}">{{ $center->account_cost_center }}</option>
                                @endforeach
                            </select>
                            </div>

                        <div class="col-2" id="edit_costCenterDiv">    
                            <!--Cost Center-->
                            <label for="edit_cost_center" class="form-label">Cost Center</label>                                   
                            <input class="form-control" cost_center_type="" name="edit_cost_center" id="edit_cost_center" value=""/> 
                        </div>
                
                        <div class="col-2">
                            <label for="edit_instrument_number" class="form-label">Instrument#</label>
                            <input type="number" class="form-control" id="edit_instrument_number" name="edit_instrument_number" placeholder="Enter Instrument#" >
                        </div>
                        <div class="col-2 text-end">
                            <label for="edit_debit_amount" class="form-label text-end">Debit</label>
                            <input type="number" min="0" onchange="$('#edit_credit_amount').val(0); if(this.value=='') this.value=0;" class="form-control text-end" id="edit_debit_amount" name="edit_debit_amount" value="0" placeholder="Enter Debit Amount" >
                        </div>                        
                        <div class="col-2 text-end">
                            <label for="edit_credit_amount" class="form-label text-end">Credit</label>
                            <input type="number" min="0" onchange="$('#edit_debit_amount').val(0); if(this.value=='') this.value=0;" class="form-control text-end" id="edit_credit_amount" name="edit_credit_amount" value="0" placeholder="Enter Credit Amount" >
                        </div>
                    </div>
                    <div class="row">
                          <div class="col-12">
                            <label for="edit_detail_remarks" class="form-label">Narration</label>
                            <textarea class="form-control" id="edit_detail_remarks" name="edit_detail_remarks" rows="1" placeholder="Narration" ></textarea>
                        </div>
                   </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light btn-ghost-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" onclick="update_edit_detail_row()" class="btn btn-info">Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End Edit Detail Modal --}}
@else
    <h1>{{config('permission.not_allowed')}}</h1>
@endif

@endsection

<script>
    let baseURL = "{{ url('/') }}";
    document.addEventListener('DOMContentLoaded', function () {
        $("#account_head").select2();
        $("#business_partner").select2();
        costcentertypechange();
    });

    function onchange_business_partner_type() {
        let mURL = '';
        console.log($('#business_partner_type option:selected').text());
        if($('#business_partner_type option:selected').text() == "Customers"){
            mURL += baseURL + '/customer_search';
        } else if($('#business_partner_type option:selected').text() == "Staff"){
            mURL += baseURL + '/staff/staff_search';
        } else if($('#business_partner_type option:selected').text() == "Suppliers"){
            mURL += baseURL + '/supplier/supplier_search';
        } else if($('#business_partner_type option:selected').text() == "Franchise"){
            mURL += baseURL + '/franchise/franchise_search';
        } else {
            mURL += baseURL + '/business/business_search';
        }

        // Re-initialize Select2 with new URL
        $('#business_partner').empty(); // Clear previous selections
        initializeBusinessPartnerSelect2(mURL, $('#business_partner_type option:selected').text());
    }   

    function initializeBusinessPartnerSelect2(url, type) {
        $('#business_partner').select2({
            ajax: {
                url: url,
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        term: params.term // search term
                    };
                },
                processResults: function (data) {
                    // Ensure 'data' is a valid array before returning
                    if (!data || typeof data !== 'object') {
                        console.error('Invalid response for Select2:', data);
                        return { results: [] };
                    }

                    return {
                        results: data.map(function (item) {
                            return { id: item.id, text: item.text };
                        })
                    };
                },
                cache: true
            },
            minimumInputLength: 3,
            placeholder: 'Select ' + type ,
            width: '100%'
        });
    }

    function add_voucher_detail() {
        // Function to add voucher detail to the table
        console.log('Add voucher detail function called');
        // Implementation goes here
        let id_account_voucher_detail = 0; // New detail, so ID is 0
        
        let id_account_head = $('#account_head option:selected').val();
        let account_head = $('#account_head option:selected').text();
        let detail_remarks = $('#detail_remarks').val();
        let cost_center_type = $('#cost_center_type').val();
        let cost_center_typetext = $('#cost_center_type option:selected').text();
        let cost_center = $('#cost_center').val();
        let instrument_number = $('#instrument_number').val();
        let debit = $('#debit_amount').val();
        let credit = $('#credit_amount').val();

        //check if either debit or credit is greater than 0
        if(debit <= 0 && credit <= 0){
            toastr.info('Please enter either Debit or Credit amount greater than 0');
            return;
        }
        //check if account head is selected
        if(id_account_head == null || id_account_head == ''){
            toastr.info('Please select an Account Head');
            return;
        }

        let newRow = `<tr>
                <td id_account_voucher_detail="${id_account_voucher_detail}" class="text-end fw-bolder">${id_account_head}</td>
                <td>${account_head}</td>
                <td>${detail_remarks}</td>
                <td cost_center_typeText="${cost_center_typetext}"   cost_center_type="${cost_center_type}" class="tdOfcostCenterName">${cost_center}</td>
                <td>${instrument_number}</td>
                <td class="text-end fw-bolder">${debit}</td>
                <td class="text-end fw-bolder">${credit}</td>
                <td>
                    <iconify-icon icon="line-md:pencil" onclick="open_edit_detail($(this).closest('tr'))" class="fs-20 text-danger cursor-pointer"></iconify-icon>
                </td>
            </tr>`;
        $('#voucher_detail_table tbody').append(newRow);
        recalculate_totals();
    }

    function recalculate_totals() {
        // Function to recalculate totals in the voucher detail table
        let total_debit = 0;
        let total_credit = 0;

        $('#voucher_detail_table tbody tr').each(function() {
            let debit = parseFloat($(this).find('td').eq(5).text()) || 0;
            let credit = parseFloat($(this).find('td').eq(6).text()) || 0;

            total_debit += debit;
            total_credit += credit;
        });
        
        $('#voucher_detail_table tfoot th').eq(1).text(total_debit.toFixed(2));
        $('#voucher_detail_table tfoot th').eq(2).text(total_credit.toFixed(2));

        if(total_debit != total_credit){
            //add class text-danger to both total debit and credit
            $('#voucher_detail_table tfoot th').eq(1).removeClass('text-success');
            $('#voucher_detail_table tfoot th').eq(2).removeClass('text-success');
            $('#voucher_detail_table tfoot th').eq(1).addClass('text-danger');
            $('#voucher_detail_table tfoot th').eq(2).addClass('text-danger');
        } else {
            //remove class text-danger from both total debit and credit
            $('#voucher_detail_table tfoot th').eq(1).removeClass('text-danger');
            $('#voucher_detail_table tfoot th').eq(2).removeClass('text-danger');
            $('#voucher_detail_table tfoot th').eq(1).addClass('text-success');
            $('#voucher_detail_table tfoot th').eq(2).addClass('text-success');
        }

    }   

    function create_voucher() {
        // Function to create voucher
        console.log('Create voucher function called');
        // Implementation goes here
        
        // Validate that total debit equals total credit
        let total_debit = parseFloat($('#voucher_detail_table tfoot th').eq(1).text()) || 0;
        let total_credit = parseFloat($('#voucher_detail_table tfoot th').eq(2).text()) || 0;
        if(total_debit != total_credit){
            toastr.error('Total Debit and Credit amounts must be equal to create the voucher.');
            return;
        }

        //check if voucher type is selected
        let voucher_type = $('#voucher_type').val();
        if(voucher_type == null || voucher_type == ''){
            toastr.error('Please select a Voucher Type');
            return;
        }

        // check voucher date is selected
        let voucher_date = $('#voucher_date').val();
        if(voucher_date == null || voucher_date == ''){
            toastr.error('Please select a Voucher Date');
            return;
        }

        // check if narration is entered
        let voucher_description = $('#voucher_description').val();
        if(voucher_description == null || voucher_description == ''){
            toastr.error('Please enter a Voucher Description');
            return;
        }

        // check if cost center is entered
        let cost_center = $('#cost_center').val();
        let cost_center_type = $('#cost_center_type').val();
        // if(cost_center == null || cost_center == ''){
        //     toastr.error('Please enter a Cost Center');
        //     return;
        // }
        
        // check payment mode is selected
        let payment_mode = $('#payment_mode').val();
        if(payment_mode == null || payment_mode == ''){
            toastr.error('Please select a Payment Mode');
            return;
        }

        voucher_details = get_voucher_details();
        if(voucher_details.length == 0){
            toastr.error('Please add at least one Voucher Detail');
            return;
        }

        
         //check if business partner is selected
        if ($('#business_partner').data('select2')) {
            let business_partner_data = $('#business_partner').select2('data');
            //console.log(business_partner_data);
            let id_business_partner = business_partner_data[0].id;
            let business_partner_name = business_partner_data[0].text;
            let business_partner_type = $('#business_partner_type option:selected').val();
            
            if(id_business_partner == null || id_business_partner == ''){
                toastr.error('Please select a Business Partner or continue without selecting one.');
                return;
            }else {
                submit_form(voucher_type, voucher_date, voucher_description, id_business_partner, business_partner_name, business_partner_type, cost_center, cost_center_type, payment_mode, voucher_details);
            }
        } else {
            //Ask if the user wants to continue without selecting a business partner and get an input from Swal
            Swal.fire({
                title: 'No Business Partner Selected',
                text: "Do you want to continue without selecting a Business Partner?",
                input: 'text',
                inputPlaceholder: 'You can add a partner name here . ..',
                icon: 'warning',
                showCancelButton: true,
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger ms-2'
                },
                confirmButtonText: 'Yes, continue',
                cancelButtonText: 'No, select'
            }).then((result) => {
                if (result.isConfirmed) {
                    let business_partner_name = result.value || 'Other';
                    let id_business_partner = 0;
                    let business_partner_type = 0;
                    submit_form(voucher_type, voucher_date, voucher_description, id_business_partner, business_partner_name, business_partner_type, cost_center, cost_center_type, payment_mode, voucher_details);
                } else {
                    return;
                }
            });
        }
    }

    function submit_form(voucher_type, voucher_date, voucher_description, id_business_partner, business_partner_name, business_partner_type, cost_center, cost_center_type, payment_mode, voucher_details) {
        // Submit the form data via AJAX or any other method
        fetch(baseURL + '/accounts/save_voucher', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                id_account_voucher: document.getElementById('id_account_voucher') ? document.getElementById('id_account_voucher').value : 0,
                voucher_date: voucher_date,
                voucher_type: voucher_type,
                voucher_status: $('#voucher_status').val(),
                description: voucher_description,
                business_partner_id: id_business_partner,
                business_partner_name: business_partner_name,
                business_partner: business_partner_type,
                cost_center_name: cost_center,
                cost_center: cost_center_type,
                payment_mode: payment_mode,
                voucher_details: voucher_details,
                business_id: $("#business_id").val(),

            })
        })
        .then(response => response.json())
        .then(data => {
            if(data.success){
                toastr.success(data.message);
                // Redirect or update UI as needed
            } else {
                toastr.error('Error creating voucher: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            toastr.error('Error creating voucher');
        });
    }

    function get_voucher_details() {
        let details = [];
        $('#voucher_detail_table tbody tr').each(function() {
            let detail = {
                id_account_voucher_detail: $(this).find('td').eq(0).attr('id_account_voucher_detail'),
                account_head_id: $(this).find('td').eq(0).text(),
                account_head: $(this).find('td').eq(1).text(),
                detail_remarks: $(this).find('td').eq(2).text(),
                cost_center: $(this).find('td').eq(3).text(),
                cost_center_type: $(this).find('td').eq(3).attr('cost_center_type'),
                instrument_number: $(this).find('td').eq(4).text(),
                debit: parseFloat($(this).find('td').eq(5).text()) || 0,
                credit: parseFloat($(this).find('td').eq(6).text()) || 0,
            };
            details.push(detail);
        });
        return details;
    }

    function open_edit_detail(element) {

        $('#edit_detail_row_index').val($(element).index());
        $(element).find('td').each(function(index, td) {
            console.log(index + ': ' + $(td).text());
            if(index == 0){
                $('#edit_account_head').val($(td).text()).trigger('change');
            } else if(index == 2){
                $('#edit_detail_remarks').val($(td).text());
            } else if(index == 3){
                let cost_center_type = $(td).attr('cost_center_type');
                let cost_center_typeText = $(td).attr('cost_center_typeText');
                $('#edit_cost_center_type').val(cost_center_type).trigger('change');
                edit_costcentertypechange();
                console.log($(td).text(),"saif");
                var Route = '';
                if(cost_center_typeText == "Staff"){
                    Route = "{{ route('staff.staff_search') }}";
                    edit_enable_costcenterstaff(Route,$(td).text());
                } else if(cost_center_typeText == "Department") {
                    Route = "{{ route('service_department_search') }}";
                    edit_enable_costcenterdepartments(Route,$(td).text());
                }
            } else if(index == 4){
                $('#edit_instrument_number').val($(td).text());
            } else if(index == 5){
                $('#edit_debit_amount').val($(td).text());
            } else if(index == 6){
                $('#edit_credit_amount').val($(td).text());
            }
        });
        // return;

        let El = document.getElementById('editDetailModal');
        let modal = new bootstrap.Modal(El);
        modal.show();
    }

    function update_edit_detail_row() {
        let row_index = $('#edit_detail_row_index').val();
        let row = $('#voucher_detail_table tbody tr').eq(row_index);

        row.find('td').eq(0).text($('#edit_account_head').val());
        row.find('td').eq(1).text($('#edit_account_head option:selected').text());
        row.find('td').eq(2).text($('#edit_detail_remarks').val());
        row.find('td').eq(3).attr('cost_center_type', $('#edit_cost_center_type').val());
        row.find('td').eq(3).attr('cost_center_typeText', $('#edit_cost_center_type option:selected').text());
        row.find('td').eq(3).text($('#edit_cost_center').val());
        row.find('td').eq(4).text($('#edit_instrument_number').val());
        row.find('td').eq(5).text($('#edit_debit_amount').val());
        row.find('td').eq(6).text($('#edit_credit_amount').val());

        recalculate_totals();
        // Close the modal
        let editModalEl = document.getElementById('editDetailModal');
        let modal = bootstrap.Modal.getInstance(editModalEl);
        modal.hide();
    }   

    function costcentertypechange() {
        var selectedText = $("#cost_center_type option:selected").text();
        var $div = $("#costCenterDiv");

        $div.empty(); 

        if (selectedText !== "Staff" && selectedText !== "Department") {
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <input type="text" class="form-control" id="cost_center" name="cost_center" value="${selectedText =='All' ? '' :selectedText }" />
            `);
        } else {
            // Show select2
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <select class="form-select select2" id="cost_center" name="cost_center"></select>
            `);

            var Route = '';
            if(selectedText == "Staff"){
                Route = "{{ route('staff.staff_search') }}";
                enable_costcenterstaff(Route);
            } else {
                Route = "{{ route('service_department_search') }}";
                enable_costcenterdepartments(Route);
            }
        }
    }


    function enable_costcenterstaff(url) {
        if ($('#cost_center').hasClass('select2-hidden-accessible')) {
            $('#cost_center').select2('destroy'); 
        }
        $('#cost_center').select2({
                    ajax: {
                        url: url,
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                term: params.term // search term
                            };
                        },
                        processResults: function (data) {
                            // Ensure 'data' is a valid array before returning
                            if (!data || typeof data !== 'object') {
                                console.error('Invalid response for Select2:', data);
                                return { results: [] };
                            }

                        return {
                                    results: data.map(function (item) {
                                        return { 
                                            id: item.text, 
                                            text: `${item.text} | ${item.staff_cell}` 
                                        };
                                    })
                                };

                        },
                        cache: true
                    },
                    minimumInputLength: 3,
                    placeholder: 'Select Staff'  ,
                    width: '100%',
                templateSelection: function (data, container) {
                        // This controls what is displayed in the input after selection
                        if (data.full_name && data.cell) {
                            return data.full_name + " | " + data.cell;
                        }
                        return data.text;
                    }
                }); 
    }
    function enable_costcenterdepartments(url) {
        if ($('#cost_center').hasClass('select2-hidden-accessible')) {
            $('#cost_center').select2('destroy'); 
        }
        $('#cost_center').select2({
                    ajax: {
                        url: url,
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                term: params.term // search term
                            };
                        },
                        processResults: function (data) {
                            // Ensure 'data' is a valid array before returning
                            if (!data || typeof data !== 'object') {
                                console.error('Invalid response for Select2:', data);
                                return { results: [] };
                            }

                        return {
                                    results: data.map(function (item) {
                                        return { 
                                            id: item.text, 
                                            text: `${item.text}` 
                                        };
                                    })
                                };

                        },
                        cache: true
                    },
                    minimumInputLength: 3,
                    placeholder: 'Select Department'  ,
                    width: '100%',
                templateSelection: function (data, container) {
                        // This controls what is displayed in the input after selection
                        if (data.full_name && data.cell) {
                            return data.full_name + " | " + data.cell;
                        }
                        return data.text;
                    }
                }); 
    } 


    
    function edit_costcentertypechange() {
        var selectedText = $("#edit_cost_center_type option:selected").text();
        var $div = $("#edit_costCenterDiv");

        $div.empty(); 

        if (selectedText !== "Staff" && selectedText !== "Department") {
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <input type="text" class="form-control" id="edit_cost_center" name="edit_cost_center" value="${selectedText =='All' ? '' :selectedText }" />
            `);
        } else {
            // Show select2
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <select class="form-select select2" id="edit_cost_center" name="edit_cost_center"></select>
            `);

            var Route = '';
            if(selectedText == "Staff"){
                Route = "{{ route('staff.staff_search') }}";
                edit_enable_costcenterstaff(Route);
            } else {
                Route = "{{ route('service_department_search') }}";
                edit_enable_costcenterdepartments(Route);
            }
        }
    }


    function edit_enable_costcenterstaff(url,defaultValue = null) {
        if ($('#edit_cost_center').hasClass('select2-hidden-accessible')) {
            $('#edit_cost_center').select2('destroy'); 
        }
        $('#edit_cost_center').select2({
                    ajax: {
                        url: url,
                        dataType: 'json',
                        delay: 250,
                       
                        data: function (params) {
                            return {
                                term: params.term // search term
                            };
                        },
                        processResults: function (data) {
                            // Ensure 'data' is a valid array before returning
                            if (!data || typeof data !== 'object') {
                                console.error('Invalid response for Select2:', data);
                                return { results: [] };
                            }

                        return {
                                    results: data.map(function (item) {
                                        return { 
                                            id: item.text, 
                                            text: `${item.text} | ${item.staff_cell}` 
                                        };
                                    })
                                };

                        },
                        cache: true
                    },
                    dropdownParent: $('#editDetailModal'),
                    allowClear: true,
                    minimumInputLength: 3,
                    placeholder: 'Select Staff'  ,
                    width: '100%',
                templateSelection: function (data, container) {
                        // This controls what is displayed in the input after selection
                        if (data.full_name && data.cell) {
                            return data.full_name + " | " + data.cell;
                        }
                        return data.text;
                    }
                }); 

            if (defaultValue) {
                // Create a new option element and append it to the select
                var option = new Option(defaultValue, defaultValue.defaultValue, true, true);
                $('#edit_cost_center').append(option).trigger('change');
            }
    }
    function edit_enable_costcenterdepartments(url,defaultValue = null) {
        if ($('#edit_cost_center').hasClass('select2-hidden-accessible')) {
            $('#edit_cost_center').select2('destroy'); 
        }
        $('#edit_cost_center').select2({
                    ajax: {
                        url: url,
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                term: params.term // search term
                            };
                        },
                        processResults: function (data) {
                            // Ensure 'data' is a valid array before returning
                            if (!data || typeof data !== 'object') {
                                console.error('Invalid response for Select2:', data);
                                return { results: [] };
                            }

                        return {
                                    results: data.map(function (item) {
                                        return { 
                                            id: item.text, 
                                            text: `${item.text}` 
                                        };
                                    })
                                };

                        },
                        cache: true
                    },
                    dropdownParent: $('#editDetailModal'),
                    allowClear: true,
                    minimumInputLength: 3,
                    placeholder: 'Select Department'  ,
                    width: '100%',
                templateSelection: function (data, container) {
                        // This controls what is displayed in the input after selection
                        if (data.full_name && data.cell) {
                            return data.full_name + " | " + data.cell;
                        }
                        return data.text;
                    }
                }); 


            // Preselect default value if provided
            if (defaultValue) {
                // Create a new option element and append it to the select
                var option = new Option(defaultValue, defaultValue.defaultValue, true, true);
                $('#edit_cost_center').append(option).trigger('change');
            }
    }

</script>