@extends('layouts.horizontal', ['title' => 'General Ledger', 'topbarTitle' => 'Genral Ledger'])

@section('css')
@vite(['node_modules/choices.js/public/assets/styles/choices.min.css', 'node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection
@section('content')
<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     tr.border-top > td {border-top: 2px solid #000 !important;}
</style>

<div class="genral-ledger-container">
    <!-- start page title -->
    <div class="row mb-2">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">General Ledger</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                                                
                    <div class="row mb-2" id="filters">
                        <div class="col-12">
                            <div class="row mb-3">
                                <h4 class="card-title mb-2">Filters :</h4>         
                                <div class="col-md-2">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="{{ date('Y-m-d') }}">
                                </div>
                                <div class="col-md-2">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="{{ date('Y-m-t') }}">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Sub Control Head</label>
                                    <select id="sub_control_account" name="id_sub_control_account" class="form-select select-2" onchange="change_sub_control_account(this)">     
                                        <option value="0">Sub Control Head</option>                                               
                                        @foreach($account_sub_control as $sub_control)
                                            <option value="{{ $sub_control->id_account_sub_control }}">{{ $sub_control->account_sub_control }}</option>
                                        @endforeach
                                    </select>
                                </div>                                        
                                <div class="col-md-3">
                                    <label class="form-label">Account Head</label>
                                    <select id="account_head" name="account_head_id" class="form-select select-2" onchange="change_account_head_account(this)">     
                                        <option value="0">Select Account Heads</option>                                               
                                            @foreach($account_heads as $head)
                                            <option value="{{ $head->id_account_heads }}">{{ $head->account_head }}</option>
                                        @endforeach
                                    </select>
                                </div>                                            
                                <div class="col-md-2">
                                    <label for="business" class="form-label">Branches</label>
                                    <select class="form-select" id="business" name="business">                                                    
                                        @foreach($businesses as $business)
                                            <option value="{{ $business->id_business }}" {{ $business->id_business == session('business_id') ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                        @endforeach
                                        @if (session('ho') =='Yes')
                                            <option value="0">All Branches</option>
                                        @endif
                                    </select>
                                </div>
                            </div>                                    
                            <div class="row mb-3">
                                <div class="col-2">
                                    <label for="business_partner_type" class="form-label">Business Partner Type</label>
                                    <select onchange="onchange_business_partner_type()" class="form-select" id="business_partner_type" name="business_partner_type" required>
                                        <option value="" disabled selected>Select Business Partner Type</option>
                                        @foreach($business_partners as $partner)
                                            <option @if(isset($voucher) && $voucher->business_partner == $partner->id_account_business_partner) selected @endif value="{{ $partner->id_account_business_partner }}">{{ $partner->account_business_partner }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                    <div class="col-2">
                                    <label for="business_partner" class="form-label">Business Partner</label>
                                    <select class="form-select select2" id="business_partner" name="business_partner" placeholder="Enter Business Partner" >
                                        
                                    </select>
                                </div>

                                <div class="col-2">
                                    <label for="cost_center_type" class="form-label">Cost Center</label>
                                    <select onchange="costcentertypechange();" class="form-control" name="cost_center_type" id="cost_center_type" placeholder="Enter Business Partner" >     
                                        <option value="0">All</option>                               
                                        @foreach($cost_centers as $center)
                                            <option value="{{ $center->id_account_cost_center }}">{{ $center->account_cost_center }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-2" id="costCenterDiv">    
                                    <!--Cost Center-->
                                    <label for="cost_center" class="form-label">Cost Center</label>                                   
                                    <input class="form-control" name="cost_center_name" id="cost_center" value=""/> 
                                </div>

                                <div class="col-2">
                                    <label for="groupByFilter" class="form-label">Group By</label>
                                    <select class="form-select select2" id="groupByFilter" name="groupByFilter">
                                        <option value="id_account_vouchers">Voucher</option>
                                        <option value="instrument_number">Voucher & Instrument No </option>
                                        <option value="account_head_id">Account Head</option>
                                        <option value="cost_center">Cost Center</option>
                                        <option value="business_partner_id">Business Partner</option>
                                        <option value="voucher_date">Date</option>
                                        <option value="month">Month</option>
                                        <option value="year">Year</option>
                                    </select>     
                                </div>   

                                    <div class="col-md-2 text-end align-self-end">
                                    <button type="button" class="btn btn-light  w-20" id="btn_reset_filters">Reset</button>                                                
                                    <button type="button" class="btn btn-outline-success w-20" id="btn_refresh_table">Refresh</button>                                            
                                </div>
                            </div>  
                            <div class="row">
                                
                            </div>
                        </div>
                    </div>
                       
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">            
            <div class="table-responsive">
                <table id="general_ledger_table" class="table table-bordered  dt-responsive w-100 fs-12 table-sm">
                    <thead>
                        <tr>
                            <th colspan=6 class="text-start" id="account_head_display">All</th>                             
                           
                            <th colspan=6 class="text-end" id="opening_balance_display">Opening Balance: 0.00</th>
                        </tr>
                        <tr>                            
                            <th style="width: 2%;">ID</th>
                            <th style="width: 10%;">Voucher Date</th>
                            <th style="width: 10%;">Created At</th>
                            <th style="width: 25%;">Narration</th>
                            <th style="width: 3%;">Mode</th>
                            <th style="width: 10%;">Inst. #</th>
                            <th style="width: 7%;">Type</th>
                            <th style="width: 8%;">Partner</th>
                            <th style="width: 10%;">Created By</th>
                            <th style="width: 12%;" class="text-end">Debit</th>
                            <th style="width: 12%;" class="text-end">Credit</th>
                            <th style="width: 16%;" class="text-end">Running</th>
                        </tr>
                    </thead>
                    <tbody id="general_ledger_table_body">
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="9" class="text-end">Closing Balance:</th>                                                       
                            <th class="text-end" id="debit_total">0.00</th>
                            <th class="text-end" id="credit_total">0.00</th>                            
                            <th class="text-end"><span class="fw-bold" id="closing_balance_display">0.00</span></th>
                        </tr>
                    </tfoot>    
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    let baseURL = '{{ url("") }}'; // Use relative paths
    const staffImageBase = "{{ asset('images/staff') }}/";
    let general_ledger_table = null;

    function initialize_general_ledger_table() { 
        
        let closing_balance = 0;
        let runningTotal = 0;

        document.getElementById('opening_balance_display').innerText = "Opening Balance: 0.00";
        document.getElementById('account_head_display').innerText = "Account Head: All";
        document.getElementById('debit_total').innerText = "0.00";
        document.getElementById('credit_total').innerText = "0.00";
        document.getElementById('closing_balance_display').innerText = "0.00";
      
        general_ledger_table = $('#general_ledger_table').DataTable({
            processing: true,
            serverSide: true,
            destroy: true,
            autoWidth: false,
            responsive: false,
            scrollY: "500px",  
            scrollX: "auto",  
            scrollCollapse: true,
            ajax: {
                url: "{{ route('accounts.general_ledger') }}",
                type: 'GET',
                data: function(d) {
                    d.business_id = document.getElementById('business').value;
                    d.start_date = document.getElementById('from_date').value;
                    d.end_date = document.getElementById('to_date').value;
                    d.sub_control_account_id = document.getElementById('sub_control_account')?.value || 0;
                    d.account_head_id = document.getElementById('account_head')?.value || 0;
                    d.business_partner_id = document.getElementById('business_partner')?.value || 0;
                    d.business_partner_type_id = document.getElementById('business_partner_type')?.value || 0;
                    d.cost_center_type = document.getElementById('cost_center_type')?.value || 0;
                    d.cost_center_name = document.getElementById('cost_center')?.value || 0;
                    d.groupByFilter = document.getElementById('groupByFilter')?.value || 0;
                },
                dataSrc: function(json) {

               
                    // Check if the API returned an error or message instead of data
                    console.log(json);
                    let opening_balance_data = json.opening_balance;
                    closing_balance = 0;
                    runningTotal = 0;

                    document.getElementById('opening_balance_display').innerText = "Opening Balance: 0.00";
                                      

                    const thead = $('#general_ledger thead');

                    if (opening_balance_data) {

                        document.getElementById('opening_balance_display').innerText = "Opening Balance: " + parseFloat(opening_balance_data.opening_balance).toFixed(2);
                        // document.getElementById('account_head_display').innerText = opening_balance_data.account_head != null ? "Account Head: " + opening_balance_data.account_head :  "Account Head: " + document.getElementById('account_head').options[document.getElementById('account_head').selectedIndex].text;
                        account_head = opening_balance_data.account_head;
                        opening_balance = parseFloat(opening_balance_data.opening_balance);
                        //closing_balance = closing_balance + opening_balance;
                        runningTotal = runningTotal + opening_balance;

                    }

                    if (json.error) {
                        alert(json.error);
                        return [];
                    } else if (json.message) {
                        alert(json.message);
                        return [];
                    }
                    return json.data;
                }
            },
            "info": false,
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
              
            },
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-light active" },
                { extend: "csv",   className: "btn btn-sm btn-light" },
                { extend: "print", className: "btn btn-sm btn-light" },
                { extend: "pdf", className: "btn btn-sm btn-light" }
            ],
            columns: [
                { data: 'id_account_vouchers', width: '2%' },
                { data: 'voucher_date', width: '10%' },
                { data: 'created_on', width: '10%' },
                { data: 'description', width: '25%' },
                { data: 'payment_mode', width: '3%' },
                { data: 'instrument_number', width: '10%' },
                { data: 'account_voucher_type', width: '7%' },
                { data: 'business_partner_name', width: '8%' },
                { data: 'created_by', className: '', width: '10%' },
                { data: 'debit', className: 'text-end', width: '12%' },
                { data: 'credit', className: 'text-end', width: '12%' },
               {
                data: 'net_amount',
                className: 'text-end',
                width: '16%',
            }

            ],

            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {
                if (data.voucher_status != 'Active') {
                    $(row).addClass('strike-through');
                }                
            },
            "drawCallback": function(settings) {
                let debit_total = 0;
                let credit_total = 0;               
                let opening_balance = 0;               
                let net_amount_total = 0;

                document.getElementById('debit_total').innerText = "0.00";
                document.getElementById('credit_total').innerText = "0.00";
                document.getElementById('closing_balance_display').innerText = "0.00";

                let api = this.api();
                
                api.rows({ page: 'current' }).every(function() {
                    let data = this.data();
                    if(data.voucher_status != 'Active') {
                        // If voucher is not active, skip adding to running total
                        $(this.node()).find('td:last').text('Cancelled');
                         $(this.node()).find('td:last').addClass('text-end');
                    } else {
                        runningTotal += parseFloat(data.net_amount);
                        // Update the last cell in this row
                        $(this.node()).find('td:last').text(runningTotal.toFixed(2));
                        $(this.node()).find('td:last').addClass('text-end');
                        
                        debit_total += parseFloat(data.debit);
                        credit_total += parseFloat(data.credit);
                        net_amount_total += parseFloat(data.net_amount);
                    }
                   
                    //make fist col link to voucher print
                    let voucher_link = '{{ route("accounts.account_voucher_print") }}' + '?id=:id';
                    voucher_link = voucher_link.replace(':id', data.id_account_vouchers);
                    $(this.node()).find('td:first').html('<a href="' + voucher_link + '" target="_blank">' + data.id_account_vouchers + '</a>');


                });
                closing_balance += runningTotal;
                document.getElementById('debit_total').innerText = debit_total.toFixed(2);
                document.getElementById('credit_total').innerText = credit_total.toFixed(2);                
                document.getElementById('closing_balance_display').innerText = closing_balance.toFixed(2);
            },
            order: [[0, 'asc']],
            ordering:false,
            sorting: false,
            paging: false,            
            
        });
    }

   
    document.addEventListener('DOMContentLoaded', function() {
        
        // Initialize Select2
        $('.select-2').select2({
            width: '100%'
        });

        // initialize customers select2
        $('#customer').select2({
            placeholder: 'Select Customer',
            minimumInputLength: 3,
            allowClear: true,
            ajax: {
                url: '{{ route("customer_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.customer_name || (item.customer_name + ' (' + item.customer_cell + ')'),
                                customer_name: item.customer_name,
                                customer_cell: item.customer_cell,
                                customer_type: item.customer_type // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatCustomer,      // dropdown items
            templateSelection: formatCustomerSel // selected item
        });

        function formatCustomer(customer) {
            // Select2 calls this for placeholder items where id is undefined/empty.
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }

            // defensive: unify the type so comparisons are reliable
            var type = (customer.customer_type || '').toString().toLowerCase();
           
            // decide icon & color (use Bootstrap Icons classes as example)
            var iconClass = 'ti-user fs-4 text-secondary';
            var nameClass = '';
            if (type === 'orange' || type === '1') {
                iconClass = 'ti-star fs-4 text-warning';
                nameClass = 'text-warning';
            } else if (type === 'green' || type === '2') {
                iconClass = 'ti-flag fs-4 text-success';
                nameClass = 'text-success';
            }  else if (type === 'red' || type === '3') {
                iconClass = 'ti-flag-question fs-4 text-danger';
                //nameClass = 'text-danger';
            } 
            // safe-escape text pieces
            var nameEsc = $('<div/>').text(customer.customer_name || customer.text || '').html();
            var cellEsc = $('<div/>').text(customer.customer_cell || '').html();

            var $node = $(
                '<div class="d-flex justify-content-between align-items-center">' +
                    '<div>' +
                        '<div class="fw-bold  '+nameClass+'">' + nameEsc + '</div>' +
                        '<div class="small">' + cellEsc + '</div>' +
                    '</div>' +
                    '<i class="ti ' + iconClass + ' ms-2" aria-hidden="true"></i>' +
                '</div>'
            );
            return $node;
        }

        function formatCustomerSel(customer) {
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }
            var name = customer.customer_name || customer.text;
            var cell = customer.customer_cell ? ' (' + customer.customer_cell + ')' : '';
            // return a simple node — keep selection compact
            return $('<span>').text(name + cell);
        }


        // initialize staff select2
        $('#staff').select2({
            placeholder: 'Select Staff',
            minimumInputLength: 3,
            allowClear: true,
            ajax: {
                url: '{{ route("staff.staff_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { 
                        term: params.term,
                        business_id: document.getElementById('business').value                        
                    };
                },
                processResults: function (data) {
                    console.log(data);
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.text,
                                staff_cell: item.staff_cell,
                                branch: item.business_name,
                                staff_type: item.staff_type,
                                staff_image: item.staff_image // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatStaff,      // dropdown items
            templateSelection: formatStaff // selected item
        });
        function formatStaff (option) {
           if (!option.id) {
                return option.text;
            }

            var imgSrc = staffImageBase + option.staff_image;
            return $('<span><img src="'+ imgSrc +'" class="avatar-sm rounded-circle me-2" /> ' + option.text + ' - ' + option.branch + ' - ' + option.staff_type + '</span>');
        }


        // initialize suppliers select2
        $('#supplier').select2({
            placeholder: 'Select Supplier',
            minimumInputLength: 3,
            allowClear: true,
            ajax: {
                url: '{{ route("supplier.supplier_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.supplier_name || (item.supplier_name + ' (' + item.supplier_cell + ')'),
                                supplier_name: item.supplier_name,
                                supplier_cell: item.supplier_cell,
                                supplier_active: item.supplier_active // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatSupplier,      // dropdown items
            templateSelection: formatSupplierSel // selected item
        });

        function formatSupplier(supplier) {
            // Select2 calls this for placeholder items where id is undefined/empty.
            if (!supplier || !supplier.id) {
                return supplier && supplier.text ? supplier.text : '';
            }

            // defensive: unify the type so comparisons are reliable
            var active = (supplier.supplier_active || '').toString().toLowerCase();
           
            // decide icon & color (use Bootstrap Icons classes as example)
            var iconClass = 'ti ti-user fs-4 text-secondary';
            var nameClass = '';
            if (active === 'yes' || active === 'Active') {
                iconClass = 'ti ti-check fs-4 text-success';
                nameClass = 'text-success';
            } else {
                iconClass = 'ti ti-close fs-4 text-danger';
                nameClass = 'text-danger';
            }

            return $('<span><i class="'+ iconClass +'"></i> <span class="'+ nameClass +'">' + supplier.supplier_name + ' ' + supplier.supplier_cell + '</span></span>');
        }

        function formatSupplierSel(supplier) {
            if (!supplier || !supplier.id) {
                return supplier && supplier.text ? supplier.text : '';
            }
            var name = supplier.supplier_name || supplier.text;
            var cell = supplier.supplier_cell ? ' (' + supplier.supplier_cell + ')' : '';
            // return a simple node — keep selection compact
            return $('<span class="text-dark">').text(name + cell);
        }

        // initialize franchise select2
        $('#franchise').select2({
            placeholder: 'Select Franchise',
            minimumInputLength: 3,
            allowClear: true,
            ajax: {
                url: '{{ route("franchise.franchise_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.franchise_name || (item.franchise_name + ' (' + item.franchise_office_phone + ')'),
                                franchise_name: item.franchise_name,
                                franchise_office_phone: item.franchise_office_phone,
                                franchise_status: item.franchise_status // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatFranchise,      // dropdown items
            templateSelection: formatFranchiseSel // selected item
        });

        function formatFranchise(franchise) {
            // Select2 calls this for placeholder items where id is undefined/empty.
            if (!franchise || !franchise.id) {
                return franchise && franchise.text ? franchise.text : '';
            }

            // defensive: unify the type so comparisons are reliable
            var active = (franchise.franchise_status || '').toString().toLowerCase();
           
            // decide icon & color (use Bootstrap Icons classes as example)
            var iconClass = 'ti ti-user fs-4 text-secondary';
            var nameClass = '';
            if (active === 'active') {
                iconClass = 'ti ti-check fs-4 text-success';
                nameClass = 'text-success';
            } else {
                iconClass = 'ti ti-close fs-4 text-danger';
                nameClass = 'text-danger';
            }

            return $('<span><i class="'+ iconClass +'"></i> <span class="'+ nameClass +'">' + franchise.franchise_name + ' ' + franchise.franchise_office_phone + '</span></span>');
        }

        function formatFranchiseSel(franchise) {
            if (!franchise || !franchise.id) {
                return franchise && franchise.text ? franchise.text : '';
            }
            var name = franchise.franchise_name || franchise.text;
            var cell = franchise.franchise_office_phone ? ' (' + franchise.franchise_office_phone + ')' : '';
            // return a simple node — keep selection compact
            return $('<span class="text-dark">').text(name + cell);
        }


        initialize_general_ledger_table();

        document.getElementById('btn_refresh_table').addEventListener('click', function(btn) { 
            var sub_control_account_id = document.getElementById('sub_control_account')?.value || 0;
            var account_head_id = document.getElementById('account_head')?.value || 0;
            var from_date = document.getElementById('from_date')?.value || 0;
            var to_date = document.getElementById('to_date')?.value || 0;


               if (from_date && to_date) {
                var from = new Date(from_date);
                var to = new Date(to_date);
                var diffTime = Math.abs(to - from); // difference in milliseconds
                var diffYears = diffTime / (1000 * 60 * 60 * 24 * 365); // convert to years

                if (diffYears > 2) {
                    Swal.fire({
                        title: 'Warning',
                        text: "You cannot select a date range longer than 2 years.",
                        icon: 'warning',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                    return false;
                }
            }


            if (sub_control_account_id == 0 && account_head_id == 0) {
                Swal.fire({
                            title: 'Warning',
                            text: "Please select at least a Sub Control Head or an Account Head.",
                            icon: 'warning',
                            confirmButtonText: 'OK',
                            customClass: {
                                    confirmButton: 'btn btn-danger'
                            }
                        });
                return false        
            } 


            $("#btn_refresh_table").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>`);
            $("#btn_refresh_table").prop("disabled", true);
            if(general_ledger_table){
                general_ledger_table.ajax.reload(function() {
                    $("#btn_refresh_table").html(`Refresh`);
                    $("#btn_refresh_table").prop("disabled", false);
                });
            }
        });

    });


    function onchange_business_partner_type() {
            let mURL = '';
              const type = $('#business_partner_type option:selected').text();
            if (type === "Customers") {
                 mURL = "{{ route('customer_search') }}";
            } else if (type === "Staff") {
                mURL = "{{ route('staff.staff_search') }}";
            } else if (type === "Suppliers") {
                mURL = "{{ route('supplier.supplier_search') }}";
            } else if (type === "Franchise") {
                mURL = "{{ route('franchise.franchise_search') }}";
            } else {
                mURL = "{{ route('business.business_search') }}";
            }
            // Re-initialize Select2 with new URL
            $('#business_partner').empty(); // Clear previous selections
            initializeBusinessPartnerSelect2(mURL, $('#business_partner_type option:selected').text());
    }   
    function initializeBusinessPartnerSelect2(url, type) {
            $('#business_partner').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.text };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select ' + type ,
                width: '100%'
            });
    } 




    function costcentertypechange() {
        var selectedText = $("#cost_center_type option:selected").text();
        var $div = $("#costCenterDiv");

        $div.empty(); 

        if (selectedText !== "Staff" && selectedText !== "Department") {
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <input type="text" class="form-control" id="cost_center" name="cost_center_name" value="${selectedText =='All' ? '' :selectedText }" />
            `);
        } else {
            // Show select2
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <select class="form-select select2" id="cost_center" name="cost_center_name"></select>
            `);

            var Route = '';
            if(selectedText == "Staff"){
                Route = "{{ route('staff.staff_search') }}";
                enable_costcenterstaff(Route);
            } else {
                Route = "{{ route('service_department_search') }}";
                enable_costcenterdepartments(Route);
            }
        }
    }


function enable_costcenterstaff(url) {
    if ($('#cost_center').hasClass('select2-hidden-accessible')) {
        $('#cost_center').select2('destroy'); 
    }
     $('#cost_center').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                      return {
                                results: data.map(function (item) {
                                    return { 
                                        id: item.text, 
                                        text: `${item.text} | ${item.staff_cell}` 
                                    };
                                })
                            };

                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select Staff'  ,
                width: '100%',
               templateSelection: function (data, container) {
                    // This controls what is displayed in the input after selection
                    if (data.full_name && data.cell) {
                        return data.full_name + " | " + data.cell;
                    }
                    return data.text;
                }
            }); 
}
function enable_costcenterdepartments(url) {
    if ($('#cost_center').hasClass('select2-hidden-accessible')) {
        $('#cost_center').select2('destroy'); 
    }
     $('#cost_center').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                      return {
                                results: data.map(function (item) {
                                    return { 
                                        id: item.text, 
                                        text: `${item.text}` 
                                    };
                                })
                            };

                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select Department'  ,
                width: '100%',
               templateSelection: function (data, container) {
                    // This controls what is displayed in the input after selection
                    if (data.full_name && data.cell) {
                        return data.full_name + " | " + data.cell;
                    }
                    return data.text;
                }
            }); 
}

function change_sub_control_account(this_select_box){
    if($(this_select_box).val() > 0){
        $("#account_head").val("0").trigger("change");
        $("#account_head_display").html("Sub Control Account : " + $(this_select_box).find("option:selected").text());
        
    }
}

function change_account_head_account(this_select_box){
    if($(this_select_box).val() > 0){
    $("#sub_control_account").val("0").trigger("change");
    $("#account_head_display").html("Account Head: " + $(this_select_box).find("option:selected").text());
    }
}

document.getElementById("btn_reset_filters").addEventListener("click", function () {
    // Select2 dropdown reset
    $('#sub_control_account').val("0").trigger("change");
    $('#account_head').val("0").trigger("change");
    $('#business_partner_type').val("").trigger("change");
    $('#business_partner').val("").trigger("change");
    $('#groupByFilter').val("id_account_vouchers").trigger("change");

    document.getElementById('cost_center_type').value = "0";
    // Cost center text clear
    document.getElementById('cost_center').value = "";
    // Table refresh
    // $('#btn_refresh_table').click();
});
</script>
@endsection