@extends('layouts.horizontal', ['title' => 'Aging Payables', 'topbarTitle' => 'Aging Payables']) 
@section('css')
 <style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
 </style>
@endsection
@section('content')
<div class="profit-loss-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Aging Payables</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">Aging Payables</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- FILTERS -->
    <form id="accounts_closing_form" method="POST" action="javascript:void(0)">
        @csrf
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Filters </h4>
                        <div>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-sm-3">
                            <label class="form-label">Business</label>
                            <select class="form-select" id="business" name="selected_business_id">
                               
                                @foreach($businesses as $business)
                                    <option value="{{ $business->id_business }}"
                                        {{ $business->id_business == $selected_business_id ? 'selected' : '' }}>
                                        {{ $business->business_name }}
                                    </option>
                                @endforeach
                                @if (session('ho') =="Yes")
                                    <option value="0">All Branches</option>
                                @endif
                            </select>
                        </div>

                        <div class="col-sm-3">
                            <label for="as_on_date_select" class="form-label">As On Date</label>
                            <input type="date" class="form-control" id="as_on_date_select" name="as_on_date" value="{{ date('Y-m-01') }}">
                        </div>       
                     
                        
                        <div class="col-sm-3 align-self-end">
                            <button type="button" class="btn btn-outline-success " id="btn_refresh_table">Refresh</button>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    </form>
    <!-- EXPENSE TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Aging Payables</h4>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12" id="agingPayablesTable">
                            <thead class="table-light">
                                <tr>
                                    <th colspan=4 class="text-start" id="AsOnDate"></th>                             
                                    <th colspan=4 class="text-end" id="AccountHead">Account Head :</th>
                                </tr>
                                <tr >
                                    <th>ID</th>
                                    <th>Branch</th>
                                    <th>Business Partner</th>
                                    <th class="text-end">< 30</th>
                                    <th class="text-end">30 - 59</th>
                                    <th class="text-end">60 - 89</th>
                                    <th class="text-end">> 90</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody id="agingPayablesTableBody">
                               
                            </tbody>
                            <tfoot class="table-light fw-bold">
                                <tr>
                                    <th colspan="2" class="text-end">Grand Total:</th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                   
                </div>
            </div>
        </div>
    </div> 

</div>
@endsection

@section('scripts')
<script>
let baseURL = "{{ url('/') }}";
let user_role = @json(session('user_role'));
let agingPayablesTable=null;
document.addEventListener("DOMContentLoaded", function() { 
    initializeAgingPayablesTable(); 
    document.getElementById('btn_refresh_table').addEventListener('click', function(btn) { 
        $("#btn_refresh_table").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>`);
        $("#btn_refresh_table").prop("disabled", true);
        if(agingPayablesTable){
            agingPayablesTable.ajax.reload(function() {
                $("#btn_refresh_table").html(`Refresh`);
                $("#btn_refresh_table").prop("disabled", false);
            });
        }
    });
});


function initializeAgingPayablesTable() {
    agingPayablesTable = $('#agingPayablesTable').DataTable({
        processing: true,
        serverSide: true,
        destroy: true,
        autoWidth: false,
        responsive: false,
        scrollY: "500px",
        scrollX: true,
        scrollCollapse: true,

        ajax: {
            url: "{{ route('accounts.aging_payables') }}",
            type: 'GET',

            data: function(d) {
                return {
                    business_id: document.getElementById('business').value,
                    as_on_date: document.getElementById('as_on_date_select').value,

                    // Server-side parameters
                    start: d.start,
                    length: d.length,
                    search: { value: d.search.value },
                    draw: d.draw
                };
            },

            dataSrc: function(json) {
                if (json.error) {
                    alert(json.error);
                    return [];
                }

                if (json.message) {
                    alert(json.message);
                    return [];
                }

                $("#AsOnDate").text("As On Date : "+json.as_on_date);
                $("#AccountHead").text("Account Head :"+json.account_head_name);

                json.recordsTotal = json.recordsTotal || json.data.length;
                json.recordsFiltered = json.recordsFiltered || json.data.length;
                return json.data;
            }
        },

        pageLength: 50,
        lengthMenu: [[10, 25, 50,100,300,500,1000, -1], [10, 25, 50,100,300,500,1000, "All"]],

        layout: {
            topStart: "buttons",
            topEnd: "search",
            bottomStart: {
                pageLength: {
                    menu: [[10, 25, 50,100,300,500,1000, -1], [10, 25, 50,100,300,500,1000, "Show all"]]
                },
                info: {}
            }
        },

        buttons: [
            { extend: "copy", className: "btn btn-sm btn-soft-primary" },
            { extend: "csv", className: "btn btn-sm btn-soft-primary" },
            { extend: "print", className: "btn btn-sm btn-soft-primary" },
            { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
        ],

        columns: [
        
            { data: 'business_partner_id', width: '5%', title: 'ID' },
            { data: 'branch', width: '5%', title: 'Branch' },
            { data: 'business_partner_name', width: '20%', title: 'Business Partner' },
            { 
                data: 'lessthen30',
                className: 'text-end',
                width: '10%',
                title: '< 30',
                render: d => (parseFloat(d) || 0).toLocaleString('en-IN', { minimumFractionDigits: 2 })
            },

            { 
                data: 'thirtyfiftynine',
                className: 'text-end',
                width: '10%',
                title: '30 - 59',
                render: d => (parseFloat(d) || 0).toLocaleString('en-IN', { minimumFractionDigits: 2 })
            },

            { 
                data: 'sixtyninty',
                className: 'text-end',
                width: '10%',
                title: '60 - 89',
                render: d => (parseFloat(d) || 0).toLocaleString('en-IN', { minimumFractionDigits: 2 })
            },

            { 
                data: 'over90',
                className: 'text-end',
                width: '10%',
                title: '> 90',
                render: d => (parseFloat(d) || 0).toLocaleString('en-IN', { minimumFractionDigits: 2 })
            },

            {
                data: null,
                className: 'text-end fw-bold',
                width: '15%',
                title: 'Total',
                render: row => {
                    let total =
                        (parseFloat(row.lessthen30) || 0) +
                        (parseFloat(row.thirtyfiftynine) || 0) +
                        (parseFloat(row.sixtyninty) || 0) +
                        (parseFloat(row.over90) || 0);

                    return total.toLocaleString('en-IN', { minimumFractionDigits: 2 });
                }
            }
        ],

        footerCallback: function(row, data, start, end, display) {
            let api = this.api();

            let less30 = 0, t35 = 0, t60 = 0, ov90 = 0;

            api.rows({ search: "applied" }).data().each(function(row) {
                less30 += parseFloat(row.lessthen30) || 0;
                t35    += parseFloat(row.thirtyfiftynine) || 0;
                t60    += parseFloat(row.sixtyninty) || 0;
                ov90   += parseFloat(row.over90) || 0;
            });

            let gTotal = less30 + t35 + t60 + ov90;

            $(api.column(3).footer()).html(less30.toLocaleString('en-IN', { minimumFractionDigits: 2 }));
            $(api.column(4).footer()).html(t35.toLocaleString('en-IN', { minimumFractionDigits: 2 }));
            $(api.column(5).footer()).html(t60.toLocaleString('en-IN', { minimumFractionDigits: 2 }));
            $(api.column(6).footer()).html(ov90.toLocaleString('en-IN', { minimumFractionDigits: 2 }));
            $(api.column(7).footer()).html(gTotal.toLocaleString('en-IN', { minimumFractionDigits: 2 }));
        },

        ordering:false 
    });
}

</script>
@endsection