@extends('layouts.horizontal', ['title' => 'Trial Balance', 'topbarTitle' => 'Trial Balance'])

@section('css')
@vite(['node_modules/choices.js/public/assets/styles/choices.min.css', 'node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

<div class="trail-balance-container">
    <!-- start page title -->
    <div class="row mb-2">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Trial Balance</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">Trail Balance</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Filters :</h4>
                    <div class="row g-3">
                        
                        <div class="col-sm-2">
                            <label for="from_date" class="form-label">From Date</label>
                            <input type="date" class="form-control" id="from_date" name="from_date" value="{{ date('Y-m-01') }}">
                        </div>
                        <div class="col-sm-2">
                            <label for="to_date" class="form-label">To Date</label>
                            <input type="date" class="form-control" id="to_date" name="to_date" value="{{ date('Y-m-t') }}">
                        </div> 
                        <div class="col-md-3">
                            <label class="form-label">Sub Control Head</label>
                            <select id="sub_control_account" name="id_sub_control_account" class="form-select select-2" onchange="change_sub_control_account(this)">     
                                <option value="0">Sub Control Head</option>                                               
                                @foreach($account_sub_control as $sub_control)
                                    <option value="{{ $sub_control->id_account_sub_control }}">{{ $sub_control->account_sub_control }}</option>
                                @endforeach
                            </select>
                        </div>                                        
                        <div class="col-md-3">
                            <label class="form-label">Account Head</label>
                            <select id="account_head" name="account_head_id" class="form-select select-2" onchange="change_account_head_account(this)">     
                                <option value="0">Select Account Heads</option>                                               
                                @foreach($account_heads as $head)
                                    <option value="{{ $head->id_account_heads }}">{{ $head->account_head }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="col-sm-2">
                            <label for="business" class="form-label">Business</label>
                            <select class="form-select" id="business" name="business">                                
                                @foreach($businesses as $business)
                                    <option value="{{ $business->id_business }}" {{ $business->id_business == session('business_id') ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                @endforeach
                                @if(session('ho') =='Yes')
                                <option value="0">All Branches</option>
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3 mt-3 ">
                        <div class="col-md-9">

                        </div>
                        <div class="col-md-3  align-self-end d-flex justify-content-end gap-1">
                            <button type="button" class="btn btn-light " id="btn_reset_filters">Reset</button>                                                
                            <button type="button" class="btn btn-outline-success" onclick="trialBalance()" id="trailBalanceButton">Refresh</button>                                            
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {{-- <h4 class="card-title mb-4">Trial Balance</h4> --}}
                    <div class="d-flex justify-content-between align-items-center mb-4">
                                <h4 class="card-title mb-0">Trial Balance</h4>
                                <div>
                                    <button type="button" class="btn btn-outline-success mb-3" onclick="remove_zero_balances();">Remove Zero Balances</button> 
                                </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered  dt-responsive w-100 fs-12 table-sm" id="TrialBalanceTable">
                            <thead>
                                <tr>
                                    <th class="text-start" colspan="8" id="business-name"></th>
                                </tr>
                                <tr>
                                    <th class="text-start" style="width: 30%;">Account Head</th>
                                    <th class="text-start" style="width: 10%;">Account Type</th>
                                    <th colspan=2 class="text-center" style="width: 20%;">Opening Balance</th>
                                    <th colspan=2 class="text-center" style="width: 20%;">Current Balance</th>
                                    <th colspan=2 class="text-center" style="width: 20%;">Net Balance</th>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td class="text-center">Debit</td>
                                    <td class="text-center">Credit</td>
                                    <td class="text-center">Debit</td>
                                    <td class="text-center">Credit</td>
                                    <td class="text-center">Debit</td>
                                    <td class="text-center">Credit</td>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated here via JavaScript -->
                                 @foreach($account_heads as $item)
                                    <tr data-row-id="{{$item->id_account_heads}}">
                                        <td class="text-start">{{ $item->account_head_number }} - {{ $item->account_head }}</td>
                                        <td class="text-start">{{ $item->account_main }}</td>
                                        <td class="text-center amount" data-ds-opening-debit  data-ds-account-number="{{$item->id_account_heads}}"></td>
                                        <td class="text-center amount" data-ds-opening-credit   data-ds-account-number="{{$item->id_account_heads}}"></td>
                                        <td class="text-center amount" data-ds-current-debit   data-ds-account-number="{{$item->id_account_heads}}"></td>
                                        <td class="text-center amount" data-ds-current-credit   data-ds-account-number="{{$item->id_account_heads}}"></td>
                                        <td class="text-center amount" data-ds-net-debit    data-ds-account-number="{{$item->id_account_heads}}"></td>
                                        <td class="text-center amount" data-ds-net-credit  data-ds-account-number="{{$item->id_account_heads}}"></td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td>Total</td>
                                    <td></td>
                                    <td data-ds-total-opening-debit >0.00</td>
                                    <td data-ds-total-opening-credit>0.00</td>
                                    <td data-ds-total-current-debit>0.00</td>
                                    <td data-ds-total-current-credit>0.00</td>
                                    <td data-ds-total-net-debit>0.00</td>
                                    <td data-ds-total-net-credit>0.00</td>
                                </tr>
                            </tfoot>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const start_date = document.getElementById("from_date").value;
        const end_date = document.getElementById("to_date").value;
        const id_business = document.getElementById("business").value; 
        $('.select-2').select2({
            width: '100%'
        }); 
        // Initial load
        trialBalance();
    });

    function trialBalance() {
        const start_date = document.getElementById("from_date").value;
        const end_date = document.getElementById("to_date").value;
        const business_id = document.getElementById("business").value;

        var sub_control_account_id = document.getElementById('sub_control_account')?.value || 0;
        var account_head_id = document.getElementById('account_head')?.value || 0;
        var business_partner_id = document.getElementById('business_partner')?.value || 0;
        var business_partner_type_id = document.getElementById('business_partner_type')?.value || 0;
        var cost_center_type = document.getElementById('cost_center_type')?.value || 0;
        var cost_center_name = document.getElementById('cost_center')?.value || 0;

        let url = "{{ route('accounts.trial_balance') }}" 
            + `?start_date=${start_date}`
            + `&end_date=${end_date}`
            + `&business_id=${business_id}`
            + `&sub_control_account_id=${sub_control_account_id}`
            + `&account_head_id=${account_head_id}`
            + `&business_partner_id=${business_partner_id}`
            + `&business_partner_type_id=${business_partner_type_id}`
            + `&cost_center_type=${cost_center_type}`
            + `&cost_center_name=${cost_center_name}`;

        // Implement the refresh logic here

         $("#trailBalanceButton").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span> Loading...`);
        fetch(url,{
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-Token': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
         $("#trailBalanceButton").html(`Refresh`);
            // console.log("Opening Balance Data:", data.opening_balance);
            // console.log("Current Balance Data:", data.current_balance);
            // Process and display the trial balance data as needed
            
            let totalOpeningDebit = 0, totalOpeningCredit = 0;
            let totalCurrentDebit = 0, totalCurrentCredit = 0;
            let totalNetDebit = 0, totalNetCredit = 0; 


            document.querySelectorAll("#TrialBalanceTable tbody tr").forEach(row => {
                if(account_head_id > 0 || sub_control_account_id  > 0){
                    row.classList.add("d-none");
                }
            });

            document.querySelectorAll("#TrialBalanceTable tbody .amount").forEach(cell => {
                cell.textContent = '0.00';
            }); 
            
            let activeIDs = [];

            data.opening_balance.forEach(item => {
                if (!activeIDs.includes(item.account_head_number)) {
                    activeIDs.push(item.account_head_number);
                }
            });
            data.current_balance.forEach(item => {
                if (!activeIDs.includes(item.account_head_number)) {
                    activeIDs.push(item.account_head_number);
                }
            });

            activeIDs.forEach(id => {
                let row = document.querySelector(`#TrialBalanceTable tbody tr[data-row-id='${id}']`);
                // if(account_head_id > 0 || sub_control_account_id  > 0){
                 if (row) row.classList.remove("d-none");
                // }
            });

            data.opening_balance.forEach(item => {
                debitElement = document.querySelector(`[data-ds-opening-debit][data-ds-account-number='${item.account_head_number}']`);
                creditElement = document.querySelector(`[data-ds-opening-credit][data-ds-account-number='${item.account_head_number}']`);

                let balance = parseFloat(item.balance) || 0;
                if (balance > 0) {                     
                    if (debitElement) {
                        creditElement.textContent = '0.00';       
                        debitElement.textContent = balance.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        totalOpeningDebit += balance;
                    }
                } else if (balance < 0) {
                                
                    if (creditElement) {
                        debitElement.textContent = '0.00';
                        creditElement.textContent = Math.abs(balance).toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        totalOpeningCredit += Math.abs(balance);
                    }
                } else {

                   if (debitElement) {
                    debitElement.textContent = '0.00';
                   } 

                   if (creditElement) {
                    creditElement.textContent = '0.00';
                   } 
                }
                
            });

            data.current_balance.forEach(item => {
                // console.log("Processing current balance item:", item);
                let debitElement = document.querySelector(`[data-ds-current-debit][data-ds-account-number='${item.account_head_number}']`);
                let creditElement = document.querySelector(`[data-ds-current-credit][data-ds-account-number='${item.account_head_number}']`);
                
                let balance = parseFloat(item.balance) || 0;
                if (balance > 0) {
                    if(debitElement) {
                        creditElement.textContent = '0.00';
                        debitElement.textContent = balance.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        totalCurrentDebit += balance;
                    }
                    
                } else if (balance < 0) {
                    if(creditElement) {
                        debitElement.textContent = '0.00';
                        creditElement.textContent = Math.abs(balance).toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                        totalCurrentCredit += Math.abs(balance);
                    }
                } else {

                    if(debitElement){
                        debitElement.textContent = '0.00';
                    }

                    if(creditElement){
                        creditElement.textContent = '0.00';
                    }
                }
                
            });
            // Calculate Net Balances
            document.querySelectorAll("#TrialBalanceTable tbody tr").forEach(row => {
                // console.log("Processing row:", row);
                let openingDebit = parseFloat(row.querySelector("[data-ds-opening-debit]").textContent.replace(/,/g, '')) || 0;
                let openingCredit = parseFloat(row.querySelector("[data-ds-opening-credit]").textContent.replace(/,/g, '')) || 0;
                let currentDebit = parseFloat(row.querySelector("[data-ds-current-debit]").textContent.replace(/,/g, '')) || 0;
                let currentCredit = parseFloat(row.querySelector("[data-ds-current-credit]").textContent.replace(/,/g, '')) || 0;

                let netDebit = (openingDebit + currentDebit) - (openingCredit + currentCredit);
                if (netDebit > 0) {
                    row.querySelector("[data-ds-net-debit]").textContent = netDebit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    row.querySelector("[data-ds-net-credit]").textContent = '0.00';
                    totalNetDebit += netDebit;
                } else if (netDebit < 0) {
                    row.querySelector("[data-ds-net-debit]").textContent = '0.00';
                    row.querySelector("[data-ds-net-credit]").textContent = Math.abs(netDebit).toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    totalNetCredit += Math.abs(netDebit);
                } else {
                    row.querySelector("[data-ds-net-debit]").textContent = '0.00';
                    row.querySelector("[data-ds-net-credit]").textContent = '0.00';
                }
            });
           
            // Write Totals
            // console.log("Appending totals row");
            document.querySelector("[data-ds-total-opening-debit]").textContent = totalOpeningDebit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            document.querySelector("[data-ds-total-opening-credit]").textContent = totalOpeningCredit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            document.querySelector("[data-ds-total-current-debit]").textContent = totalCurrentDebit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            document.querySelector("[data-ds-total-current-credit]").textContent = totalCurrentCredit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            document.querySelector("[data-ds-total-net-debit]").textContent = totalNetDebit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            document.querySelector("[data-ds-total-net-credit]").textContent = totalNetCredit.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            
            document.getElementById("business-name").textContent = data.business_name ? data.business_name : 'All Branches';
        })
        .catch(error => {
            $("#trailBalanceButton").html(`Refresh`);
            console.error("Error fetching trial balance data:", error);
        });

        table = $('#TrialBalanceTable').DataTable({
            destroy: true,
            paging: false,
            searching: true,
            info: false,
            ordering: false,
             "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
              
            },
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-light",
                   exportOptions: {
                    rows: function (idx, data, node) {
                        return !$(node).hasClass('d-none');
                    }
                    }
                 },
                { extend: "csv",   className: "btn btn-sm btn-light",
                   exportOptions: {
                    rows: function (idx, data, node) {
                        return !$(node).hasClass('d-none');
                    }
                    }
                 },
                { extend: "print", className: "btn btn-sm btn-light",
                   exportOptions: {
                    rows: function (idx, data, node) {
                        return !$(node).hasClass('d-none');
                    }
                    }
                 },
                { extend: "pdf", className: "btn btn-sm btn-light",
                   exportOptions: {
                    rows: function (idx, data, node) {
                        return !$(node).hasClass('d-none');
                    }
                    }
                }
            ],
            columnDefs: [
                { targets: [2,3,4,5,6,7], className: 'text-end' }
            ]
        });
    }

    function remove_zero_balances() {
        document.querySelectorAll("#TrialBalanceTable tbody tr").forEach(row => {
            let netDebit = parseFloat(row.querySelector("[data-ds-net-debit]").textContent.replace(',','')) || 0;
            let netCredit = parseFloat(row.querySelector("[data-ds-net-credit]").textContent.replace(',','')) || 0;
            if (netDebit === 0 && netCredit === 0) {
                row.classList.add("d-none");
            } else {
                row.classList.remove("d-none");
            }
        });
    } 

    function onchange_business_partner_type() {
            let mURL = '';
              const type = $('#business_partner_type option:selected').text();
            if (type === "Customers") {
                 mURL = "{{ route('customer_search') }}";
            } else if (type === "Staff") {
                mURL = "{{ route('staff.staff_search') }}";
            } else if (type === "Suppliers") {
                mURL = "{{ route('supplier.supplier_search') }}";
            } else if (type === "Franchise") {
                mURL = "{{ route('franchise.franchise_search') }}";
            } else {
                mURL = "{{ route('business.business_search') }}";
            }

            // Re-initialize Select2 with new URL
            $('#business_partner').empty(); // Clear previous selections
            initializeBusinessPartnerSelect2(mURL, $('#business_partner_type option:selected').text());
    }   
    function initializeBusinessPartnerSelect2(url, type) {
            $('#business_partner').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.text };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select ' + type ,
                width: '100%'
            });
    }
    
        function costcentertypechange() {
            var selectedText = $("#cost_center_type option:selected").text();
            var $div = $("#costCenterDiv");

            $div.empty(); 

            if (selectedText !== "Staff" && selectedText !== "Department") {
                $div.append(`
                    <label for="cost_center" class="form-label">Cost Center</label>
                    <input type="text" class="form-control" id="cost_center" name="cost_center_name" value="${selectedText =='All' ? '' :selectedText }" />
                `);
            } else {
                // Show select2
                $div.append(`
                    <label for="cost_center" class="form-label">Cost Center</label>
                    <select class="form-select select2" id="cost_center" name="cost_center_name"></select>
                `);

                var Route = '';
                if(selectedText == "Staff"){
                    Route = "{{ route('staff.staff_search') }}";
                    enable_costcenterstaff(Route);
                } else {
                    Route = "{{ route('service_department_search') }}";
                    enable_costcenterdepartments(Route);
                }
            }
        }


        function enable_costcenterstaff(url) {
            if ($('#cost_center').hasClass('select2-hidden-accessible')) {
                $('#cost_center').select2('destroy'); 
            }
            $('#cost_center').select2({
                        ajax: {
                            url: url,
                            dataType: 'json',
                            delay: 250,
                            data: function (params) {
                                return {
                                    term: params.term // search term
                                };
                            },
                            processResults: function (data) {
                                // Ensure 'data' is a valid array before returning
                                if (!data || typeof data !== 'object') {
                                    console.error('Invalid response for Select2:', data);
                                    return { results: [] };
                                }

                            return {
                                        results: data.map(function (item) {
                                            return { 
                                                id: item.text, 
                                                text: `${item.text} | ${item.staff_cell}` 
                                            };
                                        })
                                    };

                            },
                            cache: true
                        },
                        minimumInputLength: 3,
                        placeholder: 'Select Staff'  ,
                        width: '100%',
                    templateSelection: function (data, container) {
                            // This controls what is displayed in the input after selection
                            if (data.full_name && data.cell) {
                                return data.full_name + " | " + data.cell;
                            }
                            return data.text;
                        }
                    }); 
        }
        function enable_costcenterdepartments(url) {
            if ($('#cost_center').hasClass('select2-hidden-accessible')) {
                $('#cost_center').select2('destroy'); 
            }
            $('#cost_center').select2({
                        ajax: {
                            url: url,
                            dataType: 'json',
                            delay: 250,
                            data: function (params) {
                                return {
                                    term: params.term // search term
                                };
                            },
                            processResults: function (data) {
                                // Ensure 'data' is a valid array before returning
                                if (!data || typeof data !== 'object') {
                                    console.error('Invalid response for Select2:', data);
                                    return { results: [] };
                                }

                            return {
                                        results: data.map(function (item) {
                                            return { 
                                                id: item.text, 
                                                text: `${item.text}` 
                                            };
                                        })
                                    };

                            },
                            cache: true
                        },
                        minimumInputLength: 3,
                        placeholder: 'Select Department'  ,
                        width: '100%',
                    templateSelection: function (data, container) {
                            // This controls what is displayed in the input after selection
                            if (data.full_name && data.cell) {
                                return data.full_name + " | " + data.cell;
                            }
                            return data.text;
                        }
                    }); 
        }

    function change_sub_control_account(this_select_box){
        if($(this_select_box).val() > 0){
            $("#account_head").val("0").trigger("change");
            
        }
    }

    function change_account_head_account(this_select_box){
        if($(this_select_box).val() > 0){
        $("#sub_control_account").val("0").trigger("change");
        }
    }

    document.getElementById("btn_reset_filters").addEventListener("click", function () {
        // Select2 dropdown reset
        $('#sub_control_account').val("0").trigger("change");
        $('#account_head').val("0").trigger("change");
        
    });
</script>
@endsection