@extends('layouts.base', ['title' => 'Log In'])

@section('css')
@endsection

@section('content')

<div class="auth-bg d-flex min-vh-100">
    <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
        <div class="col-xxl-4 col-lg-5 col-md-6">
            <!-- <a href="{{ route('any', ['index'])}}" class="auth-brand d-flex justify-content-center mb-2">
                <img src="{{ asset('images/logo-dark.png') }}" alt="dark logo" height="26" class="logo-dark">
                <img src="{{ asset('images/logo.png') }}" alt="logo light" height="26" class="logo-light">
            </a> -->
            <a href="#" class="logo" style="font-family: raleway; line-height:35px !important;" ><span style="font-weight:600; font-size:40px !important; color: #9fb3b6 !important;">SKED</span><span style="font-weight:600; font-size:40px !important; color: #8d998a !important">WISE 2.0</span></a>                            
            <p class="fw-semibold mb-4 text-center text-muted fs-15">SCHEDULING / CRM / SCM / HRM / ACCOUNTING</p>

            <div class="card overflow-hidden text-center p-xxl-4 p-3 mb-0">

                <h4 class="fw-semibold mb-3 fs-18">Log in to your account</h4>

                <form action="{{ route('login.post') }}" method="post" class="text-start mb-3">
                    @csrf

                     @if ($errors->any())
                        <div class="alert alert-danger mt-2 mb-3">
                            @foreach ($errors->all() as $error)
                                <div style="color:red">{{ $error }}</div>
                            @endforeach
                        </div>
                    @endif

                    <div class="mb-3">                        
                        <input type="text" id="user-name" name="user_name" class="form-control"
                            placeholder="Enter your User Name">
                    </div>

                    <div class="mb-3">
                        
                        <input type="password" id="user-password" name="user_password" class="form-control"
                            placeholder="Enter your password">
                    </div>

                    <div class="d-flex justify-content-between mb-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="checkbox-signin">
                            <label class="form-check-label" for="checkbox-signin">Remember me</label>
                        </div>

                        <a href="{{ route ('second' , ['auth','reset-password']) }}" class="text-muted border-bottom border-dashed">Forget
                            Password</a>
                    </div>

                    <div class="d-grid">
                        <button class="btn fw-semibold" style="background-color: #8d998a; color:#ffffff;" type="submit">Login</button>
                    </div>
                   


                </form>

                <!-- <p class="text-muted fs-14 mb-0">Don't have an account?
                    <a href="{{ route ('second' , ['auth','register']) }}" class="fw-semibold text-danger ms-1">Sign Up !</a>
                </p> -->

            </div>
            <p class="mt-4 text-center mb-0">
                <script>
                    document.write(new Date().getFullYear())
                </script> © Skedwise - By <span
                    class="fw-bold text-decoration-underline text-uppercase text-reset fs-12"><a target="_blank" href="https://www.mexyon.com">Mexyon</a></span>
            </p>
        </div>
    </div>
</div>

@endsection

@section('scripts')

@endsection
