@extends('layouts.horizontal', ['title' => 'Staff Block Time Reasons', 'topbarTitle' => 'Staff Block Time Reasons'])

@section('css')
@vite([
    'node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css'
])
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Staff Block Time Reasons</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="block_events_table" class="table table-bordered dt-responsive fs-13 w-100">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Block Event Name</th>
                                <th>Description</th>
                                <th class="noprint">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($blockEvents as $e)
                                <tr>
                                    <td>{{ $e->id_block_events }}</td>
                                    <td>{{ $e->block_event_name }}</td>
                                    <td>{{ $e->block_event_desc }}</td>
                                    <td>
                                        <button
                                            onclick="openEditBlockEventModal({{ $e->id_block_events }})"
                                            class="btn btn-sm btn-ghost-info me-2 rounded-circle btn-icon edit-block-event-btn"
                                            data-id="{{ $e->id_block_events }}"
                                            data-block_event_name="{{ $e->block_event_name }}"
                                            data-block_event_desc="{{ $e->block_event_desc }}"
                                        >
                                            <iconify-icon icon="line-md:edit-twotone" class="fs-22"></iconify-icon>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Add/Edit Modal --}}
<div class="modal fade" id="blockEventModal" tabindex="-1" aria-labelledby="blockEventModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="blockEventModalLabel"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="blockEventModalForm">
                @csrf
                <div class="modal-body">
                    <input type="hidden" id="id_block_events" name="id_block_events">

                    <div class="mb-3">
                        <label for="block_event_name" class="form-label">Block Event Name</label>
                        <input type="text" class="form-control" id="block_event_name" name="block_event_name" required>
                    </div>

                    <div class="mb-3">
                        <label for="block_event_desc" class="form-label">Description</label>
                        <textarea class="form-control" id="block_event_desc" name="block_event_desc" rows="3" required></textarea>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" onclick="save_block_event()" class="btn btn-primary" id="saveBlockEventBtn">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- End Modal --}}
@endsection

@section('scripts')
<script>
    let blockEventsTable;

    $(document).ready(function() {
        initBlockEventsTable();
    });

    function initBlockEventsTable() {
        if ($.fn.DataTable.isDataTable('#block_events_table')) {
            $('#block_events_table').DataTable().clear().destroy();
        }

        blockEventsTable = $('#block_events_table').DataTable({
            responsive: true,
            fixedHeader: true,
            lengthChange: true,
            pageLength: 10,
            searching: true,
            info: true,
            paging: true,
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf",   className: "btn btn-sm btn-soft-primary" }
            ],
            layout: {
                topStart: "buttons",
                topEnd: function() {
                    // Return a flex container with search input and button
                    return '<div class="d-flex align-items-center gap-2" style="justify-content: flex-end; width: 100%;"><label class="dataTables_filter" style="margin: 0;"><input type="search" class="form-control form-control-sm" placeholder="Search..." aria-controls="block_events_table" id="block_events_table_search"></label><button class="btn btn-sm btn-outline-success" id="addBlockEventBtn" onclick="openAddBlockEventModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Add Reason</button></div>';
                },
                bottomStart: {
                    pageLength: { menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]] },
                    info: {}
                },
                bottomEnd: "paging"
            },
            initComplete: function(settings) {
                // Manually wire up the search input to DataTables
                var searchInput = $('#block_events_table_search');
                if (searchInput.length) {
                    searchInput.on('keyup', function() {
                        blockEventsTable.search(this.value).draw();
                    });
                }
            }
        });
    }

    function reloadBlockEventsTable() {
        $.ajax({
            url: window.location.href,
            type: 'GET',
            success: function(response) {
                const $newContent = $(response);
                const $newTableBody = $newContent.find('#block_events_table tbody');
                const $newTable = $newContent.find('#block_events_table');
                
                if ($newTableBody.length && $newTable.length) {
                    $('#block_events_table tbody').html($newTableBody.html());
                    initBlockEventsTable();
                } else {
                    window.location.reload();
                }
            },
            error: function() {
                window.location.reload();
            }
        });
    }

    function openAddBlockEventModal() {
        $('#id_block_events').val('');
        $('#block_event_name').val('');
        $('#block_event_desc').val('');

        $('#blockEventModalLabel').text('Add Reason');

        let el = document.getElementById('blockEventModal');
        let modal = bootstrap.Modal.getInstance(el);
        if (!modal) modal = new bootstrap.Modal(el);
        modal.show();
    }

    function openEditBlockEventModal(id) {
        let button = $('.edit-block-event-btn[data-id="' + id + '"]');

        $('#id_block_events').val(button.data('id'));
        $('#block_event_name').val(button.data('block_event_name'));
        $('#block_event_desc').val(button.data('block_event_desc'));

        $('#blockEventModalLabel').text('Edit Reason');

        let el = document.getElementById('blockEventModal');
        let modal = bootstrap.Modal.getInstance(el);
        if (!modal) modal = new bootstrap.Modal(el);
        modal.show();
    }

    function save_block_event() {
        if ($('#block_event_name').val().trim() === '') {
            toastr.warning('Block event name is required.');
            return;
        }
        if ($('#block_event_desc').val().trim() === '') {
            toastr.warning('Description is required.');
            return;
        }

        $('#saveBlockEventBtn').prop('disabled', true);

        $.ajax({
            url: '{{ route("block_events.save_or_update") }}',
            method: 'POST',
            data: $('#blockEventModalForm').serialize(),
            success: function(res) {
                $('#saveBlockEventBtn').prop('disabled', false);
                if (res.success) {
                    toastr.success(res.message);
                    $('#blockEventModal').modal('hide');
                    reloadBlockEventsTable();
                } else {
                    toastr.error(res.message || 'Failed to save reason');
                }
            },
            error: function(xhr) {
                $('#saveBlockEventBtn').prop('disabled', false);
                toastr.error('Failed to save reason: ' + xhr.responseText);
            }
        });
    }
</script>
@endsection
