@extends('layouts.horizontal', ['title' => 'Branches', 'topbarTitle' => 'Branches'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

<div class="branches">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Branches</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 table-responsive">
                            <table id="branches-table" class="table table-hover w-100">
                                <thead>
                                    <tr>
                                        <th>Section</th>
                                        <th>ID</th>
                                        <th>Logo</th>
                                        <th>Branch Name</th>
                                        <th>Address</th>
                                        <th class="text-start">Phone</th>
                                        <th>Owner</th>
                                        <th>HO</th>
                                        <th class="text-end">Revenue</th>
                                        <th class="text-end">Expenses</th>
                                        <th class="text-end">Profit</th>
                                        <th>Last Closing</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branches as $branch)
                                    <tr data-branch-id="{{ $branch->id_business }}">
                                        <td>{{ $branch->business_type }}</td>
                                        <td>{{ $branch->id_business }}</td>
                                        <td>
                                            @if($branch->business_logo)
                                                <img onclick="openImageModal({{ $branch->id_business }});" src="{{ asset('images/business/' . $branch->business_logo) }}" alt="Branch Logo" style="height: 40px; cursor: pointer;">
                                            @else
                                                <span style="cursor: pointer;" class="text-muted" onclick="openImageModal({{ $branch->id_business }});">No Logo</span>
                                            @endif
                                        </td>
                                        <td>{{ $branch->business_name }}</td>
                                        <td>{!! $branch->business_address !!}</td>
                                        <td class="text-start">{{ $branch->business_phone1 }}</td>
                                        <td>{{ $branch->business_owner }}</td>
                                        <td><label class="badge badge-outline-{{ $branch->ho == 'Yes' ? 'success' : 'danger' }}">{{ $branch->ho }}</label></td>
                                        <td class="text-end revenue" data-branch-id="{{ $branch->id_business }}">-</td>
                                        <td class="text-end expenses" data-branch-id="{{ $branch->id_business }}">-</td>
                                        <td class="text-end profit" data-branch-id="{{ $branch->id_business }}">-</td>
                                        <td class="last-closing" data-branch-id="{{ $branch->id_business }}">-</td>
                                        <td>
                                            <iconify-icon onclick="openBranchModal({{ $branch->id_business }})" icon="line-md:edit-twotone" class="fs-20 me-2" data-bs-toggle="tooltip" data-placement="top" title="Edit" style="cursor: pointer;"></iconify-icon>
                                            <iconify-icon onclick="openSettingsModal({{ $branch->id_business }})" icon="line-md:cog-filled-loop" class="fs-20 me-2" data-bs-toggle="tooltip" data-placement="top" title="Settings" style="cursor: pointer;"></iconify-icon>
                                            <iconify-icon onclick="openModuleModal('{{ $branch->loyalty_enable }}', '{{ $branch->receipts_installed }}', '{{ $branch->referal_installed }}', '{{ $branch->hrm_installed }}', '{{ $branch->coaching }}')" icon="fa6-solid:users-gear" class="fs-20 me-2" data-bs-toggle="tooltip" data-placement="top" title="Add-On Modules" style="cursor: pointer;"></iconify-icon>
                                            @can('view_tax_settings')
                                                <iconify-icon onclick="window.location.href='{{ route('tax-settings.index', ['business_id' => $branch->id_business]) }}'" icon="wpf:coins" class="fs-20 me-2" data-bs-toggle="tooltip" data-placement="top" title="Tax Settings" style="cursor: pointer;"></iconify-icon>
                                            @endcan
                                            @can('view_branch_targets')
                                                <iconify-icon onclick="window.location.href='{{ route('branch-targets.index') }}'" icon="streamline:target-solid" class="fs-20" data-bs-toggle="tooltip" data-placement="top" title="Branch Targets" style="cursor: pointer;"></iconify-icon>
                                            @endcan
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div> <!-- end row-->

    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Branch Comparison Chart</h4>
                    <div id="branch_comparison_chart" class="apex-charts" dir="ltr"></div>
                </div>
                <!-- end card body-->
            </div>
            <!-- end card -->
        </div>
        
    </div>

</div> <!-- end Branches-->

{{-- Modal for Business image upload using Dropzone --}}
    <div class="modal fade" id="ImageModal" tabindex="-1" aria-labelledby="ImageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                        <h5 class="modal-title" id="ImageModalLabel">Select or Upload Image</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="businessDropzone" class="dropzone"
                    data-action="{{ route('business.uploadimage') }}"
                    data-preview-base="{{ asset('images/business') }}">
                    @csrf
                    <div class="modal-body">
                        <h6>Choose Existing Image:</h6>
                        <input type="hidden" id="image_id" name="id_business">
                        <div id="existingImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                            <!-- Existing images will be loaded here -->
                        </div>
                        
                        <input type="hidden" id="existing_image" name="existing_image">
                        <h6>Or Upload New Image:</h6>
                        <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                        <div class="dz-message needsclick">
                            <i class="ti ti-cloud-upload h1 text-muted"></i>
                            <h3>Drop files here or click to upload.</h3>
                            <span class="text-muted fs-13">(This is your dropzone. Selected files are
                            <strong>stored</strong> on the server.)</span>
                        </div>
                        <input type="hidden" name="business_image" id="business_image">
                        <div id="selectedBusinessPreview" class="mt-3"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
{{-- End of Modal --}}
{{--Edit Business Modal--}}
    <div class="modal fade" id="businessEditModal" tabindex="-1" aria-labelledby="businessEditModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                        <h5 class="modal-title" id="businessEditModalLabel">Edit Branch Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="businessEditForm" method="POST" action="#">
                            @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    
                                    <label for="business_type_id" class="form-label">Business Section</label>
                                    <select class="form-select mb-3" id="business_type_id" name="business_type_id">
                                        <option value="">Select Section</option>
                                        @foreach($business_types as $type)
                                            <option value="{{ $type->id_business_type }}">{{ $type->business_type }}</option>
                                        @endforeach
                                    </select>

                                    <label for="business_name" class="form-label">Business Name</label>
                                    <input type="text" class="form-control mb-3" id="business_name" name="business_name" required>
                                
                                    <label for="business_phone1" class="form-label">Phone 1</label>
                                    <input type="text" class="form-control mb-3" id="business_phone1" name="business_phone1" required>

                                    <label for="business_phone3" class="form-label">Phone 3</label>
                                    <input type="text" class="form-control mb-3" id="business_phone3" name="business_phone3">
                                    
                                    <label for="business_email" class="form-label">Email</label>
                                    <input type="email" class="form-control" id="business_email" name="business_email">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="id_business" class="form-label">Business ID</label>
                                    <input type="text" readonly class="form-control mb-3" id="id_business" name="id_business" required>

                                    <label for="business_owner" class="form-label">Business Owner</label>
                                    <input type="text" class="form-control mb-3" id="business_owner" name="business_owner" required>

                                    <label for="business_phone2" class="form-label">Phone 2</label>
                                    <input type="text" class="form-control mb-3" id="business_phone2" name="business_phone2">
                                
                                
                                    <label for="business_phone4" class="form-label">Phone 4</label>
                                    <input type="text" class="form-control mb-3" id="business_phone4" name="business_phone4">
                                
                                    <label for="business_area" class="form-label">Area</label>
                                    <input type="text" class="form-control" id="business_area" name="business_area">                                
                                    
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="business_owner_contact" class="form-label">Owner Contact</label>
                                        <input type="text" class="form-control" id="business_owner_contact" name="business_owner_contact">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="ho" class="form-label">Head Office (HO)</label>
                                        <select disabled="disabled" class="form-select" id="ho" name="ho">
                                            <option value="Yes">Yes</option>
                                            <option value="No">No</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="common_services" class="form-label">Common Services</label>
                                        <select {{ session('user_role') != 'Super User' ? 'disabled="disabled"' : '' }} class="form-select" id="common_services" name="common_services">
                                            <option value="Yes">Yes</option>
                                            <option value="No">No</option>
                                        </select>                                    
                                    </div>
                                    <div class="col-md-6">
                                        <label for="common_products" class="form-label">Common Products</label>
                                        <select {{ session('user_role') != 'Super User' ? 'disabled="disabled"' : '' }} class="form-select" id="common_products" name="common_products">
                                            <option value="Yes">Yes</option>
                                            <option value="No">No</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label for="business_address" class="form-label">Business Address</label>
                                    <textarea class="form-control mb-3" id="business_address" name="business_address" rows="3"></textarea>
                                </div>
                                <div class="col-md-12">
                                    <label for="payment_terms" class="form-label">Payment Terms</label>
                                    <textarea class="form-control" id="payment_terms" name="payment_terms" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button onclick="saveBranchChanges()" type="button" class="btn btn-primary">Save Changes</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        </div>
                </form>
            </div>
        </div>
    </div>

{{--End of Modal--}}

{{--Branch Settings Modal--}}
<div class="modal fade" id="businessSettingsModal" tabindex="-1" aria-labelledby="businessSettingsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header">
                    <h5 class="modal-title" id="businessSettingsModalLabel">Branch Operation Settings</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>            
            <div class="modal-body">
                <form id="businessSettingsForm" method="POST" action="#">
                    @csrf    
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <input type="hidden" id="settings_business_id" name="id_business">
                                    <label for="settings_business_name">Branch Name</label>
                                    <input type="text" class="form-control" id="settings_business_name" name="business_name">
                                </div>
                                <div class="col-md-3">
                                    <label for="business_opening_time">Opening Time</label>
                                    <input type="time" class="form-control" id="business_opening_time" name="business_opening_time">
                                </div>
                                <div class="col-md-3">
                                    <label for="business_closing_time">Closing Time</label>
                                    <input type="time" class="form-control" id="business_closing_time" name="business_closing_time">
                                </div>
                            </div>                                
                            <div class="row mb-3">
                                <h4>Sales Settings</h4>
                                <div class="col-md-3">
                                    <label for="tax_optional">Tax Enabled</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="tax_optional" name="tax_optional">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="rec_allow_prev">Historical Data</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="rec_allow_prev" name="rec_allow_prev">
                                        <option value="Y">Yes</option>
                                        <option value="N">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="show_cash_reg">Show Cash Register</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="show_cash_reg" name="show_cash_reg">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="allow_balance">Allow Balance</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="allow_balance" name="allow_balance">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>                                       
                            </div>
                            
                            <div class="row mb-3">
                                <h4>Financial Settings</h4>                                                    
                                <div class="col-md-3">
                                    <label for="backdated_invoice">Backdated Invoice</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="backdated_invoice" name="backdated_invoice">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="cancel_advance">Cancel Advance</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="allow_cancel_advance" name="allow_cancel_advance">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="invoiced_drag">Edit Paid Invoice</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="invoiced_drag" name="invoiced_drag">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="allow_invoice_cancel">Cancel Invoice</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select" id="allow_invoice_cancel" name="allow_invoice_cancel">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="cc_charge">Credit Card Fee</label>
                                    <input {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-control" type="number" step="0.01" id="cc_charge" name="cc_charge" placeholder="e.g., 2.5">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <h4>Inventory Settings</h4>
                                <div class="col-md-3">
                                    <label for="allow_price_update">Allow Price Update</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' || session('user_role') == 'Admin' ? '' : 'disabled' }} class="form-select" id="allow_price_update" name="allow_price_update">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                            <div class="col-md-3">
                                    <label for="allow_stock_update">Allow Stock Update</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' || session('user_role') == 'Admin' ? '' : 'disabled' }} class="form-select" id="allow_stock_update" name="allow_stock_update">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                
                                <div class="col-md-3">
                                    <label for="show_professional">Sell Professional</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' || session('user_role') == 'Admin' ? '' : 'disabled' }} class="form-select" id="show_professional" name="show_professional">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                            </div>                       
                            <div class="row mb-3">
                                <h4>Visits & Appointments Settings</h4>
                                <div class="col-md-3">
                                    <label for="allow_visit_cancel">Cancel Visit</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' || session('user_role') == 'Admin' ? '' : 'disabled' }} class="form-select" id="allow_visit_cancel" name="allow_visit_cancel">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>                            
                                <div class="col-md-3">
                                    <label for="allow_visit_move">Move Visit</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' || session('user_role') == 'Admin' ? '' : 'disabled' }} class="form-select" id="allow_visit_move" name="allow_visit_move">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                
                            </div>
                        </div>
                        <div class="col-md-4 border-start ps-4">                               
                            <div class="row">
                                <h4>Modules</h4>
                                <div class="col-md-12 modules" id="hrm_div">
                                    <label for="hrm_installed">HRM - Payroll Enabled</label>
                                    <select disabled="disabled" class="form-select mb-3" id="hrm_installed" name="hrm_installed">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                    <div class="alert alert-success p-3">
                                        <h4>Detailed Payroll / Attendance  / Human Resource Management!</h4>
                                            <p>
                                            Enable this module to manage employee payroll, attendance, and other HR functions directly from the branch settings.
                                            This module provides tools for tracking employee hours, calculating salaries, and managing leave requests.
                                            It is Integrated with SkedWise Accounting Module for seamless Staff Loans and other financial management.
                                            <hr>
                                            Disabling this module will hide all HRM-related features from the branch interface.
                                            </p>
                                    </div>
                                </div>
                                <div class="col-md-12 modules" id="loyalty_sms_div">
                                    <label for="loyalty_sms">Loyalty / SMS Enabled</label>
                                    <select {{ session('user_role') == 'Super User' ? '' : 'disabled' }} class="form-select mb-3" id="loyalty_sms" name="loyalty_sms">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                    <div class="alert alert-warning p-3">
                                        <h4>Loyalty / SMS / Scheduled Notifications / Bulk Advertisments!</h4>
                                            <p>
                                            Enable this module to manage SMS notifications, scheduled messages, and bulk messaging directly from the branch settings.
                                            This module provides tools for creating and sending SMS campaigns, scheduling messages, and managing contact lists.
                                            <hr>
                                            Disabling this module will disable all SMS-related features from the branch interface.
                                            </p>
                                    </div>
                                </div>
                                <div class="col-md-12 modules" id="flexi_pricing_div">
                                    <label for="flexi_pricing_enabled">Flexi-Pricing Enabled</label>
                                    <select {{ session('user_role') == 'Super User' || session('user_role') == 'Super Admin' ? '' : 'disabled' }} class="form-select mb-3" id="flexi_pricing_enabled" name="flexi_pricing_enabled">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                    <div class="alert alert-primary p-3">
                                        <h4>Flexi-Pricing Module</h4>
                                            <p>
                                            Enable dynamic pricing based on booking capacity. Configure flexible pricing bands that offer discounts based on day of week, time slots, and booking capacity percentage.
                                            This module allows you to incentivize bookings during slower periods and optimize revenue.
                                            <hr>
                                            Disabling this module will hide all flexi-pricing features from the booking interface.
                                            </p>
                                    </div>
                                </div>
                                <div class="col-md-12 modules" id="receipts_installed_div">
                                    <label for="receipts_installed">Digital Receipts Enabled</label>
                                    <select {{ session('user_role') == 'Super User' ? '' : 'disabled' }} class="form-select mb-3" id="receipts_installed" name="receipts_installed">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                    <div class="alert alert-info p-3">
                                        <h4>Digital Receipts</h4>
                                            <p>
                                            An Add-on for sending digital receipts to Customer Phones.
                                            Go Paperless and save the environment.
                                            This module provides tools for sending receipts via SMS directly from the POS interface.
                                            <hr>
                                            Check details on <a href="https://receipt.mexyon.com" target="_blank">https://receipt.mexyon.com</a>
                                            </p>
                                    </div>
                                </div>
                                <div class="col-md-12 modules" id="referral_installed_div">
                                    <label for="referral_installed">Referral Program Enabled</label>
                                    <select {{ session('user_role') == 'Super User' ? '' : 'disabled' }} class="form-select mb-3" id="referral_installed" name="referral_installed">
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                    <div class="alert alert-success p-3">
                                        <h4>Referral Program</h4>
                                            <p>
                                            Let your customers be your advocates!<br>
                                            Encourage your customers to refer new clients and grow your business.
                                            This module provides tools for tracking referrals and managing rewards.
                                            <hr>
                                            Check details on <a href="https://referral.mexyon.com/" target="_blank">https://referral.mexyon.com/</a>
                                            </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>                    
            <div class="modal-footer">
                <button type="button" onclick="saveBusinessSettings();" class="btn btn-primary">Save Changes</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

{{--End Branch Settings Modal--}}

{{--Finance Modal--}}

<div class="modal fade" id="financeModal" tabindex="-1" aria-labelledby="financeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="financeModalLabel">Branch Add-Ons Implementation</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>            
            <div class="modal-body">

                <p>Click on the Module to View Features &amp; Benefits.</p>
                <ol class="list-group list-group-numbered" id="modules">
                    
                </ol>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
{{--End Finance Modal--}}

@endsection

@section('scripts')

<script>
    // Pass currency from PHP config to JavaScript
    window.CURRENCY_SYMBOL = '{{ config("constants.CURRENCY", "$") }}';
    // Use relative paths (empty string works with subdirectories)
    window.BASE_URL = '{{ url("") }}';
    
    $(document).ready(function() {
        // Load branch financial data
        loadBranchFinancialData();
        
        render_branch_comparison_chart();
        // Initialize DataTable
        // var table = $('#branches-table').DataTable({
        //     responsive: true,
        //     // Add any additional DataTable options here
        // });

        // Initialize Dropzone for Business Image Upload
          let businessDropzone = new Dropzone("#businessDropzone", {
               url: document.getElementById('businessDropzone').dataset.action, 
               paramName: "file", // field name sent to server
               maxFilesize: 2, // MB
               acceptedFiles: ".jpg,.jpeg,.png,.gif",
               addRemoveLinks: true,
               dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
               `,
               init: function () {
                    this.on("success", function (file, response) {
                         // Save filename into hidden input
                         document.getElementById('business_image').value = response.filename;

                         // Show preview
                         document.getElementById('selectedBusinessPreview').innerHTML =
                              `<img src="${document.getElementById('businessDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                    });

                    this.on("error", function (file, errorMessage) {
                         console.error("Dropzone upload error:", errorMessage);
                    });
               }
          });

        // Initialize tooltips
       // Initialize all tooltips on the page
        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
        const tooltipList = [...tooltipTriggerList].map(el => new bootstrap.Tooltip(el));

        // Close tooltip on click anywhere in document
        document.addEventListener('click', (e) => {
            tooltipList.forEach(t => t.hide());
        });

        // Close tooltip on scroll
        window.addEventListener('scroll', () => {
            tooltipList.forEach(t => t.hide());
        });

        document.getElementById('ImageModal').addEventListener('show.bs.modal', function () {            
        // Load existing images via AJAX
        fetch("{{ route('business.existing_images') }}")
            .then(res => {
                        if (!res.ok) throw new Error("Network response was not ok " + res.statusText);
                        return res.json();
                })
            .then(images => {
                //console.log(images); // For debugging
                const existingImagesContainer = document.getElementById('existingImages');
                existingImagesContainer.innerHTML = ''; // Clear previous images

                let container = document.getElementById('existingImages');
                container.innerHTML = "";

                if (!images.length) {
                    container.innerHTML = "<p class='text-muted '>No images found</p>";
                    return;
                }
                images.forEach(url => {
                    let filename = url.split('/').pop();
                    let img = document.createElement('img');
                    img.src = url;
                    img.dataset.filename = filename;
                    img.style.width = "150px";
                    img.style.height = "50px";
                    img.style.objectFit = "cover";
                    img.style.cursor = "pointer";
                    img.classList.add("border", "rounded", "m-1");

                    img.addEventListener('click', function() {
                        document.querySelectorAll('#existingImages img').forEach(i => i.style.border = "1px solid #ddd");
                        this.style.border = "3px solid blue";

                        document.getElementById('existing_image').value = this.dataset.filename;
                        document.getElementById('selectedBusinessPreview').innerHTML = 
                            `<img src="${url}" width="120" class="border rounded">`;
                    });
                    container.appendChild(img);
                });
            })
            .catch(error => console.error('Error fetching existing images:', error));
        });
        // Submit Business Image form via AJAX
        document.getElementById('businessDropzone').addEventListener('submit', function(e) {
            e.preventDefault();
            let formData = new FormData(this);

            fetch("{{ route('business.update_image') }}", {
                method: "POST",
                headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if(data.success) {                    
                    window.location.reload();
                }
            });
        });
    });

    function openImageModal(business_id) {
       // Set the image URL in the hidden input field
        document.getElementById('business_image').value = '';
        document.getElementById('existing_image').value = '';
        
        document.getElementById('selectedBusinessPreview').innerHTML = '';
        document.getElementById('image_id').value = business_id;

        const imageModal = new bootstrap.Modal(document.getElementById('ImageModal'));
        imageModal.show();
    }

    function openBranchModal(business_id) {
       // console.log("Opening branch modal for business ID:", business_id);
        // Fetch branch details via AJAX and populate the form
        fetch(`{{ url('/business/get_branch') }}/${business_id}`)

            .then(res => res.json())
            .then(data => {
                document.getElementById('business_type_id').value = data.business_type_id;
                document.getElementById('id_business').value = data.id_business;
                document.getElementById('business_name').value = data.business_name;
                document.getElementById('business_owner').value = data.business_owner;
                document.getElementById('business_address').value = data.business_address;
                document.getElementById('business_phone1').value = data.business_phone1;
                document.getElementById('business_phone2').value = data.business_phone2;
                document.getElementById('business_email').value = data.business_email;
                document.getElementById('payment_terms').value = data.payment_terms;
                document.getElementById('business_phone3').value = data.business_phone3;
                document.getElementById('business_phone4').value = data.business_phone4;
                document.getElementById('business_area').value = data.business_area;
                document.getElementById('business_owner_contact').value = data.business_owner_contact;
                document.getElementById('ho').value = data.ho;
                document.getElementById('common_services').value = data.common_services;
                document.getElementById('common_products').value = data.common_products;

                // Update form action URL
                let url = "{{ url('/business/update') }}";
                document.getElementById('businessEditForm').action = url;

                const businessEditModal = new bootstrap.Modal(document.getElementById('businessEditModal'));
                businessEditModal.show();
            })
            .catch(error => console.error('Error:', error));
    }

    function openSettingsModal(business_id) {
        console.log("Opening settings modal for business ID:", business_id);
        // Fetch branch details via AJAX and populate the form
        fetch(`{{ url('/business/get_branch') }}/${business_id}`)

            .then(res => res.json())
            .then(data => {
                document.getElementById('business_name').value = data.business_name;
                
                // Update form action URL
                let url = "{{ url('/business/update_settings') }}";
                document.getElementById('businessSettingsForm').action = url;

                document.getElementById('settings_business_id').value = data.id_business;
                document.getElementById('settings_business_name').value = data.business_name;
                document.getElementById('business_opening_time').value = data.business_opening_time;
                document.getElementById('business_closing_time').value = data.business_closing_time;
                document.getElementById('tax_optional').value = data.tax_optional;
                document.getElementById('rec_allow_prev').value = data.rec_allow_prev;
                document.getElementById('show_cash_reg').value = data.show_cash_reg;
                document.getElementById('allow_balance').value = data.allow_balance;
                document.getElementById('backdated_invoice').value = data.backdated_invoice;
                document.getElementById('invoiced_drag').value = data.invoiced_drag;
                document.getElementById('allow_invoice_cancel').value = data.allow_invoice_cancel;
                document.getElementById('cc_charge').value = data.cc_charge;
                document.getElementById('allow_price_update').value = data.allow_price_update;
                document.getElementById('allow_stock_update').value = data.allow_stock_update;
                document.getElementById('show_professional').value = data.show_professional;
                document.getElementById('allow_visit_cancel').value = data.allow_visit_cancel;
                document.getElementById('allow_visit_move').value = data.allow_visit_move;
                document.getElementById('allow_cancel_advance').value = data.allow_cancel_advance;

                document.getElementById('hrm_installed').value = data.hrm_installed;
                document.getElementById('loyalty_sms').value = data.loyalty_sms;   
                document.getElementById('receipts_installed').value = data.receipts_installed;
                document.getElementById('referral_installed').value = data.referral_installed;
                document.getElementById('flexi_pricing_enabled').value = data.flexi_pricing_enabled || 'No';

                Array.from(document.getElementsByClassName('modules')).forEach(function(element) {
                    element.style.display = 'none'; // Hide all module sections initially
                });

                // Always show flexi-pricing (it's a feature toggle, not an installed module)
                document.getElementById('flexi_pricing_div').style.display = 'block';

                if(data.referral_installed === 'Yes'){
                    document.getElementById('referral_installed_div').style.display = 'none';
                    // If Referral is enabled, hide all other modules
                    if(data.receipts_installed === 'Yes'){
                        document.getElementById('receipts_installed_div').style.display = 'none';
                        if(data.loyalty_sms === 'Yes'){
                            document.getElementById('loyalty_sms_div').style.display = 'none';
                            if(data.hrm_installed === 'Yes'){
                                document.getElementById('hrm_div').style.display = 'none';
                            } else {                    
                                document.getElementById('hrm_div').style.display = 'block';
                            }
                        } else {                    
                            document.getElementById('loyalty_sms_div').style.display = 'block';                        
                        }  
                    } else {                    
                        document.getElementById('receipts_installed_div').style.display = 'block';
                    
                    }
                } else {
                    document.getElementById('referral_installed_div').style.display = 'block';
                    // Show other modules based on their individual settings
                }
                
                // Ensure flexi-pricing is always visible (it's a feature toggle)
                document.getElementById('flexi_pricing_div').style.display = 'block';

                  
                const businessSettingsModal = new bootstrap.Modal(document.getElementById('businessSettingsModal'));
                businessSettingsModal.show();
            })
            .catch(error => console.error('Error:', error));
    }

    function saveBranchChanges(){
        const form = document.getElementById('businessEditForm');
        const formData = new FormData(form);

        fetch(form.action, {
            method: 'POST',
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal and reload page or update table row
                const businessEditModal = bootstrap.Modal.getInstance(document.getElementById('businessEditModal'));
                businessEditModal.hide();
                location.reload(); // Reload to see changes
            } else {
                toastr('Error saving changes', 'error');
            }
        })
        .catch(error => console.error('Error:', error));
    }

    function saveBusinessSettings(){
        const formData = new FormData(document.getElementById('businessSettingsForm'));
        fetch(document.getElementById('businessSettingsForm').action, {
            method: 'POST',
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal and reload page or update table row
                const businessSettingsModal = bootstrap.Modal.getInstance(document.getElementById('businessSettingsModal'));
                businessSettingsModal.hide();
                location.reload(); // Reload to see changes
            } else {
                toastr('Error saving changes', 'error');
            }
        })
        .catch(error => console.error('Error:', error));
    }

    function openModuleModal(le, ri, fi, hrmi, ci){

        let loyalty_enable = le;
        let receipts_installed = ri;
        let referal_installed = fi;
        let hrm_installed = hrmi;
        let coaching = ci;

        let html = `<li class="list-group-item d-flex justify-content-between align-items-start ms-2">
                        <a href="#" class="${loyalty_enable == 'Yes'  ? 'text-dark' : 'text-muted'}" target="_blank">Loyalty Program</a>
                        <span class="badge ${loyalty_enable == 'Yes'  ? 'bg-success' : 'bg-danger'} rounded-pill">${loyalty_enable == 'Yes' ? 'Active' : 'InActive'}</span>   
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-start ms-2">
                        <a href="#" class="${receipts_installed == 'Yes'  ? 'text-dark' : 'text-muted'}" target="_blank">Digital Receipts</a>
                        <span class="badge ${receipts_installed == 'Yes'  ? 'bg-success' : 'bg-danger'} rounded-pill">${receipts_installed == 'Yes' ? 'Active' : 'InActive'}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-start ms-2">
                        <a href="#" class="${referal_installed == 'Yes'  ? 'text-dark' : 'text-muted'}" target="_blank">Friend Referal System</a>
                        <span class="badge ${referal_installed == 'Yes'  ? 'bg-success' : 'bg-danger'} rounded-pill">${referal_installed == 'Yes' ? 'Active' : 'InActive'}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-start ms-2">
                        <a href="#" class="${hrm_installed == 'Yes'  ? 'text-dark' : 'text-muted'}" target="_blank">HRM / Pay-Roll System</a>
                        <span class="badge ${hrm_installed == 'Yes'  ? 'bg-success' : 'bg-danger'} rounded-pill">${hrm_installed == 'Yes' ? 'Active' : 'InActive'}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-start ms-2">
                        <a href="#" class="${coaching == 'Yes'  ? 'text-dark' : 'text-muted'}" target="_blank">Coaching Classes Module</a>
                        <span class="badge ${coaching == 'Yes'  ? 'bg-success' : 'bg-danger'} rounded-pill">${coaching == 'Yes' ? 'Active' : 'InActive'}</span>
                    </li>
                    <li class="list-group-item text-muted d-flex justify-content-between align-items-start ms-2">                            
                        Fixed Asset Management             
                        <span class="badge bg-danger rounded-pill">InActive</span>                                       
                    </li>`;

            $("#modules").html(html);

        const financeModal = new bootstrap.Modal(document.getElementById('financeModal'));
        financeModal.show();
    }

    function loadBranchFinancialData() {
        $.ajax({
            url: "{{ route('business.branches.financial-data') }}",
            type: 'GET',
            success: function(data) {
                if (data && data.length > 0) {
                    // Update table with financial data
                    data.forEach(function(branch) {
                        var revenueCell = $('.revenue[data-branch-id="' + branch.branch_id + '"]');
                        var expensesCell = $('.expenses[data-branch-id="' + branch.branch_id + '"]');
                        var profitCell = $('.profit[data-branch-id="' + branch.branch_id + '"]');
                        var lastClosingCell = $('.last-closing[data-branch-id="' + branch.branch_id + '"]');
                        
                        var currencySymbol = window.CURRENCY_SYMBOL || '$';
                        
                        // Parse and validate numeric values - handle string numbers from JSON
                        var revenue = typeof branch.revenue === 'string' ? parseFloat(branch.revenue) : (branch.revenue || 0);
                        var expenses = typeof branch.expenses === 'string' ? parseFloat(branch.expenses) : (branch.expenses || 0);
                        var profit = typeof branch.profit === 'string' ? parseFloat(branch.profit) : (branch.profit || 0);
                        
                        // Ensure all values are actual numbers
                        revenue = isNaN(revenue) ? 0 : Number(revenue);
                        expenses = isNaN(expenses) ? 0 : Number(expenses);
                        profit = isNaN(profit) ? 0 : Number(profit);
                        
                        // Display Revenue and Expenses in black (no color classes, no + or - sign)
                        revenueCell.removeClass('text-danger text-success text-warning');
                        expensesCell.removeClass('text-danger text-success text-warning');
                        revenueCell.text(currencySymbol + revenue.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
                        expensesCell.text(currencySymbol + expenses.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
                        
                        // Display Profit with proper sign and color
                        // Remove ALL previous color classes first
                        profitCell.removeClass('text-danger text-success text-warning');
                        
                        // Format profit value (preserve negative sign)
                        var profitFormatted = profit.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                        profitCell.text(currencySymbol + profitFormatted);
                        
                        // Color profit based on positive/negative (green for profit, red for loss)
                        // Use explicit numeric comparison with Math.sign for clarity
                        var profitSign = Math.sign(profit);
                        if (profitSign < 0) {
                            // Negative profit - show in red
                            profitCell.removeClass('text-success text-warning');
                            profitCell.addClass('text-danger');
                            profitCell.css('color', '#dc3545'); // Bootstrap red color as fallback
                        } else if (profitSign > 0) {
                            // Positive profit - show in green
                            profitCell.removeClass('text-danger text-warning');
                            profitCell.addClass('text-success');
                            profitCell.css('color', '#198754'); // Bootstrap green color as fallback
                        } else {
                            // Profit is exactly 0 - no color (use default text color)
                            profitCell.removeClass('text-danger text-success text-warning');
                            profitCell.css('color', ''); // Reset to default
                        }
                        
                        // Display Last Closing Date
                        if (branch.last_closing) {
                            // Format the date nicely (e.g., "2024-12-31" -> "31-Dec-2024")
                            var closingDate = new Date(branch.last_closing);
                            var formattedDate = closingDate.toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric'
                            });
                            lastClosingCell.text(formattedDate);
                        } else {
                            lastClosingCell.text('N/A');
                            lastClosingCell.addClass('text-muted');
                        }
                    });
                    
                    // Update chart with real data
                    updateBranchComparisonChart(data);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error loading branch financial data:', error);
            }
        });
    }

    var branchComparisonChart = null;

    function render_branch_comparison_chart(){ 
        var colors = ["#5b69bc", "#39afd1", "#fa5c7c"];
        var dataColors = $("#branch_comparison_chart").data('colors');
        if (dataColors) {
            colors = dataColors.split(",");
        }
        var options = {
            chart: {
                height: 380,
                type: 'line',
                stacked: false,
                toolbar: {
                    show: false
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                width: [0, 0, 3]
            },
            series: [{
                name: 'Profit',
                type: 'column',
                data: []
            }, {
                name: 'Expenses',
                type: 'column',
                data: []
            }, {
                name: 'Revenue',
                type: 'line',
                data: []
            }],
            colors: colors,
            xaxis: {
                categories: [],
            },
            yaxis: [
                {
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors[0]
                    },
                    labels: {
                        style: {
                            color: colors[0]
                        }
                    },
                    title: {
                        text: "Profit"
                    },
                },
                {
                    opposite: true,
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors[1]
                    },
                    labels: {
                        style: {
                            color: colors[1]
                        },
                        offsetX: 10
                    },
                    title: {
                        text: "Expenses",
                    },
                },
                {
                    opposite: true,
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors[2]
                    },
                    labels: {
                        style: {
                            color: colors[2]
                        }
                    },
                    title: {
                        text: "Revenue"
                    }
                },

            ],
            tooltip: {
                followCursor: true,
                y: {
                    formatter: function (y) {
                        if (typeof y !== "undefined") {
                            var currencySymbol = window.CURRENCY_SYMBOL || '$';
                            return currencySymbol + parseFloat(y).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                        }
                        return y;
                    }
                }
            },
            grid: {
                borderColor: '#f1f3fa',
                padding: {
                    bottom: 5
                }
            },
            legend: {
                offsetY: 7,
            },
            responsive: [{
                breakpoint: 600,
                options: {
                    yaxis: {
                        show: false
                    },
                    legend: {
                        show: false
                    }
                }
            }]
        }

        branchComparisonChart = new ApexCharts(
            document.querySelector("#branch_comparison_chart"),
            options
        );

        branchComparisonChart.render();
        
        // Allow scrolling when hovering over the chart
        // Fix: Enable page scrolling while hovering over ApexCharts
        var chartContainer = document.querySelector("#branch_comparison_chart");
        if (chartContainer) {
            // Wait for chart to fully render before adding scroll handler
            setTimeout(function() {
                // Add wheel event listener to allow page scrolling
                chartContainer.addEventListener('wheel', function(e) {
                    // Only handle normal scrolling (not zoom with Ctrl/Cmd)
                    // Scroll the page
                    window.scrollBy({
                        top: e.deltaY,
                        left: 0,
                        behavior: 'auto'
                    });
                }, { passive: true });
            }, 300);
        }
    }

    function updateBranchComparisonChart(data) {
        if (!branchComparisonChart || !data || data.length === 0) {
            return;
        }

        var branchNames = data.map(function(b) { return b.branch_name; });
        var profitData = data.map(function(b) { 
            var profit = parseFloat(b.profit || 0);
            return isNaN(profit) ? 0 : profit;
        });
        var expensesData = data.map(function(b) { 
            var expenses = parseFloat(b.expenses || 0);
            return isNaN(expenses) ? 0 : expenses;
        });
        var revenueData = data.map(function(b) { 
            var revenue = parseFloat(b.revenue || 0);
            return isNaN(revenue) ? 0 : revenue;
        });

        branchComparisonChart.updateOptions({
            xaxis: {
                categories: branchNames
            },
            series: [{
                name: 'Profit',
                type: 'column',
                data: profitData
            }, {
                name: 'Expenses',
                type: 'column',
                data: expensesData
            }, {
                name: 'Revenue',
                type: 'line',
                data: revenueData
            }]
        }, true, true);
    }
</script>
@endsection