@extends('layouts.vertical', ['title' => 'Apex Column Charts', 'topbarTitle' => 'Apex Column Charts'])

@section('css')
@endsection

@section('content')

<div class="row">
    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Basic Column Chart</h4>
                <div dir="ltr">
                    <div id="basic-column" class="apex-charts" data-colors="#5b69bc,#10c469,#fa5c7c">
                    </div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->

    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Column Chart with Datalabels</h4>
                <div dir="ltr">
                    <div id="datalabels-column" class="apex-charts" data-colors="#5b69bc"></div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->
</div>
<!-- end row-->

<div class="row">
    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Stacked Column Chart</h4>
                <div dir="ltr">
                    <div id="stacked-column" class="apex-charts" data-colors="#39afd1,#f9c851,#e3eaef">
                    </div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->

    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">100% Stacked Column Chart</h4>
                <div dir="ltr">
                    <div id="full-stacked-column" class="apex-charts"
                        data-colors="#39afd1,#10c469,#e3eaef"></div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->
</div>
<!-- end row-->

<div class="row">
    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Column with Markers</h4>
                <div dir="ltr">
                    <div id="column-with-markers" class="apex-charts" data-colors="#5b69bc,#f9c851">
                    </div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->

    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Column with Group Label</h4>
                <div dir="ltr">
                    <div id="column-with-group-label" class="apex-charts"
                        data-colors="#39afd1,#10c469,#e3eaef"></div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->
</div>
<!-- end row-->

<div class="row">
    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Column Chart with rotated labels & Annotations</h4>
                <div dir="ltr">
                    <div id="rotate-labels-column" class="apex-charts" data-colors="#fa5c7c"></div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->

    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Column Chart with negative values</h4>
                <div dir="ltr">
                    <div id="negative-value-column" class="apex-charts" data-colors="#5b69bc"></div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->
</div>
<!-- end row-->

<div class="row">
    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Distributed Column Chart</h4>
                <div dir="ltr">
                    <div id="distributed-column" class="apex-charts"
                        data-colors="#5b69bc,#35b8e0,#10c469,#fa5c7c,#f9c851,#39afd1,#e3eaef,#313a46">
                    </div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->

    <div class="col-xl-6">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">Range Column Chart</h4>
                <div dir="ltr">
                    <div id="range-column" class="apex-charts" data-colors="#10c469,#39afd1"></div>
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->
</div>
<!-- end row-->

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="d-flex card-header justify-content-between align-items-center">
                <h4 class="header-title">Dynamic Loaded Chart</h4>
                <div class="flex-shrink-0">
                    <select id="model" class="form-select form-select-sm">
                        <option value="iphone5">iPhone 5</option>
                        <option value="iphone6">iPhone 6</option>
                        <option value="iphone7">iPhone 7</option>
                    </select>
                </div>
            </div>

            <div class="card-body pt-0">
                <h4 class="header-title"></h4>
                <div dir="ltr">
                    <div class="row">
                        <div class="col-sm-6">
                            <div id="chart-year"
                                data-colors="#5b69bc,#35b8e0,#10c469,#fa5c7c,#f9c851,#39afd1"></div>
                        </div>
                        <div class="col-sm-6">
                            <div id="chart-quarter"
                                data-colors="#5b69bc,#35b8e0,#10c469,#fa5c7c,#f9c851,#39afd1"></div>
                        </div>
                    </div> <!-- end row-->
                </div>
            </div>
            <!-- end card body-->
        </div>
        <!-- end card -->
    </div>
    <!-- end col-->
</div>
<!-- end row-->

@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.0/dayjs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.0/plugin/quarterOfYear.min.js"></script>
@vite(['resources/js/components/chart-apex-column.js'])
@endsection