@extends('layouts.horizontal', ['title' => 'Cities', 'topbarTitle' => 'Cities'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
@endsection
@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="TSuppliers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Cities & Areas</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <!--  Table -->
    <div class="row">
        <div class="col-12"> 
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="cities_and_area_table" class="table table-centered  mb-0 table-sm fs-14 ">
                               <thead>
                                    <tr class="table-light">
                                        <th class="text-start">City</th>
                                        <th class="text-start">Area</th>
                                    </tr>
                                    <tr class="table-light">
                                        <th><button class="btn btn-sm btn-primary" onclick="openCityModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Add New City</button></th>
                                        <th><button class="btn btn-sm btn-primary" onclick="openCityAreaModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Add New Area</button></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($cities as $city)
                                        @if($city->areas->count() > 0)
                                            <!-- First row: only city -->
                                            <tr>
                                                <td 
                                                    ds-account-head 
                                                    data-bs-toggle="tooltip" 
                                                    title="ID: {{ $city->id_cities }}" 
                                                    data-cityid="{{ $city->id_cities }}" 
                                                    data-city="{{ $city->city }}" 
                                                    data-province="{{ $city->province }}" 
                                                    data-country="{{ $city->country }}"
                                                   >
                                                    {{ ucfirst($city->city) }}, <span class="text-muted">{{ ucfirst($city->province) }}, {{ ucfirst($city->country) }}</span>
                                                    <iconify-icon 
                                                        style="cursor:pointer;" 
                                                        onclick="openEditCityModal(this)" 
                                                        class="fs-20 text-end" 
                                                        icon="line-md:edit-twotone"
                                                    ></iconify-icon>
                                                </td>
                                                <td></td> <!-- Area empty in first row -->
                                            </tr>

                                            <!-- Next rows: only areas -->
                                            @foreach($city->areas as $area)
                                                <tr>
                                                <td></td>
                                                <td 
                                                    data-bs-toggle="tooltip" 
                                                    title="ID: {{ $area->id_city_areas }}" 
                                                    data-id_city_areas="{{ $area->id_city_areas }}" 
                                                    data-city_id="{{ $city->id_cities }}" 
                                                    data-city_area="{{ $area->city_area }}" 
                                                >
                                                    {{ ucfirst($area->city_area) }}
                                                    <iconify-icon 
                                                        style="cursor:pointer;" 
                                                        onclick="openEditAreaModal(this)" 
                                                        class="fs-20 text-end" 
                                                        icon="line-md:edit-twotone"
                                                    ></iconify-icon>
                                                </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <!-- City with no areas -->
                                            <tr>
                                                <td  
                                                    data-bs-toggle="tooltip" 
                                                    title="ID: {{ $city->id_cities }}" 
                                                    data-cityid="{{ $city->id_cities }}" 
                                                    data-city="{{ $city->city }}" 
                                                    data-province="{{ $city->province }}" 
                                                    data-country="{{ $city->country }}"
                                                >
                                                {{ ucfirst($city->city) }}, <span class="text-muted">{{ ucfirst($city->province) }}, {{ ucfirst($city->country) }}</span>
                                                    <iconify-icon 
                                                        style="cursor:pointer;" 
                                                        onclick="openEditCityModal(this)" 
                                                        class="fs-20 text-end" 
                                                        icon="line-md:edit-twotone"
                                                    ></iconify-icon>
                                                </td>
                                                <td></td> <!-- No areas -->
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                    </table>
                 </div> 
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modal for Add city --}}
<div class="modal fade" id="cityModal" tabindex="-1" aria-labelledby="cityModal" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New City</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="cityModalForm">
                @csrf
                <div class="modal-body">
                    <div class="row mb-2">
                        <input type="hidden" id="id_cities" name="id_cities" >
                        <div class="col-md-12">
                            <label for="city" class="form-label">City<strong class="text-danger"> *</strong></label>
                            <input type="text" class="form-control" id="city" name="city" placeholder="City" required>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-md-12">
                            <label for="city" class="form-label">Province<strong class="text-danger"> *</strong></label>
                            <input type="text" class="form-control" id="province" name="province" placeholder="Province" required>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-12">
                            <label for="city" class="form-label">Country<strong class="text-danger"> *</strong></label>
                            <input type="text" class="form-control" id="country" name="country" placeholder="Country" required>
                        </div>
                    </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" onclick="save_and_update_city()" class="btn btn-primary" id="saveChangesButtons">Save changes</button>
            </div>
            </form>
        </div>
    </div>
    </div>
{{-- End Modal --}}

{{-- Modal for Add city --}}
<div class="modal fade" id="areaModal"  aria-labelledby="areaModal" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New City</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="cityAreaModalForm">
                @csrf
                <div class="modal-body">
               
                    <div class="row mb-2">
                        <input type="hidden" id="id_city_areas" name="id_city_areas" >
                        <div class="col-md-12">
                            <label for="city" class="form-label">City area<strong class="text-danger"> *</strong></label>
                            <input type="text" class="form-control" id="city_area" name="city_area" placeholder="City Area" required>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-12">
                            <label for="city" class="form-label">City<strong class="text-danger"> *</strong></label>

                            <select class="form-control select-2" name="city_id" id="city_id">
                                @if (isset($cities))
                                        @foreach($cities as $city)
                                        <option value="{{$city->id_cities}}">{{$city->city}}</option> 
                                        @endforeach
                                @endif  
                            </select>
                        </div>
                    </div>    

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" onclick="save_and_update_area()" class="btn btn-primary" id="areaSaveChangesButtons">Save changes</button>
            </div>
            </form>
        </div>
    </div>
    </div>
{{-- End Modal --}}
@endsection

@section('scripts')
<script>
$(document).ready(function() {
   $('.select-2').select2({
        width: '100%',
        dropdownParent: $('#areaModal'), 
        minimumResultsForSearch: 0      
    });


        var table = $('#cities_and_area_table').DataTable({
            "lengthChange": false,
            "paging": false,
            "ordering": false,
            "info": false,            
            "language": {
                search: "",
                searchPlaceholder: "Search..."
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search"
               
            },
             "buttons": [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ]
        });

});

function openCityModal() {
    $('#cityModal .modal-title').text('Add New City');
    $('#cityModalForm')[0].reset();
    $('#id_cities').val('');
    let El = document.getElementById('cityModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
    modal.show();
}



function save_and_update_city() {
    var formData = new FormData(document.getElementById("cityModalForm"));
    $("#saveChangesButtons").prop('disabled', true);
    $.ajax({
        url: "{{ route('city_save_or_update') }}",
        method: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function(res) {
            $("#saveChangesButtons").prop('disabled', false);
            if(res.success){
                let El = document.getElementById('cityModal');
                let modal = bootstrap.Modal.getInstance(El);
                if (!modal) modal = new bootstrap.Modal(El);
                modal.hide();
                toastr.success(res.message);
                setTimeout(() => {
                    window.location.reload();
                }, 300);

            } else {
                $("#saveChangesButtons").prop('disabled', false);
                toastr.error('Failed to save city: ' + res.message);
            }
        },
        error: function(xhr) {
            $("#saveChangesButtons").prop('disabled', false);
            toastr.error('Failed to save city: ' + xhr.responseText);
        }
    });
}

function openCityAreaModal() {
    $('#areaModal .modal-title').text('Add New Area');
    $('#cityAreaModalForm')[0].reset();
    $('#id_city_areas').val('');
    let El = document.getElementById('areaModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
    modal.show();
}
function save_and_update_area() {
    var formData = new FormData(document.getElementById("cityAreaModalForm"));
    $("#areaSaveChangesButtons").prop('disabled', true);
    $.ajax({
        url: "{{ route('area_save_or_update') }}",
        method: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function(res) {
            $("#areaSaveChangesButtons").prop('disabled', false);
            if(res.success){
                let El = document.getElementById('areaModal');
                let modal = bootstrap.Modal.getInstance(El);
                if (!modal) modal = new bootstrap.Modal(El);
                modal.hide();
                toastr.success(res.message);
                setTimeout(() => {
                    window.location.reload();
                }, 300);

            } else {
                $("#areaSaveChangesButtons").prop('disabled', false);
                toastr.error('Failed to save area: ' + res.message);
            }
        },
        error: function(xhr) {
            $("#areaSaveChangesButtons").prop('disabled', false);
            toastr.error('Failed to save area: ' + xhr.responseText);
        }
    });
}

function openEditCityModal(this_btn) {
    // get parent td
    const td = this_btn.closest('td');

    const cityId   = td.dataset.cityid;
    const city     = td.dataset.city;
    const province = td.dataset.province;
    const country  = td.dataset.country;

    $('#id_cities').val(cityId);
    $('#city').val(city);
    $('#province').val(province);
    $('#country').val(country);

    $('#cityModal .modal-title').text('Edit City');
    let El = document.getElementById('cityModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
    modal.show();
}

function openEditAreaModal(this_btn) {
    // get parent td
    const td = this_btn.closest('td');
    const id_city_areas   = td.dataset.id_city_areas;
    const city_area     = td.dataset.city_area;
    const city_id = td.dataset.city_id;

    $('#id_city_areas').val(id_city_areas);
    $('#city_area').val(city_area);
    $('#city_id').val(city_id).trigger('change');

    $('#cityModal .modal-title').text('Edit Area');
    let El = document.getElementById('areaModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
    modal.show();
}













</script>
@endsection