@extends('layouts.horizontal', ['title' => 'Consent Form', 'topbarTitle' => 'Consent Form'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')
<div class="wrapper">
    <div class="container">
        <div class="row">
            <div class="col-sm-12"></div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        {{-- Title --}}
                        <div class="row">
                            <div class="col-md-12 gap-2">
                                <h2 class="text-center formtitle mb-4">
                                    CONSENT FORM (<span id="form-title">{{ strtoupper($consent_form->concent_form) }}</span>)
                                </h2>

                                <input type="hidden" id="visit_id" value="{{ $visit_id }}">
                                <input type="hidden" id="customer_id" value="{{ $customer_id }}">
                                <input type="hidden" id="id_concent_form" value="{{ $consent_form->id_concent_forms }}">
                            </div>
                        </div>

                        {{-- Customer Details --}}
                        <div class="row m-t-20">
                            <div class="col-md-12 gap-2">
                                <div class="row mb-2">
                                    <div class="col-md-2"><h5>Client Name:</h5></div>
                                    <div class="col-md-4" style="border-bottom:1px solid #000;">
                                        <p id="customer_name">{{ $customerdetails->customer_name }}</p>
                                    </div>

                                    <div class="col-md-2"><h5>Date of Visit:</h5></div>
                                    <div class="col-md-4" style="border-bottom:1px solid #000;">
                                        <p id="visit_date">
                                            {{ $customerdetails->customer_visit_date ?: '-' }}
                                        </p>
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-2"><h5>Client Cell:</h5></div>
                                    <div class="col-md-4" style="border-bottom:1px solid #000;">
                                        <p id="customer_cell">{{ $customerdetails->customer_cell }}</p>
                                    </div>

                                    <div class="col-md-2"><h5>Area of Residence:</h5></div>
                                    <div class="col-md-4" style="border-bottom:1px solid #000;">
                                        <p id="customer_area">{{ $customerdetails->customer_area ?: '-' }}</p>
                                    </div>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-md-2"><h5>Tech Consultant:</h5></div>
                                    <div class="col-md-4" style="border-bottom:1px solid #000;">
                                        <select id="tech_consultant" style="border:none">
                                            @foreach($staff as $consultant)
                                                <option value="{{ $consultant->id_staff }}">
                                                    {{ $consultant->staff_fullname }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-2"><h5>Event Date:</h5></div>
                                    <div class="col-md-4" style="border-bottom:1px solid #000;">
                                        <input type="date" id="event_date" placeholder="Optional" style="border:none">
                                    </div>
                                </div>

                            </div>
                        </div>

                        {{-- Dynamic Form Structure --}}
                        <div class="row gap-4">                           
                            @php
                                $structure = json_decode($consent_form->form_structure, true);
                            @endphp
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-12" id="structuredata">
                                 @php $x = 0; @endphp
                                @foreach($structure as $section => $sectionheading)
                                    <div class="row myEdiv mb-2">
                                        <div class="col-md-12">
                                            @if(str_contains($section, '-'))
                                                <span class="section mb-2" section="{{ $section }}"></span>
                                            @else
                                                <h4 class="section mb-2" section="{{ $section }}">{!! $section !!}:</h4>
                                            @endif
                                           
                                            @foreach($sectionheading as $heading => $elements)
                                               
                                                <div class="row elemdiv mb-3">
                                                    <div class="col-md-12">
                                                        @if(str_contains($heading, '-'))
                                                            <span class="section_heading" key="{{ $heading }}"></span>
                                                        @else
                                                            <h5 class="section_heading" key="{{ $heading }}">{!! $heading !!}</h5>
                                                        @endif
                                                        
                                                        @foreach($elements as $key => $type)
                                                            
                                                            {{-- Checkbox --}}
                                                            @if($type === 'checkbox' && strpos($key,'-') === false)
                                                                <div class="form-group checkbox form-check " style="display:inline-block">
                                                                    <input type="checkbox"
                                                                        class="jsonelem echeckbox form-check-input"
                                                                        id="{!! $key.$x !!}"
                                                                        key="{!! $key !!}"
                                                                        name="{!! $heading !!}">
                                                                    <label class="form-check-label me-2" for="{!! $key.$x !!}">{!! $key !!}</label>                                                                   
                                                                </div>
                                                                 @php $x++; @endphp
                                                            @endif

                                                            {{-- Radio --}}
                                                            @if($type === 'radio' && strpos($key,'-') === false)
                                                                <div class="form-group radio form-radio" style="display:inline-block">
                                                                    <input type="radio"
                                                                        class="jsonelem eradio form-radio-input"
                                                                        id="{!! $key.$x !!}"
                                                                        key="{!! $key !!}"
                                                                        name="{!! $heading !!}">
                                                                    <label class="form-check-label me-2" for="{!! $key.$x !!}" >{!! $key !!}</label>                                                                   
                                                                </div>
                                                                 @php $x++; @endphp
                                                            @endif

                                                            {{-- Paragraph --}}
                                                            @if($type === 'para' && strpos($key,'-') === false)
                                                                <p class="jsonelem epara " key="{!! $heading !!}">
                                                                    {!! $key !!}
                                                                </p>
                                                            @endif

                                                            {{-- List --}}
                                                            @if($type === 'list')
                                                                <div class="jsonelem elist" key="{!! $heading !!}">
                                                                    {!! $key !!}
                                                                </div>
                                                            @endif

                                                            {{-- Textarea --}}
                                                            @if($type === 'textarea')
                                                                <p class="mt-2">
                                                                    @if(strpos($key, '-') === false)
                                                                    <label class="form-check-label me-2" for="{!! $key.$x !!}" >{!! $key !!}</label>
                                                                    @endif
                                                                    <textarea class="jsonelem etextarea form-control"
                                                                        id="{!! $key.$x !!}"
                                                                        key="{!! $key !!}"
                                                                        section="{!! $heading !!}"></textarea></p>
                                                                @php $x++; @endphp

                                                            @endif
                                                            
                                                            {{-- Image --}}
                                                            @if($type === 'img')
                                                                <img class="jsonelem eimage img-fluid" src="{!! asset('images/consentforms/'.$key) !!}">
                                                            @endif

                                                            {{-- Image with Text --}}
                                                            @if($type === 'imghalf')
                                                               <div class="row mb-3">
                                                                    <div class="col-md-6">
                                                                        @if(strpos($key,"-")===0)
                                                                        <label class="form-check-label me-2" for="{!! $key !!}" >{!! $key!!}</label>
                                                                        @endif
                                                                        <img class="jsonelem eimghalf img-fluid"
                                                                            src="{!! asset('images/consentforms/'. $key) !!}"
                                                                            key="{!! $key !!}">
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <textarea class="jsonelem etexthalf form-control"
                                                                            key="{!! $key !!}"
                                                                            section="{!! $heading !!}"></textarea>
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>

                        {{-- Signatures --}}
                        <div class="row m-t-20">
                            <div class="col-md-6">
                                <label>Client Signature:</label>
                                <div id="customer_signature" class="border border-2 border-rounded"></div>
                            </div>

                            <div class="col-md-6">
                                <label>Consultant Signature:</label>
                                <div id="consultant_signature" class="border border-2 border-rounded"></div>
                            </div>
                        </div>

                        
                    </div>
                    <div class="card-footer text-end">
                        <button onclick="saveform()" id="btnSave" class="btn btn-primary">
                            <span id="saveSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span>
                            Save Consent Form</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@vite(['node_modules/jsignature/libs/jSignature.min.js', 'node_modules/select2/dist/js/select2.min.js'])
<script>
    const BaseUrl = "{{ config('constants.BASE_URL') }}";
$(function () {

    
    $('#tech_consultant').select2();

    $('#customer_signature').jSignature();
    $('#consultant_signature').jSignature();

});

function formjson() {

    const result = {};

    $('#structuredata .myEdiv').each(function () {
        const sectionEl = $(this).find('.section[section]').first();
        if (!sectionEl.length) return;
        const section = sectionEl.attr('section').trim();
        if (!result[section]) result[section] = {};

        $(this).find('.elemdiv').each(function () {
            let headingEl = $(this).find('.section_heading').first();
            let heading = headingEl.length ? headingEl.text().trim() : '__no_heading__';

            if (!result[section][heading]) result[section][heading] = {};

            $(this).find('.jsonelem').each(function () {
                let key, value;

                if ($(this).hasClass('etexthalf')) return;

                if ($(this).hasClass('echeckbox')) {
                    key = $(this).attr('key') + '||checkbox';
                    value = $(this).prop('checked');
                } else if ($(this).hasClass('eradio')) {
                    key = $(this).attr('key') + '||radio';
                    value = $(this).prop('checked');
                } else if ($(this).hasClass('etextarea')) {
                    key = $(this).attr('key') + '||para';
                    value = ($(this).val() || '').trim();
                } else if ($(this).hasClass('epara')) {
                    key = $(this).attr('key') + '||para';
                    value = $(this).text().trim();
                } else if ($(this).hasClass('elist')) {
                    key = $(this).attr('key') + '||list';
                    value = $(this).text().trim();
                } else if ($(this).hasClass('eimage')) {
                    key = $(this).attr('key') + '||img';
                    value = $(this).attr('src');
                } else if ($(this).hasClass('eimghalf')) {
                    key = $(this).attr('key') + '||imghalf';
                    value = $(this).closest('.elemdiv').find('.etexthalf').val()?.trim() ?? '';
                }

                if (key !== undefined) result[section][heading][key] = value;
            });
        });
    });

    return JSON.stringify(result, null, 2);
}

function saveform() {

    $("#saveSpinner").removeClass('d-none');
    $("#btnSave").attr('disabled', true);

    let customerSig = $('#customer_signature').jSignature('getData','svgbase64');
    let consultantSig = $('#consultant_signature').jSignature('getData','svgbase64');
  
    $.ajax({
        type: 'POST',
        url: '{{ route("save_consent_form") }}',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        data: {
            concent_form_id: $('#id_concent_form').val(),
            form_title: $('#form-title').text(),
            customer_id: $('#customer_id').val(),
            visit_id: $('#visit_id').val(),
            staff_id: $('#tech_consultant').val(),
            event_date: $('#event_date').val(),
            concent_data: formjson(),
            customer_signature: customerSig.join(','),
            consultant_signature: consultantSig.join(',')
        },
        success: function (res) {
            toastr.success('Consent Form saved successfully!');
            // open in same tab

            window.location.href = BaseUrl + '/signed_consent_form/' + res.concent_form_data_id;
            $("#saveSpinner").addClass('d-none');
            $("#btnSave").attr('disabled', false);
        },
        error: function (err) {
            toastr.error('Error saving Consent Form. Please try again.');
            $("#saveSpinner").addClass('d-none');
            $("#btnSave").attr('disabled', false);
        }

    });
}
</script>
@endsection