@extends('layouts.horizontal', ['title' => 'Consent Form', 'topbarTitle' => 'Consent Form'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')

<style>
    #customer_signature {
        padding: 0;
        margin: 0;
        border: 2px dotted #000;
        width: 75%;
    }
</style>

<div class="wrapper">
    <div class="container">
        <div class="card m-t-20 p-4">
            <div class="card-body">
                {{-- Title --}}
                <h2 class="text-center formtitle">
                    CONSENT FORM ({{ strtoupper($consent_form->concent_form) }})
                </h2>

                {{-- Hidden --}}
                <input type="hidden" id="visit_id" value="{{ $customerdetails->id_customer_visits }}">
                <input type="hidden" id="customer_id" value="{{ $customerdetails->id_customers }}">
                <input type="hidden" id="id_concent_form" value="{{ $consent_form->id_concent_forms }}">
                <input type="hidden" id="id_concent_category" value="{{ $consent_form->id_concent_category }}">

                {{-- Customer Details --}}
                <div class="row mt-4">
                    <div class="col-md-2"><strong>Client Name:</strong></div>
                    <div class="col-md-4 border-bottom" id="customer_name">
                        {!! $customerdetails->customer_name !!}
                    </div>

                    <div class="col-md-2"><strong>Date of Visit:</strong></div>
                    <div class="col-md-4 border-bottom" id="visit_date">
                        {{ $customerdetails->customer_visit_date }}
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-2"><strong>Client Cell:</strong></div>
                    <div class="col-md-4 border-bottom" id="customer_cell">
                        {{ $customerdetails->customer_cell }}
                    </div>

                    <div class="col-md-2"><strong>Area of Residence:</strong></div>
                    <div class="col-md-4 border-bottom" id="customer_area">
                        {{ $customerdetails->customer_area ?: '-' }}
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-2"><strong>Tech Consultant:</strong></div>
                    <div class="col-md-4 border-bottom">
                        <select id="tech_consultant" style="border:none">
                            <option></option>
                        </select>
                    </div>

                    <div class="col-md-2"><strong>Event Date:</strong></div>
                    <div class="col-md-4 border-bottom">
                        <input id="event_date" placeholder="Optional" style="border:none">
                    </div>
                </div>

                {{-- Structure --}}
                <div id="structuredata" class="mt-4">
                    @php($lastsection = '')
                    @php($lastsectionheading = '')

                   
                    <div class="me">

                        @if($lastsection !== $consent_form->section && $consent_form->section !== 'Default')
                            <h5 class="section" section="{{ $consent_form->section }}">
                                {!! $consent_form->section !!}:
                            </h5>
                            @php($lastsection = $consent_form->section)
                        @endif

                        @if($lastsectionheading !== $consent_form->section_heading)
                            <div class="row" section_heading="{{ $consent_form->section_heading }}">
                                @if($consent_form->section_heading !== '-')
                                    <div class="col-md-2">
                                        <strong class="section_heading">
                                            {!! $consent_form->section_heading !!}:
                                        </strong>
                                    </div>
                                    <div class="col-md-10 form">
                                @else
                                    <div class="col-md-12 form m-l-15">
                                @endif

                                @php($options = json_decode($consent_form->section_options, true))

                                @foreach($options as $type => $items)

                                    @if($type === 'checkbox' || $type === 'radio')
                                        @foreach($items as $label => $v)
                                            <input
                                                type="{{ $type }}"
                                                class="jsonelem eradio m-l-15"
                                                section="{{ $consent_form->section }}"
                                                key="{{ $label }}"
                                                name="{{ $consent_form->section_heading }}"
                                                id="{{ Str::slug($consent_form->section_heading.'_'.$label) }}"
                                            >
                                            <label for="{{ Str::slug($consent_form->section_heading.'_'.$label) }}">
                                                {!! $label !!}
                                            </label>
                                        @endforeach
                                    @endif

                                    @if($type === 'textarea')
                                        @foreach($items as $label => $v)
                                            <label>{!! $label !!}</label>
                                            <textarea
                                                class="jsonelem etextarea"
                                                section="{{ $consent_form->section }}"
                                                key="{{ $label }}"
                                                style="border:none;border-bottom:1px solid #000"
                                            ></textarea>
                                        @endforeach
                                    @endif

                                    @if($type === 'text')
                                        @foreach($items as $label => $v)
                                            <p class="jsonelem epara"
                                            section="{{ $consent_form->section }}"
                                            key="{{ $label }}">
                                                {!! $v !!}
                                            </p>
                                        @endforeach
                                    @endif

                                @endforeach
                                </div>
                            </div>

                            @php($lastsectionheading = $consent_form->section_heading)
                        @endif
                    </div>      
                   
                </div>

                {{-- Signatures --}}
                <div class="row m-t-20">
                    <div class="col-md-2">Client Signature:</div>
                    <div class="col-md-4"><div id="customer_signature"></div></div>

                    <div class="col-md-2">Consultant Signature:</div>
                    <div class="col-md-4"><div id="consultant_signature"></div></div>
                </div>

                {{-- Save --}}
                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-primary pull-right" onclick="saveform()">Save</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@vite(['node_modules/jsignature/libs/jSignature.min.js', 'node_modules/select2/dist/js/select2.min.js'])
<script>
    $(function () {


        $('#customer_signature, #consultant_signature').jSignature('reset');
    });


    function formjson() {

        var shJson = '{';
        var y = 0;
        var section = '';
        var lastsection = '';

        $('#structuredata').children('.me').each(function () {

            if (section !== $(this).find('.section').attr('section') && y !== 0) {
                shJson += "},";
            }

            section = $(this).find('.section').attr('section');

            if (typeof section !== 'undefined') {
                if (lastsection !== section) {
                    shJson += '"' + section + '":';
                    lastsection = section;
                    y = 0;
                }
            }

            var section_heading = $(this).find('.section_heading').html();

            if (typeof section_heading !== 'undefined' && section_heading !== 'undefined') {

                if (y !== 0) {
                    shJson += ",";
                } else {
                    shJson += "{";
                }

                shJson += '"' + section_heading + '":';

                var oJson = '{';
                var x = 0;

                $(this).find('.jsonelem').each(function () {

                    var key, value;

                    if ($(this).hasClass('eradio')) {
                        key = $(this).attr('key') + '||radio';
                        value = $(this).prop('checked');
                    }
                    else if ($(this).hasClass('etextarea')) {
                        key = $(this).attr('key') + '||para';
                        value = $(this).val();
                    }
                    else if ($(this).hasClass('epara')) {
                        key = $(this).attr('key') + '||para';
                        value = $(this).html();
                    }

                    if (typeof key !== 'undefined') {
                        if (x === 0) {
                            oJson += '"' + key + '":"' + value + '"';
                        } else {
                            oJson += ',"' + key + '":"' + value + '"';
                        }
                        x++;
                    }
                });

                oJson += '}';
                shJson += oJson;
                y++;
            }
        });

        shJson += "}}";
        return shJson;
    }

    function saveform() {

        let customerSig = $('#customer_signature').jSignature('getData','svgbase64');
        let consultantSig = $('#consultant_signature').jSignature('getData','svgbase64');

        $.post("{{ route('save_consent_form') }}", {
            _token: '{{ csrf_token() }}',
            customer_id: $('#customer_id').val(),
            visit_id: $('#visit_id').val(),
            concent_data: formjson(),
            customer_signature: customerSig.join(','),
            consultant_signature: consultantSig.join(',')
        });
    }
</script>
@endsection