@extends('layouts.horizontal', ['title' => 'Consent Forms', 'topbarTitle' => 'Consent Forms'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row page-titles mb-3">
            <div class="col-md-5 align-self-center">
                <h2 class="text-themecolor"> {{ $visit_id ? 'Consent Forms for Visit ID: ' . $visit_id : 'Consent Forms' }}</h2>
            </div>
            <div class="col-md-7 align-self-center text-end">
                <div class="d-flex justify-content-end align-items-center">
                    <button onclick="" class="btn btn-success d-none d-lg-block m-l-15">
                        <i class="ti ti-plus"></i> New Consent Form
                    </button>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                @foreach($data as $category)                              
                <div class="row mt-2">
                    <div class="col-md-4">
                        <h2 class="card-title">{{ $category['category']->concent_category }} </h2>
                    </div>                                                
                </div>
                <div class="row mt-3">
                    @foreach($category['forms'] as $form)
                    <div class="col-md-4">
                        <div class="card border shadow-none mb-2">
                            <div class="card-body">
                                <div class="d-flex">
                                    <div class="align-self-center">
                                        <h4 class="card-title">{{ $form->concent_form }} <span class="text-primary">({{  $category['category']->concent_category }}) </span></h4>                               
                                    </div>
                                    <div class="ms-auto">
                                        
                                        <a href="{{ route('get_consent_form', ['id_consent_form' => $form->id_concent_forms]) }}" class="btn btn-ghost-info btn-icon rounded-circle">
                                            <iconify-icon icon="line-md:pencil" class="fs-20"></iconify-icon>
                                        </a>
                                    </div>
                                </div>
                                <div class="mt-0">
                                    <span class="text-muted">Last Edited: {{ date('d M Y', strtotime($form->updated_at ?? $form->created_on)) }}</span>
                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <button onclick = "openConsentForm({{ $form->id_concent_forms }}, {{ $visit_id ?? 'null' }}, '{{ $customer_name ?? '' }}', {{ $customer_id ?? 'null' }})" class="btn btn-outline-primary">Fill for Customer: <span>{{  $customer_name ?? 'N/A' }}</span></button>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>                       
            @endforeach
        </div>
    </div>

@endsection
@section('scripts')
<script>
    function openConsentForm(id_concent_form, visit_id = null, customer_name = '', customer_id = null) {
        let url = '{{ route("consent_form") }}' + '?id_concent_form=' + id_concent_form;

        if (visit_id) {
            url += '&visit_id=' + visit_id;
        }
        if (customer_name) {
            url += '&customer_name=' + encodeURIComponent(customer_name);
        }
        if (customer_id) {
            url += '&customer_id=' + customer_id;
        }

        // Open the URL in a new tab
        window.open(url, 'consent-form-window');
    }
</script>
@endsection