@extends('layouts.horizontal', ['title' => 'Signed Consent', 'topbarTitle' => 'View Consent', 'nonav' => true])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite([
    'node_modules/flatpickr/dist/flatpickr.min.css'
])
@endsection

@section('content')
<div class="row mb-4">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h2 class="mb-sm-0">Consent Forms</h2>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Consent Forms</a></li>
                    <li class="breadcrumb-item active">Consent Forms List</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body" >
                <div class="row mb-4  border-bottom border-1 pb-3" id="filters_row">
                    <div class="col-4">
                        <label class="form-label h5">Customer</label>
                        <select id="customer_filter" class="select2"></select>
                    </div>
                    <div class="col-1 d-flex align-items-end">
                        <button id="filter_button_customer" class="btn btn-ghost-primary rounded-circle">
                            <iconify-icon icon="line-md:filter-twotone" class="fs-22"></iconify-icon>
                        </button>
                    </div>
                    <div class="col-4">
                        <label class="form-label h5">Date Range</label>
                       <input class="form-control" id="dateRange" type="text" value="{{ \Carbon\Carbon::parse($start)->format('Y-m-d') }} to {{ \Carbon\Carbon::parse($end)->format('Y-m-d') }}" />
                    </div>
                    <div class="col-1 d-flex align-items-end">
                        <button id="filter_button_date" class="btn btn-ghost-primary rounded-circle">
                            <iconify-icon icon="line-md:filter-twotone" class="fs-22"></iconify-icon>
                        </button>
                    </div>
                    <div id="btn_clear_filters" class="col-2 d-flex align-items-end justify-content-end">
                        <button class="btn btn-outline-secondary" >
                            Clear Filters
                        </button>
                    </div>
                </div>        
                <div class="table-responsive">
                    <table id="consentFormsTable" class="table table-bordered table-striped dt-responsive">
                        <thead>
                            <tr>
                                <th>Serial No.</th>
                                <th>Form ID.</th>
                                <th>Form Name</th>
                                <th>Customer Name</th>
                                <th>Customer Cell</th>                                
                                <th>Visit ID</th>
                                <th>Visit Date</th>
                                <th>Date Signed</th>
                                <th>Consultant</th>
                                <th>ConsultantSignature</th>
                                <th>CustomerSignature</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
      //get customer_id from URL parameter if exists
        const urlParams = new URLSearchParams(window.location.search);
        const customerIdFromUrl = urlParams.get('id_customers');
       

    const baseURL = "{{ url('/') }}";
    $(document).ready(function() {

      
        //initialize datatable
        initDataTable();

        // Initialize Select2 for customer filter       
        $('#customer_filter').select2({
            placeholder: 'Select Customer',
            dropdownParent: $('#filters_row'),                
            minimumInputLength: 3,
            allowClear: true,      
            ajax: {
                 url: '{{ route("customer_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.customer_name || (item.customer_name + ' (' + item.customer_cell + ')'),
                                customer_name: item.customer_name,
                                customer_cell: item.customer_cell,
                                customer_type: item.customer_type // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatCustomer,      // dropdown items
            templateSelection: formatCustomerSel // selected item
            });

    
        function formatCustomer(customer) {
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }

            var type = (customer.customer_type || '').toString().toLowerCase();
            var iconClass = 'ti-user fs-4 text-secondary';
            var nameClass = '';

            if (type === 'orange' || type === '1') {
                iconClass = 'ti-star fs-4 text-warning';
                nameClass = 'text-warning';
            } else if (type === 'green' || type === '2') {
                iconClass = 'ti-flag fs-4 text-success';
                nameClass = 'text-success';
            } else if (type === 'red' || type === '3') {
                iconClass = 'ti-flag-question fs-4 text-danger';
            }

            var nameEsc = $('<div/>').text(customer.customer_name || customer.text || '').html();
            var cellEsc = $('<div/>').text(customer.customer_cell || '').html();

            var $node = $(`
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="fw-bold ${nameClass}">${nameEsc}</div>
                        <div class="small">${cellEsc}</div>
                    </div>
                    <i class="ti ${iconClass} ms-2" aria-hidden="true"></i>
                </div>
            `);

            //important: return plain DOM node, not jQuery object
            return $node[0];
        }

        function formatCustomerSel(customer) {
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }
            var name = customer.customer_name || customer.text;
            var cell = customer.customer_cell ? ' (' + customer.customer_cell + ')' : '';
            // return a simple node — keep selection compact
            return $('<span>').text(name + cell);
        }


        // Initialize date range picker
        let dateRangePicker = flatpickr("#dateRange", {
            mode: "range",
            dateFormat: "Y-m-d",
            // minDate: "today",
            // maxDate: new Date().fp_incr(30) // 30 days from today
            defaultDate: ["{{ $start }}", "{{ $end }}"]
        });

        $("#btn_clear_filters").on('click', function() {
            $('#customer_filter').val(null).trigger('change');
             dateRangePicker.setDate(
                ["{{ $start }}", "{{ $end }}"],
                true
            );
        });
       

        // Filter button click event for customer
        $('#filter_button_customer').on('click', function() {
            //destroy existing datatable before reinitializing
            $('#consentFormsTable').DataTable().destroy();

            initDataTable();
        });

        // Filter button click event for date range
        $('#filter_button_date').on('click', function() {
           //destroy existing datatable before reinitializing
            $('#consentFormsTable').DataTable().destroy();

            initDataTable();
        });
    });

    function initDataTable() {
        console.log(customerIdFromUrl);
         //get customer_id from URL parameter if exists
        var customer_id = customerIdFromUrl ? customerIdFromUrl : $('#customer_filter').val();

        console.log("Customer ID for DataTable:", customer_id);
        console.log($('#customer_filter').val());

        $('#consentFormsTable').DataTable({
            scrollX:true,
            scrollY: 450,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            autoWidth: false,
            serverSide: true,
            ajax: {
                url: baseURL + '/consent_list_data',
                data: function (d) {
                    d.customer_id = customer_id;
                    d.date_range = $('#dateRange').val();
                }
            },
            columns: [
                { data: 'id_concent_form_data', name: 'id_concent_form_data' },
                { data: 'concent_form_id', name: 'concent_form_id' },
                { data: 'form_title', name: 'form_title' },
                { data: 'customer_name', name: 'customer_name' },
                { data: 'customer_cell', name: 'customer_cell' },
               
                { data: 'visit_id', name: 'visit_id' },
                { data: 'visit_date', name: 'visit_date' },
                { data: 'concent_date', name: 'concent_date' },
                { data: 'consultant_name', name: 'consultant_name' },
                { data: 'consultant_signature', name: 'consultant_signature', orderable: false, searchable: false,
                    //base64 image rendering
                    render: function(data, type, row) {
                        if(data) {
                            return '<img src="data:' + data + '" alt="Consultant Signature" style="max-height: 50px;"/>';
                        } else {
                            return 'No Signature';
                        }
                    } 

                },
                { data: 'customer_signature', name: 'customer_signature', orderable: false, searchable: false,
                    //base64 image rendering
                    render: function(data, type, row) {
                        if(data) {
                            return '<img src="data:' + data + '" alt="Signature" style="max-height: 50px;"/>';
                        } else {
                            return 'No Signature';
                        }
                    }
                 },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            order: [[0, 'desc']],
            lengthMenu: [10, 25, 50, 100],
            pageLength: 10,
            drawCallback: function(settings) {
                // Any additional actions after table redraw can be added here
            }
        });
    }

</script>
@endsection