@extends('layouts.horizontal', ['title' => 'Consent Form', 'topbarTitle' => 'Consent Form'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')

<div class="wrapper">
    <div class="container">
        
        <div class="row">
            <div class="col-sm-12"></div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">

                        {{-- Logo --}}
                        <div class="row">
                            <div class="pull-left">
                                <h3 class="logo invoice-logo">
                                    @if(!empty($business))
                                        <img
                                            src="{{ asset('assets/images/business/'.$business[0]['business_logo']) }}"
                                            alt="{{ $business[0]['business_name'] }}"
                                            class="img-responsive"
                                        >
                                    @else
                                        SalonPK
                                    @endif
                                </h3>
                            </div>
                        </div>

                        {{-- Title --}}
                        <div class="row">
                            <div class="col-md-12">
                                <h2 class="text-center formtitle">
                                    CONSENT FORM ({{ strtoupper($form_data->form_title) }})
                                </h2>

                                <input type="hidden" id="visit_id" value="{{ $form_data->visit_id }}">
                                <input type="hidden" id="customer_id" value="{{ $form_data->customer_id }}">
                                <input type="hidden" id="id_concent_form_data" value="{{ $form_data->id_concent_form_data }}">
                            </div>
                        </div>

                        {{-- Customer Details --}}
                        <div class="row m-t-20">
                            <div class="col-md-12">

                                <div class="row">
                                    <div class="col-md-2"><h5>Client Name:</h5></div>
                                    <div class="col-md-4 border-bottom">
                                        <p>{{ $form_data->customer_name }}</p>
                                    </div>

                                    <div class="col-md-2"><h5>Date of Visit:</h5></div>
                                    <div class="col-md-4 border-bottom">
                                        <p>{{ $form_data->visit_date ?: '-' }}</p>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-2"><h5>Client Cell:</h5></div>
                                    <div class="col-md-4 border-bottom">
                                        <p>{{ $form_data->customer_cell }}</p>
                                    </div>

                                    <div class="col-md-2"><h5>Area of Residence:</h5></div>
                                    <div class="col-md-4 border-bottom">
                                        <p>{{ $form_data->customer_area ?: '-' }}</p>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-2"><h5>Tech Consultant:</h5></div>
                                    <div class="col-md-4 border-bottom">
                                        <p>{{ $form_data->consultant_name ?: '-' }}</p>
                                    </div>

                                    <div class="col-md-2"><h5>Event Date:</h5></div>
                                    <div class="col-md-4 border-bottom">
                                        <p>{{ $form_data->event_date ?: '-' }}</p>
                                    </div>
                                </div>

                            </div>
                        </div>

                        {{-- Dynamic Form Structure --}}
                        <div class="row mt-3">
                            <div class="col-md-12" id="structuredata">

                                @php
                                    $sections = json_decode($form_data->concent_data, true);
                                
                                @endphp

                                @foreach($sections as $section => $sectionHeading)
                                    <div class="row mt-1">
                                        <div class="col-md-12">

                                            @if(!str_contains($section, '-'))
                                                <h4 class="section" >
                                                    {{ $section }}
                                                </h4>
                                            @endif

                                            @foreach($sectionHeading as $sub => $elements)

                                                <div class="row mt-1">
                                                    <div class="col-md-12">
                                                        <h5>{{ $sub }}</h5>
                                                    </div>
                                                    <div class="col-md-12">
                                                        @if($sub !== $section && strpos($sub, '-') === 0)
                                                            <h5>{{ $sub }}</h5>
                                                        @endif
                                                    </div>

                                                    <div class="col-md-12">
                                                        @foreach($elements as $key => $value)
                                                            @php
                                                                [$label, $type] = explode('||', $key);
                                                            @endphp

                                                            @if(in_array($type, ['checkbox','radio']))
                                                               
                                                                <div class="form-check form-checkbox-dark form-check-inline d-inline-block me-4">
                                                                    <input type="checkbox" class="form-check-input check-input-success" disabled                                                                       
                                                                        {{ $value === true ? 'checked' : '' }}>
                                                                    <label class="form-check-label" style="color:#000000 !important">{{ $label }}</label>
                                                                </div>
                                                              
                                                            @elseif($type === 'para')
                                                                <p style="font-size:14px;">
                                                                    {!! urldecode($value) !!}
                                                                </p>

                                                            @elseif($type === 'list')
                                                                <div>{!! urldecode($value) !!}</div>

                                                            @elseif($type === 'img')
                                                                <img class="img"
                                                                    src="{{ asset('assets/images/'.$label) }}">

                                                            @elseif($type === 'imghalf')
                                                                <div class="row">
                                                                    <div class="col-md-4">
                                                                        <img class="img"
                                                                            style="max-height:250px"
                                                                            src="{{ asset('images/consentforms/'.$label) }}">
                                                                    </div>
                                                                    <div class="col-md-8">
                                                                        <p>{!! urldecode($value) !!}</p>
                                                                    </div>
                                                                </div>
                                                            @endif

                                                        @endforeach
                                                    </div>
                                                </div>

                                            @endforeach
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>

                        {{-- Signatures --}}
                        <div class="row m-t-20 m-b-20">
                            <div class="col-md-12">

                                <div class="row">
                                    <div class="col-md-2">Client Signature:</div>
                                    <div class="col-md-4 border-bottom">
                                        <div id="customer_signature"></div>
                                    </div>

                                    <div class="col-md-2">Consultant Signature:</div>
                                    <div class="col-md-4 border-bottom">
                                        <div id="consultant_signature"></div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-end">
                        <div class="d-print-none mb-5">
                            <div class="d-flex justify-content-center gap-2">
                                <a href="javascript:window.print()" class="btn btn-primary"><i
                                        class="ti ti-printer me-1"></i> Print</a>
                                <a href="javascript: void(0);" class="btn btn-secondary"><i class="ti ti-send me-1"></i>
                                    Send</a>
                            
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>
@endsection

@section('scripts')
@vite(['node_modules/jsignature/libs/jSignature.min.js', 'node_modules/select2/dist/js/select2.min.js'])
<script>
    $(function () {
        $('<img>', {
            src: 'data:{{ $form_data->customer_signature }}'
        }).appendTo('#customer_signature');

        $('<img>', {
            src: 'data:{{ $form_data->consultant_signature }}'
        }).appendTo('#consultant_signature');
    });
</script>
@endsection