@extends('layouts.horizontal', ['title' => 'Order', 'topbarTitle' => 'View Order', 'nonav' => true])

@section('css')

 <style>
     .row {
        display: flex !important;
        flex-wrap: nowrap !important;
    }

    .col-md-6 {
        width: 50% !important;
        float: left !important;
    }

    h2.category-title {
        page-break-after: avoid;
        color: #000 !important;
    }

    .section-container {
        page-break-inside: avoid;
    }

    .category-table {
        page-break-inside: avoid;
    }

    .category-table  th, td {
        font-size: 12px;
        padding: 4px 6px !important;
    }

    /* dashed border print issue fix */
    .category-title {
        border-bottom: 2px dashed #000 !important;
    }
 </style>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body" >
                <!-- Invoice Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div>
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>     
                        <div class="mt-2">                            
                            <h6 class="fs-14 mb-0 lh-base font-monospace">{!! $business->business_address !!}</h6>
                            <h6 class="fs-14 mb-2 font-monospace">Phone: {{ $business->business_phone1 }}</h6>
                        </div>   
                        <div style="text-align: left;" class="mt-3">
                            <h6 class="fs-14 fw-bolder mb-0 font-monospace">{{ $customer->customer_name }}</h6>
                            <abbr class="fs-14 mb-2 font-monospace">{{ $customer->customer_cell }}</abbr>
                         </div>                
                    </div>
                    <div class="text-end">                        
                            <span class="badge bg-danger-subtle text-danger px-1 fs-20 mb-3  font-monospace">{{$order->order_status}}</span>
                            <h3 class=" m-0 fw-bolder fs-20 font-monospace">Order: # {{$order->id_customer_order}}</h3>
                            <div style="text-align: left;" class="mt-3">
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Date: {{$order->customer_order_date}}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Time: {{$order->customer_order_time}}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Agent: {{$order->created_by}}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Type: {{  'Retail' }}</h6>
                            </div>
                    </div>
                </div>
                @if (isset($categoriesDataFormattedData) && !empty($categoriesDataFormattedData))
                    <div class="d-print-none mb-0 text-start">
                        <button type="button" class="btn btn-outline-primary btn-sm d-print-none" onclick="toggleProducts()" id="btnProducts">
                            Hide Products Details
                        </button>
                    </div>
                @endif
                <div class="mt-2" id="show_and_hide_section_of_products">
                    <div class="table">
                        <table class="table text-left align-middle mb-0 font-monospace" style="overflow-x: hidden;">
                            <thead>
                                <tr class="bg-light bg-opacity-50">
                                <th class="border-0" scope="col" style="width: 50px;">#</th>
                                <th class="hidden-xs d-print-none text-start border-0" scope="col">Brand</th>
                                <th class="text-start border-0" scope="col">Item</th>
                                <th class="hidden-xs d-print-none border-0" scope="col">Sold By</th>
                                <th class="hidden-xs d-print-none border-0" scope="col">Batch</th>
                                <th class="text-end border-0" scope="col">Unit</th>
                                <th class="text-end border-0" scope="col">Qty.</th>
                                <th class="text-end border-0" scope="col">Discount</th>                                    
                                <th class="text-end border-0" scope="col" class="text-end">Total</th>
                                <th class="hidden-xs d-print-none text-end border-0" scope="col">Tax</th>                                    
                                <th class="hidden-xs d-print-none text-end border-0" scope="col" class="text-end">Final</th>
                                </tr>
                            </thead>
                            <tbody id="services-list">
                              @php 
                                $subTotal = 0;
                                $totalTax = 0;
                                $total_discount_amount = 0;
                                $row = 1; 
                            @endphp

                            @foreach($order_products as $product)
                                @php
                                    $unit_price_with_qty = $product->qty * $product->product_unit_price; 
                                    $discount_amount = $product->qty * ($product->product_discount_amount ?? 0); 
                                    $discounted_price = $unit_price_with_qty - $discount_amount;
                                    $tax_amount = $discounted_price > 0 ? $product->product_sales_tax / 100 * $discounted_price : 0;
                                    $final_price = $discounted_price + $tax_amount;

                                    $subTotal += $product->price*$product->qty; 
                                    $total_discount_amount += $discount_amount;
                                    $totalTax += $tax_amount;
                                @endphp
                                
                                <tr>
                                    <td scope="row">{{ $row }}</td>
                                    <td class="d-print-none text-start">{{ $product->business_brand_name }}</td>
                                    <td class="text-start">{{ $product->product }}</td>
                                    <td class="d-print-none">{!! $product->staff !!}</td>
                                    <td class="d-print-none">{{ $product->batch_id . '|' . $product->batch }}</td>
                                    <td class="text-end">{{ number_format((float)$product->product_unit_price, 2, '.', '') }}</td>
                                    <td class="text-end">{{ $product->qty }}</td>
                                    <td class="text-end">{{ number_format((float)$discount_amount, 2, '.', '') }}</td>
                                    <td class="text-end">{{ number_format((float)$discounted_price, 2, '.', '') }}</td>
                                    <td class="d-print-none text-end">{{ number_format((float)$tax_amount, 2, '.', '') }}</td>
                                    <td class="d-print-none text-end">{{ number_format((float)$final_price, 2, '.', '') }}</td>
                                </tr>
                                
                                @php 
                                    $row++;
                                @endphp
                            @endforeach
                            </tbody>
                        </table>                   
                    </div>

                    <div>
                        <table class="table table-nowrap align-middle mb-0 ms-auto font-monospace" style="width:335px">
                            <tbody>         
                                <tr>
                                    <td class="fw-bolder">SubTotal {{ config('constants.CURRENCY') }}</td>
                                    <td class="text-end fw-bolder">{{ config('constants.CURRENCY') . ' ' . number_format($subTotal, 2) }}</td>
                                </tr>

                                <tr>
                                    <td class="fw-bolder">Total Before Tax</td>
                                    <td class="text-end fw-bolder">{{ config('constants.CURRENCY') . ' ' . number_format($subTotal - $total_discount_amount, 2) }}</td>
                                </tr>

                                <tr>
                                    <td class="fw-bolder">Sales Tax</td>
                                    <td class="text-end fw-bolder">{{ config('constants.CURRENCY') . ' ' . number_format($totalTax, 2) }}</td>
                                </tr>
                                <tr style="border-bottom: 2px dashed #000 !important; "  class="border-top border-top-dashed fs-16">
                                    <td class="fw-bolder">Total Amount</td>
                                    <td class="text-end fw-bolder">{{ config('constants.CURRENCY') . ' ' . number_format(($subTotal - $total_discount_amount)+$totalTax, 2) }}</td>
                                </tr>
                                @php
                                    $total_advance_amount =0;
                                @endphp
                                @if (isset($customer_order_advance))
                                    @foreach ($customer_order_advance as $row)
                                    @php
                                        $total_advance_amount+= $row->advance_amount;
                                    @endphp
                                    @endforeach
                                @endif
                                @if ($total_advance_amount > 0)
                                <tr>
                                    <td class="fw-bolder">Advance Amount</td>
                                    <td class="text-end fw-bolder">{{ config('constants.CURRENCY') . ' ' . number_format($total_advance_amount, 2) }}</td>
                                </tr>
                                @endif

                            </tbody>
                        </table>
                        <!--end table-->
                    </div>
                </div>
                @if (isset($categoriesDataFormattedData) && !empty($categoriesDataFormattedData))
                    <div class="d-print-none mb-0 text-start">
                        <button type="button" class="btn btn-outline-secondary btn-sm d-print-none" onclick="toggleCategories()" id="btnCategories">
                            Hide Categories Form
                        </button>
                    </div>
                    <div class="mt-1" id="show_and_hide_section_of_categories_form">
                            @foreach($categoriesDataFormattedData as $category)
                                <h2 class="category-title mb-2 text-center border-bottom border-bottom-dashed " style="border-bottom: 2px dashed #000 !important; ">{{  $category['category_name'] }}</h2>
                                
                                @php
                                    $sections = $category['sections'];
                                @endphp

                                @for($i = 0; $i < count($sections); $i += 2)
                                <div class="row">
                                    <!-- Left Column -->
                                    <div class="col-md-6">
                                        @if(isset($sections[$i]))
                                        <div class="section-container">
                                            <h3 class="section-title text-center bg-light">{{ $sections[$i]['title'] }}</h3>
                                            <table class="table table-nowrap align-middle mb-0 ms-auto font-monospace category-table">
                                                <tbody>
                                                    @foreach($sections[$i]['fields'] as $field)
                                                    <tr>
                                                        <th>{{ $field['label'] }}</th>
                                                        <td>{{ $field['value'] ?? '-' }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endif
                                    </div>
                                    
                                    <!-- Right Column -->
                                    <div class="col-md-6">
                                        @if(isset($sections[$i + 1]))
                                        <div class="section-container">
                                            <h3 class="section-title text-center bg-light">{{ $sections[$i + 1]['title'] }}</h3>
                                            <table class="table table-nowrap align-middle mb-0 ms-auto font-monospace category-table">
                                                <tbody>
                                                    @foreach($sections[$i + 1]['fields'] as $field)
                                                    <tr>
                                                        <th>{{ $field['label'] }}</th>
                                                        <td>{{ $field['value'] ?? '-' }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                @endfor
                            @endforeach
                    </div>
                @endif
                <div class="card-body">
                    <div class="mt-4">
                        <p class=" justify-content-center pb-2  font-monospace">
                            <b>THANK YOU FOR YOUR VISIT!</b> It has been our pleasure to serve you, and we hope we see you again soon.
                        </p>
                    </div>
                   
                    <div class="bg-body p-2 rounded-2 mt-2 mb-1  font-monospace">
                        <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Terms : </span>
                        {!!  $business->payment_terms !!}
                        </p>
                    </div>
        
            
                <div class="d-print-none mb-5">
                    <div class="d-flex justify-content-center gap-2">
                        <a href="javascript:window.print()" class="btn btn-primary"><i class="ti ti-printer me-1"></i> Print</a>
                      
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
document.addEventListener("DOMContentLoaded", function () { 
    //    toggleCategories();
});   

 function toggleProducts() {
        const section = document.getElementById('show_and_hide_section_of_products');
        const btn = document.getElementById('btnProducts');

        if (section.style.display === 'none') {
            section.style.display = 'block';
            btn.innerText = 'Hide Products';
        } else {
            section.style.display = 'none';
            btn.innerText = 'Show Products';
        }
    }

    function toggleCategories() {
        const section = document.getElementById('show_and_hide_section_of_categories_form');
        const btn = document.getElementById('btnCategories');

        if (section.style.display === 'none') {
            section.style.display = 'block';
            btn.innerText = 'Hide Categories Form';
        } else {
            section.style.display = 'none';
            btn.innerText = 'Show Categories Form';
        }
    }
</script>
@endsection
