@extends('layouts.horizontal', ['title' => 'Customer Account', 'topbarTitle' => 'Account'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection
<style>
    .pointer {
        cursor: pointer;
    }
</style>
@section('content')

    <div class="customer-account-container container-fluid">
        <div class="row page-titles mb-3">
            <div class="col-md-5 align-self-center">
                <h2 class="text-themecolor">{{ $customer->customer_name }}</h2>                
            </div>            
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">                   
                        <div class="d-flex justify-content-between align-items-center mb-3">    
                            <div class="">
                                <h4 class="card-title">Customer Account: {{ $customer->customer_name }}</h4>
                                <h6 class="card-subtitle">Details of customer account and transactions.</h6>
                            </div>
                            <div>
                                <a data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="auto" data-bs-custom-class="tooltip-dark" data-bs-title="View Consent Forms" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-dark me-1" href="/consent_list?id_customers={{ $customer->id_customers }}" target="_blank">                                    
                                    <iconify-icon icon="fluent:signed-24-regular" style="cursor:pointer" class="text-dark fs-22"></iconify-icon>                                    
                                </a>
                                <button data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="auto" data-bs-custom-class="tooltip-dark" data-bs-title="Edit Customer" onclick="openCustomerEditModal({{ $customer->id_customers }})" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-dark">
                                    <iconify-icon icon="line-md:edit-twotone" style="cursor:pointer" class="text-dark fs-22"></iconify-icon>
                                </button>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 customer-details mt-4">
                                <p><strong>Cell :</strong> {{ $customer->customer_cell }}</p>
                                <p><strong>Email :</strong> {{ $customer->customer_email }}</p>
                                <p><strong>Card :</strong> {{ $customer->customer_card }}</p>
                                <p><strong>Area :</strong> {{ $customer->customer_area }}</p>
                                <p><strong>Care Of :</strong> {{ $customer->customer_careof }}</p>
                            </div>
                            <div class="col-md-4 customer-details mt-4">
                                <p><strong>Gender :</strong> {{ $customer->customer_gender }}</p>
                                <p><strong>Birthdate :</strong> {{ $customer->customer_birthdate }}</p>
                                <p><strong>Credit Limit :</strong> {{ $customer->allowed_balance }}</p>
                                <p><strong>Type :</strong> {{ $customer->customer_type }}</p>
                                <p><strong>Since :</strong> {{ $customer->customer_created_on }}</p>
                            </div>
                            <div class="col-md-4 customer-details mt-4">
                                <p><strong>Loyalty Points :</strong> {{ $customer_loyalty_points }}</p>

                                <p class="text-success fs-16">
                                    <strong>Retained : </strong>  {{ $customer_retained_amount }}
                                </p>
                                <label class="fw-bold mb-1">Transfer Retained Amount</label>
                                <div class="input-group mb-3">
                                    <input 
                                        type="number" 
                                        step="any"
                                        class="form-control"
                                        name="transfer_amount"
                                        id="transfer_amount"
                                        placeholder="Amount"
                                        min="1"
                                        max="{{ $customer_retained_amount }}"
                                    >

                                    <select class="form-select" name="branch_id" id="branch_id">
                                        <option value="">Select Branch</option>
                                        @foreach($businesses as $business)
                                            <option value="{{ $business->id_business }}">
                                                {{ $business->business_name }}
                                            </option>
                                        @endforeach
                                    </select>

                                    <button class="btn btn-success px-3" type="button" id="transfer_retained_btn" onclick="transferRetained({{$customer->id_customers}})">
                                        
                                        <iconify-icon icon="fa:paper-plane" class="fs-15"></iconify-icon>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-3 d-none" id="inactive-customer-alert"><!-- Inactive Customer Alert -->
            <div class="col-12">
                <a href="/send_sms_offer/{{ $customer->id_customers }}" class="text-info">
                    <div class="alert alert-info mb-0 text-center" role="alert">                        
                            <iconify-icon icon="mdi:information-outline" class="fs-20 align-middle"></iconify-icon>
                            <span class="align-middle ms-2">Customer has not visited us for over 3 months.</span>
                            <h4 class="mb-1 mt-2">Let's reach out to the customer to re-engage them.</h4>
                            <p class="mb-1">Consider offering them a special promotion or discount to encourage their return.</p>
                            <p class="mb-0"><a href="/send_sms_offer/{{ $customer->id_customers }}" class="text-info">Click here to send SMS offer</a></p>
                        </a>
                    </div>
                </a>
            </div>
        </div>
        <div class="row">            
            <div class="col-6">
                <div class="card" id="service-type-chart-container"><!-- Service Type Chart -->
                    <div class="card-body">
                        <h4 class="card-title">Customer's Service Preference</h4>
                        <!-- Polar Area Chart -->
                        <div dir="ltr">
                            <div id="service-type-chart" class="apex-charts"
                                data-colors="#93b373,#1F77B4,#29A3A3,#5BC0BE,#FFD166,#EF476F,#06D6A0,#073B4C,#8ECAE6,#FFB703,#FB8500,#8338EC,#118AB2"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="card" id="staff-preference-chart-container"><!-- Staff Preference Chart -->
                    <div class="card-body">
                        <h4 class="card-title">Customer's Staff Preference</h4>
                        <!-- Polar Area Chart -->
                        <div dir="ltr">
                            <div id="staff-preference-chart" class="apex-charts"
                                data-colors="#93b373,#1F77B4,#29A3A3,#5BC0BE,#FFD166,#EF476F,#06D6A0,#073B4C,#8ECAE6,#FFB703,#FB8500,#8338EC,#118AB2"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12"><!-- Transactions Table -->
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Transactions</h4>
                        <h6 class="card-subtitle">List of all transactions made by this customer.</h6>                   
                        <div class="table-responsive mt-2" style="overflow-y: auto; max-height: 1020px;">
                            <table id="customerInvoices" class="table table-bordered w-100 fs-12">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Services</th>
                                        <th>Price</th>
                                        <th>Day Ago</th>
                                        <th>Total</th>
                                        <th>Tax</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody> 
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        @if($customer_balance_invoices->count() > 0)
        <div class="row"><!-- Balance Invoices -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Balance Invoices</h4>
                        <h6 class="card-subtitle">List of all balance invoices for this customer.</h6>                   
                        <div class="table-responsive mt-2" style="overflow-y: auto; max-height: 400px;">
                            <table class="table table-bordered w-100 fs-12">
                                <thead>
                                    <tr>
                                        <th>Invoice #</th>
                                        <th>Date</th>
                                        <th>Total Payable</th>
                                        <th>Amount Paid</th>
                                        <th>Balance</th>
                                        <th>Recover</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($customer_balance_invoices as $invoice)
                                    <tr>
                                        <td>{{ $invoice->invoice_number }}</td>
                                        <td>{{ $invoice->invoice_date }}</td>
                                        <td>{{ $invoice->total_payable }}</td>
                                        <td>{{ $invoice->paid_earlier }}</td>
                                        <td class="text-danger">{{ $invoice->balance }}</td>
                                        <td>
                                            <a href="/new_recovery_invoice/{{ $invoice->id_invoice }}" target="invoice" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-dark recovery-btn " data-id="{{ $invoice->id }}">
                                                <iconify-icon icon="solar:hand-money-outline" class="fs-20 pointer" onclick="open_invoice({{ $invoice->id_invoice }})"></iconify-icon>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody> 
                            </table>
                            <div class="mt-2">
                                <strong>Total Balance: </strong> <span class="text-danger">{{ $customer_balance_invoices->sum('balance') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
        
        
        <div class="row color-records-section" id="colorRecordsSection"><!-- Color Records Section -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">{{ $customer->customer_name }}'s Color Records</h4>
                        <h6 class="card-subtitle">List of all color records for this customer.</h6>
                        <div class="table-responsive mt-2" style="overflow-y: auto; max-height: 400px;">
                            <table class="table table-bordered w-100 fs-12" id="colorRecordsTable">
                                <thead>
                                    <tr>
                                        <th>Record ID</th>
                                        <th>Type</th>
                                        <th>Color</th>
                                        <th>Water Content</th>
                                        <th>Date</th>
                                        <th>Time (min)</th>
                                        <th>Days Ago</th>
                                        <th>Charge</th>
                                        <th>Remarks</th>
                                        <th>Recommendation</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        

        <div class="row facial-records-section" id="facialRecordsSection"><!-- Facial Records Section -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">{{ $customer->customer_name }}'s Facial Records</h4>
                        <h6 class="card-subtitle">List of all facial records for this customer.</h6>
                        <div class="table-responsive mt-2" style="overflow-y: auto; max-height: 400px;">
                            <table class="table table-bordered w-100 fs-12" id="facialRecordsTable">
                                <thead>
                                    <tr>
                                        <th>Record ID</th>
                                        <th>Facial Name</th>
                                        <th>Exfoliant</th>
                                        <th>Mask</th>
                                        <th>Cleanser</th>
                                        <th>Date</th>
                                        <th>Time</th>
                                        <th>Days Ago</th>
                                        <th>Charge</th>
                                        <th>Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row eyelash-records-section" id="eyelashRecordsSection"><!-- Eyelash Records Section -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">{{ $customer->customer_name }}'s Eyelash Records</h4>
                        <h6 class="card-subtitle">List of all eyelash records for this customer.</h6>
                        <div class="table-responsive mt-2" style="overflow-y: auto; max-height: 400px;">
                            <table class="table table-bordered w-100 fs-12" id="eyelashRecordsTable">
                                <thead>
                                    <tr>
                                        <th>Record ID</th>
                                        <th>Type</th>
                                        <th>Thickness</th>
                                        <th>Length</th>
                                        <th>Curl</th>
                                        <th>Full Set/Refill</th>
                                        <th>Date</th>
                                        <th>Days Ago</th>
                                        <th>Charge</th>
                                        <th>Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@include('modals.customer_add')
@endsection

@section('scripts')
   <script>
    let baseURL = '{{ url("") }}'; // Base URL with subdirectory support
        document.addEventListener('DOMContentLoaded', function() {
           
            let url = baseURL + '/get_customer_invoices/{{ $customer->id_customers }}';
            
            // Server-side processing for customer invoices table
            let table = $('#customerInvoices').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: url,
                    type: 'GET'
                },
                columns: [
                    { data: 'formatted_invoice_date', name: 'formatted_invoice_date', title: 'Invoice Date', className: 'pointer' },
                    { data: 'services', name: 'services', title: 'Services', className: 'pointer' },
                    { data: 'staff_names', name: 'staff_names', title: 'Staff', className: 'pointer' },
                    { data: 'days_since_invoice', name: 'days_since_invoice', title: 'Days Ago', className: 'pointer', 
                        render: function(data, type, row) {                            
                            return `<label class="badge bg-success fs-12 p-1">${data} days ago</label> `;
                        }
                    },
                    { data: 'gross_wo_tax', name: 'gross_wo_tax', title: 'Gross (No Tax)' },
                    { data: 'tax_total', name: 'tax_total', title: 'Tax' , className: 'pointer'},
                    { data: 'total_payable', name: 'total_payable', title: 'Total Payable' , className: 'pointer'}
                ],
                order: [[0, 'desc']],
                responsive: true
            });

            table.on('click', 'tbody tr', function () {
                let data = table.row(this).data();
                open_invoice(data.id_invoice);
            });
            
            table.on('draw.dt', function() {
                let firstRow = table.row(0).data();
                let lapseDays = firstRow ? firstRow.days_since_invoice : 0;
                if (firstRow) {
                    console.log('After draw:', firstRow);
                     if(lapseDays > 90){
                        document.getElementById("inactive-customer-alert").classList.remove("d-none");
                    }
                }
            });

            // Render Service Type Chart
            serviceTypeChart();
            staffPreferenceChart();

            //fetch facial records data and populate the table
            let facialTable = $('#facialRecordsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: baseURL + '/get_customer_facial_records/{{ $customer->id_customers }}',
                    type: 'GET'
                },
                columns: [
                    { data: 'id', name: 'id', title: 'Record ID' },
                    { data: 'facial_name', name: 'facial_name', title: 'Facial Name' },
                    { data: 'exfoliant', name: 'exfoliant', title: 'Exfoliant' },
                    { data: 'mask', name: 'mask', title: 'Mask' },
                    { data: 'cleanser', name: 'cleanser', title: 'Cleanser' },
                    { data: 'record_date', name: 'record_date', title: 'Date' },
                    { data: 'record_time', name: 'record_time', title: 'Time' },
                    { data: 'days_ago', name: 'days_ago', title: 'Days Ago' }, 
                    { data: 'charge', name: 'charge', title: 'Charge' },
                    { data: 'remarks', name: 'remarks', title: 'Remarks' }
                ],
                order: [[0, 'desc']],
                responsive: true
            });
            //if no facial records, hide the facial records section
            facialTable.on('xhr', function() {
                var json = facialTable.ajax.json();
                if(json.recordsTotal == 0){
                    document.querySelector('.facial-records-section').classList.add('d-none');
                }
            });

            //fetch color records data and populate the table
            let colorTable = $('#colorRecordsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: baseURL + '/get_customer_color_records/{{ $customer->id_customers }}',
                    type: 'GET'
                },
                columns: [
                    { data: 'id', name: 'id', title: 'Record ID' },
                    { data: 'color_type', name: 'color_type', title: 'Type' },
                    { data: 'color_number', name: 'color_number', title: 'Color' },
                    { data: 'water_content', name: 'water_content', title: 'Water Content' },
                    { data: 'color_record_date', name: 'color_record_date', title: 'Date' },
                    { data: 'time_min', name: 'time_min', title: 'Time (min)' },
                    { data: 'days_ago', name: 'days_ago', title: 'Days Ago' }, 
                    { data: 'charge', name: 'charge', title: 'Charge' },
                    { data: 'color_remarks', name: 'color_remarks', title: 'Remarks' },
                    { data: 'recommendation', name: 'recommendation', title: 'Recommendation' }
                ],
                order: [[0, 'desc']],
                responsive: true
            });
            //if no color records, hide the color records section
            colorTable.on('xhr', function() {
                var json = colorTable.ajax.json();
                if(json.recordsTotal == 0){
                    document.querySelector('.color-records-section').classList.add('d-none');
                }
            });


            //fetch eyelash records data and populate the table
            let eyelashTable = $('#eyelashRecordsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: baseURL + '/get_customer_eyelash_records/{{ $customer->id_customers }}',
                    type: 'GET'
                },
                columns: [
                    { data: 'id_eyelashes', name: 'id_eyelashes', title: 'ID' },
                    { data: 'eyelash_type', name: 'eyelash_type', title: 'Type' },
                    { data: 'thickness', name: 'thickness', title: 'Thickness' },
                    { data: 'length', name: 'length', title: 'Length' },
                    { data: 'curl', name: 'curl', title: 'Curl' },
                    { data: 'full_set_refill', name: 'full_set_refill', title: 'Full Set/Refill' },                    
                    { data: 'lash_record_date', name: 'lash_record_date', title: 'Date' },                  
                    { data: 'days_ago', name: 'days_ago', title: 'Days Ago' }, 
                    { data: 'charge', name: 'charge', title: 'Charge' },
                    { data: 'lash_remarks', name: 'lash_remarks', title: 'Remarks' }
                ],
                order: [[0, 'desc']],
                responsive: true
            });
            //if no eyelash records, hide the eyelash records section
            eyelashTable.on('xhr', function() {
                var json = eyelashTable.ajax.json();
                if(json.recordsTotal == 0){
                    document.querySelector('.eyelash-records-section').classList.add('d-none');
                }
            });

        
        });

        function serviceTypeChart(){

            //fetch service category data as labels and series from server
            fetch(baseURL + '/get_customer_service_category_data/{{ $customer->id_customers }}')
            .then(response => response.json())
            .then(data => {
                if(data.length == 0){
                    //find the label and remove the heading
                    $("#service-type-chart-container").find(".card-title").remove();

                    html=`
                        <div class="bg-danger text-center text-light p-2 rounded mb-3">
                            <iconify-icon icon="mdi:alert-circle-outline" class="fs-60"></iconify-icon>
                            <p class="fs-16">This Customer has not visited us ever!</p>                            
                        </div>
                        <div class="bg-soft-success p-3 rounded">
                            <h5 class="">You can send them a special offer!</h5>
                            <p class="mb-0">Encourage them to book an appointment by sending a special offer or discount via SMS.</p>
                            <p class="mb-0"><a href="/send_sms_offer/{{ $customer->id_customers }}" class="text-info">Click here to send SMS offer</a></p>
                        </div>
                    `;
                    $("#service-type-chart").append(html);
                    return;
                } else {
                    var labels = data.labels;
                    var series = data.series;
                    renderServiceTypeChart(labels, series);
                }
            });
        }

        function renderServiceTypeChart(labels, series){

            var dataColors = $("#service-type-chart").data('colors');
            if (dataColors) {
                colors = dataColors.split(",");
            }

            var options = {
                series: series,
                chart: {
                    height: 380,
                    type: 'polarArea',
                },
                stroke: {
                    colors: ['#fff']
                },
                fill: {
                    opacity: 0.8
                },
                labels: labels,
                legend: {
                    position: 'right'
                },
                colors: colors,
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            var chart = new ApexCharts(document.querySelector("#service-type-chart"), options);
            chart.render();

        }

        function staffPreferenceChart(){

            //fetch staff preference data as labels and series from server
            fetch(baseURL + '/get_customer_staff_preference_data/{{ $customer->id_customers }}')
            .then(response => response.json())
            .then(data => {
                if(data.length == 0){
                    //find the label and remove the heading
                    $("#staff-preference-chart-container").find(".card-title").remove();

                    html=`
                        <div class="bg-soft-danger text-center p-2 rounded mb-3">
                            <iconify-icon icon="mdi:question-mark-circle-outline" class="fs-60"></iconify-icon>
                            <p class="fs-16">Would you like to Call the Customer?</p>                            
                        </div>
                        <div class="bg-soft-info p-3 rounded">
                            <h5 class="">You can call them with a special offer!</h5>
                            <p class="mb-0">Encourage them to book an appointment by sending a special offer or discount via SMS.</p>
                            <p class="mb-0"><label for="phone">Phone: {{ $customer->customer_cell }}</label> </p>
                        </div>
                    `;
                    $("#staff-preference-chart").append(html);
                   // document.getElementById("staff-preference-chart-container").classList.add("d-none");
                    return;
                } else {
                    var labels = data.labels;
                    var series = data.series;
                    renderStaffPreferenceChart(labels, series);
                }
            });
        }
        function renderStaffPreferenceChart(labels, series){

            var dataColors = $("#staff-preference-chart").data('colors');
            if (dataColors) {
                colors = dataColors.split(",");
            }

            var options = {
                series: series,
                chart: {
                    height: 380,
                    type: 'polarArea',
                },
                stroke: {
                    colors: ['#fff']
                },
                fill: {
                    opacity: 0.8
                },
                labels: labels,
                legend: {
                    position: 'right'
                },
                colors: colors,
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
                
            };

            var chart = new ApexCharts(document.querySelector("#staff-preference-chart"), options);
            chart.render();

        }

        function open_invoice(invoice_id){
            let url = baseURL + '/existing_service_invoice/' + invoice_id;
            window.open(url, 'invoice');
        }

        function openCustomerEditModal(customer_id) {
            console.log('editing customer: ' + customer_id);
            document.getElementById('id_customers').value = customer_id;
            $("#customer_id").val(customer_id);
            
            El = document.getElementById('customerAddModal');
            var modal = new bootstrap.Modal(El);
            modal.show();
        }

       function transferRetained(customer_id) {
        var $btn = $('#transfer_retained_btn');
       

        var amount = parseFloat($('#transfer_amount').val());
        var branchId = $('#branch_id').val();
        var maxAmount = parseFloat({{ $customer_retained_amount }});

        // Validation
        if(!amount || amount <= 0) {
            Swal.fire({
                title: 'info',
                text: 'Please enter a valid transfer amount.',
                icon: 'info',
                confirmButtonText: 'OK',
                customClass: { confirmButton: 'btn btn-danger' }
            });
            return;
        }

        if(amount > maxAmount) {
            Swal.fire({
                title: 'info',
                text: 'Amount cannot exceed retained balance.',
                icon: 'info',
                confirmButtonText: 'OK',
                customClass: { confirmButton: 'btn btn-danger' }
            });
            return;
        }

        if(!branchId) {
            Swal.fire({
                title: 'info',
                text: 'Please select a branch.',
                icon: 'info',
                confirmButtonText: 'OK',
                customClass: { confirmButton: 'btn btn-danger' }
            });
            return;
        }
        
        $btn.html(`<span class="spinner-border spinner-border-sm me-1 " role="status" aria-hidden="true" ></span>`);
        $btn.prop('disabled', true);

        // AJAX request
        $.ajax({
            url: "{{ route('customer.transfer_retained') }}",
            type: "POST",
            data: {
                _token: "{{ csrf_token() }}",
                customer_id: customer_id,
                amount: amount,
                branch_id: branchId
            },
            success: function(response) {
                $btn.html(`<iconify-icon icon="fa:paper-plane" class="fs-15"></iconify-icon>`);
                $btn.prop('disabled', false);

                if(response.succes === true) {
                    $('#transfer_amount').val('');
                    $('#branch_id').val('');
                    Swal.fire({
                        title: 'Success',
                        text: response.message,
                        icon: 'success',
                        confirmButtonText: 'OK',
                        customClass: { confirmButton: 'btn btn-success' }
                    });

                    setTimeout(() => {
                     window.location.reload(true); 
                    }, 500);


                } else {
                    Swal.fire({
                        title: 'Error',
                        text: response.message,
                        icon: 'error',
                        confirmButtonText: 'OK',
                        customClass: { confirmButton: 'btn btn-danger' }
                    });
                }
            },
            error: function(xhr, status, error) {
                $btn.html(`<iconify-icon icon="fa:paper-plane" class="fs-15"></iconify-icon>`);
                $btn.prop('disabled', false);

                Swal.fire({
                    title: 'Error',
                    text: 'Something went wrong. Please try again.',
                    icon: 'error',
                    confirmButtonText: 'OK',
                    customClass: { confirmButton: 'btn btn-danger' }
                });

                console.error(error);
            }
        });
    }
    </script>

@endsection