@extends('layouts.horizontal', ['title' => 'Customers', 'topbarTitle' => 'Customers'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <h2 class="mb-0">Customers</h2>
                    <div class="page-title-right d-flex align-items-center gap-3">
                        @php
                            $breadcrumb = getCurrentMenuBreadcrumb();
                        @endphp
                        @if(!empty($breadcrumb))
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-0 py-2">
                                    @foreach($breadcrumb as $index => $item)
                                        @if($index === count($breadcrumb) - 1)
                                            <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                        @else
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                        @endif
                                    @endforeach
                                </ol>
                            </nav>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">                   
                        <div class="table-responsive mt-2">
                            <table id="customersTable" class="table table-striped table-bordered w-100 fs-13">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Cell</th>
                                        <th>Email</th>
                                        <th>Card</th>
                                        <th>Area</th>
                                        <th>Created</th>
                                        <th>Updated</th>
                                        <th>Gender</th>
                                        <th>Birthdate</th>
                                        <th>Credit Limit</th>
                                        <th>Type</th>
                                        <th>Created At</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody> 
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('modals.customer_add')
@endsection

@section('scripts')

    <script>
        let baseURL = '{{ url("") }}'; // Use relative paths
        document.addEventListener('DOMContentLoaded', function() {
            get_customer_data();
        });

        function get_customer_data(){
            console.log('getting data');

            if ($.fn.DataTable.isDataTable('#customersTable')) {
                $('#customersTable').DataTable().clear().destroy();
            }
            let myIcon = ""; let myClass = "";
            const table = $('#customersTable').DataTable({
                processing: true,
                serverSide: true,
                layout: {
                    topStart: 'search',
                    topEnd: function() {
                        @can('create-customer')
                            return '<button onclick="openCustomerAddModal()" class="btn btn-outline-success btn-sm" id="newCustomerBtn"><iconify-icon icon="mdi:plus" class="me-1" width="16" inline></iconify-icon> New Customer</button>';
                        @endcan
                    },
                    bottomStart: {
                        pageLength: { menu: [10, 25, 50, 100] },
                        info: {}
                    },
                    bottomEnd: 'paging'
                },
                ajax: {
                    url: '{{ route("customers.customersdata") }}',
                    type: 'GET'
                },
                columns: [
                    { data: 'id_customers', name: 'id_customers' },
                    { data: 'customer_name' , render: function(data, type, row) {
                        return `<a href="{{ url('open_customer_account') }}/${row.id_customers}" target="customeraccount">${data}</a>`;
                    }},
                    { data: 'customer_cell', name: 'customer_cell' },
                    { data: 'customer_email', name: 'customer_email' },
                    { data: 'customer_card', name: 'customer_card' },
                    { data: 'customer_area', name: 'customer_area' },
                    { data: 'customer_created_at', name: 'customer_created_at' },
                    { data: 'last_updated_on', name: 'last_updated_on' },
                    { data: 'customer_gender', name: 'customer_gender' },
                    { data: 'customer_birthdate', name: 'customer_birthdate' },
                    { data: 'credit_limit', name: 'credit_limit' },
                    { data: 'customer_type', 
                        render: function(data, type, row) {                            
                            
                                if(data == "red"){
                                    myIcon = "solar:flag-linear";
                                    myClass="text-danger";
                                } else if(data == "orange"){
                                    myIcon = "noto-v1:star";
                                    myClass="";
                                } else if(data == "green"){
                                    myIcon = "solar:flag-linear";
                                    myClass="text-success";
                                } else {
                                    myIcon = "proicons:tag-add";
                                    myClass="text-info";
                                }
                                return `<iconify-icon icon="${myIcon}" style="cursor:pointer" class="fs-20 ${myClass}"></iconify-icon>`;
                            
                        },
                    },
                    { data: 'branch_name', name: 'branch_name' },
                    { data: null, 
                        orderable: false, 
                        searchable: false,
                        render: function(data, type, row) {
                            
                            return `
                                <a href="{{ url('open_customer_account') }}/${data.id_customers}" target="customeraccount" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-dark me-1">
                                   <iconify-icon icon="line-md:watch-loop"class="fs-20"></iconify-icon>
                                </a>
                                <button onclick="openCustomerEditModal(${data.id_customers})" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-dark">
                                    <iconify-icon icon="line-md:edit-twotone" style="cursor:pointer" class="text-dark fs-22"></iconify-icon>
                                </button>
                            `;
                        }
                    }
                ],
                order: [[0, 'desc']]
            });

        }

        function openCustomerAddModal(){
            El = document.getElementById('customerAddModal');
            var modal = new bootstrap.Modal(El);
            modal.show();
        }

        function openCustomerEditModal(customer_id){
            console.log('editing customer: ' + customer_id);
            document.getElementById('id_customers').value = customer_id;
            $("#customer_id").val(customer_id);
            
            El = document.getElementById('customerAddModal');
            var modal = new bootstrap.Modal(El);
            modal.show();
        }
    </script>   
   
@endsection