@extends('layouts.horizontal', ['title' => 'Daily Sheet', 'topbarTitle' => 'Daily Sheet',  'nonav' => true])

@section('css')
@endsection
<style>
        /* Custom styles for the scheduler */
        .page-container {
            max-width: 100% !important;
            margin: 0 auto;
        }
         tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
@section('content')

    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Daily Sheet</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row ">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filters</div>
                    <form id="invoicesform" method="GET" action="daily_sheet">                        
                        <div class="row">                                            
                            <div class="col-4">                                
                                <label class="form-label" for="date">Select Date</label>
                                <input type="date" class="form-control" id="date" name="date" value="{{ $today ?? date('Y-m-d') }}" placeholder="Select Date" required>
                                <input type="hidden" id="business_id" name="business_id" value="{{ session('business_id') }}">
                            </div>
                            <div class="col-2">
                                <button id="btn_refresh_table" type="submit" class="btn btn-sm btn-primary mt-4" >Run</button>
                            </div>
                            <div class="col-6 text-end">
                                
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <div class="dashboard">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <h4 class="card-title">As On {{ \Carbon\Carbon::parse($today)->format('d-m-Y') }}</h4>
                            <div>                                
                                <iconify-icon icon="file-icons:microsoft-excel" class="icon text-success fs-20 me-2" style="cursor: pointer;"></iconify-icon>
                                <iconify-icon icon="streamline-cyber:printer-3" class="icon text-primary fs-20 me-2" style="cursor:pointer;" onclick="printDailySheet()"></iconify-icon>                                
                            </div>
                        </div>
                        <div id="daily_sheet">
                            <!-- Daily Sheet content will be loaded here -->
                            <table id="daily_sheet_table">
                                <tbody>
                                    @php $cash_balance = 0; $cash_in_total = 0; $cash_out_total = 0; $cash_balance_total = 0; $card_total = 0; 
                                        $voucher_total = 0; $check_total = 0; $online_total = 0; $gross_sale_total = 0; $discount_total = 0;
                                        $retained_total = 0; $balance_total = 0; $advance_adjusted_total = 0; $retained_used_total = 0; $cc_tip_total = 0; 
                                        $sales_tax_total = 0; $cc_fee_total = 0; $payments_received_total = 0; $expense_total = 0;
                                    @endphp   
                                    @if(count($vouchers) > 0)
                                    <tr> <!-- INVOICE TABLE row -->
                                        <td>
                                            <table class="table table-bordered fs-12 w-100">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th colspan='21'><strong>Invoice Details {{ $today }}</strong></th>
                                                    </tr>
                                                    <tr>
                                                        <th>Inv.ID</th>
                                                        <th>@</th>
                                                        <th>Customer</th>
                                                        <th>By</th>
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                </thead>
                                                <tbody>                                                                                    
                                                    @foreach ($vouchers as $voucher)
                                                        <tr class ="fw-bolder {{ $voucher->invoice_status != 'valid' ? 'strike-through' : '' }}">
                                                            <td>{{ $voucher->invoice_day_seq }}</td>
                                                            <td>{{ \Carbon\Carbon::parse($voucher->created_on)->format('H:i') }}</td>
                                                            <td>{{ $voucher->customer_name }}</td>
                                                            <td>{{ $voucher->created_by }}</td>
                                                            <td>{{ number_format($voucher->cash, 2) }}</td>                                           
                                                            <td>{{ number_format($voucher->return_cash, 2) }}</td>                                            
                                                            @php $cash_balance = (float)$voucher->cash - (float)$voucher->return_cash; @endphp
                                                            <td>{{ number_format($cash_balance, 2) }}</td>                                           
                                                            <td>{{ number_format($voucher->card, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->voucher, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->bank, 2) }}</td>                                             
                                                            <td>{{ number_format($voucher->online, 2) }}</td>                                           
                                                            <td>{{ number_format($voucher->service_income + $voucher->retail_income + $voucher->training_income + $voucher->recurring_income, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->retail_discount + $voucher->service_discount, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->retained, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->balance, 2) }}</td>                                             
                                                            <td>{{ number_format($voucher->advance_adjusted, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->retained_used, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->cc_tip, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->sales_tax, 2) }}</td>                                            
                                                            <td>{{ number_format($voucher->cc_fee, 2) }}</td>                                            
                                                            <td>
                                                                {{ number_format($cash_balance + $voucher->card + $voucher->voucher + $voucher->bank + $voucher->online, 2) }}
                                                            </td>
                                                            @if ($voucher->invoice_status == 'valid')
                                                                @php 
                                                                    $cash_in_total += $voucher->cash; 
                                                                    $cash_out_total += $voucher->return_cash; 
                                                                    $cash_balance_total += $cash_balance; 
                                                                    $card_total += $voucher->card; 
                                                                    $voucher_total += $voucher->voucher; 
                                                                    $check_total += $voucher->bank; 
                                                                    $online_total += $voucher->online; 
                                                                    $gross_sale_total += ($voucher->service_income + $voucher->retail_income + $voucher->training_income + $voucher->recurring_income); 
                                                                    $discount_total += ($voucher->retail_discount + $voucher->service_discount); 
                                                                    $retained_total += $voucher->retained; 
                                                                    $balance_total += $voucher->balance; 
                                                                    $advance_adjusted_total += $voucher->advance_adjusted; 
                                                                    $retained_used_total += $voucher->retained_used; 
                                                                    $cc_tip_total += $voucher->cc_tip; 
                                                                    $sales_tax_total += $voucher->sales_tax; 
                                                                    $cc_fee_total += $voucher->cc_fee; 
                                                                    $payments_received_total += ($cash_balance + $voucher->card + $voucher->voucher + $voucher->bank + $voucher->online);
                                                                @endphp
                                                            @endif
                                                        </tr>
                                                        @if($voucher->invoice_type == 'sale')
                                                            @foreach($voucher->products as $product)
                                                                <tr @if($voucher->invoice_status != 'valid') class="strike-through" @endif>
                                                                    <td></td>
                                                                    <td colspan="18">
                                                                        &nbsp;&nbsp;&nbsp; - {{ $product->product_name }} | Qty: {{ $product->invoice_qty }} | Price: {{ number_format($product->price + $product->service_addition, 2) }} | Total: {{ number_format($product->final_price, 2) }}
                                                                    </td>
                                                                    <td>    </td>
                                                                </tr>
                                                            @endforeach
                                                            
                                                        @endif
                                                        @if($voucher->invoice_type == 'service')
                                                            @foreach($voucher->services as $service)
                                                                <tr @if($voucher->invoice_status != 'valid') class="strike-through" @endif>
                                                                    <td></td>
                                                                    <td colspan="18">
                                                                        &nbsp;&nbsp;&nbsp; - {{ $service->service_name }} | <strong> Start: {{ $service->service_time }} </strong> | Duration: {{ $service->duration }} mins | Price: {{ number_format($service->price + $service->service_addition, 2) }}
                                                                    </td>
                                                                    <td></td>
                                                                </tr>
                                                            @endforeach                                            
                                                        @endif
                                                    @endforeach 
                                                    <!-- End of Invoice Rows -->
                                                    <tfoot class="bg-light">
                                                        <tr>
                                                            <th colspan="4"></th>                                            
                                                            <th>Cash Received</th>
                                                            <th>Cash Return</th>
                                                            <th>Cash</th>
                                                            <th>Card</th>
                                                            <th>Voucher</th>
                                                            <th>Check</th>     
                                                            <th>Online</th>                                               
                                                            <th>Gross Sale</th>                                        
                                                            <th>Discount</th>
                                                            <th>Retained</th>
                                                            <th>Balance</th>
                                                            <th>Adv.Adj.</th>
                                                            <th>Ret.Adj.</th>
                                                            <th>CC.Tip</th>
                                                            <th>Tax</th>
                                                            <th>CC.Fee</th>
                                                            <th>Payments Received</th>
                                                        </tr>
                                                        <tr>
                                                            <th colspan="4">Invoices Breakup</th>
                                                            <th>{{ number_format($cash_in_total, 2) }}</th>
                                                            <th>- {{ number_format($cash_out_total, 2) }}</th>
                                                            <th>{{ number_format($cash_balance_total, 2) }}</th>
                                                            <th>{{ number_format($card_total, 2) }}</th>
                                                            <th>{{ number_format($voucher_total, 2) }}</th>
                                                            <th>{{ number_format($check_total, 2) }}</th>
                                                            <th>{{ number_format($online_total, 2) }}</th>
                                                            <th>{{ number_format($gross_sale_total, 2) }}</th>
                                                            <th>{{ number_format($discount_total, 2) }}</th>
                                                            <th>{{ number_format($retained_total, 2) }}</th>
                                                            <th>{{ number_format($balance_total, 2) }}</th>
                                                            <th>{{ number_format($advance_adjusted_total, 2) }}</th>
                                                            <th>{{ number_format($retained_used_total, 2) }}</th>
                                                            <th>{{ number_format($cc_tip_total, 2) }}</th>
                                                            <th>{{ number_format($sales_tax_total, 2) }}</th>
                                                            <th>{{ number_format($cc_fee_total, 2) }}</th>
                                                            <th>{{ number_format($payments_received_total, 2) }}</th>
                                                        </tr>                                                        
                                                    </tfoot>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr> <!-- End of INVOICE TABLE row -->
                                    @endif
                                    @if(count($training_vouchers) > 0)
                                    <tr><!-- TRAINING INVOICE TABLE -->
                                        <td> 
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th colspan='21'><strong>Training Invoice Details {{ $today }}</strong></th>
                                                    </tr>
                                                    <tr>
                                                        <th>Inv.ID</th>
                                                        <th></th>
                                                        <th>Customer</th>
                                                        <th>By</th>
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $training_cash_in_total = 0; $training_cash_out_total = 0; $training_cash_balance_total = 0; $training_card_total = 0; 
                                                        $training_voucher_total = 0; $training_check_total = 0; $training_online_total = 0; $training_gross_sale_total = 0; $training_discount_total = 0;
                                                        $training_retained_total = 0; $training_balance_total = 0; $training_advance_adjusted_total = 0; 
                                                        $training_retained_used_total = 0; $training_cc_tip_total = 0; $training_sales_tax_total = 0; $training_cc_fee_total = 0;
                                                        $training_payments_received_total = 0;
                                                    @endphp
                                                    @foreach ($training_vouchers as $training_invoice)
                                                        <tr class="{{ $training_invoice->voucher_status != 'Active' ? 'strike-through' : '' }}">
                                                            <td>{{ $training_invoice->id_program_invoices }}</td>
                                                            <td>{{ $training_invoice->voucher_date }}</td>
                                                            <td>{{ $training_invoice->customer_name }}</td>   
                                                            <td>{{ $training_invoice->created_by }}</td>                                                             
                                                            <td>{{ number_format($training_invoice->cash, 2) }}</td>  
                                                            <td>{{ number_format($training_invoice->cash_return, 2) }}</td>
                                                            @php $training_cash_balance = (float)$training_invoice->cash - (float)$training_invoice->cash_return; @endphp
                                                            <td>{{ number_format($training_cash_balance, 2) }}</td>                                           
                                                            <td>{{ number_format($training_invoice->card, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>{{ number_format($training_invoice->bank, 2) }}</td>                                             
                                                            <td>{{ number_format($training_invoice->online, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>                                         
                                                            <td>0.0</td>
                                                            <td>0.0</td>                                             
                                                            <td>0.0</td>
                                                            <td>0.0</td>                                            
                                                            <td>{{ number_format($training_invoice->cc_tip, 2) }}</td>                                                                                                 
                                                            <td>{{ number_format($training_invoice->sales_tax, 2) }}</td>                                            
                                                            <td>{{ number_format($training_invoice->cc_fee, 2) }}</td>
                                                            <td>{{ number_format($training_cash_balance + $training_invoice->card + $training_invoice->voucher + $training_invoice->bank + $training_invoice->online, 2) }}</td>
                                                            @if($training_invoice->voucher_status == 'Active')
                                                                @php
                                                                    $training_cash_in_total += $training_invoice->cash; 
                                                                    $training_cash_out_total += $training_invoice->cash_return; 
                                                                    $training_cash_balance_total += $training_cash_balance;
                                                                    $training_card_total += $training_invoice->card; 
                                                                    $training_voucher_total += 0;
                                                                    $training_check_total += $training_invoice->bank; 
                                                                    $training_online_total += $training_invoice->online;
                                                                    $training_gross_sale_total += ($training_invoice->service_income + $training_invoice->retail_income + $training_invoice->training_income + $training_invoice->recurring_income); 
                                                                    $training_discount_total += ($training_invoice->retail_discount + $training_invoice->service_discount); 
                                                                    $training_retained_total += $training_invoice->retained;
                                                                    $training_balance_total += $training_invoice->balance; 
                                                                    $training_advance_adjusted_total += $training_invoice->advance_adjusted;
                                                                    $training_retained_used_total += $training_invoice->retained_used; 
                                                                    $training_cc_tip_total += $training_invoice->cc_tip;
                                                                    $training_sales_tax_total += $training_invoice->sales_tax; 
                                                                    $training_cc_fee_total += $training_invoice->cc_fee;
                                                                    $training_payments_received_total += ($training_cash_balance + $training_invoice->card + $training_invoice->voucher + $training_invoice->bank + $training_invoice->online);
                                                                
                                                                    $cash_in_total += $training_invoice->cash; 
                                                                    $cash_out_total += $training_invoice->cash_return; 
                                                                    $cash_balance_total += $training_cash_balance; 
                                                                    $card_total += $training_invoice->card; 
                                                                    $voucher_total += 0; 
                                                                    $check_total += $training_invoice->bank; 
                                                                    $online_total += $training_invoice->online; 
                                                                    $gross_sale_total += ($training_invoice->service_income + $training_invoice->retail_income + $training_invoice->training_income + $training_invoice->recurring_income); 
                                                                    $discount_total += ($training_invoice->retail_discount + $training_invoice->service_discount); 
                                                                    $retained_total += $training_invoice->retained; 
                                                                    $balance_total += $training_invoice->balance; 
                                                                    $advance_adjusted_total += $training_invoice->advance_adjusted; 
                                                                    $retained_used_total += $training_invoice->retained_used; 
                                                                    $cc_tip_total += $training_invoice->cc_tip; 
                                                                    $sales_tax_total += $training_invoice->sales_tax; 
                                                                    $cc_fee_total += $training_invoice->cc_fee; 
                                                                    $payments_received_total += ($training_cash_balance + $training_invoice->card + $training_invoice->voucher + $training_invoice->bank + $training_invoice->online);
                                                                @endphp
                                                            @endif
                                                        </tr>
                                                    @endforeach 
                                                </tbody>
                                                <tfoot class="bg-light">
                                                    <tr>
                                                        <th colspan="4"></th>                                            
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                    <tr >
                                                        <th colspan="4">Training Breakup</th>
                                                        <th>{{ number_format($training_cash_in_total, 2) }}</th>
                                                        <th>- {{ number_format($training_cash_out_total, 2) }}</th>
                                                        <th>{{ number_format($training_cash_balance_total, 2) }}</th>
                                                        <th>{{ number_format($training_card_total, 2) }}</th>
                                                        <th>{{ number_format($training_voucher_total, 2) }}</th>
                                                        <th>{{ number_format($training_check_total, 2) }}</th>
                                                        <th>{{ number_format($training_online_total, 2) }}</th>
                                                        <th>{{ number_format($training_gross_sale_total, 2) }}</th>
                                                        <th>{{ number_format($training_discount_total, 2) }}</th>
                                                        <th>{{ number_format($training_retained_total, 2) }}</th>
                                                        <th>{{ number_format($training_balance_total, 2) }}</th>
                                                        <th>{{ number_format($training_advance_adjusted_total, 2) }}</th>
                                                        <th>{{ number_format($training_retained_used_total, 2) }}</th>
                                                        <th>{{ number_format($training_cc_tip_total, 2) }}</th>
                                                        <th>{{ number_format($training_sales_tax_total, 2) }}</th>
                                                        <th>{{ number_format($training_cc_fee_total, 2) }}</th>
                                                        <th>{{ number_format($training_payments_received_total, 2) }}</th>
                                                    </tr>                                                    
                                                </tfoot>
                                            </table>
                                        </td> 
                                    </tr><!-- End of TRAINING INVOICE TABLE -->                                    
                                    @endif
                                    @if(count($gift_vouchers) > 0)
                                    <tr><!-- GIFT VOUCHER TABLE -->
                                        <td> 
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th colspan='21'><strong>Gift Voucher Details {{ $today }}</strong></th>
                                                    </tr>
                                                    <tr>
                                                        <th>GV.ID</th>
                                                        <th></th>
                                                        <th>Customer</th>
                                                        <th>By</th>
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $gift_cash_in_total = 0; $gift_cash_out_total = 0; $gift_cash_balance_total = 0; $gift_card_total = 0; 
                                                        $gift_voucher_total = 0; $gift_check_total = 0; $gift_online_total = 0; $gift_gross_sale_total = 0; $gift_discount_total = 0;
                                                        $gift_retained_total = 0; $gift_balance_total = 0; $gift_advance_adjusted_total = 0; 
                                                        $gift_retained_used_total = 0; $gift_cc_tip_total = 0; $gift_sales_tax_total = 0; $gift_cc_fee_total = 0;
                                                        $gift_payments_received_total = 0;
                                                    @endphp
                                                    @foreach ($gift_vouchers as $gift_voucher)
                                                        <tr class="{{ $gift_voucher->voucher_status != 'Active' ? 'strike-through' : '' }}">
                                                            <td>{{ $gift_voucher->id_account_vouchers }}</td>
                                                            <td>{{ $gift_voucher->voucher_date }}</td>
                                                            <td>{{ $gift_voucher->customer_name }}</td>
                                                            <td>{{ $gift_voucher->created_by }}</td>
                                                            <td>{{ number_format($gift_voucher->cash, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>{{ number_format($gift_voucher->cash, 2) }}</td>
                                                            <td>{{ number_format($gift_voucher->card + $gift_voucher->cc_fee_expense, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>{{ number_format($gift_voucher->bank, 2) }}</td>
                                                            <td>{{ number_format($gift_voucher->online, 2) }}</td>
                                                            <td>{{ number_format($gift_voucher->grosstotal_service, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>
                                                            <td>{{ number_format($gift_voucher->sales_tax, 2) }}</td>
                                                            <td>{{ number_format($gift_voucher->cc_fee, 2) }}</td>
                                                            <td>{{ number_format($gift_voucher->cash + $gift_voucher->card + $gift_voucher->cc_fee_expense + $gift_voucher->bank + $gift_voucher->online, 2) }}</td>
                                                            @if ($gift_voucher->voucher_status == 'Active')
                                                                @php 
                                                                    $gift_cash_in_total += $gift_voucher->cash; 
                                                                    $gift_cash_out_total += 0;
                                                                    $gift_cash_balance_total += $gift_voucher->cash;
                                                                    $gift_card_total += ($gift_voucher->card + $gift_voucher->cc_fee_expense); 
                                                                    $gift_voucher_total += 0;
                                                                    $gift_check_total += $gift_voucher->bank; 
                                                                    $gift_online_total += $gift_voucher->online;
                                                                    $gift_gross_sale_total += $gift_voucher->grosstotal_service; 
                                                                    $gift_discount_total += 0;
                                                                    $gift_retained_total += 0;
                                                                    $gift_balance_total += 0;
                                                                    $gift_advance_adjusted_total += 0;
                                                                    $gift_retained_used_total += 0;
                                                                    $gift_cc_tip_total += 0;
                                                                    $gift_sales_tax_total += $gift_voucher->sales_tax;
                                                                    $gift_cc_fee_total += $gift_voucher->cc_fee;
                                                                    $gift_payments_received_total += ($gift_voucher->cash + $gift_voucher->card + $gift_voucher->cc_fee_expense + $gift_voucher->bank + $gift_voucher->online);
                                                                
                                                                    $cash_in_total += $gift_voucher->cash; 
                                                                    $cash_out_total += 0; 
                                                                    $cash_balance_total += $gift_voucher->cash; 
                                                                    $card_total += ($gift_voucher->card + $gift_voucher->cc_fee_expense); 
                                                                    $voucher_total += 0; 
                                                                    $check_total += $gift_voucher->bank; 
                                                                    $online_total += $gift_voucher->online; 
                                                                    $gross_sale_total += $gift_voucher->grosstotal_service; 
                                                                    $discount_total += 0; 
                                                                    $retained_total += 0; 
                                                                    $balance_total += 0; 
                                                                    $advance_adjusted_total += 0; 
                                                                    $retained_used_total += 0; 
                                                                    $cc_tip_total += 0; 
                                                                    $sales_tax_total += $gift_voucher->sales_tax; 
                                                                    $cc_fee_total += $gift_voucher->cc_fee; 
                                                                    $payments_received_total += ($gift_voucher->cash + $gift_voucher->card + $gift_voucher->cc_fee_expense + $gift_voucher->bank + $gift_voucher->online);
                                                                @endphp
                                                            @endif
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                                <tfoot class="bg-light">
                                                    <tr>
                                                        <th colspan="4"></th>                                            
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                    <tr >
                                                        <th colspan="4">Gift Voucher Breakup</th>
                                                        <th>{{ number_format($gift_cash_in_total, 2) }}</th>
                                                        <th>- {{ number_format($gift_cash_out_total, 2) }}</th>
                                                        <th>{{ number_format($gift_cash_balance_total, 2) }}</th>
                                                        <th>{{ number_format($gift_card_total, 2) }}</th>
                                                        <th>{{ number_format($gift_voucher_total, 2) }}</th>
                                                        <th>{{ number_format($gift_check_total, 2) }}</th>
                                                        <th>{{ number_format($gift_online_total, 2) }}</th>
                                                        <th>{{ number_format($gift_gross_sale_total, 2) }}</th>
                                                        <th>{{ number_format($gift_discount_total, 2) }}</th>
                                                        <th>{{ number_format($gift_retained_total, 2) }}</th>
                                                        <th>{{ number_format($gift_balance_total, 2) }}</th>
                                                        <th>{{ number_format($gift_advance_adjusted_total, 2) }}</th>
                                                        <th>{{ number_format($gift_retained_used_total, 2) }}</th>
                                                        <th>{{ number_format($gift_cc_tip_total, 2) }}</th>
                                                        <th>{{ number_format($gift_sales_tax_total, 2) }}</th>
                                                        <th>{{ number_format($gift_cc_fee_total, 2) }}</th>
                                                        <th>{{ number_format($gift_payments_received_total, 2) }}</th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </td>
                                    </tr><!-- End of GIFT VOUCHER TABLE -->
                                    @endif 
                                    @if(count($advance_vouchers) > 0)
                                    <tr><!-- ADVANCE VOUCHER TABLE -->
                                        <td> 
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th colspan='21'><strong>Advance Voucher Details {{ $today }}</strong></th>
                                                    </tr>
                                                    <tr>
                                                        <th>Adv. ID</th>
                                                        <th></th>
                                                        <th>Customer</th>                                                       
                                                        <th>By</th>
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>                                                  
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $advance_cash_in_total = 0; $advance_cash_out_total = 0; $advance_cash_balance_total = 0; $advance_card_total = 0; 
                                                        $advance_voucher_total = 0; $advance_check_total = 0; $advance_online_total = 0; $advance_gross_sale_total = 0; $advance_discount_total = 0;
                                                        $advance_retained_total = 0; $advance_balance_total = 0; $advance_advance_adjusted_total = 0; 
                                                        $advance_retained_used_total = 0; $advance_cc_tip_total = 0; $advance_sales_tax_total = 0; 
                                                        $advance_cc_fee_total = 0; $advance_payments_received_total = 0;
                                                    @endphp
                                                    @foreach ($advance_vouchers as $advance_voucher)
                                                        <tr class="{{ $advance_voucher->voucher_status != 'Active' ? 'strike-through' : '' }}">
                                                            <td>{{ $advance_voucher->id_account_vouchers }}</td>
                                                            <td>{{ $advance_voucher->voucher_date }}</td>
                                                            <td>{{ $advance_voucher->customer_name }}</td>                                                           
                                                            <td>{{ $advance_voucher->service_names }} By {{ $advance_voucher->created_by }}</td>                                                             
                                                            <td>{{ number_format($advance_voucher->cash, 2) }}</td>  
                                                            <td>0.0</td>
                                                            <td>{{ number_format($advance_voucher->cash, 2) }}</td>                                           
                                                            <td>{{ number_format($advance_voucher->card + $advance_voucher->cc_fee_expense, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>{{ number_format($advance_voucher->bank, 2) }}</td>                                             
                                                            <td>{{ number_format($advance_voucher->online, 2) }}</td>
                                                            <td>0.0</td>
                                                            <td>0.0</td>                                         
                                                            <td>0.0</td>
                                                            <td>0.0</td>                                             
                                                            <td>0.0</td>
                                                            <td>0.0</td>                                            
                                                            <td>0.0</td>                                                                                                 
                                                            <td>0.0</td>                                            
                                                            <td>{{ number_format($advance_voucher->cc_fee, 2) }}</td>
                                                            <td>{{ number_format($advance_voucher->cash + $advance_voucher->card + $advance_voucher->cc_fee_expense + $advance_voucher->bank + $advance_voucher->online, 2) }}</td>                                                            
                                                        </tr>
                                                        @php 
                                                            if($advance_voucher->voucher_status == 'Active') {
                                                                $advance_cash_in_total += $advance_voucher->cash; 
                                                                $advance_cash_out_total += 0;
                                                                $advance_cash_balance_total += $advance_voucher->cash;
                                                                $advance_card_total += ($advance_voucher->card + $advance_voucher->cc_fee_expense); 
                                                                $advance_voucher_total += 0;
                                                                $advance_check_total += $advance_voucher->bank; 
                                                                $advance_online_total += $advance_voucher->online;
                                                                $advance_gross_sale_total += 0; 
                                                                $advance_discount_total += 0;
                                                                $advance_retained_total += 0;
                                                                $advance_balance_total += 0;
                                                                $advance_advance_adjusted_total += 0;
                                                                $advance_retained_used_total += 0;
                                                                $advance_cc_tip_total += 0;
                                                                $advance_sales_tax_total += 0;
                                                                $advance_cc_fee_total += $advance_voucher->cc_fee;
                                                                $advance_payments_received_total += ($advance_voucher->cash + $advance_voucher->card + $advance_voucher->cc_fee_expense + $advance_voucher->bank + $advance_voucher->online);
                                                                
                                                                $cash_in_total += $advance_voucher->cash; 
                                                                $cash_out_total += 0; 
                                                                $cash_balance_total += $advance_voucher->cash; 
                                                                $card_total += ($advance_voucher->card + $advance_voucher->cc_fee_expense); 
                                                                $voucher_total += 0; 
                                                                $check_total += $advance_voucher->bank; 
                                                                $online_total += $advance_voucher->online; 
                                                                $gross_sale_total += 0; 
                                                                $discount_total += 0; 
                                                                $retained_total += 0; 
                                                                $balance_total += 0; 
                                                                $advance_adjusted_total += 0; 
                                                                $retained_used_total += 0; 
                                                                $cc_tip_total += 0; 
                                                                $sales_tax_total += 0; 
                                                                $cc_fee_total += $advance_voucher->cc_fee; 
                                                                $payments_received_total += ($advance_voucher->cash + $advance_voucher->card + $advance_voucher->cc_fee_expense + $advance_voucher->bank + $advance_voucher->online);
                                                            }
                                                        @endphp
                                                    @endforeach 
                                                </tbody>
                                                <tfoot class="bg-light">
                                                    <tr>
                                                        <th colspan="4"></th>                                            
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                    <tr >
                                                        <th colspan="4">Advance Voucher Breakup</th>
                                                        <th>{{ number_format($advance_cash_in_total, 2) }}</th>
                                                        <th>- {{ number_format($advance_cash_out_total, 2) }}</th>
                                                        <th>{{ number_format($advance_cash_balance_total, 2) }}</th>
                                                        <th>{{ number_format($advance_card_total, 2) }}</th>
                                                        <th>{{ number_format($advance_voucher_total, 2) }}</th>
                                                        <th>{{ number_format($advance_check_total, 2) }}</th>
                                                        <th>{{ number_format($advance_online_total, 2) }}</th>
                                                        <th>{{ number_format($advance_gross_sale_total, 2) }}</th>
                                                        <th>{{ number_format($advance_discount_total, 2) }}</th>
                                                        <th>{{ number_format($advance_retained_total, 2) }}</th>
                                                        <th>{{ number_format($advance_balance_total, 2) }}</th>
                                                        <th>{{ number_format($advance_advance_adjusted_total, 2) }}</th>
                                                        <th>{{ number_format($advance_retained_used_total, 2) }}</th>
                                                        <th>{{ number_format($advance_cc_tip_total, 2) }}</th>
                                                        <th>{{ number_format($advance_sales_tax_total, 2) }}</th>
                                                        <th>{{ number_format($advance_cc_fee_total, 2) }}</th>
                                                        <th>{{ number_format($advance_payments_received_total, 2) }}</th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </td>
                                    </tr><!-- End of ADVANCE VOUCHER TABLE -->
                                    @endif
                                    <tr>    <!-- OVERALL TOTAL TABLE -->
                                        <td>
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th></th>      
                                                        <th></th>
                                                        <th></th>
                                                        <th>@</th>                                      
                                                        <th>Cash Received</th>
                                                        <th>Cash Return</th>
                                                        <th>Cash</th>
                                                        <th>Card</th>
                                                        <th>Voucher</th>
                                                        <th>Check</th>     
                                                        <th>Online</th>                                               
                                                        <th>Gross Sale</th>                                        
                                                        <th>Discount</th>
                                                        <th>Retained</th>
                                                        <th>Balance</th>
                                                        <th>Adv.Adj.</th>
                                                        <th>Ret.Adj.</th>
                                                        <th>CC.Tip</th>
                                                        <th>Tax</th>
                                                        <th>CC.Fee</th>
                                                        <th>Payments Received</th>
                                                    </tr>
                                                    <tr >
                                                        <th >Overall Total</th>
                                                        <th colspan="2">{{ $business }}</th>
                                                        <th>{{ \Carbon\Carbon::now()->format('d.m.Y H:i') }}</th>
                                                        <th>{{ number_format($cash_in_total, 2) }}</th>
                                                        <th>- {{ number_format($cash_out_total, 2) }}</th>
                                                        <th>{{ number_format($cash_balance_total, 2) }}</th>
                                                        <th>{{ number_format($card_total, 2) }}</th>
                                                        <th>{{ number_format($voucher_total, 2) }}</th>
                                                        <th>{{ number_format($check_total, 2) }}</th>
                                                        <th>{{ number_format($online_total, 2) }}</th>
                                                        <th>{{ number_format($gross_sale_total, 2) }}</th>
                                                        <th>{{ number_format($discount_total, 2) }}</th>
                                                        <th>{{ number_format($retained_total, 2) }}</th>
                                                        <th>{{ number_format($balance_total, 2) }}</th>
                                                        <th>{{ number_format($advance_adjusted_total, 2) }}</th>
                                                        <th>{{ number_format($retained_used_total, 2) }}</th>
                                                        <th>{{ number_format($cc_tip_total, 2) }}</th>
                                                        <th>{{ number_format($sales_tax_total, 2) }}</th>
                                                        <th>{{ number_format($cc_fee_total, 2) }}</th>
                                                        <th>{{ number_format($payments_received_total, 2) }}</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </td>
                                    </tr> <!-- End of OVERALL TOTAL TABLE -->
                                    @if(count($expenses) > 0)
                                    <tr> <!-- EXPENSE TABLE -->
                                        <td>
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th colspan='6'><strong>Expenses Details {{ $today }}</strong></th>
                                                    </tr>
                                                    <tr>
                                                        <th>Expense ID</th>
                                                        <th>Paid To</th>
                                                        <td>Narration</td>
                                                        <th>Accounts</th>
                                                        <th>Amount</th>
                                                        <th>Paid By</th>                                                    
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($expenses as $expense)
                                                        <tr class="{{ $expense->voucher_status != 'Active' ? 'strike-through' : '' }}">
                                                            <td>{{ $expense->id_account_vouchers }}</td>
                                                            <td>{{ !str_contains($expense->account_heads, 'Salar') ? $expense->business_partner_name : '' }}</td> 
                                                            <td>{{ $expense->description }}</td>
                                                            <td>{!! $expense->account_heads !!}</td>  
                                                            <td>{{ number_format($expense->expense_amount, 2) }}</td>                                           
                                                            <td>{{ $expense->created_by }}</td>   
                                                            @php 
                                                                if($expense->voucher_status == 'Active' && str_contains($expense->account_heads, 'Till')) {
                                                                    $expense_total += $expense->expense_amount; 
                                                                }
                                                            @endphp                                                          
                                                        </tr>
                                                    @endforeach 
                                                </tbody>
                                                <tfoot class="bg-light">
                                                    <tr>
                                                        <th colspan="4">Total Expenses</th>
                                                        <th>{{ number_format($expense_total, 2) }}</th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </td>
                                    </tr>   <!-- End of EXPENSE TABLE -->
                                    @endif
                                    <tr> <!-- CASH REGISTER TABLE -->
                                        <td  class="top-aligned-cell">
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <thead class="bg-light">
                                                    <tr>
                                                        <th colspan='4'><strong>Cash Register Details {{ $today }}</strong></th>
                                                    </tr>
                                                    <tr>
                                                        <th>Cash Reconciliation</th>
                                                        <th>Cash Ledger</th>
                                                        <th>Denominations</th>                                                 
                                                    </tr>
                                                </thead>
                                                <tbody>                                                    
                                                    <tr>
                                                        <td style=" vertical-align: top;">
                                                            <table class="table table-bordered fs-12 w-100">
                                                                <tbody>
                                                                    <tr>
                                                                        <td><strong>Today's Cash:</strong></td><td>{{ number_format($cash_balance_total, 2) }}</td>                                                                        
                                                                    </tr>
                                                                    <tr>
                                                                        <td><strong>+ Cash Retained:</strong></td><td>{{ number_format($retained_total, 2) }}</td>                                                                        
                                                                    </tr>
                                                                    <tr>
                                                                        <td><strong>- Card Tips:</strong></td><td>{{ number_format($cc_tip_total, 2) }}</td>                                                                        
                                                                    </tr>
                                                                    <tr>
                                                                        <td><strong>- Cash Payments:</strong></td><td>{{ number_format($expense_total, 2) }}</td>                                                                        
                                                                    </tr>
                                                                </tbody>
                                                                <tfoot class="bg-light">
                                                                    <tr>
                                                                        <th><strong>Expected Cash Total:</strong></th><th>{{ number_format(($cash_balance_total + $retained_total - $cc_tip_total - $expense_total), 2) }}</th>   
                                                                        @php 
                                                                            $expected_cash_total = ($cash_balance_total + $retained_total - $cc_tip_total - $expense_total);
                                                                        @endphp                                                                     
                                                                    </tr>
                                                            </table>
                                                        </td>
                                                        <td style=" vertical-align: top;">
                                                            <table class="table table-bordered fs-12 w-100">
                                                                <tbody>
                                                                    <tr>
                                                                        <td><strong>Till Cash Balance C/F:</strong></td><td>{{ number_format($yesterdayCashRegister != null ? $yesterdayCashRegister->till_amounts : 0, 2) }}</td>                                                                        
                                                                    </tr>
                                                                    <tr>
                                                                        <td><strong>Additional Morning Cash:</strong></td><td>{{ number_format($todayCashRegister != null ? $todayCashRegister->cash_addition : 0, 2) }}</td>                                                                        
                                                                    </tr>
                                                                    <tr>
                                                                        <td><strong>Today Cash Reciepts:</strong></td><td>{{ number_format($expected_cash_total, 2) }}</td>                                                                        
                                                                    </tr>
                                                                </tbody>
                                                                <tfoot class="bg-light">
                                                                    <tr>
                                                                        @php 
                                                                            // Calculate Closing Cash
                                                                            $closing_cash = $expected_cash_total + ($yesterdayCashRegister != null ? $yesterdayCashRegister->till_amounts : 0) + ($todayCashRegister != null ? $todayCashRegister->cash_addition : 0);  
                                                                        @endphp
                                                                        <th><strong>Closing Cash:</strong></th><th>{{ number_format($closing_cash, 2) }}</th>                                                                        
                                                                    </tr>
                                                                <tfoot>
                                                            </table>
                                                        </td>
                                                        <td style=" vertical-align: top;">
                                                            <table class="table table-bordered fs-12 w-100">
                                                                <tbody>
                                                                    @php 
                                                                        $denominations = [
                                                                            5000, 1000, 500, 200, 100, 75, 50, 20, 10, 5, 1
                                                                        ];
                                                                        $denomination_sum = 0;
                                                                    @endphp

                                                                    @foreach($denominations as $denomination)
                                                                        @php
                                                                            $column = 'x' . (int) $denomination; // build column name like x1000, x500, etc.
                                                                            $count = $todayCashRegister->$column ?? 0;
                                                                            $total = $denomination * $count;
                                                                            $denomination_sum += $total;
                                                                        @endphp
                                                                        <tr>
                                                                            <td>
                                                                                <strong>
                                                                                    {{ config('constants.CURRENCY') . number_format($denomination, 2) . ' x ' . $count . ' = ' }}
                                                                                </strong>
                                                                            </td>
                                                                            <td>{{ number_format($total, 2) }}</td>
                                                                        </tr>
                                                                    @endforeach
                                                                </tbody>

                                                                <tfoot >
                                                                    <tr>
                                                                        <th  class="bg-light"><strong>Total Denominations:</strong></th>
                                                                        <th class="bg-light">{{ number_format($denomination_sum, 2) }}</th>
                                                                    </tr>
                                                                    <tr>
                                                                         @php 
                                                                            // Calculate Difference
                                                                            $difference = $denomination_sum - $closing_cash;
                                                                        @endphp
                                                                        <th class="{{ $difference < 0 ? 'text-danger' : 'text-success' }}"><strong>Difference:</strong></th>                                                                       
                                                                        <th class="{{ $difference < 0 ? 'text-danger' : 'text-success' }}">{{ number_format($difference, 2) }}</th>
                                                                    </tr>
                                                                </tfoot>
                                                            </table>
                                                        </td>                                              
                                                    </tr>                                                    
                                                </tbody>                                                
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td >
                                            <table class="table table-bordered fs-12 w-100 mt-2">
                                                <tbody>
                                                    <tr>
                                                        <td><strong>Printed By:</strong> {{ session('user_name') }} @ {{ now()->format('d-m-Y H:i') }}</td>
                                                        <td><strong>Checked By:</strong> ________________________</td>
                                                        <td><strong>Approved By:</strong> ________________________</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('scripts')
<script>

    function printDailySheet() {
        let printContents = document.getElementById('daily_sheet').innerHTML;
        let originalContents = document.body.innerHTML;
        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
        location.reload();
    }
</script>
@endsection
