@extends('layouts.horizontal', ['title' => 'Services Dashboard', 'topbarTitle' => 'Services Dashboard'])

@section('css')
@vite([
    'node_modules/flatpickr/dist/flatpickr.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
<style>
    /* Hide Select2 arrow for the Top Customers rows dropdown only */
    .top-customers-rows-container .select2-container--default .select2-selection--single .select2-selection__arrow {
        display: none;
    }
</style>
@endsection

@section('content')
@php
$start_date = now()->subDays(30)->toDateString(); 
$end_date   = now()->toDateString();
@endphp
<div class="row mb-4">
    <div class="col-12">
        <div class="page-title-box d-flex align-items-center justify-content-between">
            <h2 class="mb-0">Services Dashboard</h2>
            <div class="page-title-right d-flex align-items-center gap-2"> 
                {{-- Date Range:  --}}
                <div class="d-flex align-items-center gap-2">
                    <input class="form-control" id="dateRange" type="text" value="{{ \Carbon\Carbon::parse($start_date)->format('d-m-Y') }} - {{ \Carbon\Carbon::parse($end_date)->format('d-m-Y') }}" style="min-width: 200px;" />
                    <select class="form-select" id="business_id" name="business_id" data-toggle="select2">
                        @if (session('ho') =="Yes")
                            @foreach($branches as $business)
                                <option value="{{ $business->id_business }}" {{ $business->id_business == session('business_id') ? 'selected' : '' }}>{{ $business->business_name }}</option>
                            @endforeach
                        @else
                        <option value="{{ session('business_id') }}">{{ session('business_name') }}</option>
                        @endif
                    </select>
                    <button id="refresh-dashboard" type="button" style="width: 100px;" class="btn btn-ghost-dark btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh">
                        <iconify-icon icon="mdi:refresh" class="fs-22" ></iconify-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row row-cols-xxl-4 row-cols-md-4 row-cols-sm-1">

    @can('Total_Invoiced_Visits')
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Total Invoiced Visits</h4>
                    <p class="text-muted mb-0 state_date_range" style="font-size: 0.75rem;"></p>
                </div>
                <i class="ri-information-line info-icon" 
                   data-bs-toggle="tooltip" 
                   data-bs-placement="bottom" 
                   title="Shows the number of visits that have been invoiced versus the total number of visits for the selected date range. The percentage indicates how many visits have been invoiced out of the total."></i>
            </div>

            <div class="card-body pt-0">
                <div class="d-flex align-items-end gap-2 justify-content-between">
                    <div class="text-end flex-shrink-0">
                        <div id="total-orders-chart" data-colors="#ff5b5b,#F6F7FB"></div>
                    </div>
                    <div class="text-end">
                        <h3 class="fw-semibold" id="total-visits-value">-</h3>
                        <p class="text-muted mb-0" id="total-visits-change">Loading...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end col -->
    @endcan
    @can('Total_Revenue')
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Total Revenue</h4>
                    <p class="text-muted mb-0 state_date_range" style="font-size: 0.75rem;"></p>
                </div>
                <i class="ri-information-line info-icon" 
                   data-bs-toggle="tooltip" 
                   data-bs-placement="bottom" 
                   title="Displays the total service revenue generated from all invoiced visits for the selected date range, compared to the previous period of equal length. The progress bar shows the percentage change."></i>
            </div>

            <div class="card-body pt-0">
                <div class="d-flex align-items-center gap-2 justify-content-between">
                    <span class="badge bg-success rounded-pill fs-13" id="revenue-badge">- <i class="ti ti-trending-up"></i> </span>
                    <div class="text-end">
                        <h3 class="fw-semibold" id="total-revenue-value">-</h3>
                        <p class="text-muted mb-0" id="total-revenue-change">Loading...</p>
                    </div>
                </div>

                <div class="progress progress-soft progress-sm mt-3">
                    <div class="progress-bar bg-success" role="progressbar" id="revenue-progress" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
        </div>
    </div><!-- end col -->
    @endcan
    @can('Repeat_Customers')
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Repeat Customers</h4>
                    <p class="text-muted mb-0  state_date_range" style="font-size: 0.75rem;"></p>
                </div>
                <i class="ri-information-line info-icon" 
                   data-bs-toggle="tooltip" 
                   data-bs-placement="bottom" 
                   title="Shows the percentage of customers who have made 2 or more visits in the selected date range out of the total unique customers in that period. This indicates customer loyalty and retention."></i>
            </div>

            <div class="card-body pt-0">
                <div class="d-flex align-items-end gap-2 justify-content-between">
                    <div class="text-end flex-shrink-0">
                        <div id="new-users-chart" data-colors="#f9c851,#F6F7FB"></div>
                    </div>
                    <div class="text-end">
                        <h3 class="fw-semibold" id="new-customers-value">-</h3>
                        <p class="text-muted mb-0" id="new-customers-change">Loading...</p>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end col -->
    @endcan
    @can('Customer_Satisfaction')
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Customer Satisfaction</h4>
                    <p class="text-muted mb-0  state_date_range" style="font-size: 0.75rem;"></p>
                </div>
                <i class="ri-information-line info-icon" 
                   data-bs-toggle="tooltip" 
                   data-bs-placement="bottom" 
                   title="Displays the average customer satisfaction rating for the selected date range, compared to the previous period of equal length. The progress bar shows the percentage change in satisfaction."></i>
            </div>

            <div class="card-body pt-0">
                <div class="d-flex align-items-center gap-2 justify-content-between">
                    <span class="badge bg-info rounded-pill fs-13" id="satisfaction-badge">- <i class="ti ti-trending-up"></i> </span>
                    <div class="text-end">
                        <h3 class="fw-semibold" id="satisfaction-value">-</h3>
                        <p class="text-muted mb-0" id="satisfaction-change">Loading...</p>
                    </div>
                </div>

                <div class="progress progress-soft progress-sm mt-3">
                    <div class="progress-bar bg-info" role="progressbar" id="satisfaction-progress" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
        </div>
    </div><!-- end col -->
    @endcan
</div><!-- end row -->

<div class="row">

    @can('Top_Service_Categories')
        <div class="col-xxl-6 col-xl-6">
            <div class="card card-h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-0">Top 10 Service Categories</h4>
                        <p class="text-muted mb-0  top_10_services_categories_date_range" style="font-size: 0.75rem;"></p>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-2-fill"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('data-visits-chart', 'print')"><i class="ri-printer-line me-2"></i>Print Chart</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('data-visits-chart', 'png')"><i class="ri-download-line me-2"></i>Download as PNG</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('data-visits-chart', 'jpeg')"><i class="ri-download-line me-2"></i>Download as JPEG</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('data-visits-chart', 'pdf')"><i class="ri-file-pdf-line me-2"></i>Download as PDF</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('data-visits-chart', 'svg')"><i class="ri-file-line me-2"></i>Download as SVG</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body pt-2">
                    <div dir="ltr">
                        <div id="data-visits-chart" class="apex-charts" data-colors="#5b69bc,#ff8acc,#10c469,#35b8e0"></div>

                        <div class="row mt-3" id="category-legend">
                            <!-- Category legend will be populated by JavaScript -->
                        </div>
                    </div>
                </div> <!-- end card-body-->
            </div> <!-- end card-->
        </div> <!-- end col-->
    @endcan

    @can('Footfall_Heatmap')
    <div class="col-xxl-6 col-xl-6 col-lg-6">
        <div class="card card-h-100">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                <div class="d-flex align-items-center gap-2">
                    <div>
                        <h4 class="header-title mb-0">Footfall Heatmap</h4>
                        <p class="text-muted mb-0 footFall_date_range" style="font-size: 0.75rem;"></p>
                    </div>
                    <i class="ri-information-line info-icon" 
                       data-bs-toggle="tooltip" 
                       data-bs-placement="bottom" 
                       title="This heatmap visualizes daily footfall (number of invoiced visits) over the past 13 months from the current date. The date range selector does not affect this chart. Each cell represents a day, with colors indicating visit volume: gray (no visits), blue (low), light blue (medium), green (high), and red (very high). The color thresholds are dynamically calculated based on your data distribution to highlight busy and quiet periods."></i>
                </div>
                <div class="dropdown">
                    <button class="btn btn-sm btn-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="ri-more-2-fill"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('footfall-heatmap', 'print')"><i class="ri-printer-line me-2"></i>Print Chart</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('footfall-heatmap', 'png')"><i class="ri-download-line me-2"></i>Download as PNG</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('footfall-heatmap', 'jpeg')"><i class="ri-download-line me-2"></i>Download as JPEG</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('footfall-heatmap', 'pdf')"><i class="ri-file-pdf-line me-2"></i>Download as PDF</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('footfall-heatmap', 'svg')"><i class="ri-file-line me-2"></i>Download as SVG</a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body pt-2">
                <div dir="ltr" id="footfall-heatmap-container">
                    <div class="text-center py-4">
                        <div class="spinner-border spinner-border-sm text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <span class="ms-2">Loading footfall data...</span>
                    </div>
                </div>
            </div> <!-- end card-body-->
        </div> <!-- end card-->
    </div> <!-- end col-->
    @endcan
</div> <!-- end row-->

@can('Monthly_Performance')
<!-- Monthly Performance Chart - Own Row -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                <div>
                    {{-- <h4 class="header-title mb-0">Monthly Performance</h4> --}}
                    <h4 class="header-title mb-0">Performance Overview</h4>
                    <p class="text-muted mb-0 date-range-past-31-days monthly_performance-date-rate" style="font-size: 0.75rem;">Past 31 Days</p>
                </div>
                <div class="dropdown">
                    <button class="btn btn-sm btn-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="ri-more-2-fill"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('monthly-performance-chart', 'print')"><i class="ri-printer-line me-2"></i>Print Chart</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('monthly-performance-chart', 'png')"><i class="ri-download-line me-2"></i>Download as PNG</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('monthly-performance-chart', 'jpeg')"><i class="ri-download-line me-2"></i>Download as JPEG</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('monthly-performance-chart', 'pdf')"><i class="ri-file-pdf-line me-2"></i>Download as PDF</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('monthly-performance-chart', 'svg')"><i class="ri-file-line me-2"></i>Download as SVG</a></li>
                    </ul>
                </div>
            </div>

            <div class="card-body p-0 pt-1">
                <div dir="ltr" class="px-2">
                    <div id="monthly-performance-chart" class="apex-charts" data-colors="#5b69bc,#ff8acc,#10c469,#35b8e0,#f9c851"></div>
                </div>

                <div class="border-top border-dashed mt-2">
                    <div class="row text-center align-items-center g-0">
                        <div class="col-md-3 col-6">
                            <p class="text-muted mt-3 mb-1">Visits</p>
                            <h4 class="mb-3" id="monthly-visits-total">-</h4>
                        </div>
                        <div class="col-md-3 col-6 border-start border-end border-dashed">
                            <p class="text-muted mt-3 mb-1">Services</p>
                            <h4 class="mb-3" id="monthly-services-total">-</h4>
                        </div>
                        <div class="col-md-3 col-6 border-end border-dashed">
                            <p class="text-muted mt-3 mb-1">Revenue</p>
                            <h4 class="mb-3" id="monthly-revenue-total">-</h4>
                        </div>
                        <div class="col-md-3 col">
                            <p class="text-muted mt-3 mb-1">Balances</p>
                            <h4 class="mb-3" id="monthly-balances-total">-</h4>
                        </div>
                    </div>
                </div>

            </div>
        </div> <!-- end card-->
    </div> <!-- end col-->
</div> <!-- end row-->
@endcan

@can('Top_Performing_Staff')
<!-- Top Staff Performance Slider -->
<div class="row">
    <div class="col-12">
        <div class="mb-2">
            <h4 class="header-title mb-0">Top Performing Staff</h4>
            <p class="text-muted mb-0 date-range-current-month-staff" style="font-size: 0.75rem;">Current Month</p>
        </div>
        <div id="staff-slider-container" class="staff-slider-container mb-2">
            <div class="d-flex align-items-center justify-content-center mb-2" style="display: none !important;">
                <span id="staff-slider-info" class="text-muted">Loading...</span>
            </div>
            <div class="staff-slider-content-wrapper">
                <!-- Left Arrow Button -->
                <button class="btn btn-light btn-sm staff-slider-arrow staff-slider-arrow-left" id="staff-slider-prev" onclick="prevStaffSlide()" style="display: none;">
                    <i class="ri-arrow-left-line fs-18"></i>
                </button>
                <div id="staff-slider-wrapper" class="staff-slider-wrapper">
                    <div id="staff-slider-track" class="staff-slider-track">
                        <div class="col-12 text-center py-4" style="flex: 0 0 100%; width: 100%;">
                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <span class="ms-2">Loading staff performance...</span>
                        </div>
                    </div>
                </div>
                <!-- Right Arrow Button -->
                <button class="btn btn-light btn-sm staff-slider-arrow staff-slider-arrow-right" id="staff-slider-next" onclick="nextStaffSlide()" style="display: none;">
                    <i class="ri-arrow-right-line fs-18"></i>
                </button>
            </div>
        </div>
    </div>
</div> <!-- end row-->
@endcan

<!-- Top Customers and Top Services Section -->
<div class="row">
    @can('Top_Customers')
        <div class="col-xxl-6 col-xl-6">
            <div class="card card-h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-0">Top Customers</h4>
                        <p class="text-muted mb-0 date-range-past-3-months date-range-for-top-customer" style="font-size: 0.75rem;">Past 3 Months</p>
                    </div>
                    <div class="d-flex align-items-center gap-2 top-customers-rows-container">
                        <div class="d-flex align-items-center">
                            <label for="top-customers-rows" class="me-1 mb-0 text-muted" style="font-size: 0.75rem;">Rows</label>
                            <select
                                id="top-customers-rows"
                                class="form-select form-select-sm"
                                style="width: 72px;"
                                data-toggle="select2"
                                data-minimum-results-for-search="Infinity"
                            >
                                <option value="10" selected>10</option>
                                <option value="20">20</option>
                                <option value="30">30</option>
                            </select>
                        </div>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="ri-more-2-fill"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportTopCustomers('print')"><i class="ri-printer-line me-2"></i>Print Table</a></li>
                                <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportTopCustomers('csv')"><i class="ri-download-line me-2"></i>Download CSV</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive" style="max-height: 360px; overflow-y: auto;">
                        <table id="top-customers-table" class="table table-custom align-middle table-nowrap table-hover table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Customer</th>
                                    <th>Phone</th>
                                    <th>Visits</th>
                                    <th>Revenue</th>
                                    <th>Balance</th>
                                    <th>Last Visit</th>
                                </tr>
                            </thead>
                            <tbody id="top-customers-tbody">
                                <tr>
                                    <td colspan="6" class="text-center py-4">
                                        <div class="spinner-border spinner-border-sm text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                        <span class="ms-2">Loading top customers...</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col-->
    @endcan
    
    @can('Yearly_Sale_Comparison')
        <div class="col-xxl-6 col-xl-6 col-lg-6">
            <div class="card card-h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-0">Yearly Service Comparison</h4>
                        <p class="text-muted mb-0" style="font-size: 0.75rem;">All Years</p>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-more-2-fill"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('statistics-chart', 'print')"><i class="ri-printer-line me-2"></i>Print Chart</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('statistics-chart', 'png')"><i class="ri-download-line me-2"></i>Download as PNG</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('statistics-chart', 'jpeg')"><i class="ri-download-line me-2"></i>Download as JPEG</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('statistics-chart', 'pdf')"><i class="ri-file-pdf-line me-2"></i>Download as PDF</a></li>
                            <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('statistics-chart', 'svg')"><i class="ri-file-line me-2"></i>Download as SVG</a></li>
                        </ul>
                    </div>
                </div>

                <div class="card-body p-0 pt-1">
                    <div dir="ltr" class="px-1">
                        <div id="statistics-chart" class="apex-charts" data-colors="#5b69bc"></div>
                    </div>

                    <div class="border-top border-dashed mt-2">
                        <div class="row text-center align-items-center g-0">
                            <div class="col-12">
                                <p class="text-muted mt-3 mb-1">Total Service Revenue This Year</p>
                                <h4 class="mb-3" id="yearly-sales-total">-</h4>
                            </div>
                        </div>
                    </div>

                </div>
            </div> <!-- end card-->
        </div> <!-- end col-->
    @endcan

</div> <!-- end row-->

<!-- Monthly Service Collection Breakup Chart -->
<div class="row">
    <div class="col-12">
        <div class="card card-h-100">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                <div>
                    <h4 class="header-title mb-0">Monthly Service Collection Breakup</h4>
                    <p class="text-muted mb-0" style="font-size: 0.75rem;">Date Range: <span id="service-collection-breakup-date-range"></span></p>
                </div>
                <div class="dropdown">
                    <button class="btn btn-sm btn-light" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="ri-more-2-fill"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('service-collection-breakup-chart', 'print')"><i class="ri-printer-line me-2"></i>Print Chart</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('service-collection-breakup-chart', 'png')"><i class="ri-download-line me-2"></i>Download as PNG</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('service-collection-breakup-chart', 'jpeg')"><i class="ri-download-line me-2"></i>Download as JPEG</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('service-collection-breakup-chart', 'pdf')"><i class="ri-file-pdf-line me-2"></i>Download as PDF</a></li>
                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="exportChart('service-collection-breakup-chart', 'svg')"><i class="ri-file-line me-2"></i>Download as SVG</a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body pt-2">
                <center><div class="centerDivForLoader"></div></center>
                <div dir="ltr" id="service-collection-breakup-chart">
                    
                </div>
            </div>
        </div>
    </div>
</div> <!-- end row-->

@endsection

@section('scripts')
<!-- Load jsPDF for PDF export functionality -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
    // Make jsPDF globally available for PDF export functionality
    if (typeof window.jspdf === 'undefined' && typeof jspdf !== 'undefined') {
        window.jspdf = { jsPDF: jspdf.jsPDF };
    }

    // Pass currency from PHP config to JavaScript
    window.CURRENCY_SYMBOL = '{{ config("constants.CURRENCY", "$") }}';
    // Base URL for AJAX calls (same as PHP url("")) - using const like retaildashboard
    const baseURL = '{{ url("") }}';
    // Route URLs for customer account
    window.OPEN_CUSTOMER_ACCOUNT_BASE_URL = '{{ url("open_customer_account") }}';

    // Chart instances
    let totalVisitsChart = null;
    let newCustomersChart = null;
    let dataVisitsChart = null;
    let statisticsChart = null;
    let monthlyPerformanceChart = null;
    let footfallHeatmapChart = null;
    let serviceCollectionBreakupChart = null;

    // Top customers state
    let topCustomersData = [];

    // Staff slider state
    let staffData = [];
    let currentStaffPage = 0;
    const staffPerPage = 4;

    // Monthly Performance Chart colors
    let colors5 = ["#921d5f", "#ffc7ff", "#f9c851", "#923024", "#ffbeab"];

    function loadDashboardData() {
        const dateRange = getDateRangeForMonths();

        if (!dateRange) return;

        const from = dateRange.start;
        const to   = dateRange.end;

        const startDate = new Date(from);
        const endDate   = new Date(to);

        const maxMonths = 24;

        const diffMonths =
            (endDate.getFullYear() - startDate.getFullYear()) * 12 +
            (endDate.getMonth() - startDate.getMonth());

        if (diffMonths > maxMonths) {
            Swal.fire({
                title: 'Warning',
                text: "You cannot select a date range longer than 2 years.",
                icon: 'warning',
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-danger'
                }
            });
            return;
        }

        updateDateRangeLabels(dateRange);
        initializeCharts(dateRange);

        // Load all data
        loadDashboardStats(dateRange);
        loadTopCustomers(dateRange);
        loadTopServiceCategories(dateRange);
        loadFootfallHeatmap(dateRange);
        loadMonthlyPerformance(dateRange);
        loadMonthlySales(dateRange);
        loadTopStaff(dateRange);
        loadMonthlyServicePaymentSummary(dateRange);
    }
    function getDateRangeForMonths() {
        return { 
            start: document.getElementById('dateRange').value.split(' to ')[0], 
            end: document.getElementById('dateRange').value.split(' to ')[1],
        };
    }


    // Format number with commas
    function formatNumber(num) {
        if (num >= 1000000) {
            return (num / 1000000).toFixed(1) + 'M';
        } else if (num >= 1000) {
            return (num / 1000).toFixed(1) + 'K';
        }
        return num.toString();
    }

    // Format currency
    function formatCurrency(amount) {
        const currencySymbol = window.CURRENCY_SYMBOL || '$';
        // Convert to number, handling null, undefined, strings, etc.
        const numAmount = parseFloat(amount) || 0;
        if (numAmount >= 1000000) {
            return currencySymbol + (numAmount / 1000000).toFixed(2) + 'M';
        } else if (numAmount >= 1000) {
            return currencySymbol + (numAmount / 1000).toFixed(1) + 'K';
        }
        return currencySymbol + numAmount.toFixed(2);
    }

    // Format date for display (e.g., "01 Jan 2024")
    function formatDateForDisplay(date) {
        const d = new Date(date);
        const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
        const day = String(d.getDate()).padStart(2, '0');
        const month = months[d.getMonth()];
        const year = d.getFullYear();
        return `${day} ${month} ${year}`;
    }

    // Calculate and update date range labels
    function updateDateRangeLabels(dateRange) {
        const now = new Date();
        const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
        
        // Current Month: First day of current month to today
        const currentMonthStart = new Date(now.getFullYear(), now.getMonth(), 1);
        const currentMonthRange = `${formatDateForDisplay(currentMonthStart)} - ${formatDateForDisplay(today)}`;
        
        // Past 3 Months: 3 months ago to today
        const threeMonthsAgo = new Date(now.getFullYear(), now.getMonth() - 3, now.getDate());
        const threeMonthsRange = `${formatDateForDisplay(threeMonthsAgo)} - ${formatDateForDisplay(today)}`;
        
        // Past 31 Days: 30 days ago to today (31 days total, matching PHP query which uses 0-30 days)
        const past31Days = new Date(today);
        past31Days.setDate(past31Days.getDate() - 30);
        const past31DaysRange = `${formatDateForDisplay(past31Days)} - ${formatDateForDisplay(today)}`;
        
        // Past Month: First day of last month to today (as per getTopServices query)
        const lastMonthStart = new Date(now.getFullYear(), now.getMonth() - 1, 1);
        const pastMonthRange = `${formatDateForDisplay(lastMonthStart)} - ${formatDateForDisplay(today)}`;
        
        // Update all labels
        $('.date-range-current-month').each(function() {
            const $el = $(this);
            const originalText = $el.data('original-text') || $el.text().split('(')[0].trim();
            if (!$el.data('original-text')) {
                $el.data('original-text', originalText);
            }
            $el.text(`${originalText} (${currentMonthRange})`);
        });
        
        $('.date-range-past-3-months').each(function() {
            const $el = $(this);
            const originalText = $el.data('original-text') || $el.text().split('(')[0].trim();
            if (!$el.data('original-text')) {
                $el.data('original-text', originalText);
            }
            $el.text(`${originalText} (${threeMonthsRange})`);
        });
        
        $('.date-range-past-31-days').each(function() {
            const $el = $(this);
            const originalText = $el.data('original-text') || $el.text().split('(')[0].trim();
            if (!$el.data('original-text')) {
                $el.data('original-text', originalText);
            }
            $el.text(`${originalText} (${past31DaysRange})`);
        });
        
        $('.date-range-past-month').each(function() {
            const $el = $(this);
            const originalText = $el.data('original-text') || $el.text().split('(')[0].trim();
            if (!$el.data('original-text')) {
                $el.data('original-text', originalText);
            }
            $el.text(`${originalText} (${pastMonthRange})`);
        });
    }

    // Load Dashboard Stats
    function loadDashboardStats(dateRange) {
        let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        params.business_id = $("#business_id").val();

        // Respect selected rows per page when fetching data
        let limit = 10;
        const rowsSelect = document.getElementById('top-customers-rows');
        if (rowsSelect) {
            const parsed = parseInt(rowsSelect.value, 10);
            if (!isNaN(parsed) && parsed > 0) {
                limit = parsed;
            }
        }
        params.limit = limit;
        
        // Note: Chart instances are created/destroyed in initializeCharts()
        // We don't destroy or clear DOM here - just update the existing charts with new data

        if ($('#total-visits-value').length) 
            $('#total-visits-value').text('0');
        if($('#total-visits-change').length) 
            $('#total-visits-change').text('No data available');
        if ($('#total-revenue-value').length) 
            $('#total-revenue-value').text((window.CURRENCY_SYMBOL || '$') + '0');
        if ($('#total-revenue-change').length) 
            $('#total-revenue-change').text('No data available');
        if ($('#new-customers-value').length) 
            $('#new-customers-value').text('0 | 0');
        if ($('#new-customers-change').length) 
            $('#new-customers-change').text('Repeat | Total');
        if ($('#satisfaction-value').length) 
            $('#satisfaction-value').text('0%');
        if ($('#satisfaction-change').length) 
            $('#satisfaction-change').text('No data available');


        $.ajax({
            url: baseURL + '/dashboard/stats',
            type: 'GET',
            data: params,
            timeout: 10000,
            success: function(data) {
                
                $('.state_date_range').text(`${data.from}  →  ${data.to}`);
                var previous_period =   `${data.prevFrom} → ${data.prevTo}`; 
                
                if (data.prevFrom === data.prevTo) {
                    previous_period = data.prevTo;
                }

                if (!data) {
                    if ($('#total-visits-value').length) 
                        $('#total-visits-value').text('0');
                    if($('#total-visits-change').length) 
                        $('#total-visits-change').text('No data available');
                    if ($('#total-revenue-value').length) 
                        $('#total-revenue-value').text((window.CURRENCY_SYMBOL || '$') + '0');
                    if ($('#total-revenue-change').length) 
                        $('#total-revenue-change').text('No data available');
                    if ($('#new-customers-value').length) 
                        $('#new-customers-value').text('0 | 0');
                    if ($('#new-customers-change').length) 
                        $('#new-customers-change').text('Repeat | Total');
                    if ($('#satisfaction-value').length) 
                        $('#satisfaction-value').text('0%');
                    if ($('#satisfaction-change').length) 
                        $('#satisfaction-change').text('No data available');
                    return;
                }

                // Update Total Visits (Total vs Invoiced)
                const totalVisits = data.total_visits?.total || 0;
                const invoicedVisits = data.total_visits?.invoiced || 0;
                const invoicedPercentage = data.total_visits?.percentage || 0;
                if ($('#total-visits-value').length) 
                    $('#total-visits-value').text(formatNumber(invoicedVisits) + ' / ' + formatNumber(totalVisits));
                
                if($('#total-visits-change').length) 
                    $('#total-visits-change').text('Invoiced / Total');
                
                // Update Total Visits Chart (Circle progress bar showing invoiced percentage)
                if (totalVisitsChart) {
                    const safePercentage = isNaN(invoicedPercentage) || !isFinite(invoicedPercentage) ? 0 : Math.max(0, Math.min(100, invoicedPercentage));
                    totalVisitsChart.updateSeries([safePercentage]);
                }

                // Update Total Revenue
                const revenueChange = data.total_revenue?.change || 0;
                const revenueChangeText = revenueChange > 0 ? `+${revenueChange}%` : `${revenueChange}%`;
                if ($('#total-revenue-value').length) 
                    $('#total-revenue-value').text(formatCurrency(data.total_revenue?.current || 0));
                if ($('#total-revenue-change').length) 
                    $('#total-revenue-change').text(`${previous_period} (${revenueChangeText})`);
                if ($('#revenue-badge').length) 
                    $('#revenue-badge').html(`${revenueChangeText} <i class="ti ti-trending-${revenueChange >= 0 ? 'up' : 'down'}"></i>`);
                if ($('#revenue-progress').length) 
                    $('#revenue-progress').css('width', Math.min(Math.abs(revenueChange), 100) + '%'); 

                // Update Repeat Customers (Repeat vs Total)
                const repeatCustomers = data.repeat_customers?.repeat || 0;
                const totalUniqueCustomers = data.repeat_customers?.total || 0;
                const repeatPercentage = data.repeat_customers?.percentage || 0;
                if ($('#new-customers-value').length) 
                    $('#new-customers-value').text(formatNumber(repeatCustomers) + ' / ' + formatNumber(totalUniqueCustomers));
                if ($('#new-customers-change').length) 
                    $('#new-customers-change').text('Repeat / Total');
                
                // Update Repeat Customers Chart (Circle progress bar showing repeat percentage)
                if (newCustomersChart) {
                    const safePercentage = isNaN(repeatPercentage) || !isFinite(repeatPercentage) ? 0 : Math.max(0, Math.min(100, repeatPercentage));
                    newCustomersChart.updateSeries([safePercentage]);
                }

                // Update Customer Satisfaction
                const satisfaction = data.customer_satisfaction?.percentage || 0;
                if ($('#satisfaction-value').length) 
                    $('#satisfaction-value').text(satisfaction + '%');
                if ($('#satisfaction-change').length) 
                    $('#satisfaction-change').text(`Based on ${data.customer_satisfaction?.total_feedback || 0} feedbacks`);
                if ($('#satisfaction-progress').length) 
                    $('#satisfaction-progress').css('width', satisfaction + '%').attr('aria-valuenow', satisfaction);
            },
            error: function(xhr, status, error) {
                if ($('#total-visits-value').length) 
                    $('#total-visits-value').text('0');
                if($('#total-visits-change').length) 
                    $('#total-visits-change').text('Error loading data');
                if ($('#total-revenue-value').length) 
                    $('#total-revenue-value').text((window.CURRENCY_SYMBOL || '$') + '0');
                if ($('#total-revenue-change').length) 
                    $('#total-revenue-change').text('Error loading data');
                if ($('#new-customers-value').length) 
                    $('#new-customers-value').text('0 | 0');
                if ($('#new-customers-change').length) 
                    $('#new-customers-change').text('Repeat | Total');
                if ($('#satisfaction-value').length) 
                    $('#satisfaction-value').text('0%');
                if ($('#satisfaction-change').length) 
                    $('#satisfaction-change').text('Error loading data');
                console.error('Error loading dashboard stats:', error);
            }
        });
    }

    // Load Top Service Categories - Treemap
    function loadTopServiceCategories(dateRange) {
        let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        params.business_id = $("#business_id").val();
        $('#category-legend').html('');
        $('#category-legend').html('<div class="col-12 text-center py-4"><div class="spinner-border spinner-border-sm text-primary" role="status"><span class="visually-hidden">Loading...</span></div><span class="ms-2">Loading...</span></div>');
        // return false;
        $.ajax({
            url: baseURL + '/dashboard/top-service-categories',
            type: 'GET',
            data: params,
            timeout: 10000,
            success: function(responsive) {
                $('#category-legend').html('');
                $('.top_10_services_categories_date_range').text(`Date Range ${responsive.from}  →  ${responsive.to}`);
                
                var data = responsive.combined;
                if (!data || data.length === 0) {
                    if (dataVisitsChart) {
                        dataVisitsChart.updateSeries([{ data: [] }]);
                    }
                    if ($('#category-legend').length)
                    $('#category-legend').html('<div class="col-12 text-center text-muted py-4">No category data available</div>');
                    return;
                }

                // Prepare treemap data
                const treemapData = data.map(function(cat) {
                    const revenue = parseFloat(cat.total_revenue) || 0;
                    return {
                        x: cat.category_name || 'Uncategorized',
                        y: isNaN(revenue) || !isFinite(revenue) ? 0 : revenue
                    };
                });

                const colors = ["#5b69bc", "#10c469", "#fa5c7c", "#35b8e0", "#39afd1", "#ffc35a", "#eef2f7", "#313a46", "#ff8acc", "#f9c851", "#e3eaef", "#ff5b5b", "#0acf97", "#727cf5"];

                // Update chart
                if (dataVisitsChart) {
                    dataVisitsChart.updateOptions({ 
                        series: [{
                            data: treemapData
                        }],
                        colors: colors.slice(0, treemapData.length)
                    }, false, true, true);
                }

                // Update legend with matching colors from chart
                let legendHtml = '';
                data.forEach(function(cat, index) {
                    const chartColor = colors[index] || colors[index % colors.length];
                    legendHtml += '<div class="col-6">';
                    legendHtml += '<div class="d-flex justify-content-between align-items-center p-1">';
                    legendHtml += '<div>';
                    legendHtml += '<i class="ri-circle-fill fs-12 align-middle me-1" style="color: ' + chartColor + ';"></i>';
                    legendHtml += '<span class="align-middle fw-semibold">' + (cat.category_name || 'Uncategorized') + '</span>';
                    legendHtml += '</div>';
                    legendHtml += '<span class="fw-semibold text-muted float-end">' + formatCurrency(cat.total_revenue || 0) + '</span>';
                    legendHtml += '</div>';
                    legendHtml += '</div>';
                });
                if($('#category-legend').length)
                    $('#category-legend').html(legendHtml);
            },
            error: function(xhr, status, error) {
                $('#category-legend').html('');
                if (dataVisitsChart) {
                    dataVisitsChart.updateSeries([{ data: [] }]);
                }
                if($('#category-legend').length)
                    $('#category-legend').html('<div class="col-12 text-center text-danger py-4">Error loading category data</div>');
                    console.error('Error loading service categories:', error);
            }
        });
    }

    // Load Top Customers
    function loadTopCustomers(dateRange) {

        let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        params.business_id = $("#business_id").val();

        // Respect selected rows per page when fetching data
        let limit = 10;
        const rowsSelect = document.getElementById('top-customers-rows');
        if (rowsSelect) {
            const parsed = parseInt(rowsSelect.value, 10);
            if (!isNaN(parsed) && parsed > 0) {
                limit = parsed;
            }
        }
        params.limit = limit;

        const tbody = $('#top-customers-tbody');
        if (!tbody.length) return;

        tbody.html('<tr><td colspan="6" class="text-center py-4"><div class="spinner-border spinner-border-sm text-primary" role="status"><span class="visually-hidden">Loading...</span></div><span class="ms-2">Loading...</span></td></tr>');

        $.ajax({
            url: baseURL + '/dashboard/top-customers',
            type: 'GET',
            data: params,
            timeout: 15000,
            success: function (responsive) {

                $('.date-range-for-top-customer').text(`Date Range ${responsive.from}  →  ${responsive.to}`);
                const data = responsive.customers || [];

                if (!data.length) {
                    topCustomersData = [];
                    tbody.html('<tr><td colspan="6" class="text-center py-4 text-muted">No customer data available</td></tr>');
                    return;
                }

                topCustomersData = data;
                renderTopCustomersTable();
            },
            error: function (xhr, status, error) {
                topCustomersData = [];
                tbody.html('<tr><td colspan="6" class="text-center py-4 text-danger">Error loading customer data</td></tr>');
                console.error('Error loading top customers:', error);
            }
        });
    }

    function renderTopCustomersTable() {
        const tbody = $('#top-customers-tbody');
        if (!tbody.length) return;

        if (!Array.isArray(topCustomersData) || topCustomersData.length === 0) {
            tbody.html('<tr><td colspan="6" class="text-center py-4 text-muted">No customer data available</td></tr>');
            return;
        }

        let rowsToShow = 10;
        const rowsSelect = document.getElementById('top-customers-rows');
        if (rowsSelect) {
            const parsed = parseInt(rowsSelect.value, 10);
            if (!isNaN(parsed) && parsed > 0) {
                rowsToShow = parsed;
            }
        }

        const limitedData = topCustomersData.slice(0, rowsToShow);

        let html = '';
        limitedData.forEach(function (customer) {
            // Format days since last visit
            let daysAgoText = '-';
            if (customer.days_since_last_visit !== null && customer.days_since_last_visit !== undefined) {
                const days = parseInt(customer.days_since_last_visit);
                if (days === 0) {
                    daysAgoText = 'Today';
                } else if (days === 1) {
                    daysAgoText = '1 day ago';
                } else if (!isNaN(days)) {
                    daysAgoText = days + ' days ago';
                }
            }

            html += '<tr>';
            // Make customer name a clickable link
            const customerId = customer.id_customers;
            const customerName = customer.customer_name || 'Unknown';
            if (customerId) {
                const baseUrl = window.OPEN_CUSTOMER_ACCOUNT_BASE_URL || baseURL + '/open_customer_account';
                const customerUrl = baseUrl + '/' + customerId;
                html += '<td><strong><a href="' + customerUrl + '" target="_blank" class="text-primary text-decoration-underline" style="cursor: pointer;">' + customerName + '</a></strong></td>';
            } else {
                html += '<td><strong>' + customerName + '</strong></td>';
            }
            html += '<td>' + (customer.customer_cell || '-') + '</td>';
            html += '<td>' + (customer.total_visits || 0) + '</td>';
            html += '<td>' + formatCurrency(customer.total_revenue || 0) + '</td>';
            html += '<td>' + ((customer.total_balance > 0) ? '<span class="text-danger">' + formatCurrency(customer.total_balance) + '</span>' : formatCurrency(customer.total_balance || 0)) + '</td>';
            html += '<td><small class="text-muted">' + daysAgoText + '</small></td>';
            html += '</tr>';
        });

        tbody.html(html);
    }

    function exportTopCustomers(format) {
        const table = document.getElementById('top-customers-table');
        if (!table) {
            alert('Top customers table not found.');
            return;
        }

        if (format === 'print') {
            const printWindow = window.open('', '_blank', 'width=900,height=600');
            if (!printWindow) {
                alert('Please allow pop-ups to print the table.');
                return;
            }

            const styles = `
                <style>
                    body {
                        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
                        margin: 0;
                        padding: 20px;
                    }
                    table {
                        border-collapse: collapse;
                        width: 100%;
                    }
                    th, td {
                        border: 1px solid #dee2e6;
                        padding: 8px;
                        font-size: 12px;
                        text-align: left;
                    }
                    th {
                        background-color: #f8f9fa;
                        font-weight: 600;
                    }
                </style>
            `;

            printWindow.document.write('<!DOCTYPE html><html><head><title>Top Customers</title>' + styles + '</head><body>');
            printWindow.document.write(table.outerHTML);
            printWindow.document.write('<script>window.onload=function(){window.focus();window.print();};<\/script>');
            printWindow.document.write('</body></html>');
            printWindow.document.close();
        } else if (format === 'csv') {
            let csv = '';
            const rows = table.querySelectorAll('tr');

            rows.forEach(function (row) {
                const cells = row.querySelectorAll('th, td');
                const rowData = [];
                cells.forEach(function (cell) {
                    let text = cell.innerText.replace(/"/g, '""');
                    rowData.push('"' + text + '"');
                });
                csv += rowData.join(',') + '\n';
            });

            const blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
            const url = URL.createObjectURL(blob);
            const link = document.createElement('a');
            link.href = url;
            link.download = 'top-customers.csv';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            setTimeout(function () { URL.revokeObjectURL(url); }, 100);
        }
    }

    // Helper function to calculate percentile
    function calculatePercentile(sortedArray, percentile) {
        if (sortedArray.length === 0) return 0;
        const index = Math.ceil((percentile / 100) * sortedArray.length) - 1;
        return sortedArray[Math.max(0, index)];
    }

    // Load Footfall Heatmap
    // Note: Footfall Heatmap always shows past 13 months from current date - date range is ignored
    function loadFootfallHeatmap(dateRange) {
        // Date range is ignored - always uses past 13 months from current date
        let params = {
            business_id: $("#business_id").val()
            // from/to parameters are not sent - backend calculates from current date
        };
        const container = $('#footfall-heatmap-container');
        if (!container.length) return;
        container.html('<div class="text-center py-4"><div class="spinner-border spinner-border-sm text-primary" role="status"><span class="visually-hidden">Loading...</span></div><span class="ms-2">Loading...</span></div>');
        $.ajax({
            url: baseURL + '/dashboard/footfall-heatmap',
            data: params,
            type: 'GET',
            timeout: 15000,
            success: function(responsive) {
                $('#footfall-heatmap-container').html('');
                var  data= responsive.series;

                $('.footFall_date_range').text(`Date Range ${responsive.from}  →  ${responsive.to}`);
                if (!data || data.length === 0) {
                    container.html('<div class="text-center py-4 text-muted">No footfall data available</div>');
                    if (footfallHeatmapChart) {
                        footfallHeatmapChart.destroy();
                        footfallHeatmapChart = null;
                    }
                    return;
                }

                // Extract all visit counts from the data to calculate percentiles
                const allVisitCounts = [];
                data.forEach(function(month) {
                    if (month.data && Array.isArray(month.data)) {
                        month.data.forEach(function(day) {
                            if (day.y && day.y > 0) {
                                allVisitCounts.push(day.y);
                            }
                        });
                    }
                });

                // Calculate dynamic thresholds using percentiles
                let q1 = 0, q2 = 0, q3 = 0, p95 = 0;
                
                if (allVisitCounts.length > 0) {
                    // Sort visit counts in ascending order
                    const sortedCounts = allVisitCounts.slice().sort(function(a, b) {
                        return a - b;
                    });
                    
                    // Calculate quartiles and 95th percentile
                    q1 = calculatePercentile(sortedCounts, 25);  // 25th percentile (Q1)
                    q2 = calculatePercentile(sortedCounts, 50);  // 50th percentile (median/Q2)
                    q3 = calculatePercentile(sortedCounts, 75);  // 75th percentile (Q3)
                    p95 = calculatePercentile(sortedCounts, 95); // 95th percentile
                    
                    // Ensure minimum thresholds for better visual distinction
                    // If data is very sparse, use at least 1, 2, 3, 4 as thresholds
                    if (q1 === 0 && q2 === 0 && q3 === 0) {
                        // All data is 0 or very sparse - use fixed small thresholds
                        q1 = 1;
                        q2 = 2;
                        q3 = 3;
                        p95 = 4;
                    } else {
                        // Ensure q1 < q2 < q3 < p95
                        if (q1 === q2) q2 = q1 + 1;
                        if (q2 === q3) q3 = q2 + 1;
                        if (q3 >= p95) p95 = q3 + 1;
                    }
                } else {
                    // No data with visits - use default thresholds
                    q1 = 1;
                    q2 = 2;
                    q3 = 3;
                    p95 = 4;
                }

                // Generate X-axis labels (1-31 for days)
                const xAxisLabels = [];
                for (let i = 1; i <= 31; i++) {
                    xAxisLabels.push(i.toString());
                }

                // Colors for heatmap (gradient from low to high)
                const colors = ["#5b69bc"];

                const options = {
                    chart: {
                        height: 450,
                        type: 'heatmap',
                        toolbar: {
                            show: false
                        }
                    },
                    dataLabels: {
                        enabled: false
                    },
                    colors: colors,
                    series: data,
                    xaxis: {
                        type: 'category',
                        categories: xAxisLabels,
                        title: {
                            text: 'Day of Month'
                        }
                    },
                    yaxis: {
                        title: {
                            text: 'Month'
                        }
                    },
                    plotOptions: {
                        heatmap: {
                            shadeIntensity: 0.5,
                            colorScale: {
                                ranges: [{
                                    from: 0,
                                    to: 0,
                                    name: 'No Visits',
                                    color: '#e9ecef'
                                }, {
                                    from: 1,
                                    to: q1,
                                    name: 'Low',
                                    color: '#5b69bc'
                                }, {
                                    from: q1 + 1,
                                    to: q2,
                                    name: 'Medium',
                                    color: '#35b8e0'
                                }, {
                                    from: q2 + 1,
                                    to: q3,
                                    name: 'High',
                                    color: '#10c469'
                                }, {
                                    from: q3 + 1,
                                    to: 999999,
                                    name: 'Very High',
                                    color: '#fa5c7c'
                                }]
                            }
                        }
                    },
                    tooltip: {
                        y: {
                            formatter: function(value) {
                                return value + ' visits';
                            }
                        }
                    }
                };

                // Destroy existing chart if it exists
                if (footfallHeatmapChart) {
                    footfallHeatmapChart.destroy();
                }

                // Create new chart
                container.html('<div id="footfall-heatmap" class="apex-charts"></div>');
                footfallHeatmapChart = new ApexCharts(document.querySelector("#footfall-heatmap"), options);
                footfallHeatmapChart.render();
            },
            error: function(xhr, status, error) {
                $('#footfall-heatmap-container').html('');
                console.error('Error loading footfall heatmap:', error);
                if (footfallHeatmapChart) {
                    footfallHeatmapChart.destroy();
                    footfallHeatmapChart = null;
                }
            }
        });
    }

    // Load Monthly Performance
    function loadMonthlyPerformance(dateRange) {
            let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        params.business_id = $("#business_id").val();    
        $.ajax({
            url: baseURL + '/dashboard/monthly-performance',
            type: 'GET',
            data: params,
            timeout: 10000,
            success: function(responsive) {
                var  data= responsive.performanceData;
                $('.monthly_performance-date-rate').text(`Date Range ${responsive.from}  →  ${responsive.to}`);
                if (!data || data.length === 0) {
                    if($('#monthly-visits-total').length)
                        $('#monthly-visits-total').text('0');
                    if($('#monthly-services-total').length)
                        $('#monthly-services-total').text('0');
                    if($('#monthly-revenue-total').length)
                        $('#monthly-revenue-total').text((window.CURRENCY_SYMBOL || '$') + '0');
                    if($('#monthly-balances-total').length)
                        $('#monthly-balances-total').text((window.CURRENCY_SYMBOL || '$') + '0');
                    if (monthlyPerformanceChart) {
                        monthlyPerformanceChart.updateOptions({ xaxis: { categories: [] } });
                        monthlyPerformanceChart.updateSeries([]);
                    }
                    return;
                }

                // Extract dates as strings (formatted like "Mon 1st", "Tue 2nd", etc.)
                const dates = data.map(d => {
                    const dateStr = d.date ? String(d.date) : '';
                    return dateStr;
                });

                const visits = data.map(d => {
                    const val = parseInt(d.visits_count) || 0;
                    return isNaN(val) || !isFinite(val) ? 0 : val;
                });
                const services = data.map(d => {
                    const val = parseInt(d.services_count) || 0;
                    return isNaN(val) || !isFinite(val) ? 0 : val;
                });
                const revenue = data.map(d => {
                    const val = parseFloat(d.revenue) || 0;
                    return isNaN(val) || !isFinite(val) ? 0 : val;
                });
                const balances = data.map(d => {
                    const val = parseFloat(d.balances) || 0;
                    return isNaN(val) || !isFinite(val) ? 0 : val;
                });
                const advances = data.map(d => {
                    const val = parseFloat(d.advances) || 0;
                    return isNaN(val) || !isFinite(val) ? 0 : val;
                });

                // Calculate totals
                const totalVisits = visits.reduce((a, b) => a + b, 0);
                const totalServices = services.reduce((a, b) => a + b, 0);
                const totalRevenue = revenue.reduce((a, b) => a + b, 0);
                const totalBalances = balances.reduce((a, b) => a + b, 0);
                if($('#monthly-visits-total').length)
                    $('#monthly-visits-total').text(totalVisits);
                if($('#monthly-services-total').length)
                    $('#monthly-services-total').text(totalServices);
                if($('#monthly-revenue-total').length)
                    $('#monthly-revenue-total').text(formatCurrency(totalRevenue));
                if($('#monthly-balances-total').length)
                    $('#monthly-balances-total').text(formatCurrency(totalBalances));

                // Calculate min/max for each Y-axis
                // Right Y-axis (Visits/Services) - columns
                const visitsServicesMax = visits.length > 0 || services.length > 0 
                    ? Math.max(...visits, ...services, 1) 
                    : 1;
                const visitsServicesMin = 0;
                const visitsServicesPadding = (isNaN(visitsServicesMax) || !isFinite(visitsServicesMax)) ? 0 : visitsServicesMax * 0.1; // 10% padding
                
                // Left Y-axis (Revenue/Balances/Advance) - lines
                const revenueBalancesMax = revenue.length > 0 || balances.length > 0 || advances.length > 0
                    ? Math.max(...revenue, ...balances, ...advances, 1)
                    : 1;
                const revenueBalancesMin = revenue.length > 0 || balances.length > 0 || advances.length > 0
                    ? Math.min(...revenue, ...balances, ...advances, 0)
                    : 0;
                const revenueBalancesPadding = (isNaN(revenueBalancesMax) || !isFinite(revenueBalancesMax)) ? 0 : revenueBalancesMax * 0.1; // 10% padding

                // Update chart - Series order: Lines (left Y-axis) first, then Columns (right Y-axis)
                if (monthlyPerformanceChart) {
                    // First, update xaxis categories to prevent auto-generation
                    monthlyPerformanceChart.updateOptions({
                        xaxis: {
                            type: 'category',
                            categories: dates,
                            labels: {
                                rotate: -45,
                                rotateAlways: true,
                                style: {
                                    fontSize: '11px'
                                },
                                maxHeight: 80
                            }
                        }
                    }, false, false); // Don't redraw yet, no animation
                    
                    // Then update series
                    monthlyPerformanceChart.updateSeries([
                        { 
                            name: 'Revenue', 
                            type: 'line', 
                            data: revenue
                        },
                        { 
                            name: 'Balances', 
                            type: 'line', 
                            data: balances
                        },
                        { 
                            name: 'Advance', 
                            type: 'line', 
                            data: advances
                        },
                        { 
                            name: 'Visits', 
                            type: 'column', 
                            data: visits 
                        },
                        { 
                            name: 'Services', 
                            type: 'column', 
                            data: services 
                        }
                    ]);
                    
                    // Finally, update options with calculated min/max for Y-axes
                    // Ensure stroke configuration is maintained for lines
                    monthlyPerformanceChart.updateOptions({
                        stroke: {
                            width: [3, 3, 3, 0, 0], // Lines have width 3, columns have width 0
                            curve: ['smooth', 'smooth', 'smooth', 'straight', 'straight'] // Smooth spline curves for lines
                        },
                        yaxis: [
                            {
                                // Y-axis 0 (left) - Revenue (line)
                                axisTicks: {
                                    show: true,
                                },
                                axisBorder: {
                                    show: true,
                                    color: colors5[0]
                                },
                                title: { text: 'Revenue/Balances' },
                                min: Math.max(0, revenueBalancesMin - revenueBalancesPadding),
                                max: revenueBalancesMax + revenueBalancesPadding,
                                labels: {
                                    formatter: function(val) {
                                        return formatCurrency(val);
                                    },
                                    style: {
                                        colors: colors5[0]
                                    }
                                },
                                forceNiceScale: true
                            },
                            {
                                // Y-axis 1 (left) - Balances (line) - same config, hidden
                                axisTicks: {
                                    show: true,
                                },
                                axisBorder: {
                                    show: true,
                                    color: colors5[1]
                                },
                                title: { text: 'Revenue/Balances' },
                                min: Math.max(0, revenueBalancesMin - revenueBalancesPadding),
                                max: revenueBalancesMax + revenueBalancesPadding,
                                show: false, // Hide duplicate axis
                                labels: {
                                    formatter: function(val) {
                                        return formatCurrency(val);
                                    },
                                    style: {
                                        colors: colors5[1]
                                    },
                                    offsetX: 10
                                },
                                forceNiceScale: true
                            },
                            {
                                // Y-axis 2 (left) - Advance (line) - same config, hidden
                                axisTicks: {
                                    show: true,
                                },
                                axisBorder: {
                                    show: true,
                                    color: colors5[2]
                                },
                                title: { text: 'Revenue/Balances' },
                                min: Math.max(0, revenueBalancesMin - revenueBalancesPadding),
                                max: revenueBalancesMax + revenueBalancesPadding,
                                show: false, // Hide duplicate axis
                                labels: {
                                    formatter: function(val) {
                                        return formatCurrency(val);
                                    },
                                    style: {
                                        colors: colors5[2]
                                    },
                                    offsetX: 10
                                },
                                forceNiceScale: true
                            },
                            {
                                // Y-axis 3 (right) - Visits (column)
                                opposite: true,
                                axisTicks: {
                                    show: true,
                                },
                                axisBorder: {
                                    show: true,
                                    color: colors5[3]
                                },
                                title: { text: 'Visits/Services' },
                                min: visitsServicesMin,
                                max: visitsServicesMax + visitsServicesPadding,
                                labels: {
                                    formatter: function(val) {
                                        return Math.round(val);
                                    },
                                    style: {
                                        colors: colors5[3]
                                    }
                                },
                                forceNiceScale: true
                            },
                            {
                                // Y-axis 4 (right) - Services (column) - same config, hidden
                                opposite: true,
                                axisTicks: {
                                    show: true,
                                },
                                axisBorder: {
                                    show: true,
                                    color: colors5[4]
                                },
                                title: { text: 'Visits/Services' },
                                min: visitsServicesMin,
                                max: visitsServicesMax + visitsServicesPadding,
                                show: false, // Hide duplicate axis
                                labels: {
                                    formatter: function(val) {
                                        return Math.round(val);
                                    },
                                    style: {
                                        colors: colors5[4]
                                    },
                                    offsetX: 10
                                },
                                forceNiceScale: true
                            }
                        ]
                    }, true, true); // redraw: true, animate: true - ensure chart redraws with lines
                }
            },
            error: function(xhr, status, error) {
                if($('#monthly-visits-total').length)
                    $('#monthly-visits-total').text('0');
                if($('#monthly-services-total').length)
                    $('#monthly-services-total').text('0');
                if($('#monthly-revenue-total').length)
                    $('#monthly-revenue-total').text((window.CURRENCY_SYMBOL || '$') + '0');
                if($('#monthly-balances-total').length)
                    $('#monthly-balances-total').text((window.CURRENCY_SYMBOL || '$') + '0');
                console.error('Error loading monthly performance:', error);
            }
        });
    }

    // Initialize Charts
    function initializeCharts(dateRange) {
        // Total Visits Chart (Radial)
        var colors = ["#ff5b5b", "#F6F7FB"];

        var dataColors = $("#total-orders-chart").data('colors');
        if (dataColors) {
            colors = dataColors.split(",");
        }

        var options1 = {
            series: [0],
        chart: {
            type: 'radialBar',
            height: 81,
            width: 81,
                sparkline: { enabled: false }
        },
        plotOptions: {
            radialBar: {
                offsetY: 0,
                    hollow: { margin: 0, size: '50%' },
                dataLabels: {
                        name: { show: false },
                    value: {
                        offsetY: 5,
                        fontSize: '14px',
                        fontWeight: "600",
                        formatter: function (val) {
                                return val + '%'
                        }
                    }
                }
            }
        },
        grid: {
                padding: { top: -18, bottom: -20, left: -20, right: -20 }
        },
        colors: colors,
        };
        if($('#total-orders-chart').length){
            // Destroy existing chart instance before creating a new one to prevent conflicts
            // This fixes the issue where radial charts remain at 0% after branch change/refresh
            if (totalVisitsChart) {
                try {
                    totalVisitsChart.destroy();
                } catch (e) {
                    console.warn('Error destroying existing totalVisitsChart:', e);
                }
            }
            // Clear DOM after destroying chart instance
            $("#total-orders-chart").empty();
            totalVisitsChart = new ApexCharts(document.querySelector("#total-orders-chart"), options1);
            totalVisitsChart.render();
        }

        // New Customers Chart (Radial)
        var colors2 = ["#f9c851", "#F6F7FB"];
        var dataColors2 = $("#new-users-chart").data('colors');
        if (dataColors2) {
            colors2 = dataColors2.split(",");
    }
    var options2 = {
            series: [0],
        chart: {
            type: 'radialBar',
            height: 81,
            width: 81,
                sparkline: { enabled: false }
        },
        plotOptions: {
            radialBar: {
                offsetY: 0,
                    hollow: { margin: 0, size: '50%' },
                dataLabels: {
                        name: { show: false },
                    value: {
                        offsetY: 5,
                        fontSize: '14px',
                        fontWeight: "600",
                        formatter: function (val) {
                                return val + '%'
                        }
                    }
                }
            }
        },
        grid: {
                padding: { top: -18, bottom: -20, left: -20, right: -20 }
            },
            colors: colors2,
        };
        if($('#new-users-chart').length){
            // Destroy existing chart instance before creating a new one to prevent conflicts
            // This fixes the issue where radial charts remain at 0% after branch change/refresh
            if (newCustomersChart) {
                try {
                    newCustomersChart.destroy();
                } catch (e) {
                    console.warn('Error destroying existing newCustomersChart:', e);
                }
            }
            // Clear DOM after destroying chart instance
            $("#new-users-chart").empty();
            newCustomersChart = new ApexCharts(document.querySelector("#new-users-chart"), options2);
            newCustomersChart.render();
        }

        // Service Categories Chart (Treemap) - Distributed treemap
        var colors3 = ["#5b69bc", "#10c469", "#fa5c7c", "#35b8e0", "#39afd1", "#ffc35a", "#eef2f7", "#313a46", "#ff8acc", "#f9c851", "#e3eaef", "#ff5b5b", "#0acf97", "#727cf5"];
        var dataColors3 = $("#data-visits-chart").data('colors');
        if (dataColors3) {
            colors3 = dataColors3.split(",");
        }
        var options3 = {
            chart: { 
                height: 277, 
                type: 'treemap',
                toolbar: {
                    show: false
                }
            },
            series: [{
                data: []
            }],
            legend: {
                show: false
            },
            colors: colors3,
            plotOptions: {
                treemap: {
                    distributed: true,
                    enableShades: false
                }
            },
            dataLabels: {
                enabled: true,
                style: {
                    fontSize: '12px',
                    fontWeight: 600
                },
                formatter: function(text, op) {
                    return text; // Only show category name
                },
                offsetY: -4
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return formatCurrency(value);
                    }
                }
            }
        };
        if($('#data-visits-chart').length){
            // Destroy existing chart instance before creating a new one to prevent conflicts
            // This fixes the issue where the chart disappears after branch change/refresh
            if (dataVisitsChart) {
                try {
                    dataVisitsChart.destroy();
                } catch (e) {
                    console.warn('Error destroying existing dataVisitsChart:', e);
                }
            }
            dataVisitsChart = new ApexCharts(document.querySelector("#data-visits-chart"), options3);
            dataVisitsChart.render();
        }

        // Statistics Chart (Monthly Sales - Multi-line with markers)
        var colors4 = ["#ff9800", "#e91e63", "#00bcd4", "#4caf50", "#2196f3", "#f44336", "#9c27b0"];
        var dataColors4 = $("#statistics-chart").data('colors');
        if (dataColors4) {
            colors4 = dataColors4.split(",");
        }
        var options4 = {
            series: [],
            chart: {
                height: 301, 
                type: "line", 
                toolbar: { show: false },
                zoom: { enabled: false }
            },
            stroke: {
                width: 2, 
                curve: 'smooth'
            },
            markers: {
                size: 5,
                hover: {
                    size: 7
                },
                strokeWidth: 2,
                strokeColors: ['#fff']
            },
            xaxis: { 
                categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                title: { text: 'Months' },
                labels: {
                    style: {
                        fontSize: '12px'
                    }
                }
            },
            yaxis: {
                title: { text: 'Sales' },
                labels: {
                    formatter: function(val) {
                        if (val >= 1000000) {
                            return (val / 1000000).toFixed(0) + 'M';
                        } else if (val >= 1000) {
                            return (val / 1000).toFixed(0) + 'K';
                        }
                        return val.toFixed(0);
                    }
                }
            },
            colors: colors4,
            legend: {
                show: true,
                position: 'bottom',
                horizontalAlign: 'center',
                fontSize: '12px',
                markers: {
                    width: 12,
                    height: 12,
                    radius: 6
                }
            },
            tooltip: {
                shared: true,
                intersect: false,
                y: {
                    formatter: function(y) {
                        return typeof y !== "undefined" ? formatCurrency(y) : y;
                    }
                }
            },
            dataLabels: {
                enabled: false
            }
        };
        if($('#statistics-chart').length){
            // Destroy existing chart instance before creating a new one to prevent conflicts
            if (statisticsChart) {
                try {
                    statisticsChart.destroy();
                } catch (e) {
                    console.warn('Error destroying existing statisticsChart:', e);
                }
            }
            statisticsChart = new ApexCharts(document.querySelector("#statistics-chart"), options4);
            statisticsChart.render();
        }

        // Monthly Performance Chart (Dual Y-axis) - Hybrid chart
        // Lines (Revenue, Balances, Advance) on left Y-axis
        // Columns (Visits, Services) on right Y-axis
        // colors5 is already defined at module level
        var dataColors5 = $("#monthly-performance-chart").data('colors');
        if (dataColors5) {
            colors5 = dataColors5.split(",");
        } else {
            // Reset to default if no data attribute
            colors5 = ["#921d5f", "#ffc7ff", "#f9c851", "#923024", "#ffbeab"];
        }
        var options5 = {
            chart: {
                height: 299,
                type: 'line',
                stacked: false,
                zoom: { enabled: false },
                toolbar: { show: false }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                width: [3, 3, 3, 0, 0], // Lines have width 3, columns have width 0
                curve: ['smooth', 'smooth', 'smooth', 'straight', 'straight'] // Smooth spline curves for lines
            },
            series: [
                { name: 'Revenue', type: 'line', data: [] },
                { name: 'Balances', type: 'line', data: [] },
                { name: 'Advance', type: 'line', data: [] },
                { name: 'Visits', type: 'column', data: [] },
                { name: 'Services', type: 'column', data: [] }
            ],
            colors: colors5,
            markers: {
                size: [5, 5, 5, 0, 0], // Show markers for lines, none for columns
                strokeWidth: [2, 2, 2, 0, 0],
                strokeColors: ['#fff', '#fff', '#fff', 'transparent', 'transparent'],
                fillColors: colors5.slice(0, 3), // Use series colors for markers
                hover: {
                    size: [7, 7, 7, 0, 0]
                },
                showNullValues: false
            },
            fill: {
                opacity: [0, 0, 0, 1, 1], // Lines not filled, columns filled
                type: ['solid', 'solid', 'solid', 'solid', 'solid']
            },
            plotOptions: {
                bar: {
                        columnWidth: "30%",
                    borderRadius: 5,
                },
            },
            xaxis: {
                type: 'category',
                categories: [],
                labels: {
                    rotate: -45,
                    rotateAlways: true,
                    style: {
                        fontSize: '11px'
                    },
                    maxHeight: 80
                }
            },
            yaxis: [
                {
                    // Y-axis 0 (left) - Revenue (line)
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors5[0]
                    },
                    labels: {
                        formatter: function(val) {
                            return formatCurrency(val);
                        },
                        style: {
                            colors: colors5[0]
                        }
                    },
                    title: {
                        text: 'Revenue/Balances'
                    },
                    forceNiceScale: true
                },
                {
                    // Y-axis 1 (left) - Balances (line) - same as axis 0, but hidden
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors5[1]
                    },
                    labels: {
                        formatter: function(val) {
                            return formatCurrency(val);
                        },
                        style: {
                            colors: colors5[1]
                        },
                        offsetX: 10
                    },
                    title: {
                        text: 'Revenue/Balances'
                    },
                    show: false, // Hide duplicate axis
                    forceNiceScale: true
                },
                {
                    // Y-axis 2 (left) - Advance (line) - same as axis 0, but hidden
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors5[2]
                    },
                    labels: {
                        formatter: function(val) {
                            return formatCurrency(val);
                        },
                        style: {
                            colors: colors5[2]
                        },
                        offsetX: 10
                    },
                    title: {
                        text: 'Revenue/Balances'
                    },
                    show: false, // Hide duplicate axis
                    forceNiceScale: true
                },
                {
                    // Y-axis 3 (right) - Visits (column)
                    opposite: true,
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors5[3]
                    },
                    labels: {
                        formatter: function(val) {
                            return Math.round(val);
                        },
                        style: {
                            colors: colors5[3]
                        }
                    },
                    title: {
                        text: 'Visits/Services'
                    },
                    forceNiceScale: true
                },
                {
                    // Y-axis 4 (right) - Services (column) - same as axis 3, but hidden
                    opposite: true,
                    axisTicks: {
                        show: true,
                    },
                    axisBorder: {
                        show: true,
                        color: colors5[4]
                    },
                    labels: {
                        formatter: function(val) {
                            return Math.round(val);
                        },
                        style: {
                            colors: colors5[4]
                        },
                        offsetX: 10
                    },
                    title: {
                        text: 'Visits/Services'
                    },
                    show: false, // Hide duplicate axis
                    forceNiceScale: true
                }
            ],
            tooltip: {
                followCursor: true,
                shared: true,
                intersect: false,
                y: [
                    // Lines (Revenue, Balances, Advance) - currency format
                    { formatter: function(y) { return typeof y !== "undefined" ? formatCurrency(y) : y; } },
                    { formatter: function(y) { return typeof y !== "undefined" ? formatCurrency(y) : y; } },
                    { formatter: function(y) { return typeof y !== "undefined" ? formatCurrency(y) : y; } },
                    // Columns (Visits, Services) - number format
                    { formatter: function(y) { return typeof y !== "undefined" ? Math.round(y) : y; } },
                    { formatter: function(y) { return typeof y !== "undefined" ? Math.round(y) : y; } }
                ]
            },
            grid: {
                borderColor: '#f1f3fa',
                padding: {
                    bottom: 5
                }
            },
            legend: {
                show: true,
                position: 'top',
                horizontalAlign: 'left',
                fontSize: '12px',
                offsetY: 7
            },
            responsive: [{
                breakpoint: 600,
                options: {
                    yaxis: {
                        show: false
                    },
                    legend: {
                        show: false
                    }
                }
            }]
        };
        if($('#monthly-performance-chart').length){
            monthlyPerformanceChart = new ApexCharts(document.querySelector("#monthly-performance-chart"), options5);
            monthlyPerformanceChart.render();
        }
    }

    // Load Top Staff
    function loadTopStaff(dateRange) {

        let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }    
        params.business_id = $("#business_id").val();
        const track = $('#staff-slider-track');
        if(!track.length)
            return;

        track.html('<div class="col-12 text-center py-4"><div class="spinner-border spinner-border-sm text-primary" role="status"><span class="visually-hidden">Loading...</span></div><span class="ms-2">Loading...</span></div>');

        $.ajax({
            url: baseURL + '/dashboard/top-staff',
            type: 'GET',
            data: params,
            timeout: 10000,
            success: function(responsive) {
                var  data= responsive.staff;
                $('.date-range-current-month-staff').text(`Date Range ${responsive.from}  →  ${responsive.to}`);
                if (!data || data.length === 0) {
                    if($('#staff-slider-track').length)
                        $('#staff-slider-track').html('<div class="col-12 text-center py-4 text-muted">No staff data available</div>');
                    if($('#staff-slider-info').length)
                        $('#staff-slider-info').hide();
                    if($('#staff-slider-prev').length)
                        $('#staff-slider-prev').hide().prop('disabled', true);
                    if($('#staff-slider-next').length)
                        $('#staff-slider-next').hide().prop('disabled', true);
                    return;
                }

                staffData = data;
                currentStaffPage = 0;
                renderStaffSlide();
            },
            error: function(xhr, status, error) {
                if($('#staff-slider-track').length)
                    $('#staff-slider-track').html('<div class="col-12 text-center py-4 text-danger">Error loading staff data</div>');
                if($('#staff-slider-info').length)
                    $('#staff-slider-info').hide();
                if($('#staff-slider-prev').length)
                    $('#staff-slider-prev').hide().prop('disabled', true);
                if($('#staff-slider-next').length)
                    $('#staff-slider-next').hide().prop('disabled', true);
                console.error('Error loading top staff:', error);
            }
        });
    }

    // Render staff slide with sliding animation
    function renderStaffSlide() {

        const track = $('#staff-slider-track');
        if (!track.length) return;
        
        // Hide the info text
        if($('#staff-slider-info').length)
        $('#staff-slider-info').hide();

        // Calculate max page
        const maxPage = Math.ceil(staffData.length / staffPerPage) - 1;
        
        // Show/hide and enable/disable navigation arrows
        const canGoPrev = currentStaffPage > 0;
        const canGoNext = currentStaffPage < maxPage;
        
        const prevBtn = $('#staff-slider-prev');
        const nextBtn = $('#staff-slider-next');
        
        if(prevBtn.length){
            if (canGoPrev) {
                prevBtn.show().prop('disabled', false);
            } else {
                prevBtn.hide().prop('disabled', true);
            }
        }
        
        if(nextBtn.length){
            if (canGoNext) {
                nextBtn.show().prop('disabled', false);
            } else {
                nextBtn.hide().prop('disabled', true);
            }
        }

        // Render all staff cards grouped into pages for smooth sliding
        let html = '';
        const totalPages = Math.ceil(staffData.length / staffPerPage);
        
        for (let page = 0; page < totalPages; page++) {
            const startIdx = page * staffPerPage;
            const endIdx = Math.min(startIdx + staffPerPage, staffData.length);
            const pageStaff = staffData.slice(startIdx, endIdx);
            
            html += '<div class="staff-slide" style="flex: 0 0 100%; width: 100%;">';
            html += '<div class="row row-cols-xxl-4 row-cols-lg-4 row-cols-md-2 row-cols-1 g-3">';
            
            pageStaff.forEach(function(staff, index) {
                let staffImageUrl = baseURL + '/images/users/avatar-1.jpg'; // Default
                if (staff.staff_image && staff.staff_image !== '') {
                    // Handle different image path formats
                    if (staff.staff_image.startsWith('http')) {
                        staffImageUrl = staff.staff_image;
                    } else if (staff.staff_image.startsWith('/')) {
                        // If it starts with /, prepend base URL
                        staffImageUrl = baseURL + staff.staff_image;
                    } else {
                        // Staff images are stored in public/images/staff/, not storage
                        staffImageUrl = baseURL + '/images/staff/' + staff.staff_image;
                    }
                }
                
                html += '<div class="col">';
                html += '<div class="card shadow-sm staff-card" style="height: 110px;">';
                html += '<div class="card-body d-flex align-items-center gap-2" style="height: 100%; padding: 0.75rem;">';
                html += '<img src="' + staffImageUrl + '" alt="staff-image" class="me-1 avatar-xl img-thumbnail rounded-circle flex-shrink-0 staff-avatar-img" style="width: 75px; height: 75px; object-fit: cover;" data-fallback-attempted="false">';
                html += '<div style="flex: 1; min-width: 0; overflow: hidden;">';
                html += '<h5 class="mb-1" style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis; font-size: 0.95rem; font-weight: 600;">' + (staff.staff_fullname || 'Unknown Staff') + '</h5>';
                html += '<p class="text-muted mb-1" style="font-size: 0.8rem; margin-bottom: 0.15rem;">' + formatCurrency(staff.total_earnings || 0) + '</p>';
                html += '<p class="m-0 fs-14" style="font-size: 0.8rem; margin: 0;">' + (staff.services_count || 0) + ' Services</p>';
                html += '</div>';
                html += '</div>';
                html += '</div>';
                html += '</div>';
            });
            
            html += '</div>';
            html += '</div>';
        }

        track.html(html);
        
        // Calculate and apply slide offset (translate by percentage)
        const offset = -currentStaffPage * 100;
        track.css('transform', 'translateX(' + offset + '%)');
    }

    // Staff slider navigation - Make globally accessible for inline onclick handlers
    window.prevStaffSlide = function() {
        if (currentStaffPage > 0) {
            currentStaffPage--;
            renderStaffSlide();
        }
    };

    window.nextStaffSlide = function() {
        const maxPage = Math.ceil(staffData.length / staffPerPage) - 1;
        if (currentStaffPage < maxPage) {
            currentStaffPage++;
            renderStaffSlide();
        }
    };

    // Recalculate slide position on window resize
    let resizeTimer;
    $(window).on('resize', function() {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function() {
            if (staffData && staffData.length > 0) {
                renderStaffSlide();
            }
        }, 250);
    });

    // Load Monthly Service Payment Summary (Collection Breakup)
    function loadMonthlyServicePaymentSummary(dateRange) {
        let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        params.business_id = $("#business_id").val();
        $("#service-collection-breakup-chart").empty();
        spin_loader('#service-collection-breakup-chart');
        
        $.ajax({
            url: baseURL + '/dashboard/getMonthlyServicePaymentSummary',
            type: 'GET',
            data: params,
            dataType: 'json',
            success: function (response) {
                remover_spin_loader('#service-collection-breakup-chart');
                $("#service-collection-breakup-chart").empty();
                if(response.success) {
                    let data = response.data;

                    // Display selected date range
                    $('#service-collection-breakup-date-range').text(response.from + ' → ' + response.to);

                    // Categories (payment types)
                    let categories = ['Cash', 'Bank', 'Card', 'Online'];

                    // Data array
                    let seriesData = [
                        data.cash_debit,
                        data.bank_debit,
                        data.card_debit,
                        data.online_debit
                    ];

                    // Multiple colors for each bar
                    let colors = ["#39afd1", "#10c469", "#fa5c7c", "#ffc107"]; // Cash, Bank, Card, Online

                    // ApexCharts options
                    let options = {
                        chart: {
                            height: 380,
                            type: 'bar',
                            toolbar: { show: false }
                        },
                        plotOptions: {
                            bar: {
                                horizontal: true,
                                distributed: true,
                            }
                        },
                        dataLabels: { enabled: false },
                        series: [{
                            data: seriesData
                        }],
                        colors: colors,
                        xaxis: {
                            categories: categories,
                            axisBorder: { show: false }
                        },
                        states: {
                            hover: { filter: 'none' }
                        },
                        grid: { borderColor: '#f1f3fa' }
                    };

                    // Render chart
                    let chartEl = document.querySelector("#service-collection-breakup-chart");
                    chartEl.innerHTML = ""; // clear previous chart
                    
                    // Destroy existing chart if it exists
                    if (serviceCollectionBreakupChart) {
                        try {
                            serviceCollectionBreakupChart.destroy();
                        } catch (e) {
                            console.warn('Error destroying existing serviceCollectionBreakupChart:', e);
                        }
                    }
                    
                    serviceCollectionBreakupChart = new ApexCharts(chartEl, options);
                    serviceCollectionBreakupChart.render();
                } else {
                    console.error("No data available or API returned false.");
                }
            },
            error: function (err) {
                remover_spin_loader('#service-collection-breakup-chart');
                console.error('Error fetching monthly service payment summary', err);
            }
        });
    }

    // Load Monthly Sales (Yearly Service Comparison)
    // Note: Yearly Service Comparison ignores selected date range - shows all available years
    function loadMonthlySales(dateRange) {
        // Date range is ignored - shows all available data from summary table
        let params = {
            business_id: $("#business_id").val()
            // from/to parameters are not sent - backend uses all available data
        };
        $.ajax({
            url: baseURL + '/dashboard/monthly-sales',
            type: 'GET',
            data: params,
            timeout: 10000,
            success: function(data) {
                if (!data || data.length === 0) {
                    if (statisticsChart) {
                        statisticsChart.updateSeries([]);
                        statisticsChart.updateOptions({ xaxis: { categories: [] } });
                    }
                    if($('#yearly-sales-total').length)
                    $('#yearly-sales-total').text((window.CURRENCY_SYMBOL || '$') + '0');
                    console.log('Yearly Sale Comparison: No data returned from server');
                    return;
                }
                
                console.log('Yearly Service Comparison: Received data', data.length, 'items');

                // Group data by year
                const yearsData = {};
                const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                
                data.forEach(function(item) {
                    if (!yearsData[item.year]) {
                        yearsData[item.year] = {};
                    }
                    yearsData[item.year][item.month] = item.total_sale;
                });

                // Get all years sorted
                const years = Object.keys(yearsData).sort((a, b) => parseInt(a) - parseInt(b));
                
                console.log('Yearly Service Comparison: Years found', years);
                console.log('Yearly Service Comparison: Years data', yearsData);
                
                // Define colors and marker shapes for different years
                const yearColors = [
                    "#ff9800", // Orange
                    "#e91e63", // Pink
                    "#00bcd4", // Light Blue
                    "#4caf50", // Green
                    "#2196f3", // Blue
                    "#f44336", // Red
                    "#9c27b0", // Purple
                    "#ffc107", // Amber
                    "#009688", // Teal
                    "#795548"  // Brown
                ];
                
                const markerShapes = ['circle', 'square', 'triangle', 'diamond', 'cross', 'x', 'rect', 'rectRounded', 'rectRot', 'star'];
                
                // Build series for each year with unique colors and markers
                const series = years.map(function(year, index) {
                    const yearData = months.map(function(month) {
                        return yearsData[year][month] || 0;
                    });
                    return {
                        name: year.toString(),
                        type: 'line',
                        data: yearData,
                        color: yearColors[index % yearColors.length],
                        marker: {
                            shape: markerShapes[index % markerShapes.length],
                            size: 5,
                            hover: {
                                size: 7
                            },
                            strokeWidth: 2,
                            strokeColors: ['#fff']
                        }
                    };
                });

                // Calculate total sales across all years
                const yearlyTotal = data.reduce(function(sum, item) {
                    return sum + (item.total_sale || 0);
                }, 0);

                if($('#yearly-sales-total').length)
                $('#yearly-sales-total').text(formatCurrency(yearlyTotal));

                // Update chart with proper configuration
                if (statisticsChart) {
                    console.log('Yearly Service Comparison: Updating chart with', series.length, 'series');
                    // Extract colors from series for chart colors array
                    const chartColors = series.map(s => s.color || '#5b69bc');
                    
                    statisticsChart.updateOptions({
                        xaxis: { 
                            categories: months,
                            title: { text: 'Months' }
                        },
                        chart: { type: 'line' },
                        colors: chartColors,
                        stroke: {
                            width: 2,
                            curve: 'smooth'
                        }
                    }, false, true); // false = not animate, true = update chart
                    statisticsChart.updateSeries(series, true); // true = animate
                } else {
                    console.warn('Yearly Service Comparison: statisticsChart is not initialized');
                }
            },
            error: function(xhr, status, error) {
                if (statisticsChart) {
                    statisticsChart.updateSeries([]);
                    statisticsChart.updateOptions({ xaxis: { categories: [] } });
                }
                if($('#yearly-sales-total').length)
                $('#yearly-sales-total').text((window.CURRENCY_SYMBOL || '$') + '0');
                console.error('Error loading yearly service comparison:', {
                    status: status,
                    error: error,
                    response: xhr.responseText,
                    statusCode: xhr.status
                });
            }
        });
    }

    // Export Chart Function - Similar to Highcharts exporting module
    // Make it globally accessible for onclick handlers
    window.exportChart = function(chartId, format) {
        let chartInstance = null;
        
        // Map chart IDs to chart instances
        if (chartId === 'data-visits-chart') {
            chartInstance = dataVisitsChart;
        } else if (chartId === 'statistics-chart') {
            chartInstance = statisticsChart;
        } else if (chartId === 'monthly-performance-chart') {
            chartInstance = monthlyPerformanceChart;
        } else if (chartId === 'footfall-heatmap') {
            chartInstance = footfallHeatmapChart;
        } else if (chartId === 'service-collection-breakup-chart') {
            chartInstance = serviceCollectionBreakupChart;
        }
        
        if (!chartInstance) {
            console.error('Chart instance not found for:', chartId);
            alert('Chart not ready. Please wait for it to load.');
            return;
        }
        
        // Generate filename similar to Highcharts
        const chartTitle = getChartTitle(chartId);
        const timestamp = new Date().toISOString().slice(0, 10).replace(/-/g, '');
        const filename = (chartTitle || 'chart').toLowerCase().replace(/\s+/g, '-') + '-' + timestamp;
        
        try {
            if (format === 'print') {
                // Print chart - similar to Highcharts printChart
                printChart(chartInstance, chartId);
            } else if (format === 'png') {
                // Download PNG - similar to Highcharts downloadPNG
                downloadChartImage(chartInstance, filename, 'png');
            } else if (format === 'jpeg') {
                // Download JPEG - similar to Highcharts downloadJPEG
                downloadChartImage(chartInstance, filename, 'jpeg');
            } else if (format === 'pdf') {
                // Download PDF - similar to Highcharts downloadPDF
                downloadChartPDF(chartInstance, filename);
            } else if (format === 'svg') {
                // Download SVG - similar to Highcharts downloadSVG
                downloadChartSVG(chartInstance, chartId, filename);
            }
        } catch (error) {
            console.error('Error exporting chart:', error);
            alert('Error exporting chart. Please try again.');
        }
    }

    // Helper function to get chart title
    function getChartTitle(chartId) {
        const titleMap = {
            'data-visits-chart': 'Top Service Categories',
            'statistics-chart': 'Monthly Sales',
            'monthly-performance-chart': 'Monthly Performance',
            'footfall-heatmap': 'Footfall Heatmap',
            'service-collection-breakup-chart': 'Monthly Service Collection Breakup'
        };
        return titleMap[chartId] || 'Chart';
    }

    // Print chart function - similar to Highcharts printChart
    function printChart(chartInstance, chartId) {
        const chartElement = document.querySelector('#' + chartId);
        if (!chartElement) {
            alert('Chart element not found.');
            return;
        }
        
        // Get chart SVG/HTML
        const chartHtml = chartElement.innerHTML;
        
        // Get basic styles
        const styles = `
            <style>
                * { box-sizing: border-box; }
                body { 
                    margin: 0; 
                    padding: 20px; 
                    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
                }
                svg { 
                    max-width: 100%; 
                    height: auto; 
                }
                @media print {
                    body { padding: 0; }
                    @page { margin: 1cm; }
                }
            </style>
        `;
        
        const printWindow = window.open('', '_blank', 'width=800,height=600');
        if (!printWindow) {
            alert('Please allow pop-ups to print the chart.');
            return;
        }
        
        const scriptTag = '<' + 'script>';
        const scriptClose = '<' + '/' + 'script>';
        printWindow.document.write(`
            <!DOCTYPE html>
            <html>
                <head>
                    <title>Print Chart</title>
                    ${styles}
                </head>
                <body>
                    ${chartHtml}
                    ${scriptTag}
                        window.onload = function() { 
                            window.focus();
                            window.print(); 
                        }
                    ${scriptClose}
                </body>
            </html>
        `);
        printWindow.document.close();
    }

    // Download chart as image (PNG/JPEG) - similar to Highcharts downloadPNG/downloadJPEG
    function downloadChartImage(chartInstance, filename, format) {
        const mimeType = format === 'jpeg' ? 'image/jpeg' : 'image/png';
        
        chartInstance.dataURI({
            scale: 2, // Higher quality
            width: chartInstance.w.globals.svgWidth,
            height: chartInstance.w.globals.svgHeight
        }).then(({ imgURI }) => {
            // Convert data URI to blob for better browser compatibility
            const byteString = atob(imgURI.split(',')[1]);
            const mimeString = imgURI.split(',')[0].split(':')[1].split(';')[0];
            const ab = new ArrayBuffer(byteString.length);
            const ia = new Uint8Array(ab);
            for (let i = 0; i < byteString.length; i++) {
                ia[i] = byteString.charCodeAt(i);
            }
            const blob = new Blob([ab], { type: mimeType });
            
            // Create download link
            const url = URL.createObjectURL(blob);
            const link = document.createElement('a');
            link.href = url;
            link.download = filename + '.' + format;
            link.style.display = 'none';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            
            // Clean up
            setTimeout(() => URL.revokeObjectURL(url), 100);
        }).catch((error) => {
            console.error('Error exporting chart image:', error);
            alert('Error exporting chart. Please try again.');
        });
    }

    // Download chart as PDF - similar to Highcharts downloadPDF
    function downloadChartPDF(chartInstance, filename) {
        chartInstance.dataURI({
            scale: 2,
            width: chartInstance.w.globals.svgWidth,
            height: chartInstance.w.globals.svgHeight
        }).then(({ imgURI }) => {
            // Check if jsPDF is available
            if (typeof window.jspdf !== 'undefined' && window.jspdf.jsPDF) {
                try {
                    const pdf = new window.jspdf.jsPDF({
                        orientation: chartInstance.w.globals.svgWidth > chartInstance.w.globals.svgHeight ? 'landscape' : 'portrait',
                        unit: 'px',
                        format: [chartInstance.w.globals.svgWidth, chartInstance.w.globals.svgHeight]
                    });
                    
                    const img = new Image();
                    img.onload = function() {
                        const pdfWidth = pdf.internal.pageSize.getWidth();
                        const pdfHeight = (img.height * pdfWidth) / img.width;
                        
                        // Center the image
                        const xOffset = 0;
                        const yOffset = 0;
                        
                        pdf.addImage(imgURI, 'PNG', xOffset, yOffset, pdfWidth, pdfHeight);
                        pdf.save(filename + '.pdf');
                    };
                    img.onerror = function() {
                        alert('Error loading image for PDF export.');
                    };
                    img.src = imgURI;
                } catch (error) {
                    console.error('Error creating PDF:', error);
                    // Fallback: download as PNG
                    downloadChartImage(chartInstance, filename, 'png');
                    alert('Error creating PDF. Downloading as PNG instead.');
                }
            } else {
                // Fallback: download as PNG
                downloadChartImage(chartInstance, filename, 'png');
                alert('PDF export requires jsPDF library. Downloading as PNG instead.');
            }
        }).catch((error) => {
            console.error('Error exporting chart PDF:', error);
            alert('Error exporting chart. Please try again.');
        });
    }

    // Download chart as SVG - similar to Highcharts downloadSVG
    function downloadChartSVG(chartInstance, chartId, filename) {
        const svgElement = document.querySelector('#' + chartId + ' svg');
        if (!svgElement) {
            alert('SVG element not found.');
            return;
        }
        
        try {
            // Clone SVG to avoid modifying the original
            const svgClone = svgElement.cloneNode(true);
            
            // Get SVG as string
            const svgData = new XMLSerializer().serializeToString(svgClone);
            
            // Add XML declaration and proper namespace
            const svgWithDeclaration = '<' + '?xml version="1.0" encoding="UTF-8"?>\n' + svgData;
            
            // Create blob and download
            const svgBlob = new Blob([svgWithDeclaration], { 
                type: 'image/svg+xml;charset=utf-8' 
            });
            const svgUrl = URL.createObjectURL(svgBlob);
            const link = document.createElement('a');
            link.href = svgUrl;
            link.download = filename + '.svg';
            link.style.display = 'none';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            
            // Clean up
            setTimeout(() => URL.revokeObjectURL(svgUrl), 100);
        } catch (error) {
            console.error('Error exporting SVG:', error);
            alert('Error exporting SVG. Please try again.');
        }
    }

    // Handle staff image errors with retry limit to prevent infinite loops
    function handleStaffImageError(img) {
        if (img.dataset.fallbackAttempted === 'true') {
            // Already tried fallback, stop retrying and hide image or show placeholder
            img.style.display = 'none';
            return;
        }
        
        // Mark that we've attempted fallback
        img.dataset.fallbackAttempted = 'true';
        
        // Try fallback image once
        const fallbackUrl = baseURL + '/images/users/avatar-1.jpg';
        if (img.src !== fallbackUrl) {
            img.src = fallbackUrl;
        } else {
            // If already on fallback and it fails, hide the image
            img.style.display = 'none';
        }
    }

    // Initialize on page load
    $(document).ready(function() {
        flatpickr("#dateRange", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: ["{{ $start_date }}", "{{ $end_date }}"]
        });

        loadDashboardData();
        $('#refresh-dashboard').on('click', function() {
            loadDashboardData();
        });
        
        // Initialize Select2 on branch dropdown
        $('#business_id').select2({
            width: '100%',
            placeholder: 'Select Branch'
        });

        // Rows-per-page selector for Top Customers: refetch with new limit
        const topCustomersRows = document.getElementById('top-customers-rows');
        if (topCustomersRows) {
            topCustomersRows.addEventListener('change', function () {
                const currentRange = getDateRangeForMonths();
                loadTopCustomers(currentRange);
            });
        }
        
        // Initialize Bootstrap tooltips for info icons
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Set up image error handlers for staff avatars (delegated event handler)
        $(document).on('error', '.staff-avatar-img', function() {
            handleStaffImageError(this);
        });
    });

    // Helper functions for loading indicators
    function spin_loader(id){
        $(id).closest('.card-body').find('.centerDivForLoader').html(`<div class="spinner-grow text-primary m-2" role="status"></div></div>`);
    }
    function remover_spin_loader(id){
        $(id).closest('.card-body').find('.centerDivForLoader').html(``);
    }
</script>
@endsection