@extends('layouts.horizontal', ['title' => 'Dashboard', 'topbarTitle' => 'Dashboard'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css',
    'node_modules/flatpickr/dist/flatpickr.min.css'
])
<style>


</style>
@endsection
@section('content')
{{----------------------------->Top Cards Start <-----------------------------}}
@section('content')
{{----------------------------->Top Cards Start <-----------------------------}}
<div class="head_office_dashboard_top_cards">
    <div class="row mb-3">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Head Office Dashboard</h2>
                <div class="page-title-right d-flex align-items-center gap-2">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
           
                    <div class="d-flex align-items-center gap-2">
                        <button id="refresh-dashboard" onclick="window.location.reload();" type="button" class="btn btn-ghost-dark btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh">
                         <iconify-icon icon="mdi:refresh" class="fs-22" ></iconify-icon>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div> 

        {{-- NEW: Monthly Revenue Targets Section --}}
    <div class="row">
        <div class="col-xl-12">
            <div class="card monthly-targets-card">
                <div class="card-header border-bottom border-dashed border-success">
                    <div class="row">
                        <div class="col-6">
                            <h4 class="header-title text-success">
                                <iconify-icon icon="mdi:calendar-month-outline" class="me-1"></iconify-icon>Monthly Revenue Targets Performance 
                            </h4>
                        </div>
                        <div class="col-md-2">
                            <select id="monthly_target_year" class="form-select">
                                @for ($i = 0; $i < 5; $i++)
                                    @php
                                        $year = date('Y') - $i;
                                    @endphp
                                    <option value="{{ $year }}" {{ $year == date('Y') ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-2">
                        <select id="revenue_type" class="form-select">
                            <option value="All">All</option>
                            <option value="services">Services</option>
                            <option value="retail">Retail</option>
                        </select>
                        
                        </div>
                        <div class="col-md-2">
                            <select id="by_sector_or_location" onchange="display_or_hide_sector_and_business_type('#by_sector_or_location')" class="form-select">
                                <option value="by_location">By Location</option>
                                <option value="by_sector">By Sector</option>
                                <option value="all_branches">All Branches</option>
                            </select>
                        </div>
                        <div class="col-md-2 d-none">
                            <select id="business_type_filter" class="form-select">
                                @foreach ($business_type as $business_type_row)
                                <option value="{{$business_type_row->id_business_type}}">{{$business_type_row->business_type}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    {{-- Filters Row --}}
                    <div class="row filter-row mb-4 d-none">
                        <div class="col-md-3 d-none">
                            <label class="form-label">Business/Branch</label>
                            <select id="business_filter" class="form-select">
                                <option value="">All Businesses</option>
                            </select>
                        </div>
                      
                    </div>
                    <div class="row">
                        <div class="col-md-12" id="monthlyPerformanceRevenuetabsByBusinessType">
                             <ul class="nav nav-pills bg-nav-pills nav-justified mb-2" id="monthlyPerformanceRevenuetabs">
                                @foreach ($business_type as $index => $business_type_row)
                                  @php
                                    $isTabActive =$index ==0 ? 'active' : '';
                                  @endphp  
                                <li class="nav-item " id="business_type_id_li"><button class="nav-link  rounded-0 {{$isTabActive}} business_type_id"  data-bs-toggle="tab" data-bs-target="" data-business_type_id_of_li="{{$business_type_row->id_business_type}}">{{$business_type_row->business_type}}</button></li>
                                @endforeach 
                             </ul>
                            <div class="tab-content" id=""></div> 
                        </div>

                        <div class="col-md-12 d-none" id="monthlyPerformanceRevenuetabsBySector">
                             <ul class="nav nav-pills bg-nav-pills nav-justified mb-2" id="monthlyPerformanceRevenuetabsOfSector">
                                @foreach ($sectors as $index => $sector)
                                  @php
                                    $isTabActive =$index ==0 ? 'active' : '';
                                  @endphp  
                                <li class="nav-item " id="sector_id_of_li"><button class="nav-link  rounded-0 {{$isTabActive}} sector_id_of_li"  data-bs-toggle="tab" data-bs-target="" data-sector_id_of_li="{{$sector->id_sector}}">{{$sector->sector}}</button></li>
                                @endforeach 
                             </ul>
                            <div class="tab-content" id=""></div> 
                        </div>

                    </div>
                    {{-- Summary Boxes --}}
                    <div class="row g-3 mb-1">

                        <!-- Total Target -->
                        <div class="col-md-3 col-sm-6">
                            <div class="card text-bg-primary shadow-sm border border-dashed">
                                <div class="card-body p-3">
                                    <small>Total Target</small>
                                    <h4 class="fw-bold mb-0" id="totalTarget">0</h4>
                                </div>
                            </div>
                        </div>

                        <!-- Total Revenue -->
                        <div class="col-md-3 col-sm-6">
                            <div class="card text-bg-success shadow-sm shadow-sm border border-dashed">
                                <div class="card-body p-3">
                                    <small>Total Revenue</small>
                                    <h4 class="fw-bold mb-0" id="totalRevenue">0</h4>
                                </div>
                            </div>
                        </div>

                        <!-- Achieved % -->
                        <div class="col-md-3 col-sm-6">
                            <div class="card text-bg-warning shadow-sm shadow-sm border border-dashed">
                                <div class="card-body p-3">
                                    <small>Achieved %</small>
                                    <h4 class="fw-bold mb-0" id="achievedPercentage">0%</h4>
                                </div>
                            </div>
                        </div>

                        <!-- Variance -->
                        <div class="col-md-3 col-sm-6">
                            <div class="card text-bg-danger shadow-sm shadow-sm border border-dashed">
                                <div class="card-body p-3">
                                    <small>Variance</small>
                                    <h4 class="fw-bold mb-0" id="totalVariance">0</h4>
                                </div>
                            </div>
                        </div>

                    </div>
                
                    {{-- Charts Row --}}
                    <div class="row mb-4">
                        {{-- <div class="col-md-5 d-none">
                            <div class="chart-container">
                                <h6>Monthly Target vs Revenue</h6>
                                <div id="monthlyTargetVsRevenueChart" style="height: 350px;"></div>
                            </div>
                        </div> --}}
                        <div class="col-md-12">
                             <div class="table-responsive" id="responsiveMonthyDataTableId">
                                <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-11" id="monthlyDataTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th></th>
                                         
                                        </tr>
                                    </thead>
                                    <tbody id="monthlyDataBody">
                                        {{-- Data will be loaded via AJAX --}}
                                    </tbody>
                                    <tfoot class="table-light fw-bold">
                                       
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12">
          <div class="card">
                <div class="card-header border-bottom border-dashed border-primary">
                    <div class="row">
                        <div class="col-8">
                            <h4 class="header-title"></h4>
                            <h4 class="header-title text-primary"><iconify-icon icon="mdi:calendar-month-outline" class="me-1"></iconify-icon>Revenue Targets</h4>
                        </div>
                        <div class="col-2">
                            <select id="target_year" class="form-select form-select-sm">
                                @php
                                    $currentYear = now()->year; // current year
                                    $totalYears = 5;            // last 5 years
                                @endphp

                                @for ($i = 0; $i < $totalYears; $i++)
                                    @php
                                        $year = $currentYear - $i;
                                    @endphp
                                    <option value="{{ $year }}" {{ $year == $currentYear ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endfor
                            </select>
                        </div>

                         <div class="col-md-2">
                            <select id="by_sector_or_location_revenue_targets" class="form-select">
                                <option value="by_location">By Location</option>
                                <option value="by_sector">By Sector</option>
                                <option value="all_branches">All Branches</option>
                            </select>
                        </div>
                    
                    </div>
                   
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7">
                            <ul class="nav nav-pills bg-nav-pills nav-justified mb-3" id="businessTabs"></ul>
                            <div class="tab-content" id="businessTabsContent"></div>
                        </div>
                        <div class="col-md-5 border-start border-dashed border-primary">
                             <div id="revenueTargetsChart" style="height: 400px;"></div>
                 
                        </div>
                    </div>

                </div> 
            </div>
        </div>
        </div>
    <div> 
    <div class="row">
        <div class="col-xl-12">
          <div class="card">
                <div class="card-header border-bottom border-dashed border-primary">
                      <div class="row">
                        <div class="col-4">
                            <h4 class="header-title"></h4>
                            <h4 class="header-title text-primary"><iconify-icon icon="mdi:calendar-month-outline" class="me-1"></iconify-icon>Branches Comparison</h4>
                        </div>
                        <div class="col-2">
                            <select id="comparison_year" class="form-select form-select-sm" onchange="load_branch_comparison_chart()">
                                @php
                                    $currentYear = now()->year; // current year
                                    $totalYears = 5;            // last 5 years
                                @endphp

                                @for ($i = 0; $i < $totalYears; $i++)
                                    @php
                                        $year = $currentYear - $i;
                                    @endphp
                                    <option value="{{ $year }}" {{ $year == $currentYear ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-2">
                             <select id="business_type_id_for_comparison" class="form-select" onchange="updating_branch_comparison_business_type_and_sector('#sector_id')">
                                @foreach ($business_type as $business_type_row)
                                <option value="{{$business_type_row->id_business_type}}">{{$business_type_row->business_type}}</option>
                                @endforeach
                                <option value="0">-select location-</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="sector_id"  class="form-select" onchange="updating_branch_comparison_business_type_and_sector('#business_type_id_for_comparison')" >
                                <option value="0">-select sector-</option>
                                @foreach ($sectors as $sector)
                                <option value="{{$sector->id_sector}}">{{$sector->sector}}</option>
                                @endforeach
                            </select>
                        </div>   
                       
                        <div class="col-2">
                            <select id="account_main" class="form-select form-select-sm" onchange="load_branch_comparison_chart()">
                                @foreach ($account_main as $account )
                                    <option value="{{ $account->account_main }}" {{  $account->account_main =='Revenue'  ? 'selected' : '' }}>{{ $account->account_main }}</option>
                                @endforeach
                            </select>
                        </div>
                    
                    </div>
                </div>
                <div class="card-body">
                    <center><div class="centerDivForLoader"></center>
                      <div id="revenue-cogs-chart"></div>
                    </div>
                </div> 
            </div>
        </div>
        </div>
    <div>


</div>
@endsection
@section('scripts')
<script>
window.CURRENCY_SYMBOL = '{{ config("constants.CURRENCY", "$") }}';
const baseURL = '{{ url('') }}';
let dataTableInstances = {};

var currency = '{{ config("constants.CURRENCY", "$") }}';

// Chart instances
let monthlyTargetVsRevenueChart = null;
let monthlyAchievementChart = null;

$(document).ready(function () {
    $('#business_type_filter, #business_filter, #monthly_target_year ,#target_year, #revenue_type , #account_main , #comparison_year  , #by_sector_or_location , #by_sector_or_location_revenue_targets').select2({
        width: '100%'
    });

    load_branch_comparison_chart();

    loadBusinessRevenueTargetsPerformance();
    loadMonthlyRevenueTargetsPerformance();

    $('#target_year , #by_sector_or_location_revenue_targets').on('change', function () {
        loadBusinessRevenueTargetsPerformance();
    });

    $('.business_type_id , .sector_id_of_li').on('click', function() {
            loadMonthlyRevenueTargetsPerformance();
    });
        
    $('#monthly_target_year , #business_type_filter , #revenue_type, #by_sector_or_location').on('change', function() {
        loadMonthlyRevenueTargetsPerformance();
    });
});



// ====================> Revenue Targets Start <=======================
function loadBusinessRevenueTargetsPerformance() {
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
        const target = $(e.target).data('bs-target');
        const table = $(target).find('table').attr('id');
        initDataTable(table);
    });
    

    let by_sector_or_location_revenue_targets = $("#by_sector_or_location_revenue_targets").val();

    $.ajax({
        url: "{{ route('dashboard.getBusinessRevenueTargetsPerformance') }}",
        type: "GET",
        data: {
            target_year: $('#target_year').val(), 
            by_sector_or_location_revenue_targets: $('#by_sector_or_location_revenue_targets').val(), 
        },
        beforeSend: function () {
            $('#businessTabs').html(
                `<li class="nav-item">
                    <span class="nav-link disabled rounded-0 rounded-0"><div class="spinner-grow text-primary m-2" role="status"></div></div></span>
                 </li>`
            );
            $('#businessTabsContent').html(
                `<div class="text-center py-5"><div class="spinner-grow text-primary m-2" role="status"></div></div></div>`
            );
        },
        success: function (res) {
            console.log(res,"res");
            if (res.success && res.data.length > 0) {
                const groupedData = groupByBusinessType(res.data);
                renderTabs(groupedData);
                        // Chart ke liye data prepare karen
                    renderRevenueChart(res.data);
            } else {
                $('#businessTabs').html('');
                $('#businessTabsContent').html(
                    `<div class="alert alert-warning">No data found</div>`
                );
            }
        },
        error: function (xhr) {
            console.error(xhr);
            $('#businessTabs').html('');
            $('#businessTabsContent').html(
                `<div class="alert alert-danger">Something went wrong</div>`
            );
        }
    });
}

function groupByBusinessType(data) {
    return data.reduce((acc, item) => {
        if (!acc[item.business_type]) {
            acc[item.business_type] = [];
        }
        acc[item.business_type].push(item);
        return acc;
    }, {});
}


function renderTable(rows, tableId) {

    let totalTarget = 0, totalPrev = 0, totalCurr = 0;
    let tbody = '';

    rows.forEach(r => {
        totalTarget += Number(r.target_year);
        totalPrev   += Number(r.actual_prev_year);
        totalCurr   += Number(r.actual_target_year);

        tbody += `
            <tr>
                <td>${r.branch}</td>
                <td>${formatCurrency(r.target_year)}</td>
                <td>${formatCurrency(r.actual_prev_year)}</td>
                <td>${formatCurrency(r.actual_target_year)}</td>
                <td>${(r.yoy_percentage)}%</td>
                <td>${(r.achieved_percentage)}%</td>
            </tr>
        `;
    });

    const yoy = totalPrev > 0 ? (((totalCurr - totalPrev) / totalPrev) * 100).toFixed(2) : 0;
    const achieved = totalTarget > 0 ? ((totalCurr / totalTarget) * 100).toFixed(2) : 0;

    tbody += `
        <tr class="fw-bold bg-light">
            <td>Total</td>
            <td>${formatCurrency(totalTarget)}</td>
            <td>${formatCurrency(totalPrev)}</td>
            <td>${formatCurrency(totalCurr)}</td>
            <td>${yoy}%</td>
            <td>${achieved}%</td>
        </tr>
    `;

    return `
        <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-11" id="${tableId}">
            <thead class="table-light">
                <tr>
                    <th>Branches</th>
                    <th>Target</th>
                    <th>Actual ${$('#target_year').val() - 1}</th>
                    <th>Actual ${$('#target_year').val() }</th>
                    <th>YOY %</th>
                    <th>Achieved %</th>
                </tr>
            </thead>
            <tbody>${tbody}</tbody>
        </table>
    `;
}

function renderTabsOLD(groupedData) {
    
    let tabs = '';
    let content = '';
    let index = 0;

    $.each(groupedData, function (type, rows) {

        const active = index === 0 ? 'active' : '';
        const show   = index === 0 ? 'show active' : '';
        const tableId = `store_table_${index}`;

        tabs += `
            <li class="nav-item">
                <button class="nav-link ${active} rounded-0" data-bs-toggle="tab"
                        data-bs-target="#tab-${index}">
                    ${type}
                </button>
            </li>
        `;

        content += `
            <div class="tab-pane fade ${show}" id="tab-${index}">
                ${renderTable(rows, tableId)}
            </div>
        `;

        // first tab auto init
        if (index === 0) {
            setTimeout(() => initDataTable(tableId), 200);
        }

        index++;
    });

    $('#businessTabs').html(tabs);
    $('#businessTabsContent').html(content);

    // On tab change → init DataTable
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
        const target = $(e.target).data('bs-target');
        const table = $(target).find('table').attr('id');
        initDataTable(table);
    });
}

function renderTabs(groupedData) {

    let tabs = '';
    let content = '';
    let index = 0;

    let byType = $('#by_sector_or_location_revenue_targets').val();


    if (byType === 'all_branches') {

        let allRows = [];

        $.each(groupedData, function (type, rows) {
            allRows = allRows.concat(rows);
        });

        const tableId = 'store_table_all';

        tabs = `
            <li class="nav-item">
                <button class="nav-link active rounded-0"
                        data-bs-toggle="tab"
                        data-bs-target="#tab-all">
                    All Branches
                </button>
            </li>
        `;

        content = `
            <div class="tab-pane fade show active" id="tab-all">
                ${renderTable(allRows, tableId)}
            </div>
        `;

        $('#businessTabs').html(tabs);
        $('#businessTabsContent').html(content);


        setTimeout(() => initDataTable(tableId), 200);
        return; 
    }


    $.each(groupedData, function (type, rows) {

        const active = index === 0 ? 'active' : '';
        const show   = index === 0 ? 'show active' : '';
        const tableId = `store_table_${index}`;

        tabs += `
            <li class="nav-item">
                <button class="nav-link ${active} rounded-0"
                        data-bs-toggle="tab"
                        data-bs-target="#tab-${index}">
                    ${type}
                </button>
            </li>
        `;

        content += `
            <div class="tab-pane fade ${show}" id="tab-${index}">
                ${renderTable(rows, tableId)}
            </div>
        `;

        if (index === 0) {
            setTimeout(() => initDataTable(tableId), 200);
        }

        index++;
    });

    $('#businessTabs').html(tabs);
    $('#businessTabsContent').html(content);

   
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
        const target = $(e.target).data('bs-target');
        const table = $(target).find('table').attr('id');
        initDataTable(table);
    });
}

function initDataTable(tableId) {
    if (!tableId) return;
    if (dataTableInstances[tableId]) {
        dataTableInstances[tableId].destroy();
    }
    
    dataTableInstances[tableId] = $('#' + tableId).DataTable({
        ordering: false,
        responsive: false,
        fixedHeader: true,
        fixedColumns: {
            leftColumns: 1,
        },
        lengthChange: true,
        pageLength: 50,
        searching: false,
        info: false,
        paging: false,
        scrollY: "300px",  
        scrollX: "auto",  
        scrollCollapse: true,
        buttons: [
            { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
            { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
            { extend: "print", className: "btn btn-sm btn-soft-primary" },
            { extend: "pdf",   className: "btn btn-sm btn-soft-primary" }
        ],
        layout: {
            topStart: "buttons",
            topEnd: "search",
            bottomStart: {
                pageLength: {
                    menu: [[50, 100, 1000], [50, 100, 1000]]
                },
                info: {}
            },
            bottomEnd: "paging"
        }
    });
}

function renderRevenueChart(data) {
    if (!Array.isArray(data) || data.length === 0) {
        if (window.revenueChart) {
            window.revenueChart.destroy();
            window.revenueChart = null;
        }
        return;
    }

    const targetYear = Number($('#target_year').val()) || new Date().getFullYear();
    const prevYear = targetYear - 1;

    const safeNumber = (val) => {
        const num = parseFloat(val);
        return isNaN(num) ? 0 : num;
    };

    const branches    = data.map(d => d.branch || 'N/A');
    const targets     = data.map(d => safeNumber(d.target_year));
    const actualPrev  = data.map(d => safeNumber(d.actual_prev_year));
    const actualCurr  = data.map(d => safeNumber(d.actual_target_year));

   
    const rawMax = Math.max(...targets, ...actualPrev, ...actualCurr);
    const niceMax = rawMax > 0 ? Math.ceil(rawMax * 1.1) : 100000; 

    const options = {
        chart: {
            height: 400,
            type: 'line',
            toolbar: { show: true }
        },
        series: [
            { name: 'Target', type: 'line', data: targets },
            { name: `Actual ${prevYear}`, type: 'area', data: actualPrev },
            { name: `Actual ${targetYear}`, type: 'area', data: actualCurr }
        ],
        stroke: { width: [3, 2, 2], curve: 'smooth' },
        xaxis: {
            categories: branches,
            title: { text: 'Branches' },
            labels: { rotate: -45, rotateAlways: true, trim: false, style: { fontSize: '12px', fontWeight: 500 } }
        },
        yaxis: {
            min: 0,
            max: niceMax,
            labels: { formatter: val => formatCurrency(val) }
        },
        tooltip: {
            shared: true,
            intersect: false,
            y: { formatter: val => formatCurrency(val) }
        },
        markers: { size: 4 },
        fill: { opacity: [0, 0.3, 0.3] },
        colors: ['#1E88E5', '#43A047', '#F4511E'],
        legend: { position: 'top' },
        dataLabels: { enabled: false },
        responsive: [
            { breakpoint: 768, options: { chart: { height: 300 }, legend: { position: 'bottom' } } }
        ]
    };

    if (window.revenueChart) {
        window.revenueChart.updateOptions(options, true, true);
    } else {
        window.revenueChart = new ApexCharts(document.querySelector("#revenueTargetsChart"), options);
        window.revenueChart.render();
    }
}
// ====================> Revenue Targets End <=======================

// ====================> Monthly Revenue Functions <=======================
function loadMonthlyRevenueTargetsPerformance() {
    const year = $('#monthly_target_year').val();
    // const businessTypeId = $('#business_type_filter').val();
    const businessId = $('#business_filter').val();
    let businessTypeId =$("#monthlyPerformanceRevenuetabs .business_type_id.active").data('business_type_id_of_li');
    let sector_id =$("#monthlyPerformanceRevenuetabsOfSector .sector_id_of_li.active").data('sector_id_of_li');
    const revenue_type =$('#revenue_type').val();

    let by_sector_or_location = $("#by_sector_or_location").val();

    if (by_sector_or_location === 'by_location') {
        sector_id =0;
    } 
    else if (by_sector_or_location === 'by_sector') {
        businessTypeId =0;
    }

    if(by_sector_or_location =='all_branches'){
        businessTypeId =0;
        sector_id =0;
    }

    // $("#monthlyDataTable thead").html(`<tr><th></th></tr>`);
    // $("#monthlyDataTable tbody").html(``);
    // $("#monthlyDataTable tfoot").html(``);
    if ($.fn.DataTable.isDataTable('#monthlyDataTable')) {
        dataTableInstances={};
        $('#monthlyDataTable').DataTable().destroy(); 
    }

    $("#monthlyDataTable thead").html(`<tr><th></th></tr>`);
    $("#monthlyDataTable tbody").html(``);
    $("#monthlyDataTable tfoot").html(``);

    $.ajax({
        url: "{{ route('dashboard.getBusinessRevenueTargetsPerformanceMonthly') }}",
        type: "GET",
        data: {
            target_year: year,
            business_type_id: businessTypeId,
            sector_id: sector_id,
            business_id: businessId,
            revenue_type: revenue_type,
            by_sector_or_location_or_all_branches: by_sector_or_location
        },
        beforeSend: function() {
            // Show loading indicators
            $('#monthlyDataBody').html(`<tr><td class="text-center"><div class="spinner-grow text-primary m-2 text-center" role="status"></div></div></td></tr>`);
        },
        success: function(res) {
            if (res.success) {
                renderMonthlyData(res.data);
                // renderMonthlyCharts(res.data);
                updateSummaryBoxes(res.data.summary);
                renderSummaryChart(res.data);
            } else {
                showMonthlyError('Failed to load monthly data');
            }
        },
        error: function(xhr) {
            console.error(xhr);
            showMonthlyError('Error loading monthly data');
        }
    });
}

function loadBusinessTypesForFilter() {
    $.ajax({
        url: "{{ route('dashboard.getBusinessRevenueTargetsPerformanceMonthly') }}",
        type: "GET",
        data: { target_year: $('#monthly_target_year').val() },
        success: function(res) {
            if (res.success && res.data.filters.business_types) {
                const businessTypes = res.data.filters.business_types;
                let options = '<option value="">All Business Types</option>';
                
                businessTypes.forEach(type => {
                    options += `<option value="${type.id_business_type}">${type.business_type}</option>`;
                });
                
                $('#business_type_filter').html(options);
            }
        }
    });
}

function loadBusinessesForFilter(businessTypeId) {
    $.ajax({
        url: "{{ route('dashboard.getBusinessRevenueTargetsPerformanceMonthly') }}",
        type: "GET",
        data: {
            target_year: $('#monthly_target_year').val(),
            business_type_id: businessTypeId
        },
        success: function(res) {
            if (res.success && res.data.filters.businesses) {
                const businesses = res.data.filters.businesses;
                let options = '<option value="">All Businesses</option>';
                
                businesses.forEach(business => {
                    options += `<option value="${business.id_business}">${business.business_name}</option>`;
                });
                
                $('#business_filter').html(options);
            }
        }
    });
}


function groupByMonthAndBusiness(data) {
    const months = {};
    const businesses = {};
    
    data.forEach(item => {
        // collect unique businesses
        businesses[item.business_id] = item.business_name;

        // group by month
        if (!months[item.month]) {
            months[item.month] = {
                month_name: item.month_name,
                businesses: {}
            };
        }

        months[item.month].businesses[item.business_id] = item;
    });

    return { months, businesses };
}


function renderMonthlyTableHeader(businesses) {
    let th = `<th>Month</th>`;

    // === Business-wise columns ===
    Object.entries(businesses).forEach(([id, name]) => {
        th += `
            <th>${name} Target</th>
            <th>${name} Revenue</th>
            <th>${name} Achieved %</th>
        `;
    });

    // === Month-wise Total Columns at the end ===
    th += `
        <th>Total Target</th>
        <th>Total Revenue</th>
        <th>Total Achieved %</th>
        <th>Total Variance</th>
    `;

    $('#monthlyDataTable thead tr').html(th);
}


function renderDynamicFooter(businesses, totals) {

    let footerHtml = `<tr><td class="fw-bold">Total</td>`;

    let grandTarget = 0;
    let grandRevenue = 0;

    // === Business-wise totals ===
    Object.keys(businesses).forEach(businessId => {

        const t = totals[businessId] || { target: 0, revenue: 0 };
        const achieved = t.target > 0 ? ((t.revenue / t.target) * 100).toFixed(2) : 0;

        footerHtml += `
            <td class="fw-bold">${formatCurrency(t.target)}</td>
            <td class="fw-bold">${formatCurrency(t.revenue)}</td>
            <td class="fw-bold">${achieved}%</td>
        `;

        // === Grand totals calculation ===
        grandTarget += Number(t.target);
        grandRevenue += Number(t.revenue);
    });

    // === Grand total columns at the end ===
    const grandVariance = grandRevenue - grandTarget;
    const grandAchieved = grandTarget > 0 ? ((grandRevenue / grandTarget) * 100).toFixed(2) : 0;

    footerHtml += `
        <td class="fw-bold">${formatCurrency(grandTarget)}</td>
        <td class="fw-bold">${formatCurrency(grandRevenue)}</td>
        <td class="fw-bold">${grandAchieved}%</td>
        <td class="${grandVariance >= 0 ? 'variance-positive' : 'variance-negative'}">${formatCurrency(grandVariance)}</td>
    </tr>`;

    $('#monthlyDataTable tfoot').html(footerHtml);
}



function renderMonthlyData(data) {

    if ($.fn.DataTable.isDataTable('#monthlyDataTable')) {
        dataTableInstances={};
        $('#monthlyDataTable').DataTable().destroy(); 
    }


    const monthlyData = data.monthly_data;

    const { months, businesses } = groupByMonthAndBusiness(monthlyData);

    renderMonthlyTableHeader(businesses);

    let html = '';

    // === FOOTER TOTALS PER BUSINESS ===
    const footerTotals = {};

    Object.values(months).forEach(monthRow => {

        html += `<tr><td class="fw-bold">${monthRow.month_name}</td>`;

        let monthTarget = 0;
        let monthRevenue = 0;

        Object.keys(businesses).forEach(businessId => {

            const item = monthRow.businesses[businessId] || {
                target: 0,
                revenue: 0,
                achieved_percentage: 0,
                variance: 0
            };

            const achieved = Number(item.achieved_percentage).toFixed(2);

            // === collect totals per business for footer ===
            if (!footerTotals[businessId]) {
                footerTotals[businessId] = { target: 0, revenue: 0 };
            }
            footerTotals[businessId].target += Number(item.target);
            footerTotals[businessId].revenue += Number(item.revenue);

            // === month-wise totals ===
            monthTarget += Number(item.target);
            monthRevenue += Number(item.revenue);

            html += `
                <td>${formatCurrency(item.target)}</td>
                <td>${formatCurrency(item.revenue)}</td>
                <td>
                    <div class="progress" style="height:6px">
                        <div class="progress-bar ${
                            achieved >= 100 ? 'bg-success' :
                            achieved >= 80 ? 'bg-warning' : 'bg-danger'
                        }" style="width:${Math.min(achieved,100)}%"></div>
                    </div>
                    <small>${achieved}%</small>
                </td>
            `;
        });

        // === Month-wise Total Columns ===
        const monthVariance = monthRevenue - monthTarget;
        const monthAchievedPercent = monthTarget > 0 ? ((monthRevenue / monthTarget) * 100).toFixed(2) : 0;

        html += `
            <td class="fw-bold">${formatCurrency(monthTarget)}</td>
            <td class="fw-bold">${formatCurrency(monthRevenue)}</td>
            <td class="fw-bold">${monthAchievedPercent}%</td>
            <td class="${monthVariance >= 0 ? 'variance-positive' : 'variance-negative'}">
                ${formatCurrency(monthVariance)}
            </td>
        `;

        html += `</tr>`;
    });

    $('#monthlyDataBody').html(html);

    // === Render Dynamic Footer (Business-wise totals) ===
    renderDynamicFooter(businesses, footerTotals);

    initDataTable('monthlyDataTable');
}


function renderMonthlyDataOLD(data) {
    const monthlyData = data.monthly_data;
    let html = '';

    let totalTarget = 0;
    let totalRevenue = 0;

    monthlyData.forEach(item => {
        totalTarget += Number(item.target);
        totalRevenue += Number(item.revenue);

        const varianceClass = item.variance >= 0 ? 'variance-positive' : 'variance-negative';
        const statusClass = item.achieved_percentage >= 100 ? 'badge bg-success' :
                            item.achieved_percentage >= 80 ? 'badge bg-warning' :
                            'badge bg-danger';

        const statusText = item.achieved_percentage >= 100 ? 'Achieved' :
                           item.achieved_percentage >= 80 ? 'On Track' :
                           'Needs Attention';

        html += `
            <tr>
                <td class="fw-bold">${item.month_name}</td>
                <td>${formatCurrency(item.target)}</td>
                <td>${formatCurrency(item.revenue)}</td>
                <td>
                    <div class="d-flex align-items-center">
                        <div class="progress flex-grow-1" style="height: 8px;">
                            <div class="progress-bar ${item.achieved_percentage >= 100 ? 'bg-success' : item.achieved_percentage >= 80 ? 'bg-warning' : 'bg-danger'}"
                                 style="width: ${Math.min(item.achieved_percentage, 100)}%">
                            </div>
                        </div>
                        <span class="ms-2">${item.achieved_percentage.toFixed(2)}%</span>
                    </div>
                </td>
                <td class="${varianceClass}">
                    ${formatCurrency(item.variance)}
                </td>
                <td>
                    <span class="${statusClass}">${statusText}</span>
                </td>
            </tr>
        `;
    });

    $('#monthlyDataBody').html(html);

    /* ===== FOOTER CALCULATIONS ===== */
    const totalVariance = totalRevenue - totalTarget;
    const achievedPercent = totalTarget > 0
        ? ((totalRevenue / totalTarget) * 100).toFixed(2)
        : 0;

    $('#ft_target').html(formatCurrency(totalTarget));
    $('#ft_revenue').html(formatCurrency(totalRevenue));
    $('#ft_variance')
        .html(formatCurrency(totalVariance))
        .removeClass('variance-positive variance-negative')
        .addClass(totalVariance >= 0 ? 'variance-positive' : 'variance-negative');

    $('#ft_achieved').html(achievedPercent + '%');

    initDataTable('monthlyDataTable');
}

function updateSummaryBoxes(summary) {
    $('#totalTarget').text(formatCurrency(summary.total_target));
    $('#totalRevenue').text(formatCurrency(summary.total_revenue));
    $('#achievedPercentage').text(summary.overall_achieved_percentage.toFixed(2) + '%');
    
    const variance = summary.total_variance;
    const varianceClass = variance >= 0 ? 'variance-positive' : 'variance-negative';
    const varianceSymbol = variance >= 0 ? '+' : '';
    
    $('#totalVariance').html(`<span class="${varianceClass}">${varianceSymbol}${formatCurrency(variance)}</span>`);
}

function renderMonthlyCharts(data) {
    const monthlyData = data.monthly_data;
    
    // Prepare data for charts
    const months = monthlyData.map(item => item.month_name);
    const targets = monthlyData.map(item => item.target);
    const revenues = monthlyData.map(item => item.revenue);
    const achievementPercentages = monthlyData.map(item => item.achieved_percentage);
    
    // Chart 1: Monthly Target vs Revenue (Dual Axis)
    const targetVsRevenueOptions = {
        chart: {
            type: 'line',
            height: 350,
            toolbar: { show: true }
        },
        series: [
            {
                name: 'Target',
                type: 'column',
                data: targets
            },
            {
                name: 'Revenue',
                type: 'line',
                data: revenues
            }
        ],
        stroke: {
            width: [0, 3],
            curve: 'smooth'
        },
        colors: ['#667eea', '#4CAF50'],
        fill: {
            type: 'solid',
            opacity: [0.8, 0]
        },
        markers: {
            size: [0, 4],
            colors: ['#4CAF50'],
            strokeColors: '#fff',
            strokeWidth: 2
        },
        xaxis: {
            categories: months
        },
        yaxis: [
            {
                title: {
                    text: 'Target Amount'
                },
                labels: {
                    formatter: function(val) {
                        return formatCurrency(val);
                    }
                }
            },
            {
                opposite: true,
                title: {
                    text: 'Revenue Amount'
                },
                labels: {
                    formatter: function(val) {
                        return formatCurrency(val);
                    }
                }
            }
        ],
        tooltip: {
            shared: true,
            intersect: false,
            y: {
                formatter: function(val) {
                    return formatCurrency(val);
                }
            }
        },
        legend: {
            position: 'top'
        },
        dataLabels: {
            enabled: false
        }
    };
    
    // Render or update charts
    if (monthlyTargetVsRevenueChart) {
        monthlyTargetVsRevenueChart.updateOptions(targetVsRevenueOptions);
    } else {
        monthlyTargetVsRevenueChart = new ApexCharts(
            document.querySelector("#monthlyTargetVsRevenueChart"),
            targetVsRevenueOptions
        );
        monthlyTargetVsRevenueChart.render();
    }
 
}

function showMonthlyError(message) {
    $('#monthlyDataBody').html(`
        <tr>
            <td colspan="6" class="text-center text-danger">
                <iconify-icon icon="mdi:alert-circle-outline" class="me-2"></iconify-icon>
                ${message}
            </td>
        </tr>
    `);
}


function renderSummaryChart(data) {
    const dataArray = Array.isArray(data) ? data : data.monthly_data;
    const summaryByMonth = dataArray.reduce((acc, item) => {
    const month = item.month_name;
        if (!acc[month]) {
            // Initialize
            acc[month] = {
                month: item.month,
                month_name: item.month_name,
                total_target: parseFloat(item.target),
                total_revenue: parseFloat(item.revenue),
                total_variance: parseFloat(item.variance),
            };
        } else {
            // Sum up
            acc[month].total_target += parseFloat(item.target);
            acc[month].total_revenue += parseFloat(item.revenue);
            acc[month].total_variance += parseFloat(item.variance);
        }
        // Calculate achieved percentage safely
        acc[month].overall_achieved_percentage = acc[month].total_target
            ? (acc[month].total_revenue / acc[month].total_target) * 100
            : 0;

        return acc;
    }, {});
    const summaryArray = Object.values(summaryByMonth);
}

function formatCurrency(amount,currency='Yes') {
    const currencySymbol = currency =='Yes' ?  window.CURRENCY_SYMBOL || '$' : '';
    // Convert to number, handling null, undefined, strings, etc.
    const numAmount = parseFloat(amount) || 0;
    if (Math.abs(numAmount) >= 1000000) {
        return currencySymbol + (numAmount / 1000000).toFixed(2) + 'M';
    } else if (Math.abs(numAmount) >= 1000) {
        return currencySymbol + (numAmount / 1000).toFixed(2) + 'K';
    }
    return currencySymbol + numAmount.toFixed(2);
}


function load_branch_comparison_chart(){
    var account_main = $("#account_main").val();
    var comparison_year = $("#comparison_year").val();
    var business_type_id_for_comparison = $("#business_type_id_for_comparison").val() || 0;
    var sector_id = $("#sector_id").val() || 0;
    $("#revenue-cogs-chart").empty();
    spin_loader('#revenue-cogs-chart');      
    
    $.ajax({
        url: baseURL + '/dashboard/head_office/branches_comparison',
        type: 'GET',
        data: {
            account_main: account_main,
            comparison_year: comparison_year,
            business_type_id_for_comparison: business_type_id_for_comparison,
            sector_id: sector_id,
        },
        dataType: 'json',
        success: function (response) {
            remover_spin_loader('#revenue-cogs-chart');
            
            if(response.success && response.data.length > 0) {
                let data = response.data;

                // =========================
                // Process Data Dynamically
                // =========================
                const monthNames = {
                    'January': 0, 'February': 1, 'March': 2, 'April': 3,
                    'May': 4, 'June': 5, 'July': 6, 'August': 7,
                    'September': 8, 'October': 9, 'November': 10, 'December': 11
                };
                
                const monthShortNames = [
                    'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                    'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
                ];
                
                // Get all unique branches with their names
                const branches = {};
                data.forEach(item => {
                    if (!branches[item.business_id]) {
                        branches[item.business_id] = {
                            id: item.business_id,
                            name: item.business_name,
                            data: new Array(12).fill(0)
                        };
                    }

                    const monthIndex = parseInt(item.month_num) - 1;

                    if (monthIndex >= 0 && monthIndex < 12) {
                        branches[item.business_id].data[monthIndex] = parseFloat(item.balance) || 0;
                    }
                });

                // Populate data for each branch
                data.forEach(item => {
                    const monthName = item.month;
                    const monthIndex = monthNames[monthName];
                    
                    if (monthIndex !== undefined && branches[item.business_id]) {
                        branches[item.business_id].data[monthIndex] = parseFloat(item.balance) || 0;
                    }
                });
                
                // Convert to series array
                const revenueSeries = Object.values(branches).map(branch => ({
                    name: branch.name,
                    data: branch.data
                }));
                
                console.log("Revenue Series:", revenueSeries); // Debugging ke liye
                

                const displayDates = monthShortNames.map(month => `${month} ${comparison_year}`);
                

                let maxVal = 0;
                revenueSeries.forEach(series => {
                    const seriesMax = Math.max(...series.data);
                    if (seriesMax > maxVal) {
                        maxVal = seriesMax;
                    }
                });
                
                const padding = maxVal > 0 ? maxVal * 0.1 : 1000; // 10% padding or default 1000
                

                const colorPalette = [
                    '#0d6efd', '#28a745', '#ffc107', '#dc3545', 
                    '#6f42c1', '#20c997', '#fd7e14', '#e83e8c',
                    '#17a2b8', '#6c757d', '#343a40', '#007bff'
                ];
                

                revenueSeries.forEach((series, index) => {
                    series.color = colorPalette[index % colorPalette.length];
                });
                

                function formatCurrency(value) {
                    return 'Rs ' + Math.round(value).toLocaleString();
                }
                

                if (window.revenueCogsChart) {
                    window.revenueCogsChart.destroy();
                }
                

                const chartOptions = {
                    chart: {
                        type: 'line',
                        height: 300,
                        toolbar: { 
                            show: true,
                            tools: {
                                download: true,
                                selection: true,
                                zoom: true,
                                zoomin: true,
                                zoomout: true,
                                pan: true,
                                reset: true
                            }
                        },
                        fontFamily: 'Inter, Arial, sans-serif',
                        dropShadow: {
                            enabled: true,
                            top: 3,
                            left: 2,
                            blur: 6,
                            opacity: 0.15
                        },
                        animations: {
                            enabled: true,
                            easing: 'easeinout',
                            speed: 900
                        },
                        zoom: {
                            enabled: true,
                            type: 'x',
                            autoScaleYaxis: true
                        }
                    },
                    
                    series: revenueSeries,
                    
                    stroke: {
                        width: 3,
                        curve: 'smooth'
                    },
                    
                    colors: revenueSeries.map(series => series.color),
                    
                    markers: {
                        size: 5,
                        strokeWidth: 2,
                        hover: { 
                            size: 7 
                        }
                    },
                    
                    grid: {
                        borderColor: '#e9ecef',
                        strokeDashArray: 4
                    },
                    
                    xaxis: {
                        categories: displayDates,
                        labels: {
                            rotate: -45,
                            style: {
                                fontSize: '11px',
                                fontWeight: 500,
                                colors: '#6c757d'
                            }
                        },
                        axisBorder: { 
                            show: false 
                        },
                        axisTicks: { 
                            show: false 
                        },
                        tooltip: {
                            enabled: false
                        }
                    },
                    
                    yaxis: {
                        min: 0,
                        max: maxVal + padding,
                        labels: {
                            formatter: val => formatCurrency(val),
                            style: {
                                fontSize: '11px',
                                colors: '#6c757d'
                            }
                        },
                        title: {
                            text: account_main || 'Amount',
                            style: {
                                fontSize: '12px',
                                fontWeight: 600,
                                color: '#495057'
                            }
                        }
                    },
                    
                    tooltip: {
                        shared: true,
                        intersect: false,
                        theme: 'light',
                        y: {
                            formatter: val => formatCurrency(val)
                        },
                        x: {
                            formatter: function(value, { seriesIndex, dataPointIndex, w }) {
                                const fullMonths = [
                                    'January', 'February', 'March', 'April', 'May', 'June',
                                    'July', 'August', 'September', 'October', 'November', 'December'
                                ];
                                return `${fullMonths[dataPointIndex]} ${comparison_year}`;
                            }
                        }
                    },
                    
                    legend: {
                        position: 'bottom',
                        fontSize: '11px',
                        markers: {
                            width: 10,
                            height: 10,
                            radius: 10
                        },
                        itemMargin: {
                            horizontal: 10,
                            vertical: 5
                        }
                    },
                    
                    // Add responsive options
                    responsive: [{
                        breakpoint: 768,
                        options: {
                            chart: {
                                height: 300
                            },
                            legend: {
                                position: 'bottom',
                                horizontalAlign: 'center'
                            }
                        }
                    }],
                    
                    
                    dataLabels: {
                        enabled: false
                    }
                };
                
    
                window.revenueCogsChart = new ApexCharts(
                    document.querySelector("#revenue-cogs-chart"),
                    chartOptions
                );
                
           
                window.revenueCogsChart.render();
                
            } else {
                
                $("#revenue-cogs-chart").html(
                    '<div class="text-center p-5">' +
                    '<h5>No data available</h5>' +
                    '<p class="text-muted">Please select different filters</p>' +
                    '</div>'
                );
            }
        },
        error: function (err) {
            console.error('Error fetching branches comparison data', err);
            remover_spin_loader('#revenue-cogs-chart');
            
            // Show error message
            $("#revenue-cogs-chart").html(
                '<div class="text-center p-5 text-danger">' +
                '<h5>Error loading chart</h5>' +
                '<p class="text-muted">Please try again later</p>' +
                '</div>'
            );
        }
    });
}

function spin_loader(id){
    $(id).closest('.card-body').find('.centerDivForLoader').html(`<div class="spinner-grow text-primary m-2" role="status"></div></div>`);
}
function remover_spin_loader(id){
    $(id).closest('.card-body').find('.centerDivForLoader').html(``);
}

function display_or_hide_sector_and_business_type(id){
    let selectedValue = $(id).val();
    $('#monthlyPerformanceRevenuetabsBySector, #monthlyPerformanceRevenuetabsByBusinessType')
        .addClass('d-none');

    if (selectedValue === 'by_location') {
        $('#monthlyPerformanceRevenuetabsByBusinessType').removeClass('d-none');
    } 
    else if (selectedValue === 'by_sector') {
        $('#monthlyPerformanceRevenuetabsBySector').removeClass('d-none');
    }else if(selectedValue =='all_branches'){
          $('#monthlyPerformanceRevenuetabsBySector, #monthlyPerformanceRevenuetabsByBusinessType')
        .addClass('d-none');
    }
}

function updating_branch_comparison_business_type_and_sector(id){
    $(id).val(0);
    load_branch_comparison_chart();
}


 
</script>
@endsection