@extends('layouts.horizontal', ['title' => 'Dashboard', 'topbarTitle' => 'Dashboard'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css',
    'node_modules/flatpickr/dist/flatpickr.min.css'
])
<style>

.table-responsive {
    max-height: 400px; 
    overflow-y: auto; 
    overflow-x: auto;
}

#product-categories-table {
    width: 100%;  
}

#product-categories-table th,
#product-categories-table td {
    white-space: nowrap; 
}

#product-categories-table tfoot {
    position: sticky;
    bottom: 0;
    background-color: #ffffff;
    z-index: 10;
}


#categories-wise-stock-sale{
    width: 100%;  
}

#categories-wise-stock-sale th,
#categories-wise-stock-sale td {
    white-space: nowrap; 
}

#categories-wise-stock-sale tfoot {
    position: sticky;
    bottom: 0;
    background-color: #ffffff;
    z-index: 10;
}
</style>
@endsection
@section('content')
{{----------------------------->Top Cards Start <-----------------------------}}
@section('content')
{{----------------------------->Top Cards Start <-----------------------------}}

@php
$start_date = now()->subDays(30)->toDateString(); 
$end_date   = now()->toDateString();  
@endphp
<div class="retail_dashboard_top_cards">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Retail Dashboard</h2>
                <div class="page-title-right d-flex align-items-center gap-2">
                    {{-- Date Range:  --}}
                    <div class="d-flex align-items-center gap-2">
                        <input class="form-control" id="dateRange" type="text" value="{{ \Carbon\Carbon::parse($start_date)->format('d-m-Y') }} - {{ \Carbon\Carbon::parse($end_date)->format('d-m-Y') }}" style="min-width: 200px;" />
                        <select class="form-select" id="business_id" name="business_id" data-toggle="select2">
                            @if (session('ho') =="Yes")
                                @foreach($branches as $business)
                                    <option value="{{ $business->id_business }}" {{ $business->id_business == session('business_id') ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                @endforeach
                            @else
                            <option value="{{ session('business_id') }}">{{ session('business_name') }}</option>
                            @endif
                        </select>
                        <button id="refresh-dashboard" style="width: 100px;" type="button" class="btn btn-ghost-dark btn-icon rounded-circle" data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh">
                         <iconify-icon icon="mdi:refresh" class="fs-22" ></iconify-icon>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

<div class="row row-cols-xxl-4 row-cols-md-4 row-cols-sm-1">

    {{--------------------- Retail Customer Receivable Card Start -------------}}
        <div class="col">
            <div class="card">
                
                <div class="card-header d-flex justify-content-between align-items-start">
                    <div>
                        <h4 class="header-title mb-0">Retail Receivable</h4>
                        <p class="text-muted mb-0 " style="font-size: 0.75rem;">(<span class="retail-customer-receivbles-date-range-current-month"></span>)</p>
                    </div>
                    <i class="ri-information-line info-icon" 
                    data-bs-toggle="tooltip" 
                    data-bs-placement="bottom" 
                    title="Displays receivables, received amount, and pending dues from retail customers in the current month. The progress bar shows collection efficiency."></i>
                </div>
                
                <div class="card-body pt-0">

                    <center><div class="centerDivForLoader"></center>
                    <div class="d-flex align-items-center gap-2 justify-content-between">
                        <!-- Badge showing Paid % -->
                        <span class="badge bg-success rounded-pill fs-13" id="retailCustomerReceivable-badge">
                        </span>
                        <!-- Main balance -->
                        <div class="text-end">
                            <h3 class="fw-semibold" id="retailCustomerReceivable">-</h3>
                            <p class="text-muted mb-0 fs-11" id="retailCustomerReceivable-details">
                                Loading...
                            </p>
                        </div>
                    </div>

                    <!-- Progress bar -->
                    <div class="progress progress-soft progress-sm mt-3">
                        <div class="progress-bar" role="progressbar" id="retailCustomerReceivable-progress" style="width:0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
        </div>
    {{--------------------- Retail Customer Receivable Card End -------------}} 


      {{---------------------Retail Customer Payable Card Start -----------}}
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Retail Advances</h4>
                    <p class="text-muted mb-0" style="font-size: 0.75rem;">
                       (<span class="retail-customer-payables-date-range-current-month"></span>)
                    </p>
                </div>
                <i class="ri-information-line info-icon"
                data-bs-toggle="tooltip"
                data-bs-placement="bottom"
                title="Displays total advances received from retail customers & Franchies, amount already utilized, and remaining balance.">
                </i>
            </div>

            <div class="card-body pt-0">
                <center><div class="centerDivForLoader"></center>
                <div class="d-flex align-items-center gap-2 justify-content-between">
                    <span class="badge bg-success rounded-pill fs-13"
                        id="retailCustomerPayable-badge"></span>

                    <div class="text-end">
                        <h3 class="fw-semibold" id="retailCustomerPayable">-</h3>
                        <p class="text-muted mb-0 fs-11"
                        id="retailCustomerPayable-details">Loading...</p>
                    </div>
                </div>

                <div class="progress progress-soft progress-sm mt-3">
                    <div class="progress-bar"
                        id="retailCustomerPayable-progress"
                        style="width:0%"></div>
                </div>
            </div>
        </div>
    </div>

    {{---------------------Retail Customer Payable Card Start -------------}} 

    {{------------------ Purchase Vs GRN Start  -------------}}
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title ">Unreceived Goods</h4>
                    <p class="text-muted mb-0" style="font-size: 0.75rem;">
                        (<span class="purchase-grn-date"></span>)
                    </p>
                </div>
               
                <select id="purchase-grn-mode" 
                        class="form-select form-select-sm d-inline-block" 
                        style="width: 75px; height: 28px; font-size: 0.55rem; vertical-align: left;">
                        <option value="qty">Quantity</option>
                    <option value="amount">Amount</option>
                </select>

            </div>

            <div class="card-body pt-2">
                <center><div class="centerDivForLoader"></center>
                <div class="d-flex align-items-center gap-2 justify-content-between">
                    <!-- Badge showing Paid % -->
                    <span class="badge bg-success rounded-pill fs-13" id="purchase-grn-badge"></span>

                    <!-- Main balance -->
                    <div class="text-end">
                        <h3 class="fw-semibold" id="purchase-grn-main">-</h3>
                        <p class="text-muted mb-0 fs-11" id="purchase-grn-sub">
                            Loading...
                        </p>
                    </div>
                </div>

                <!-- Progress bar -->
                <div class="progress progress-soft progress-sm mt-2">
                    <div class="progress-bar" role="progressbar" id="purchase-grn-progress" style="width:0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
        </div>
    </div>
    {{------------------ Purchase Vs GRN Start  -------------}}

    {{------------------ Retail Revenue Start  -------------}}
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Retail Revenue</h4>
                    <p class="text-muted mb-0 " style="font-size: 0.75rem;">(<span class="retail-date-range"></span>)</p>
                </div>
                <i class="ri-information-line info-icon" 
                data-bs-toggle="tooltip" 
                data-bs-placement="bottom" 
                title="Displays the total retail revenue generated in the selected period. The progress bar shows the percentage change compared to last month."></i>
            </div>

            <div class="card-body pt-0">
                <center><div class="centerDivForLoader"></center>
                <div class="d-flex align-items-center gap-2 justify-content-between">
                    <span class="badge bg-success rounded-pill fs-13" id="retail-revenue-badge">- <i class="ti ti-trending-up"></i> </span>
                    <div class="text-end">
                        <h3 class="fw-semibold" id="retail-revenue-value">-</h3>
                        <p class="text-muted mb-0 fs-11" id="retail-revenue-change">Loading...</p>
                    </div>
                </div>

                <div class="progress progress-soft progress-sm mt-3">
                    <div class="progress-bar bg-success" role="progressbar" id="retail-revenue-progress" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
            </div>
        </div>
    </div>
    {{------------------ Retail Revenue End  -------------}}

</div><!-- end row -->

{{------------------------------>Top Cards End<-----------------------------}}

<div class="row">

    <div class="col-xxl-4 col-xl-4 col-lg-4">
        <div class="card card-h-100">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                <div>
                    <h4 class="header-title mb-0">Top 5 Products Sales <small class="text-muted">(Quantity Based)</small></h4>
                    <p class="text-muted mb-0" style="font-size: 0.75rem;">Date Range: <span id="top-product-date-range"></span></p>
                </div>
            </div>
            <div class="card-body pt-2">
                 <center><div class="centerDivForLoader"></center>
                <div dir="ltr">
                    <!-- Apex Chart Container -->
                    <div id="rotate-labels-column" class="apex-charts" data-colors="#fa5c7c">
                        <div class="text-center" id="topProductsSecionLoadaer">
                            <span class="ms-2"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="col-xxl-4 col-xl-4 col-lg-4">
        <div class="card  card-h-100">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-0">Category-wise Stock Sales Analysis</h4>
                        <p class="text-muted mb-0" style="font-size: 0.75rem;">Date Range: <span id="top-categories-date-range"></span></p>
                    </div>
                  
            </div>
            <div class="card-body pt-2">
                 <center><div class="centerDivForLoader"></center>
                <div dir="ltr" id="top_categories">
                    
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-4 col-xl-4 col-lg-4">
        <div class="card card-h-100">
            <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-0">Month Collection Breakup</h4>
                        <p class="text-muted mb-0" style="font-size: 0.75rem;">Date Range: <span id="basic-bar-date-range"></span></p>
                    </div>
                   
            </div>
            <div class="card-body pt-2">
                 <center><div class="centerDivForLoader"></center>
                <div dir="ltr" id="basic-bar">
                    
                </div>
            </div>
        </div>
    </div>

</div> <!-- end row-->

<div class="row">
    <div class="col">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-start">
                <div>
                    <h4 class="header-title mb-0">Revenue & COGS Overview</h4>
                    <p class="text-muted mb-0 " style="font-size: 0.75rem;">Date Range: (<span class="revenue-cogs-chart-date-range"></span>)</p>
                </div>
            </div>
            <div class="card-body pt-0">
                <center><div class="centerDivForLoader"></center>
                <div id="revenue-cogs-chart">
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Top Product Categories  Section Start-->
    <div class="row">

        <div class="col-xxl-4 col-xl-4">
            <div class="card card-h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-1">Top 10 Retail Customers</h4>
                        <p class="text-muted mb-0 date-range-past-3-months" style="font-size: 0.75rem;"> Date Range: <span id="top_customers_date_range" ></span></p>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                    <table id="top_customers" class="table table-custom table-centered table-sm table-nowrap table-hover mb-0 w-100 table-sm fs-13">
                        <thead>
                            <tr class="fw-bold">
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Revenue</th>
                                <th class="text-end">Balance</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                    </div>
                </div>
            </div>
        </div> 

        <div class="col-xxl-8 col-xl-8">
            <div class="card card-h-100">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-between gap-2 border-bottom border-dashed">
                    <div>
                        <h4 class="header-title mb-1">Product Categories Status</h4>
                        <p class="text-muted mb-0 date-range-past-3-months" style="font-size: 0.75rem;">Stock last updated: <span id="product_stock_category_status_last_updated_at"></span></p>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                    <table id="product-categories-table" class="table table-custom table-centered table-sm table-nowrap table-hover mb-0 w-100 table-sm fs-13">
                        <thead>
                            <tr class="fw-bold">
                                {{-- <th>Branch</th> --}}
                                <th>Store</th>
                                <th>Category</th>
                                <th class="text-end">Products Count</th>
                                <th class="text-end">In Stock</th>
                                <th class="text-end">In Stock (%)</th>
                                <th class="text-end">Stock Value</th>
                                <th class="text-end">Stock Value (%)</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tfoot class="fw-bold">
                            <tr>
                                <td colspan="2" class="text-start">Grand Total</td>
                                <td id="ft_product_count" class="text-center"></td>
                                <td id="ft_instock" class="text-end"></td>
                                <td class="text-center" id="footr_stock_perc"></td>
                                <td id="ft_stock_value" class="text-end"></td>
                                <td class="text-center" id="footer_stock_value_perc"></td>
                            </tr>
                        </tfoot>
                    </table>
                    </div>
                </div>
            </div>
        </div> 
    </div> 

</div>
@endsection
@section('scripts')
<script>
    // Currency from Laravel config
    window.CURRENCY_SYMBOL = '{{ config("constants.CURRENCY", "$") }}';
    // Base URL (supports subfolders)
    const baseURL = '{{ url('') }}';
    let totalVisitsChart = null;
let newCustomersChart = null;
let dataVisitsChart = null;
let statisticsChart = null;
let monthlyPerformanceChart = null;
let footfallHeatmapChart = null;
let customersChartLoaded = false;
var rotateLabelsChart = null;
let retailChart = null;
let revenueCogsChart = null;

$(document).ready(function () {

    flatpickr("#dateRange", {
        mode: "range",
        dateFormat: "Y-m-d",
        // minDate: "today",
        // maxDate: new Date().fp_incr(30) // 30 days from today
        defaultDate: ["{{ $start_date }}", "{{ $end_date }}"]
    });
    setTimeout(function() {

        loadDashboardData();
    }, 1);

    // Refresh button event
    $('#refresh-dashboard').on('click', function() {
        loadDashboardData();
    });

});

function getDateRangeForMonths() {
    return { 
        start: document.getElementById('dateRange').value.split(' to ')[0], 
        end: document.getElementById('dateRange').value.split(' to ')[1],
    };
}

function loadDashboardData() {
    const dateRange = getDateRangeForMonths();
    if (!dateRange) return;

    const from = dateRange.start;
    const to   = dateRange.end;

    const startDate = new Date(from);
    const endDate   = new Date(to);

    const maxMonths = 24;

    const diffMonths =
        (endDate.getFullYear() - startDate.getFullYear()) * 12 +
        (endDate.getMonth() - startDate.getMonth());

    if (diffMonths > maxMonths) {
        Swal.fire({
            title: 'Warning',
            text: "You cannot select a date range longer than 2 years.",
            icon: 'warning',
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-danger'
            }
        });
        return;
    } 
    // Load all dashboard components with date range
    loadProductCategories(dateRange);
    loadProductCategoriesSale(dateRange);
    loadTopRetailCustomers(dateRange);
    loadRetailCustomersAndFranchiseBalances(dateRange);
    loadRetailCustomerAndFranchisePayables(dateRange);
    retail_revenue(dateRange);
    top_product_sales_perc(dateRange);
    getMonthlyRetailPaymentSummary(dateRange);
    purchaseGrnDashboard(dateRange);
    getting_revenue_income_cogs(dateRange);
}

// Optional: Helper function to get all months between two dates
function getAllMonthsInRange(startMonth, endMonth, year) {
    const months = [];
    let currentMonth = parseInt(startMonth);
    const targetMonth = parseInt(endMonth);
    
    while (true) {
        months.push(currentMonth.toString().padStart(2, '0'));
        if (currentMonth === targetMonth) break;
        currentMonth++;
        if (currentMonth > 12) {
            currentMonth = 1;
            // If we cross December, break to avoid infinite loop
            if (targetMonth < startMonth) {
                // Handle year crossover
                break;
            }
        }
    }
    
    return months;
}

function loadProductCategories(dateRange =null) {
    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/product_categories_stock_status',
        type: 'GET',
        dataType: 'json',
        data:{
            business_id: $("#business_id").val()
        },
        success: function(response) {
            if (!response.success || !response.data || response.data.length === 0) {
                $('#product-categories-table tbody').html(`
                    <tr>
                        <td colspan="15" class="text-center py-4 text-muted">
                            No category data found
                        </td>
                    </tr>
                `);
                return;
            }

            let tbody = '';
            let total = {
                product_count: 0,
                addition_qty: 0,
                purchased_qty: 0,
                transfer_in_qty: 0,
                transfer_out_qty: 0,
                sold_qty: 0,
                used_qty: 0,
                returned_qty: 0,
                instock: 0,
                total_stock_value: 0,
                footer_stock_value_perc: 0,
                footr_stock_perc: 0,
            };

            response.data.forEach(row => {
                let stockQtyPerc = row.stock_qty_percentage ?? 0;
                let stockValuePerc = row.stock_value_percentage ?? 0;

                // Badge color
                let stockBadge = '';
           

                // Accumulate totals
                total.product_count       += parseInt(row.product_count) || 0;
                total.addition_qty        += parseFloat(row.addition_qty) || 0;
                total.purchased_qty       += parseFloat(row.purchased_qty) || 0;
                total.transfer_in_qty     += parseFloat(row.transfer_in_qty) || 0;
                total.transfer_out_qty    += parseFloat(row.transfer_out_qty) || 0;
                total.sold_qty            += parseFloat(row.sold_qty) || 0;
                total.used_qty            += parseFloat(row.used_qty) || 0;
                total.returned_qty        += parseFloat(row.returned_qty) || 0;
                total.instock             += parseFloat(row.instock) || 0;
                total.total_stock_value   += parseFloat(row.total_stock_value) || 0;
                total.footer_stock_value_perc   += parseFloat(stockQtyPerc) || 0;
                total.footr_stock_perc   += parseFloat(stockValuePerc) || 0;
                tbody += `
                    <tr>
                        <td class="d-none">${row.business_name}</td>
                        <td>${row.store}</td>
                        <td><strong>${row.category}</strong></td>
                        <td class="text-center">${row.product_count}</td>
                        <td class="text-end">${parseFloat(row.instock).toFixed(2)}</td>
                        <td class="text-center">
                            ${parseFloat(stockQtyPerc).toFixed(2)}%
                        </td>
                        <td class="text-end">${parseFloat(row.total_stock_value).toLocaleString()}</td>
                        <td class="text-center">
                            ${parseFloat(stockValuePerc).toFixed(2)}%
                        </td>
                    </tr>
                `;
            });

            $('#product-categories-table tbody').html(tbody);
            // Update footer totals
            $('#ft_product_count').text(total.product_count);
            $('#ft_addition_qty').text(total.addition_qty.toFixed(2));
            $('#ft_purchased_qty').text(total.purchased_qty.toFixed(2));
            $('#ft_transfer_in_qty').text(total.transfer_in_qty.toFixed(2));
            $('#ft_transfer_out_qty').text(total.transfer_out_qty.toFixed(2));
            $('#ft_sold_qty').text(total.sold_qty.toFixed(2));
            $('#ft_used_qty').text(total.used_qty.toFixed(2));
            $('#ft_returned_qty').text(total.returned_qty.toFixed(2));
            $('#ft_instock').text(total.instock.toFixed(2));
            $('#ft_stock_value').text(total.total_stock_value.toLocaleString());
            $('#footr_stock_perc').text(total.footr_stock_perc.toFixed(0));
            $('#footer_stock_value_perc').text(total.footer_stock_value_perc.toFixed(0));

            $("#product_stock_category_status_last_updated_at").text(response.lastUpdatedAt);
        },
        error: function(xhr, status, error) {
            console.error('Dashboard API Error:', error);
        }
    });
}

function loadProductCategoriesSale(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        
    params.business_id = $("#business_id").val();
    spin_loader('#top_categories');    
    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/product_categories_sales_perc',
        type: 'GET',
        dataType: 'json',
        data: params,
        success: function(response) {
             remover_spin_loader('#top_categories');
              $('#top_categories').empty();
            if (response.success && response.data.length > 0) {

                var filteredData = response.data.filter(function(item) {
                    return parseFloat(item.total_sale_qty) > 0;
                });
                if (filteredData.length > 0) {
                    var total_qty_for_perc_calculation = 0;
                    filteredData.forEach(function(item) {
                        total_qty_for_perc_calculation += parseFloat(item.total_sale_qty);
                    });
                    $('#top-categories-date-range').text(response.from+'  → '+response.to);
                    const mData = filteredData.map(f => ({
                            name: f.category,        // API returns `name`
                            x: f.total_sale_qty || 0,  // actual sale value
                            y: parseFloat(parseFloat((f.total_sale_qty / total_qty_for_perc_calculation) * 100)) || 0   
                        }));
                     draw_top_categories(mData, total_qty_for_perc_calculation);
                } 
            }else {
                $('#top_categories').html('<div class="col-12 text-center text-muted py-4">No category sales data available</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Dashboard API Error:', error);
        
        }
    });
}

function loadTopRetailCustomers(dateRange = null) {
    // Prevent multiple calls
    if (customersChartLoaded) {
        console.log('Customers chart already loaded, skipping...');
        return;
    }

     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
    params.business_id = $("#business_id").val();    
    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/getting_top_retail_customers',
        type: 'GET',
        timeout: 10000,
        data: params,
        success: function(data) {
            if (!data || !data.data || data.data.length === 0) {
                if (dataVisitsChart) {
                    dataVisitsChart.updateSeries([{ data: [] }]);
                }
                $('#customer-legend').html('<div class="col-12 text-center text-muted py-4">No customer data available</div>');
                return;
            }

            const customers = data.data;

                var html=``;
                customers.forEach(function(cust) {
                    const customerUrl = '{{ url("open_customer_account") }}/' + cust.customer_id;
                    html+=`<tr>
                        <td><a href="${customerUrl}" target="_blank"> ${cust.customer_name}</a></td>
                        <td>${cust.customer_cell}</td>
                        <td>${formatCurrency(cust.total_sales)}</td>
                        <td class='text-end'>${formatCurrency(cust.receivable_balance)}</td>
                     </tr>`;
                });

                $("#top_customers tbody").html(html);
                $('#top_customers_date_range').text(data.from+'  → '+data.to);
            
        },
        error: function(xhr, status, error) {
            console.error('Error loading retail customers:', error, xhr.responseText);
        }
    });
}
 
function loadRetailCustomersAndFranchiseBalances(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
        params.business_id = $("#business_id").val();

        $("#retailCustomerReceivable").text('');
        $("#retailCustomerReceivable-progress").text('');
        $("#retailCustomerReceivable-details").text('');
        $("#retailCustomerReceivable-badge").text('');

        spin_loader('#retailCustomerReceivable');
        
    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/getRetailCustomerAndFranchiseBalances',
        type: 'GET',
        dataType: 'json',
        data: params,
        success: function(response) {
                remover_spin_loader('#retailCustomerReceivable')
            if (!response.success) return;
                const data = response.data;

                const retail = data.retail;
                const franchise = data.franchise;

            /* =====================================================
               RETAIL CUSTOMER & FRANCHISE COMBINED
            ===================================================== */

            var total_receivable_combined = parseFloat((retail.total_receivable || 0)) + parseFloat((franchise.total_receivable || 0));
            var total_received_combined = parseFloat((retail.total_received || 0))   + parseFloat((franchise.total_received || 0));

            var  combined_balance = parseFloat(total_receivable_combined) -   parseFloat(total_received_combined); 
            const combinedPaidPerc = total_receivable_combined ? (total_received_combined / total_receivable_combined) * 100 : 0;


            $('#retailCustomerReceivable')
                .text(formatCurrency(combined_balance));

            // Badge
            setBadge(
                '#retailCustomerReceivable-badge',
                combinedPaidPerc,"Received"
            );

            // Details
            $('#retailCustomerReceivable-details').html(
                `Total: ${formatCurrency(total_receivable_combined,'No')} | ` +
                `Rcvd: ${formatCurrency(total_received_combined,'No')}`
            );

            // Progress bar
            setProgress(
                '#retailCustomerReceivable-progress',
                combinedPaidPerc
            );

            // $('.retail-customer-receivbles-date-range-current-month')
            //     .text(`${data.from}  →  ${data.to}`);
            $('.retail-customer-receivbles-date-range-current-month')
                .text(`As On → ${data.to}`);

            /* =====================================================
               RETAIL CUSTOMER
            ===================================================== */
 

            const retailReceivable = retail.total_receivable || 0;
            const retailReceived   = retail.total_received || 0;
            const retailPending    = Math.max(retailReceivable - retailReceived, 0);

            const retailPaidPerc = retailReceivable
                ? (retailReceived / retailReceivable) * 100
                : 0;

            // Main amount (Pending / Outstanding)
            // $('#retailCustomerReceivable')
            //     .text(formatCurrency(retailPending));

            // Badge
            // setBadge(
            //     '#retailCustomerReceivable-badge',
            //     retailPaidPerc,"Received"
            // );

            // Details
            // $('#retailCustomerReceivable-details').html(
            //     `Total: ${formatCurrency(retailReceivable,'No')} | ` +
            //     `Rcvd: ${formatCurrency(retailReceived,'No')}`
            // );

            // Progress bar
            // setProgress(
            //     '#retailCustomerReceivable-progress',
            //     retailPaidPerc
            // );

            // $('.retail-customer-receivbles-date-range-current-month')
            //     .text(`${data.from}  →  ${data.to}`);

            /* =====================================================
               FRANCHISE
            ===================================================== */
        
            const franReceivable = franchise.total_receivable || 0;
            const franReceived   = franchise.total_received || 0;
            const franPending    = Math.max(franReceivable - franReceived, 0);

            const franPaidPerc = franReceivable
                ? (franReceived / franReceivable) * 100
                : 0;

            $('#franchiseReceivable')
                .text(formatCurrency(franPending));

            setBadge(
                '#franchiseReceivable-badge',
                franPaidPerc,"Received"
            );

            $('#franchiseReceivable-details').html(
                `Total: ${formatCurrency(franReceivable,'No')} | ` +
                `Rcvd: ${formatCurrency(franReceived,'No')}`
            );

            setProgress(
                '#franchiseReceivable-progress',
                franPaidPerc
            );

            $('.franchise-receivbles-date-range-current-month')
                .text(`${data.from} - ${data.to}`);
        },

        error: function() {
            console.error('Dashboard API Error');
        }
    });
}

function setBadge(selector, percent ,paid_labael) {
    let cls = 'bg-success';

    if (percent < 50) cls = 'bg-danger';
    else if (percent < 80) cls = 'bg-warning';

    $(selector)
        .removeClass('bg-success bg-warning bg-danger')
        .addClass(cls)
        .text(`${Math.round(percent)}% ${paid_labael}`);
}

function setProgress(selector, percent) {
    $(selector)
        .css('width', Math.min(percent, 100) + '%')
        .removeClass('bg-success bg-warning bg-danger')
        .addClass(
            percent > 80 ? 'bg-success' :
            percent > 50 ? 'bg-warning' : 'bg-danger'
        );
}

function loadRetailCustomerAndFranchisePayables(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        } 
        params.business_id = $("#business_id").val();
    $("#retailCustomerPayable").text('');
    $("#retailCustomerPayable-progresss").text('');
    $("#retailCustomerPayable-details").text('');
    $("#retailCustomerPayable-badge").text('');  
    
    spin_loader('#retailCustomerPayable');

    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/getRetailCustomerPayableAndFranchisePayable',
        type: 'GET',
        dataType: 'json',
        data: params,
        success: function(response) {
            remover_spin_loader('#retailCustomerPayable')
            if (!response.success) return;
            const data = response.data;

            const retail = data.retail;
            const franchise = data.franchise;
            /* =====================================================
               RETAIL PAYABLE & FRANCHISE PAYABLE
            ===================================================== */

            var retailAndFranchisePayable = parseFloat(retail.total_payable || 0) +  parseFloat(franchise.total_payable || 0);
            var retailAndFranchisePaid = parseFloat(retail.total_paid || 0) +  parseFloat(franchise.total_paid || 0);
            var retailAndFranchiseBalance =parseFloat(retailAndFranchisePayable) - parseFloat(retailAndFranchisePaid);

            const retailAndFranchiseCombinedPaidPerc = retailAndFranchisePayable
                ? (retailAndFranchisePaid / retailAndFranchisePayable) * 100
                : 0;

            $('#retailCustomerPayable')
            .text(formatCurrency(retailAndFranchiseBalance));

            setBadge('#retailCustomerPayable-badge', retailAndFranchiseCombinedPaidPerc,'Paid');

            $('#retailCustomerPayable-details').html(
                `Total: ${formatCurrency(retailAndFranchisePayable,'No')} | ` +
                `Paid: ${formatCurrency(retailAndFranchisePaid,'No')}`
            );

            setProgress('#retailCustomerPayable-progress', retailAndFranchiseCombinedPaidPerc);

            // $('.retail-customer-payables-date-range-current-month')
            //     .text(`${data.from}  →  ${data.to}`);
            $('.retail-customer-payables-date-range-current-month')
                .text(`As On → ${data.to}`);
                
            /* =====================================================
               RETAIL PAYABLE
            ===================================================== */
   

            const retailPayable = retail.total_payable || 0;
            const retailPaid    = retail.total_paid || 0;
            const retailBalance = Math.max(retailPayable - retailPaid, 0);

            const retailPaidPerc = retailPayable
                ? (retailPaid / retailPayable) * 100
                : 0;

            // $('#retailCustomerPayable')
            //     .text(formatCurrency(retailBalance));

            // setBadge('#retailCustomerPayable-badge', retailPaidPerc,'Paid');

            // $('#retailCustomerPayable-details').html(
            //     `Total: ${formatCurrency(retailPayable,'No')} | ` +
            //     `Paid: ${formatCurrency(retailPaid,'No')}`
            // );

            // setProgress('#retailCustomerPayable-progress', retailPaidPerc);

            // $('.retail-customer-payables-date-range-current-month')
            //     .text(`${data.from}  →  ${data.to}`);

            /* =====================================================
               FRANCHISE PAYABLE
            ===================================================== */

            const franPayable = franchise.total_payable || 0;
            const franPaid    = franchise.total_paid || 0;
            const franBalance = Math.max(franPayable - franPaid, 0);

            const franPaidPerc = franPayable
                ? (franPaid / franPayable) * 100
                : 0;

            $('#franchisePayable')
                .text(formatCurrency(franBalance));

            setBadge('#franchisePayable-badge', franPaidPerc,'Paid');

            $('#franchisePayable-details').html(
                `Total: ${formatCurrency(franPayable,'No')} | ` +
                `Paid: ${formatCurrency(franPaid,'No')}`
            );

            setProgress('#franchisePayable-progress', franPaidPerc);

            $('.franchise-payables-date-range-current-month')
                .text(`${data.from} - ${data.to}`);
        },
        error: function () {
            console.error('Payables Dashboard API Error');
        }
    });
}


function formatCurrency(amount,currency='Yes') {
    const currencySymbol = currency =='Yes' ?  window.CURRENCY_SYMBOL || '$' : '';
    // Convert to number, handling null, undefined, strings, etc.
    const numAmount = parseFloat(amount) || 0;
    if (Math.abs(numAmount) >= 1000000) {
        return currencySymbol + (numAmount / 1000000).toFixed(2) + 'M';
    } else if (Math.abs(numAmount) >= 1000) {
        return currencySymbol + (numAmount / 1000).toFixed(1) + 'K';
    }
    return currencySymbol + numAmount.toFixed(2);
}

function draw_top_categories(mData, total) {
    // Sort descending by value
    mData.sort(function (a, b) {
        return b.x - a.x;
    });

    // Take top 5
    let top5Data = mData.slice(0, 5);

    // Labels and series
    let series = top5Data.map(item => item.x); 
    let labels = top5Data.map(item => item.name);

    // Colors
    var colors = ["#5b69bc", "#35b8e0","#10c469", "#fa5c7c","#e3eaef"];
    var dataColors = $("#top_categories").data('colors');
    if (dataColors) {
        colors = dataColors.split(",");
    }

    // Destroy previous chart if exists
    if (window.grossingServicesChart) {
        window.grossingServicesChart.destroy();
    }

    // ApexCharts options
    var options = {
        chart: {
            height: 380,
            type: 'pie',
            toolbar: { show: true }
        },
        series: series,
        labels: labels,
        colors: colors,
        tooltip: {
            y: {
                formatter: function(val, opts) {
                    let index = opts.seriesIndex;
                    return ' Sales Qty : '+val;
                }
            }
        },
        legend: {
            position: 'bottom'
        },
     
        dataLabels: {
            enabled: true,
            formatter: function(val, opts) {
                return labels[opts.seriesIndex] + ': ' + val.toFixed(1) + '%';
            }
        }
    };

    window.grossingServicesChart = new ApexCharts(document.querySelector("#top_categories"), options);
    window.grossingServicesChart.render();
} 

function retail_revenue(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
    params.business_id = $("#business_id").val();
    $("#retail-revenue-value").text('');
    $("#retail-revenue-change").text('');
    $("#retail-revenue-badge").text('');
    $("#retail-revenue-progress").text('');    
    
    spin_loader('#retail-revenue-value');

    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/retail_revenue',
        type: 'GET',
        data: params,
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                remover_spin_loader('#retail-revenue-value');
                const data = response.data;
                
                // Current and last month retail balances
                const current =  data.current_month.total || 0;
                const last = data.last_month.total || 0;

                // Percentage change
                let change = data.percentage_change || 0;
                const changeText = change > 0 ? `+${change}%` : `${change}%`;

                // Update DOM
                $('.retail-date-range').text(`${response.from || 'Current Month'}  →  ${response.to || 'Current Month'}`);
                $('#retail-revenue-value').text(formatCurrency(current));
                var previous_period =   `${response.previous_from} → ${response.previous_to}`; 
                if(response.previous_from == response.previous_to){
                    previous_period =response.previous_to;
                }

                $('#retail-revenue-change').text(`${previous_period} (${changeText})`);
                $('#retail-revenue-badge').html(`${changeText} <i class="ti ti-trending-${change >= 0 ? 'up' : 'down'}"></i>`);
                $('#retail-revenue-progress').css('width', Math.min(Math.abs(change), 100) + '%');
                $('#retail-revenue-progress').attr('aria-valuenow', Math.min(Math.abs(change), 100));

            }
        },
        error: function(err) {
            console.error('Error fetching retail revenue', err);
        }
    });
}

function top_product_sales_perc(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
    params.business_id = $("#business_id").val();
    spin_loader('#rotate-labels-column');     
    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/top_product_sales_perc',
        type: 'GET',
        data: params,
        dataType: 'json',
        success: function (response) {
            remover_spin_loader('#rotate-labels-column');
            $("#topProductsSecionLoadaer").remove();
            $("#rotate-labels-column").empty();
            if (!response.success) return;
            let categories = [];
            let seriesData = [];

            response.data.forEach(item => {
                 let productName = item.product;
                if (productName.length > 15) {
                    productName = productName.substring(0, 12) + '...';
                }
                categories.push(productName);

                seriesData.push(parseInt(item.total_sale_qty));
            });
            $('#top-product-date-range').text(response.from + ' → ' + response.to);

            renderTopProductsChart(categories, seriesData);
        },
        error: function (err) {
            console.error('Error fetching top products', err);
        }
    });
}

function renderTopProductsChart(categories, seriesData) {

    var colors = ["#fa5c7c", "#10c469", "#39afd1", "#ffc35a", "#5b69bc"];

    var options = {
        chart: {
            height: 380,
            type: 'bar',
            toolbar: { show: true }
        },

        plotOptions: {
            bar: {
                columnWidth: '50%', 
                distributed: true,
            }
        },
        colors: colors, 
        series: [{
            name: 'Total Sale Qty',
            data: seriesData

        }],

        dataLabels: {
            enabled: false
        },

        xaxis: {
            categories: categories,
            labels: {
                show: false  
            }
        },
        yaxis: {
            title: {
                text: 'Quantity Sold'
            }
        },

        grid: {
            borderColor: '#f1f3fa'
        }
    };

    if (rotateLabelsChart) {
        rotateLabelsChart.destroy();
    }

    rotateLabelsChart = new ApexCharts(
        document.querySelector("#rotate-labels-column"),
        options
    );
    
    rotateLabelsChart.render();
}

function getMonthlyRetailPaymentSummary(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
    params.business_id = $("#business_id").val();   
    $("#basic-bar").empty();
    spin_loader('#basic-bar');      
    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/getMonthlyRetailPaymentSummary',
        type: 'GET',
        data: params,
        dataType: 'json',
        success: function (response) {
            remover_spin_loader('#basic-bar');
            $("#basic-bar").empty();
            if(response.success) {
                let data = response.data;

                // Display selected date range
                $('#basic-bar-date-range').text(response.from + ' → ' + response.to);

                // Categories (payment types)
                let categories = ['Cash', 'Bank', 'Card', 'Online'];

                // Data array
                let seriesData = [
                    data.cash_debit,
                    data.bank_debit,
                    data.card_debit,
                    data.online_debit
                ];

                // Multiple colors for each bar
                let colors = ["#39afd1", "#10c469", "#fa5c7c", "#ffc107"]; // Cash, Bank, Card, Online

                // ApexCharts options
                let options = {
                    chart: {
                        height: 380,
                        type: 'bar',
                        toolbar: { show: true }
                    },
                    plotOptions: {
                        bar: {
                                horizontal: true,
                                distributed: true,
                            }
                    },
                    dataLabels: { enabled: false },
                    series: [{
                        data: seriesData
                    }],
                    colors: colors,
                    xaxis: {
                        categories: categories,
                        axisBorder: { show: false }
                    },
                    states: {
                        hover: { filter: 'none' }
                    },
                    grid: { borderColor: '#f1f3fa' }
                };

                // Render chart
                let chartEl = document.querySelector("#basic-bar");
                chartEl.innerHTML = ""; // clear previous chart
                let chart = new ApexCharts(chartEl, options);
                chart.render();
            } else {
                console.error("No data available or API returned false.");
            }
        },
        error: function (err) {
            console.error('Error fetching monthly retail payment summary', err);
        }
    });
}

function purchaseGrnDashboard(dateRange = null) {
     let params = {};
        if (dateRange) {
            params = { from: dateRange.start, to: dateRange.end };
        }
    params.business_id = $("#business_id").val();    
    $("#purchase-grn-main").text('');
    $("#purchase-grn-progress").text('');
    $("#purchase-grn-badge").text('');
    $("#purchase-grn-sub").text('');  

    spin_loader('#purchase-grn-main');

    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/purchase_order_and_grn_detail',
        type: 'GET',
        data: params,
        dataType: 'json',
        success: function (res) {
            remover_spin_loader('#purchase-grn-main')
            if (!res.success) return;

            const data = res.data;

            function render(mode = 'amount') {

                let purchase = 0, grn = 0, returned = 0;

                if (mode === 'qty') {
                    purchase = Number(data.purchase_qty || 0);
                    grn      = Number(data.total_grn_qty || 0) - Number(data.total_return_qty || 0);
                    returned = Number(data.total_return_qty || 0);
                } else {
                    purchase = Number(data.total_purchase_amount || 0);
                    grn      = Number(data.total_grn_amount || 0) - Number(data.total_return_amount || 0);
                    returned = Number(data.total_return_amount || 0);
                }

                const netReceived = Math.max(grn, 0);
                const percent = purchase > 0 ? (netReceived / purchase) * 100 : 0;


                var balance  = purchase - netReceived;

                // Main value
                $('#purchase-grn-main').text(
                    mode === 'qty'
                        ? balance.toFixed(2)
                        : formatCurrency(balance)
                );
                
                // Sub info
                $('#purchase-grn-sub').html(
                    `PO: ${mode === 'qty' ? purchase : formatCurrency(purchase,'No')} | ` +
                    `GRN: ${mode === 'qty' ? grn : formatCurrency(grn,'No')}`
                );

                // Badge + Progress
                setBadge('#purchase-grn-badge', percent, 'Received');
                setProgress('#purchase-grn-progress', percent);

                // Date range
                $('.purchase-grn-date').text(`${res.from} → ${res.to}`);
            }
            // Initial load
            render('qty');
            // Toggle (Amount / Quantity)
            $('#purchase-grn-mode').off('change').on('change', function () {
                render(this.value);
            });
        }
    });
}

// ===============================
// Revenue / COGS / Net Profit Chart
// ===============================

function getting_revenue_income_cogs(dateRange = null) {

    let params = {};
    if (dateRange) {
        params = { from: dateRange.start, to: dateRange.end };
    }
    params.business_id = $("#business_id").val();
    $("#revenue-cogs-chart").html(``);
    spin_loader("#revenue-cogs-chart");

    $.ajax({
        url: baseURL + '/dashboard/retaildashboard/getting_revenue_income_cogs',
        type: 'GET',
        data: params,
        success: function (res) {
            remover_spin_loader("#revenue-cogs-chart");
            $("#revenue-cogs-chart").empty();
            $('#revenue-cogs-chart-loader').remove();

            if (!res.success || !res.data.length) {
                return;
            }

            $('.revenue-cogs-chart-date-range').text(`${res.from} → ${res.to}`);
            const dates = [];
            const revenue = [];
            const cogs = [];
            const profit = [];

            res.data.forEach(row => {
                dates.push(row.voucher_date);
                revenue.push(+row.total_sales);
                cogs.push(+row.cogs_balance);
                profit.push(+row.net_profit);
            });

            // ---------- Y Axis Ranges ----------
            const maxVal = Math.max(...revenue, ...cogs, ...profit);
            const padding = parseFloat(parseFloat(maxVal * 0.1).toFixed(2)); 
            // ---------- CREATE / UPDATE CHART ----------
            if (true) {
                revenueCogsChart = new ApexCharts(
                    document.querySelector("#revenue-cogs-chart"),
                    {
                        chart: {
                            type: 'line',
                            height: 340,
                            toolbar: { show: true },
                            fontFamily: 'Inter, Arial, sans-serif',
                            dropShadow: {
                                enabled: true,
                                top: 3,
                                left: 2,
                                blur: 6,
                                opacity: 0.15
                            },
                            animations: {
                                enabled: true,
                                easing: 'easeinout',
                                speed: 900
                            }
                        },

                        series: [
                            { name: 'Revenue', data: revenue },
                            { name: 'COGS', data: cogs },
                            { name: 'Net Profit', data: profit }
                        ],

                        stroke: {
                            width: [3, 3, 3],
                            curve: 'smooth'
                        },

                        colors: ['#28a745', '#dc3545', '#0d6efd'],

                        markers: {
                            size: 5,
                            strokeWidth: 2,
                            hover: { size: 7 }
                        },

                        grid: {
                            borderColor: '#e9ecef',
                            strokeDashArray: 4
                        },

                        xaxis: {
                            categories: dates,
                            tickPlacement: 'on',
                            labels: {
                                rotate: -45,
                                rotateAlways: true,
                                style: {
                                    fontSize: '11px',
                                    fontWeight: 500,
                                    colors: '#6c757d'
                                }
                            },
                            axisBorder: { show: false },
                            axisTicks: { show: false }
                        },

                        yaxis: {
                            min: 0,
                            max: maxVal + padding,
                            labels: {
                                formatter: val => formatCurrency(val),
                                style: {
                                    fontSize: '11px',
                                    colors: '#6c757d'
                                }
                            }
                        },

                        tooltip: {
                            shared: true,
                            intersect: false,
                            theme: 'light',
                            y: {
                                formatter: val => formatCurrency(val)
                            }
                        },

                        legend: {
                            position: 'bottom',
                            fontSize: '11px',
                            markers: {
                                width: 10,
                                height: 10,
                                radius: 10
                            }
                        }
                    }
                );

                revenueCogsChart.render();


            }
        },
        error: function (err) {
          $("#revenue-cogs-chart").empty();
          $('#revenue-cogs-chart-loader').remove();
        }
    });
}

function spin_loader(id){
    $(id).closest('.card-body').find('.centerDivForLoader').html(`<div class="spinner-grow text-primary m-2" role="status"></div></div>`);
}
function remover_spin_loader(id){
    $(id).closest('.card-body').find('.centerDivForLoader').html(``);
}
</script>
@endsection