{{-- 
    TEMPORARY DEBUG FILE - Add this to any page to debug icon issues
    Include this in your layout or add to a test page:
    @include('debug-icons')
--}}
<script>
(function() {
    console.log('=== ICON DEBUGGING START ===');
    
    // 1. Check if fonts are loaded
    document.fonts.ready.then(() => {
        console.log('Total fonts loaded:', document.fonts.size);
        
        const tablerLoaded = document.fonts.check('16px tabler-icons');
        const remixLoaded = document.fonts.check('16px remixicon');
        
        console.log('Tabler Icons loaded:', tablerLoaded);
        console.log('Remix Icons loaded:', remixLoaded);
        
        if (!tablerLoaded || !remixLoaded) {
            console.error('❌ Icon fonts NOT loaded!');
        } else {
            console.log('✅ Icon fonts loaded successfully');
        }
    });
    
    // 2. Check all @font-face rules in stylesheets
    console.log('\n=== FONT-FACE DECLARATIONS ===');
    const styleSheets = Array.from(document.styleSheets);
    let fontFaceCount = 0;
    
    styleSheets.forEach((sheet, index) => {
        try {
            const rules = Array.from(sheet.cssRules || []);
            rules.forEach(rule => {
                if (rule instanceof CSSFontFaceRule) {
                    fontFaceCount++;
                    const fontFamily = rule.style.fontFamily;
                    const src = rule.style.src;
                    console.log(`Font ${fontFaceCount}:`, {
                        family: fontFamily,
                        src: src,
                        stylesheet: sheet.href || 'inline'
                    });
                    
                    // Extract URLs from src
                    const urlMatch = src.match(/url\(['"]?([^'"]+)['"]?\)/g);
                    if (urlMatch) {
                        urlMatch.forEach(url => {
                            const cleanUrl = url.replace(/url\(['"]?|['"]?\)/g, '');
                            console.log('  → Font URL:', cleanUrl);
                            
                            // Test if URL is accessible
                            fetch(cleanUrl, { method: 'HEAD' })
                                .then(response => {
                                    if (response.ok) {
                                        console.log('  ✅ Font file accessible:', cleanUrl);
                                    } else {
                                        console.error('  ❌ Font file NOT accessible:', cleanUrl, 'Status:', response.status);
                                    }
                                })
                                .catch(error => {
                                    console.error('  ❌ Font file fetch error:', cleanUrl, error);
                                });
                        });
                    }
                }
            });
        } catch(e) {
            // Cross-origin stylesheet, skip
            if (e.message.includes('cross-origin')) {
                console.log(`Stylesheet ${index}: Cross-origin, skipping`);
            }
        }
    });
    
    if (fontFaceCount === 0) {
        console.error('❌ No @font-face rules found!');
    }
    
    // 3. Check icon elements
    console.log('\n=== ICON ELEMENTS CHECK ===');
    const tablerIcons = document.querySelectorAll('.ti, [class*="ti-"]');
    const remixIcons = document.querySelectorAll('.ri, [class*="ri-"]');
    
    console.log('Tabler icon elements found:', tablerIcons.length);
    console.log('Remix icon elements found:', remixIcons.length);
    
    if (tablerIcons.length > 0) {
        const firstIcon = tablerIcons[0];
        const computed = window.getComputedStyle(firstIcon);
        console.log('First Tabler icon:', {
            element: firstIcon,
            fontFamily: computed.fontFamily,
            content: computed.content,
            display: computed.display
        });
    }
    
    if (remixIcons.length > 0) {
        const firstIcon = remixIcons[0];
        const computed = window.getComputedStyle(firstIcon);
        console.log('First Remix icon:', {
            element: firstIcon,
            fontFamily: computed.fontFamily,
            content: computed.content,
            display: computed.display
        });
    }
    
    // 4. Check network requests for fonts
    console.log('\n=== NETWORK CHECK ===');
    console.log('Open Network tab and filter by "Font" to see font requests');
    console.log('Look for 404 errors on .woff2, .woff, or .ttf files');
    
    // 5. Check Vite manifest if available
    fetch('/build/.vite/manifest.json')
        .then(response => response.json())
        .then(manifest => {
            console.log('\n=== VITE MANIFEST ===');
            const iconEntries = Object.entries(manifest).filter(([key, value]) => 
                key.includes('icons') || key.includes('font')
            );
            if (iconEntries.length > 0) {
                console.log('Icon-related entries:', iconEntries);
            } else {
                console.log('No icon-related entries in manifest');
            }
        })
        .catch(error => {
            console.log('Could not load Vite manifest (this is OK if not using Vite dev server)');
        });
    
    console.log('\n=== ICON DEBUGGING END ===');
    console.log('Check the Network tab for failed font requests');
    console.log('Check the Console for any 404 errors');
})();
</script>
