@extends('layouts.base', ['title' => 'Error 403'])

@section('body_attribute')
class="h-100"
@endsection

@section('content')

<div class="auth-bg d-flex min-vh-100">
    <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
        <div class="col-xxl-3 col-lg-5 col-md-6">
            <a href="{{ route('any', ['index'])}}" class="auth-brand d-flex justify-content-center mb-2">
                <img src="{{ asset('images/logo-dark.png') }}" alt="dark logo" height="26" class="logo-dark">
                <img src="{{ asset('images/logo.png') }}" alt="logo light" height="26" class="logo-light">
            </a>

            <p class="fw-semibold mb-4 text-center text-muted fs-15">Your End-To-End Business Management System.</p>

            <div class="card overflow-hidden text-center p-xxl-4 p-3 mb-0">

                <div class="text-center">
                    <h1 class="text-error">403</h1>
                    <h3 class="mt-3 mb-2">Access Denied !</h3>
                    <p class="text-muted mb-3">{{ $message ??  'You are not authorized to view this page. If you think this is a mistake, please contact support for assistance.'}} </p>

                    <div class="d-flex gap-2 justify-content-center flex-wrap">
                        <a href="{{ url()->previous() !== request()->fullUrl() ? url()->previous() : route('home') }}" class="btn btn-primary">
                            <i class="ti ti-arrow-left fs-16 me-1"></i> Back
                        </a>
                        
                        @auth
                        <a href="/logout" class="btn btn-danger">
                            <i class="ti ti-logout fs-16 me-1"></i> Logout
                        </a>
                        @else
                        <a href="{{ route('login') }}" class="btn btn-danger">
                            <i class="ti ti-login fs-16 me-1"></i> Login
                        </a>
                        @endauth
                    </div>
                </div>

            </div>
            <p class="mt-4 text-center mb-0">
                <script>
                    document.write(new Date().getFullYear())
                </script> © SkedWise - By <span
                    class="fw-bold text-decoration-underline text-uppercase text-reset fs-12">Mexyon</span>
            </p>
        </div>
    </div>
</div>

@endsection

@section('scripts')

@endsection