@extends('layouts.horizontal', ['title' => 'Daily Expenses', 'topbarTitle' => 'Daily Expenses'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     tr.border-top > td {border-top: 2px solid #000 !important;}
    tr.border-bottom > td {border-bottom: 2px solid #000 !important;}
    tr.no-dt-row { background-color: #f9f9f9; font-weight: bold; }  
</style>

<div class="daily-expenses-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Daily Expenses</h2>
                <div class="page-title-right">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    @if(session('user_role') == 'Super User' || session('user_role') == 'Super Admin')
        @if(session('ho')=="Yes")
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title">
                            Filter Expenses
                        </div>
                        <form id="expensesform" method="GET" action="{{ route('daily_expenses') }}">
                            <div class="row">                                            
                                <div class="col-md-3">
                                    <label class="form-label" for="branch_id">Select  Branch</label>
                                    <select id="branch_id" name="business_id" class="form-select">
                                        @foreach($branches as $branch)
                                            <option value="{{ $branch->id_business }}" @if($branch->id_business == $business->id_business) selected @endif>{{ $branch->business_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" for="date">Select Date</label>
                                    <input type="date" id="date" name="date" class="form-control" value="{{ $mDate }}">
                                </div>
                                <div class="col-md-3">
                                    <button id="btn_refresh_table" type="submit" class="btn btn-ghost-primary flex-shrink-0 rounded-circle btn-icon mt-3" >
                                        <i class="ti ti-refresh fs-20"></i>
                                    </button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>  
            </div>            
        </div> <!-- end row-->
        @endif
    @endif

    <div id="new_expense_container" class="row d-none">
        <div class="col-12">
            <div class="card">                
                
                <div class="card-body">
                    <div class="card-title  mb-4">
                        <h5>Add New Expense</h5>
                        <small class="text-muted">Keep saving the Expenses. Once done refresh the page to see the updated list.</small>
                    </div>
                    <form id="new_expense_form" class="form">
                        <input type="hidden" name="business_id" value="{{ $business->id_business }}">
                        <div class="row g-3">                            
                            <div class="col-md-2">
                                <label class="form-label" for="voucher_date">Select Date</label>
                                <input type="date" {{ session('user_role')=='Reception' ? "disabled" : "" }} id="voucher_date" name="voucher_date" class="form-control" value="{{ date('Y-m-d') }}">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label" for="payment_account">Select Cash Account</label>
                                <select id="payment_account" name="payment_account" class="form-select select2">
                                    @foreach($cashAccounts as $head)
                                        <option value="{{ $head->id_account_heads }}">{{ $head->account_head }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3  border-end">
                                <label class="form-label" for="expense_account">Select Expense Account</label>
                                <select id="expense_account" name="expense_account" class="form-select select2">
                                    @foreach($expenseAccounts as $account)
                                        <option value="{{ $account->id_account_heads }}">{{ $account->account_head }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label" for="description">Narration</label>
                                <input type="text" id="description" name="description" class="form-control" placeholder="Enter description">        
                            </div>
                            <div class="col-md-2">
                                <label class="form-label" for="amount">Amount</label>
                                <input type="number" step="0.01" id="amount" name="amount" class="form-control" placeholder="0.00">
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-md-3">
                                <label for="business_partner_type" class="form-label">Business Partner Type</label>
                                <select onchange="onchange_business_partner_type()" class="form-select" id="business_partner_type" name="business_partner_type" required>
                                    <option value="" disabled selected>Select Business Partner Type</option>
                                    @foreach($business_partners as $partner)
                                        <option @if(isset($voucher) && $voucher->business_partner == $partner->id_account_business_partner) selected @endif value="{{ $partner->id_account_business_partner }}">{{ $partner->account_business_partner }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="business_partner" class="form-label">Business Partner</label>
                                <select class="form-select select2" id="business_partner" name="business_partner" placeholder="Enter Business Partner" >
                                    @if(isset($voucher))
                                        <option value="{{ $voucher->business_partner_id }}" selected>{{ $voucher->business_partner_name }}</option>
                                    @endif
                                </select>
                            </div>  
                        </div>  
                    </form>
                    <div class="card-footer">
                        <div class="float-end">
                            <button id="saveExpenseButton" onclick="saveExpense()" class="btn btn-primary">
                                <span id="saveExpenseSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span> Save</button>
                        </div>
                    </div>                      
                </div>
            </div>        
        </div>
    </div> 

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title  mb-4">
                        Daily Expenses for {{ $business->business_name }}
                        <div class="float-end">
                            <button id="add_expense_button" class="btn btn-outline-primary">Add New Expenses</button>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="daily_expenses_table" class="table table-bordered fs-13">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Category</th>
                                    <th>Sub Category</th>
                                    <th>Description</th>
                                    <th class="text-end text-danger">Cash</th>                                    
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php  $total_is_cash = 0;  @endphp
                                @foreach($expenses as $expense)
                                    @php
                                        if(str_contains($expense->account_head, 'Till')) {
                                            $total_is_cash += $expense->is_cash;
                                        }
                                    @endphp
                                    <tr class="{{ str_contains($expense->account_head, 'Till') ? 'no-dt-row' : '' }}">
                                        <td>{{ $expense->id_account_vouchers }}</td>
                                        <td>{{ \Carbon\Carbon::parse($expense->voucher_date)->format('d/m/Y') }}</td>
                                        <td>{{ $expense->account_head }}</td>
                                        <td>{{ $expense->account_sub_control }}</td>
                                        <td>{{ $expense->description }}</td>                                        
                                        <td class="text-end {{ str_contains($expense->account_head, 'Till') ? 'text-danger' : '' }}">{{ number_format($expense->is_cash, 2) }}</td>                                        
                                        <td>
                                            @if(session('user_role') == 'Super User' || session('user_role') == 'Super Admin' || session('user_role') == 'Admin')
                                                <button onclick="deleteExpense({{ $expense->id_account_vouchers }})" class="btn btn-ghost-danger rounded-circle btn-icon flex-shrink-0 btn-sm">
                                                    <i class="ti ti-trash fs-20"></i>
                                                </button>
                                            @endif
                                        </td>                                        
                                    </tr>     
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="border-top border-bottom">
                                    <th colspan="5" class="text-end">Till Cash Total</th>
                                    <th class="text-end text-danger">{{ number_format($total_is_cash, 2) }}</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    let baseURL = '{{ url("") }}'; // Use relative paths 

    document.addEventListener('DOMContentLoaded', function () {
        //Initialize select2
        $(".select2").select2();

        // Initialize DataTable
        $('#daily_expenses_table tr.border-top').addClass('no-dt-row');
        $('#daily_expenses_table').DataTable({
            "ordering": false,            
            "searching": true,
            "info": false,
            rowSelector: 'tr:not(.no-dt-row)', // this ensures DataTables skips subtotals
             "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
        });

        $('#add_expense_button').on('click', function () {
            $('#new_expense_container').removeClass('d-none');
            (this).classList.add('d-none');
        });



    });

        function onchange_business_partner_type() {
            let mURL = '';
            console.log($('#business_partner_type option:selected').text());
            if($('#business_partner_type option:selected').text() == "Customers"){
                mURL += baseURL + '/customer_search';
            } else if($('#business_partner_type option:selected').text() == "Staff"){
                mURL += baseURL + '/staff/staff_search';
            } else if($('#business_partner_type option:selected').text() == "Suppliers"){
                mURL += baseURL + '/supplier/supplier_search';
            } else if($('#business_partner_type option:selected').text() == "Franchise"){
                mURL += baseURL + '/franchise/franchise_search';
            } else {
                mURL += baseURL + '/business/business_search';
            }

            // Re-initialize Select2 with new URL
            $('#business_partner').empty(); // Clear previous selections
            initializeBusinessPartnerSelect2(mURL, $('#business_partner_type option:selected').text());
        }   

        function initializeBusinessPartnerSelect2(url, type) {
            console.log('URL chosen for Select2:', url);
            $('#business_partner').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.text };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select ' + type ,
                width: '100%'
            });
        }

        function saveExpense() {
            //Disable Save Button
            $("#saveExpenseButton").prop("disabled", true);
            $("#saveExpenseSpinner").removeClass("d-none");

            var bp_data = $('#business_partner').select2('data');

            if($("#description").val() == ''){
                //Enable Save Button
                $("#saveExpenseButton").prop("disabled", false);
                $("#saveExpenseSpinner").addClass("d-none");

                toastr.error('Please enter description in the narration field.');
                return;
            }

            if($("#amount").val() == '' || parseFloat($("#amount").val()) <= 0){
                //Enable Save Button
                $("#saveExpenseButton").prop("disabled", false);
                $("#saveExpenseSpinner").addClass("d-none");

                toastr.error('Please enter a valid amount greater than zero.');
                return;
            }

            let formData = {
                business_id: '{{ $business->id_business }}',
                voucher_date: $('#voucher_date').val(),
                payment_account: $('#payment_account').val(),
                expense_account: $('#expense_account').val(),
                description: $('#description').val(),
                amount: $('#amount').val(),                
                business_partner: $('#business_partner_type option:selected').val(),
                business_partner_id: bp_data.length > 0 ? bp_data[0].id : null,
                business_partner_name: bp_data.length > 0 ? bp_data[0].text : null,
                _token: '{{ csrf_token() }}'
            };

            $.ajax({
                url: baseURL + '/expenses/save_expense',
                type: 'POST',
                data: formData,
                success: function (response) {
                    toastr.success(response.message);
                    location.reload(); // Reload the page to see the new expense
                    //Enable Save Button
                    $("#saveExpenseButton").prop("disabled", false);
                    $("#saveExpenseSpinner").addClass("d-none");
                },
                error: function (xhr, status, error) {
                    //Enable Save Button
                    $("#saveExpenseButton").prop("disabled", false);
                    $("#saveExpenseSpinner").addClass("d-none");

                    console.error('Error saving expense:', error);
                    toastr.error('Failed to save expense.'+ xhr.responseJSON.message);
                }
            });
        }

        function deleteExpense(expenseId) {
           Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                input: 'text', // adds input box
                inputPlaceholder: 'Enter reason for deletion',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Close',
                customClass: {
                    confirmButton: 'btn btn-danger',
                    cancelButton: 'btn btn-secondary'
                },
                preConfirm: (inputValue) => {
                    if (!inputValue) {
                        Swal.showValidationMessage('Please enter a reason');
                        return false;
                    }
                    return inputValue;
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    const reason = result.value; // user input value
                    performDeleteExpense(expenseId, reason);
                }
            });

        }

        function performDeleteExpense(expenseId, reason) {
            //use fetch to cancel the account voucher
            fetch(baseURL + '/accounts/cancel_voucher', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ 
                    id_account_vouchers: expenseId ,
                    business_id: '{{ $business->id_business }}',
                    'reason': 'Deleted from Daily Expenses  UI' + (reason ? ' - ' + reason : '')
                })
            }).then(response => {
                if (response.ok) {
                    toastr.success('Expense deleted successfully.');
                    location.reload(); // Reload the page to see the updated list
                } else {
                    toastr.error('Failed to delete expense.');
                }
            }).catch(error => {
                console.error('Error deleting expense:', error);
                toastr.error('Failed to delete expense.');
            });
        }

</script>