@extends('layouts.horizontal', ['title' => 'Day Invoices List', 'topbarTitle' => 'Invoices'])

@section('css')
@vite([
    'node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
@endsection

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Day's Visitor List</h2>
                <div class="page-title-right">
                    
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div>
                            <h4 class="card-title">Visitors List for {{ date('d M Y') }}</h4>
                        </div>
                        <div class="card-actions">
                            <button class="btn btn-sm btn-outline-success" onclick="">
                                <iconify-icon icon="mdi:reload" class="me-1 fs-22"></iconify-icon>
                                Refresh
                            </button>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="day-visitors-datatable" class="table table-bordered dt-responsive nowrap w-100 fs-14">
                            <thead>
                                <tr>
                                    <th>Visit ID</th>
                                    <th>Visit Status</th>
                                    <th>Customer ID</th>
                                    <th>Customer Name</th>
                                    <th>Service Type</th>
                                    <th>Service Category</th>
                                    <th>Service</th>
                                    <th>Service Time</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($visits as $visit)
                                <tr class="{{ $visit->visit_status == 'cancelled' ? 'strike-through' : '' }}">
                                    <td style="background-color: {{ $visit->visit_color }};">{{ $visit->id_customer_visits }}</td>
                                    <td>{{ ucfirst($visit->visit_status) }}</td>
                                    <td>{{ $visit->customer_id }}</td>
                                    <td>{{ $visit->customer_name }}</td>
                                    <td>{{ $visit->s_type }}</td>
                                    <td>{{ $visit->s_category }}</td>
                                    <td>{{ $visit->service_name }}</td>
                                    <td>{{ date('h:i A', strtotime($visit->visit_service_start)) }} - {{ date('h:i A', strtotime($visit->visit_service_end)) }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-secondary" onclick="window.location.href='{{ route('give_feedback', ['visit_service_id' => $visit->id_visit_services]) }}'">
                                            <iconify-icon icon="fluent-mdl2:feedback-response-solid" class="me-1 fs-16"></iconify-icon>
                                            Feedback
                                        </button>
                                       
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection