@extends('layouts.horizontal', ['title' =>$pageTitle, 'topbarTitle' => $pageTitle])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="TSuppliers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">{{$pageTitle}}</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    @can('create-Franchise_Orders')
        <div class="row">
        <div class="col-12">
            <div class="card">
                
                <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h4 class="card-title mb-0">Select The Franchise </h4>
                    <div>
                        <a href="{{route('franchise.franchise_orders')}}" type="button" class="btn btn-primary">View Franchise Orders</a>
                    </div>
                </div>
                <form method="post" action = "{{ route('franchise.create_franchise_order') }}">
                    @csrf
                    <div class="row g-3">
                        <div class="col-3">
                            <select class="form-select select-2" id="selected_franchise" name="selected_franchise" <?php if($selected_franchise!=='all'){echo "disabled='disabled'";} ?>>
                                <option value='all'></option>
                                    @foreach ($franchises as $f)
                                        <option {{ $f->id==$selected_franchise ? 'selected' : ''}} value='<?php echo $f->id;?>'><?php echo $f->franchise_name. ' | '. $f->owner;?></option>
                                    @endforeach
                            </select>
                        </div>

                        @php
                            $order_date = $order[0]['order_date'] ?? $order_date;
                        @endphp
                        <div class="col-3">
                            <input type="date" class="form-control" id="order_date" name="order_date" value="{{$order_date}}">
                        </div>     

                        <div class="col-sm-2 align-self-end">
                            <input type="hidden" name="run_franchise_orders" id="voucher_add_csrf" value=""/>
                            <button type="submit" class="btn btn-primary " onclick="$('#run_franchise_orders').val($('#cook').val());" id="refresh_btn"> Run</button>
                        </div>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>


    <?php if(isset($franchise)){ ?>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">{{$pageTitle}}</h4>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="franchise_name" class="control-label">Name</label>
                                <input readonly="readonly" type="text" class="form-control" id="franchise_name" name="franchise_name" placeholder="Name" value='<?php echo $franchise->franchise_name;?>'>
                                <input type="hidden" class="form-control" id="order-customer-id" name="order-customer-id" value='<?php echo $franchise->id_franchises;?>'>
                                <input type='hidden' name='order_id' id='order_id' value="{{$order[0]['id_franchise_orders'] ?? '' }}">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="franchise_ntn" class="control-label">NTN</label>
                                <input readonly type="text" class="form-control" id="franchise_ntn" name="franchise_ntn" placeholder="NTN" value='<?php echo $franchise->franchise_ntn;?>'>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="franchise_owner" class="control-label">Owner</label>
                                <input readonly type="text" class="form-control" id="franchise_owner" name="franchise_owner" placeholder="Owner" value='<?php echo $franchise->franchise_owner;?>'>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="franchise_discount" class="control-label">Franchise Discount %</label>
                                <input readonly type="text" class="form-control" id="franchise_discount" name="franchise_discount" placeholder="Discount" value='<?php echo $franchise->franchise_discount;?>'>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="franchise_limit" class="control-label">Franchise Credit Limit</label>
                                <input readonly type="text" class="form-control" id="franchise_limit" name="franchise_limit" placeholder="Limit" value='<?php echo $franchise->franchise_limit;?>'>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="order_extra" class="control-label">Branch or Other Details</label>
                                <input type="text" class="form-control" id="order_extra" name="order_extra" placeholder="Extra details" value='<?php if(sizeof($order)>=1){echo $order[0]['franchise_order_extra'];}?>'>
                            </div>
                        </div>
                    </div>

                    {{-- SECOND ROW --}}

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label" for="retail-order-products" >Select Product:</label>
                                <select class="form-control select-2"  id="retail-order-products" name="order-products"  data-placeholder="Brand Product Category. .">
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2 d-none">
                            <label for="checkboxall" class="control-label">?</label>
                            <div class="checkbox checkbox-success ">
                                <input onchange="retail_getproducts();" id="checkboxall" type="checkbox">
                                <label for="checkboxall">
                                    Show All Stores
                                </label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="retail-order-staff" class="control-label">Sold By</label>
                                <select class='form-control select-2'  id="retail-order-staff" name="order-staff" data-placeholder="Staff"> 
                                    <option></option>
                                    @if (isset($getStaff))
                                        @foreach ($getStaff as $staff)
                                            <option value="{{$staff->id}}">{{$staff->text}}</option>
                                        @endforeach
                                    @endif

                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="order-customer-qty" class="control-label">Qty.</label>
                                <input class="form-control numeric" type="number" id="order-customer-qty" name="order-customer-qty" value="1">
                            </div>
                        </div> 
                         <?php $editable=false; if(sizeof($order)>=1){ if($order[0]['order_status']=='Open'){$editable=true;}}else{$editable=true;}?>
                        <?php if($editable==true){?>
                            <div class='col-md-1 text-start'>
                                <label  class="control-label " style="color: #ffffff">Action</label>
                                <button type="button" onclick='addFranchiseOrderRows();' class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn ">
                                <iconify-icon icon="line-md:arrow-open-down" class="fs-20"></iconify-icon>
                                </button>
                            </div>
                        <?php } ?>
                    </div>
                   

                    {{-- THIRD ROW --}}
                     <div class='row mb-3' style="min-height: 150px;">
                        <div id='order-product-list' class='col-md-12'>
                            <div class="table-responsive">
                                <table class="table table-centered table-bordered  mb-0 table-sm fs-12 w-100" id="ordertbl">
                                    <thead>
                                        <tr>
                                            <th style="display:none;">Customer ID</th>
                                            <th>Product ID</th>
                                            <th>Product </th>
                                            <th>Details</th>
                                            <th>Category</th>
                                            <th class="d-none">Batch</th>
                                            <th style="display:none;">Staff ID</th>
                                            <th>Sold By</th>
                                            <th>Qty.</th>
                                            <th>Price</th>                                                            
                                            <th class="text-end">Total</th>
                                            <th class="text-end">Disc(%)</th>
                                            <th class="text-end">Unit Discount</th>                                                            
                                            <th class="text-end">Discounted Price</th>
                                            <th  id="month">Month</th>
                                            <th id="year">Year</th>
                                            <th class="d-none" id="product_type"></th>
                                            <th>Remove</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $totalvalue=0; $totaldiscount=0; if(sizeof($order) > 0){
                                            foreach($order as $item){
                                            ?>
                                        <tr>
                                            <td style="display:none;"><?php echo $item['franchise_id']; ?></td>
                                            
                                            <td class='id' row='<?php echo $item['product_id'];?>' batch_id='<?php echo $item['batch_id']; ?>'><input type='hidden' id='product_id' name='product_id' value='<?php echo $item['product_id'];?>'><?php echo $item['product_id'];?></td>
                                            <td><?php echo $item['product_name']; ?></td>
                                            <td class="productdetail" style="text-align:left;"><input type="text" class="productdetail" name="productdetail" id="productdetail<?php echo $item['product_id'];?>" style="width: 80px; border: none; text-align:left;" value="<?php echo $item['product_detail']; ?>"/></td>
                                            <td><?php echo $item['category']; ?></td>
                                            <td class='batchid d-none' batch_id='<?php echo $item['batch_id']; ?>'><?php echo $item['batch']; ?></td>
                                            <td style="display:none;"><?php echo $item['staff_id']; ?></td>
                                            <td><?php echo $item['staff_name']; ?></td>
                                            <td class="qty" contenteditable="true" oninput="trigger_price_colum(this);" stockfrom="<?php echo $item['stockfrom']; ?>"><?php echo $item['qty']; ?></td>
                                            <td><input onchange="price_by_product(this.value, '{{$item['product_id']}}');" style="border:none;" name="price" value="<?php echo $item['unit_price']; ?>"></td>
                                            <td style="text-align:right;"><?php echo $item['unit_price'] * $item['qty']; ?></td>
                                            <?php
                                                $totalPrice = $item['unit_price'] * $item['qty'];
                                                    if ($totalPrice > 0) {
                                                        $discountPerc = ($item['unit_discount']*$item['qty'] / $totalPrice) * 100;
                                                    } else {
                                                        $discountPerc = 0; 
                                                    } 
                                            ?>

                                            <td style="text-align:right;"><input read type="text"  onblur="recalculate();" class="numeric discount_perc" name="discount_perc" id="discount_perc<?php echo $item['product_id'];?>" style="text-align:right; border: none;" value="{{round($discountPerc, 2)}}"></td>
                                            <td class="discount" unit_discount="<?php echo $item['unit_discount'];?>" style="text-align:right;"><input type="text"  onblur="recalculate();" class="numeric discount_by_product" name="discount_by_product" id="discount_by_product<?php echo $item['product_id'];?>" style="width: 80px; border: none; text-align:right;" value="<?php echo $item['unit_discount'];?>"></td>
                                            <?php $totaldiscount=$totaldiscount+($item['unit_discount']);?>
                                            
                                            <td discounted_price="<?php echo $item['discounted_price'];?>" style="text-align:right;"><?php echo $currency;?> <span class="combat" id="unitcost<?php echo $item['product_id'];?>"><?php echo $item['discounted_price'] ;?></span><input type="hidden" name="orignal_product_price" id="orignal_product_price<?php echo $item['product_id'];?>" value="<?php echo $item['discounted_price'];?>"></td>
                                            <?php $totalvalue=$totalvalue + $item['discounted_price'] ;?>
                                            
                                            <?php if(null!==$item['order_month']){?>
                                            <td class="month" style="text-align:left;"><select><option value="1">Jan</option><option value="2">Feb</option><option value="3">Mar</option><option value="4">Apr</option><option value="5">May</option><option value="6">Jun</option><option value="7">Jul</option><option value="8">Aug</option><option value="9">Sep</option><option value="10">Oct</option><option value="11">Nov</option><option value="12">Dec</option></select></td>
                                            <td class="year" style="text-align:left;"><select><option value="2020">2020</option><option selected="selected" value="2021">2021</option><option value="2022">2022</option></select></td>
                                            
                                            <?php }else { ?>
                                            <td class="month>"></td>
                                            <td class="year>"></td>
                                            
                                            <?php } ?>
                                            
                                            <?php $product_and_batch_id = $item['product_id'].''.$item['batch_id'] ?>
                                            <td><button onclick="removebyrow('<?php echo $product_and_batch_id ?>');" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button></td>
                                        </tr>
                                        <?php }} ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="5"></th>
                                            <th class="d-none"></th>
                                            <th colspan="4"></th>
                                            {{-- <th style="text-align:right;"><input style="border: none; text-align:right;" readonly="readonly" id="totaldiscount" value="<?php echo $totaldiscount;?>"></th> --}}
                                            <th style="text-align:right;"><input style="border: none; text-align:right;" readonly="readonly" id="totaldiscount" value=""></th>
                                            <th style="text-align:right;"><input style="border: none; text-align:right;" readonly="readonly" id="totalvalue" value="<?php echo $totalvalue;?>"></th>
                                            <th></th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    {{-- FOURTH ROW --}}

                    <?php if($editable==true){?>
                        <div class="row mb-3">
                            <div class="col-md-6 ">
                            <form action="open_order_invoice" method="post" target="_blank">
                                <input type="hidden" class="form-control" id="order-id" name="order-id">
                                    <input type="hidden" name="csrf_test_name" id="retail_modal_csrf" value=""/>
                                    <button id="btngengdn" onclick="$('#retail_modal_csrf').val($('#cook').val());" style='display:none;' class="btn btn-pink waves-effect waves-light">Create GDN</button>
                                </form>
                            </div>
                                <div class="col-md-6 text-end">
                                <button type="button" onclick="franchise_updateorder();" class="btn btn-primary" id="saveChangesButton">Save Changes</button>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div> 
<?php } ?>

@else
    <h1>{{ config('permission.not_allowed') }}</h1>
@endcan
@endsection

@section('scripts')
<script>
$(document).ready(function() {
        $('.select-2').select2({
            width: '100%'
        });

        $('#retail-order-products').select2({
                placeholder: 'Select a product',
                ajax: {
                    url: '{{ route("products.search_products") }}',
                    dataType: 'json',
                    delay: 1000,
                    data: function(params) {
                        return {
                            q: params.term, 
                        
                        };
                    },
                    processResults: function(data) {
                       return {
                            results: data.map(function (item) {
                                return {
                                id: item.id,
                                text: item.business_brand_name + ' ' + item.product + ' ' + (item.category ? ' (Category: ' + item.category + ')' : ''),
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                price: item.price,
                                category: item.category,
                                unit_type: item.unit_type,
                                product_type: item.product_type, 
                                };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 4
            });

});

    function addFranchiseOrderRows() {

        var stockfrom="in_stock";
        if ($("#order-customer-qty").val() === "" || $("#order-customer-qty").val() === "0" || $("#retail-order-products option:selected").val() === "select") {
              Swal.fire({
                icon: 'warning',
                title: 'Product & Quantity Should not be empty!',
                text: 'Please select all the above options before proceeding.',
                confirmButtonText: 'OK',
                customClass: {
                            confirmButton: 'btn btn-danger'
                }
            });
            return false;
        }

        r = $("#retail-order-products").val().split(',');
        var data = $("#retail-order-products").select2('data');
        if (data.length > 0) {
            var item = data[0]; 
            var product_id     = parseInt(item.id);
            var in_stock       = 0;
            var product_name   = item.product;
            var category       = item.category || '';
            var batch          = '';
            var batch_id       = 0;
            var price          = item.price;
            var unit_type      = item.unit_type;
            var measure_unit   = item.measure_unit;
            var qty_per_unit   = item.qty_per_unit;
            var product_type   = item.product_type;
        }

        var selected_qty = parseInt($("#order-customer-qty").val());

            let duplicateFound = false;
            $("#order-product-list td.id").each(function () {
                let existingProduct = parseFloat($(this).attr("row"));
                let existingBatch   = parseFloat($(this).attr("batch_id"));

                if (existingProduct === product_id && existingBatch === batch_id) {
                    duplicateFound = true;
                    return false;
                }
            });

            if (duplicateFound) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Already added!',
                    text: 'This product is already in the list.',
                    confirmButtonText: 'OK',
                      customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                });
                return false;
            }
            addFranchiseOrderRow1(stockfrom, product_id, product_name, category, batch, batch_id, price, in_stock, unit_type, measure_unit, qty_per_unit, product_type);
    }
    
    function addFranchiseOrderRow1(stockfrom, product_id, product_name, category, batch, batch_id, price, in_stock, unit_type, measure_unit, qty_per_unit, product_type){
        var mhtml = "";
        var qty = parseInt($("#order-customer-qty").val());
        if (parseInt(product_id) > 0) {
            var rowcount=0;
            var pTotalQty=0;
           
            var alreadyexist= retail_storeOTblValues();
            var ae = false;
            if(alreadyexist.length > 0){
              
                $('#ordertbl tr').each(function(row, tr) {
                    if($(tr).find('td:eq(1)').text()==product_id && $(tr).find('td:eq(5)').attr('batch_id')==batch_id){
                        pTotalQty = pTotalQty + parseInt($(tr).find('td:eq(7)').text()) + qty;
                        if(pTotalQty > in_stock){
                            // Swal.fire({
                            //     icon: 'warning',
                            //     title: 'Quantity cannot be more then available stock!',
                            //     text: 'The entered quantity is more than the available stock (' + in_stock + '). Please adjust the quantity before proceeding.',
                            //     confirmButtonText: 'OK'
                            // });
                            // ae=true;
                        }
                    }
                })  
            }
            if(ae===true){
                return false;
            } else{
                 var rowstillnow = $("#order-product-list tr").length;

                if(rowstillnow > 75){
                    swal({
                            title: "Maximum of 75 products in an order!",
                            text: 'Please Create a Different Order for the rest of the Products.',
                            type: "warning",
                            confirmButtonText: 'OK!',
                              customClass: {
                                confirmButton: 'btn btn-danger'
                            }
                        });
                    return false;
                }
                mhtml += '<tr>';
                mhtml += '<td style="display:none;">' + $("#order-customer-id").val() + '</td>';
                //mhtml += "<td class='id' row='"+rowcount+"'>" + product_id + "</td>";
                mhtml += "<td class='id' row='"+product_id+"' batch_id='"+batch_id+"'><input type='hidden' id='product_id' name='product_id' value='"+ parseInt(product_id)  +"'>" + product_id + "</td>";
                mhtml += "<td>" + product_name + "</td>";
                mhtml += "<td class='productdetail' style='text-align:left;'><input type='text' class='productdetail' name='productdetail' id='productdetail"+ parseInt(product_id)  +"' style='width: 80px; border: none; text-align:left;' value=''/></td>";
                mhtml += "<td>" + category + "</td>";
                mhtml += "<td class='batchid d-none' batch_id='"+batch_id+"'>" + batch + "</td>";
                mhtml += "<td style='display:none;'>";
                $('#retail-order-staff').children('option:selected').each(function() {
                    if($(this).val()!==""){
                        mhtml += $(this).val();
                    }
                });
                mhtml += "</td>";
                mhtml += "<td>";
                $('#retail-order-staff').children('option:selected').each(function() {
                    if($(this).val()!==""){
                        mhtml += $(this).text();
                    }
                });
                mhtml += "</td>";

                mhtml += '<td contenteditable="true" oninput="trigger_price_colum(this);" class="qty" stockfrom="'+ stockfrom +'">' + qty + '</td>';
                mhtml += '<td class="price"><input onchange="price_by_product(this.value, \''+parseInt(product_id)+'\');" name="price" class="decimal" style="border:none;" value="' + price + '"></td>';
                
                mhtml += '<td style="text-align:right;">'+ parseFloat(price)*parseFloat(qty) +'</td>';
                mhtml += '<td style="text-align:right;"><input read type="text"  onblur="recalculate();" class="numeric discount_perc" name="discount_perc" id="discount_perc'+product_id+'" style="text-align:right; border: none;" value="'+ parseFloat($("#franchise_discount").val()) +'"></td>';
                mhtml += '<td class="discount" unit_discount="'+(parseFloat(price)*parseFloat($("#franchise_discount").val()))/100+'" style="text-align:right;"><input read type="text"  onblur="recalculate();" class="numeric discount_by_product" name="discount_by_product" id="discount_by_product'+product_id+'" style="text-align:right; border: none;" value="'+ ((parseFloat(price)*parseFloat($("#franchise_discount").val()))/100)+'"></td>';
               
                mhtml += '<td discounted_price="'+ (parseFloat(price)-(parseFloat(price)*parseFloat($("#franchise_discount").val()))/100)*parseFloat(qty) +'" style="text-align:right;"><?php echo $currency;?> <span class="combat" id="unitcost'+product_id+'">' + (parseFloat(price)-(parseFloat(price)*parseFloat($("#franchise_discount").val()))/100)*parseFloat(qty)  + '</span><input readonly type="hidden" name="orignal_product_price" id="orignal_product_price'+product_id+'" value="' + (parseFloat(price)-(parseFloat(price)*parseFloat($("#franchise_discount").val()))/100) * parseFloat(qty)  + '"></td>';
                
                if(product_type=='Subscription'){
                    $("#month").show();
                    $("#year").show();
                    mhtml += '<td class="month" style="text-align:left;">';
                    mhtml += '<select>';
                    @foreach($months as $month)
                    mhtml += '<option value="<?php echo $month->id_months;?>"><?php echo $month->month_name;?></option>';
                    @endforeach               
                    mhtml += '</select>';
                    mhtml += '</td>';
                    var d = new Date();
                    var p = d.getFullYear() - 1;
                    var c = d.getFullYear();
                    var n = d.getFullYear() + 1;
                    mhtml += '<td class="year" style="text-align:left;">';
                    mhtml += '<select>';
                    mhtml += '<option value="'+ p +'">'+ p +'</option>';
                    mhtml += '<option selected="selected" value="'+ c +'">'+ c +'</option>';
                    mhtml += '<option value="'+ n +'">'+ n +'</option>';
                    mhtml += '</select>';
                    mhtml += '</td>';
                } else if($("#month").is(':visible')){
                    mhtml += '<td class="month" style="text-align:left;"></td>';
                    mhtml += '<td class="year" style="text-align:left;"></td>';
                }
                var product_and_batch_id= product_id+''+batch_id;
                mhtml += '<td><button onclick="removebyrow(\'' + product_and_batch_id + '\');" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button></td>';
                mhtml += "</tr>";
        
       
                $("#order-product-list tbody").append(mhtml);
                recalculate();
                update_total();
                $("#order-customer-qty").val('1');
                $('#retail-order-staff').val(null).trigger('change');
                //$('#retail-order-products').val('select');
               
            }
        }
    }


    function retail_storeOTblValues(){
        var TableData = new Array();
        $('#ordertbl tr').each(function(row, tr) {
            TableData[row] = {
                 "customerid": $(tr).find('td:eq(0)').text()
                , "productid": $(tr).find('td:eq(1)').text()
                , "productname": $(tr).find('td:eq(2)').text()
                , "productdetail": $(tr).find('td:eq(3) input').val()
                , "category": $(tr).find('td:eq(4)').text()
                , "batch": $(tr).find('td:eq(5)').text()
                , "batch_id": $(tr).find('td:eq(5)').attr('batch_id')
                , "staffid": $(tr).find('td:eq(6)').text()
                , "staff": $(tr).find('td:eq(7)').text()
                , "qty": $(tr).find('td:eq(8)').text()
                , "stockfrom": $(tr).find('td:eq(8)').attr('stockfrom')
                , "unit_price": $(tr).find('td:eq(9) input').val()
                , "discount_perc": $(tr).find('td:eq(11) input').val()
                , "unit_discount": $(tr).find('td:eq(12) input').val()
                , "discounted_price": $(tr).find('td:eq(13)').attr('discounted_price')
                , "month": $(tr).find('td:eq(14) select').val()
                , "year": $(tr).find('td:eq(15) select').val()
                , "product_type": $(tr).find('td:eq(16) input').val()
            }
        });
        TableData.shift();
        TableData.pop(); 
        return TableData;
    }

    function update_total(){       
        var theTotal = 0;
        var theDiscount=0;
        $("table td:nth-child(14) .combat").each(function () {
            var val = $(this).text();;
            theTotal += parseFloat(val);
        });
        $("table td:nth-child(13) .discount_by_product").each(function () {
            var disc = $(this).val();
            theDiscount += parseFloat(disc);
        });
        $('#totalvalue').val(Math.round(theTotal));
        // $('#totaldiscount').val(Math.round(theDiscount));
     
    }

    function removebyrow(val) {
        $('#order-product-list').find("td.id").each(function(index) {
        //    console.log($(this).attr("row"));
            var product_and_batch_id = $(this).attr("row")+''+$(this).attr("batch_id")
            if (product_and_batch_id=== val) {
                $(this).closest('tr').remove();
            }
        });
        update_total();
    }
    function removeproduct(val) {
        $('#order-product-list').find("td.id").each(function(index) {
            var product_and_batch_id = $(this).attr("row")+''+$(this).attr("batch_id");
            if ($(this).html() == val) {
                $(this).closest('tr').remove();
            }
        });
        update_total()
    }



    // Jab percentage change ho
    $(document).on('input', '.discount_perc', function () {
        let tr = $(this).closest('tr');

        let qty   = parseFloat(tr.find('td:eq(8)').text()) || 0;
        let price = parseFloat(tr.find('td:eq(9) input').val()) || 0;
        let perc  = parseFloat($(this).val()) || 0;

        let discount = (price * perc) / 100;

        tr.find('.discount_by_product').val(discount.toFixed(2));

        recalculate();
    });

    // Jab discount amount change ho
    $(document).on('input', '.discount_by_product', function () {
        let tr = $(this).closest('tr');

        let qty   = parseFloat(tr.find('td:eq(8)').text()) || 0;
        let price = parseFloat(tr.find('td:eq(9) input').val()) || 0;
        let discount = parseFloat($(this).val()) || 0;

        let perc = price > 0 ? (discount / price) * 100 : 0;

        tr.find('.discount_perc').val(perc.toFixed(2));

        recalculate();
    });


    function recalculate() {

        var grand = 0;

        $('#ordertbl tr').each(function (row, tr) {

            if (row > 0 && $(tr).find('th:eq(0)').attr('colspan') != 9) {

                let qty   = parseFloat($(tr).find('td:eq(8)').text()) || 0;
                let price = parseFloat($(tr).find('td:eq(9) input').val()) || 0;
                let discount = parseFloat($(tr).find('.discount_by_product').val()) || 0;

                let total = price * qty;
                let final = total - (discount * qty);

                final = Math.round(final);

                $(tr).find('td:eq(13)').attr('discounted_price', final);
                $(tr).find('td:eq(13) span').text(final);

                grand += final;
            }
        });

        $("#totalvalue").val(grand);
    }


    function price_by_product(val, productid) {
        $('#ordertbl tr').each(function(row, tr) {
            var product = $(tr).find('td:eq(1)').text();
            if (product === productid) {
                var qty = parseFloat($(tr).find('td:eq(8)').text()) || 0;
                var price = parseFloat($(tr).find('td:eq(9) input').val()) || 0;
                var discount_perc = parseFloat($(tr).find('td:eq(11) input').val()) || 0;

                var unit_discount = (price * discount_perc) / 100;
                var total = price * qty;
                var discount_amount = (total * discount_perc) / 100;
                var final_price = total - discount_amount;

                
                $(tr).find('td:eq(10)').text(total.toFixed(2));              
                $(tr).find('td:eq(12) input').val(unit_discount.toFixed(2)); 
                $(tr).find('td:eq(13) span').text(final_price.toFixed(2));    
                $(tr).find('td:eq(13)').attr('discounted_price', final_price.toFixed(2));
            }
        });
        update_total(); // optional
    }

    function franchise_updateorder(val='') {
            var TableData;
            TableData = retail_storeOTblValues();
            TableData =  JSON.stringify(TableData);
            if (TableData.length > 2) {

                $("#saveChangesButton").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span> Loading..`);
                $('#saveChangesButton').prop('disabled', true);
                $.ajax({
                    type: "POST",
                    url: '{{route('franchise.save_franchise_order')}}',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}' 
                    },
                    data: {
                        orderdata:TableData,
                        order_date:$("#order_date").val() || 0,
                        orderid:$("#order_id").val() || 0,
                        franchiseid:$("#order-customer-id").val(),
                        franchisename:$("#franchise_name").val(),
                        franchisentn:$("#franchise_ntn").val(),
                        orderstatus: 'Open',
                        franchise_order_value: $("#totalvalue").val(),
                        franchise_order_discount: $("#totaldiscount").val(),
                        order_extra: $("#order_extra").val()
                    },
                    success: function(data) {
                        $('#saveChangesButton').prop('disabled', false);
                        $("#saveChangesButton").html(`Save Changes`);
                        if (data.success) {
                            // toastr.success(data.message, 'Done!');  
                            let order_id = 1; // <-- Yahan ap dynamic order id set karen
                            Swal.fire({
                                title: "Success",
                                text: data.message+ " Would you like to create the invoice for this order?",
                                icon: "success",
                                showCancelButton: true,
                                confirmButtonText: "Yes, Create Invoice",
                                cancelButtonText: "No, Close",
                            customClass: {
                                            confirmButton: "btn btn-success me-2", // Apply your custom classes
                                            cancelButton: "btn btn-primary" // Apply your custom classes
                                },
                                buttonsStyling: false
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.href = data.invoice_url;
                                }
                            });                            
                        } else {
                            Swal.fire({
                                icon: data.message_type,
                                title: 'Error',
                                text: data.message,
                                confirmButtonText: 'OK',
                                customClass: {
                                        confirmButton: 'btn btn-danger'
                                    }
                            });
                        }
                    },
                     error: function(xhr, status, error) {
                        $('#saveChangesButton').prop('disabled', false);
                        $("#saveChangesButton").html(`Save Changes`);
                        console.error('AJAX Error:', error);
                    }
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'You have not added any Products',
                    text: 'Select Product and staff member providing that made the sale.',
                    confirmButtonText: 'OK!',
                    customClass: {
                            confirmButton: 'btn btn-danger'
                    }
               });
            }
    }

    function trigger_price_colum(this_row){
        $(this_row).closest('tr').find('[name="price"]').trigger('change');
    }

</script>
@endsection