@extends('layouts.horizontal', ['title' => 'Franchises', 'topbarTitle' => 'Franchises'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
@endsection
@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="TSuppliers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Franchises</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <!-- Suppliers Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="franchise_table" class="table table-bordered table-centered  mb-0 table-sm fs-12 w-100">
                        <thead class="table-light">
                            <tr>
                                <th class="text-start">Franchise ID</th>
                                <th>Franchise NTN</th>
                                <th>Franchise Name</th>
                                <th>Franchise Contact</th>
                                <th>Franchise Owner</th>
                                <th>Office Phone</th>
                                <th>Address</th>
                                <th>Email</th>                                        
                                <th>Agreed Discount</th>                                        
                                <th>Payment Terms</th>                                        
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                
                        </tbody>
                    </table>
                 </div> 
                </div>
            </div>
        </div>
    </div>
</div>


{{-- Modal for Editing Suppliers --}}
<div class="modal fade" id="franchiseModal" tabindex="-1" aria-labelledby="franchiseModal" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" ></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="franchiseModalForm">
                @csrf
                <div class="modal-body">
                <div class="row mb-3">
                    <input type="hidden" id="id_franchises" name="id_franchises" >
                    <div class="col-md-6">
                        <label for="franchise_name" class="form-label">Franchise Name <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control" id="franchise_name" name="franchise_name" placeholder="Franchise Name" required>
                    </div>
                      <div class="col-md-6">
                        <label for="franchise_owner" class="form-label">Owner <strong class="text-danger">*</strong></label>
                        <input type="text" class="form-control" id="franchise_owner" name="franchise_owner" placeholder="Owner" >
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="franchise_ntn" class="form-label">Franchise NTN</label>
                        <input type="number" step="any"  class="form-control" id="franchise_ntn" placeholder="Franchise NTN" name="franchise_ntn" >
                    </div>
                    <div class="col-md-6">
                        <label for="franchise_contact" class="form-label">Contact</label>
                        <input type="text" step="any"  class="form-control" id="franchise_contact" placeholder="Contact" name="franchise_contact" >
                    </div>
                </div>  
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="franchise_office_phone" class="form-label">Office Phone</label>
                        <input type="text" class="form-control" id="franchise_office_phone" placeholder="Office Phone" name="franchise_office_phone" >
                    </div>
                    <div class="col-md-6">
                        <label for="franchise_email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="franchise_email" name="franchise_email" placeholder="Email">
                    </div>
                </div>  
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="franchise_discount" class="form-label">Agreed Discount</label>
                        <input type="number" step="any"  class="form-control" id="franchise_discount" name="franchise_discount" placeholder="Agreed Discount">
                    </div>
                    <div class="col-md-6">
                        <label for="franchise_limit" class="form-label">Credit Limit</label>
                        <input type="number" step="any" class="form-control" id="franchise_limit" name="franchise_limit" placeholder="Credit Limit">
                    </div>
                </div>  
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="franchise_address" class="form-label">Address</label>
                        <input type="text" class="form-control" id="franchise_address" name="franchise_address" placeholder="Address" >
                    </div>
                </div>  
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label for="franchise_payment_terms" class="form-label">Payment Terms</label>
                        <textarea class="form-control" id="franchise_payment_terms" name="franchise_payment_terms" rows="4" placeholder="Enter payment terms">{{$defultFranchiseTerms ?? ''}} </textarea>
                    </div> 
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" onclick="save_franchise()" class="btn btn-primary" id="saveChangesButtons">Save changes</button>
            </div>
            </form>
        </div>
    </div>
{{-- End Modal --}}



@endsection

@section('scripts')
<script>
$(document).ready(function() {
initializeFranchiseTable(); 
});

//on scroll close tooltips
$(window).on('scroll', function () {
            $('[data-bs-toggle="tooltip"]').each(function () {
                let instance = bootstrap.Tooltip.getInstance(this);
                if (instance) {
                    instance.hide();
                }
            });
});

function openFranchiseModal() {
    $('.modal-title').text('Add New Franchise');
    $('#franchiseModalForm')[0].reset();
    $('#id_franchises').val('');
    let El = document.getElementById('franchiseModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
    modal.show();
}

function save_franchise() {
    var formData = new FormData(document.getElementById("franchiseModalForm"));
    $("#saveChangesButtons").prop('disabled', true);
    $.ajax({
        url: "{{ route('franchise.save') }}",
        method: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function(res) {
            $("#saveChangesButtons").prop('disabled', false);
            if(res.success){
                let El = document.getElementById('franchiseModal');
                let modal = bootstrap.Modal.getInstance(El);
                if (!modal) modal = new bootstrap.Modal(El);
                modal.hide();

                $('#franchise_table').DataTable().ajax.reload();
                toastr.success(res.message);

            } else {
                $("#saveChangesButtons").prop('disabled', false);
                toastr.error('Failed to save Franchise: ' + res.message);
            }
        },
        error: function(xhr) {
            $("#saveChangesButtons").prop('disabled', false);
            toastr.error('Failed to save Franchise: ' + xhr.responseText);
        }
    });
}


function openEditModal(btn) {

    $('.modal-title').text('Edit Franchise');

    $('#id_franchises').val($(btn).data('id'));
    $('#franchise_name').val($(btn).data('name'));
    $('#franchise_ntn').val($(btn).data('ntn'));
    $('#franchise_contact').val($(btn).data('contact'));
    $('#franchise_owner').val($(btn).data('owner'));
    $('#franchise_office_phone').val($(btn).data('office'));
    $('#franchise_email').val($(btn).data('email'));
    $('#franchise_address').val($(btn).data('address'));
    $('#franchise_discount').val($(btn).data('discount'));
    $('#franchise_limit').val($(btn).data('limit'));
    $('#franchise_payment_terms').val($(btn).data('franchise_payment_terms'));

    let El = document.getElementById('franchiseModal');
    let modal = bootstrap.Modal.getInstance(El);
    if (!modal) modal = new bootstrap.Modal(El);

    modal.show();
}


initializeFranchiseTable = function() {
    $('#franchise_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: false,
        fixedHeader: true,
        destroy:true,
        ajax: {
            url: '{{ route("franchise.franchisedata") }}',
            type: 'get',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
        },

        columns: [
            { data: 'id_franchises' , className: 'text-start',},
            { data: 'franchise_ntn' , name: 'franchise_ntn'  },
            { data: 'franchise_name' },
            { data: 'franchise_contact' },
            { data: 'franchise_owner' },
            { data: 'franchise_office_phone' },
            { data: 'franchise_address' },
            { data: 'franchise_email' },
            { data: 'franchise_discount'},
            { data: 'franchise_payment_terms'},
            { data: 'action' }
        ],
         buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
                "layout": {
                    topStart: "buttons",
                    topEnd: function() {
                        // Return a flex container with search input and button
                        return '<div class="d-flex align-items-center gap-2" style="justify-content: flex-end; width: 100%;"><label class="dataTables_filter" style="margin: 0;"><input type="search" class="form-control form-control-sm" placeholder="Search..." aria-controls="franchise_table" id="franchise_table_search"></label>' +
                               @can('create-Franchise')
                               '<button class="btn btn-sm btn-outline-success" id="addFranchiseBtn" onclick="openFranchiseModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Add franchise</button>' +
                               @endcan
                               '</div>';
                    },
                    bottomStart: {           
                        pageLength: {
                            menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                        },
                        info: {}
                    },                
                    bottomEnd: "paging"     
                },
                initComplete: function(settings) {
                    // Manually wire up the search input to DataTables
                    var searchInput = $('#franchise_table_search');
                    if (searchInput.length) {
                        searchInput.on('keyup', function() {
                            $('#franchise_table').DataTable().search(this.value).draw();
                        });
                    }
                },
        ordering: true,
        drawCallback: function(settings) {
                // Initialize tooltips after table draw
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('#franchise_table [data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
                })
        }
    });
};

</script>
@endsection