@extends('layouts.horizontal', ['title' => 'Franchise Orders', 'topbarTitle' => 'Franchise Orders'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="TSuppliers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Franchise Orders</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @can('create-Franchise_Orders')
                        <a class="btn btn-outline-success" href="{{ route('franchise.create_franchise_order') }}">
                        <iconify-icon icon="mdi:plus" class="me-1 fs-20"></iconify-icon> Add New Order</a>
                    @endcan
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
          {{-------------------->  ALERTS START <--------------------------}}
        @if (session('success')) 
        <div class="alert alert-success alert-dismissible d-flex align-items-center border-2 border border-success"
        role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
                <iconify-icon icon="solar:check-read-line-duotone" class="fs-20 me-1"></iconify-icon>
                <div class="lh-1"><strong>Success - </strong> {!! session('success') !!}</div>
            </div>
        @endif
        @if (session('warning'))
            <div class="alert alert-warning alert-dismissible d-flex align-items-center border border-warning"
                role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
                <iconify-icon icon="solar:shield-warning-line-duotone" class="fs-20 me-1"></iconify-icon>
                <div class="lh-1"><strong>Warning - </strong> {!! session('warning') !!}</div>
            </div>
        @endif

        @if (session(key: 'error'))
        <div class="alert alert-danger alert-dismissible d-flex align-items-center border-2 border border-danger"
            role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert"
            aria-label="Close"></button>
            <iconify-icon icon="solar:danger-triangle-bold-duotone" class="fs-20 me-1"></iconify-icon>
            <div class="lh-1"><strong>Error - </strong> {!! session('error') !!} </div>
        </div>
        @endif
    {{-------------------->  ALERTS END <--------------------------}} 

        <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Filters :</h4>
                    <div class="row g-3">
                        <div class="col-2">
                            <label for="franchise_id" class="form-label">Franchises</label>
                            <select class="form-select select2" id="franchise_id" name="franchise_id">
                                <option value="All">All</option>
                                
                            </select>
                        </div>
                        <div class="col-sm-2">
                            <label class="form-label">From Date</label>
                            <input type="date" class="form-control" id="from_date" value="{{ date('Y-m-01') }}">
                        </div>
                        <div class="col-sm-2">
                            <label class="form-label">To Date</label>
                            <input type="date" class="form-control" id="to_date" value="{{ date('Y-m-t') }}">
                        </div>

                        <div class="col-2">
                            <label for="dtype" class="form-label">Date Type</label>
                            <select class="form-select select2" id="dtype" name="dtype">
                                <option value='created'>Created date</option>
                                <option value='order'>Order date</option>
                                <option value='invoice'>Invoice date</option>
                            </select>
                        </div>
                
                        <div class="col-2">
                            <label for="order_status" class="form-label">Status</label>
                            <select class="form-select select2" id="order_status" name="order_status">
                                <option value='All'>All</option>
                                <option  value='Open'>Open</option>
                                <option  value='Invoiced'>Invoiced</option>
                                <option  value='Paid'>Received</option>
                                <option  value='Cancelled'>Cancelled</option>
                            </select>
                        </div>
                
                        <div class="col-sm-2 align-self-end">
                            <button type="button" class="btn btn-outline-secondary" id="btn_reset_filters">Reset</button>     
                            <button type="button" class="btn btn-outline-success" onclick="initializeFranchiseTable();" id="refresh_btn"> Refresh</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Suppliers Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="franchise_order_table" class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12">
                        <thead class="table-light">
                           <tr>
                            <th>ID</th>
                            <th>Franchise</th>
                            <th>NTN</th>
                            <th>Order Status</th>
                            <th>Created By</th>
                            <th>Created On</th>
                            <th>Order Date</th>
                            <th>Invoice Date</th>
                            <th>Order Value</th>
                            <th>Invoice Number</th>
                            <th>Invoice Discount</th>
                            <th>Invoice Other Charges</th>
                            <th>Product Sales Tax</th>
                            <th>Invoiced Sales Tax</th>
                            <th>Invoiced Value</th>
                            <th>Receivable</th>
                            <th>Action</th>                                       
                        </tr>
                        </thead>
                        <tbody>
                
                        </tbody>
                    </table>
                 </div> 
                </div>
            </div>
        </div>
    </div>
</div>



{{-- Modal for invoice History --}}
<div class="modal fade" id="invoice_payments_listing_modal" tabindex="-1" aria-labelledby="invoice_payments_listing_modal" aria-hidden="true">
    <div class="modal-dialog modal-full-width">
        <div class="modal-content ">
            <div class="modal-header">
                <h4 class="modal-title" >Payment History For Franchise Order ID : <span id="FranchiseOrderIdForModal"></span> </h4>
                <button type="button" class="btn-close " data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

             <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 text-center mb-2">
                        <h2 class="text-center">Payment History</h2>

                    </div>
                    <div class="col-1"></div>
                    <div class="col-10">
                          <div class="table-responsive">
                         <table class="table table-centered table-bordered  mb-0 table-sm fs-12 w-100 " id="invoice_payment_table">
                        <thead>
                            <tr>
                                <th>Sr#</th>
                                <th>Date</th>
                                <th>Description</th>
                                <th>Amount</th>
                                <th>Created By</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th id="total_received_amount_for_footer"></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>

                    </div>
                    </div>
                     <div class="col-1"></div>
                </div>
              
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
{{-- End Modal --}}
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    var mURL = "{{ route('franchise.franchise_search') }}";
    initializeFranchisePartnerSelect2(mURL, $('#franchise_id option:selected').text());
    initializeFranchiseTable();
});

//on scroll close tooltips
$(window).on('scroll', function () {
        $('[data-bs-toggle="tooltip"]').each(function () {
            let instance = bootstrap.Tooltip.getInstance(this);
            if (instance) {
                instance.hide();
            }
        });
});

function initializeFranchisePartnerSelect2(url, type) {
            $('#franchise_id').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.text };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select ' + type ,
                width: '100%'
            });
} 

initializeFranchiseTable = function() {

    var franchiseid = $("#franchise_id").val() || 'All';
    var dtype =    $("#dtype").val();
    var status =   $("#order_status").val();
    var startdate = $("#from_date").val();
    var enddate = $("#to_date").val();

    $('#franchise_order_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: false,
        fixedHeader: true,
        scrollY: "500px",  
        scrollX: "auto",  
        scrollCollapse: true,
        destroy:true,
        ajax: {
            url: '{{ route("franchise.franchise_order_data") }}',
            type: 'get',
            data:{
                franchiseid:franchiseid,
                dtype:dtype,
                status:status,
                startdate:startdate,
                enddate:enddate
            },
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
        },
       columns: [
            { data: 'id_franchise_orders', name: 'id_franchise_orders'},
            { data: 'franchise_name', name: 'franchise_name'},
            { data: 'franchise_ntn', name: 'franchise_ntn'},
            { data: 'order_status', name: 'order_status'},
            { data: 'created_by', name: 'created_by' },
            { data: 'created_on', name: 'created_on' },
            { data: 'order_date', name: 'order_date' },
            { data: 'invoice_date', name: 'invoice_date' },
            { data: 'franchise_order_value', name: 'franchise_order_value' },
            { data: 'invoice_number', name: 'invoice_number' },
            { data: 'invoice_discount', name: 'invoice_discount' },
            { data: 'invoice_other_charges', name: 'invoice_other_charges' },
            { data: 'product_tax', name: 'fo.product_tax' },
            { data: 'invoice_sales_tax', name: 'invoice_sales_tax' },
            { data: 'invoice_total_receivable', name: 'invoice_total_receivable' },
            { data: 'balance', name: 'balance' },
           { data: 'actions', name: 'actions', orderable: false, searchable: false }
        ],
        createdRow: function(row, data, dataIndex) {
            if (data.order_status === 'Cancelled') {
                $(row).addClass('strike-through');
            }
        },
         buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
                "layout": {
                    topStart: "buttons",
                    topEnd: "search",
                    bottomStart: {           
                        pageLength: {
                            menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                        },
                        info: {}
                    },                
                    bottomEnd: "paging"     
                },
        ordering: true ,
        drawCallback: function(settings) {
                // Initialize tooltips after table draw
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('#franchise_order_table [data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
                })
        }
    });
};

    function cancelFranchiseOrder(id){
        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you really want to cancel this order?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Cancel Order',
            cancelButtonText: 'Close',
            customClass: {
                confirmButton: "btn btn-danger me-2", // Apply your custom classes
                cancelButton: "btn btn-warning" // Apply your custom classes
            },
            buttonsStyling: false,
        }).then((result) => {
            if (result.isConfirmed) {
                // Proceed with cancellation
                sendCancelRequest(id, result.value);
            }
        });
    }


    function sendCancelRequest(id, reason) {
        var url = "{{ route('franchise.cancel_order') }}"; 
        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            data: {
                    id_franchise_orders: id,
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success('Ordr cancelled successfully.');
                        $('#franchise_order_table').DataTable().ajax.reload();
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error('An error occurred while cancelling the voucher.');
                }
            });        
    } 

    function view_franchise_order_invoice_payment(id , this_btn){

        $(this_btn).prop('disabled', true);

        var url = "{{ route('franchise.invoice_payment_history') }}";
         $("#invoice_payment_table tbody").empty(); 
        $.ajax({
            url: url,
            type: 'GET',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            data: {
                    id_franchise_orders: id,
                },
                success: function(response) {
                    $(this_btn).prop('disabled', false);
                    $("#invoice_payment_table tbody").empty(); 
                    if (response.success) { 
                        var total_received_amount_for_footer =0;
                        $.each(response.payment_history, function(index, item) {
                          let voucherPrintUrl = "{{ route('accounts.account_voucher_print') }}" + "?id=" + item.id_account_vouchers;
                            total_received_amount_for_footer+= parseFloat(item.total_received);
                            let row = `
                                <tr>
                                    <td>${index + 1}</td>
                                    <td>${item.voucher_date}</td>
                                    <td>${item.description}</td>
                                    <td>${parseFloat(item.total_received).toFixed(2)}</td>
                                    <td>${item.created_by}</td>
                                    <td>
                                      <a href="${voucherPrintUrl}" target="_blank" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-primary"><iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon></a>
                                      <button onclick="cancelInvoicePayment(${id} , ${item.id_account_vouchers},this)" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button>
                                    </td>
                                </tr>
                            `;
                            $("#invoice_payment_table tbody").append(row);
                        });

                        let El = document.getElementById('invoice_payments_listing_modal');
                        let modal = bootstrap.Modal.getInstance(El);
                        if (!modal) {
                            modal = new bootstrap.Modal(El);
                        }
                        modal.show();

                        $("#total_received_amount_for_footer").text(parseFloat(total_received_amount_for_footer).toFixed(2));
                        $("#FranchiseOrderIdForModal").text(id);

                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    $(this_btn).prop('disabled', false);
                    toastr.error('An error occurred');
                }
            });       
    }
    function cancelInvoicePayment(id,id_account_vouchers,this_btn){

        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you really want to cancel this Payment?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Cancel Payment',
            cancelButtonText: 'Close',
            customClass: {
                confirmButton: "btn btn-danger me-2", 
                cancelButton: "btn btn-warning"
            },
            buttonsStyling: false,
        }).then((result) => {
            if (result.isConfirmed) {
                var url = "{{ route('franchise.cancel_invoice_payment') }}"; 
                $.ajax({
                    url: url,
                    type: 'POST',
                    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                    data: {
                            id_franchise_orders: id,
                            id_account_vouchers: id_account_vouchers,
                        },
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.message);
                                $(this_btn).closest('tr').remove();
                                $('#franchise_order_table').DataTable().ajax.reload();
                            } else {
                                toastr.error(response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            toastr.error('An error occurred while cancelling the voucher.');
                        }
                    });        
                                    
            }
        });

    }

    document.getElementById("btn_reset_filters").addEventListener("click", function () {
    // Select2 dropdown reset
        $('#franchise_id').val("All").trigger("change");
        $('#order_status').val("All").trigger("change");
    });
</script>
@endsection