@extends('layouts.horizontal', ['title' => 'Franchise Order Invoice', 'topbarTitle' => 'Franchise Order Invoice', 'nonav' => true])

@section('css')
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@endsection

@section('content')
<?php $editable=false; if($order[0]['order_status']=='Open'){$editable=true;}?>

@can('create_invoice-Franchise_Orders')



<div class="row">
    <div class="col-12">
        <div class="card position-relative">
            <form>
                <div class="card-body">
                    <!-- Invoice Logo-->
                    <div class="d-flex align-items-start justify-content-between">
                         <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72x;">
                            <img style="height: 72px;" id="logo" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>     
                        <div class="text-end">
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="franchise_id" class="col-form-label fs-16 fw-bold">#Franchise ID</label>
                                </div>
                                <div class="col-auto">
                                    <input type="number" step="any" id="franchise_id" class="form-control border-0" readonly="readonly" placeholder="00001234" value="{{$order_detail->franchise_id}}">
                                </div>
                            </div>

                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="invoice_date" class="col-form-label fs-16 fw-bold">INVOICE DATE </label>
                                </div>
                                <div class="col-auto">
                                    <input type="date" id="invoice_date" class="form-control border-0"  placeholder="00001234" value="{{$order_detail->order_date}}">
                                </div>
                            </div>
                            {{-- <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="franchise_order_id" class="col-form-label fs-16 fw-bold">INVOICE # </label>
                                </div>
                                <div class="col-auto">
                                    <input type="text" id="franchise_order_id" class="form-control border-0" readonly="readonly" placeholder="00001234" value="{{$order_detail->id_franchise_orders}}">
                                </div>
                            </div>--}}
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="franchise_order_id" class="col-form-label fs-16 fw-bold">VENDOR INVOICE SEQ </label>
                                </div>
                                <div class="col-auto">
                                    <input type="text" step="any" id="invoicenumber" class="form-control border-0" readonly="readonly" placeholder="00001234" value="{{$franchiseinvoicenumber->invoice_number}}">
                                </div>
                            </div> 

                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6 col-md-8 col-sm-12 mt-0">
                            <table class="table table-borderless">
                                <tbody>
                                    <tr class="p-0">
                                        <th class="py-1" style="width:150px;">Franchise Name</th>
                                        <td class="py-1">
                                            <input type="text" id="BName" readonly class="form-control border-0 p-0"
                                                value="{{$franchise->franchise_name}}">
                                        </td>
                                    </tr>

                                    <tr class="p-0">
                                        <th class="py-1">Owner</th>
                                        <td class="py-1">
                                            <input type="text" id="Owner" readonly class="form-control border-0 p-0"
                                                value="{{$franchise->franchise_owner}}">
                                        </td>
                                    </tr>

                                    <tr class="p-0">
                                        <th class="py-1">Phone Number</th>
                                        <td class="py-1">
                                            <input type="text" id="BNumber" readonly class="form-control border-0 p-0"
                                                value="{{$franchise->franchise_office_phone}}">
                                        </td>
                                    </tr>

                                    <tr class="d-print-none p-0">
                                        <th class="py-1">Address</th>
                                        <td class="py-1">
                                            <textarea readonly rows="1" id="BAddress" class="form-control border-0 p-0">{{$franchise->franchise_address}}</textarea>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                        </div>
                    </div>

                    <div class="mt-1">
                        <div class="table">
                            <table class="table text-center  mb-0 table-sm w-100 fs-12" id="tblproducts">
                                <thead>
                                    <tr class="bg-light bg-opacity-50">
                                    <th scope="col" class="border-0 d-print-none" >#</th>
                                    <th scope="col" class="border-0 d-print-none" >Brand</th>
                                    <th scope="col" class="border-0 d-print-none" >Item</th>
                                    <th scope="col" class="border-0 d-print-none d-none" >Batch</th>
                                    <th scope="col" class="border-0 d-print-none" >Sold by</th>
                                    
                                    <th scope="col" class="border-0 d-print-none" >Unit Price</th>
                                    <th>Qty.</th>
                                    <th scope="col" class="border-0 d-print-none text-end" >Total Price</th>
                                    <th scope="col" class="border-0 d-print-none text-end">Total Discount</th>
                                    <th scope="col" class="border-0 d-print-none text-end">Discount(%)</th>
                                    <th scope="col" class="border-0 d-print-none text-end">Total Price</th>
                                    <th scope="col" class="border-0 d-print-none text-end">Tax Rate</th>
                                    <th scope="col" class="border-0 d-print-none text-end">Tax Value</th>
                                    <th scope="col" class="border-0 d-print-none text-end">Value Inclusive of Tax</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $subtotal=0; if(isset($order)){
                                    $x=1; $total_price_bf_tax=0; $total_price_with_tax=0; $total_tax=0; $tax_perc=0; $totalproduct_discount=0; $total_qty =0;
                                    foreach($order as $product){
                                        $subtotal=$subtotal + ($product['unit_price']*$product['qty']); 
                                        $total_qty +=$product['qty'];
                                    ?>
                                    <tr id="idtr">
                                        <td fpid="<?php echo $product['id_franchise_order_products']; ?>"  data-month="<?php echo $product['order_month'] ?>" data-year="<?php echo $product['order_year'] ?>"><input type="hidden" id="product_id" name="product_id" class="product_id" value="<?php echo $product['product_id'];?>"><?php echo $x;?></td>
                                        <td ><?php echo $product['business_brand_name']; ?></td>
                                        <?php 
                                            $dateObj   = DateTime::createFromFormat('!m', intval($product['order_month']));
                                            $monthName = $dateObj->format('F');
                                        ?>
                                        <td data-product_detail="<?php echo $product['product_detail']; ?>"><span class="productname"><?php echo $product['product_name']; ?> <?php echo $product['product_detail'];?></span>&nbsp;<span class="category"><?php echo $product['product_type']=='Subscription' ? $monthName.'-'.$product['order_year'] :  ' ';?></span></td>
                                        <td class="d-none">
                                            <input type="hidden" id="batch_id" name="batch_id" value="<?php echo $product['batch_id'];?>">
                                            <input type="hidden" id="batch" name="batch" value="<?php echo $product['batch'];?>">
                                            <input type="hidden" id="batch_amount" name="batch_amount" value="<?php echo $product['batch_amount'];?>">
                                            <?php echo $product['batch']; ?>
                                        </td>
                                        <td class="" data-staff_id ="<?php echo $product['staff_id']; ?>"><?php echo $product['staff_name']; ?></td>
                                        <td class="text-end"><?php echo $product['unit_price']; ?></td>
                                        <td><?php echo $product['qty']; ?></td>
                                        <td class="text-end"><?php echo $product['unit_price']*$product['qty']; ?></td>                                                            
                                        <td class="text-end"><?php echo $product['unit_discount']*$product['qty']; ?></td>
                                        <?php $totalproduct_discount = $totalproduct_discount + ($product['unit_discount']*$product['qty']);?>
                                        <td class="text-end" ><span id="disc_perc"><?php if($product['unit_price']>0) {echo number_format((($product['unit_discount']*$product['qty'])*100)/($product['unit_price']*$product['qty']),2);} else{ echo '0';}?></span>%</td>
                                        <td class="text-end" combat = '<?php echo $product['discounted_price']; ?>'>{{  config('constants.CURRENCY') }}<span class="combat" id="unitcost<?php echo $product['product_id']; ?>"><?php echo $product['discounted_price']; ?></span></td>
                                        
                                        <?php if(defined('FRANCHISE_TAX')){ if(FRANCHISE_TAX=="after"){?>
                                            <td  class="tax_perc text-end"><input onchange="document.getElementById(<?php echo $product['id_franchise_order_products'];?>).value=<?php echo $product['discounted_price']; ?>*this.value/100; updatetotal_new();" name='tax_perc' style="width:50px; border:none; text-align:right;" value="<?php echo $product['product_sales_tax'];?>"></td>
                                        <?php } else {?>
                                            <td class="tax_perc text-end"><input onchange="document.getElementById(<?php echo $product['id_franchise_order_products'];?>).value=<?php echo $product['discounted_price']; ?>*this.value/100; updatetotal_new();" name='tax_perc' style="width:50px; border:none; text-align:right;" value="<?php echo $product['product_sales_tax'];?>"></td>
                                        <?php } } else { ?>  
                                           <td  class="tax_perc text-end"><input onchange="document.getElementById(<?php echo $product['id_franchise_order_products'];?>).value=<?php echo $product['discounted_price']; ?>*this.value/100; updatetotal_new();" name='tax_perc' style="width:50px; border:none; text-align:right;" value="<?php echo $product['product_sales_tax'];?>"></td>
                                        <?php } ?>
                                        <?php $total_price_bf_tax = $total_price_bf_tax + $product['discounted_price']; ?>
                                        <?php if($order[0]['order_status']=='Open'){?>
                                            <?php if(defined('FRANCHISE_TAX')){ if(FRANCHISE_TAX=="after"){?>
                                                <td class="text-end"><input id="<?php echo $product['id_franchise_order_products'];?>" style="text-align:right; border:none; width:70px;" onchange="updatetotal_new();" name="product_tax" value="<?php  $product_price=$product['discounted_price']; if($product_price > 0){ $product_tax = $product_price*$product['product_sales_tax']/100; } else { $product_tax = 0;} echo $product_tax; ?>"></td>
                                            <?php } else {?>
                                                <td class="text-end"><input id="<?php echo $product['id_franchise_order_products'];?>" style="text-align:right; border:none; width:70px;" onchange="updatetotal_new();" name="product_tax" value="<?php  $product_price= $product['discounted_price']; if($product_price > 0){ $product_tax = $product_price*$product['product_sales_tax']/100; } else { $product_tax = 0;} echo $product_tax; ?>"></td>
                                            <?php } } else { ?>    
                                                <td class="text-end" ><input id="<?php echo $product['id_franchise_order_products'];?>" style="text-align:right; border:none; width:70px;" onchange="updatetotal_new();" name="product_tax" value="<?php  $product_price=$product['discounted_price']; if($product_price > 0){ $product_tax = $product_price*$product['product_sales_tax']/100; } else { $product_tax = 0;} echo $product_tax; ?>"></td>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <td class=" text-end"><input style="text-align:right; border:none; width:70px;" readonly="readonly"  name="product_tax" value="<?php echo $product['product_tax']; ?>"></td>
                                        <?php $product_tax =  $product['product_tax'];} ?>
                                        <td class="text-end"><?php echo number_format($product['discounted_price']+$product_tax,2);?></td>
                                        <?php $total_tax=$total_tax + $product_tax;?>
                                        <?php $total_price_with_tax = $total_price_with_tax + $product['discounted_price']+$product_tax;?>
                                    </tr>
                                    <?php $x++;}} ?> 
                         
                                </tbody>
                                <tfoot>
                                <th colspan=4></th>
                                <th></th>                                                    
                                <th><?php echo number_format($total_qty,2);?></th>                                                    
                                <th></th>                                                    
                                <th class="text-end"><?php echo number_format($totalproduct_discount,2);?></th>
                                <th class="text-end"  ></th>
                                <th class="text-end"><?php echo number_format($total_price_bf_tax,2);?></th>
                                <th></th>
                                <th class="taxtotal text-end"><?php echo number_format($total_tax,2);?></th>
                                <th class="footer_total_with_tax text-end" ><?php echo number_format($total_price_with_tax,2);?></th>                                                    
                            </tfoot>
                            </table>
                            
                        </div>
                        <div class="row  d-print-none">
                            <div class="col-6 mt-4 d-print-none">
                                <div class="row">
                                </div>
                                <div>
                                    <label class="form-label" for="InvoiceNote"> Note : </label>
                                    <textarea class="form-control" id="InvoiceNote" placeholder="Any Information you need to save with the invoice . . . " rows="3"></textarea>
                                </div>
                            </div>
                            <div class="col-6">
                                <table class="table table-sm table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:300px">
                                    <tbody>
                                        {{----------------- SUB TOTAL----------------------}}
                                        <tr>
                                            <td class="fw-medium">Subtotal {{  config('constants.CURRENCY') }} {{$subtotal}}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" id="txt_org_subtotal" name="txt_org_subtotal" readonly="readonly" class="form-control text-end" placeholder="0.00" disabled  value="{{ number_format((float)$subtotal, 2, '.', '') }}">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Product Discount {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" id="txtproductdiscount" readonly="readonly" class="form-control text-end" placeholder="0.00" value="0">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th class="fw-bold">After Product Discount {{  config('constants.CURRENCY') }}</th>
                                            <th class="text-end ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" id="txtsubtotal" readonly="readonly" class="form-control text-end" placeholder="0.00" disabled value="<?php echo number_format((float)$subtotal, 2, '.', '');?>">
                                                </div>
                                            </th>
                                        </tr>
                                    
                                        <tr>
                                            <td class="fw-medium">Discount % {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input <?php if($editable==false){echo " readonly='readonly' "; }?>  type="text" id="discount_in_percent" class="form-control text-end" placeholder="0.00" value="<?php echo $order[0]['invoice_discount_perc']; ?>">
                                                </div>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td class="fw-medium">Discount  {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input <?php if($editable==false){echo " readonly='readonly' "; }?>  type="text" id="txtdiscount" class="form-control text-end" placeholder="0.00" value="<?php echo $order[0]['invoice_discount']; ?>">
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr>
                                            <td class="fw-medium">Other Charges {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input <?php if($editable==false){echo " readonly='readonly' "; }?>  type="text" id="txtothercharges" onchange="updatetotal_new()" class="form-control text-end" placeholder="0.00" value="<?php echo $order[0]['invoice_other_charges']; ?>">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <td class="fw-bold">Amount Exclusive of Taxes {{  config('constants.CURRENCY') }} </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input  type="text" readonly="readonly" id="txtgross" class="form-control text-end" placeholder="0.00" disabled value="<?php echo $order[0]['invoice_gross_total']; ?>">
                                                </div>
                                            </td>
                                        </tr> 

                                        <tr>
                                            <td class="fw-medium">Amount of Product Sales Tax {{  config('constants.CURRENCY') }} </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" readonly="readonly" id="txtsalestax" class="form-control text-end" placeholder="0.00" value="<?php echo $order[0]['invoice_sales_tax']; ?>">
                                                </div>
                                            </td>
                                        </tr> 

                                        <tr>
                                            <td class="fw-medium">Sales Taxes (%) {{  config('constants.CURRENCY') }} </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" <?php if($editable==false){ ?>readonly="readonly"<?php } ?>  onchange="calctaxfromperc()" id="txttaxfromperc" class="form-control text-end" placeholder="0.00" value="<?php echo $order[0]['invoice_sales_tax_perc']; ?>">
                                                </div>
                                            </td>
                                        </tr>
                                         
                                        <tr>
                                            <td class="fw-medium">Amount of Sales Taxes {{  config('constants.CURRENCY') }} </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" readonly onchange="updatetotal_new()" id="txtothersalestax" class="form-control text-end" placeholder="0.00" value="<?php echo $order[0]['invoice_sales_tax']; ?>">
                                                </div>
                                            </td>
                                        </tr>

                                        <tr class="fs-15">
                                            <td class="fw-bold fs-20 text-success">Amount Inclusive of Taxes {{  config('constants.CURRENCY') }} </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input readonly type="text" id="txttotalpayable" class="form-control text-end" placeholder="0.00" disabled value="<?php echo number_format($total_price_with_tax,2);?>">
                                                </div>
                                            </td>
                                        </tr> 



                                        <div id="witharrearsdiv" style="display:none;">    
                                            <p class="text-right">
                                                Arrears
                                                <input style="text-align: right; border:none;" readonly="readonly" class="decimal" id="arrears" class="form-inline" value="<?php if(isset($arrears)){echo $arrears->balance;}else{echo 0;}?>">
                                            </p>
                                            <hr>
                                            <p class="text-right" >
                                                Total Payable with Arrears
                                                <input style="text-align: right; border:none;" readonly="readonly" class="decimal" id="totalwitharrears" class="form-inline" value="">
                                            </p>
                                        </div>


                                    </tbody>
                                </table>
                            <!--end table-->

                            </div>
                        </div>
                    </div>
                    <div class="card-foorter d-print-none mt-4">
                        <div class="row">
                            <div class="col-6 text-end">
                            </div>   
                            <div class="col-md-3 text-end">
                                <a href="{{route('franchise.franchise_orders')}}" type="button" class="btn btn-primary">Go Back to Franchise Orders</a>
                            </div>
                            <div class="col-2 text-end">
                                <select id="business_store_id" name="business_store_id" class="form-select">  
                                    @foreach($stores as $store)
                                        <option  value="{{ $store->id_business_stores }}">{{ $store->business_store }} ({{ $store->business_name }})</option>
                                    @endforeach
                                </select>            
                            </div>
                            <div class="col-1 text-end">
                                <button id="btnsubmit" type="button" onclick="createinvoice();" class="btn btn-success gap-1"><span id="generateInvoiceSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span>  <i class="ti ti-device-floppy fs-16"></i> Save</button>
                            </div>
                        </div>

                    </div>
                </div> <!-- end card-body-->
            </form>
        </div><!-- end card -->
        
    </div>

</div>
@else
    <h1> {{ config('permission.not_allowed') }} </h1>
@endcan
@endsection

@section('scripts')
<script>
$(document).ready(function() {            

        $(".numeric").keypress(function (e) {
            //if the letter is not digit then display error and don't type anything
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && (e.which < 48 || e.which > 57)) {
               return false;
           }
        });
        $(".multinumeric").keypress(function (e) {
            //if the letter is not digit then display error and don't type anything
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && e.which != 44 && (e.which < 48 || e.which > 57)) {
               return false;
           }
        });
        $(".decimal").keypress(function(e) {
            //if the letter is not digit then display error and don't type anything
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && (e.which < 48 || e.which > 57) ) {
                
                return false;
            }
        });

        @if($editable==true)       
            updatetotal_new();
        @endif
        
        toastr.options = {
            "closeButton": true,
            "debug": true,
            "newestOnTop": true,
            "progressBar": true,
            "positionClass": "toast-bottom-center",
            "preventDuplicates": true,
            "onclick": null,
            "showDuration": "100",
            "hideDuration": "500",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
        
        $("#txtdiscount").change(function(){
            
            if($('#txtothercharges').val()===""){$('#txtothercharges').val(0);}
            var subtotalextra = parseFloat($('#txtsubtotal').val())+parseFloat($('#txtothercharges').val());
            var parcentage = (parseFloat($(this).val()) / subtotalextra) * 100;
            $('#discount_in_percent').val(parcentage.toFixed(2));
            //$("#paid").val($("#grandtotal").val());
            //$("#balanceamount").val(parseFloat($("#grandtotal").val()) - parseFloat($("#paid").val()));
            updatetotal_new();
            
        });
        $("#discount_in_percent").change(function(){
            
            if($('#txtothercharges').val()===""){$('#txtothercharges').val(0);}
            var subtotalextra = parseFloat($('#txtsubtotal').val())+parseFloat($('#txtothercharges').val());
            var discount = (parseFloat($(this).val()) * subtotalextra) / 100;
            $('#txtdiscount').val(Math.round(discount));
            //$("#paid").val($("#grandtotal").val());
            //$("#balanceamount").val(parseFloat($("#grandtotal").val()) - parseFloat($("#paid").val()));
            updatetotal_new();
            
        });
        $("#tax_in_perc").change(function(){
            
            var grosstotal = parseFloat($('#txtgross').val());
            var salestax = (parseFloat($(this).val()) * grosstotal) / 100;
            $('#txtothersalestax').val(Math.round(salestax));
            //$("#paid").val($("#grandtotal").val());
            //$("#balanceamount").val(parseFloat($("#grandtotal").val()) - parseFloat($("#paid").val()));
            updatetotal_new();
            
            
        });

});

         
    function updatetotal(){
        
        if($('#txtdiscount').val()===""){$('#txtdiscount').val('0');}
        if($('#txtothercharges').val()===""){$('#txtothercharges').val('0');}
        if($('#arrears').val()===""){$('#arrears').val('0');}
        
        
        var grosstotal=(parseFloat($("#txtsubtotal").val()) +  parseFloat($("#txtothercharges").val())) - parseFloat($("#txtdiscount").val());
        var taxabletotal=(parseFloat($("#txtsubtotal").val()) +  parseFloat($("#txtothercharges").val())) - parseFloat($("#txtdiscount").val());
        var orggrosstotal = parseFloat($("#txt_org_subtotal").val()) +  parseFloat($("#txtothercharges").val());
        var arrears = $('#arrears').val();
        
        
        $("#txtgross").val(grosstotal);
        
         var salestax = (parseFloat($('#tax_in_perc').val()) * grosstotal) / 100;
         $('#txtsalestax').val(Math.round(salestax));
       
        var totalpayable=grosstotal + parseFloat(salestax);
        $("#txttotalpayable").val(Math.round(totalpayable*100)/100);
        $("#grandtotal").val(Math.round(grosstotal));
        
        
        $("#totalwitharrears").val(Math.round(totalpayable+parseFloat(arrears)));
        
        $('#btnsubmit').removeClass('disabled');
        
        if(parseFloat($("#txtsalestax").val()) > 0){
            $("#saledtaxtag").show();
        }else {
            $("#saledtaxtag").hide();
        }
        
        showhidearrears();
    }
    
    function showhidearrears(){
        if($("#showarrears").is(":checked")){
           $("#witharrearsdiv").show();
           $("#totalwitharrears").val(Math.round(parseFloat($("#txttotalpayable").val()) + parseFloat($("#arrears").val())));
        }else{
            $("#witharrearsdiv").hide();
        }
        
    }
    
    function invoice_storeOTblValues(){
    
        var TableData = new Array();
        $('#tblproducts tr').each(function(row, tr) {
            TableData[row] = {
                "id_franchise_order_products": $(tr).find('td:eq(0)').attr('fpid'),
                "month": $(tr).find('td:eq(0)').attr('data-month'),
                "year": $(tr).find('td:eq(0)').attr('data-year')
                , "seq": $(tr).find('td:eq(0)').text()
                , "productid": $(tr).find('td:eq(0) input').val()
                , "brandname": $(tr).find('td:eq(1)').text()
                , "productname": $(tr).find('td:eq(2) .productname').text()
                , "product_detail": $(tr).find('td:eq(2)').attr('data-product_detail')
                , "category": $(tr).find('td:eq(2) .category').text()
                , "batch_id": $(tr).find('td:eq(3) #batch_id').val()
                , "batch": $(tr).find('td:eq(3) #batch').val()
                , "batch_amount": $(tr).find('td:eq(3) #batch_amount').val()
                , "staff_name": $(tr).find('td:eq(4)').text()
                , "staff_id": $(tr).find('td:eq(4)').attr('data-staff_id')
                , "unit_price": $(tr).find('td:eq(5)').text()
                , "qty": $(tr).find('td:eq(6)').text()
                , "product_price": $(tr).find('td:eq(7)').text()
                , "product_discount": $(tr).find('td:eq(8)').text()
                , "discount_perc": $(tr).find('td:eq(9) #disc_perc').text()
                , "discounted_price": $(tr).find('td:eq(10) .combat').text()
                , "tax_perc": $(tr).find('td:eq(11)').find('input[name=tax_perc]').val()
                , "product_tax": $(tr).find('td:eq(12)').find('input[name=product_tax]').val()
                , "final_price": $(tr).find('td:eq(13)').text()
            }
        });
        TableData.shift();  // first row will be empty - so remove
        TableData.pop();  // last row will be empty - so remove
        //console.log(TableData); 
        return TableData;
    }
    
    function createinvoice(){
    
            create_new_invoice();   
        
    }

    function create_new_invoice(){
        
        var TableData;
            TableData = invoice_storeOTblValues();
            TableData = JSON.stringify(TableData);
        $('#btnsubmit').addClass('disabled');
        $('#btnsubmit').html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>');
        $.ajax({
            type: 'POST',
            url: '{{route('franchise.save_franchise_invoice')}}',
            headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}' 
            },
            data: {
                tabledata: TableData,
                franchise_id: $("#franchise_id").val(),   
                franchise_address: $("#BAddress").val(),   
                franchise_phone: $("#BNumber").val(),   
                franchise_name: $("#BName").val(),   
                orderid:@json($order_id),   
                orgsubtotal:$("#txt_org_subtotal").val(),
                discount:$("#txtdiscount").val(),                
                discount_perc: $('#discount_in_percent').val(),
                product_discount: $("#txtproductdiscount").val(),
                other_charges: $('#txtothercharges').val(),
                
                grosstotal:$("#txtgross").val(),
                
                tax_in_perc:$("#txttaxfromperc").val(), 
                salestax:$("#txtsalestax").val(),    
                othertax:$("#txtothersalestax").val(),    

                grandtotal:$("#grandtotal").val(),
                totalpayable:$("#txttotalpayable").val(),

            
                remarks: $("#InvoiceNote").val(),
                invoicedate: $("#invoice_date").val(),
                invoicenumber : $("#invoicenumber").val(),
                store_id : $("#business_store_id").val()
            },
            success: function(data) {
                $('#btnsubmit').removeClass('disabled');
                $('#btnsubmit').html('<i class="ti ti-device-floppy fs-16"></i> Save');
                if (data.success) {
                    toastr.success(data.message, 'Done!'); 
                    setTimeout(() => {
                        window.location.href = data.franchise_print_url;                             
                    }, 500);
                } else {
                    let shortageHtml = "";
                    if (data.data && data.data.length > 0) {
                        shortageHtml += `
                            <table class="table table-bordered text-start" style="font-size:14px;">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Product</th>
                                        <th>O.Qty</th>
                                        <th>Avail</th>
                                        <th>Short</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                        data.data.forEach(item => {
                            shortageHtml += `
                                <tr>
                                    <td><a href="${item.product_batch_route}" target="_blank">${item.productid}</a></td>
                                    <td><a href="${item.product_batch_route}" target="_blank">${item.productname}</a></td>
                                    <td>${item.required_qty}</td>
                                    <td>${item.available_qty}</td>
                                    <td class="text-danger fw-bold">${item.shortage}</td>
                                </tr>
                            `;
                        });
                        shortageHtml += `</tbody></table>`;
                    }
                    Swal.fire({
                        icon: data.message_type,
                        title: data.message,
                        width: '40%',
                        html: `
                            <div style="text-align:left;">
                                ${shortageHtml}
                            </div>
                        `,
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                }
            },
           error: function(xhr, status, error) {
                $('#btnsubmit').removeClass('disabled');
                $('#btnsubmit').html('<i class="ti ti-device-floppy fs-16"></i> Save');
                console.error('AJAX Error:', error);
            }
        });
        
        $("#txtdiscount").attr("readonly",true);
        $("#discount_in_percent").attr("readonly",true);
        $(".discount_by_product").attr("readonly",true);
        $(".perc_discount_product").attr("readonly",true);    
        
    }

    function updatetotal_new(){

        var totalproductdiscount=0;
        var totalorgtotal=0;
        var totaltax=0;
        var totalwithtax=0;
        $('#tblproducts tr').each(function(row, tr) {   
            if($(tr).find('td:eq(0)').text() != '#' && $(tr).find('td:eq(0)').text() != ''){
                
                totalproductdiscount = totalproductdiscount + parseFloat($(tr).find('td:eq(8)').text());            
                totalorgtotal = totalorgtotal + parseFloat($(tr).find('td:eq(7)').text());
                totalorgtotal=Math.round(totalorgtotal * 100)/100;
                var thisprice = parseFloat( $(tr).find('td:eq(10)').find('span[class=combat]').html());
                var thistax = parseFloat( $(tr).find('td:eq(12)').find('input[name=product_tax]').val())
                totaltax = totaltax + thistax;

                // console.log(thisprice,"thisprice");
                // console.log(thistax,"thistax");

                var thisperc = thisprice > 0 ?  Math.round((100 * thistax / thisprice)*100)/100 : 0;

                $(tr).find('td:eq(11)').find('input[name=tax_perc]').val(parseFloat(thisperc).toFixed(2));
                $(tr).find('td:eq(13)').text( parseFloat(thistax+thisprice).toFixed(2))

                totalwithtax =totalwithtax + parseFloat(thistax+thisprice);
            }
        });

    
        $(".taxtotal").html(Math.round(totaltax*100)/100);

        $("#txt_org_subtotal").val(Math.round(totalorgtotal * 100)/100 );
        
        var subtotal = parseFloat($("#txt_org_subtotal").val(totalorgtotal));
        $("#txtproductdiscount").val(totalproductdiscount);

        $("#txtsubtotal").val(parseFloat(totalorgtotal - totalproductdiscount).toFixed(2));

        var additional_discount = parseFloat($("#txtdiscount").val());
        var other_charges =  parseFloat($("#txtothercharges").val());

        $("#txtsalestax").val(Math.round(totaltax*100)/100);   
        //amount exclusive of taxes
        $("#txtgross").val(Math.round((totalorgtotal - totalproductdiscount - additional_discount + other_charges) *100)/100);
        var totalbeforetax = totalorgtotal - totalproductdiscount - additional_discount + other_charges;

        var othertaxes = parseFloat($("#txtothersalestax").val());

        $(".footer_total_with_tax").text(Math.round((totalbeforetax + totaltax + othertaxes)*100)/100);
        $("#txttotalpayable").val(Math.round((totalbeforetax + totaltax + othertaxes)*100)/100);
        $('#btnsubmit').removeClass('disabled');
        showhidearrears();
    }

    function calctaxfromperc(){
         $('#txtothersalestax').val( Math.round(($("#txtgross").val() * $("#txttaxfromperc").val()/100) ) );
        updatetotal_new();
    }
</script>
@endsection