@extends('layouts.horizontal', ['title' => 'Invoice', 'topbarTitle' => 'View Invoice', 'nonav' => true])
@section('css')
<style>
    .custom-padding{
        padding:0.35rem 0.2rem !important;
    }
</style>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body" >
                <!-- Invoice Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div>
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>     
                        <div class="mt-2">                            
                            <h6 class="fs-14 mb-0 lh-base font-monospace">{!! $business->business_address  !!} </h6>
                            <h6 class="fs-14 mb-2 font-monospace">Phone:  {{ $business->business_phone1  }} </h6>
                        </div>   
                         <div style="text-align: left;" class="mt-3">
                            <h6 class="fs-14 fw-bolder mb-0 font-monospace">{{$franchise->franchise_name}}</h6>
                            <h6 class="fs-14 mb-0 font-monospace">Owner {{$franchise->franchise_owner ?? ''}}</h6>
                            <h6 class="fs-14 mb-0 font-monospace">NTN {{$franchise->franchise_ntn ?? ''}}</h6>
                            @if (!empty($franchise->franchise_email))
                            <h6 class="fs-14 mb-0 font-monospace">{{$franchise->franchise_email}}</h6>
                            @endif
                            @if (!empty($franchise->franchise_office_phone))
                            <h6 class="fs-14 mb-0 font-monospace">{{$franchise->franchise_office_phone}}</h6>
                            @endif
                            <abbr class="fs-14 mb-2 font-monospace">{{$franchise->franchise_address ?? '' }}</abbr>
                         </div>                
                    </div>
                    <div class="text-end">                       
                            <span class="badge bg-danger-subtle text-danger px-1 fs-20 mb-3  font-monospace">invoice_status</span>
                            <h3 class=" m-0 fw-bolder fs-20 font-monospace">Invoice: #{{ $order_detail->invoice_number }}</h3>
                            <div style="text-align: left;" class="mt-3">
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Order: #{{ $order[0]['franchise_order_id'] }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Invoice Date: {{$order[0]['formatted_invoice_date']}}</h6>                        
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Due Date: {{$order[0]['due_date']}}</h6>                        
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Agent: {{$order_detail->created_by}}</h6>
                            </div>
                    </div>
                </div>

                <div class="mt-4">
                    <div class="table">
                        <table class="table text-left align-middle mb-0 font-monospace table-sm fs-12" style="overflow-x: hidden;">
                            <thead>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="text-start border-0" scope="col" >#</th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" >Brand</th>
                                    <th class="text-start border-0" scope="col" >Item</th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" >Batch</th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" >Sold by</th>
                                    
                                    <th class="text-end border-0" scope="col" >Unit Price</th>
                                    <th class="text-end border-0" scope="col">Qty.</th>
                                    <th class="text-end border-0" scope="col"  >Total Price</th>
                                    <th class="text-end border-0" scope="col">Total Disc</th>
                                    <th class="hidden-xs d-print-none text-end border-0" >Disc(%)</th>
                                    <th class="text-end border-0" scope="col" >Total Price</th>
                                    <th class="text-end border-0" scope="col" >Tax Rate</th>
                                    <th class="hidden-xs d-print-none text-end border-0">Tax Value</th>
                                    <th class="text-end border-0" scope="col">Value Inclusive of Tax</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $subtotal=0; if(isset($order)){
                            $x=1; $total_price_bf_tax=0; $total_price_with_tax=0; $total_tax=0; $tax_perc=0; $totalproduct_discount=0; $total_qty=0;
                            foreach($order as $product){
                                $subtotal=$subtotal + ($product['unit_price']*$product['qty']);  
                                $total_qty +=$product['qty'];                                                     
                            ?>
                            <tr id="idtr">
                                <td>{{ $x}}</td>
                                <td class="hidden-xs d-print-none text-start border-0">{{$product['business_brand_name']}}</td>
                                <?php 
                                    $dateObj   = DateTime::createFromFormat('!m', intval($product['order_month']));
                                    $monthName = $dateObj->format('F');
                                ?>
                                <td>{{$product['product_name']}}{{$product['product_detail']}} {{$product['product_type']=='Subscription' ? $monthName.'-'.$product['order_year'] :  '' }} </td>
                                <td class="hidden-xs d-print-none text-start border-0">
                                    {{$product['batch']}}
                                </td>
                                <td class="hidden-xs d-print-none text-start border-0">{{$product['staff_name']}}</td>
                                <td class="text-end">{{ $product['unit_price']}}</td>
                                <td class="text-end">{{$product['qty']}}</td>
                                <td class="text-end">{{$product['unit_price']*$product['qty']}}</td>                                                            
                                <td class="text-end">{{$product['unit_discount']*$product['qty']}}</td>
                                <?php $totalproduct_discount = $totalproduct_discount + ($product['unit_discount']*$product['qty']);?>
                                <td class="hidden-xs d-print-none text-end border-0" ><?php if($product['unit_price']>0) {echo number_format((($product['unit_discount']*$product['qty'])*100)/($product['unit_price']*$product['qty']),2);} else{ echo '0';}?>%</td>
                                <td class="text-end">{{$product['discounted_price']}}</td>
                                <td class="text-end">
                                    <?php
                                    if ($order[0]['order_status'] === 'Open') {
                                        echo $product['product_sales_tax'];
                                    } else {
                                        echo ($product['discounted_price'] > 0)
                                            ? round(($product['product_tax'] * 100) / $product['discounted_price'], 2)
                                            : 0;
                                    }
                                    ?>
                                </td>

                                <?php $total_price_bf_tax = $total_price_bf_tax + $product['discounted_price']; ?>
                                <td class="hidden-xs d-print-none text-end border-0">{{$product['product_tax']}}</td>
                                <?php $product_tax =  $product['product_tax'];?>
                                <td class="text-end">{{number_format($product['discounted_price']+$product_tax,2)}}</td>
                                <?php $total_tax=$total_tax + $product_tax;?>
                                <?php $total_price_with_tax = $total_price_with_tax + $product['discounted_price']+$product_tax;?>
                            </tr>
                            <?php $x++;}} ?>
                            </tbody>
                            <tfoot>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="text-start border-0" scope="col" ></th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" ></th>
                                    <th class="text-start border-0" scope="col" ></th>
                                    <th class="hidden-xs d-print-none text-start border-0"></th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" ></th>
                                    
                                    <th class="text-end border-0" scope="col"></th>
                                    <th class="text-end border-0" scope="col">{{number_format($total_qty,2)}}</th>
                                    <th class="text-end border-0" scope="col">{{number_format($subtotal,2)}}</th>
                                    <th class="text-end border-0" scope="col">{{number_format($totalproduct_discount,2)}}</th>
                                    <th class="hidden-xs d-print-none text-end border-0"></th>
                                    <th class="text-end border-0" scope="col">{{number_format($total_price_bf_tax,2)}}</th>
                                    <th class="text-end border-0" scope="col"></th>
                                    <th class="hidden-xs d-print-none text-end border-0">{{number_format($total_tax,2)}}</th>
                                    <th class="text-end border-0" scope="col">{{number_format($total_price_with_tax,2)}}</th>
                               </tr>
                            </tfoot>
                        </table>                   
                    </div>
                    <div>
                        <table class="table table-nowrap align-middle mb-0 ms-auto font-monospace" style="width:335px">
                            <tbody>         
                                <tr>
                                    <td class="fw-bolder custom-padding">SubTotal</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format($subtotal,2)}}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bolder custom-padding">Product Discount</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format($totalproduct_discount,2)}}</td>
                      
                                </tr>
                                @if (isset($order[0]['invoice_discount']) && $order[0]['invoice_discount'] > 0)
                                    <tr>
                                        <td class="fw-bolder custom-padding">Invoice Discount <span class="invoice_discount_perc">{{($order[0]['invoice_discount_perc'] ?? 0)}}</span>%</td>
                                        <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format($order[0]['invoice_discount'] ?? 0 ,2)}}</td>
                                   </tr>
                                @endif
                                @if (isset($order[0]['invoice_other_charges']) && $order[0]['invoice_other_charges'] > 0)
                                <tr>
                                    <td class="fw-bolder custom-padding">Other Charges</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format($order[0]['invoice_other_charges'] ?? 0 ,2)}}</td>
                      
                                </tr>
                                @endif
                                <tr>
                                    <td class="fw-bolder custom-padding">Amount Exclusive of Taxes</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format( ((($order[0]['invoice_other_charges'] ?? 0)+$total_price_bf_tax) - ($order[0]['invoice_discount'] ?? 0) ) ,2)}}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bolder custom-padding">Amount of Product Sales Tax </td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format($total_tax ,2)}}</td>
                                </tr>
                                <tr style="border-bottom: 2px dashed #000 !important; ">
                                    <td class="fw-bolder custom-padding">Amount of Sales Taxes {{number_format($order[0]['invoice_sales_tax_perc'] ?? 0 ,2)}}% </td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{number_format($order[0]['invoice_sales_tax'] ?? 0 ,2)}}</td>
                                </tr>

                                 <tr  class="border-top border-top-dashed fs-16">
                                    <td class="fw-bold custom-padding">Amount Inclusive of Taxes</td>
                                    <td class="fw-bold text-end custom-padding">{{config('constants.CURRENCY')}} {{number_format($order[0]['invoice_total_receivable'] ?? 0 ,2)}}</td>
                                </tr>

                                <?php $total_arrears =0; if(isset($arrears)){ $total_arrears = $arrears->balance;}?>
                                <tr  class="border-top border-top-dashed fs-16 witharrearsdiv d-none">
                                    <td class="fw-bold custom-padding">Arrears</td>
                                    <td class="fw-bold text-end custom-padding">{{config('constants.CURRENCY')}} {{number_format($total_arrears ?? 0 ,2)}}</td>
                                </tr>
                                <?php  $final_payable_with_arrears = ($total_arrears)+($order[0]['invoice_total_receivable'] ?? 0); ?>
                                <tr  class="border-top border-top-dashed fs-16 witharrearsdiv d-none">
                                    <td class="fw-bold custom-padding">Total Payable with Arrears</td>
                                    <td class="fw-bold text-end custom-padding">{{config('constants.CURRENCY')}} {{number_format($final_payable_with_arrears ?? 0 ,2)}}</td>
                                </tr>

                            </tbody>
                        </table>
                        <!--end table-->
                    </div>
                </div>

                <div class="card-body">
                    @if (!empty($franchise->franchise_payment_terms))
                        <div class="bg-body p-2 rounded-2 mt-4 mb-4  font-monospace">
                            <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Terms : </span>
                                {!!  $franchise->franchise_payment_terms ?? '' !!}
                            </p>
                        </div>
                    @endif
                    
                <div class="d-print-none mb-5">
                    <div class="d-flex justify-content-center gap-2">
                        <input onclick="showhidearrears();" type="checkbox" class="form-check-input" id="showarrears" style="width: 16px; height:16px;">
                        <label class="form-check-label" for="showarrears">Show Arrears</label>
                        <a href="{{route('franchise.franchise_orders')}}" type="button" class="btn btn-success">Go Back to Franchise Orders</a>
                        @if (isset($order[0]['franchise_order_id']) && $order[0]['franchise_order_id'] > 0 && $order[0]['order_status'] =='Invoiced') 
                        <button class="btn btn-danger" id="cancelInvoiceBtn" onclick="cancelFranchiseOrderInvoice({{ $order[0]['franchise_order_id'] }})" ><iconify-icon icon="solar:trash-bin-trash-bold-duotone"></iconify-icon> Cancel Invoice</button>
                        @php
                            $payment_receiving_note_url = route('franchise.payment_receiving_note', [
                                'order_id' => $order[0]['franchise_order_id']
                            ]); 
                        @endphp         
                        <a href="{{$payment_receiving_note_url}}" class="btn btn-success"  data-bs-toggle="tooltip" title="Receive Payment" ><iconify-icon icon="ph:money-wavy-thin" class="fs-20"></iconify-icon> Receive Payment</a>
                        @endif
                        <a href="javascript:window.print()" class="btn btn-primary"><i class="ti ti-printer me-1"></i> Print</a>
                    </div>
                </div>

                <!-- end link -->
                
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {

});    
function cancelFranchiseOrderInvoice(id){
        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you really want to cancel this invoice?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, Cancel Invoice',
            cancelButtonText: 'No, Close',
            customClass: {
                confirmButton: "btn btn-danger me-2",
                cancelButton: "btn btn-warning"
            },
            buttonsStyling: false,
        }).then((result) => {
            if (result.isConfirmed) {
                sendCancelRequest(id); // no need to pass result.value
            }
        });
    }

    function sendCancelRequest(id) {
        $.ajax({
            url: "{{ route('franchise.cancel_order_invoice') }}",
            type: "POST",
            headers: { "X-CSRF-TOKEN": "{{ csrf_token() }}" },
            data: {
                id_franchise_orders: id
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    setTimeout(() => {
                        window.location.href = response.franchise_orders_route;                             
                    }, 1000);
                } else if(response.message_type =='warning') {
                    toastr.warning(response.message || 'Unable to cancel invoice.');
                }else{
                    toastr.error(response.message || 'Unable to cancel invoice.');
                }
            },
            error: function() {
                toastr.error('An error occurred while cancelling the invoice.');
            }
        });
    }

    function showhidearrears() {
        if ($("#showarrears").is(":checked")) {
            $(".witharrearsdiv").removeClass("d-none");
        } else {
            $(".witharrearsdiv").addClass("d-none");
        }
    }
</script>
@endsection