@extends('layouts.horizontal', ['title' => 'Return Note', 'topbarTitle' => 'Return Note', 'nonav' => true])
@section('css')
<style>
    .custom-padding{
        padding:0.35rem 0.2rem !important;
    }
</style>
@endsection

@section('content')
<div class="row"> 
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex align-items-center justify-content-between">
                <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                </div> 
                <h4 class="card-title">New Return Note For Order #{{ $order[0]['franchise_order_id'] }}</h4>
            </div>
            <div class="card-body" >
                <!-- Invoice Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div>
                         <div style="text-align: left;" class="mt-3">
                            <h6 class="fs-14 fw-bolder mb-0 font-monospace">{{$franchise->franchise_name}}</h6>
                            <h6 class="fs-14 mb-0 font-monospace">NTN {{$franchise->franchise_ntn ?? ''}}</h6>
                            @if (!empty($franchise->franchise_email))
                            <h6 class="fs-14 mb-0 font-monospace">{{$franchise->franchise_email}}</h6>
                            @endif
                            @if (!empty($franchise->franchise_office_phone))
                            <h6 class="fs-14 mb-0 font-monospace">{{$franchise->franchise_office_phone}}</h6>
                            @endif
                            <abbr class="fs-14 mb-2 font-monospace">{{$franchise->franchise_address ?? '' }}</abbr>
                         </div>                
                    </div>
                    <div class="text-end"> 
                        @if (isset($order_detail->invoice_number) && !empty($order_detail->invoice_number))
                        <h3 class=" m-0 fw-bolder fs-20 font-monospace">Invoice: #{{ $order_detail->invoice_number }}</h3>
                        @endif                      
                        <div style="text-align: left;" class="mt-3">
                            <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Order: #{{ $order[0]['franchise_order_id'] }}</h6>
                            @if (isset($order[0]['formatted_invoice_date']) && !empty($order[0]['formatted_invoice_date']))
                            <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Invoice Date: {{$order[0]['formatted_invoice_date']}}</h6>                        
                            @endif
                            @if (isset($order[0]['due_date']) && !empty($order[0]['due_date']))
                            <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Due Date: {{$order[0]['due_date']}}</h6>
                            @endif
                            @if (isset($order[0]['created_by']) && !empty($order[0]['created_by']))
                            <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Agent: {{$order_detail->created_by}}</h6>
                            @endif

                            <input type="date" id="return_date" class="form-control mt-1"  placeholder="00001234" value="{{$order_detail->order_date}}">
                        </div>
                    </div>
                </div>

                <div class="mt-4">
                    <div class="table">
                        <table class="table text-left align-middle mb-0 font-monospace table-sm fs-12" style="overflow-x: hidden;" id="franchise_return_note_payment">
                            <thead>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="text-start border-0" scope="col" >#</th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" >Brand</th>
                                    <th class="text-start border-0" scope="col" >Item</th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" >Batch</th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" >Sold by</th>
                                    <th class="text-end border-0" scope="col" >Unit Price</th>
                                    <th class="text-center border-0 text-success" scope="col">Invoiced Qty.</th>
                                    <th class="text-center border-0 text-primary" scope="col">Already Returned.</th>
                                    <th class="text-center border-0 text-danger" scope="col">Return Qty.</th>
                                    <th class="text-end border-0" scope="col"  >Total Price</th>
                                    <th class="text-end border-0" scope="col">Unit Disc</th>
                                    <th class="hidden-xs d-print-none text-end border-0" >Disc(%)</th>
                                    <th class="text-end border-0" scope="col" >Total Price</th>
                                    <th class="text-end border-0" scope="col" >Tax(%)</th>
                                    <th class="hidden-xs d-print-none text-end border-0">Tax Value</th>
                                    <th class="text-end border-0" scope="col">Value Inclusive of Tax</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $subtotal=0; if(isset($order)){
                            $x=1; $total_price_bf_tax=0; $total_price_with_tax=0; $total_tax=0; $tax_perc=0; $totalproduct_discount=0; $total_qty=0; $already_returned_qty=0;
                            foreach($order as $product){
                                $subtotal=$subtotal + ($product['unit_price']*$product['qty']);  
                                $total_qty +=$product['qty'];                                                     
                            ?>
                            <tr id="idtr">
                                <td>{{ $x}} 
                                <input type="hidden" id="product_id" name="id_franchise_order_products" class="id_franchise_order_products" value="<?php echo $product['id_franchise_order_products']; ?>">
                                <input type="hidden" id="product_id" name="product_id" class="product_id" value="<?php echo $product['product_id'];?>">
                                <input type="hidden" id="batch_id" class="batch_id" name="batch_id" value="<?php echo $product['batch_id'];?>">
                                <input type="hidden" id="batch" class="batch" name="batch" value="<?php echo $product['batch'];?>">
                                <input type="hidden" id="batch_amount" class="batch_amount" name="batch_amount" value="<?php echo $product['batch_amount'];?>">

                                </td>
                                <td class="hidden-xs d-print-none text-start border-0">{{$product['business_brand_name']}}</td>
                                <?php 
                                    $dateObj   = DateTime::createFromFormat('!m', intval($product['order_month']));
                                    $monthName = $dateObj->format('F');
                                ?>
                                <td>{{$product['product_name']}}{{$product['product_detail']}} {{$product['product_type']=='Subscription' ? $monthName.'-'.$product['order_year'] :  '' }} </td>
                                <td class="hidden-xs d-print-none text-start border-0">
                                    {{$product['batch']}}
                                </td>
                                <td class="hidden-xs d-print-none text-start border-0">{{$product['staff_name']}}</td>
                                <td class="text-end unit_price">{{ $product['unit_price']}}</td>
                                <td class="text-center invoiced_qty text-success">{{$product['qty']}}</td>
                                <td class="text-center already_retured_qty text-primary">{{$product['already_retured_qty']}}</td>
                                <?php $already_returned_qty += $product['already_retured_qty'] ?? 0; ?>
                                <td class="text-center "><input style="width: 70px !important;" type="number" step="any" class="form-control return_qty text-center text-danger " oninput="calculation_of_product_table();" value="0"></td>
                                <td class="text-end unit_price_with_qty">{{$product['unit_price']*$product['qty']}}</td>                                                            
                                <td class="text-end unit_discount">{{$product['unit_discount']}}</td>
                                <?php $totalproduct_discount = $totalproduct_discount + ($product['unit_discount']*$product['qty']);?>
                                <td class="hidden-xs d-print-none text-end border-0 discount_perc" ><?php if($product['unit_price']>0) {echo ((($product['unit_discount']*$product['qty'])*100)/($product['unit_price']*$product['qty']));} else{ echo '0';}?>%</td>
                                <td class="text-end discounted_price">{{$product['discounted_price']}}</td>
                                <td  class="text-end product_tax_perc"><?php echo round( ($product['product_tax'] *100)/$product['discounted_price'], 2)?></td>
                                <?php $total_price_bf_tax = $total_price_bf_tax + $product['discounted_price']; ?>
                                <td class="hidden-xs d-print-none text-end border-0 product_tax_amount">{{$product['product_tax']}}</td>
                                <?php $product_tax =  $product['product_tax'];?>
                                <td class="text-end value_inclusive_of_tax">{{($product['discounted_price']+$product_tax)}}</td>
                                <?php $total_tax=$total_tax + $product_tax;?>
                                <?php $total_price_with_tax = $total_price_with_tax + $product['discounted_price']+$product_tax;?>
                            </tr>
                            <?php $x++;}} ?> 
                            <tfoot>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="text-start border-0" scope="col" ></th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" ></th>
                                    <th class="text-start border-0" scope="col" ></th>
                                    <th class="hidden-xs d-print-none text-start border-0"></th>
                                    <th class="hidden-xs d-print-none text-start border-0" scope="col" ></th>
                                    <th class="text-end border-0" scope="col"></th>
                                    <th class="text-center border-0 footer_qty text-success" scope="col">{{($total_qty)}}</th>
                                    <th class="text-end border-0 text-center text-primary" scope="col">{{ $already_returned_qty}}</th>
                                    <th class="text-center border-0 footer_return_qty text-danger" scope="col">{{($total_qty)}}</th>
                                    <th class="text-end border-0 footer_unit_price_with_qty" scope="col">{{($subtotal)}}</th>
                                    {{-- <th class="text-end border-0 footer_total_disc" scope="col">{{($totalproduct_discount)}}</th> --}}
                                    <th class="text-end border-0 footer_total_disc" scope="col"></th>
                                    <th class="hidden-xs d-print-none text-end border-0"></th>
                                    <th class="text-end border-0 footer_discounted_price" scope="col">{{($total_price_bf_tax)}}</th>
                                    <th class="text-end border-0" scope="col"></th>
                                    <th class="hidden-xs d-print-none text-end border-0 footer_tax_amount">{{($total_tax)}}</th>
                                    <th class="text-end border-0 footer_value_inclusive_of_tax" scope="col">{{($total_price_with_tax)}}</th>
                               </tr>
                            </tfoot>
                        </table>                   
                    </div>
                    <div>
                        <table class="table table-nowrap align-middle mb-0 ms-auto font-monospace" style="width:335px">
                            <tbody>         
                                <tr>
                                    <td class="fw-bolder custom-padding">SubTotal</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}}  <span class="subtotal">{{($subtotal)}}</span></td>
                                </tr>
                                <tr>
                                    <td class="fw-bolder custom-padding">Product Discount</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} <span class="total_product_disc">{{($totalproduct_discount)}}</span></td>
                      
                                </tr>
                                @if (isset($order[0]['invoice_discount']) && $order[0]['invoice_discount'] > 0)
                                    <tr>
                                        <td class="fw-bolder custom-padding">Invoice Discount <span class="invoice_discount_perc">{{($order[0]['invoice_discount_perc'] ?? 0)}}</span>%</td>
                                        <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} <span class="invoice_discount">{{($order[0]['invoice_discount'] ?? 0)}}</span></td>
                                   </tr>
                                @endif
                                @if (isset($order[0]['invoice_other_charges']) && $order[0]['invoice_other_charges'] > 0)
                                {{-- <tr>
                                    <td class="fw-bolder custom-padding">Other Charges</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} {{($order[0]['invoice_other_charges'] ?? 0)}}</td>
                      
                                </tr> --}}
                                @endif
                                <tr>
                                    <td class="fw-bolder custom-padding">Amount Exclusive of Taxes</td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} <span class="amount_exclusive_of_tax">{{( ((($order[0]['invoice_other_charges'] ?? 0)+$total_price_bf_tax) - ($order[0]['invoice_discount'] ?? 0) ))}}</span></td>
                                </tr>
                                <tr>
                                    <td class="fw-bolder custom-padding">Amount of Product Sales Tax </td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} <span class="amount_of_product_sales_tax">{{($total_tax)}}</span></td>
                                </tr>
                                <tr style="border-bottom: 2px dashed #000 !important; ">
                                    <td class="fw-bolder custom-padding">Amount of Sales Taxes <span class="invoice_tax_perc">{{($order[0]['invoice_sales_tax_perc'] ?? 0)}}</span>% </td>
                                    <td class="text-end fw-bolder custom-padding">{{config('constants.CURRENCY')}} <span class="invoice_sales_tax_amount">{{($order[0]['invoice_sales_tax'] ?? 0)}}</span></td>
                                </tr>

                                 <tr  class="border-top border-top-dashed fs-16">
                                    <td class="fw-bold custom-padding">Amount Inclusive of Taxes</td>
                                    <td class="fw-bold text-end custom-padding">{{config('constants.CURRENCY')}} <span class="amount_inclusive_of_tax">{{($order[0]['invoice_total_receivable'] ?? 0)}}</span></td>
                                </tr>
                            </tbody>
                        </table>
                        <!--end table-->
                    </div>
                </div>

                <div class="col-md-12 text-end mt-2">
                    <a href="{{route('franchise.franchise_orders')}}" type="button" class="btn btn-primary">Go Back to Franchise Orders</a>
                    @if($already_returned_qty > 0)
                        <button type="button" id="returnHistoryButton" onclick ="view_franchise_order_return_history({{$order[0]['franchise_order_id']}})" target="_blank" class="btn btn-secondary"><span id="generateReturnHistorySpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span>  <iconify-icon icon="line-md:watch-loop" class="fs-20 me-1"></iconify-icon>Return History</button>
                    @endif
                    <button id="btnsubmit" type="button" onclick="saveReturnNote();" class="btn btn-success gap-1"><span id="generateInvoiceSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span>  <i class="ti ti-device-floppy fs-16"></i> Save</button>
                </div>
                <!-- end link -->

            </div>
        </div>
    </div>
</div>

{{-- Modal for Return  History --}}
<div class="modal fade" id="invoice_payments_listing_modal" tabindex="-1" aria-labelledby="invoice_payments_listing_modal" aria-hidden="true">
    <div class="modal-dialog modal-full-width">
        <div class="modal-content ">
            <div class="modal-header">
                <h4 class="modal-title" >Return History For Franchise Order ID : <span id="FranchiseOrderIdForModal">{{$order[0]['franchise_order_id']}}</span> </h4>
                <button type="button" class="btn-close " data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

             <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 text-center mb-2">
                        <h2 class="text-center">Return History</h2>

                    </div>
                    <div class="col-1"></div>
                    <div class="col-10">
                          <div class="table-responsive">
                         <table class="table table-centered table-bordered table-nowrap mb-0 table-sm " id="invoice_payment_table">
                        <thead>
                            <tr>
                                <th>Sr#</th>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Total Return Qty</th>
                                <th>Created By</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <tfoot>
                            <tr>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th id="total_return_qty_for_footer"></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>

                    </div>
                    </div>
                     <div class="col-1"></div>
                </div>
              
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
{{-- End Modal --}}








@endsection

@section('scripts')
<script>
$(document).ready(function() {
calculation_of_product_table();
});    

function calculation_of_product_table(){

    var footer_return_qty =0;
    var footer_unit_price_with_qty =0;
    var footer_discounted_price =0;
    var footer_tax_amount =0;
    var footer_value_inclusive_of_tax =0;
    var footer_return_discount_amount=0;
    $("#franchise_return_note_payment tbody tr").each(function(){
      var unit_price =  parseFloat($(this).find('.unit_price').text() || 0);
      var invoiced_qty =  parseFloat($(this).find('.invoiced_qty').text() || 0);
      var already_retured_qty =  parseFloat($(this).find('.already_retured_qty').text() || 0);
      var return_qty =  parseFloat($(this).find('.return_qty').val() || 0);
      var unit_discount =  parseFloat($(this).find('.unit_discount').text() || 0);
      var product_tax_perc =  parseFloat($(this).find('.product_tax_perc').text() || 0);
      footer_return_qty +=return_qty;


          var allowed_qty = invoiced_qty - already_retured_qty;

        if (return_qty > allowed_qty) {

            Swal.fire({
                icon: 'warning',
                title: 'Quantity Limit Exceeded',
                text: "You cannot return more than remaining quantity. Allowed: " + allowed_qty,
                confirmButtonText: 'OK',
                customClass: { confirmButton: 'btn btn-warning' }
            });

            // Focus back to field
            $(this).find('.return_qty').val(0); 
            $(this).find('.return_qty').focus();

            return_qty =0;

            isValid = false;
            return false;   
        }


      var return_qty_with_unit_price =   (return_qty*unit_price);
      footer_unit_price_with_qty += return_qty_with_unit_price;
      $(this).find('.unit_price_with_qty').text(parseFloat(return_qty_with_unit_price).toFixed(2));

      var return_discount_amount =(unit_discount*return_qty);
      footer_return_discount_amount+=  return_discount_amount;

      var discounted_price = (return_qty_with_unit_price - return_discount_amount);
      footer_discounted_price+=discounted_price;
      $(this).find('.discounted_price').text(parseFloat(discounted_price).toFixed(2));

      var tax_amount = (discounted_price*product_tax_perc)/100;
      footer_tax_amount+=tax_amount;
      $(this).find('.product_tax_amount').text(parseFloat(tax_amount).toFixed(2));
      var value_inclusive_of_tax  = (discounted_price+tax_amount);
      footer_value_inclusive_of_tax += value_inclusive_of_tax;
      $(this).find('.value_inclusive_of_tax').text(parseFloat(value_inclusive_of_tax).toFixed(2));

    }); 

    //------------------ table footer ------------------
    $('.footer_return_qty').text(parseFloat(footer_return_qty).toFixed(2));
    $('.footer_unit_price_with_qty').text(parseFloat(footer_unit_price_with_qty).toFixed(2));
    // $('.footer_total_disc').text(parseFloat(footer_return_discount_amount).toFixed(2));
    $('.footer_discounted_price').text(parseFloat(footer_discounted_price).toFixed(2));
    $('.footer_tax_amount').text(parseFloat(footer_tax_amount).toFixed(2));
    $('.footer_value_inclusive_of_tax').text(parseFloat(footer_value_inclusive_of_tax).toFixed(2)); 
    
    // Grand Totals
    $('.subtotal').text(parseFloat(footer_unit_price_with_qty).toFixed(2)); 
     
    $('.total_product_price').text(parseFloat(footer_return_discount_amount).toFixed(2)); 

    var invoice_discount_perc =  parseFloat($('.invoice_discount_perc').text() || 0);
    var invoice_discount_amount = (footer_discounted_price*invoice_discount_perc)/100; 

    $('.invoice_discount').text(parseFloat(invoice_discount_amount).toFixed(2)); 
    $('.invoice_discount').text(parseFloat(invoice_discount_amount).toFixed(2)); 
    
    var amount_exclusive_of_tax =  (footer_discounted_price -invoice_discount_amount);
    
    $('.amount_exclusive_of_tax').text(parseFloat(amount_exclusive_of_tax).toFixed(2)); 

    $('.amount_of_product_sales_tax').text(parseFloat(footer_tax_amount).toFixed(2)); 

    var invoice_tax_perc =  parseFloat($('.invoice_tax_perc').text() || 0);
    var invoice_sales_tax_amount = (amount_exclusive_of_tax*invoice_tax_perc)/100; 

    $('.invoice_sales_tax_amount').text(parseFloat(invoice_sales_tax_amount).toFixed(2)); 
    var amount_inclusive_of_tax =  (invoice_sales_tax_amount+amount_exclusive_of_tax+footer_tax_amount);
    $('.amount_inclusive_of_tax').text(parseFloat(amount_inclusive_of_tax).toFixed(2));     
}


function collectTableData() {
    var tableData = [];
    
    $("#franchise_return_note_payment tbody tr").each(function(index) {
        var rowData = {
            // Hidden fields
            id_franchise_order_products: $(this).find('.id_franchise_order_products').val(),
            product_id: $(this).find('.product_id').val(),
            batch_id: $(this).find('.batch_id').val(),
            batch: $(this).find('.batch').val(),
            batch_amount: $(this).find('.batch_amount').val(),
            
            // Visible data from table cells
            brand: $(this).find('td:eq(1)').text().trim(),
            item: $(this).find('td:eq(2)').text().trim(),
            batch_visible: $(this).find('td:eq(3)').text().trim(),
            sold_by: $(this).find('td:eq(4)').text().trim(),
            unit_price: parseFloat($(this).find('.unit_price').text().trim() || 0),
            invoiced_qty: parseFloat($(this).find('.invoiced_qty').text().trim() || 0),
            return_qty: parseFloat($(this).find('.return_qty').val() || 0),
            unit_price_with_qty: parseFloat($(this).find('.unit_price_with_qty').text().trim() || 0),
            unit_discount: parseFloat($(this).find('.unit_discount').text().trim() || 0),
            discount_perc: parseFloat($(this).find('.discount_perc').text().trim().replace('%', '') || 0),
            discounted_price: parseFloat($(this).find('.discounted_price').text().trim() || 0),
            product_tax_perc: parseFloat($(this).find('.product_tax_perc').text().trim() || 0),
            product_tax_amount: parseFloat($(this).find('.product_tax_amount').text().trim() || 0),
            value_inclusive_of_tax: parseFloat($(this).find('.value_inclusive_of_tax').text().trim() || 0)
        };
        
        tableData.push(rowData);
    });
    
    return tableData;
}

function collectSummaryData() {
    var summaryData = {
        subtotal: parseFloat($('.subtotal').text().trim() || 0),
        total_product_discount: parseFloat($('.total_product_disc').text().trim() || 0),
        invoice_discount_perc: parseFloat($('.invoice_discount_perc').text().trim() || 0),
        invoice_discount: parseFloat($('.invoice_discount').text().trim() || 0),
        amount_exclusive_of_tax: parseFloat($('.amount_exclusive_of_tax').text().trim() || 0),
        amount_of_product_sales_tax: parseFloat($('.amount_of_product_sales_tax').text().trim() || 0),
        invoice_tax_perc: parseFloat($('.invoice_tax_perc').text().trim() || 0),
        invoice_sales_tax_amount: parseFloat($('.invoice_sales_tax_amount').text().trim() || 0),
        amount_inclusive_of_tax: parseFloat($('.amount_inclusive_of_tax').text().trim() || 0),
        return_date: $('#return_date').val(),
        
        // Footer values
        footer_qty: parseFloat($('.footer_qty').text().trim() || 0),
        footer_return_qty: parseFloat($('.footer_return_qty').text().trim() || 0),
        footer_unit_price_with_qty: parseFloat($('.footer_unit_price_with_qty').text().trim() || 0),
        footer_total_disc: parseFloat($('.footer_total_disc').text().trim() || 0),
        footer_discounted_price: parseFloat($('.footer_discounted_price').text().trim() || 0),
        footer_tax_amount: parseFloat($('.footer_tax_amount').text().trim() || 0),
        footer_value_inclusive_of_tax: parseFloat($('.footer_value_inclusive_of_tax').text().trim() || 0)
    };
    
    return summaryData;
}

function saveReturnNote() {
    var total_to_be_returned_qty = 0;
    $("#franchise_return_note_payment tbody tr").each(function () {
        total_to_be_returned_qty += parseFloat($(this).find('.return_qty').val() || 0);
    });

    if (total_to_be_returned_qty === 0) {
        toastr.warning(
            'Please select at least one quantity to proceed with the return note.',
            'No Quantity Selected'
        );
        return false;
    }

    // Show loading spinner
    $('#generateInvoiceSpinner').removeClass('d-none');
    $('#btnsubmit').prop('disabled', true);
    
    var tableData = collectTableData();
    var summaryData = collectSummaryData();

    var postData = {
        order_id: '{{ $order[0]["franchise_order_id"] }}',
        table_data: tableData,
        summary_data: summaryData,
        _token: '{{ csrf_token() }}'
    };

    // AJAX request
    $.ajax({
        url: '{{ route("franchise.save_franchise_return") }}',
        type: 'POST',
        dataType: 'json',
        data: postData,

        success: function(response) {
            $('#generateInvoiceSpinner').addClass('d-none');
            $('#btnsubmit').prop('disabled', false);

            if (response.success) {
                toastr.success(response.message, 'Done!');
                setTimeout(() => {
                    window.location.reload();
                }, 200);
            } else {
                toastr.error(response.message, 'Error!');
            }
        },

        error: function(xhr) {
            $('#generateInvoiceSpinner').addClass('d-none');
            $('#btnsubmit').prop('disabled', false);

            let msg = xhr.responseJSON?.message || 'An error occurred.';
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: msg
            });
        }
    });

}


function view_franchise_order_return_history(id){

    $('#generateReturnHistorySpinner').removeClass('d-none');
    $('#returnHistoryButton').prop('disabled', true);
        var url = "{{ route('franchise.franchise_order_return_history') }}";
         $("#invoice_payment_table tbody").empty(); 
        $.ajax({
            url: url,
            type: 'GET',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            data: {
                    id_franchise_orders: id,
                },
                success: function(response) {
                    $('#generateReturnHistorySpinner').addClass('d-none');
                    $('#returnHistoryButton').prop('disabled', false);

                    $("#invoice_payment_table tbody").empty(); 
                   if (response.success) { 
                    var total_return_qty_for_footer = 0;

                    $.each(response.return_history, function(index, item) {

                        total_return_qty_for_footer += parseFloat(item.return_qty);

                       // Split voucher IDs and Descriptions
                        let voucherIds = item.voucher_ids ? item.voucher_ids.split(",") : [];
                        let voucherDescriptions = item.voucher_description ? item.voucher_description.split(",") : [];

                        // Build dropdown items
                        let voucherDropdownItems = "";

                        voucherIds.forEach(function(vId, i) {
                            vId = vId.trim();
                            let desc = voucherDescriptions[i] ? voucherDescriptions[i].trim() : "Voucher";

                            // URL
                            let url = "{{ route('accounts.account_voucher_print') }}" + "?id=" + vId;

                            voucherDropdownItems += `
                                <a class="dropdown-item" href="${url}" target="_blank">
                                    <strong>${vId}</strong> - ${desc}
                                </a>
                            `;
                        });

                        // Dropdown with count
                        let voucherDropdown = `
                            <div class="btn-group">
                                <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown"
                                    aria-haspopup="true" aria-expanded="false">
                                    Vouchers (${voucherIds.length})
                                </button>
                                <div class="dropdown-menu">
                                    ${voucherDropdownItems}
                                </div>
                            </div>
                        `;
                        let row = `
                            <tr>
                                <td>${index + 1}</td>
                                <td>${item.return_date}</td>
                                <td>${item.status}</td>
                                <td>${parseFloat(item.return_qty).toFixed(2)}</td>
                                <td>${item.created_by}</td>

                                <td>
                                    ${voucherDropdown}
                                    <a href="javascript:void(0)" onclick="cancelRetrunNote(${id}, ${item.id}, this)"  type="button" class="btn btn-danger btn-sm"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></a>
                                </td>
                            </tr>
                        `;

                        $("#invoice_payment_table tbody").append(row);
                    });

                    let El = document.getElementById('invoice_payments_listing_modal');
                    let modal = bootstrap.Modal.getInstance(El);
                    if (!modal) {
                        modal = new bootstrap.Modal(El);
                    }
                    modal.show();

                    $("#total_return_qty_for_footer").text(parseFloat(total_return_qty_for_footer).toFixed(2));
                    $("#FranchiseOrderIdForModal").text(id);

                } else {
                    toastr.error(response.message);
                }

                },
                error: function(xhr, status, error) {
                    $('#generateReturnHistorySpinner').addClass('d-none');
                    $('#returnHistoryButton').prop('disabled', false);
                    toastr.error('An error occurred');
                }
            });       
}


function cancelRetrunNote(id,return_note_id,this_btn){

        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you really want to cancel this Return Note?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Cancel Return Note',
            cancelButtonText: 'Close',
            customClass: {
                confirmButton: "btn btn-danger me-2", 
                cancelButton: "btn btn-warning"
            },
            buttonsStyling: false,
        }).then((result) => {
            if (result.isConfirmed) {
                var url = "{{ route('franchise.cancel_franchise_return_note') }}"; 
                $.ajax({
                    url: url,
                    type: 'POST',
                    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                    data: {
                            id_franchise_orders: id,
                            return_note_id: return_note_id,
                        },
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.message);
                                $(this_btn).closest('tr').remove();
                            } else {
                                toastr.error(response.message);
                            }
                        },
                        error: function(xhr, status, error) {
                            toastr.error('An error occurred while cancelling the voucher.');
                        }
                    });        
                                    
            }
        });

    }
</script>
@endsection