@extends('layouts.horizontal', ['title' => 'Invoice Payment Receiving Note', 'topbarTitle' => 'Invoice Payment Receiving Note', 'nonav' => true])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@endsection

 @php 
 $narriationHtml ='<label for="notes" class="form-label">Narration</label><textarea class="form-control" id="notes" name="notes" rows="3">Payment Receiving For Invoice # '.$order_detail->invoice_number.'.</textarea>';
 @endphp   

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                    </div> 
                    <h4 class="card-title">New Invoice Payment Receiving For Invoice # {{$order_detail->invoice_number}}</h4>
                </div>
                <div class="card-body">
                    <form id="new_invoice_payment_form">   
                        @csrf
                        <input type="hidden" id="franchise_id" name="franchise_id"  value="{{$order_detail->franchise_id}}">
                        <input type="hidden" id="franchise_order_id" name="franchise_order_id"  value="{{$order_detail->id_franchise_orders}}">
                        <input type="hidden" id="invoice_number" name="invoice_number"  value="{{$order_detail->invoice_number}}">
                        <div class="row">
                            <div class="col-md-2">
                                <label for="supplier_name" class="form-label">Franchise Name</label>
                                <input type="text" class="form-control" id="franchise_name" name="franchise_name" value="{{$franchise->franchise_name}}" readonly>
                            </div>
                            <div class="col-md-2">
                                <label for="payment_date" class="form-label">Payment Date</label>
                                <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}" required>
                            </div>
                            <div class="col-md-2">
                                <label for="payment_mode" class="form-label">Payment Mode</label>
                                <select  onchange="get_cash_account_heads()" class="form-select" id="payment_mode" name="payment_mode" required>                                    
                                    <option value="Cash">Cash</option>
                                    <option value="Bank">Bank Transfer</option>
                                    <option value="Bank">Cheque</option>
                                    <option value="Card">Credit Card</option>
                                    <option value="Online">Online</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="amount" class="form-label">Receive In</label>
                                <select class="form-select" id="account_head_id" name="account_head_id" required>
                                </select>
                            </div>
                            <div class="col-md-1">
                                <div class="spinner-border text-dark mt-3 fs-12 d-none" role="status" id="loading_spinner">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label for="instrument_number" class="form-label">Instrument#</label>
                                <input type="text" class="form-control" id="instrument_number" name="instrument_number">
                            </div>
                        </div>
                        <div class="row mt-2 d-none">
                            <div class="col-2">
                                <label for="cost_center_type" class="form-label">Cost Center Type</label>
                                <select onchange="costcentertypechange();" class="form-control" name="cost_center_type" id="cost_center_type" placeholder="Enter Business Partner" >     
                                    {{-- <option value="0">All</option>                                --}}
                                    @foreach($cost_centers as $center)
                                        <option value="{{ $center->id_account_cost_center }}">{{ $center->account_cost_center }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-2" id="costCenterDiv">    
                                <!--Cost Center-->
                                <label for="cost_center" class="form-label">Cost Center</label>                                   
                                <input class="form-control" name="cost_center" id="cost_center" value="" required/> 
                            </div>

                        </div>        
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="row mb-2">
                                    <div class="col-md-4 text-start"> 
                                        <label for="amount" class="form-label">Total Receivable</label>                                         
                                        <input type="number" class="form-control form-control-sm text-end" id="total_receivable" name="total_receivable" value="{{round($total_receivable)}}" disabled>
                                    </div>
                                
                                    <div class="col-md-4 text-start border-start border-primary">   
                                        <label for="amount" class="form-label">Total Received</label>                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="total_receivable" name="total_receivable" value="{{round($total_received)}}" disabled>
                                    </div>
                                    <div class="col-md-4 text-start border-start border-primary">
                                        <label for="amount" class="form-label">Remaining</label>                                            
                                        <input type="number" class="form-control form-control-sm text-end" id="remaining" name="remaining" value="{{ round($balance)}}" disabled>
                                    </div>

                                </div>  
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label class="form-label text-success fw-bolder">Invoice Settlement Amount</label>                                  
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" oninput="calculate_from_percentage(); calculate_from_amount();" step="any" class="form-control form-control-sm text-success fw-bolder text-end" id="receiving_now" name="receiving_now" value="{{ round($balance)}}" required>
                                    </div>
                                </div>
                                <div class="row mb-2" id="excessReceiving">
                                    <div class="col-md-6">
                                        <label class="form-label text-primary">Excess</label>                                  
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" step="any" class="form-control form-control-sm   text-end bg-light text-primary" id="excess" name="excess" value="0" readonly>
                                    </div>
                                </div>
                                <hr>
                                @php
                                   $total_avaiable_advance = isset($franchise_over_all_advance_balance[0]->balance) ? $franchise_over_all_advance_balance[0]->balance : 0;
                                @endphp
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label class="form-label  ">Avaiable Advance</label>                                  
                                    </div>
                                    <div class="col-1">
                                        <label class="form-check-label text-end" for="useAdvance">Use</label>

                                    </div>
                                    <div class="col-md-1">
                                      <input  type="checkbox" class="text-start form-check-input me-1" id="useAdvance">
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" step="any" class="form-control form-control-sm  text-end bg-light" id="avaibaleAdvance" name="avaibaleAdvance" value="{{ round($total_avaiable_advance,2)}}" required>
                                    </div>
                                </div>

                                @php
                                    $use_advance_now = $total_avaiable_advance >= $balance ? $balance : $total_avaiable_advance;
                                @endphp
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label class="form-label ">Advance Use Now</label>                                  
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" readonly oninput="validate_advance()" step="any" class="form-control form-control-sm   text-end" id="useAvaibaleAdvance" name="useAvaibaleAdvance" value="0" required>
                                    </div>
                                </div>
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label class="form-label fw-bolder">Amount After Advance Adjustment</label>                                  
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" oninput="calculate_from_percentage(); calculate_from_amount();" step="any" class="form-control form-control-sm  fw-bolder text-end bg-light" id="receiving_after_advance_adjustment" name="receiving_after_advance_adjustment" value="{{ round($balance)}}" required>
                                    </div>
                                </div>
                                <hr>  
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="amount" class="form-label">With Holding Income Tax %</label>                                      
                                    </div>
                                    <div class="col-md-2">
                                        <input type="number" step="any" oninput="calculate_from_percentage();" class="form-control form-control-sm text-end" id="withholding_tax_percentage" name="withholding_tax_percentage" value="0.00">
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" step="any" oninput="calculate_from_amount();"  class="form-control form-control-sm text-end" id="withholding_tax" name="withholding_tax" value="0.00">
                                    </div>
                                </div> 
                                <hr>   
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                       <label for="amount" class="form-label">Total Invoice Tax Amount</label>  
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" readonly step="any"  class="form-control form-control-sm text-end bg-light" id="total_invoice_tax_amount" name="total_invoice_tax_amount" value="{{$total_tax_on_invoice}}">
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="amount" class="form-label">With Holding Sale Tax %</label>                                      
                                    </div> 
                                    <div class="col-md-2">
                                        <input type="number" step="any" oninput="calculate_from_percentage();" class="form-control form-control-sm text-end" id="withholding_sales_tax_percentage" name="withholding_sales_tax_percentage" value="0.00">
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" step="any" oninput="calculate_from_amount();"  class="form-control form-control-sm text-end" id="withholding_sales_tax" name="withholding_sales_tax" value="0.00">
                                    </div>
                                </div> 
                                <hr>   
                                <div class="row mt-2">
                                    <div class="col-md-6">
                                        <label class="form-label text-primary fw-bolder">Amount After Withholding</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" step="any" class="form-control form-control-sm text-primary fw-bolder text-end bg-light" id="receiving_after_withholding" name="receiving_after_withholding" value="{{ round($balance)}}" >
                                    </div>
                                </div>                     
                            </div>   
                            <div class="col-md-6">
                                @php
                                    $pendingCount = isset($franchise_pending_payments) ? count($franchise_pending_payments) : 0;
                                @endphp

                

                                @if (isset($franchise_pending_payments) && !empty($franchise_pending_payments) && $pendingCount > 1)
                                @php
                                    $total_receivable = 0;
                                @endphp

                                <div class="table-responsive mb-5" style="max-height: 300px; overflow-y: auto;">
                                    {{-- <h4 class="text-center">Orders with Pending Payments</h4> --}}
                                    <table id="franchise_order_table" class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12">
                                        <thead class="table-light position-sticky top-0" style="z-index: 10; background: #f8f9fa;">
                                            <tr>
                                                <th colspan="7" class="text-center fs-14">Other Pending Payments</th>
                                            </tr>
                                            <tr>
                                                <th>ID</th>
                                                <th>Franchise</th>
                                                <th>Invoice No</th>
                                                <th>Order Date</th>
                                                <th>Invoice Date</th>
                                                <th>Receivable</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($franchise_pending_payments as $rows)
                                              @if ($rows->id_franchise_orders !=  $order_detail->id_franchise_orders)
                                                <tr>
                                                    <td>{{$rows->id_franchise_orders}}</td>
                                                    <td>{{$rows->franchise_name}}</td>
                                                    <td>{{$rows->invoice_number}}</td>
                                                    <td>{{$rows->order_date}}</td>
                                                    <td>{{$rows->invoice_date}}</td>
                                                    <td>{{number_format($rows->balance,2)}}</td>
                                                    @php
                                                        $payment_receiving_note_url = route('franchise.payment_receiving_note', [
                                                            'order_id' => $rows->id_franchise_orders
                                                        ]); 

                                                        $total_receivable += $rows->balance;
                                                    @endphp
                                                    <td>
                                                       <a href="{{$payment_receiving_note_url}}" 
                                                        class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success openOrderTab"
                                                        data-order-id="{{$rows->id_franchise_orders}}"
                                                        title="Receive Payment">
                                                            <iconify-icon icon="ph:money-wavy-thin" class="fs-20"></iconify-icon>
                                                        </a>
                                                    </td>
                                                </tr>
                                               @endif   
                                            @endforeach
                                        </tbody>
                                        <tfoot class="table-light position-sticky bottom-0" style="z-index: 10; background: #f8f9fa;">
                                            <tr>
                                                <th colspan="5" class="text-start">Total Receivable</th>
                                                <th>{{number_format($total_receivable, 2)}}</th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                @endif
                                
                                 @if ($pendingCount <= 1)
                                    {!!$narriationHtml!!}
                                 @endif   
                                
                            </div>  
                            @if ($pendingCount> 1)
                                <div class="col-md-12 mt-2">        
                                    {!! $narriationHtml !!}
                                </div>
                            @endif   
                        </div>
                    </form>
                </div>
                <div class="card-footer text-end">
                    <a href="{{route('franchise.franchise_orders')}}" type="button" class="btn btn-success">Go Back to Franchise Orders</a>
                    <button type="submit" id="savePaymentButton" form="new_invoice_payment_form" class="btn btn-primary"><i class="ti ti-device-floppy fs-16"></i> Save Payment</button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    const purchase_order_id = 0;
    const remaining_amount = 0;
    const baseURL = "{{ url('') }}";
    var lock = false;
    document.addEventListener('DOMContentLoaded', function() {
        get_cash_account_heads();
        costcentertypechange();
        calculate_from_amount(); 

        $("#new_invoice_payment_form").submit(function(e) {
            e.preventDefault();  

            var account_head_id =  $("#account_head_id").val() || '';
            var cost_center =  $("#cost_center").val() || '';

            if(account_head_id =='' || account_head_id ==0){
                Swal.fire({
                    icon: 'warning',
                    title: 'Notice',
                    text: "Please select an Account Head before proceeding.",
                    confirmButtonText: 'OK',
                    customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                });
                
                return false;
            }
            if(cost_center == "" || cost_center ==0){
                Swal.fire({
                    icon: 'warning',
                    title: 'Notice',
                    text: "Cost Center cannot be left empty. Please provide a valid value.",
                    confirmButtonText: 'OK',
                    customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                });
                return false;
            }

            var formData = new FormData(this);
                $("#savePaymentButton").prop('disabled', true);
                $('#savePaymentButton').html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true">Wait..</span>');
                    $.ajax({
                        url: "{{ route('franchise.save_invoice_payment') }}",
                        method: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(res) {
                            $("#savePaymentButton").prop('disabled', false);
                              $('#savePaymentButton').html('<i class="ti ti-device-floppy fs-16"></i> Save Payment');
                            if(res.success){
                               toastr.success(res.message, 'Done!'); 
                               setTimeout(() => {
                                    window.location.href = res.account_voucher_print_url;
                                    // window.open(res.account_voucher_print_url, '_blank');
                                    // window.location.reload();  
                                }, 500);
                            } else {
                                $("#useAvaibaleAdvance").val(parseFloat(res.total_avaiable_balance).toFixed(2));
                                $("#avaibaleAdvance").val(parseFloat(res.total_avaiable_balance).toFixed(2));
                                // toastr.error('Failed to save payment: ' + res.message);
                                calculate_from_percentage(); calculate_from_amount();

                                  Swal.fire({
                                        icon: res.message_type,
                                        title: res.message,
                                        confirmButtonText: 'OK',
                                        customClass: {
                                            confirmButton: 'btn btn-danger'
                                        }
                                    });

                            }
                        },
                        error: function(xhr) {
                            $("#savePaymentButton").prop('disabled', false);
                            $('#savePaymentButton').html('<i class="ti ti-device-floppy fs-16"></i> Save Payment');
                            toastr.error('Error occurred: ' + xhr.responseText);
                        }
                    });
        });

    });
    
    function get_cash_account_heads() {

        var account_type = $('#payment_mode').val();
        $('#loading_spinner').removeClass('d-none');
        $.ajax({
            url: baseURL + '/accounts/get_account_heads?' +'account_sub_control=' + account_type,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let accountHeads=data.account_heads;
                let accountHeadSelect = $('#account_head_id');
                accountHeadSelect.empty();
                accountHeads.forEach(function(accountHead) {
                    accountHeadSelect.append(new Option(accountHead.account_head_number + " - " + accountHead.account_head, accountHead.id_account_heads));
                });
                $('#loading_spinner').addClass('d-none');
            },
            error: function(xhr, status, error) {
                $('#loading_spinner').addClass('d-none');
                toastr.error('Error fetching account heads:', error);
            }
        });
    }

    function costcentertypechange() {
        var selectedText = $("#cost_center_type option:selected").text();
        var $div = $("#costCenterDiv");

        $div.empty(); 

        if (selectedText !== "Staff" && selectedText !== "Department") {
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <input type="text" class="form-control" id="cost_center" name="cost_center" value="${selectedText =='All' ? '' :selectedText }" />
            `);
        } else {
            // Show select2
            $div.append(`
                <label for="cost_center" class="form-label">Cost Center</label>
                <select class="form-select select2" id="cost_center" name="cost_center"></select>
            `);

            var Route = '';
            if(selectedText == "Staff"){
                Route = "{{ route('staff.staff_search') }}";
                enable_costcenterstaff(Route);
            } else {
                Route = "{{ route('service_department_search') }}";
                enable_costcenterdepartments(Route);
            }
        }
    } 


    function enable_costcenterstaff(url) {
        if ($('#cost_center').hasClass('select2-hidden-accessible')) {
            $('#cost_center').select2('destroy'); 
        }
        $('#cost_center').select2({
                    ajax: {
                        url: url,
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                term: params.term // search term
                            };
                        },
                        processResults: function (data) {
                            // Ensure 'data' is a valid array before returning
                            if (!data || typeof data !== 'object') {
                                console.error('Invalid response for Select2:', data);
                                return { results: [] };
                            }

                        return {
                                    results: data.map(function (item) {
                                        return { 
                                            id: item.text, 
                                            text: `${item.text} | ${item.staff_cell}` 
                                        };
                                    })
                                };

                        },
                        cache: true
                    },
                    minimumInputLength: 3,
                    placeholder: 'Select Staff'  ,
                    width: '100%',
                templateSelection: function (data, container) {
                        // This controls what is displayed in the input after selection
                        if (data.full_name && data.cell) {
                            return data.full_name + " | " + data.cell;
                        }
                        return data.text;
                    }
                }); 
    }
    function enable_costcenterdepartments(url) {
        if ($('#cost_center').hasClass('select2-hidden-accessible')) {
            $('#cost_center').select2('destroy'); 
        }
        $('#cost_center').select2({
                    ajax: {
                        url: url,
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                term: params.term // search term
                            };
                        },
                        processResults: function (data) {
                            // Ensure 'data' is a valid array before returning
                            if (!data || typeof data !== 'object') {
                                console.error('Invalid response for Select2:', data);
                                return { results: [] };
                            }

                        return {
                                    results: data.map(function (item) {
                                        return { 
                                            id: item.text, 
                                            text: `${item.text}` 
                                        };
                                    })
                                };

                        },
                        cache: true
                    },
                    minimumInputLength: 3,
                    placeholder: 'Select Department'  ,
                    width: '100%',
                templateSelection: function (data, container) {
                        // This controls what is displayed in the input after selection
                        if (data.full_name && data.cell) {
                            return data.full_name + " | " + data.cell;
                        }
                        return data.text;
                    }
                }); 
    }  

    function calculate_from_amount() {
        if (lock) return;
        lock = true;

        var remaining_account = parseFloat($("#remaining").val() || 0);
        var receiving_now = parseFloat($("#receiving_now").val() || 0);
        var withholding_amount = parseFloat($("#withholding_tax").val() || 0);

        var withholding_amount = parseFloat($("#withholding_tax").val() || 0);

        var total_invoice_tax_amount = parseFloat($("#total_invoice_tax_amount").val() || 0);
        var withholding_sales_tax_percentage = parseFloat($("#withholding_sales_tax_percentage").val() || 0);
        var withholding_sales_tax = parseFloat($("#withholding_sales_tax").val() || 0);
        var excess =0;
        // Validation 1: receiving_now cannot exceed remaining_account
        if (receiving_now > remaining_account) {
            // Swal.fire({
            //     icon: 'warning',
            //     title: 'Notice',
            //     text: "Receiving amount cannot be greater than remaining account!",
            //     confirmButtonText: 'OK',
            //     customClass: {
            //             confirmButton: 'btn btn-danger'
            //         }
            // });
            // $("#receiving_now").val(remaining_account.toFixed(2));
            // receiving_now = remaining_account;
             excess =  receiving_now - remaining_account;
            $("#excess").val(parseFloat(excess).toFixed(2));

        }


        // Calculate percentage
        var percentage = receiving_now > 0 ? (withholding_amount / (receiving_now-excess)) * 100 : 0;

       

        // Validation 2: withholding percentage cannot exceed 100%
        if (percentage > 100) {
             Swal.fire({
                icon: 'warning',
                title: 'Notice',
                text: "Withholding tax cannot exceed 100%!",
                confirmButtonText: 'OK',
                customClass: {
                        confirmButton: 'btn btn-danger'
                    }
            });
            percentage = 100;
            withholding_amount = receiving_now; // 100% amount
            $("#withholding_tax").val(withholding_amount.toFixed(2));
        } 


        var sale_tax_percentage = total_invoice_tax_amount > 0 ? (withholding_sales_tax / total_invoice_tax_amount) * 100 : 0;
        $("#withholding_sales_tax_percentage").val(sale_tax_percentage.toFixed(2));

        var useAvaibaleAdvance = parseFloat($("#useAvaibaleAdvance").val() || 0);
        var receiving_after = (receiving_now-useAvaibaleAdvance) - withholding_amount;
        $("#receiving_after_advance_adjustment").val((receiving_now -useAvaibaleAdvance).toFixed(2));
        $("#withholding_tax_percentage").val(percentage.toFixed(2));

        var withholding_sales_tax = parseFloat($("#withholding_sales_tax").val() || 0) ;    
        $("#receiving_after_withholding").val((receiving_after - withholding_sales_tax).toFixed(2));
        if(receiving_after > 0){
            $("#savePaymentButton").prop('disabled', false);
        }else{
             $("#savePaymentButton").prop('disabled', true);
        }

        lock = false;
    }

    function calculate_from_percentage() {
        if (lock) return;
        lock = true;
        
        var remaining_account = parseFloat($("#remaining").val() || 0);
        var receiving_now = parseFloat($("#receiving_now").val() || 0);
        var percentage = parseFloat($("#withholding_tax_percentage").val() || 0);

        var excess =0;
        // Validation 1: receiving_now cannot exceed remaining_account
        if (receiving_now > remaining_account) {
            // Swal.fire({
            //     icon: 'warning',
            //     title: 'Notice',
            //     text: "Receiving amount cannot be greater than remaining account!",
            //     confirmButtonText: 'OK',
            //     customClass: {
            //             confirmButton: 'btn btn-danger'
            //         }
            // });

            // $("#receiving_now").val(remaining_account.toFixed(2));
            // receiving_now = remaining_account;
            excess =  receiving_now - remaining_account;
            $("#excess").val(parseFloat(excess).toFixed(2));

        }

        // Validation 2: percentage cannot exceed 100
        if (percentage > 100) {
            Swal.fire({
                icon: 'warning',
                title: 'Notice',
                text: "Withholding tax cannot exceed 100%!",
                confirmButtonText: 'OK',
                customClass: {
                        confirmButton: 'btn btn-danger'
                    }
            });
            percentage = 100;
            $("#withholding_tax_percentage").val(100);
        }


        var useAvaibaleAdvance = parseFloat($("#useAvaibaleAdvance").val() || 0);
        var withholding_amount = ((receiving_now -excess) * percentage) / 100;
        var receiving_after = (receiving_now) - withholding_amount;
        $("#withholding_tax").val(withholding_amount.toFixed(2));


        var total_invoice_tax_amount = parseFloat($("#total_invoice_tax_amount").val() || 0);
        var withholding_sales_tax_percentage = parseFloat($("#withholding_sales_tax_percentage").val() || 0);
        var withholding_sales_tax = (total_invoice_tax_amount * withholding_sales_tax_percentage) / 100;
        $("#withholding_sales_tax").val(withholding_sales_tax.toFixed(2));
 

        $("#receiving_after_withholding").val( ((receiving_after-useAvaibaleAdvance) - withholding_sales_tax).toFixed(2));
        lock = false;
    }

    function validate_advance(){
       var avaibaleAdvance = parseFloat($("#avaibaleAdvance").val() || 0);
       var useAvaibaleAdvance = parseFloat($("#useAvaibaleAdvance").val() || 0);
       if(useAvaibaleAdvance > avaibaleAdvance){
        $("#useAvaibaleAdvance").val(parseFloat(avaibaleAdvance).toFixed(2))
        toastr.warning('You cannot use more than the available advance.');
       }
       calculate_from_percentage(); calculate_from_amount();
    }   

    $(document).on('mousedown', '.openOrderTab', function(e) {

        // 1 = left click
        // 2 = middle click (mouse wheel)
        // 4 = right click

        if (e.which === 2) { 
            e.preventDefault(); // Stop browser default middle-click new tab
            
            let url = $(this).attr('href');
            let orderId = $(this).data('order-id');
            let windowName = "order_tab_" + orderId;

            window.open(url, windowName); // open in same assigned tab
        }
    });

    $(document).on('click', '.openOrderTab', function(e) {
        e.preventDefault();
        let $btn = $(this);
        let url = $btn.attr('href');
        let orderId = $btn.data('order-id');
        let windowName = "order_tab_" + orderId;

        if (!$btn.hasClass('clicked-before')) {
            $btn.removeClass('btn-ghost-success')
            $btn.addClass('clicked-before btn-ghost-primary'); 
            $btn.attr('title', 'Already Opened');
        }

        window.open(url, windowName);
    });

   $(document).on('click', '#useAdvance', function(e) {
        var avaibaleAdvance = parseFloat($("#avaibaleAdvance").val() || 0);
        var receiving_now = parseFloat($("#receiving_now").val() || 0);
        var useAdvanceNow =   avaibaleAdvance >= receiving_now ? receiving_now : avaibaleAdvance;
        
        if ($("#useAdvance").is(":checked")) {
            $("#useAvaibaleAdvance").prop("readonly", false);
            $("#useAvaibaleAdvance").val(parseFloat(useAdvanceNow).toFixed(2));
            validate_advance();
        } else {
            $("#useAvaibaleAdvance").prop("readonly", true);
            $("#useAvaibaleAdvance").val(parseFloat(0).toFixed(2));
            validate_advance();
        }
    });
</script>
@endsection