@extends('layouts.horizontal', ['title' => 'Franchise Invoice Aging', 'topbarTitle' => 'Franchise Invoice Aging']) 
@section('css')
 <style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
 </style>
@endsection
@section('content')
<div class="profit-loss-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Franchise Invoice Aging</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item active">Franchise Invoice Aging</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- FILTERS -->
    <form id="accounts_closing_form" method="POST" action="javascript:void(0)">
        @csrf
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h4 class="card-title mb-0">Filters </h4>
                        <div>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-sm-3">
                            <label for="as_on_date_select" class="form-label">As On Date</label>
                            <input type="date" class="form-control" id="as_on_date_select" name="as_on_date" value="{{ date('Y-m-d') }}">
                        </div>       

                        <div class="col-sm-3 align-self-end">
                            <button type="button" class="btn btn-outline-success" id="btn_refresh_table">Refresh</button>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    </form>
    <!-- EXPENSE TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Franchise Invoice Aging</h4>
                    </div>
                    <div class="table-responsive">
                       <table id="agingReceivablesTable" class="table table-bordered table-sm fs-12 w-100">
                            <thead class="table-light">
                                <tr>
                                    <th>Franchise ID</th>
                                    <th>Franchise</th>
                                    <th>Product</th>
                                    <th>Order ID</th>
                                    <th>Invoice#</th>
                                    <th>Invoice Date</th>
                                    <th class="text-end">Days</th>
                                    <th class="text-end">< 10</th>
                                    <th class="text-end">10-19</th>
                                    <th class="text-end">20-39</th>
                                    <th class="text-end">40-59</th>
                                    <th class="text-end">60-90</th>
                                    <th class="text-end">> 90</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th colspan="6" class="text-end">G-Total</th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                    <th class="text-end"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>
    </div> 
</div>
@endsection

@section('scripts')
<script>
let baseURL = "{{ url('/') }}";
let user_role = @json(session('user_role'));
let agingReceivablesTable=null;
document.addEventListener("DOMContentLoaded", function() { 
    initializeagingReceivablesTable(); 
    document.getElementById('btn_refresh_table').addEventListener('click', function(btn) { 
        $("#btn_refresh_table").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>`);
        $("#btn_refresh_table").prop("disabled", true);
        if(agingReceivablesTable){
            agingReceivablesTable.ajax.reload(function() {
                $("#btn_refresh_table").html(`Refresh`);
                $("#btn_refresh_table").prop("disabled", false);
            });
        }
    });
});


function initializeagingReceivablesTable() {
   agingReceivablesTable = $('#agingReceivablesTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: false,
        fixedHeader: true,
        destroy:true,
        scrollY: "500px",  
        scrollX: "auto",  
        scrollCollapse: true,
        ajax: {
            url: '{{ route("franchise.franchise_aging") }}',
            type: 'GET',
            data: function(d) {
                d.as_on_date = $('#as_on_date_select').val()
            }
        },
        columns: [
            { data: 'franchise_id', title: 'Franchise ID', className: 'text-start' },
            { data: 'franchise_name', title: 'Franchise' },
            {
                data: 'product_name',
                title: 'Product Name',
                render: function(data) {
                    return `<textarea class="form-control fs-12" style="mix-height:65px;" readonly>${data}</textarea>`;
                }
            },
            { data: 'id_franchise_orders', title: 'Order ID' },
            { data: 'invoice_number', title: 'Invoice#' },
            { data: 'invoice_date', title: 'Invoice Date' },
            { data: 'lapsed_days', title: 'Days', className: 'text-end' },
            { data: 'bucket_0_9', title: '< 10', className: 'text-end' },
            { data: 'bucket_10_19', title: '10-19', className: 'text-end' },
            { data: 'bucket_20_39', title: '20-39', className: 'text-end' },
            { data: 'bucket_40_58', title: '40-59', className: 'text-end' },
            { data: 'bucket_60_89', title: '60-90', className: 'text-end' },
            { data: 'bucket_90_plus', title: '> 90', className: 'text-end' }
        ],
        responsive: false,
        fixedHeader: true,
        buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
        ],
        "layout": {
                    topStart: "buttons",
                    topEnd: "search",
                    bottomStart: {           
                        pageLength: {
                            menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                        },
                        info: {}
                    },                
                    bottomEnd: "paging"     
        },
        ordering: true,
        footerCallback: function(row, data, start, end, display) {
            var api = this.api();
            var intVal = function(i) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ? i : 0;
            };

            [6,7,8,9,10,11].forEach(function(idx) {
                var total = api.column(idx).data().reduce((a,b) => intVal(a) + intVal(b), 0);
                $(api.column(idx).footer()).html(total.toFixed(2));
            });
        }
    });
}


</script>
@endsection 