@extends('layouts.horizontal', ['title' => 'Product Sale Details', 'topbarTitle' => 'Product Sale Details']) 
@section('css')
 <style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
 </style>
@endsection
@section('content')
<div class="profit-loss-container">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Franchise Product Sale Details</h2>
                 <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Accounts</a></li>
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Franchise</a></li>
                            <li class="breadcrumb-item active">Franchise Product Sale Details</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- FILTERS -->
    <form id="accounts_closing_form" method="POST" action="javascript:void(0)">
        @csrf
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h4 class="card-title mb-0">Filters </h4>
                        <div>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-sm-3">
                            <label for="as_on_date_select" class="form-label">From</label>
                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $start_date }}">
                        </div>       
                        <div class="col-sm-3">
                            <label for="as_on_date_select" class="form-label">To</label>
                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $end_date }}">
                        </div>       

                        <div class="col-sm-3 align-self-end">
                            <button type="button" class="btn btn-outline-success" id="btn_refresh_table">Refresh</button>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    </form>
    <!-- EXPENSE TABLE --> 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">Franchise Product Sale Details</h4>
                    </div>
                    <div class="table-responsive">
                       <table id="franchiseProductSaleDetailTable" class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12">
                            <thead class="table-light">
                                <tr>
                                    <th>Order ID</th>
                                    <th>Franchise ID</th>
                                    <th>Franchise</th>
                                    <th>Franchise Phone</th>
                                    <th>Invoice</th>
                                    <th>Date</th>
                                    <th>Brand</th>
                                    <th>Product ID</th>
                                    <th>Product</th>
                                    <th>Category</th>
                                    <th>Store</th>
                                    <th>Sold By</th>
                                    <th class="text-end">Price</th>
                                    <th class="text-end">Qty</th>
                                    <th class="text-end">Total Price</th>
                                    <th class="text-end">Product Discount</th>
                                    <th class="text-end">Invoice Discount</th>
                                    <th class="text-end">Product Tax</th>
                                    <th class="text-end">Invoice Tax</th>
                                    <th class="text-end">Total</th>
                                    <th class="text-end">COG</th>
                                   
                                </tr>
                            </thead>
                            <tfoot>
                                 <tr>
                                    <th colspan="13">G-Total</th>
                                    <th class="text-end" id="total_qty"></th>
                                    <th class="text-end" id="total_price"></th>
                                    <th class="text-end" id="product_dec"></th>
                                    <th class="text-end" id="invoice_disc"></th>
                                    <th class="text-end" id="product_tax"></th>
                                    <th class="text-end" id="invoice_tax"></th>
                                    <th class="text-end" id="final_total"></th>
                                    <th class="text-end" id="cost_of_goods"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>
    </div> 
</div>
@endsection

@section('scripts')
<script>
let baseURL = "{{ url('/') }}";
let user_role = @json(session('user_role'));
let franchiseProductSaleDetailTable=null;
document.addEventListener("DOMContentLoaded", function() { 
    initializefranchiseProductSaleDetailTable(); 
    document.getElementById('btn_refresh_table').addEventListener('click', function(btn) { 
            var from_date = document.getElementById('start_date')?.value || 0;
            var to_date = document.getElementById('end_date')?.value || 0;

               if (from_date && to_date) {
                var from = new Date(from_date);
                var to = new Date(to_date);
                var diffTime = Math.abs(to - from); // difference in milliseconds
                var diffYears = diffTime / (1000 * 60 * 60 * 24 * 365); // convert to years

                if (diffYears > 2) {
                    Swal.fire({
                        title: 'Warning',
                        text: "You cannot select a date range longer than 2 years.",
                        icon: 'warning',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                    return false;
                }
            }


        $("#btn_refresh_table").html(`<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>`);
        $("#btn_refresh_table").prop("disabled", true);
        if(franchiseProductSaleDetailTable){
            franchiseProductSaleDetailTable.ajax.reload(function() {
                $("#btn_refresh_table").html(`Refresh`);
                $("#btn_refresh_table").prop("disabled", false);
            });
        }
    });
});


function initializefranchiseProductSaleDetailTable() {

     franchiseProductSaleDetailTable = $('#franchiseProductSaleDetailTable').DataTable({
        processing: true,
        serverSide: true,
        responsive: false,
        fixedHeader: true,
        destroy:true,
        scrollY: "500px",  
        scrollX: "auto",  
        scrollCollapse: true,
        ajax: {
            url: '{{ route("franchise.franchise_product_sale_details") }}',
            type: 'GET',
            data: function(d) {
                d.start_date = $('#start_date').val(),
                d.end_date = $('#end_date').val()
            }
        },
     columns: [
           {
                data: 'id_franchise_orders',
                title: 'Order ID',
                render: function (data, type, row) {
                    let url = "{{ route('franchise.view_franchise_order_invoice', ':id') }}";
                    url = url.replace(':id', data);

                    return `<a href="${url}" class="text-primary fw-bold">
                                ${data}
                            </a>`;
                }
            },
            { data: 'franchise_id', title: 'Franchise ID' },
            { data: 'franchise_name', title: 'Franchise' },
            { data: 'franchise_office_phone', title: 'Franchise Phone' },
            {
                data: 'invoice_number',
                title: 'Invoice#',
                render: function (data, type, row) {
                    let url = "{{ route('franchise.view_franchise_order_invoice', ':id') }}";
                    url = url.replace(':id', row.id_franchise_orders);

                    return `<a href="${url}" class="text-primary fw-bold" target="_blank">
                                ${data}
                            </a>`;
                }
            },
            {
                data: 'invoice_date',
                title: 'Inv Date',
                className: 'text-center'
            },
            { data: 'business_brand_name', title: 'Brand' },
            {
                data: 'product_id',
                title: 'Product Id',
                render: function (data, type, row) {
                    let url = "{{ route('products.batches', ':id_business_products') }}";
                    url = url.replace(':id', row.product_id);
                    return `<a href="${url}" class="text-primary fw-bold" target="_blank">
                                ${data}
                            </a>`;
                }
            },
            { data: 'product_name', title: 'Product' },
            { data: 'category', title: 'Category' },
            { data: 'business_store', title: 'Store' },
            { data: 'staff_name', title: 'Sold By' },
            { data: 'unit_price', className: 'text-end', render: data => parseFloat(data || 0).toFixed(2)},
            { data: 'qty', className: 'text-end',render: data => parseFloat(data || 0).toFixed(2) },
            { data: 'total_amount', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2) },
            { data: 'discounted_price', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2) },
            { data: 'invoice_discount_amount', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2)},
            { data: 'product_tax', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2) },
            { data: 'invoice_sales_tax_amount', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2) },
            { data: 'net_amount', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2) },
            { data: 'cog', className: 'text-end' , render: data => parseFloat(data || 0).toFixed(2) }
        ],
        responsive: false,
        fixedHeader: true,
        buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
        ],
        "layout": {
                    topStart: "buttons",
                    topEnd: "search",
                    bottomStart: {           
                        pageLength: {
                            menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                        },
                        info: {}
                    },                
                    bottomEnd: "paging"     
        },
        ordering: true,
        // initComplete: function () {
        //     this.api()
        //         .columns([0, 1, 2,3,4, 5]) // Order ID, Franchise, Invoice, Brand, Product columns
        //         .every(function () {
        //             var column = this;
        //             var title = $(column.header()).text();
                    
        //             // Create input element
        //             var input = $('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />')
        //                 .appendTo($(column.header()).empty())
        //                 .on('keyup change clear', function () {
        //                     if (column.search() !== this.value) {
        //                         column.search(this.value).draw();
        //                     }
        //                 });
        //         });
        // },
       footerCallback: function (row, data) {
            var api = this.api();

            var intVal = function (i) {
                return typeof i === 'string'
                    ? i.replace(/[\$,]/g, '') * 1
                    : typeof i === 'number'
                    ? i
                    : 0;
            };

            let cols = [13,14,15,16,17,18,19,20]; 
            // qty → net_amount
            cols.forEach(function (idx) {
                var total = api.column(idx).data()
                    .reduce((a, b) => intVal(a) + intVal(b), 0);

                $(api.column(idx).footer()).html(total.toFixed(2));
            });
        }

    });
}

</script>
@endsection 