@extends('layouts.horizontal', ['title' => 'Gift Voucher', 'topbarTitle' => 'Print Gift Voucher', 'nonav' => true])

@section('css')
@endsection

@section('content')
<div class="row ">
    <div class="col-12">
        <div class="card">
            <div class="card-body font-monospace">
                <!-- Gift Vouchers Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div>
                        <img src="{{ asset('images/business') . '/'. ($business->business_logo ?? 'logo-dark.png') }}" alt="dark logo" style="max-height: 72px;">     
                        <div class="mt-2">                            
                            <h6 class="fs-14 mb-0 lh-base font-monospace"> {!! $business->business_address !!} </h6>
                            <h6 class="fs-14 mb-2 font-monospace">Phone: {{ $business->business_phone }}</h6>
                        </div>   
                         <div style="text-align: left;" class="mt-3">
                            <h6 class="fs-14 fw-bolder mb-0 font-monospace">{{ $voucher->customer_name }}</h6>
                            <abbr class="fs-14 mb-2 font-monospace">{{ $voucher->customer_cell }}</abbr>
                         </div>                
                    </div>
                    <div class="text-end">
                        <h6 class="m-0 fw-bolder fs-20 font-monospace">Gift Voucher</h6>
                        <h3 class="m-0 fw-bolder fs-20 font-monospace">Gift Voucher: #{{ $voucher->voucher_number }}</h3>

                        <div style="text-align: left;" class="mt-3">
                            <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">ID: {{ $voucher->id_order_vouchers }}</h6>
                            <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Created On: {{ \Carbon\Carbon::parse($voucher->voucher_date)->format('d M Y') }}</h6>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    @if($voucher->voucher_heading != "" && $voucher->voucher_heading != null)
                        <div class="mb-3">
                            <h3 class="fw-bolder font-monospace">{{ $voucher->voucher_heading }}</h3>
                        </div>
                    @endif
                    <div class="">
                        <table class="table table-borderless table-sm text-left align-middle mb-0 ">
                            <thead>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="border-0" scope="col" style="width: 50px;">#</th>
                                    <th class="border-0" scope="col" style="width: 50px;">Item</th>
                                    <th class="border-0" scope="col" style="width: 50px;">Description</th>
                                    <th class="border-0 text-end" scope="col" style="width: 50px;">Value</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $row=1; $total=0; @endphp                                
                                    <tr>                                        
                                        <td>{{ $row }}</td>
                                        <td class="">{{ $voucher->service_names }}</td>
                                        <td class="">{{ $voucher->type }}</td>
                                        <td class="text-end">{{ $voucher->voucher_value }}</td>
                                    </tr>                                
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="3" class="text-end">Service Worth:</th>
                                    <th class="text-end">{{ number_format($voucher->voucher_value,2) }}</th>
                                </tr>
                                <tr>
                                    <th colspan="3" class="text-end">Tax:</th>
                                    <th class="text-end">{{ number_format($voucher->voucher_tax,2) }}</th>
                                </tr>
                                <tr class="border-bottom">
                                    <th colspan="3" class="text-end">CC Fee:</th>
                                    <th class="text-end">{{ number_format($voucher->voucher_cccharge,2) }}</th>
                                </tr>
                                <tr class="">
                                    <th colspan="3" class="text-end fw-normal">Total Amount:</th>
                                    <th class="text-end  fw-normal">{{ number_format($voucher->amount,2) }}</th>
                                </tr>
                                <tr class="">
                                    <th colspan="3" class="text-end  fw-normal">Used Amount:</th>
                                    <th class="text-end  fw-normal">{{ number_format($voucher->amount - $voucher->remaining_amount,2) }}</th>
                                </tr>
                                <tr class="">
                                    <th colspan="3" class="text-end  fw-normal">Remaining:</th>
                                    <th class="text-end  fw-normal">{{ number_format($voucher->remaining_amount,2) }}</th>
                                </tr>
                                <tr class="">
                                    <th colspan="3" class="text-end  fw-normal">Validity:</th>
                                    <th class="text-end  fw-normal">{{ \Carbon\Carbon::parse($voucher->valid_until)->format('d M Y') }}</th>
                                </tr>
                            </tfoot>
                        </table>                        
                    </div>
                </div>                              
            </div>
            <div class="card-footer bg-transparent border-top d-print-none">
                <div class="d-print-none mb-5">
                    <div class="d-flex justify-content-center gap-2">
                        <a href="javascript:window.print()" class="btn btn-primary"><i
                                class="ti ti-printer me-1"></i> Print</a>
                        <a href="javascript: void(0);" class="btn btn-secondary"><i class="ti ti-send me-1"></i>
                            Send</a>
                    
                    </div>
                </div>
            </div>  
        </div>
    </div>
</div>

@endsection