@extends('layouts.horizontal', ['title' => 'Gift Vouchers', 'topbarTitle' => 'Gift Vouchers'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

<div class="Tvouchers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Gift Vouchers</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row {{ session('user_role') != 'Super User' && session('user_role') != 'Super Admin' ? 'd-none' : '' }}">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filter Vouchers</div>
                    <!-- <form id="invoicesform" method="GET" action="today_invoices/todayinvoicesdata"> -->                        
                        <div class="row">                                            
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                
                                <label class="form-label" for="voucherDate">Select Date</label>
                                <input type="date" class="form-control" id="voucherDate" name="start_date" value="{{ $today ?? date('Y-m-d') }}" placeholder="Select Date" required>
                            </div>
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                <button id="btn_refresh_table" type="button" class="btn btn-sm btn-primary mt-4" >Run</button>
                            </div>                            
                        </div>
                    <!-- </form> -->
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="gift_vouchers_table" class="table table-bordered table-sm w-100 fs-12">
                        <thead>
                            <tr>
                                <th>Voucher Code</th>
                                <th>Issued To</th>
                                <th>Voucher Type</th>
                                <th>Amount</th>
                                <th>Remaining</th>
                                <th>Remaining Services</th>
                                <th>Issued On</th>
                                <th>Expiry Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
{{-- Edit Gift Voucher Modal --}}
<div class="modal fade" id="editGiftVoucherModal" tabindex="-1" aria-labelledby="editGiftVoucherModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editGiftVoucherModalLabel">Edit Gift Voucher</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editGiftVoucherForm">
                <div class="modal-body">
                     @csrf                
                     <div class="row">
                        <div class="col-12 mb-3">                            
                            <label for="edit_voucher_heading" class="form-label">Heading</label>
                            <textarea id="edit_voucher_heading" name="voucher_heading" class="form-control" rows="2"></textarea>
                        
                        </div>
                     </div>
                    <div class="row">
                        <div class="col-6 gap-3">
                            <input type="hidden" id="edit_voucher_id" name="voucher_id">                            
                            <div class="mb-3">
                                <label for="edit_voucher_value" class="form-label">Voucher Value</label>
                                <input type="number" class="form-control" id="edit_voucher_value" name="voucher_value" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="edit_voucher_amount">Paid Amount</label>
                                <input type="number" class="form-control" id="edit_voucher_amount" name="amount" disabled>
                            </div>                            
                            <div class="mb-3">
                                <label for="edit_voucher_status" class="form-label">Voucher Status</label>
                                <select class="form-select" id="edit_voucher_status" name="voucher_status" required>
                                    <option value="open">Open</option>
                                    <option value="closed">Closed</option>
                                </select>
                            </div>
                           
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="edit_voucher_number" class="form-label">Voucher Number</label>
                                <input type="text" class="form-control" id="edit_voucher_number" name="voucher_number" disabled>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="edit_voucher_tax">Paid Tax</label>
                                <input type="number" class="form-control" id="edit_voucher_tax" name="voucher_tax" disabled>
                            </div>
                            <div class="mb-3">
                                <label for="edit_remaining_amount" class="form-label">Remaining Amount</label>
                                <input type="number" class="form-control" id="edit_remaining_amount" name="remaining_amount" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="edit_valid_until">Valid Until</label>
                                <input type="date" class="form-control" id="edit_valid_until" name="valid_until">
                            </div>
                            
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="button" onclick="save_voucher()" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
{{-- End Edit Gift Voucher Modal --}}
@endsection
@section('scripts')
<script>
     let baseURL = '{{ url("") }}'; // Use relative paths
    $(document).ready(function() {


         table = $('#gift_vouchers_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("gift_vouchers.giftvouchersdata") }}',
                type: 'GET',
                data: function (d) {
                    d.start_date = $('#voucherDate').val();   // custom parameter
                    d.is_todays_vouchers = false;   // flag to indicate this is Gift Vouchers (not Today's)
                }            
            },
            dataType: 'json',
            scrollX:true,
            scrollY: 350,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            fixedHeader: true,
            processing: true,
            serverSide: true,
            buttons: ['copy', 'print'],
            responsive: false,
            
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: [
                { data: 'voucher_number', name: 'voucher_number' },
                { data: 'customer_name', name: 'issued_to' },
                { data: 'type', name: 'voucher_type' },
                { data: 'amount', name: 'amount' },
                { data: 'remaining_amount', name: 'remaining_amount' },
                { data: 'service_names', name: 'remaining_services',
                    render: function(data, type, row) {
                        if(data){
                            let services = data.replaceAll('|', '<br>');
                            return services;
                        } else {
                            return '';
                        }
                    }
                },
                { data: 'voucher_date', name: 'issued_on' },
                { data: 'valid_until', name: 'expiry_date' },
                { data: 'voucher_status', name: 'status' },
                // Actions column with button
                { 
                    data: null, 
                    name: 'actions', 
                    orderable: false, 
                    searchable: false,
                    render: function (data, type, row) {
                        
                        var mRoute = "{{ url('gift_voucher_print') }}/" + row.id_order_vouchers;

                        return `
                            <a target="_blank" href="${mRoute}" 
                            class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn"
                            data-id="${row.id_order_vouchers}">
                                <iconify-icon icon="line-md:watch-loop" class="fs-20"></iconify-icon>
                            </a>
                            <button onclick="open_edit_modal(${data.id_order_vouchers});" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success edit-btn" data-id="${row.id_order_vouchers}">
                                    <iconify-icon icon="line-md:edit-twotone" class="fs-20"></iconify-icon>
                                </button>
                        `;

                    }
                }
            ],
            order: [[6, 'desc']],
            responsive: false,
        });
        $('#btn_refresh_table').click(function() {
           // table.draw();
            table.ajax.reload(); 
        });

    });

    function open_edit_modal(voucher_id) {
        @if(session()->get('user_role') == 'Super User' || session()->get('user_role') == 'Super Admin')
        // Fetch voucher details via AJAX
        $.ajax({
            url: baseURL + '/gift_voucher/' + voucher_id,
            type: 'GET',
            success: function(response) {
                data = response.data;
                // Populate the form fields
                $('#edit_voucher_id').val(data.id_order_vouchers);
                $('#edit_voucher_number').val(data.voucher_number);
                $('#edit_voucher_heading').val(data.voucher_heading);
                $('#edit_voucher_value').val(data.voucher_value);
                $('#edit_remaining_amount').val(data.remaining_amount);
                $('#edit_remaining_amount').attr('max', data.amount);
                $('#edit_voucher_tax').val(data.voucher_tax);
                $('#edit_voucher_amount').val(data.amount);
                $('#edit_valid_until').val(data.valid_until);
                $('#edit_voucher_status').val(data.voucher_status);
                
                // Show the modal
                var El = document.getElementById('editGiftVoucherModal');
                var modal = new bootstrap.Modal(El);
                modal.show();
                
            },
            error: function() {
                alert('Failed to fetch voucher details.');
            }
        });
        @else
            Swal.fire({
                icon: 'error',
                title: 'Access Denied',
                text: 'You do not have permission to edit vouchers.',
                confirmButtonText: 'OK',                
                customClass: {
                                confirmButton: 'btn btn-danger'
                            }
            });
        @endif
    }

    function save_voucher() {
        
        var formData = {
            voucher_id: $('#edit_voucher_id').val(),
            voucher_value: $('#edit_voucher_value').val(),
            remaining_amount: $('#edit_remaining_amount').val(),
            voucher_tax: $('#edit_voucher_tax').val(),
            amount: $('#edit_voucher_amount').val(),
            valid_until: $('#edit_valid_until').val(),
            voucher_status: $('#edit_voucher_status option:selected').val(),
            voucher_heading: $('#edit_voucher_heading').val(),
            voucher_number: $('#edit_voucher_number').val(),
            _token: '{{ csrf_token() }}'
        };

        $.ajax({
            url: '{{ route('update_gift_voucher') }}',
            type: 'POST',
            data: formData,
            success: function(response) {
                if(response.message_type == 'success') {
                    // Close the modal
                    var El = document.getElementById('editGiftVoucherModal');
                    var modal = bootstrap.Modal.getInstance(El);
                    modal.hide();

                    // Reload the DataTable
                    table.ajax.reload();

                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'Voucher updated successfully.',
                        confirmButtonText: 'OK',
                        customClass: {
                                confirmButton: 'btn btn-success'
                            }
                    });
                } else {
                    toastr.error(response.message);
                }
            },
            error: function() {
                toastr.error(response.message);
            }
        });
    }
</script>

@endsection