@extends('layouts.horizontal', ['title' => 'Commission Breakdown', 'topbarTitle' => 'Commission Breakdown'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css',
'node_modules/select2/dist/css/select2.min.css'])
<style>
    .nav-tabs .nav-link {
        color: #6c757d;
        font-weight: 500;
        padding: 10px 20px;
    }
    .invoice-badge {
        font-size: 0.75rem;
        padding: 3px 8px;
    }
    .table-hover tbody tr:hover {
        background-color: rgba(13, 110, 253, 0.05);
    }
    .commission-rate {
        font-weight: bold;
        color: #198754;
    }
    .target-badge {
        background-color: #ffc107;
        color: #000;
    }
    .achieved-badge {
        background-color: #198754;
        color: #fff;
    }
    .not-achieved-badge {
        background-color: #dc3545;
        color: #fff;
    }
    .amount-cell {
        text-align: right !important;
    }
    .no-data-row td {
        text-align: center !important;
        padding: 40px !important;
    }
    .commission-type-badge {
        font-size: 0.7rem;
        padding: 2px 6px;
    }
    .summary-card {
        border-radius: 10px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .summary-value {
        font-size: 1.5rem;
        font-weight: bold;
    }
    .discounted-price {
        color: #6c757d;
        font-size: 0.9rem;
        text-decoration: line-through;
    }
    .logic-indicator {
        font-size: 0.75rem;
        padding: 2px 6px;
        border-radius: 3px;
        background-color: #e9ecef;
        color: #495057;
    }
    .fixed-amount-note {
        font-size: 0.85rem;
        color: #6c757d;
        font-style: italic;
    }
    .fixed-amount-text {
        font-style: italic;
        color: #6c757d;
        font-size: 0.9rem;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Commission Breakdown</h2>
                    <p class="text-muted mb-0">
                        <strong>{{ $staff->staff_fullname }}</strong> | 
                        {{ date('F Y', mktime(0, 0, 0, $month, 1, $year)) }}
                    </p>
                </div>
                <div class="action-buttons">
                    <button class="btn btn-outline-success export-csv">
                        <iconify-icon icon="mdi:file-export"></iconify-icon> Export CSV
                    </button>
                    <button class="btn btn-outline-secondary print-tab">
                        <iconify-icon icon="mdi:printer"></iconify-icon> Print
                    </button>
                    <a href="{{ route('hrm.staff_payment_calculator', [
                        'staff' => $staff->id_staff,
                        'month' => $month,
                        'year' => $year,
                        'business_id' => $businessId
                    ]) }}" class="btn btn-outline-primary">
                        <iconify-icon icon="mdi:arrow-left"></iconify-icon> Back to Calculator
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Commission Summary Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card commission-card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h4 class="card-title">Commission Settings</h4>
                            <div class="row">
                                <div class="col-6">
                                    <p class="mb-1"><strong>Mode:</strong></p>
                                    <span class="badge bg-{{ $staffInfo->commission_mode == 'Target' ? 'warning' : 'info' }}">
                                        {{ $staffInfo->commission_mode ?? 'Services' }}
                                    </span>
                                </div>
                                <div class="col-6">
                                    <p class="mb-1"><strong>Rate/Amount:</strong></p>
                                    @if($hasFixedAmount)
                                        <span class="badge bg-success">
                                            Fixed: {{ number_format($staffInfo->commission_fixed_amount, 2) }}
                                        </span>
                                    @elseif($staffInfo->commission_mode == 'Target')
                                        <span class="badge bg-primary">{{ $staffInfo->staff_commission_perc ?? 0 }}%</span>
                                    @else
                                        <span class="badge bg-info">Pre-calculated</span>
                                    @endif
                                </div>
                                @if($staffInfo->commission_mode == 'Target')
                                <div class="col-12 mt-2">
                                    <p class="mb-1"><strong>Target:</strong></p>
                                    @php
                                        $serviceTotalDiscounted = $serviceCommissionData['summary']['monthly_sales'] ?? 0;
                                        $retailTotalDiscounted = $retailCommissionData['summary']['monthly_sales'] ?? 0;
                                        $totalAchieved = $serviceTotalDiscounted + $retailTotalDiscounted;
                                        $commissionTarget = $staffInfo->commission_target ?? 0;
                                    @endphp
                                    <span class="badge {{ $totalAchieved >= $commissionTarget ? 'achieved-badge' : 'not-achieved-badge' }}">
                                        Target: {{ number_format($commissionTarget, 2) }}
                                        | Achieved: {{ number_format($totalAchieved, 2) }}
                                        @if($commissionTarget > 0)
                                        ({{ number_format(($totalAchieved / $commissionTarget) * 100, 1) }}%)
                                        @endif
                                    </span>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h4 class="card-title">Monthly Summary</h4>
                            <div class="row">
                                <div class="col-6">
                                    <div class="text-center p-2 bg-light rounded summary-card">
                                        <h3 class="mb-0 text-primary">{{ number_format($totalCommission, 2) }}</h3>
                                        <small class="text-muted">Total Commission</small>
                                        @if($hasFixedAmount)
                                            <div><small class="text-muted">(Fixed Amount)</small></div>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 bg-light rounded summary-card">
                                        <h3 class="mb-0 text-success">{{ number_format(($serviceCommissionData['summary']['total_discounted_price'] ?? 0) + ($retailCommissionData['summary']['total_discounted_price'] ?? 0), 2) }}</h3>
                                        <small class="text-muted">Total Sales (Discounted)</small>
                                    </div>
                                </div>
                                <div class="col-6 mt-2">
                                    <div class="text-center p-2 bg-light rounded summary-card">
                                        <h3 class="mb-0 text-info">{{ ($serviceCommissionData['summary']['total_services'] ?? 0) + ($retailCommissionData['summary']['total_products'] ?? 0) }}</h3>
                                        <small class="text-muted">Total Items</small>
                                    </div>
                                </div>
                                <div class="col-6 mt-2">
                                    @php
                                        $totalDiscounted = ($serviceCommissionData['summary']['total_discounted_price'] ?? 0) + ($retailCommissionData['summary']['total_discounted_price'] ?? 0);
                                        $avgRate = $totalDiscounted > 0 ? ($totalCommission / $totalDiscounted * 100) : 0;
                                    @endphp
                                    @if($staffInfo->commission_mode == 'Services')
                                        <div class="text-center p-2 bg-light rounded summary-card">
                                            <h3 class="mb-0 text-secondary">0.00%</h3>
                                            <small class="text-muted">Avg Commission Rate</small>
                                            <div><small class="text-muted">(Pre-calculated commissions)</small></div>
                                        </div>
                                    @elseif($hasFixedAmount)
                                        <div class="text-center p-2 bg-light rounded summary-card">
                                            <h3 class="mb-0 text-secondary">{{ number_format($avgRate, 2) }}%</h3>
                                            <small class="text-muted">Effective Commission Rate</small>
                                            <div><small class="text-muted">(Based on achieved fixed amount)</small></div>
                                        </div>
                                    @else
                                        <div class="text-center p-2 bg-light rounded summary-card">
                                            <h3 class="mb-0 text-warning">{{ number_format($avgRate, 2) }}%</h3>
                                            <small class="text-muted">Avg Commission Rate</small>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Fixed Amount Allocation Display -->
                    @if($hasFixedAmount)
                    <div class="row mt-3">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <h6 class="mb-2"><iconify-icon icon="mdi:information"></iconify-icon> Fixed Amount Allocation:</h6>
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong>Service Commission:</strong> 
                                        @if($serviceCommissionData['summary']['service_commission_share'] > 0)
                                            {{ number_format($serviceCommissionData['summary']['service_commission_share'], 2) }}
                                            @if($serviceCommissionData['summary']['has_retail_invoices'])
                                                (50% of fixed amount)
                                            @else
                                                (100% of fixed amount)
                                            @endif
                                        @else
                                            0.00 (No allocation)
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <strong>Retail Commission:</strong> 
                                        @if($retailCommissionData['summary']['retail_commission_share'] > 0)
                                            {{ number_format($retailCommissionData['summary']['retail_commission_share'], 2) }}
                                            @if($retailCommissionData['summary']['has_service_invoices'])
                                                (50% of fixed amount)
                                            @else
                                                (100% of fixed amount)
                                            @endif
                                        @else
                                            0.00 (No allocation)
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Tab Navigation -->
    <div class="row mb-4">
        <div class="col-12">
            <ul class="nav nav-tabs nav-tabs-custom" id="commissionTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="service-tab" data-bs-toggle="tab" 
                            data-bs-target="#service-tab-pane" type="button" role="tab">
                        <iconify-icon icon="mdi:account-cash" class="me-2"></iconify-icon>
                        Service Commission
                        <span class="badge bg-primary ms-2">{{ $serviceCommissionData['summary']['total_services'] ?? 0 }}</span>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="retail-tab" data-bs-toggle="tab" 
                            data-bs-target="#retail-tab-pane" type="button" role="tab">
                        <iconify-icon icon="mdi:shopping" class="me-2"></iconify-icon>
                        Retail Commission
                        <span class="badge bg-success ms-2">{{ $retailCommissionData['summary']['total_products'] ?? 0 }}</span>
                    </button>
                </li>
            </ul>
        </div>
    </div>

    <!-- Tab Content -->
    <div class="row">
        <div class="col-12">
            <div class="tab-content" id="commissionTabsContent">
                <!-- Service Commission Tab -->
                <div class="tab-pane fade show active" id="service-tab-pane" role="tabpanel">
                    <div class="card">
                        <div class="card-body">
                            <!-- Summary Cards -->
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="card bg-primary text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">{{ number_format($serviceCommissionData['summary']['total_discounted_price'] ?? 0, 2) }}</h3>
                                            <p class="mb-0">Total Discounted Sales</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-success text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">{{ number_format($serviceCommissionAllocated, 2) }}</h3>
                                            <p class="mb-0">Service Commission</p>
                                            @if($hasFixedAmount)
                                                <small class="opacity-75">
                                                    @if($serviceCommissionData['summary']['service_commission_share'] > 0)
                                                        ({{ number_format($serviceCommissionData['summary']['service_commission_share'], 2) }} allocated)
                                                    @else
                                                        (No commission allocated)
                                                    @endif
                                                </small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-info text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">{{ $serviceCommissionData['summary']['total_services'] ?? 0 }}</h3>
                                            <p class="mb-0">Total Services</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-warning text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">
                                                @if($hasFixedAmount)
                                                    N/A
                                                @else
                                                    {{ number_format($serviceCommissionData['summary']['average_commission_rate'] ?? 0, 2) }}%
                                                @endif
                                            </h3>
                                            <p class="mb-0">
                                                @if($hasFixedAmount)
                                                    Fixed Commission
                                                @else
                                                    Avg Commission Rate
                                                @endif
                                            </p>
                                            @if($hasFixedAmount)
                                                <small class="opacity-75">(No individual rates)</small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Service Details Table -->
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0" id="serviceTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Invoice No</th>
                                            <th>Business</th>
                                            <th>Service</th>
                                            <th class="text-end">Original Price</th>
                                            <th class="text-end">Discounted Price</th>
                                            <th class="text-end">Paid</th>
                                            <th class="text-end">Commission</th>
                                            @if(!$hasFixedAmount && $staffInfo->commission_mode == 'Target')
                                            <th class="text-end">Rate</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $serviceDetails = $serviceCommissionData['details'] ?? collect([]);
                                        @endphp
                                        @forelse($serviceDetails as $index => $service)
                                        @php
                                            $discountedPrice = $service->discounted_price ?? 0;
                                            $serviceCommission = $service->calculated_commission ?? $service->original_commission ?? 0;
                                            $commissionRate = $discountedPrice > 0 ? ($serviceCommission / $discountedPrice * 100) : 0;
                                        @endphp
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ date('d-M-Y', strtotime($service->invoice_date)) }}</td>
                                            <td>
                                                <span class="badge bg-light text-dark invoice-badge">
                                                    {{ $service->invoice_number }}
                                                </span>
                                            </td>
                                            <td>{{ $service->business_name ?? 'N/A' }}</td>
                                            <td>{{ $service->service_name }}</td>
                                            <td class="text-end">{{ number_format($service->final_price, 2) }}</td>
                                            <td class="text-end">{{ number_format($discountedPrice, 2) }}</td>
                                            <td class="text-end">{{ number_format($service->paid, 2) }}</td>
                                            <td class="text-end">
                                                @if($hasFixedAmount)
                                                    <span class="fixed-amount-text">Fixed Amount</span>
                                                @else
                                                    <span class="fw-bold text-success">
                                                        {{ number_format($serviceCommission, 2) }}
                                                    </span>
                                                @endif
                                            </td>
                                            @if(!$hasFixedAmount && $staffInfo->commission_mode == 'Target')
                                            <td class="text-end">
                                                <span class="commission-rate">
                                                    {{ number_format($commissionRate, 2) }}%
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr class="no-data-row">
                                            <td colspan="{{ !$hasFixedAmount && $staffInfo->commission_mode == 'Target' ? '10' : '9' }}">
                                                <div class="text-muted py-4">
                                                    <iconify-icon icon="mdi:file-search-outline" style="font-size: 48px;"></iconify-icon>
                                                    <h5 class="mt-2">No Service Commissions Found</h5>
                                                    <p>No service commissions recorded for this period.</p>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Retail Commission Tab -->
                <div class="tab-pane fade" id="retail-tab-pane" role="tabpanel">
                    <div class="card">
                        <div class="card-body">
                            <!-- Summary Cards -->
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="card bg-primary text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">{{ number_format($retailCommissionData['summary']['total_discounted_price'] ?? 0, 2) }}</h3>
                                            <p class="mb-0">Total Discounted Sales</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-success text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">{{ number_format($retailCommissionAllocated, 2) }}</h3>
                                            <p class="mb-0">Retail Commission</p>
                                            @if($hasFixedAmount)
                                                <small class="opacity-75">
                                                    @if($retailCommissionData['summary']['retail_commission_share'] > 0)
                                                        ({{ number_format($retailCommissionData['summary']['retail_commission_share'], 2) }} allocated)
                                                    @else
                                                        (No commission allocated)
                                                    @endif
                                                </small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-info text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">{{ $retailCommissionData['summary']['total_products'] ?? 0 }}</h3>
                                            <p class="mb-0">Total Products</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-warning text-white">
                                        <div class="card-body text-center">
                                            <h3 class="mb-1">
                                                @if($hasFixedAmount)
                                                    N/A
                                                @else
                                                    {{ number_format($retailCommissionData['summary']['average_commission_rate'] ?? 0, 2) }}%
                                                @endif
                                            </h3>
                                            <p class="mb-0">
                                                @if($hasFixedAmount)
                                                    Fixed Commission
                                                @else
                                                    Avg Commission Rate
                                                @endif
                                            </p>
                                            @if($hasFixedAmount)
                                                <small class="opacity-75">(No individual rates)</small>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Retail Details Table -->
                            <div class="table-responsive">
                                <table class="table table-hover table-centered mb-0" id="retailTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Invoice No</th>
                                            <th>Business</th>
                                            <th>Product</th>
                                            <th class="text-end">Qty</th>
                                            <th class="text-end">Unit Price</th>
                                            <th class="text-end">Discounted Price</th>
                                            <th class="text-end">Commission</th>
                                            @if(!$hasFixedAmount && $staffInfo->commission_mode == 'Target')
                                            <th class="text-end">Rate</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $retailDetails = $retailCommissionData['details'] ?? collect([]);
                                        @endphp
                                        @forelse($retailDetails as $index => $product)
                                        @php
                                            $discountedPrice = $product->discounted_price ?? 0;
                                            $quantity = $product->invoice_qty ?? 1;
                                            $unitPrice = $discountedPrice / $quantity;
                                            $productCommission = $product->calculated_commission ?? $product->original_commission ?? 0;
                                            $commissionRate = $discountedPrice > 0 ? ($productCommission / $discountedPrice * 100) : 0;
                                        @endphp
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ date('d-M-Y', strtotime($product->invoice_date)) }}</td>
                                            <td>
                                                <span class="badge bg-light text-dark invoice-badge">
                                                    {{ $product->invoice_number }}
                                                </span>
                                            </td>
                                            <td>{{ $product->business_name ?? 'N/A' }}</td>
                                            <td>{{ $product->product_name }}</td>
                                            <td class="text-end">{{ $quantity }}</td>
                                            <td class="text-end">{{ number_format($unitPrice, 2) }}</td>
                                            <td class="text-end">{{ number_format($discountedPrice, 2) }}</td>
                                            <td class="text-end">
                                                @if($hasFixedAmount)
                                                    <span class="fixed-amount-text">Fixed Amount</span>
                                                @else
                                                    <span class="fw-bold text-success">
                                                        {{ number_format($productCommission, 2) }}
                                                    </span>
                                                @endif
                                            </td>
                                            @if(!$hasFixedAmount && $staffInfo->commission_mode == 'Target')
                                            <td class="text-end">
                                                <span class="commission-rate">
                                                    {{ number_format($commissionRate, 2) }}%
                                                </span>
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr class="no-data-row">
                                            <td colspan="{{ !$hasFixedAmount && $staffInfo->commission_mode == 'Target' ? '10' : '9' }}">
                                                <div class="text-muted py-4">
                                                    <iconify-icon icon="mdi:cart-off" style="font-size: 48px;"></iconify-icon>
                                                    <h5 class="mt-2">No Retail Commissions Found</h5>
                                                    <p>No retail commissions recorded for this period.</p>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@vite(['resources/js/app.js'])
<script>
    $(document).ready(function() {
        // Initialize DataTables only if there's data
        if ($('#serviceTable tbody tr:not(.no-data-row)').length > 0) {
            $('#serviceTable').DataTable({
                pageLength: 10,
                responsive: true,
                order: [[1, 'desc']],
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>tip',
                language: {
                    search: "_INPUT_",
                    searchPlaceholder: "Search services...",
                    emptyTable: "No service commissions found",
                    zeroRecords: "No matching service commissions found"
                },
                columnDefs: [
                    { 
                        targets: '_all',
                        orderable: true
                    }
                ]
            });
        }

        if ($('#retailTable tbody tr:not(.no-data-row)').length > 0) {
            $('#retailTable').DataTable({
                pageLength: 10,
                responsive: true,
                order: [[1, 'desc']],
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>tip',
                language: {
                    search: "_INPUT_",
                    searchPlaceholder: "Search products...",
                    emptyTable: "No retail commissions found",
                    zeroRecords: "No matching retail commissions found"
                },
                columnDefs: [
                    { 
                        targets: '_all',
                        orderable: true
                    }
                ]
            });
        }

        // Tab click handler to update URL
        $('#commissionTabs .nav-link').on('click', function() {
            const tabName = $(this).attr('id').replace('-tab', '');
            history.pushState(null, null, `#${tabName}`);
        });

        // Handle browser back/forward
        window.addEventListener('popstate', function() {
            const hash = window.location.hash.substring(1);
            if (hash) {
                const tabElement = document.getElementById(`${hash}-tab`);
                if (tabElement) {
                    const tab = new bootstrap.Tab(tabElement);
                    tab.show();
                }
            }
        });

        // Set active tab from URL hash
        const hash = window.location.hash.substring(1);
        if (hash) {
            const tabElement = document.getElementById(`${hash}-tab`);
            if (tabElement) {
                const tab = new bootstrap.Tab(tabElement);
                tab.show();
            }
        }

        // Export buttons
        $(document).on('click', '.export-csv', function() {
            const activeTab = $('#commissionTabs .nav-link.active').attr('id');
            const tableId = activeTab === 'service-tab' ? 'serviceTable' : 'retailTable';
            exportToCSV(tableId);
        });

        $(document).on('click', '.print-tab', function() {
            const activeTab = $('#commissionTabs .nav-link.active').attr('id');
            const tableId = activeTab === 'service-tab' ? 'serviceTable' : 'retailTable';
            const title = activeTab === 'service-tab' ? 'Service Commission Report' : 'Retail Commission Report';
            printTable(tableId, title);
        });

        function exportToCSV(tableId) {
            const table = document.getElementById(tableId);
            if (!table) return;
            
            const rows = table.querySelectorAll('tr');
            let csv = [];
            
            rows.forEach(row => {
                const rowData = [];
                row.querySelectorAll('th, td').forEach(cell => {
                    if (!cell.classList.contains('no-export')) {
                        // Remove HTML tags and extra whitespace
                        const cellText = cell.innerText.replace(/\n/g, ' ').replace(/,/g, '').trim();
                        rowData.push(cellText);
                    }
                });
                csv.push(rowData.join(','));
            });
            
            const csvContent = csv.join('\n');
            const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            const activeTab = $('#commissionTabs .nav-link.active').attr('id');
            const fileName = activeTab === 'service-tab' ? 'service_commissions' : 'retail_commissions';
            a.download = `${fileName}_${new Date().toISOString().slice(0,10)}.csv`;
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            window.URL.revokeObjectURL(url);
        }

        function printTable(tableId, title) {
            const printWindow = window.open('', '_blank');
            const table = document.getElementById(tableId);
            if (!table) return;
            
            const tableClone = table.cloneNode(true);
            // Remove DataTables classes and inline styles
            $(tableClone).removeClass('dataTable');
            $(tableClone).find('thead th').css('background-color', '#f5f5f5');
            $(tableClone).find('tfoot td').css('background-color', '#e9ecef');
            
            // Remove icons from cloned table
            $(tableClone).find('iconify-icon').remove();
            
            const tableHtml = tableClone.outerHTML;
            const staffName = "{{ $staff->staff_fullname }}";
            const period = "{{ date('F Y', mktime(0, 0, 0, $month, 1, $year)) }}";
            const commissionMode = "{{ $staffInfo->commission_mode ?? 'Services' }}";
            const commissionRate = "{{ $hasFixedAmount ? 'Fixed: ' . number_format($staffInfo->commission_fixed_amount, 2) : $staffInfo->staff_commission_perc . '%' }}";
            const commissionTarget = "{{ $staffInfo->commission_target ?? 0 }}";
            const totalAchieved = "{{ ($serviceCommissionData['summary']['monthly_sales'] ?? 0) + ($retailCommissionData['summary']['monthly_sales'] ?? 0) }}";
            
            printWindow.document.write(`
                <html>
                    <head>
                        <title>${title}</title>
                        <style>
                            body { font-family: Arial, sans-serif; margin: 20px; font-size: 12px; }
                            h2 { color: #333; border-bottom: 2px solid #333; padding-bottom: 10px; }
                            table { width: 100%; border-collapse: collapse; margin-top: 20px; font-size: 11px; }
                            th { background-color: #f5f5f5 !important; border: 1px solid #ddd; padding: 6px; text-align: left; font-weight: bold; }
                            td { border: 1px solid #ddd; padding: 6px; text-align: left; }
                            .text-end { text-align: right; }
                            .header-info { margin-bottom: 20px; }
                            .header-info p { margin: 5px 0; }
                            .summary-box { 
                                background-color: #f8f9fa; 
                                border: 1px solid #dee2e6; 
                                padding: 15px; 
                                margin-bottom: 20px;
                                border-radius: 5px;
                            }
                            .summary-row { display: flex; justify-content: space-between; margin-bottom: 5px; }
                            .summary-label { font-weight: bold; }
                            .discounted-price { color: #666; font-size: 0.9em; text-decoration: line-through; }
                            .logic-info { background-color: #e7f3ff; padding: 10px; border-radius: 5px; margin: 10px 0; font-size: 11px; }
                            .logic-info h6 { margin: 0 0 5px 0; color: #0c63e4; }
                            .fixed-amount-text { font-style: italic; color: #666; }
                            @media print {
                                body { margin: 0; font-size: 10px; }
                                .no-print { display: none; }
                                table { font-size: 9px; }
                                th, td { padding: 4px; }
                                .summary-box, .logic-info { break-inside: avoid; }
                            }
                            @page { size: auto; margin: 10mm; }
                        </style>
                    </head>
                    <body>
                        <div class="header-info">
                            <h2>${title}</h2>
                            <div class="summary-box">
                                <div class="summary-row">
                                    <span class="summary-label">Staff:</span>
                                    <span>${staffName}</span>
                                </div>
                                <div class="summary-row">
                                    <span class="summary-label">Period:</span>
                                    <span>${period}</span>
                                </div>
                                <div class="summary-row">
                                    <span class="summary-label">Commission Mode:</span>
                                    <span>${commissionMode}</span>
                                </div>
                                <div class="summary-row">
                                    <span class="summary-label">Commission Rate/Amount:</span>
                                    <span>${commissionRate}</span>
                                </div>
                                <div class="summary-row">
                                    <span class="summary-label">Target:</span>
                                    <span>${commissionTarget} (Achieved: ${totalAchieved})</span>
                                </div>
                                <div class="summary-row">
                                    <span class="summary-label">Printed on:</span>
                                    <span>${new Date().toLocaleDateString()} ${new Date().toLocaleTimeString()}</span>
                                </div>
                            </div>
                        </div>
                        ${tableHtml}
                    </body>
                </html>
            `);
            
            printWindow.document.close();
            setTimeout(() => {
                printWindow.print();
                printWindow.close();
            }, 500);
        }
    });
</script>
@endsection