@extends('layouts.horizontal', ['title' => 'Leave Applications', 'topbarTitle' => 'Leave Applications'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/dropzone/dist/dropzone.css',
'node_modules/select2/dist/css/select2.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    /* Custom notification styles */
    .alert-notification {
        border-left-width: 5px;
        border-radius: 8px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }
    .alert-warning {
        border-left-color: #ffc107;
        background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        color: #856404 !important;
    }
    
    .alert-warning h5,
    .alert-warning strong,
    .alert-warning .badge-warning {
        color: #856404 !important;
    }
    
    .alert-warning small {
        color: #856404 !important;
        opacity: 0.9;
    }

    /* Improved contrast for green success alerts - DARK TEXT */
    .alert-success {
        border-left-color: #28a745;
        background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        color: #155724 !important;
    }
    
    .alert-success h5,
    .alert-success strong,
    .alert-success .badge-success {
        color: #155724 !important;
    }
    
    .alert-success small {
        color: #155724 !important;
        opacity: 0.9;
    }

    /* Danger alerts - WHITE TEXT on dark red */
    .alert-danger {
        border-left-color: #dc3545;
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white !important;
    }
    
    .alert-danger h5,
    .alert-danger strong,
    .alert-danger .badge-danger {
        color: white !important;
    }
    
    .alert-danger small {
        color: white !important;
        opacity: 0.9;
    }

    /* Info alerts - DARK TEXT */
    .alert-info {
        border-left-color: #17a2b8;
        background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%);
        color: #0c5460 !important;
    }
    
    .alert-info h5,
    .alert-info strong,
    .alert-info .badge-info {
        color: #0c5460 !important;
    }
    
    .alert-info small {
        color: #0c5460 !important;
        opacity: 0.9;
    }

    /* Badge styles */
    .badge-leave {
        font-size: 1rem;
        padding: 6px 14px;
        border-radius: 20px;
        font-weight: 700;
    }
    
    .badge-warning {
        background-color: #ffc107 !important;
        color: #856404 !important;
        border: 1px solid #d39e00;
    }
    
    .badge-success {
        background-color: #28a745 !important;
        color: white !important;
        border: 1px solid #1e7e34;
    }
    
    .badge-danger {
        background-color: #dc3545 !important;
        color: white !important;
        border: 1px solid #bd2130;
    }

    /* Modal adjustments */
    .modal-body .alert {
        animation: slideIn 0.3s ease-out;
        margin: 15px 0;
        font-size: 1.1rem;
    }
    
    /* Larger font sizes for better readability */
    .modal-body .alert h5 {
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 8px;
    }
    
    .modal-body .alert .close {
        font-size: 1.8rem;
        color: rgba(0, 0, 0, 0.6);
    }
    
    .modal-body .alert-warning .close {
        color: #856404;
    }
    
    .modal-body .alert-success .close {
        color: #155724;
    }
    
    .modal-body .alert-danger .close {
        color: white;
    }
    
    .modal-body .alert-info .close {
        color: #0c5460;
    }

    @keyframes slideIn {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Loading overlay */
    #loadingOverlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        z-index: 9999;
        display: none;
        justify-content: center;
        align-items: center;
    }
    
    .spinner-border {
        width: 3rem;
        height: 3rem;
    }
    
    .status-badge {
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 500;
    }
    .status-pending { background-color: #fff3cd; color: #856404; }
    .status-approved { background-color: #d4edda; color: #155724; }
    .status-rejected { background-color: #f8d7da; color: #721c24; }
    
    /* Filter styles */
    .filter-row { background-color: #f9f9f9; }
    .form-filter { font-size: 12px; padding: 4px 6px; height: 30px; width: 100%; }
    .filter-row th { padding: 4px 6px !important; vertical-align: middle; }
    .filter-buttons { display: flex; gap: 5px; }
    .filter-buttons button { padding: 4px 8px; font-size: 12px; }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Leave Applications</h2>
                 <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if(session('Success'))
    <div class="row">
        <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{ session('Success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        </div>
    </div>
    @endif

    @if(session('Error'))
    <div class="row">
        <div class="col-12">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Error!</strong> {{ session('Error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        </div>
    </div>
    @endif

    <!-- Business Selector Section - Only show for HO users -->
    @if(session('ho') === 'Yes')
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row align-items-center">
                                <div class="col-md-12">
                                <label class="form-label">Select Business</label>
                                <select class="form-control select2" id="businessSelector">
                                    <option value="">All Businesses</option>
                                    @foreach($businesses as $biz)
                                        <option value="{{ $biz->id_business }}" 
                                            {{ (request()->get('business_id') == $biz->id_business) ? 'selected' : '' }}>
                                            {{ $biz->business_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Applications Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="leave_applications_table" class="table table-bordered dt-responsive fs-13 w-100">
                        <thead>
                            <tr>
                                <th>Application ID</th>
                                <th>Staff ID</th>
                                <th>Staff Name</th>
                                <th>Business Name</th>
                                <th>Leave Type</th>
                                <th>Required From</th>
                                <th>Required To</th>
                                <th>Status</th>
                                <th>Updated By</th>
                                <th>Updated On</th>
                                <th>Actions</th>
                            </tr>
                            <tr class="filter filter-row">
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="id_leave_applications" placeholder="Search ID">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="staff_id" placeholder="Search Staff ID">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="staff_name" placeholder="Search Name">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="business_name" placeholder="Search Business">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="leave_type" placeholder="Search Leave Type">
                                </td>
                                <td>
                                    <input type="date" class="form-control form-filter input-sm" name="required_from" placeholder="Search From Date">
                                </td>
                                <td>
                                    <input type="date" class="form-control form-filter input-sm" name="required_to" placeholder="Search To Date">
                                </td>
                                <td>
                                    <select name="application_status" class="form-control form-filter input-sm">
                                        <option value="All">All</option>
                                        <option value="Pending">Pending</option>
                                        <option value="Approved">Approved</option>
                                        <option value="Rejected">Rejected</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="approved_by" placeholder="Search Updated By">
                                </td>
                                <td>
                                    <input type="date" class="form-control form-filter input-sm" name="approved_on" placeholder="Search Updated On">
                                </td>
                                <td>
                                    <div class="filter-buttons">
                                        <button class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon filter-submit">
                                            <iconify-icon icon="mdi:magnify" class="fs-22"></iconify-icon>
                                        </button>
                                        <button class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon filter-cancel">
                                            <iconify-icon icon="mdi:refresh" class="fs-22"></iconify-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Leave App Modal -->
<div id="editleaveapp" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="editleaveapp" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="updateLeaveApp">
                @csrf
                <input type="hidden" name="txtleaveid" id="txtleaveid" value="">
                <input type="hidden" name="txtstaffid" id="txtstaffid" value="">
                <div class="modal-header">
                    <h5 class="modal-title">Update Leave Application</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="txtstaffname" class="form-label">Staff Name:</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" id="txtstaffname" name="txtstaffname" class="form-control" readonly>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="txt_leave_type" class="form-label">Leave Type:</label>
                        </div>
                        <div class="col-md-6">
                            <input type="hidden" id="txt_leave_type_id" name="txt_leave_type">
                            <select class="form-control" name="txt_leave_type" id="txt_leave_type">
                                <option value="">Loading leave types...</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="txtreqfrom" class="form-label">Required From:</label>
                        </div>
                        <div class="col-md-6">
                            <input type="date" id="txtreqfrom" name="txtreqfrom" class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="txtreqto" class="form-label">Required To:</label>
                        </div>
                        <div class="col-md-6">
                            <input type="date" id="txtreqto" name="txtreqto" class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="txt_comment" class="form-label">Comments:</label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" class="form-control" name="txt_comment" id="txt_comment">
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="txt_leave_status" class="form-label">Status:</label>
                        </div>
                        <div class="col-md-6">
                            <select class="form-control" id="txt_leave_status" name="txt_leave_status">
                                <option value="Pending">Pending</option>
                                <option value="Approved">Approved</option>
                                <option value="Rejected">Rejected</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="row mb-3" id="status_reason_row" style="display: none;">
                        <div class="col-md-6">
                            <label for="status_reason" class="form-label">Reason:</label>
                        </div>
                        <div class="col-md-6">
                            <textarea class="form-control" name="status_reason" id="status_reason" rows="3"></textarea>
                        </div>
                    </div>
                    
                    <!-- Leave balance notification will be inserted here -->
                    <div id="leave_balance_container"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay">
    <div class="spinner-border text-light" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
</div>
@endsection

@section('scripts')

<script>
    $(document).ready(function() {
    initializeSelect2();
    initializeLeaveApplicationsTable();
    setupEventHandlers();
    setupBusinessChangeHandlers();
});

function initializeSelect2() {
    $('#businessSelector').select2({
        width: '100%'
    });
}

function setupBusinessChangeHandlers() {
    $('#businessSelector').on('change', function() {
        const businessId = $(this).val();
        
        // Update staff dropdown based on selected business
        updateStaffDropdown(businessId);
        
        // Reload the DataTable with new business filter
        if (window.leaveApplicationsTable) {
            window.leaveApplicationsTable.ajax.reload();
        }
    });
}

function initializeLeaveApplicationsTable() {
    window.leaveApplicationsTable = $('#leave_applications_table').DataTable({
        scrollX: true,
        scrollCollapse: true,
        orderCellsTop: true,
        fixedHeader: {
            header: true,
            footer: false
        },
        processing: true,
        serverSide: true,
        stateSave: true,
        stateDuration: -1,
        ajax: {
            url: "{{ route('hrm.get_leave_applications') }}",
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: function(d) {
                d.id_leave_applications = $('input[name="id_leave_applications"]').val();
                d.staff_id = $('input[name="staff_id"]').val();
                d.staff_name = $('input[name="staff_name"]').val();
                d.business_name = $('input[name="business_name"]').val();
                d.leave_type = $('input[name="leave_type"]').val();
                d.required_from = $('input[name="required_from"]').val();
                d.required_to = $('input[name="required_to"]').val();
                
                // Get status value
                const statusVal = $('select[name="application_status"]').val();
                d.application_status = statusVal;
                
                d.approved_by = $('input[name="approved_by"]').val();
                d.approved_on = $('input[name="approved_on"]').val();
                
                // Add business filter for HO users
                @if(session('ho') === 'Yes')
                    d.business_id = $('#businessSelector').val();
                @endif
                
                return d;
            }
        },
        columns: [
            { data: 'id_leave_applications', name: 'id_leave_applications', orderable: true, searchable: true },
            { data: 'staff_id', name: 'staff_id', orderable: true, searchable: true },
            { data: 'staff_name', name: 'staff_name', orderable: true, searchable: true },
            { data: 'business_name', name: 'business_name', orderable: true, searchable: true },
            { data: 'leave_type', name: 'leave_type', orderable: true, searchable: true },
            { data: 'required_from', name: 'required_from', orderable: true, searchable: true },
            { data: 'required_to', name: 'required_to', orderable: true, searchable: true },
            { 
                data: 'application_status', 
                name: 'application_status',
                orderable: true,
                searchable: true,
                render: function(data) {
                    let className = '';
                    switch(data.toLowerCase()) {
                        case 'approved':
                            className = 'status-approved';
                            break;
                        case 'rejected':
                            className = 'status-rejected';
                            break;
                        default:
                            className = 'status-pending';
                    }
                    return `<span class="status-badge ${className}">${data}</span>`;
                }
            },
            { data: 'approved_by', name: 'approved_by', orderable: true, searchable: true },
            { data: 'approved_on', name: 'approved_on', orderable: true, searchable: true },
            {
                data: null,
                orderable: false,
                searchable: false,
                className: 'action-buttons',
                render: function(data, type, row) {
                    // Don't show update button for approved leave requests
                    if (row.application_status === 'Approved') {
                        return `<span class="text-muted">Already Approved</span>`;
                    }
                    return `<button onclick="getLeaveApplicationData(${row.id_leave_applications})" class="btn btn-sm btn-primary">Update</button>`;
                }
            }
        ],
        order: [[0, 'desc']],
        language: {
            paginate: {
                previous: '<i class="ti ti-chevron-left"></i>',
                next: '<i class="ti ti-chevron-right"></i>'
            }
        },
        initComplete: function(settings, json) {
            var api = this.api();
            var filterRow = $(api.table().header()).find('tr.filter');
            filterRow.show();
        }
    });
}

function setupEventHandlers() {
    // Search button
    $(document).on('click', '.filter-submit', function(e) {
        e.preventDefault();
        refreshData();
    });

    // Reset button - clear all filters
    $(document).on('click', '.filter-cancel', function(e) {
        e.preventDefault();
        document.querySelectorAll('.form-filter').forEach(input => {
            input.value = '';
        });
        document.querySelectorAll('select.form-filter').forEach(select => {
            select.value = 'All';
        });
        
        refreshData();
    });

    // Auto-search when status changes
    $(document).on('change', 'select[name="application_status"]', function() {
        refreshData();
    });

    // Enter key in filter inputs
    $(document).on('keyup', '.form-filter', function(e) {
        if (e.keyCode === 13) {
            refreshData();
        }
    });

    // Handle status change event in modal
    $(document).on('change', '#txt_leave_status', function() {
        const status = $(this).val();
        if (status == 'Pending') {
            $('#status_reason_row').hide();
            $('#status_reason').attr("required", false);
        } else {
            $('#status_reason_row').show();
            $('#status_reason').attr("required", true);
            
            // If status changed to Approved, check leave balance
            if (status == 'Approved') {
                const staffId = $("#txtstaffid").val();
                const leaveTypeId = $("#txt_leave_type").val(); // Get ID directly from select
                if (staffId && leaveTypeId) {
                    fetchLeaveBalance(staffId, leaveTypeId);
                }
            }
        }
    });

    // Handle leave type change event in modal
    $(document).on('change', '#txt_leave_type', function() {
        const staffId = $("#txtstaffid").val();
        const leaveTypeId = $(this).val(); // Get ID directly
        
        // Update hidden input as well
        $("#txt_leave_type_id").val(leaveTypeId);
        
        if (staffId && leaveTypeId) {
            fetchLeaveBalance(staffId, leaveTypeId);
        }
    });

    // Handle form submission for updating leave application
    $('#updateLeaveApp').submit(function(e) {
        e.preventDefault();
        
        // Get the selected leave type ID
        const selectedLeaveTypeId = $("#txt_leave_type").val();
        const selectedLeaveTypeName = $("#txt_leave_type option:selected").text();
        
        if (!selectedLeaveTypeId) {
            Swal.fire({
                title: 'Error',
                text: 'Please select a leave type',
                icon: 'error',
                customClass: {
                    confirmButton: "btn btn-danger"
                },
                buttonsStyling: false
            });
            return;
        }
        
        // Update the hidden input to ensure we send the ID
        $("#txt_leave_type_id").val(selectedLeaveTypeId);
        
        Swal.fire({
            title: 'Are you sure?',
            text: `Do you want to update this leave application with "${selectedLeaveTypeName}"?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, update it!',
            cancelButtonText: 'Cancel',
            customClass: {
                confirmButton: "btn btn-danger me-2",
                cancelButton: "btn btn-warning"
            },
            buttonsStyling: false
        }).then((result) => {
            if (result.isConfirmed) {
                updateLeaveApplication();
            }
        });
    });
}

function refreshData() {
    if (window.leaveApplicationsTable) {
        window.leaveApplicationsTable.ajax.reload(null, false);
    }
}

// Function to update staff dropdown based on selected business
function updateStaffDropdown(businessId) {
    if (!businessId) {
        return;
    }
    
    $.ajax({
        url: '{{ route("hrm.get_staff_by_business") }}',
        type: 'GET',
        data: {
            business_id: businessId
        },
        success: function(response) {
            if (response.success) {
                console.log('Staff loaded for business:', businessId);
            }
        },
        error: function() {
            console.error('Failed to load staff for selected business');
        }
    });
}

// Main function to fetch application data via AJAX
function getLeaveApplicationData(applicationId) {
    showLoading();
    
    $.ajax({
        url: '{{ route("hrm.get_leave_application_data", "") }}/' + applicationId,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            hideLoading();
            
            if (response.success) {
                // Check if staff has policy assigned
                if (!response.staff_info.leave_policy_id) {
                    Swal.fire({
                        title: 'Policy Not Assigned',
                        text: 'Please assign a leave policy to this staff member first before updating leave applications.',
                        icon: 'warning',
                        customClass: {
                            confirmButton: "btn btn-warning"
                        },
                        buttonsStyling: false
                    });
                    return; // Don't open the modal
                }
                
                populateModal(response);
                // Explicitly show the modal
                var modal = new bootstrap.Modal(document.getElementById('editleaveapp'));
                modal.show();
                
                // Fetch leave balance after modal is shown
                if (response.application.leave_type_id) {
                    setTimeout(function() {
                        fetchLeaveBalance(response.application.staff_id, response.application.leave_type_id);
                    }, 500);
                }
            } else {
                Swal.fire({
                    title: 'Error',
                    text: response.message,
                    icon: 'error',
                    customClass: {
                        confirmButton: "btn btn-danger"
                    },
                    buttonsStyling: false
                });
            }
        },
        error: function(xhr) {
            hideLoading();
            Swal.fire({
                title: 'Error',
                text: 'Error loading application data. Please try again.',
                icon: 'error',
                customClass: {
                    confirmButton: "btn btn-danger"
                },
                buttonsStyling: false
            });
        }
    });
}

function populateModal(data) {
    const app = data.application;
    $("#txtleaveid").val(app.id_leave_applications);
    $("#txtstaffid").val(app.staff_id);
    $("#txtstaffname").val(app.staff_name || data.staff_info?.staff_fullname || '');
    $("#txtreqfrom").val(app.required_from);
    $("#txtreqto").val(app.required_to);
    $("#txt_comment").val(app.comments || '');
    $("#txt_leave_status").val(app.application_status);
    
    // Clear existing notifications
    $("#leave_balance_container").empty();
    
    // Clear and populate leave types dropdown using leave_type_id
    $("#txt_leave_type").html('<option value="">Select Leave Type</option>');
    
    if (data.leave_types && data.leave_types.length > 0) {
        data.leave_types.forEach(function(leaveType) {
            // Use leave_type_id for value
            const selected = (leaveType.id_leave_type == app.leave_type_id) ? 'selected' : '';
            $("#txt_leave_type").append(
                `<option value="${leaveType.id_leave_type}" data-name="${leaveType.leave_type}" ${selected}>${leaveType.leave_type}</option>`
            );
        });
    }
    
    // Set the hidden input with the current leave type ID
    if (app.leave_type_id) {
        $("#txt_leave_type_id").val(app.leave_type_id);
    }
    
    // Handle status reason field visibility
    if (app.application_status === 'Pending') {
        $('#status_reason_row').hide();
        $('#status_reason').attr("required", false);
    } else {
        $('#status_reason_row').show();
        $('#status_reason').attr("required", true);
    }
}

function fetchLeaveBalance(staffId, leaveTypeId) {
    // Get the requested dates from the form
    const requiredFrom = $("#txtreqfrom").val();
    const requiredTo = $("#txtreqto").val();
    
    if (!requiredFrom || !requiredTo) {
        displayErrorNotification('Please select required dates first');
        return;
    }
    
    // Show loading indicator
    $('#leave_balance_container').html('<div class="alert alert-info">Checking leave balance...</div>');
    
    $.ajax({
        url: '{{ route("hrm.get_leave_balance") }}',
        type: 'POST',
        data: {
            staff_id: staffId,
            leave_type_id: leaveTypeId,
            required_from: requiredFrom,
            required_to: requiredTo,
            _token: '{{ csrf_token() }}'
        },
        dataType: 'json',
        success: function(response) {
            $('#leave_balance_container').empty();
            
            if (response.success) {
                displayLeaveBalanceNotification(response.data);
            } else {
                displayErrorNotification(response.message || 'Failed to fetch leave balance');
            }
        },
        error: function(xhr) {
            $('#leave_balance_container').empty();
            displayErrorNotification('Error fetching leave balance');
        }
    });
}

function displayLeaveBalanceNotification(data) {
    let notificationClass = 'alert-info';
    let icon = '<i class="fa fa-info-circle"></i>';
    let message = '';
    
    if (data.policy_leaves === 0) {
        notificationClass = 'alert-warning';
        icon = '<i class="fa fa-exclamation-triangle"></i>';
        message = `<strong>${icon} Warning!</strong> ${data.staff_name} has no ${data.leave_type} policy defined.`;
        message += `<br><small>Policy ID: ${data.policy_id || 'Not Assigned'}</small>`;
    } else if (data.remaining_leaves <= 0) {
        notificationClass = 'alert-danger';
        icon = '<i class="fa fa-exclamation-triangle"></i>';
        message = `<strong>${icon} Warning!</strong> ${data.staff_name} has no ${data.leave_type}s remaining for ${data.requested_year}. `;
        message += `<br><small>Policy allows: ${data.policy_leaves}, Already consumed: ${data.consumed_leaves}, Policy: ${data.policy_name}</small>`;
        if (data.overlapping_leaves > 0) {
            message += `<br><small class="text-danger">⚠ There are ${data.overlapping_leaves} overlapping leaves in this date range</small>`;
        }
    } else if (data.remaining_leaves < 3) {
        notificationClass = 'alert-warning';
        icon = '<i class="fa fa-exclamation-triangle"></i>';
        message = `<strong>${icon} Note:</strong> ${data.staff_name} has only ${data.remaining_leaves} ${data.leave_type}s remaining for ${data.requested_year}. `;
        message += `<br><small>Policy allows: ${data.policy_leaves}, Already consumed: ${data.consumed_leaves}, Policy: ${data.policy_name}</small>`;
        if (data.overlapping_leaves > 0) {
            message += `<br><small class="text-warning">⚠ There are ${data.overlapping_leaves} overlapping leaves in this date range</small>`;
        }
    } else {
        notificationClass = 'alert-success';
        icon = '<i class="fa fa-check-circle"></i>';
        message = `<strong>${icon} Info:</strong> ${data.staff_name} has ${data.remaining_leaves} ${data.leave_type}s remaining for ${data.requested_year}. `;
        message += `<br><small>Policy allows: ${data.policy_leaves}, Already consumed: ${data.consumed_leaves}, Policy: ${data.policy_name}</small>`;
        if (data.overlapping_leaves > 0) {
            message += `<br><small class="text-info">⚠ Note: There are ${data.overlapping_leaves} overlapping leaves in this date range</small>`;
        }
    }
    
    const notificationDiv = $(`
        <div class="alert ${notificationClass} alert-dismissible show" role="alert" style="margin-top: 15px;">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            ${message}
        </div>
    `);
    
    $('#leave_balance_container').html(notificationDiv);
}

// Function to display error notification
function displayErrorNotification(message) {
    const notificationDiv = $(`
        <div class="alert alert-danger alert-dismissible fade show" role="alert" style="margin-top: 15px;">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong><i class="fa fa-exclamation-circle"></i> Error!</strong> ${message}
        </div>
    `);
    
    $('#leave_balance_container').html(notificationDiv);
}

// Function to update leave application
function updateLeaveApplication() {
    showLoading();
    
    // Make sure we're sending the ID, not the name
    const formData = $('#updateLeaveApp').serialize();
    
    $.ajax({
        url: '{{ route("hrm.update_leave_application") }}',
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            hideLoading();
            
            if (response.success) {
                Swal.fire({
                    title: 'Success',
                    text: response.message,
                    icon: 'success',
                    customClass: {
                        confirmButton: "btn btn-success"
                    },
                    buttonsStyling: false,
                    showConfirmButton: true,
                    allowOutsideClick: false,
                    allowEscapeKey: false
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Use Bootstrap 5 modal instance to close
                        const modal = bootstrap.Modal.getInstance(document.getElementById('editleaveapp'));
                        if (modal) {
                            modal.hide();
                        } else {
                            // Fallback method
                            $('#editleaveapp').modal('hide');
                        }
                        
                        // Refresh DataTable
                        if (window.leaveApplicationsTable) {
                            window.leaveApplicationsTable.ajax.reload(null, false);
                        }
                        
                        // Optional: Reset form
                        $('#updateLeaveApp')[0].reset();
                        $('#leave_balance_container').empty();
                    }
                });
            } else {
                // Show SweetAlert for any error
                Swal.fire({
                    title: 'Error',
                    text: response.message,
                    icon: 'error',
                    customClass: {
                        confirmButton: "btn btn-danger"
                    },
                    buttonsStyling: false
                });
            }
        }, 
        error: function(xhr) {
            hideLoading();
            Swal.fire({
                title: 'Error',
                text: 'Error updating leave application',
                icon: 'error',
                customClass: {
                    confirmButton: "btn btn-danger"
                },
                buttonsStyling: false
            });
        }
    });
}


// Loading overlay functions
function showLoading() {
    $('#loadingOverlay').show();
}

function hideLoading() {
    $('#loadingOverlay').hide();
}
</script>
@endsection


