@extends('layouts.horizontal', ['title' => 'Leave Types', 'topbarTitle' => 'Leave Types'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/dropzone/dist/dropzone.css',
'node_modules/select2/dist/css/select2.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    .switch {
        position: relative;
        display: inline-block;
        width: 45px;
        height: 22px;
    }

    .switch input {display:none;}

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #ccc;
        transition: .4s;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 16px;
        width: 16px;
        left: 4px;
        bottom: 3px;
        background-color: white;
        transition: .4s;
    }

    input:checked + .slider {
        background-color: #4CAF50;
    }

    input:checked + .slider:before {
        transform: translateX(22px);
    }

    .slider.round {
        border-radius: 22px;
    }

    .slider.round:before {
        border-radius: 50%;
    }
    
    .filter-row { background-color: #f9f9f9; }
    .form-filter { font-size: 12px; padding: 4px 6px; height: 30px; width: 100%; }
    .filter-row th { padding: 4px 6px !important; vertical-align: middle; }
    .dataTables_wrapper .dataTables_filter { float: right; }
    .dataTables_wrapper .dataTables_length { float: left; }
    .dataTables_wrapper .dataTables_paginate { float: right; }
    .filter-buttons { display: flex; gap: 5px; }
    .filter-buttons button { padding: 4px 8px; font-size: 12px; }
    .action-buttons { white-space: nowrap; }
    @media (max-width: 768px) {
        .business-filter-container {
            flex-direction: column;
            align-items: stretch;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Leave Types</h2>
                <div class="page-title-right">
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div id="alert-container">
        @if(session('Success'))
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('Success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        @endif
        
        @if(session('Error'))
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <strong>Error!</strong> {{ session('Error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="leave_types_table" class="table table-bordered dt-responsive fs-13 w-100">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>ID</th>
                                <th>Leave Type</th>
                                <th>Status</th>
                                <th>Created On</th>
                                <th>Business</th>
                                <th>Actions</th>
                            </tr>
                            <!-- Filter Row -->
                            <tr class="filter filter-row">
                                <td></td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="id_leave_type" placeholder="Search ID">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="leave_type" placeholder="Search Leave Type">
                                </td>
                                <td>
                                    <select class="form-control form-filter input-sm" name="status">
                                        <option value="">All Status</option>
                                        <option value="Active">Active</option>
                                        <option value="Inactive">Inactive</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm date-picker" name="created_on" placeholder="Search Date">
                                </td>
                                <td>
                                    <input type="text" class="form-control form-filter input-sm" name="business_name" placeholder="Search Business">
                                </td>
                                <td>
                                    <div class="filter-buttons">
                                        <button class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon filter-submit">
                                            <iconify-icon icon="mdi:magnify" class="fs-22"></iconify-icon>
                                        </button>
                                        <button class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon filter-cancel">
                                            <iconify-icon icon="mdi:refresh" class="fs-22"></iconify-icon>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Leave Type Modal -->
<div class="modal fade" id="addLeaveModal" tabindex="-1" aria-labelledby="addLeaveModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="POST" action="{{ route('hrm.add_leave_type') }}" id="addLeaveForm">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addLeaveModalLabel">Add New Leave Type</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Business ID is always the session business_id -->
                    <input type="hidden" name="business_id" value="{{ session('business_id') }}">
                    
                    <div class="mb-3">
                        <label for="leave_type" class="form-label">Leave Type Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="leave_type" name="leave_type" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection

@section('scripts')
@vite(['resources/js/app.js'])
<script>
    document.addEventListener('DOMContentLoaded', function() {
        initializeDatePickers();
        initializeLeaveTypesTable();
        setupEventHandlers();
    });
    
    let leaveTypesTable = null;
    
    function initializeDatePickers() {
        if (typeof flatpickr !== 'undefined') {
            flatpickr('.date-picker', {
                dateFormat: 'Y-m-d',
                allowInput: true
            });
        }
    }
    
    function initializeLeaveTypesTable() {
        if (typeof $.fn.DataTable === 'undefined') {
            console.error('DataTables is not loaded');
            return;
        }
        
        leaveTypesTable = $('#leave_types_table').DataTable({
            scrollX: true, 
            orderCellsTop: true,           
            scrollCollapse: true,
            fixedHeader: {
                header: true,
                footer: false
            },
            processing: true,
            serverSide: true,
            stateSave: true,
            responsive: false,
            ajax: {
                url: "{{ route('hrm.get_leave_types_data') }}",
                type: 'POST',
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                dataType: 'json',
                data: function (d) {
                    d.id_leave_type = $('input[name="id_leave_type"]').val();
                    d.leave_type = $('input[name="leave_type"]').val();
                    d.status = $('select[name="status"]').val();
                    d.created_on = $('input[name="created_on"]').val();
                    d.business_name = $('input[name="business_name"]').val();
                    
                    // NO business filter - always uses session business_id
                    
                    return JSON.stringify(d);
                },
                error: function (xhr, error, thrown) {
                    console.error('DataTables AJAX error:', error, thrown, xhr.responseText);
                    showAlert('error', 'Failed to load data. Please try again.');
                }
            },
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'></i>",
                    "next": "<i class='ti ti-chevron-right'></i>"
                }
            },
            lengthChange: true,
            pageLength: 10,
            searching: false,
            info: true,
            paging: true,
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
            ],
            layout: {
                topStart: 'buttons',
                topEnd: function() {
                    return '<div class="d-flex justify-content-end"><button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addLeaveModal"><iconify-icon icon="mdi:plus" class="me-1"></iconify-icon> Add Leave Type</button></div>';
                },
                bottomStart: {
                    pageLength: {
                        menu: [10, 25, 50, 100]
                    },
                    info: {}
                },
                bottomEnd: 'paging'
            },
            columns: [
                { 
                    data: null, 
                    name: 'sno',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                { data: 'id_leave_type', name: 'id_leave_type', orderable: true, searchable: true },
                { data: 'leave_type', name: 'leave_type', orderable: true, searchable: true },
                { 
                    data: 'status', 
                    name: 'status', 
                    orderable: true, 
                    searchable: true,
                    render: function(data, type, row) {
                        const badgeClass = data === 'Active' ? 'success' : 'danger';
                        return `<span class="badge bg-${badgeClass}">${data}</span>`;
                    }
                },
                { 
                    data: 'created_on_formatted', 
                    name: 'created_on', 
                    orderable: true, 
                    searchable: true,
                    render: function(data, type, row) {
                        return data || '-';
                    }
                },
                { 
                    data: 'business_name', 
                    name: 'business_name', 
                    orderable: true, 
                    searchable: true,
                    render: function(data, type, row) {
                        return data || '-';
                    }
                },
                { 
                    data: null, 
                    name: 'actions', 
                    orderable: false, 
                    searchable: false,
                    className: 'action-buttons',
                    render: function(data, type, row) {
                        const isChecked = row.status === 'Active';
                        return `
                            <label class="switch">
                                <input type="checkbox" class="toggleStatus" 
                                    data-id="${row.id_leave_type}" 
                                    ${isChecked ? 'checked' : ''}>
                                <span class="slider round"></span>
                            </label>
                        `;
                    }
                }
            ],
            initComplete: function(settings, json) {
                var api = this.api();
                var filterRow = $(api.table().header()).find('tr.filter');
                filterRow.show();
            }
        });
    }
    
    function setupEventHandlers() {
        // Toggle status
        $(document).on('change', '.toggleStatus', function () {
            const $this = $(this);
            const id = $this.data('id');
            const status = $this.is(':checked') ? 'Active' : 'Inactive';
            const row = $this.closest('tr');

            $.ajax({
                url: "{{ route('hrm.toggle_leave_status') }}",
                type: "POST",
                data: { 
                    id: id, 
                    status: status,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response){
                    if(response.status){
                        const badge = row.find('.badge');
                        badge.removeClass('bg-success bg-danger')
                            .addClass(status === 'Active' ? 'bg-success' : 'bg-danger')
                            .text(status);
                    } else {
                        $this.prop('checked', !$this.is(':checked'));
                        showAlert('error', response.message || 'Failed to update status. Please try again.');
                    }
                },
                error: function() {
                    $this.prop('checked', !$this.is(':checked'));
                    showAlert('error', 'Failed to update status. Please try again.');
                }
            });
        });
        
        // Filter submit
        $(document).on('click', '.filter-submit', function(e) {
            e.preventDefault();
            refreshData();
        });
        
        // Filter cancel
        $(document).on('click', '.filter-cancel', function(e) {
            e.preventDefault();
            $('.form-filter').val('');
            $('.form-filter').each(function() {
                if ($(this).is('select')) {
                    $(this).val('');
                }
            });
            refreshData();
        });
        
        // Enter key in filter inputs
        $(document).on('keyup', '.form-filter', function(e) {
            if (e.key === 'Enter') {
                refreshData();
            }
        });
        
        // Form submission
        $('#addLeaveForm').on('submit', function(e) {
            const leaveTypeInput = $('#leave_type');
            if (!leaveTypeInput.val().trim()) {
                e.preventDefault();
                showAlert('error', 'Leave type name is required.');
                leaveTypeInput.focus();
            }
        });
        
        // Reset form when modal is hidden
        $('#addLeaveModal').on('hidden.bs.modal', function() {
            $('#addLeaveForm')[0].reset();
        });
    }

    function refreshData() {
        if (leaveTypesTable) {
            leaveTypesTable.ajax.reload(null, false);
        }
    }

    function showAlert(type, message) {
        const alertHtml = `
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                        <strong>${type === 'success' ? 'Success!' : 'Error!'}</strong> ${message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        `;
        
        const container = $('#alert-container');
        if (container.length) {
            container.html(alertHtml);
            
            setTimeout(() => {
                container.find('.alert').alert('close');
            }, 5000);
        }
    }
</script>
@endsection