@extends('layouts.horizontal', ['title' => 'Mark Events', 'topbarTitle' => 'Mark Events'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/dropzone/dist/dropzone.css',
'node_modules/select2/dist/css/select2.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    .calendar-day {
        position: relative;
        cursor: pointer;
    }

    .holiday-dot {
        width: 6px;
        height: 6px;
        background: #b37393;
        border-radius: 50%;
        position: absolute;
        bottom: 6px;
        left: 50%;
        transform: translateX(-50%);
    }

    .overtime-dot {
        width: 6px;
        height: 6px;
        background: #b37393;
        border-radius: 50%;
        position: absolute;
        bottom: 6px;
        left: 50%;
        transform: translateX(-50%);
    }

    .calendar-container {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
    }
    
    .event-form-section {
        flex: 1;
        min-width: 300px;
        max-width: 400px;
    }
    
    .calendar-section {
        flex: 2;
        min-width: 400px;
    }
    
    .simple-calendar {
        background: #fff;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    .calendar-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .calendar-navigation {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    
    .calendar-title {
        font-size: 1.25rem;
        font-weight: 600;
        color: #374151;
    }
    
    .calendar-month-year {
        font-size: 1.1rem;
        font-weight: 500;
        color: #6b7280;
        width: 220px;
        text-align: center;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        flex-shrink: 0;
    }
    
    .calendar-year-select {
        border: 1px solid #d1d5db;
        background: #fff;
        font-size: 1rem;
        font-weight: 500;
        color: #374151;
        padding: 4px 8px;
        border-radius: 6px;
        cursor: pointer;
        transition: all 0.2s;
        min-width: 70px;
    }
    
    .calendar-year-select:hover {
        background: #f3f4f6;
        border-color: #9ca3af;
    }
    
    .calendar-year-select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }
    
    /* Select2 styling for calendar year select */
    .calendar-month-year .select2-container {
        width: auto !important;
        min-width: 70px;
    }
    
    .calendar-month-year .select2-container--default .select2-selection--single {
        border: 1px solid #d1d5db;
        border-radius: 6px;
        background: #fff;
        height: auto;
        padding: 4px 8px;
        transition: all 0.2s;
    }
    
    .calendar-month-year .select2-container--default .select2-selection--single:hover {
        background: #f3f4f6;
        border-color: #9ca3af;
    }
    
    .calendar-month-year .select2-container--default.select2-container--focus .select2-selection--single {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }
    
    .calendar-month-year .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #374151;
        font-size: 1rem;
        font-weight: 500;
        padding: 0;
        line-height: 1.5;
    }
    
    .calendar-month-year .select2-container--default .select2-selection--single .select2-selection__arrow {
        display: none;
    }
    
    .nav-btn {
        background: #f3f4f6;
        border: 1px solid #d1d5db;
        border-radius: 6px;
        width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .nav-btn:hover {
        background: #e5e7eb;
        border-color: #9ca3af;
    }
    
    .nav-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    /* Calendar Days Grid */
    .calendar-days {
        display: grid;
        grid-template-columns: repeat(7, 1fr);
        gap: 4px;
    }

    .calendar-day-header {
        font-weight: 600;
        text-align: center;
        padding: 8px 0;
        color: #6b7280;
        font-size: 14px;
        text-transform: uppercase;
        border-bottom: 1px solid #e5e7eb;
        margin-bottom: 4px;
    }

    .calendar-day {
        border: 1px solid #e5e7eb;
        height: 70px;
        padding: 6px;
        border-radius: 6px;
        font-size: 13px;
        background: #fff;
        position: relative;
        cursor: pointer;
        transition: all 0.2s;
        overflow: hidden;
    }

    .calendar-day.empty {
        background: transparent;
        border: none;
        cursor: default;
    }

    .calendar-day.holiday {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        border-color: #dc2626;
        box-shadow: 0 2px 4px rgba(239, 68, 68, 0.1);
    }

    .calendar-day.overtime {
       background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        border-color: #dc2626;
        box-shadow: 0 2px 4px rgba(59, 130, 246, 0.1);
    }

    .calendar-day:hover:not(.empty) {
        background: #f3f4f6;
        transform: translateY(-1px);
    }

    .calendar-day.holiday:hover:not(.empty) {
        background: linear-gradient(135deg, #fecaca 0%, #fca5a5 100%);
    }

    .calendar-day.overtime:hover:not(.empty) {
        background: linear-gradient(135deg, #fecaca 0%, #fca5a5 100%);
    }

    .calendar-day .date {
        font-weight: 600;
        font-size: 14px;
        color: #374151;
    }

    .calendar-day.holiday .date {
        color: #dc2626;
    }

    .calendar-day.overtime .date {
        color: #dc2626;
    }

    .calendar-day .event-name {
        display: block;
        font-size: 11px;
        margin-top: 4px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        width: 100%;
        max-height: 14px;
        line-height: 1.2;
    }

    .calendar-day .event-name {
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
        max-height: 14px;
        line-height: 1.2;
        word-wrap: break-word;
    }

    .calendar-day.holiday .event-name {
        color: #dc2626;
    }

    .calendar-day.overtime .event-name {
       color: #dc2626;
    }

    .calendar-day[data-bs-toggle="tooltip"] {
        position: relative;
    }

    .tooltip {
        --bs-tooltip-bg: #374151;
        --bs-tooltip-color: #fff;
        --bs-tooltip-font-size: 12px;
        --bs-tooltip-max-width: 250px;
        --bs-tooltip-padding-x: 8px;
        --bs-tooltip-padding-y: 6px;
        --bs-tooltip-border-radius: 6px;
    }

    .tooltip .tooltip-inner {
        max-width: 250px;
        word-wrap: break-word;
        white-space: normal;
        text-align: left;
    }

    /* Event Form Styles */
    .event-form-card {
        background: #fff;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        height: 100%;
    }
    
    .event-list {
        margin-top: 20px;
        max-height: 300px;
        overflow-y: auto;
    }
    
    .event-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        margin-bottom: 8px;
        background: #f9fafb;
    }
    
    .event-date {
        font-weight: 500;
        color: #374151;
        min-width: 100px;
    }
    
    .event-name {
        flex: 1;
        margin: 0 10px;
        color: #6b7280;
        font-size: 13px;
    }
    
    .remove-event {
        color: #6b7280;
        background: none;
        border: none;
        cursor: pointer;
        padding: 5px;
        border-radius: 4px;
        transition: background 0.2s;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .remove-event:hover {
        background: #e5e7eb;
    }

    /* Today indicator */
    .calendar-day.today {
        border: 2px solid #3b82f6;
        background: #eff6ff;
    }

    .calendar-day.today .date {
        color: #1d4ed8;
        font-weight: 700;
    }

    .calendar-day.today.holiday {
        border-color: #dc2626;
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    }

    .calendar-day.today.overtime {
        border-color: #dc2626;
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    }

    /* Tab Styles */
    .nav-tabs {
        border-bottom: 1px solid #e5e7eb;
        margin-bottom: 20px;
    }

    .nav-tabs .nav-link {
        border: none;
        color: #6b7280;
        font-weight: 500;
        padding: 10px 20px;
        margin-right: 5px;
        border-radius: 6px 6px 0 0;
    }

    .nav-tabs .nav-link:hover {
        color: #374151;
        background-color: #f3f4f6;
    }

    .nav-tabs .nav-link.active {
        color: #374151;
        background-color: white;
        border: 1px solid #e5e7eb;
        border-bottom-color: white;
        font-weight: 600;
    }

    .tab-content {
        padding-top: 0;
    }

    .tab-pane {
        display: none;
    }

    .tab-pane.active {
        display: block;
    }
    
    /* Dot colors */
    .holiday-dot {
        width: 6px;
        height: 6px;
        background: #dc2626;
        border-radius: 50%;
        position: absolute;
        bottom: 6px;
        left: 50%;
        transform: translateX(-50%);
    }

    .overtime-dot {
        width: 6px;
        height: 6px;
        background: #dc2626;
        border-radius: 50%;
        position: absolute;
        bottom: 6px;
        left: 50%;
        transform: translateX(-50%);
    }

    /* Leave specific styles */
    .leave-dot {
        width: 6px;
        height: 6px;
        background: #10b981;
        border-radius: 50%;
        position: absolute;
        bottom: 6px;
        left: 50%;
        transform: translateX(-50%);
    }

    .calendar-day.leave {
        background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
        border-color: #10b981;
        box-shadow: 0 2px 4px rgba(16, 185, 129, 0.1);
    }

    .calendar-day.leave .date {
        color: #10b981;
    }

    .calendar-day.leave .event-name {
        color: #10b981;
    }

    .calendar-day.today.leave {
        border-color: #10b981;
        background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    }

    .leave-info-box {
        background: #f0fdf4;
        border: 1px solid #d1fae5;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 20px;
    }

    .leave-stats {
        display: flex;
        gap: 20px;
        margin-top: 10px;
    }

    .stat-item {
        flex: 1;
        text-align: center;
        padding: 10px;
        background: white;
        border-radius: 6px;
        border: 1px solid #e5e7eb;
    }

    .stat-value {
        font-size: 24px;
        font-weight: bold;
        color: #10b981;
    }

    .stat-label {
        font-size: 12px;
        color: #6b7280;
        margin-top: 5px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .calendar-container {
            flex-direction: column;
        }
        
        .event-form-section,
        .calendar-section {
            min-width: 100%;
        }
        
        .calendar-day {
            height: 60px;
            padding: 4px;
        }
        
        .calendar-day .date {
            font-size: 12px;
        }
        
        .calendar-day .event-name {
            font-size: 10px;
            max-height: 12px;
        }
        
        .leave-stats {
            flex-direction: column;
            gap: 10px;
        }
    }

    @media (max-width: 480px) {
        .calendar-day {
            height: 55px;
            padding: 3px;
        }
        
        .calendar-day .date {
            font-size: 11px;
        }
        
        .calendar-day .event-name {
            font-size: 9px;
            max-height: 11px;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Mark Events</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card-box">
                <!-- Tabs -->
                <ul class="nav nav-tabs" id="eventTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ $isHO ? 'active' : '' }}" id="holidays-tab" data-bs-toggle="tab" data-bs-target="#holidays" type="button" role="tab">
                            Gazetted Holidays
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ $isHO ? '' : 'active' }}" id="overtime-tab" data-bs-toggle="tab" data-bs-target="#overtime" type="button" role="tab">
                            Overtime Days
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link {{ !$isHO ? '' : '' }}" id="staffleaves-tab" data-bs-toggle="tab" data-bs-target="#staffleaves" type="button" role="tab">
                            Staff Leaves
                        </button>
                    </li>
                </ul>

                <div class="tab-content" id="eventTabsContent">
                    <!-- Holidays Tab -->
                    <div class="tab-pane fade {{ $isHO ? 'show active' : '' }}" id="holidays" role="tabpanel" tabindex="0">
                        <div class="calendar-container">
                            <!-- Left Side: Holiday Form -->
                            <div class="event-form-section">
                                <div class="event-form-card">
                                    <h5 class="mb-3">Add New Holiday</h5>
                                    <form id="holidayForm" method="post">
                                        @csrf
                                        <input type="hidden" name="event_id" id="holiday_event_id">
                                        <input type="hidden" name="business_id" id="holiday_business_id" value="{{ $businessId }}">
                                        
                                        <!-- Business Selector for HO Users -->
                                        @if($isHO && $hoAccounts === 'Yes')
                                        <div class="form-group mb-3">
                                            <label class="form-label">Select Business:</label>
                                            <select class="form-control select2" id="holiday_business_select" name="business_id" required>
                                                <option value="">Select Business</option>
                                                @foreach($businesses as $business)
                                                    <option value="{{ $business->id_business }}" {{ $businessId == $business->id_business ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @else
                                        <input type="hidden" id="holiday_business_select" value="{{ $businessId }}">
                                        @endif

                                        <div class="form-group mb-3">
                                            <label class="form-label">Date Range:</label>
                                            <input type="text" class="form-control" id="holiday_dateRange" name="holiday_date_range" placeholder="Select date range" readonly required>
                                            <input type="hidden" id="holiday_start_date" name="holiday_start_date">
                                            <input type="hidden" id="holiday_end_date" name="holiday_end_date">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label class="form-label">Holiday Name:</label>
                                            <input type="text" class="form-control" id="holiday_txtName" name="holiday_reason" placeholder="Enter holiday name" required>
                                        </div>
                                        <div class="form-group mb-3" style="display: none;">
                                            <label class="form-label">Year:</label>
                                            <select class="form-control" id="holiday_selectYear" name="year">
                                                @for($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                                    <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary w-100">
                                            <i class="ti ti-plus me-1"></i> Add Holiday
                                        </button>
                                    </form>

                                    <!-- Holidays List -->
                                    <div class="event-list" id="holidayList">
                                        <h6 class="mt-4 mb-3">Existing Holidays</h6>
                                        <div id="holidayListContent">
                                            <!-- Holidays will be loaded here -->
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Side: Calendar -->
                            <div class="calendar-section">
                                <div class="simple-calendar">
                                    <div class="calendar-header">
                                        <h5 class="calendar-title">Holiday Calendar</h5>
                                        <div class="calendar-navigation">
                                            <button class="nav-btn" id="holiday_prevMonth">
                                                <i class="ti ti-chevron-left"></i>
                                            </button>
                                            <span class="calendar-month-year">
                                                <span id="holiday_currentMonth"></span> 
                                                <select class="calendar-year-select" id="holiday_headerYearSelect">
                                                    @for($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                                        <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                                    @endfor
                                                </select>
                                            </span>
                                            <button class="nav-btn" id="holiday_nextMonth">
                                                <i class="ti ti-chevron-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="holiday_calendarContainer">
                                        <!-- Calendar will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Overtime Days Tab -->
                    <div class="tab-pane fade {{ $isHO ? '' : 'show active' }}" id="overtime" role="tabpanel" tabindex="0">
                        <div class="calendar-container">
                            <!-- Left Side: Overtime Form -->
                            <div class="event-form-section">
                                <div class="event-form-card">
                                    <h5 class="mb-3">Add New Overtime Day</h5>
                                    <form id="overtimeForm" method="post">
                                        @csrf
                                        <input type="hidden" name="event_id" id="overtime_event_id">
                                        <input type="hidden" name="business_id" id="overtime_business_id" value="{{ $businessId }}">
                                        
                                        <!-- Business Selector for HO Users -->
                                        @if($isHO && $hoAccounts === 'Yes')
                                        <div class="form-group mb-3">
                                            <label class="form-label">Select Business:</label>
                                            <select class="form-control select2" id="overtime_business_select" name="business_id" required>
                                                <option value="">Select Business</option>
                                                @foreach($businesses as $business)
                                                    <option value="{{ $business->id_business }}" {{ $businessId == $business->id_business ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @else
                                        <input type="hidden" id="overtime_business_select" value="{{ $businessId }}">
                                        @endif

                                        <div class="form-group mb-3">
                                            <label class="form-label">Date Range:</label>
                                            <input type="text" class="form-control" id="overtime_dateRange" name="overtime_date_range" placeholder="Select date range" readonly required>
                                            <input type="hidden" id="overtime_start_date" name="overtime_start_date">
                                            <input type="hidden" id="overtime_end_date" name="overtime_end_date">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label class="form-label">Overtime Reason:</label>
                                            <input type="text" class="form-control" id="overtime_txtName" name="overtime_reason" placeholder="Enter overtime reason" required>
                                        </div>
                                        <div class="form-group mb-3" style="display: none;">
                                            <label class="form-label">Year:</label>
                                            <select class="form-control" id="overtime_selectYear" name="year">
                                                @for($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                                    <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary w-100">
                                            <i class="ti ti-plus me-1"></i> Add Overtime Day
                                        </button>
                                    </form>

                                    <!-- Overtime List -->
                                    <div class="event-list" id="overtimeList">
                                        <h6 class="mt-4 mb-3">Existing Overtime Days</h6>
                                        <div id="overtimeListContent">
                                            <!-- Overtime days will be loaded here -->
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Side: Calendar -->
                            <div class="calendar-section">
                                <div class="simple-calendar">
                                    <div class="calendar-header">
                                        <h5 class="calendar-title">Overtime Days Calendar</h5>
                                        <div class="calendar-navigation">
                                            <button class="nav-btn" id="overtime_prevMonth">
                                                <i class="ti ti-chevron-left"></i>
                                            </button>
                                            <span class="calendar-month-year">
                                                <span id="overtime_currentMonth"></span> 
                                                <select class="calendar-year-select" id="overtime_headerYearSelect">
                                                    @for($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                                        <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                                    @endfor
                                                </select>
                                            </span>
                                            <button class="nav-btn" id="overtime_nextMonth">
                                                <i class="ti ti-chevron-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="overtime_calendarContainer">
                                        <!-- Calendar will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Staff Leaves Tab -->
                    <div class="tab-pane fade" id="staffleaves" role="tabpanel" tabindex="0">
                        <div class="calendar-container">
                            <!-- Left Side: Staff Leave Form -->
                            <div class="event-form-section">
                                <div class="event-form-card">
                                    <h5 class="mb-3">Mark Staff Leave</h5>
                                    <form id="staffLeaveForm" method="post">
                                        @csrf
                                        <input type="hidden" name="event_id" id="staff_leave_event_id">
                                        <input type="hidden" name="business_id" id="staff_leave_business_id" value="{{ $businessId }}">
                                        
                                        <!-- Business Selector for HO Users with ho_accounts access -->
                                        @if($isHO && $hoAccounts === 'Yes')
                                        <div class="form-group mb-3">
                                            <label class="form-label">Select Business:</label>
                                            <select class="form-control select2" id="staff_leave_business_select" name="business_id" required>
                                                <option value="">Select Business</option>
                                                @foreach($businesses as $business)
                                                    <option value="{{ $business->id_business }}" {{ $businessId == $business->id_business ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @else
                                        <input type="hidden" id="staff_leave_business_select" value="{{ $businessId }}">
                                        @endif

                                        <!-- Staff Selector -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Select Staff:</label>
                                            <select class="form-control select2" id="staff_leave_staff_select" name="staff_id" required {{ (($isHO && $hoAccounts === 'Yes') || !$isHO) && $businessId ? '' : 'disabled' }}>
                                                <option value="">Select {{ ($isHO && $hoAccounts === 'Yes') ? 'Business First' : 'Staff' }}</option>
                                            </select>
                                        </div>

                                        <!-- Date Range -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Date Range:</label>
                                            <input type="text" class="form-control" id="staff_leave_dateRange" name="staff_leave_date_range" placeholder="Select date range" readonly required>
                                            <input type="hidden" id="staff_leave_start_date" name="staff_leave_start_date">
                                            <input type="hidden" id="staff_leave_end_date" name="staff_leave_end_date">
                                        </div>

                                        <!-- Leave Type -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Leave Type:</label>
                                            <select class="form-control" id="staff_leave_type_select" name="leave_type_id" required disabled>
                                                <option value="">Select Staff First</option>
                                            </select>
                                        </div>

                                        <!-- Leave Reason -->
                                        <div class="form-group mb-3">
                                            <label class="form-label">Leave Reason:</label>
                                            <input type="text" class="form-control" id="staff_leave_reason" name="leave_reason" placeholder="Enter leave reason" required>
                                        </div>

                                        <!-- Leave Statistics -->
                                        <div class="leave-info-box" id="leave_info_box" style="display: none;">
                                            <h6 class="mb-2">Leave Balance</h6>
                                            <div class="leave-stats">
                                                <div class="stat-item">
                                                    <div class="stat-value" id="allowed_leaves">0</div>
                                                    <div class="stat-label">Allowed</div>
                                                </div>
                                                <div class="stat-item">
                                                    <div class="stat-value" id="consumed_leaves">0</div>
                                                    <div class="stat-label">Consumed</div>
                                                </div>
                                                <div class="stat-item">
                                                    <div class="stat-value" id="remaining_leaves">0</div>
                                                    <div class="stat-label">Remaining</div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group mb-3" style="display: none;">
                                            <label class="form-label">Year:</label>
                                            <select class="form-control" id="staff_leave_selectYear" name="year">
                                                @for($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                                    <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary w-100">
                                            <i class="ti ti-plus me-1"></i> Mark Leave
                                        </button>
                                    </form>

                                    <!-- Staff Leaves List -->
                                    <div class="event-list" id="staffLeaveList">
                                        <h6 class="mt-4 mb-3">Existing Staff Leaves</h6>
                                        <div id="staffLeaveListContent">
                                            <!-- Staff leaves will be loaded here -->
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Side: Calendar -->
                            <div class="calendar-section">
                                <div class="simple-calendar">
                                    <div class="calendar-header">
                                        <h5 class="calendar-title">Staff Leaves Calendar</h5>
                                        <div class="calendar-navigation">
                                            <button class="nav-btn" id="staff_leave_prevMonth">
                                                <i class="ti ti-chevron-left"></i>
                                            </button>
                                            <span class="calendar-month-year">
                                                <span id="staff_leave_currentMonth"></span> 
                                                <select class="calendar-year-select" id="staff_leave_headerYearSelect">
                                                    @for($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                                        <option value="{{ $i }}" {{ $i == date('Y') ? 'selected' : '' }}>{{ $i }}</option>
                                                    @endfor
                                                </select>
                                            </span>
                                            <button class="nav-btn" id="staff_leave_nextMonth">
                                                <i class="ti ti-chevron-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="staff_leave_calendarContainer">
                                        <!-- Calendar will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@vite(['resources/js/app.js'])
<script>
// Global variables for all tabs
let holidayCurrentDate = new Date();
let overtimeCurrentDate = new Date();
let staffLeaveCurrentDate = new Date();
let allHolidays = [];
let allOvertimeDays = [];
let allStaffLeaves = [];

// Flatpickr instances
let holidayFlatpickr = null;
let overtimeFlatpickr = null;
let staffLeaveFlatpickr = null;

// Current selected staff and leave type
let currentSelectedStaffId = null;
let currentSelectedLeaveTypeId = null;
let currentSelectedYear = new Date().getFullYear();

// Flags to prevent infinite loops when syncing year selects
let isSyncingHolidayYear = false;
let isSyncingOvertimeYear = false;
let isSyncingStaffLeaveYear = false;

const isHO = @json($isHO);
const hoAccounts = @json($hoAccounts);
const businessId = @json($businessId);
const showAllTabs = @json($showAllTabs);
const csrfToken = '{{ csrf_token() }}';

$(document).ready(function () {
    // Initialize date range pickers
    initializeDateRangePickers();
    
    // Initialize Select2
    if (isHO && hoAccounts === 'Yes') {
        if ($('#holiday_business_select').length && $.fn.select2) {
            $('#holiday_business_select').select2();
        }
        if ($('#overtime_business_select').length && $.fn.select2) {
            $('#overtime_business_select').select2();
        }
        if ($('#staff_leave_business_select').length && $.fn.select2) {
            $('#staff_leave_business_select').select2();
        }
    }
    
    if ($('#staff_leave_staff_select').length && $.fn.select2) {
        $('#staff_leave_staff_select').select2();
    }
    
    // Initialize Select2 for header year selects
    $('#holiday_headerYearSelect').select2({
        width: '70px',
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#holiday_headerYearSelect').closest('.calendar-header')
    });
    
    $('#overtime_headerYearSelect').select2({
        width: '70px',
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#overtime_headerYearSelect').closest('.calendar-header')
    });
    
    $('#staff_leave_headerYearSelect').select2({
        width: '70px',
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#staff_leave_headerYearSelect').closest('.calendar-header')
    });
    
    // Wire up header year select change events to use same logic as form year selects
    $('#holiday_headerYearSelect').on('change', function() {
        if (isSyncingHolidayYear) return;
        isSyncingHolidayYear = true;
        const year = parseInt($(this).val());
        // Update hidden form year select (without triggering change to avoid loop)
        $('#holiday_selectYear').val(year);
        // Trigger the same logic as form year select
        holidayCurrentDate.setFullYear(year);
        holidayCurrentDate.setMonth(0);
        updateHolidayYearSelect();
        renderHolidayCalendar();
        loadHolidays(year);
        isSyncingHolidayYear = false;
    });
    
    $('#overtime_headerYearSelect').on('change', function() {
        if (isSyncingOvertimeYear) return;
        isSyncingOvertimeYear = true;
        const year = parseInt($(this).val());
        // Update hidden form year select (without triggering change to avoid loop)
        $('#overtime_selectYear').val(year);
        // Trigger the same logic as form year select
        overtimeCurrentDate.setFullYear(year);
        overtimeCurrentDate.setMonth(0);
        updateOvertimeYearSelect();
        renderOvertimeCalendar();
        loadOvertimeDays(year);
        isSyncingOvertimeYear = false;
    });
    
    $('#staff_leave_headerYearSelect').on('change', function() {
        if (isSyncingStaffLeaveYear) return;
        isSyncingStaffLeaveYear = true;
        const year = parseInt($(this).val());
        // Update hidden form year select (without triggering change to avoid loop)
        $('#staff_leave_selectYear').val(year);
        // Trigger the same logic as form year select
        currentSelectedYear = year;
        staffLeaveCurrentDate.setFullYear(year);
        staffLeaveCurrentDate.setMonth(0);
        updateStaffLeaveYearSelect();
        renderStaffLeaveCalendar();
        
        // Load leaves for selected year
        if (isHO && hoAccounts === 'Yes') {
            const businessId = $('#staff_leave_business_select').val();
            if (businessId) {
                loadStaffLeaves(year, businessId);
            }
        } else {
            loadStaffLeaves(year, businessId);
        }
        isSyncingStaffLeaveYear = false;
    });
    
    // Initialize tabs based on user type
    initializeHolidaysTab();
    initializeOvertimeTab();
    initializeStaffLeavesTab();
    
    // Tab change events
    $('#holidays-tab').on('shown.bs.tab', function () {
        setTimeout(() => {
            renderHolidayCalendar();
            const year = $('#holiday_selectYear').val();
            loadHolidays(year);
        }, 300);
    });

    $('#overtime-tab').on('shown.bs.tab', function () {
        setTimeout(() => {
            renderOvertimeCalendar();
            const year = $('#overtime_selectYear').val();
            loadOvertimeDays(year);
        }, 300);
    });

    $('#staffleaves-tab').on('shown.bs.tab', function () {
        setTimeout(() => {
            renderStaffLeaveCalendar();
        }, 300);
    });
});

// Initialize date range pickers
function initializeDateRangePickers() {
    const currentDate = new Date();
    
    // Initialize holiday date range picker
    holidayFlatpickr = flatpickr("#holiday_dateRange", {
        mode: "range",
        dateFormat: "Y-m-d",
        defaultDate: [currentDate],
        onChange: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 2) {
                updateHolidayDateRangeFields(selectedDates[0], selectedDates[1]);
            } else if (selectedDates.length === 1) {
                // Wait for second selection
            } else {
                $('#holiday_dateRange').val('');
                $('#holiday_start_date').val('');
                $('#holiday_end_date').val('');
            }
        },
        onClose: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 1) {
                setTimeout(() => {
                    instance.setDate([selectedDates[0], selectedDates[0]]);
                    updateHolidayDateRangeFields(selectedDates[0], selectedDates[0]);
                }, 10);
            }
        }
    });

    // Initialize overtime date range picker
    overtimeFlatpickr = flatpickr("#overtime_dateRange", {
        mode: "range",
        dateFormat: "Y-m-d",
        defaultDate: [currentDate],
        onChange: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 2) {
                updateOvertimeDateRangeFields(selectedDates[0], selectedDates[1]);
            } else if (selectedDates.length === 1) {
                // Wait for second selection
            } else {
                $('#overtime_dateRange').val('');
                $('#overtime_start_date').val('');
                $('#overtime_end_date').val('');
            }
        },
        onClose: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 1) {
                setTimeout(() => {
                    instance.setDate([selectedDates[0], selectedDates[0]]);
                    updateOvertimeDateRangeFields(selectedDates[0], selectedDates[0]);
                }, 10);
            }
        }
    });

    // Initialize staff leave date range picker
    staffLeaveFlatpickr = flatpickr("#staff_leave_dateRange", {
        mode: "range",
        dateFormat: "Y-m-d",
        defaultDate: [currentDate],
        onChange: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 2) {
                updateStaffLeaveDateRangeFields(selectedDates[0], selectedDates[1]);
                // Update leave statistics when date range changes
                updateLeaveStatistics();
            } else if (selectedDates.length === 1) {
                // Wait for second selection
            } else {
                $('#staff_leave_dateRange').val('');
                $('#staff_leave_start_date').val('');
                $('#staff_leave_end_date').val('');
            }
        },
        onClose: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 1) {
                setTimeout(() => {
                    instance.setDate([selectedDates[0], selectedDates[0]]);
                    updateStaffLeaveDateRangeFields(selectedDates[0], selectedDates[0]);
                }, 10);
            }
        }
    });

    // Set initial dates
    updateHolidayDateRangeFields(currentDate, currentDate);
    updateOvertimeDateRangeFields(currentDate, currentDate);
    updateStaffLeaveDateRangeFields(currentDate, currentDate);
}

function updateHolidayDateRangeFields(startDate, endDate) {
    const formattedStart = formatDateLocal(startDate);
    const formattedEnd = formatDateLocal(endDate);
    const displayStart = formatDateDisplay(startDate);
    const displayEnd = formatDateDisplay(endDate);
    
    $('#holiday_dateRange').val(`${displayStart} - ${displayEnd}`);
    $('#holiday_start_date').val(formattedStart);
    $('#holiday_end_date').val(formattedEnd);
    
    const year = startDate.getFullYear();
    updateHolidayYearSelect(year);
}

function updateOvertimeDateRangeFields(startDate, endDate) {
    const formattedStart = formatDateLocal(startDate);
    const formattedEnd = formatDateLocal(endDate);
    const displayStart = formatDateDisplay(startDate);
    const displayEnd = formatDateDisplay(endDate);
    
    $('#overtime_dateRange').val(`${displayStart} - ${displayEnd}`);
    $('#overtime_start_date').val(formattedStart);
    $('#overtime_end_date').val(formattedEnd);
    
    const year = startDate.getFullYear();
    updateOvertimeYearSelect(year);
}

function updateStaffLeaveDateRangeFields(startDate, endDate) {
    const formattedStart = formatDateLocal(startDate);
    const formattedEnd = formatDateLocal(endDate);
    const displayStart = formatDateDisplay(startDate);
    const displayEnd = formatDateDisplay(endDate);
    
    $('#staff_leave_dateRange').val(`${displayStart} - ${displayEnd}`);
    $('#staff_leave_start_date').val(formattedStart);
    $('#staff_leave_end_date').val(formattedEnd);
    
    const year = startDate.getFullYear();
    updateStaffLeaveYearSelect(year);
}

function formatDateLocal(date) {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
}

function formatDateDisplay(date) {
    const day = String(date.getDate()).padStart(2, '0');
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const year = date.getFullYear();
    return `${day}-${month}-${year}`;
}

// =======================
// HOLIDAYS TAB FUNCTIONS
// =======================
function initializeHolidaysTab() {
    // Initialize holiday calendar
    renderHolidayCalendar();
    loadHolidays(holidayCurrentDate.getFullYear());

    // Navigation buttons
    $('#holiday_prevMonth').on('click', () => {
        holidayCurrentDate.setMonth(holidayCurrentDate.getMonth() - 1);
        updateHolidayYearSelect();
        renderHolidayCalendar();
    });

    $('#holiday_nextMonth').on('click', () => {
        holidayCurrentDate.setMonth(holidayCurrentDate.getMonth() + 1);
        updateHolidayYearSelect();
        renderHolidayCalendar();
    });

    // Form submission
    $('#holidayForm').on('submit', function (e) {
        e.preventDefault();
        saveHoliday();
    });

    // Year change event (form year select - kept for backward compatibility)
    $('#holiday_selectYear').on('change', function() {
        if (isSyncingHolidayYear) return;
        const year = parseInt($(this).val());
        // Sync header year select (update value only, don't trigger change to avoid loop)
        if ($('#holiday_headerYearSelect').val() != year) {
            $('#holiday_headerYearSelect').val(year);
            $('#holiday_headerYearSelect').trigger('change.select2');
        }
        holidayCurrentDate.setFullYear(year);
        holidayCurrentDate.setMonth(0);
        updateHolidayYearSelect();
        renderHolidayCalendar();
        loadHolidays(year);
    });

    // Business change event (for HO users with ho_accounts)
    if (isHO && hoAccounts === 'Yes') {
        $('#holiday_business_select').on('change', function() {
            const selectedBusinessId = $(this).val();
            if (selectedBusinessId) {
                // Update the hidden business_id field
                $('#holiday_business_id').val(selectedBusinessId);
                // Reload holidays for selected business
                const year = $('#holiday_selectYear').val();
                loadHolidays(year);
            }
        });
    }
}

function updateHolidayYearSelect(year = null) {
    const yearSelect = $('#holiday_selectYear');
    const headerYearSelect = $('#holiday_headerYearSelect');
    const currentYear = year || holidayCurrentDate.getFullYear();
    
    const yearExists = yearSelect.find(`option[value="${currentYear}"]`).length > 0;
    
    if (!yearExists && currentYear) {
        yearSelect.append(`<option value="${currentYear}">${currentYear}</option>`);
        headerYearSelect.append(`<option value="${currentYear}">${currentYear}</option>`);
    }
    
    yearSelect.val(currentYear);
    // Update header select without triggering change to avoid loop
    if (headerYearSelect.val() != currentYear) {
        headerYearSelect.val(currentYear).trigger('change.select2');
    }
}

function renderHolidayCalendar() {
    const year = holidayCurrentDate.getFullYear();
    const month = holidayCurrentDate.getMonth();
    
    // Update month display (year is handled by Select2)
    $('#holiday_currentMonth').text(
        holidayCurrentDate.toLocaleDateString('en-US', { month: 'long' })
    );
    
    // Update header year select to match current date (update value only, don't trigger change to avoid loop)
    if ($('#holiday_headerYearSelect').val() != year) {
        $('#holiday_headerYearSelect').val(year);
        $('#holiday_headerYearSelect').trigger('change.select2');
    }

    const container = $('#holiday_calendarContainer');
    container.empty();

    const wrapper = $('<div>').addClass('calendar-days');
    
    ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'].forEach(d => {
        const h = $('<div>').addClass('calendar-day-header').text(d);
        wrapper.append(h);
    });

    const firstDay = new Date(year, month, 1).getDay();
    const totalDays = new Date(year, month + 1, 0).getDate();
    const currentDate = new Date();
    const isCurrentMonth = currentDate.getFullYear() === year && currentDate.getMonth() === month;

    for (let i = 0; i < firstDay; i++) {
        const emptyCell = $('<div>').addClass('calendar-day empty');
        wrapper.append(emptyCell);
    }

    for (let day = 1; day <= totalDays; day++) {
        const cell = $('<div>').addClass('calendar-day');
        
        const fullDate = `${year}-${String(month + 1).padStart(2, '0')}-${String(day).padStart(2, '0')}`;
        
        // Check if today
        if (isCurrentMonth && day === currentDate.getDate()) {
            cell.addClass('today');
        }
        
        // Check if holiday
        const holiday = allHolidays.find(h => h.date === fullDate);
        if (holiday) {
            cell.addClass('holiday');
            cell.attr('data-bs-toggle', 'tooltip');
            cell.attr('data-bs-placement', 'top');
            cell.attr('title', holiday.name);
            
            const dot = $('<div>').addClass('holiday-dot');
            cell.append(dot);
        }
        
        // Add date number
        const dateSpan = $('<div>').addClass('date').text(day);
        cell.append(dateSpan);
        if (holiday) {
            const nameSpan = $('<span>').addClass('event-name').text(holiday.name);
            cell.append(nameSpan);
        }

        cell.on('click', () => {
            if (!cell.hasClass('empty')) {
                const dateObj = new Date(fullDate);
                holidayFlatpickr.setDate([dateObj, dateObj]);
                updateHolidayDateRangeFields(dateObj, dateObj);
                
                if (holiday) {
                    $('#holiday_txtName').val(holiday.name);
                    $('#holiday_event_id').val(holiday.id);
                } else {
                    $('#holiday_txtName').val('');
                    $('#holiday_event_id').val('');
                }
            }
        });
        
        wrapper.append(cell);
    }

    container.append(wrapper);
    
    if (typeof bootstrap !== 'undefined') {
        const tooltipTriggerList = container.find('[data-bs-toggle="tooltip"]');
        const tooltipList = tooltipTriggerList.map(function() {
            return new bootstrap.Tooltip(this);
        }).get();
    }
}

function loadHolidays(year) {
    // Get business ID
    let businessId;
    if (isHO && hoAccounts === 'Yes') {
        businessId = $('#holiday_business_select').val();
    } else {
        businessId = $('#holiday_business_id').val();
    }
    
    if (!businessId) {
        allHolidays = [];
        renderHolidayCalendar();
        renderHolidayList();
        return;
    }
    
    let url = `{{ route('holiday_gazetted_events') }}?year=${year}&business_id=${businessId}`;
    
    $.ajax({
        url: url,
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            allHolidays = [];
            
            $.each(data, function(index, h) {
                const date = new Date(h.start);
                const formattedDate = formatDateLocal(date);
                
                const holidayData = {
                    id: h.id,
                    date: formattedDate,
                    name: h.title,
                    displayDate: date.toLocaleDateString('en-GB'),
                    business_id: h.business_id
                };
                
                allHolidays.push(holidayData);
            });
            
            renderHolidayCalendar();
            renderHolidayList();
        },
        error: function(xhr, status, error) {
            console.error('Error loading holidays:', error);
            toastr.error('Failed to load holidays');
        }
    });
}

function renderHolidayList() {
    const container = $('#holidayListContent');
    
    if (allHolidays.length === 0) {
        container.html('<p class="text-muted text-center">No holidays added yet</p>');
        return;
    }
    
    allHolidays.sort((a, b) => new Date(a.date) - new Date(b.date));
    
    let html = '';
    allHolidays.forEach(h => {
        const date = new Date(h.date);
        const formattedDate = date.toLocaleDateString('en-GB');
        
        html += `
            <div class="event-item">
                <div class="event-date">${formattedDate}</div>
                <div class="event-name">${h.name}</div>
                <button class="remove-event" onclick="removeHoliday(${h.id})" title="Remove Holiday">
                    <i class="ti ti-trash"></i>
                </button>
            </div>`;
    });
    
    container.html(html);
}

function saveHoliday() {
    const startDateStr = $('#holiday_start_date').val();
    const endDateStr = $('#holiday_end_date').val();
    const holidayReason = $('#holiday_txtName').val();
    const eventId = $('#holiday_event_id').val();
    const year = $('#holiday_selectYear').val();

    // Get business ID
    let businessId;
    if (isHO && hoAccounts === 'Yes') {
        businessId = $('#holiday_business_select').val();
    } else {
        businessId = $('#holiday_business_id').val();
    }

    if (!startDateStr || !endDateStr) {
        toastr.error('Please select a date range');
        return;
    }

    if (!holidayReason.trim()) {
        toastr.error('Please enter a holiday name');
        return;
    }

    if (!businessId) {
        toastr.error('Please select a business');
        return;
    }

    const start = new Date(startDateStr);
    const end = new Date(endDateStr);

    const dateArray = [];
    let currentDate = new Date(start);
    while (currentDate <= end) {
        dateArray.push(new Date(currentDate));
        currentDate.setDate(currentDate.getDate() + 1);
    }

    Swal.fire({
        title: 'Saving Holidays...',
        html: `Creating holidays for ${dateArray.length} day(s)`,
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    const formData = new FormData();
    formData.append('_token', csrfToken);
    formData.append('business_id', businessId);
    formData.append('holiday_reason', holidayReason);
    formData.append('year', year);
    
    dateArray.forEach((date, index) => {
        formData.append(`holiday_dates[${index}]`, formatDateLocal(date));
    });
    
    if (eventId) {
        formData.append('event_id', eventId);
    }
    $.ajax({
        url: `{{ route('save_gazetted_holiday') }}`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            Swal.close();
            
            if (response.success) {
                toastr.success(`Successfully saved ${response.count || dateArray.length} holiday(s)`);

                $('#holiday_txtName').val('');
                $('#holiday_event_id').val('');

                const todayDate = new Date();
                holidayFlatpickr.setDate([todayDate, todayDate]);
                updateHolidayDateRangeFields(todayDate, todayDate);
                loadHolidays(year);
            } else {
                toastr.error(response.message || 'Failed to save holidays');
                if (response.errors) {
                    response.errors.forEach(error => {
                        toastr.error(error);
                    });
                }
            }
        },
        error: function (xhr, status, error) {
            Swal.close();
            console.error('AJAX Error:', status, error);
            if (xhr.responseJSON) {
                if (Array.isArray(xhr.responseJSON.errors)) {
                    xhr.responseJSON.errors.forEach(function (msg) {
                        toastr.error(msg);
                    });
                }
                if (
                    typeof xhr.responseJSON.errors === 'object' &&
                    !Array.isArray(xhr.responseJSON.errors)
                ) {
                    Object.values(xhr.responseJSON.errors).forEach(function (errArr) {
                        errArr.forEach(function (msg) {
                            toastr.error(msg);
                        });
                    });
                }

            } else {
                toastr.error('Bad Request. Unable to save staff leaves.');
            }
        }
    });
}

function removeHoliday(id) {
    Swal.fire({
        title: 'Remove Holiday?',
        text: 'Are you sure you want to remove this holiday?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, remove it',
        cancelButtonText: 'Cancel',
        buttonsStyling: false,
        customClass: {
            confirmButton: "btn btn-danger me-2",
            cancelButton: "btn btn-secondary"
        }
    }).then(result => {
        if (!result.isConfirmed) return;

        Swal.fire({
            title: 'Removing...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: `{{ route('delete_gazetted_holiday','') }}/${id}`,
            method: 'DELETE',
            headers: { 
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            success: function(response) {
                Swal.close();
                if (response.success) {
                    toastr.success(response.message || 'Holiday removed successfully');
                    loadHolidays($('#holiday_selectYear').val());
                } else {
                    toastr.error(response.message || 'Failed to remove holiday');
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                console.error('Error:', error);
                toastr.error('Server error: Please try again');
            }
        });
    });
}

// =======================
// OVERTIME TAB FUNCTIONS
// =======================
function initializeOvertimeTab() {
    renderOvertimeCalendar();
    loadOvertimeDays(overtimeCurrentDate.getFullYear());

    $('#overtime_prevMonth').on('click', () => {
        setTimeout(() => {
            overtimeCurrentDate.setMonth(overtimeCurrentDate.getMonth() - 1);
            updateOvertimeYearSelect();
            renderOvertimeCalendar();
        }, 300);
    });

    $('#overtime_nextMonth').on('click', () => {
        setTimeout(() => {
            overtimeCurrentDate.setMonth(overtimeCurrentDate.getMonth() + 1);
            updateOvertimeYearSelect();
            renderOvertimeCalendar();
        }, 300);
    });

    $('#overtimeForm').on('submit', function (e) {
        e.preventDefault();
        saveOvertimeDay();
    });

    // Year change event (form year select - kept for backward compatibility)
    $('#overtime_selectYear').on('change', function() {
        if (isSyncingOvertimeYear) return;
        const year = parseInt($(this).val());
        // Sync header year select (update value only, don't trigger change to avoid loop)
        if ($('#overtime_headerYearSelect').val() != year) {
            $('#overtime_headerYearSelect').val(year);
            $('#overtime_headerYearSelect').trigger('change.select2');
        }
        overtimeCurrentDate.setFullYear(year);
        overtimeCurrentDate.setMonth(0);
        updateOvertimeYearSelect();
        renderOvertimeCalendar();
        loadOvertimeDays(year);
    });

    // Business change event (for HO users with ho_accounts)
    if (isHO && hoAccounts === 'Yes') {
        $('#overtime_business_select').on('change', function() {
            const selectedBusinessId = $(this).val();
            if (selectedBusinessId) {
                // Update the hidden business_id field
                $('#overtime_business_id').val(selectedBusinessId);
                // Reload overtime days for selected business
                const year = $('#overtime_selectYear').val();
                loadOvertimeDays(year);
            }
        });
    }
}

function updateOvertimeYearSelect(year = null) {
    const yearSelect = $('#overtime_selectYear');
    const headerYearSelect = $('#overtime_headerYearSelect');
    const currentYear = year || overtimeCurrentDate.getFullYear();
    
    const yearExists = yearSelect.find(`option[value="${currentYear}"]`).length > 0;
    
    if (!yearExists && currentYear) {
        yearSelect.append(`<option value="${currentYear}">${currentYear}</option>`);
        headerYearSelect.append(`<option value="${currentYear}">${currentYear}</option>`);
    }
    
    yearSelect.val(currentYear);
    // Update header select without triggering change to avoid loop
    if (headerYearSelect.val() != currentYear) {
        headerYearSelect.val(currentYear).trigger('change.select2');
    }
}

function renderOvertimeCalendar() {
    const year = overtimeCurrentDate.getFullYear();
    const month = overtimeCurrentDate.getMonth();
    
    // Update month display (year is handled by Select2)
    $('#overtime_currentMonth').text(
        overtimeCurrentDate.toLocaleDateString('en-US', { month: 'long' })
    );
    
    // Update header year select to match current date (update value only, don't trigger change to avoid loop)
    if ($('#overtime_headerYearSelect').val() != year) {
        $('#overtime_headerYearSelect').val(year);
        $('#overtime_headerYearSelect').trigger('change.select2');
    }

    const container = $('#overtime_calendarContainer');
    container.empty();

    const wrapper = $('<div>').addClass('calendar-days');

    // Add day headers
    ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'].forEach(d => {
        const h = $('<div>').addClass('calendar-day-header').text(d);
        wrapper.append(h);
    });

    const firstDay = new Date(year, month, 1).getDay();
    const totalDays = new Date(year, month + 1, 0).getDate();
    const currentDate = new Date();
    const isCurrentMonth = currentDate.getFullYear() === year && currentDate.getMonth() === month;

    for (let i = 0; i < firstDay; i++) {
        const emptyCell = $('<div>').addClass('calendar-day empty');
        wrapper.append(emptyCell);
    }

    // Add day cells
    for (let day = 1; day <= totalDays; day++) {
        const cell = $('<div>').addClass('calendar-day');
        
        const fullDate = `${year}-${String(month + 1).padStart(2, '0')}-${String(day).padStart(2, '0')}`;

        if (isCurrentMonth && day === currentDate.getDate()) {
            cell.addClass('today');
        }
        
        const overtime = allOvertimeDays.find(o => o.date === fullDate);
        if (overtime) {
            cell.addClass('overtime');
            cell.attr('data-bs-toggle', 'tooltip');
            cell.attr('data-bs-placement', 'top');
            cell.attr('title', overtime.name);
            
            const dot = $('<div>').addClass('overtime-dot');
            cell.append(dot);
        }
        
        const dateSpan = $('<div>').addClass('date').text(day);
        cell.append(dateSpan);

        if (overtime) {
            const nameSpan = $('<span>').addClass('event-name').text(overtime.name);
            cell.append(nameSpan);
        }
        
        cell.on('click', () => {
            if (!cell.hasClass('empty')) {
                const dateObj = new Date(fullDate);
                overtimeFlatpickr.setDate([dateObj, dateObj]);
                updateOvertimeDateRangeFields(dateObj, dateObj);
                
                if (overtime) {
                    $('#overtime_txtName').val(overtime.name);
                    $('#overtime_event_id').val(overtime.id);
                } else {
                    $('#overtime_txtName').val('');
                    $('#overtime_event_id').val('');
                }
            }
        });
        
        wrapper.append(cell);
    }

    container.append(wrapper);
    
    if (typeof bootstrap !== 'undefined') {
        const tooltipTriggerList = container.find('[data-bs-toggle="tooltip"]');
        const tooltipList = tooltipTriggerList.map(function() {
            return new bootstrap.Tooltip(this);
        }).get();
    }
}

function loadOvertimeDays(year) {
    // Get business ID
    let businessId;
    if (isHO && hoAccounts === 'Yes') {
        businessId = $('#overtime_business_select').val();
    } else {
        businessId = $('#overtime_business_id').val();
    }
    
    if (!businessId) {
        allOvertimeDays = [];
        renderOvertimeCalendar();
        renderOvertimeList();
        return;
    }
    
    let url = `{{ route('overtime_day_events') }}?year=${year}&business_id=${businessId}`;
    
    $.ajax({
        url: url,
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            allOvertimeDays = [];
            
            $.each(data, function(index, o) {
                const date = new Date(o.start);
                const formattedDate = formatDateLocal(date);
                
                const overtimeData = {
                    id: o.id,
                    date: formattedDate,
                    name: o.title,
                    displayDate: date.toLocaleDateString('en-GB'),
                    business_id: o.business_id
                };
                
                allOvertimeDays.push(overtimeData);
            });
            
            renderOvertimeCalendar();
            renderOvertimeList();
        },
        error: function(xhr, status, error) {
            console.error('Error loading overtime days:', error);
            toastr.error('Failed to load overtime days');
        }
    });
}

function renderOvertimeList() {
    const container = $('#overtimeListContent');
    
    if (allOvertimeDays.length === 0) {
        container.html('<p class="text-muted text-center">No overtime days added yet</p>');
        return;
    }
    
    allOvertimeDays.sort((a, b) => new Date(a.date) - new Date(b.date));
    
    let html = '';
    allOvertimeDays.forEach(o => {
        const date = new Date(o.date);
        const formattedDate = date.toLocaleDateString('en-GB');
        
        html += `
            <div class="event-item">
                <div class="event-date">${formattedDate}</div>
                <div class="event-name">${o.name}</div>
                <button class="remove-event" onclick="removeOvertimeDay(${o.id})" title="Remove Overtime Day">
                    <i class="ti ti-trash"></i>
                </button>
            </div>`;
    });
    
    container.html(html);
}

function saveOvertimeDay() {
    const startDateStr = $('#overtime_start_date').val();
    const endDateStr = $('#overtime_end_date').val();
    const overtimeReason = $('#overtime_txtName').val();
    const eventId = $('#overtime_event_id').val();
    const year = $('#overtime_selectYear').val();

    // Get business ID
    let businessId;
    if (isHO && hoAccounts === 'Yes') {
        businessId = $('#overtime_business_select').val();
    } else {
        businessId = $('#overtime_business_id').val();
    }

    if (!startDateStr || !endDateStr) {
        toastr.error('Please select a date range');
        return;
    }

    if (!overtimeReason.trim()) {
        toastr.error('Please enter an overtime reason');
        return;
    }

    if (!businessId) {
        toastr.error('Please select a business');
        return;
    }

    const start = new Date(startDateStr);
    const end = new Date(endDateStr);
    const dateArray = [];
    let currentDate = new Date(start);
    while (currentDate <= end) {
        dateArray.push(new Date(currentDate));
        currentDate.setDate(currentDate.getDate() + 1);
    }

    Swal.fire({
        title: 'Saving Overtime Days...',
        html: `Creating overtime for ${dateArray.length} day(s)`,
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    const formData = new FormData();
    formData.append('_token', csrfToken);
    formData.append('business_id', businessId);
    formData.append('overtime_reason', overtimeReason);
    formData.append('year', year);
    
    dateArray.forEach((date, index) => {
        formData.append(`overtime_dates[${index}]`, formatDateLocal(date));
    });
    
    if (eventId) {
        formData.append('event_id', eventId);
    }

    // Send single request with all dates
    $.ajax({
        url: `{{ route('save_overtime_day') }}`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            Swal.close();
            if (response.success) {
                toastr.success(`Successfully saved ${response.count || dateArray.length} overtime day(s)`);
                
                // Reset form
                $('#overtime_txtName').val('');
                $('#overtime_event_id').val('');
                
                // Reset date picker to today
                const todayDate = new Date();
                overtimeFlatpickr.setDate([todayDate, todayDate]);
                updateOvertimeDateRangeFields(todayDate, todayDate);
                
                // Reload overtime days
                loadOvertimeDays(year);
            } else {
                toastr.error(response.message || 'Failed to save overtime days');
                if (response.errors) {
                    response.errors.forEach(error => {
                        toastr.error(error);
                    });
                }
            }
        },
        error: function (xhr, status, error) {
            Swal.close();
            console.error('AJAX Error:', status, error);
            if (xhr.responseJSON) {
                if (Array.isArray(xhr.responseJSON.errors)) {
                    xhr.responseJSON.errors.forEach(function (msg) {
                        toastr.error(msg);
                    });
                }
                if (
                    typeof xhr.responseJSON.errors === 'object' &&
                    !Array.isArray(xhr.responseJSON.errors)
                ) {
                    Object.values(xhr.responseJSON.errors).forEach(function (errArr) {
                        errArr.forEach(function (msg) {
                            toastr.error(msg);
                        });
                    });
                }

            } else {
                toastr.error('Bad Request. Unable to save overtime days.');
            }
        }
    });
}

function removeOvertimeDay(id) {
    Swal.fire({
        title: 'Remove Overtime Day?',
        text: 'Are you sure you want to remove this overtime day?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, remove it',
        cancelButtonText: 'Cancel',
        buttonsStyling: false,
        customClass: {
            confirmButton: "btn btn-danger me-2",
            cancelButton: "btn btn-secondary"
        }
    }).then(result => {
        if (!result.isConfirmed) return;

        Swal.fire({
            title: 'Removing...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: `{{ route('delete_overtime_day','') }}/${id}`,
            method: 'DELETE',
            headers: { 
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            success: function(response) {
                Swal.close();
                if (response.success) {
                    toastr.success(response.message || 'Overtime day removed successfully');
                    loadOvertimeDays($('#overtime_selectYear').val());
                } else {
                    toastr.error(response.message || 'Failed to remove overtime day');
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                console.error('Error:', error);
                toastr.error('Server error: Please try again');
            }
        });
    });
}

// =======================
// STAFF LEAVES TAB FUNCTIONS
// =======================
function initializeStaffLeavesTab() {
    renderStaffLeaveCalendar();
    if (isHO && hoAccounts === 'Yes') {
        const businessSelect = $('#staff_leave_business_select');
        if (businessSelect.length) {
            businessSelect.on('change', function() {
                const selectedBusinessId = $(this).val();
                
                if (selectedBusinessId) {
                    // Clear previous selections
                    $('#staff_leave_staff_select').html('<option value="">Select Staff</option>').prop('disabled', true);
                    $('#staff_leave_type_select').html('<option value="">Select Staff First</option>').prop('disabled', true);
                    $('#leave_info_box').hide();
                    
                   
                    currentSelectedStaffId = null;
                    currentSelectedLeaveTypeId = null;
                    $('#staffLeaveListContent').html('<p class="text-muted text-center">Select a staff member to view leaves</p>');
                    
                    allStaffLeaves = [];
                    renderStaffLeaveCalendar();
                    loadStaffForBusiness(selectedBusinessId);
                    const year = $('#staff_leave_selectYear').val();
                    loadStaffLeaves(year, selectedBusinessId);
                } else {
                    $('#staff_leave_staff_select').html('<option value="">Select Business First</option>').prop('disabled', true);
                    $('#staff_leave_type_select').html('<option value="">Select Staff First</option>').prop('disabled', true);
                    $('#leave_info_box').hide();
                    
                    $('#staffLeaveListContent').html('<p class="text-muted text-center">Select a business to view staff leaves</p>');
                    
                    allStaffLeaves = [];
                    renderStaffLeaveCalendar();
                }
            });
            
            const initialBusinessId = businessSelect.val();
            if (initialBusinessId) {
                loadStaffForBusiness(initialBusinessId);
                const initialYear = new Date().getFullYear();
                loadStaffLeaves(initialYear, initialBusinessId);
            }
        }
    } else {
        const currentBusinessId = businessId;
        if (currentBusinessId) {
            loadStaffForBusiness(currentBusinessId);
            loadStaffLeaves(new Date().getFullYear(), currentBusinessId);
        }
    }
    
    const initialYear = new Date().getFullYear();
    if (isHO && hoAccounts === 'Yes') {
        const initialBusinessId = $('#staff_leave_business_select').val();
        if (initialBusinessId) {
            allStaffLeaves = [];
            renderStaffLeaveCalendar();
            $('#staffLeaveListContent').html('<p class="text-muted text-center">Select a staff member to view leaves</p>');
        }
    } else {
        const currentBusinessId = businessId;
        if (currentBusinessId) {
            allStaffLeaves = [];
            renderStaffLeaveCalendar();
            $('#staffLeaveListContent').html('<p class="text-muted text-center">Select a staff member to view leaves</p>');
        }
    }
    
    $('#staff_leave_prevMonth').on('click', () => {
        staffLeaveCurrentDate.setMonth(staffLeaveCurrentDate.getMonth() - 1);
        updateStaffLeaveYearSelect();
        renderStaffLeaveCalendar();
    });

    $('#staff_leave_nextMonth').on('click', () => {
        staffLeaveCurrentDate.setMonth(staffLeaveCurrentDate.getMonth() + 1);
        updateStaffLeaveYearSelect();
        renderStaffLeaveCalendar();
    });

    // Form submission
    $('#staffLeaveForm').on('submit', function (e) {
        e.preventDefault();
        saveStaffLeave();
    });

    // Year change event (form year select - kept for backward compatibility)
    $('#staff_leave_selectYear').on('change', function() {
        if (isSyncingStaffLeaveYear) return;
        const year = parseInt($(this).val());
        // Sync header year select (update value only, don't trigger change to avoid loop)
        if ($('#staff_leave_headerYearSelect').val() != year) {
            $('#staff_leave_headerYearSelect').val(year);
            $('#staff_leave_headerYearSelect').trigger('change.select2');
        }
        currentSelectedYear = year;
        staffLeaveCurrentDate.setFullYear(year);
        staffLeaveCurrentDate.setMonth(0);
        updateStaffLeaveYearSelect();
        renderStaffLeaveCalendar();
        
        // Load leaves for selected year
        if (isHO && hoAccounts === 'Yes') {
            const businessId = $('#staff_leave_business_select').val();
            if (businessId) {
                loadStaffLeaves(year, businessId);
            } else {
                loadStaffLeaves(year);
            }
        } else {
            const currentBusinessId = businessId;
            if (currentBusinessId) {
                loadStaffLeaves(year, currentBusinessId);
            }
        }
        
        // Update statistics if staff and leave type are selected
        if (currentSelectedStaffId && currentSelectedLeaveTypeId) {
            updateLeaveStatistics();
        }
    });

    // Staff change event
    $('#staff_leave_staff_select').on('change', function() {
        const staffId = $(this).val();
        if (staffId) {
            currentSelectedStaffId = staffId;
            loadLeaveTypesForStaff(staffId);
            loadStaffLeavesForStaff(staffId);
            toastr.info(`Showing leaves for selected staff only`);
        } else {
            currentSelectedStaffId = null;
            currentSelectedLeaveTypeId = null;
            $('#staff_leave_type_select').html('<option value="">Select Staff First</option>').prop('disabled', true);
            $('#leave_info_box').hide();

            allStaffLeaves = [];
            renderStaffLeaveCalendar();
            $('#staffLeaveListContent').html('<p class="text-muted text-center">Please select a staff member to view leaves</p>');
            
            toastr.info('No staff selected. Please select a staff to view their leaves.');
        }
    });

    function filterStaffLeaveCalendar(staffId) {
        // If no staff ID provided, show all events
        if (!staffId) {
            renderStaffLeaveCalendar();
            return;
        }
        
        // Get current year from calendar
        const year = staffLeaveCurrentDate.getFullYear();
        
        // Load leaves for specific staff
        loadStaffLeavesForStaff(year, staffId);
    }

    function loadStaffLeavesForStaff(staffId) {
        const year = staffLeaveCurrentDate.getFullYear();
        let url = `{{ route('staff_leave_events') }}?year=${year}&staff_id=${staffId}`;
        
        // Add business filter
        if (isHO && hoAccounts === 'Yes') {
            const businessId = $('#staff_leave_business_select').val();
            if (businessId) {
                url += `&business_id=${businessId}`;
            }
        } else {
            const currentBusinessId = @json($businessId);
            if (currentBusinessId) {
                url += `&business_id=${currentBusinessId}`;
            }
        }
        
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'json',
            success: function(data) {
                allStaffLeaves = [];
                
                if (Array.isArray(data)) {
                    $.each(data, function(index, l) {
                        const date = new Date(l.start);
                        const formattedDate = formatDateLocal(date);
                        
                        const leaveData = {
                            id: l.id,
                            date: formattedDate,
                            staff_id: l.staff_id,
                            staff_name: l.staff_name,
                            leave_type: l.leave_type,
                            leave_type_id: l.leave_type_id,
                            reason: l.reason,
                            displayDate: date.toLocaleDateString('en-GB'),
                            business_id: l.business_id
                        };
                        
                        allStaffLeaves.push(leaveData);
                    });
                }
                
                renderStaffLeaveCalendar();
                updateStaffLeaveListForStaff(staffId);
            },
            error: function(xhr, status, error) {
                console.error('Error loading staff leaves:', error);
                toastr.error('Failed to load staff leaves: ' + error.message);
            }
        });
    }
    // Leave type change event
    $('#staff_leave_type_select').on('change', function() {
        const leaveTypeId = $(this).val();
        if (leaveTypeId) {
            currentSelectedLeaveTypeId = leaveTypeId;
            updateLeaveStatistics();
        } else {
            currentSelectedLeaveTypeId = null;
            $('#leave_info_box').hide();
        }
    });


    function updateStaffLeaveListForStaff(staffId) {
        // Filter leaves for specific staff
        const staffLeaves = allStaffLeaves.filter(l => l.staff_id == staffId);
        renderStaffLeaveListForStaff(staffLeaves);
    }

    function renderStaffLeaveListForStaff(staffLeaves) {
        const container = $('#staffLeaveListContent');
        
        if (staffLeaves.length === 0) {
            container.html('<p class="text-muted text-center">No leaves found for selected staff</p>');
            return;
        }
        
        // Get staff name
        const staffName = staffLeaves[0]?.staff_name || 'Staff';
        
        let html = `<div class="mb-3"><h6 class="mb-2">${staffName}</h6>`;
        
        staffLeaves.sort((a, b) => new Date(a.date) - new Date(b.date));
        
        staffLeaves.forEach(l => {
            const date = new Date(l.date);
            const formattedDate = date.toLocaleDateString('en-GB');
            
            html += `
                <div class="event-item">
                    <div class="event-date">${formattedDate}</div>
                    <div class="event-name">
                        <strong>${l.leave_type}</strong><br>
                        <small>${l.reason}</small>
                    </div>
                    <button class="remove-event" onclick="removeStaffLeave(${l.id})" title="Remove Leave">
                        <i class="ti ti-trash"></i>
                    </button>
                </div>`;
        });
        
        html += '</div>';
        container.html(html);
    }
}

function loadStaffForBusiness(businessId) {
    const staffSelect = $('#staff_leave_staff_select');
    staffSelect.html('<option value="">Loading staff...</option>').prop('disabled', true);
    
    $.ajax({
        url: "{{ route('hrm.get_staff_by_business') }}",
        type: 'GET',
        data: {
            business_id: businessId
        },
        dataType: 'json',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.success && data.staff) {
                staffSelect.html('<option value="">Select Staff</option>');
                
                if (data.staff.length > 0) {
                    $.each(data.staff, function(index, staff) {
                        staffSelect.append(`<option value="${staff.id_staff}">${staff.staff_fullname}</option>`);
                    });
                    staffSelect.prop('disabled', false);
                    const year = $('#staff_leave_selectYear').val();
                    loadStaffLeaves(year, businessId);
                } else {
                    staffSelect.html('<option value="">No staff found</option>');
                    toastr.info('No active staff found for this business');
                }
            } else {
                staffSelect.html('<option value="">Error loading staff</option>');
                toastr.error(data.message || 'Failed to load staff list');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading staff:', error);
            staffSelect.html('<option value="">Error loading staff</option>');
            toastr.error('Failed to load staff list: ' + error.message);
        }
    });
}

function loadLeaveTypesForStaff(staffId) {
    const leaveTypeSelect = $('#staff_leave_type_select');

    leaveTypeSelect
        .html('<option value="">Loading leave types...</option>')
        .prop('disabled', true);

    $.ajax({
        url: `{{ route("hrm.get_staff_leave_types") }}`,
        method: 'GET',
        data: { staff_id: staffId },
        dataType: 'json',

        success: function (data) {

            if (data.success) {
                leaveTypeSelect.html('<option value="">Select Leave Type</option>');

                $.each(data.leaveTypes, function (index, leaveType) {
                    leaveTypeSelect.append(
                        `<option value="${leaveType.id_leave_type}">
                            ${leaveType.leave_type}
                        </option>`
                    );
                });

                leaveTypeSelect.prop('disabled', false);

                if (data.policy_name) {
                    toastr.info(`Using policy: ${data.policy_name}`);
                }

            } else {
                leaveTypeSelect
                    .html('<option value="">No leave types available</option>')
                    .prop('disabled', true);

                if (data.has_policy === false) {
                    toastr.error(data.message || 'Please assign leave policy to this staff.');
                } 
                else if (data.has_policy === true) {
                    toastr.warning(data.message || 'No leave types configured in policy.');
                } 
                else {
                    toastr.error(data.message || 'Unable to load leave types.');
                }
            }
        },

        error: function (xhr) {
            leaveTypeSelect
                .html('<option value="">No leave types available</option>')
                .prop('disabled', true);

            const response = xhr.responseJSON;

            if (response && response.has_policy === false) {
                toastr.error(response.message);
            } 
            else if (response && response.has_policy === true) {
                toastr.warning(response.message);
            } 
            else {
                toastr.error(response?.message || 'Failed to load leave types.');
            }
        }
    });
}

async function updateLeaveStatistics() {
    if (!currentSelectedStaffId || !currentSelectedLeaveTypeId) {
        $('#leave_info_box').hide();
        return;
    }
    
    const startDateStr = $('#staff_leave_start_date').val();
    const endDateStr = $('#staff_leave_end_date').val();
    const year = $('#staff_leave_selectYear').val();
    
    if (!startDateStr || !endDateStr) {
        $('#leave_info_box').hide();
        return;
    }
    
    try {
        const response = await $.ajax({
            url: `{{ route("hrm.get_staff_leave_balance") }}`,
            method: 'POST',
            data: JSON.stringify({
                staff_id: currentSelectedStaffId,
                leave_type_id: currentSelectedLeaveTypeId,
                required_from: startDateStr,
                required_to: endDateStr,
                year: year
            }),
            contentType: 'application/json',
            headers: {
                'X-CSRF-TOKEN': csrfToken
            }
        });
        
        if (response.success) {
            $('#leave_info_box').show();
            $('#allowed_leaves').text(response.data.allowed_count);
            $('#consumed_leaves').text(response.data.consumed_leaves);
            $('#remaining_leaves').text(response.data.remaining_leaves);
            
            // Check if there are already consumed leaves for this type/year
            if (response.data.consumed_leaves > 0) {
                toastr.info(`This staff has already used ${response.data.consumed_leaves} ${response.data.leave_type} leaves in ${response.data.requested_year}`);
            }
            
            // Check for overlapping leaves
            if (response.data.overlapping_leaves > 0) {
                toastr.warning(`Warning: ${response.data.overlapping_leaves} overlapping leave(s) found in the selected date range`);
            }
            
            // Check if requested days exceed remaining leaves
            const startDate = new Date(startDateStr);
            const endDate = new Date(endDateStr);
            const requestedDays = Math.ceil((endDate - startDate) / (1000 * 60 * 60 * 24)) + 1;
            
            if (requestedDays > response.data.remaining_leaves) {
                toastr.error(`Error: Requested ${requestedDays} days but only ${response.data.remaining_leaves} leaves remaining`);
            }
        } else {
            $('#leave_info_box').hide();
            
            // Show specific message based on whether staff has policy or not
            if (response.has_policy === false) {
                toastr.error(response.message || 'Staff has no leave policy assigned');
            } else {
                toastr.error(response.message || 'Failed to load leave balance');
            }
        }
    } catch (error) {
        console.error('Error updating leave statistics:', error);
        $('#leave_info_box').hide();
        toastr.error('Error loading leave statistics');
    }
}

function updateStaffLeaveYearSelect(year = null) {
    const yearSelect = $('#staff_leave_selectYear');
    const headerYearSelect = $('#staff_leave_headerYearSelect');
    const currentYear = year || staffLeaveCurrentDate.getFullYear();
    
    const yearExists = yearSelect.find(`option[value="${currentYear}"]`).length > 0;
    
    if (!yearExists && currentYear) {
        yearSelect.append(`<option value="${currentYear}">${currentYear}</option>`);
        headerYearSelect.append(`<option value="${currentYear}">${currentYear}</option>`);
    }
    
    yearSelect.val(currentYear);
    headerYearSelect.val(currentYear).trigger('change.select2');
    currentSelectedYear = currentYear;
}

function renderStaffLeaveCalendar() {
    const year = staffLeaveCurrentDate.getFullYear();
    const month = staffLeaveCurrentDate.getMonth();
    
    // Update month display (year is handled by Select2)
    $('#staff_leave_currentMonth').text(
        staffLeaveCurrentDate.toLocaleDateString('en-US', { month: 'long' })
    );
    
    // Update header year select to match current date (update value only, don't trigger change to avoid loop)
    if ($('#staff_leave_headerYearSelect').val() != year) {
        $('#staff_leave_headerYearSelect').val(year);
        $('#staff_leave_headerYearSelect').trigger('change.select2');
    }

    const container = $('#staff_leave_calendarContainer');
    container.empty();

    const wrapper = $('<div>').addClass('calendar-days');
    
    ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'].forEach(d => {
        const h = $('<div>').addClass('calendar-day-header').text(d);
        wrapper.append(h);
    });

    const firstDay = new Date(year, month, 1).getDay();
    const totalDays = new Date(year, month + 1, 0).getDate();
    const currentDate = new Date();
    const isCurrentMonth = currentDate.getFullYear() === year && currentDate.getMonth() === month;

    for (let i = 0; i < firstDay; i++) {
        const emptyCell = $('<div>').addClass('calendar-day empty');
        wrapper.append(emptyCell);
    }

    for (let day = 1; day <= totalDays; day++) {
        const cell = $('<div>').addClass('calendar-day');
        
        const fullDate = `${year}-${String(month + 1).padStart(2, '0')}-${String(day).padStart(2, '0')}`;
        
        // Check if today
        if (isCurrentMonth && day === currentDate.getDate()) {
            cell.addClass('today');
        }
        
        // Check if staff leave - ONLY for selected staff or show none if no staff selected
        let staffLeave = null;
        if (currentSelectedStaffId) {
            // Only show leaves for the selected staff
            staffLeave = allStaffLeaves.find(l => l.date === fullDate && l.staff_id == currentSelectedStaffId);
        }
        // If no staff is selected, don't show any leaves
        
        if (staffLeave) {
            cell.addClass('leave');
            
            cell.attr('data-bs-toggle', 'tooltip');
            cell.attr('data-bs-placement', 'top');
            cell.attr('title', `${staffLeave.staff_name}: ${staffLeave.leave_type} - ${staffLeave.reason}`);
            
            const dot = $('<div>').addClass('leave-dot');
            cell.append(dot);
        }
        
        // Add date number
        const dateSpan = $('<div>').addClass('date').text(day);
        cell.append(dateSpan);
        
        if (staffLeave) {
            const nameSpan = $('<span>').addClass('event-name').text(`${staffLeave.staff_name}: ${staffLeave.leave_type}`);
            cell.append(nameSpan);
        }

        cell.on('click', () => {
            if (!cell.hasClass('empty')) {
                const dateObj = new Date(fullDate);
                staffLeaveFlatpickr.setDate([dateObj, dateObj]);
                updateStaffLeaveDateRangeFields(dateObj, dateObj);
                
                if (staffLeave) {
                    $('#staff_leave_reason').val(staffLeave.reason);
                    $('#staff_leave_event_id').val(staffLeave.id);
                    
                    // Try to select the staff and leave type
                    if (currentSelectedStaffId !== staffLeave.staff_id) {
                        $('#staff_leave_staff_select').val(staffLeave.staff_id);
                        loadLeaveTypesForStaff(staffLeave.staff_id).then(() => {
                            setTimeout(() => {
                                $('#staff_leave_type_select').val(staffLeave.leave_type_id);
                                currentSelectedLeaveTypeId = staffLeave.leave_type_id;
                                updateLeaveStatistics();
                            }, 500);
                        });
                    } else {
                        $('#staff_leave_type_select').val(staffLeave.leave_type_id);
                        currentSelectedLeaveTypeId = staffLeave.leave_type_id;
                        updateLeaveStatistics();
                    }
                } else {
                    $('#staff_leave_reason').val('');
                    $('#staff_leave_event_id').val('');
                }
            }
        });
        
        wrapper.append(cell);
    }

    container.append(wrapper);
    
    if (typeof bootstrap !== 'undefined') {
        const tooltipTriggerList = container.find('[data-bs-toggle="tooltip"]');
        const tooltipList = tooltipTriggerList.map(function() {
            return new bootstrap.Tooltip(this);
        }).get();
    }
}

function loadStaffLeaves(year, businessId = null) {
    let url = `{{ route('staff_leave_events') }}?year=${year}`;
    
    // Add business filter if provided
    if (businessId) {
        url += `&business_id=${businessId}`;
    } else if (!isHO || hoAccounts === 'No') {
        // For non-HO users or HO without accounts access, always filter by their business
        const currentBusinessId = @json($businessId);
        if (currentBusinessId) {
            url += `&business_id=${currentBusinessId}`;
        }
    }
    
    $.ajax({
        url: url,
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            allStaffLeaves = [];
            
            if (Array.isArray(data)) {
                $.each(data, function(index, l) {
                    const date = new Date(l.start);
                    const formattedDate = formatDateLocal(date);
                    
                    const leaveData = {
                        id: l.id,
                        date: formattedDate,
                        staff_id: l.staff_id,
                        staff_name: l.staff_name,
                        leave_type: l.leave_type,
                        leave_type_id: l.leave_type_id,
                        reason: l.reason,
                        displayDate: date.toLocaleDateString('en-GB'),
                        business_id: l.business_id
                    };
                    
                    allStaffLeaves.push(leaveData);
                });
            }
            
            renderStaffLeaveCalendar();
            renderStaffLeaveList();
        },
        error: function(xhr, status, error) {
            console.error('Error loading staff leaves:', error);
            toastr.error('Failed to load staff leaves: ' + error.message);
        }
    });
}

function renderStaffLeaveList() {
    const container = $('#staffLeaveListContent');
    
    // Always show filtered view when staff is selected
    if (currentSelectedStaffId) {
        const staffLeaves = allStaffLeaves.filter(l => l.staff_id == currentSelectedStaffId);
        renderStaffLeaveListForStaff(staffLeaves);
        return;
    }
    
    container.html('<p class="text-muted text-center">Select a staff member to view their leaves</p>');
}

function saveStaffLeave() {
    const startDateStr = $('#staff_leave_start_date').val();
    const endDateStr = $('#staff_leave_end_date').val();
    const leaveReason = $('#staff_leave_reason').val();
    const staffId = $('#staff_leave_staff_select').val();
    const leaveTypeId = $('#staff_leave_type_select').val();
    const eventId = $('#staff_leave_event_id').val();
    const year = $('#staff_leave_selectYear').val();
    
    // Get business ID
    let businessId;
    if (isHO && hoAccounts === 'Yes') {
        businessId = $('#staff_leave_business_select').val();
    } else {
        businessId = $('#staff_leave_business_id').val();
    }

    if (!startDateStr || !endDateStr) {
        toastr.error('Please select a date range');
        return;
    }

    if (!staffId) {
        toastr.error('Please select a staff member');
        return;
    }

    if (!leaveTypeId) {
        toastr.error('Please select a leave type');
        return;
    }

    if (!leaveReason.trim()) {
        toastr.error('Please enter a leave reason');
        return;
    }

    const start = new Date(startDateStr);
    const end = new Date(endDateStr);
    const dateArray = [];
    let currentDate = new Date(start);
    while (currentDate <= end) {
        dateArray.push(formatDateLocal(currentDate));
        currentDate.setDate(currentDate.getDate() + 1);
    }

    Swal.fire({
        title: 'Saving Staff Leaves...',
        html: `Marking leaves for ${dateArray.length} day(s)`,
        allowOutsideClick: false,
        didOpen: () => Swal.showLoading()
    });

    const formData = new FormData();
    formData.append('_token', csrfToken);
    formData.append('business_id', businessId);
    formData.append('staff_id', staffId);
    formData.append('leave_type_id', leaveTypeId);
    formData.append('leave_reason', leaveReason);
    formData.append('year', year);
    
    dateArray.forEach((date, index) => {
        formData.append(`leave_dates[${index}]`, date);
    });
    
    if (eventId) {
        formData.append('event_id', eventId);
    }
    $.ajax({
        url: `{{ route('save_staff_leave') }}`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            Swal.close();
            
            if (response.success) {
                toastr.success(`Successfully saved ${response.count || dateArray.length} leave(s)`);
                
                // Reset form
                $('#staff_leave_reason').val('');
                $('#staff_leave_event_id').val('');

                const todayDate = new Date();
                staffLeaveFlatpickr.setDate([todayDate, todayDate]);
                updateStaffLeaveDateRangeFields(todayDate, todayDate);
                
                const year = $('#staff_leave_selectYear').val();
                if (isHO && hoAccounts === 'Yes') {
                    const businessId = $('#staff_leave_business_select').val();
                    if (businessId) {
                        loadStaffLeaves(year, businessId);
                    } else {
                        loadStaffLeaves(year);
                    }
                } else {
                    const currentBusinessId = @json($businessId);
                    if (currentBusinessId) {
                        loadStaffLeaves(year, currentBusinessId);
                    }
                }
                $('#leave_info_box').hide();
            } else {
                toastr.error(response.message || 'Failed to save staff leaves');
                if (response.errors) {
                    response.errors.forEach(error => {
                        toastr.error(error);
                    });
                }
            }
        },
        error: function (xhr, status, error) {
            Swal.close();
            console.error('AJAX Error:', status, error);
            if (xhr.responseJSON) {
                if (Array.isArray(xhr.responseJSON.errors)) {
                    xhr.responseJSON.errors.forEach(function (msg) {
                        toastr.error(msg);
                    });
                }
                if (
                    typeof xhr.responseJSON.errors === 'object' &&
                    !Array.isArray(xhr.responseJSON.errors)
                ) {
                    Object.values(xhr.responseJSON.errors).forEach(function (errArr) {
                        errArr.forEach(function (msg) {
                            toastr.error(msg);
                        });
                    });
                }

            } else {
                toastr.error('Bad Request. Unable to save staff leaves.');
            }
        }

    });
}

function removeStaffLeave(id) {
    Swal.fire({
        title: 'Remove Staff Leave?',
        text: 'Are you sure you want to remove this leave?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, remove it',
        cancelButtonText: 'Cancel',
        buttonsStyling: false,
        customClass: {
            confirmButton: "btn btn-danger me-2",
            cancelButton: "btn btn-secondary"
        }
    }).then(result => {
        if (!result.isConfirmed) return;

        Swal.fire({
            title: 'Removing...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: `{{ route('delete_staff_leave','') }}/${id}`,
            method: 'DELETE',
            headers: { 
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            success: function(response) {
                Swal.close();
                if (response.success) {
                    toastr.success(response.message || 'Staff leave removed successfully');
                    const year = $('#staff_leave_selectYear').val();
                    if (isHO && hoAccounts === 'Yes') {
                        const businessId = $('#staff_leave_business_select').val();
                        if (businessId) {
                            loadStaffLeaves(year, businessId);
                        } else {
                            loadStaffLeaves(year);
                        }
                    } else {
                        const currentBusinessId = @json($businessId);
                        if (currentBusinessId) {
                            loadStaffLeaves(year, currentBusinessId);
                        }
                    }
                } else {
                    toastr.error(response.message || 'Failed to remove staff leave');
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                console.error('Error:', error);
                toastr.error('Server error: Please try again');
            }
        });
    });
}
</script>
@endsection