@extends('layouts.horizontal', ['title' => 'Payment Slips', 'topbarTitle' => 'Payment Slips'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/select2/dist/css/select2.min.css'])
<style>
    .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
        padding: 8px;
        line-height: 1.42857143;
        vertical-align: middle;
        color: #000;
        border-color: #ebeef2; 
    }
    .card-box {
        background: white;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        margin-bottom: 20px;
    }
    .table {
        border: 1px solid #ebeef2; 
        margin-bottom: 0;
    }

    .table tbody tr {
        border-bottom: 1px solid #ebeef2; 
    }
    
    .table tbody tr:last-child {
        border-bottom: none;
    }
    
    /* Dark separator borders */
    .table thead th {
        border-bottom: 2px solid #ebeef2 !important;
        background-color: #f8f9fa;
        font-weight: 600;
    }
    
    .table tfoot th,
    .table tfoot td {
        border-top: 2px solid #ebeef2 !important; 
        font-weight: 600;
        background-color: #f8f9fa;
    }
    
    /* Status colors */
    .status-paid {
        color: #28a745;
        font-weight: bold;
    }
    
    .status-unpaid {
        color: #dc3545;
        font-weight: bold;
    }
    
    /* Signature area styling */
    .signature-area {
        margin-top: 30px;
        padding-top: 20px;
        page-break-inside: avoid;
    }

    .signature-box {
        text-align: center;
        page-break-inside: avoid;
    }

    .signature-line {
        width: 200px;
        margin: 0 auto;
        border-top: 1px solid #000;
        height: 1px;
        margin-bottom: 5px;
    }

    .signature-text {
        font-size: 11px;
        color: #333;
        margin-top: 5px;
    }
    
    /* Payment status styling */
    .payment-status {
        padding: 3px 8px;
        border-radius: 3px;
        font-weight: bold;
    }
    
    .payment-paid {
        background-color: #d4edda;
        color: #155724;
    }
    
    .payment-unpaid {
        background-color: #f8d7da;
        color: #721c24;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Payment Slips</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    <div class="btn-group">
                        <button type="button" class="btn btn-outline-warning dropdown-toggle waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="true">
                            Staff Payments<span class="m-l-5"><i class="fa fa-money"></i></span>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                            <li><a href="{{ route('staff.staff_list') }}" class="dropdown-item">Staff</a></li>
                            <li><a href="{{ route('hrm.staff_payables_receivables', ['businessid' => session('selected_business_id') ?? session('business_id')]) }}" class="dropdown-item">Make Payments To Staff</a></li>
                            <li><a href="{{ route('hrm.staff_paymentslips') }}" class="dropdown-item">Payment Slips</a></li>
                        </ul>
                    </div>
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Business Selector -->
    @if(session('ho') === 'Yes')
    <div class="row mb-3 hidden-print">
        <div class="col-12">
            <div class="card-box">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <label class="form-label">Select Business</label>
                        <select class="form-control select2" id="businessSelector">
                            @if(session('ho_accounts') === 'Yes')
                                @foreach($businesses->where('ho_accounts', 'Yes') as $businessItem)
                                    <option value="{{ $businessItem->id_business }}" 
                                        {{ ($business->id_business ?? '') == $businessItem->id_business ? 'selected' : '' }}>
                                        {{ $businessItem->business_name }}
                                    </option>
                                @endforeach
                            @else
                                @foreach($businesses as $businessItem)
                                    <option value="{{ $businessItem->id_business }}" 
                                        {{ ($business->id_business ?? '') == $businessItem->id_business ? 'selected' : '' }}>
                                        {{ $businessItem->business_name }}
                                    </option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Generate Slip Form -->
    <div class="row hidden-print" id="divselection">
        <div class="col-sm-12">
            <div class="card-box">
                <h4>Generate Payment Slip</h4>
                <form id="generateSlipForm" method="post" action="{{ route('hrm.staff_paymentslips') }}">
                    @csrf
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Staff</label>
                            <select id="selected_staff" name="staff_id" class="form-control select2" required>
                                <option value="">Select Staff</option>
                                @foreach($allStaff as $item)
                                    <option value="{{ $item->id_staff }}" {{ (old('staff_id', $selectedStaff ?? '') == $item->id_staff) ? 'selected' : '' }}>
                                        {{ $item->staff_fullname }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Month</label>
                            <select class="form-control" onchange="updateMonthName()" id="selected_month" name="selected_month" required>
                                @php
                                    $month = $lastMonthYear['Month'] ?? date('n');
                                    $monthName = $lastMonthYear['MonthName'] ?? date('F');
                                @endphp
                                <option value="1" data-monthname="January" {{ ($month == 1) ? 'selected' : '' }}>January</option>
                                <option value="2" data-monthname="February" {{ ($month == 2) ? 'selected' : '' }}>February</option>
                                <option value="3" data-monthname="March" {{ ($month == 3) ? 'selected' : '' }}>March</option>
                                <option value="4" data-monthname="April" {{ ($month == 4) ? 'selected' : '' }}>April</option>
                                <option value="5" data-monthname="May" {{ ($month == 5) ? 'selected' : '' }}>May</option>
                                <option value="6" data-monthname="June" {{ ($month == 6) ? 'selected' : '' }}>June</option>
                                <option value="7" data-monthname="July" {{ ($month == 7) ? 'selected' : '' }}>July</option>
                                <option value="8" data-monthname="August" {{ ($month == 8) ? 'selected' : '' }}>August</option>
                                <option value="9" data-monthname="September" {{ ($month == 9) ? 'selected' : '' }}>September</option>
                                <option value="10" data-monthname="October" {{ ($month == 10) ? 'selected' : '' }}>October</option>
                                <option value="11" data-monthname="November" {{ ($month == 11) ? 'selected' : '' }}>November</option>
                                <option value="12" data-monthname="December" {{ ($month == 12) ? 'selected' : '' }}>December</option>
                            </select>
                            <input type="hidden" name="month" id="month" value="{{ $monthName }}">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Year</label>
                            <select name="selected_year" class="form-control" required>
                                @php
                                    $currentYear = date('Y');
                                    $selectedYear = $lastMonthYear['Year'] ?? $currentYear;
                                @endphp
                                @for($y = $currentYear; $y >= ($currentYear - 3); $y--)
                                    <option value="{{ $y }}" {{ $selectedYear == $y ? 'selected' : '' }}>
                                        {{ $y }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                    </div>
                    <div class="row text-right m-t-5">
                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-outline-primary">
                            Generate Slip
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Payment Slips Display -->
    @if(isset($vouchers) && !empty($vouchers))
        <div class="container-fluid">
            @php
                // Combine all vouchers into one slip
                $combinedData = [];
                $staffInfo = null;
                $earningsTotal = 0;
                $deductionsTotal = 0;
                $netPayable = 0;
                $paidAmount = 0;
                $paymentDate = null;
                $paymentVoucherId = null;
                $paymentMode = null;
                
                // Process all vouchers
                foreach($vouchers as $voucherId => $voucherGroup) {
                    foreach($voucherGroup as $key => $row) {
                        if($key === 'payments') continue; // Skip payments array
                        
                        if(is_array($row)) {
                            // Store staff info from first record
                            if($staffInfo === null) {
                                $staffInfo = $row;
                            }
                            
                            // Calculate earnings (debit amounts for expense accounts)
                            if(($row['debit_amount'] ?? 0) > 0 && 
                               ($row['entity_name'] ?? '') !== 'salary_payable' && 
                               ($row['entity_name'] ?? '') !== 'provident_fund_payable') {
                                $earningsTotal += $row['debit_amount'];
                            }
                            
                            // Calculate deductions (credit amounts for expense accounts)
                            if(($row['credit_amount'] ?? 0) > 0 && 
                               ($row['entity_name'] ?? '') !== 'salary_payable' && 
                               ($row['entity_name'] ?? '') !== 'provident_fund_payable') {
                                $deductionsTotal += $row['credit_amount'];
                            }
                            
                            // Check for salary payable entry
                            if(($row['entity_name'] ?? '') === 'salary_payable') {
                                if(($row['credit_amount'] ?? 0) > 0) {
                                    // This is the payable amount (accrual)
                                    $netPayable = $row['credit_amount'];
                                } elseif(($row['debit_amount'] ?? 0) > 0) {
                                    // This is a payment (debit to payable)
                                    $paidAmount = $row['debit_amount'];
                                    $paymentDate = $row['payment_date'] ?? null;
                                    $paymentVoucherId = $row['id_account_vouchers'] ?? null;
                                    $paymentMode = $row['payment_mode'] ?? null;
                                }
                            }
                            
                            // Add to combined data
                            $combinedData[] = $row;
                        }
                    }
                }
                
                // Determine payment status
                $paymentStatus = $paidAmount > 0 ? 'paid' : 'unpaid';
                $remainingPayable = max(0, $netPayable - $paidAmount);
            @endphp
            
            @if($staffInfo)
                <div class="panel panel-default no-print-break" style="margin-bottom: 40px;">
                    <div class="panel-body" style="background: white; padding: 20px; border-radius: 5px;">
                        <div id="print_area_0">
                            <div class="payment-header">
                                <div class="logo-container">
                                    @if(isset($business) && $business->business_logo)
                                        <img src="{{ asset('images/business/' . $business->business_logo) }}" 
                                             alt="{{ $business->business_name }}" class="img-responsive" />
                                    @else
                                        <h3 style="color: #333; margin: 0;">SalonPK</h3>
                                    @endif
                                </div>
                                
                                <div class="company-info">
                                    <h4>{{ $business->business_name ?? 'Company Name' }}</h4>
                                    <p>{!! $business->business_address ?? 'Company Address' !!}</p>
                                    <p>Phone: {{ $business->business_phone1 ?? 'N/A' }} | Email: {{ $business->business_email ?? 'N/A' }}</p>
                                </div>
                                
                                <div class="print-space"></div>
                                
                                <!-- Print Date and Payment Info -->
                                <div class="row" style="margin-top: 20px;">
                                    <div class="col-md-6">
                                        <p style="margin: 5px 0;"><strong>Print Date:</strong> {{ date('d-m-Y') }}</p>
                                        <p style="margin: 5px 0;"><strong>Payment Type:</strong> Staff Salary Payment Slip</p>
                                    </div>
                                    <div class="col-md-6 text-right">
                                        @if($paymentStatus == 'paid' && $paymentVoucherId)
                                            <p style="margin: 5px 0;"><strong>Payment Voucher ID:</strong> {{ $paymentVoucherId }}</p>
                                        @endif
                                        <p style="margin: 5px 0;"><strong>Payment Date:</strong> 
                                            @if($paymentDate)
                                                {{ $paymentDate }}
                                            @else
                                                {{ $staffInfo['payment_date'] ?? date('d-m-Y') }}
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Staff Information Section -->
                            <div class="section-title">Employee Information</div>
                            <div class="table-responsive">
                                <table class="table table-borderless" style="margin-bottom: 20px;">
                                    <tbody>
                                        <tr>
                                            <td style="width: 20%;"><strong>Employee Name:</strong></td>
                                            <td style="width: 30%;">{{ $staffInfo['staff_fullname'] ?? '' }}</td>
                                            <td style="width: 20%;"><strong>Date Of Joining:</strong></td>
                                            <td style="width: 30%;">{{ $staffInfo['staff_date_of_joining'] ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Designation:</strong></td>
                                            <td>{{ $staffInfo['staff_designation'] ?? '' }}</td>
                                            <td><strong>CNIC:</strong></td>
                                            <td>{{ $staffInfo['staff_cnic'] ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Department:</strong></td>
                                            <td>{{ $staffInfo['staff_department'] ?? '' }}</td>
                                            <td><strong>Account Number:</strong></td>
                                            <td>{{ $staffInfo['staff_bank_account'] ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Salary Month:</strong></td>
                                            <td>{{ $lastMonthYear['MonthName'] ?? '' }}, {{ $lastMonthYear['Year'] ?? '' }}</td>
                                            <td><strong>Account Title:</strong></td>
                                            <td>{{ $staffInfo['staff_bank_account_title'] ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Staff System ID:</strong></td>
                                            <td>{{ $staffInfo['id_staff'] ?? '' }}</td>
                                            <td><strong>Bank:</strong></td>
                                            <td>{{ $staffInfo['staff_bank'] ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Employee Code:</strong></td>
                                            <td>{{ $staffInfo['staff_eid'] ?? '' }}</td>
                                            <td><strong>Pay Day:</strong></td>
                                            <td>
                                                @if($paymentDate)
                                                    {{ $paymentDate }}
                                                @else
                                                    Not Paid Yet
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Payment Status:</strong></td>
                                            <td>
                                                <span class="payment-status payment-{{ $paymentStatus }}">
                                                    @if($paymentStatus == 'paid')
                                                        PAID
                                                    @else
                                                        NOT PAID YET
                                                    @endif
                                                </span>
                                            </td>
                                            <td><strong>Account Head:</strong></td>
                                            <td>
                                                @if($paymentStatus == 'paid')
                                                    Salaries and Wages Payable
                                                @else
                                                    Salaries and Wages Expense
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Salary Details Section -->
                            <div class="section-title">Salary Details</div>
                            <div class="row side-by-side-container">
                                <!-- Payables Column -->
                                <div class="col-md-6 earnings-column">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Payables</th>
                                                <th class="text-right">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php 
                                                $earningsList = [];
                                                $totalPayables = 0;
                                            @endphp
                                            @foreach($combinedData as $row)
                                                @if(($row['debit_amount'] ?? 0) > 0 && 
                                                    ($row['entity_name'] ?? '') !== 'salary_payable' && 
                                                    ($row['entity_name'] ?? '') !== 'provident_fund_payable' &&
                                                    !in_array($row['entity_name'] ?? '', ['rounded_adjustment']))
                                                    @php 
                                                        $earningsList[] = $row;
                                                        $totalPayables += $row['debit_amount'];
                                                    @endphp
                                                @endif
                                            @endforeach
                                            
                                            @foreach($earningsList as $earning)
                                                <tr>
                                                    <td>{{ $earning['account_head'] ?? '' }}</td>
                                                    <td class="text-right">{{ number_format($earning['debit_amount'], 2) }}</td>
                                                </tr>
                                            @endforeach
                                            
                                            <!-- Add rounding adjustments -->
                                            @foreach($combinedData as $row)
                                                @if(($row['entity_name'] ?? '') === 'rounded_adjustment' && ($row['debit_amount'] ?? 0) > 0)
                                                    @php $totalPayables += $row['debit_amount']; @endphp
                                                    <tr>
                                                        <td>{{ $row['account_head'] ?? 'Rounding Adjustment' }}</td>
                                                        <td class="text-right">{{ number_format($row['debit_amount'], 2) }}</td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th>Total Payables</th>
                                                <th class="text-right">{{ number_format($totalPayables, 2) }}</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                                <!-- Deductions Column -->
                                <div class="col-md-6 deductions-column">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Deductions</th>
                                                <th class="text-right">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php 
                                                $deductionsList = [];
                                                $totalDeductions = 0;
                                            @endphp
                                            @foreach($combinedData as $row)
                                                @if(($row['credit_amount'] ?? 0) > 0 && 
                                                    ($row['entity_name'] ?? '') !== 'salary_payable' && 
                                                    ($row['entity_name'] ?? '') !== 'provident_fund_payable')
                                                    @php 
                                                        $deductionsList[] = $row;
                                                        $totalDeductions += $row['credit_amount'];
                                                    @endphp
                                                @endif
                                            @endforeach
                                            
                                            @foreach($deductionsList as $deduction)
                                                <tr>
                                                    <td>{{ $deduction['account_head'] ?? '' }}</td>
                                                    <td class="text-right">{{ number_format($deduction['credit_amount'], 2) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th>Total Deductions</th>
                                                <th class="text-right">{{ number_format($totalDeductions, 2) }}</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                            
                            <!-- Net Salary Section -->
                            <div class="section-title">Net Salary Summary</div>
                            <div class="table-responsive">
                                <table class="table net-salary-table">
                                    <tbody>
                                        <tr>
                                            <td style="width: 60%;"><strong>Total Payables</strong></td>
                                            <td class="text-right">{{ number_format($totalPayables, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Deductions</strong></td>
                                            <td class="text-right">{{ number_format($totalDeductions, 2) }}</td>
                                        </tr>
                                        <tr style="border-top: 2px solid #000;">
                                            <td><strong>Net Salary Payable</strong></td>
                                            <td class="text-right"><strong>{{ number_format($netPayable, 2) }}</strong></td>
                                        </tr>
                                        
                                        @if($paymentStatus == 'paid' && $paidAmount > 0)
                                            <tr>
                                                <td>
                                                    <strong>Salary Paid 
                                                    @if($paymentDate)
                                                        on {{ $paymentDate }}
                                                    @endif
                                                    </strong>
                                                </td>
                                                <td class="text-right"><strong>{{ number_format($paidAmount, 2) }}</strong></td>
                                            </tr>
                                            <tr style="border-top: 2px solid #000;">
                                                <td><strong>Remaining Payable:</strong></td>
                                                <td class="text-right"><strong>{{ number_format($remainingPayable, 2) }}</strong></td>
                                            </tr>
                                        @else
                                            <tr>
                                                <td><strong>Salary Payable (Not Paid Yet)</strong></td>
                                                <td class="text-right"><strong>{{ number_format($netPayable, 2) }}</strong></td>
                                            </tr>
                                            <tr style="border-top: 2px solid #000;">
                                                <td><strong>Remaining Payable:</strong></td>
                                                <td class="text-right"><strong>{{ number_format($netPayable, 2) }}</strong></td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Payment Details Section (if paid) -->
                            <!-- @if($paymentStatus == 'paid' && $paidAmount > 0)
                                <div class="section-title">Payment Details</div>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Payment Date</th>
                                                <th>Payment Mode</th>
                                                <th>Voucher ID</th>
                                                <th class="text-right">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>{{ $paymentDate }}</td>
                                                <td>{{ $paymentMode ?? 'Bank Transfer' }}</td>
                                                <td>{{ $paymentVoucherId }}</td>
                                                <td class="text-right">{{ number_format($paidAmount, 2) }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            @endif -->
                            
                            <!-- Signature Area -->
                            <div class="signature-area">
                                <div class="row signature-row">
                                    <div class="col-md-4 col-sm-4 col-xs-4">
                                        <div class="signature-box">
                                            <div class="signature-line"></div>
                                            <p style="margin-top: 10px;">Prepared By</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4 col-xs-4">
                                        <div class="signature-box">
                                            <div class="signature-line"></div>
                                            <p style="margin-top: 10px;">Approved By</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-4 col-xs-4">
                                        <div class="signature-box">
                                            <div class="signature-line"></div>
                                            <p style="margin-top: 10px;">Received By</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Print Button -->
                        <div class="hidden-print" style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee;">
                            <div class="pull-right">
                                <a href="javascript:void(0);" onclick="printDiv('print_area_0')" class="btn btn-secondary">
                                    <i class="fa fa-print"></i> Print Slip
                                </a>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    @elseif(request()->isMethod('post') || request()->has('staff_id'))
        <div class="row" id="slipResults">
            <div class="col-sm-12">
                <div class="no-data-message">
                    <h4><i class="fa fa-search" style="margin-right: 10px;"></i>No Payment Data Found</h4>
                    <p>Please check the staff, month, and year selection and try again.</p>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

@section('scripts')
@vite(['resources/js/app.js'])
<script>
    $(document).ready(function() {
        $('.select2').select2({
            width: '100%',
            theme: 'bootstrap'
        });
        updateMonthName();
        $('#businessSelector').on('change', function() {
            const businessId = $(this).val();
            if (!businessId) return;
            
            updateStaffDropdown(businessId);
        });
        $('#selected_month').trigger('change');
    });

    function updateMonthName() {
        const selectedOption = $('#selected_month option:selected');
        const monthName = selectedOption.data('monthname') || selectedOption.text();
        $('#month').val(monthName);
    }

    function updateStaffDropdown(businessId) {
        $.ajax({
            type: 'GET',
            url: "{{ route('hrm.get_staff_by_business') }}",
            data: {
                business_id: businessId
            },
            dataType: "json",
            success: function(response) {
                if (response.success && response.staff) {
                    const staffSelect = $('#selected_staff');
                    staffSelect.empty();
                    staffSelect.append('<option value="">Select Staff</option>');
                    
                    response.staff.forEach(function(staff) {
                        staffSelect.append(
                            `<option value="${staff.id_staff}">${staff.staff_fullname}</option>`
                        );
                    });
                    
                    staffSelect.select2({
                        width: '100%',
                        theme: 'bootstrap'
                    });
                }
            },
            error: function(xhr) {
                console.error("Error loading staff:", xhr.responseText);
                showNotification('Error loading staff data', 'error');
            }
        });
    }

    document.addEventListener('keydown', function (e) {
        if ((e.ctrlKey || e.metaKey) && e.key === 'p') {
            e.preventDefault();
            const firstPrintArea = document.querySelector('[id^="print_area_"]');
            if (firstPrintArea) {
                printDiv(firstPrintArea.id);
            }
        }
    });

    function printDiv(divId) {
    if (divId === 'print_all_slips') {
        printAllSlips();
        return;
    }
    
    const element = document.getElementById(divId);
    if (!element) {
        console.error('Element not found:', divId);
        return;
    }
    
    const printContents = element.innerHTML;
    const printWindow = window.open('', '_blank');
    
    const printHtml = `
        <!DOCTYPE html>
        <html>
        <head>
            <title>Payment Slip - Print</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    margin: 10mm;
                    color: #000;
                    font-size: 10pt;
                    background: white;
                }
                
                /* Force single page */
                html, body {
                    height: 100%;
                    overflow: hidden;
                }
                
                .print-view {
                    max-height: 270mm; /* A4 height minus margins */
                    overflow: hidden;
                }
                
                /* Employee Information Section - Add light thin border */
                .employee-info-section {
                    border: 1px solid #d1d5db !important;
                    border-radius: 4px !important;
                    padding: 15px !important;
                    margin-bottom: 20px !important;
                    page-break-inside: avoid !important;
                    background: #f9fafb !important;
                }
                
                /* Salary Details border - light thin border */
                .salary-details-section {
                    border: 1px solid #d1d5db !important;
                    border-radius: 4px !important;
                    padding: 15px !important;
                    margin-bottom: 20px !important;
                    page-break-inside: avoid !important;
                }
                
                /* Payment status styling for print */
                .payment-status {
                    padding: 2px 6px !important;
                    border-radius: 3px !important;
                    font-weight: bold !important;
                    display: inline-block !important;
                }
                
                .payment-paid {
                    background-color: #d4edda !important;
                    color: #155724 !important;
                }
                
                .payment-unpaid {
                    background-color: #f8d7da !important;
                    color: #721c24 !important;
                }
                
                /* Side by side layout for earnings and deductions */
                .side-by-side-container {
                    display: flex !important;
                    flex-wrap: nowrap !important;
                    gap: 10px !important;
                    width: 100% !important;
                    margin-bottom: 15px !important;
                    page-break-inside: avoid !important;
                }
                
                .earnings-section, .deductions-section {
                    width: 48% !important;
                    flex: 1 !important;
                    page-break-inside: avoid !important;
                }
                
                /* Ensure tables don't overflow */
                .table {
                    width: 100% !important;
                    border-collapse: collapse !important;
                    margin-bottom: 10px !important;
                    font-size: 9pt !important;
                    table-layout: fixed !important;
                }
                
                .table, .table th, .table td {
                    border: 1px solid #ebeef2 !important;
                }
                
                .table tbody tr {
                    border-bottom: 1px solid #ebeef2 !important;
                }

                .table thead th {
                    border-bottom: 2px solid #ebeef2 !important;
                    background: #f8f9fa !important;
                }

                .table tfoot th,
                .table tfoot td {
                    border-top: 2px solid #ebeef2 !important;
                    background: #f8f9fa !important;
                }
                
                /* Reduce border weight for last 2 rows (payable and deductions) */
                .net-salary-table tbody tr:last-child,
                .net-salary-table tbody tr:nth-last-child(2) {
                    border-bottom: 0.5px solid #9ca3af !important;
                }
                
                .net-salary-table tbody tr:last-child td,
                .net-salary-table tbody tr:nth-last-child(2) td {
                    border-bottom: 0.5px solid #9ca3af !important;
                }
                
                .net-salary-table tbody tr:last-child th,
                .net-salary-table tbody tr:nth-last-child(2) th {
                    border-bottom: 0.5px solid #9ca3af !important;
                }
                
                .table th, .table td {
                    padding: 4px !important;
                    text-align: left !important;
                    word-wrap: break-word !important;
                    overflow-wrap: break-word !important;
                }
                
                .text-right {
                    text-align: right !important;
                }
                
                .text-center {
                    text-align: center !important;
                }
                
                .signature-area {
                    margin-top: 20px !important;
                    padding-top: 10px !important;
                    width: 100% !important;
                    page-break-inside: avoid !important;
                    position: relative !important;
                }
                
                .signature-row {
                    display: flex !important;
                    justify-content: space-between !important;
                    align-items: flex-start !important;
                    width: 100% !important;
                    margin: 0 !important;
                    padding: 0 !important;
                }
                
                .signature-box {
                    flex: 1 !important;
                    text-align: center !important;
                    padding: 0 10px !important;
                }
                
                .signature-line {
                    width: 150px !important;
                    border-top: 1px solid #000 !important;
                    margin: 0 auto 5px auto !important;
                    height: 1px !important;
                    display: block !important;
                }
                
                .signature-label {
                    font-size: 10px !important;
                    color: #333 !important;
                    margin-top: 5px !important;
                    display: block !important;
                    width: 100% !important;
                    text-align: center !important;
                }
                
                /* Ensure equal spacing */
                .signature-box:first-child {
                    padding-left: 0 !important;
                }
                
                .signature-box:last-child {
                    padding-right: 0 !important;
                }
                
                /* Style for borderless table in employee info */
                .table-borderless, .table-borderless th, .table-borderless td {
                    border: none !important;
                }
                
                /* Compact styling */
                .company-info h4 {
                    font-size: 12pt !important;
                    margin: 5px 0 !important;
                }
                
                .company-info p {
                    font-size: 9pt !important;
                    margin: 2px 0 !important;
                }
                
                .section-title {
                    font-size: 10pt !important;
                    margin: 8px 0 4px 0 !important;
                    font-weight: bold !important;
                    color: #374151 !important;
                }
                
                .totals-section {
                    margin-top: 10px !important;
                    page-break-inside: avoid !important;
                }
                
                @page {
                    margin: 10mm;
                    size: A4 portrait;
                }
                
                @media print {
                    body {
                        margin: 0 !important;
                        padding: 10mm !important;
                        font-size: 10pt !important;
                    }
                    
                    /* Force fit to single page */
                    .print-view {
                        max-height: 270mm !important;
                        overflow: hidden !important;
                    }
                    
                    /* Signature fix for print */
                    .signature-area {
                        position: relative !important;
                        bottom: 0 !important;
                        margin-top: 30px !important;
                        padding-top: 20px !important;
                        display: block !important;
                        visibility: visible !important;
                        opacity: 1 !important;
                    }
                    
                    .signature-row {
                        display: flex !important;
                        justify-content: space-between !important;
                        width: 100% !important;
                        visibility: visible !important;
                        opacity: 1 !important;
                    }
                    
                    .signature-line {
                        border-top: 1px solid #000 !important;
                        visibility: visible !important;
                        opacity: 1 !important;
                    }
                    
                    /* Remove any background colors for printing */
                    * {
                        -webkit-print-color-adjust: exact !important;
                        print-color-adjust: exact !important;
                    }
                    
                    /* Hide non-print elements */
                    .hidden-print {
                        display: none !important;
                    }
                }
            </style>
        </head>
        <body>
            <div class="print-view">
                ${printContents}
            </div>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    // Trigger print after a short delay
                    setTimeout(function() {
                        window.print();
                        
                        // Close window after print (or after timeout)
                        setTimeout(function() {
                            window.close();
                        }, 1000);
                    }, 500);
                });
            <\/script>
        </body>
        </html>
    `;
    
    printWindow.document.write(printHtml);
    printWindow.document.close();
}
    
    function showNotification(message, type = 'info') {
        const toast = $(`
            <div class="toast align-items-center text-white bg-${type === 'error' ? 'danger' : 'success'} border-0" 
                 role="alert" aria-live="assertive" aria-atomic="true" 
                 style="position: fixed; bottom: 20px; right: 20px; z-index: 9999;">
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
            </div>
        `);
        
        $('body').append(toast);
        const bsToast = new bootstrap.Toast(toast[0]);
        bsToast.show();
        
        setTimeout(function() {
            bsToast.hide();
        }, 3000);
    }
</script>
@endsection